#import <Foundation/Foundation.h>//hys
//#import <HYS/PDFKit/PDFPage.h>
#import <APPLE/PDFKit/PDFPage.h>

@class PDFDocument, PDFAnnotation, PDFSelection;


@interface PDFPage : NSObject

/*selectionForRect:

Returns the text enclosed within rect, expressed in page (user) coordinates.

- (PDFSelection *)selectionForRect:(NSRect)rect
Availability
Available in Mac OS X v10.4 and later.
See Also
– selectionForWordAtPoint:
– selectionForLineAtPoint:
– selectionFromPoint:toPoint:
– selectionForRange:*/
- (PDFSelection *)selectionForRect:(NSRect)rect;

/*rotation

Returns the page rotation angle in degrees.

- (int)rotation
Discussion

The rotation is a positive multiple of 90: 0, 90, 180, or 270. The rotation of pages with negative rotation is converted to a corresponding positive rotation.

If you are subclassing PDFView and displaying pages yourself, don’t assume a rotation of 0. Pages with an inherent rotation display rotated when opened unless you set their rotation to zero. Regardless of the inherent rotation angle, it is up to the author of a page whether zero rotation corresponds to upright text when displayed on a monitor.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setRotation:*/
- (int)rotation;

/*boundsForBox:

The bounds for the specified PDF display box.

- (NSRect)boundsForBox:(PDFDisplayBox)box
Discussion

The PDFDisplayBox enumeration defines the various box types.

See the “Constants” for additional information about box types.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSRect)boundsForBox:(PDFDisplayBox)box;

/*annotations

Gets an array containing the page’s annotations.

- (NSArray *)annotations
Discussion

The elements of the array will most likely be typed to subclasses of the PDFAnnotation class.
Availability
Available in Mac OS X v10.4 and later.
See Also
– displaysAnnotations
– setDisplaysAnnotations:
– addAnnotation:
– removeAnnotation:
– annotationAtPoint*/
- (NSArray *)annotations;

@end


