#ifndef ATSUNICODEDRAWING_H
#define ATSUNICODEDRAWING_H

#ifndef ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif

//#include <HYS/QD/ATSUnicodeDrawing.h>
#include <APPLE/QD/ATSUnicodeDrawing.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSUGetGlyphBounds

Obtains the typographic bounds of a line of glyphs after final layout. 

OSStatus ATSUGetGlyphBounds (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iBoundsCharStart,
   UniCharCount iBoundsCharLength,
   UInt16 iTypeOfBounds,
   ItemCount iMaxNumberOfBounds,
   ATSTrapezoid *oGlyphBounds,
   ItemCount *oActualNumberOfBounds
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iTextBasePointX

An ATSUTextMeasurement value specifying the x-coordinate of the origin of the line containing the glyphs in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to obtain the glyph bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounds relative to one another, not their actual onscreen position. 
iTextBasePointY

An ATSUTextMeasurement value specifying the y-coordinate of the origin of the line containing the glyphs in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to obtain the glyph bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounds relative to one another, not their actual onscreen position. 
iBoundsCharStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the character corresponding to the first glyph to measure. To indicate that the text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. 
iBoundsCharLength

A UniCharCount value specifying the length of the text range to measure. If you want the range to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTypeOfBounds

A glyph bounds constant indicating whether the width of the resulting typographic glyph bounds is determined using the caret origin (midway between two characters), the glyph origin in device space, or the glyph origin in fractional absolute positions (uncorrected for device display). See “Glyph Origin Selectors” for a description of possible values.
iMaxNumberOfBounds

An ItemCount value specifying the maximum number of bounding trapezoids to obtain. Typically, this is equivalent to the number of bounds in the oGlyphBounds array. To determine this value, see the Discussion. 
oGlyphBounds

A pointer to memory you have allocated for an array of ATSTrapezoid values. On return, the array contains a trapezoid representing the typographic bounds for glyphs in the text range. If the specified range of text encloses nested bidirectional text, ATSUGetGlyphBounds produces multiple trapezoids defining these regions.In ATSUI 1.1, the maximum number of enclosing trapezoids that can be returned is 31; in ATSUI 1.2, the maximum number is 127. If you pass a range that covers an entire line, ATSUGetGlyphBounds returns 1 trapezoid. If you are uncertain of how much memory to allocate for this array, see the Discussion. 
oActualNumberOfBounds

A pointer to an ItemCount value. On return, the value specifies the actual number of enclosing trapezoids bounding the specified characters. This may be greater than the value you provide in the iMaxNumberOfBounds parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

There are two kinds of bounds that your application may typically want to obtain for a block of text: typographic bounds and image bounds. The image bounds define the smallest rectangle that completely encloses the filled or framed parts of a block of text—that is, the text’s “inked” glyphs. Because of the potential differences in glyph height in a text block, your application may instead need to determine the typographic bounds. The typographic bounding rectangle contains the extra space above and below the image bounding rectangle where characters with ascenders or descenders would be drawn (even if none currently are).

The ATSUGetGlyphBounds function produces the enclosing trapezoid(s) that represent the typographic bounds for glyphs in a final, laid-out range of text. You typically call this function when you need to obtain an enclosing trapezoid for a line, taking rotation and all other layout attributes into account.

ATSUI determines the height of each trapezoid by examining any line ascent and descent attribute values you may have set for the line. If you have not set these attributes for the line, the ATSUGetGlyphBounds function uses any line ascent and descent values you may have set for the text layout object containing the line. If these are not set, ATSUGetGlyphBounds uses the font’s natural line ascent and descent values for the line. If these are previously set, ATSUGetGlyphBounds uses the ATSUStyle ascent and or descent/leading values.

Depending on the value you pass in the iTypeOfBounds parameter, the width of the resulting trapezoid(s) is determined using one of the following values:
the caret origin, located halfway between two characters, which should be used when performing your own highlighting
the glyph origin in device space, which is useful for obtaining bounds adjusted for specific rendering and device constraints
the glyph origin in fractional (or “ideal”) absolute positions, uncorrected for device display

Note that the coordinates produced for the trapezoid(s) are offset by the amount specified in the iTextBasePointX and iTextBasePointY parameters. If your goal in calling the ATSUGetGlyphBounds function is to obtain metrics for drawing the typographic bounds on the screen, pass the position of the origin of the line in the current graphics port or graphics context in these parameters. This enables ATSUGetGlyphBounds to match the trapezoids to their onscreen image. 

Before calculating the typographic glyph bounds for the given text range, the ATSUGetGlyphBounds function examines the text layout object to make sure that the style runs cover the entire range of text. If there are gaps between style runs, ATSUGetGlyphBounds assigns the characters in the gap to the style run following the gap. If there is no style run at the beginning of the range of text, ATSUGetGlyphBounds assigns these characters to the first style run it can find. If there is no style run at the end of the range of text, ATSUGetGlyphBounds assigns the remaining characters to the last style run it can find.

Typically you use the ATSUGetGlyphBounds function by calling it twice, as follows:
Pass NULL for the oGlyphBounds parameter, 0 for the iMaxNumberOfBounds parameter, and valid values for the other parameters. The ATSUGetGlyphBounds function returns the actual number of trapezoids needed to enclose the glyphs in the oActualNumberOfBounds parameter.
Allocate enough space for a buffer of the returned size, then call the function again, passing a valid pointer to the buffer in the oGlyphBounds parameter. On return, the buffer contains the trapezoids for the glyphs’ typographic bounds. 

To obtain the typographic bounds of a line of text prior to line layout, call the function ATSUGetUnjustifiedBounds. To calculate the image bounding rectangle for a final laid-out line, call the function ATSUMeasureTextImage. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/

OSStatus ATSUGetGlyphBounds (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iBoundsCharStart,
   UniCharCount iBoundsCharLength,
   UInt16 iTypeOfBounds,
   ItemCount iMaxNumberOfBounds,
   ATSTrapezoid *oGlyphBounds,
   ItemCount *oActualNumberOfBounds
);


/*ATSUDrawText

Renders a range of text at a specified location in a QuickDraw graphics port or Quartz graphics context.

OSStatus ATSUDrawText (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object for which to render text. 
iLineOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to render. The function ATSUDrawText renders text to the first soft line break it encounters. If the range of text spans multiple lines, you should call ATSUDrawText for each line, passing the offset corresponding to the beginning of the new line to draw with each call. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the text range to render. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd. Keep in mind that the function ATSUDrawText renders text one line at a time. If the range of text spans multiple lines, you must call ATSUDrawText for each line.
iLocationX

An ATSUTextMeasurement value specifying the x-coordinate of the origin (in either the current QuickDraw graphics port or in a Quartz graphics context) of the line containing the text range to render. Note that the ATSUTextMeasurement type is defined as a Fixed value, so you must ensure that your coordinates are converted to Fixed values before passing them to this function. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
iLocationY

An ATSUTextMeasurement value specifying the y-coordinate of the origin (in either the current graphics port or Quartz graphics context) of the line containing the text range to render. Note that the ATSUTextMeasurement type is defined as a Fixed value, so you must ensure that your coordinates are converted to Fixed values before passing them to this function. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDrawText function renders a range of text at a specified location in a QuickDraw graphics port or Quartz graphics context. This function renders text to the first soft line break it encounters. If you draw into a QuickDraw graphics port you get the best performance by using a bit depth of 16 bits. If you use bit depths of 1, 4, or 8, your application incurs a performance penalty.

You typically call the ATSUDrawText function every time you need to draw or redraw unhighlighted text. To draw highlighted text, call the function ATSUHighlightText.

ATSUDrawText uses the transfer mode and resolution that are set in the graphics port or graphics context. If you explicitly set in the style object, then text color is taken from the style object, and the value in the graphics port/context is ignored. If the text color was not explicitly set in the style object, ATSUDrawText uses the graphics port/context setting.

ATSUDrawText examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUI assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, ATSUI assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUI assigns the remaining characters to the last style run it finds.

If you want to draw a range of text that spans multiple lines, you should call ATSUDrawText for each line of text to draw, even if all the lines are in the same text layout object. You should adjust the iLineOffset parameter to reflect the beginning of each line to be drawn.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/

OSStatus ATSUDrawText (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY
);

/*ATSUMeasureTextImage

Obtains the image bounding rectangle for a line of text after final layout.

OSStatus ATSUMeasureTextImage (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY,
   Rect *oTextImageRect
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iLineOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the line to examine. To indicate that the specified line starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the text range. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd. However, the image bounds is restricted to the line in which iLineOffset resides.
iLocationX

An ATSUTextMeasurement value specifying the x-coordinate of the line’s origin in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, for the dimensions of the bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounding rectangle relative to one another, not their actual onscreen position. 
iLocationY

An ATSUTextMeasurement value specifying the y-coordinate of the line’s origin in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, for the dimensions of the bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounding rectangle relative to one another, not their actual onscreen position. 
oTextImageRect

A pointer to a Rect structure. On return, the structure contains the dimensions of the image bounding rectangle for the text, offset by the values specified in the iLocationX and iLocationY parameters. If the line is rotated, the sides of the rectangle are parallel to the coordinate axis.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUMeasureTextImage function obtains the image bounds of a laid-out line of text. These bounds are described by the smallest rectangle that completely encloses the filled or framed parts of a block of text—that is, the text’s “inked” glyphs.

In measuring the line, the ATSUMeasureTextImage function takes into account line rotation, alignment, and justification, as well as other characteristics that affect layout, such as hanging punctuation. (If the line is rotated, the sides of the rectangle are parallel to the coordinate axes and encompass the rotated line.) If no attributes are set for the line, ATSUMeasureTextImage uses the global attributes set for the text layout object.

Because the height of the image bounding rectangle is determined by the actual device metrics, ATSUMeasureTextImage ignores any previously set line ascent and descent values for the line it is measuring.

Before calculating the image bounds for the text range, the ATSUMeasureTextImage function examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUMeasureTextImage assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, the ATSUMeasureTextImage function assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUMeasureTextImage assigns the remaining characters to the last style run it finds.

To obtain the final typographic bounds of a line, call the function ATSUGetGlyphBounds. To calculate the unjustified typographic bounds of a line, call the function ATSUGetUnjustifiedBounds.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUMeasureTextImage (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY,
   Rect *oTextImageRect
);



#ifdef __cplusplus
}
#endif

#endif