#ifndef ATSUNICODEFONTS_H
#define ATSUNICODEFONTS_H

#ifndef ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSUFontVariationAxis

Represents a stylistic attribute and the range of values that the font can use to express this attribute.

typedef FourCharCode ATSUFontVariationAxis;
Discussion

Font variations allow your application to produce a range of type styles algorithmically. You can obtain a a variation axis and its maximum, minimum, and default values for a font by calling the function ATSUGetIndFontVariation. For a complete discussion of font variations, see Inside Mac OS X: Rendering Unicode Text With ATSUI.
Availability
Available in Mac OS X v10.0 and later.*/
typedef FourCharCode ATSUFontVariationAxis;

/*ATSUFontVariationValue

Represents the range of values that the font can use for a particular font variation.

typedef Fixed ATSUFontVariationValue;
Discussion

You pass the ATSUFontVariationValue type to functions that set and clear font variations in a style run. The ATSUFontVariationValue type is passed back by functions that query a style run for font variations. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef Fixed ATSUFontVariationValue;

/*ATSUFontFeatureSelector

Represents the state (on or off) of a particular feature type.

typedef UInt16 ATSUFontFeatureSelector;
Discussion

You pass the ATSUFontFeatureSelector type to functions that set or clear font feature selectors in a style run. The ATSUFontFeatureSelector type is passed back by functions that obtain font feature selectors in a style run. For a complete discussion of font feature selectors, see Inside Mac OS X: Rendering Unicode Text With ATSUI.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 ATSUFontFeatureSelector;

/*ATSUFontFeatureType

Represents the attributes of a particular font feature.

typedef UInt16 ATSUFontFeatureType;
Discussion

Font features are typographic and layout capabilities that you can select or deselect and which control many aspects of glyph selection, ordering, and positioning. Font features include fundamental controls such as whether your text is drawn with contextual forms, as well as details of appearance such as whether you want alternate forms of glyphs to be used at the beginning of a word. To a large extent, how text looks when it is laid out is a function of the number and kinds of font features you choose.

Font vendors create tables that implement the specific set of features which are included in a font by the font designer. Note that only a few feature types and selectors may be available with a given font. If you select features that are not available in a font, you won’t see a change in the glyph’s appearance. To determine the available features of a font, you can call the functions ATSUGetFontFeatureTypes and ATSUGetFontFeatureSelectors.

For a complete discussion of font features, the selectors you use to access them, and illustrations of the features, see Inside Mac OS X: Rendering Unicode Text With ATSUI.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 ATSUFontFeatureType;

/*ATSUFONDtoFontID

Finds the ATSUI font ID that corresponds to a font family number, if one exists. (Deprecated. There is no replacement because FONDs are a QuickDraw concept and QuickDraw is deprecated.)

Not recommended.

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);
Parameters
iFONDNumber

The font family number of the ATSUI-compatible font for which to obtain an ATSUI font ID.
iFONDStyle

The font family style of the font, if any. Style identifiers exist only for fonts that split a font family into subgroups.
oFontID

A pointer to a ATSUFontID value. On return, the value provides a unique identifier for the specified font family number and style. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The function ATSUFONDtoFontID is not recommended for use. Instead, use the Font Manager functions that translate font family numbers to FMFont values, which are equivalent to ATSUFontID values. Font family numbers were used by QuickDraw to represent fonts to the Font Manager. Some of these fonts, even if compatible with ATSUI, may not have font IDs.

Note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change when the system is restarted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);

/*ATSUFindFontFromName

Obtains an ATSUI font ID for the first entry in a name table that matches the specified name string, name code, platform, script, and/or language. 

OSStatus ATSUFindFontFromName (
   const void *iName,
   ByteCount iNameLength,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ATSUFontID *oFontID
);
Parameters
iName

A string that specifies the font name whose ATSUI font ID you want to obtain. The string that you pass must be appropriate for the value you pass in the iFontNameCode parameter. For example, if the iFontNameCode parameter is kFontPostscriptName, then you would supply a string that specifies the PostScript name of the font.
iNameLength

A ByteCount value specifying the length of the font name string provided in the iName parameter.
iFontNameCode

The FontNameCode value of the font name for which to obtain an ATSUI font ID. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file. You can supply any of the following constants, kFontCopyrightName, kFontFamilyName, kFontStyleName, kFontUniqueName, kFontFullName, kFontVersionName, kFontPostscriptName, kFontTrademarkName, kFontManufacturerName, kFontDesignerName, kFontDescriptionName, kFontVendorURLName, kFontDesignerURLName, kFontLicenseDescriptionName,or kFontLicenseInfoURLName.
iFontNamePlatform

A FontPlatformCode value specifying the encoding of the font name, for example, kFontUnicodePlatform (for UTF-16), kFontMacintoshPlatform, kFontReservedPlatform, kFontMicrosoftPlatform, or kFontCustomPlatform. If you pass the kFontNoPlatformCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontPlatformCode type and a list of possible values. 
iFontNameScript

A FontScriptCode value specifying the script code of the font name, for example, kFontRomanScript. Pass kFontNoScriptCode if you supplied the kFontUnicodePlatform constant for the iFontNamePlatform parameter. If you pass the kFontNoScriptCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontScriptCode type and a list of possible values. 
iFontNameLanguage

A FontLanguageCode value specifying the language of the font name, for example, kFontNorwegianLanguage. Pass kFontNoLanguageCode if you supplied the kFontUnicodePlatform constant for the iFontNamePlatform parameter. If you pass the kFontNoLanguageCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontLanguageCode type and a list of possible values.
oFontID

On return, points to the unique identifier for the specified font that matches the specified name string, name code, platform, script, and/or language. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
Return Value

A result code. If no installed font matches the specified parameters, ATSUFindFontFromName produces the constant kATSUInvalidFontID and returns the result code kATSUInvalidFontErr. See “ATSUI Result Codes”.
Discussion

The ATSUFindFontFromName function obtains an ATSUI font ID for the first font that matches the specified name string, name code, platform, script, and/or language. Because ATSUI cannot guarantee the uniqueness of names among installed fonts, ATSUFindFontFromName does not necessarily find the only font ID that matches these parameters. As a result, you may want to create a more sophisticated name-matching algorithm or guarantee the uniqueness of names among installed fonts.

To find a name string and index value for the first font in a name table that matches an ATSUI font ID and the specified font parameters, call the function ATSUFindFontName.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUFindFontFromName (
   const void *iName,
   ByteCount iNameLength,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ATSUFontID *oFontID
);

/*ATSUSetFontFeatures

Sets font features in a style object.

OSStatus ATSUSetFontFeatures (
   ATSUStyle iStyle,
   ItemCount iFeatureCount,
   const ATSUFontFeatureType *iType,
   const ATSUFontFeatureSelector *iSelector
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to set font features. 
iFeatureCount

An ItemCount value specifying the number of font features to set. This value should correspond to the number of elements in the iType and iSelector arrays.
iType

A pointer to the initial ATSUFontFeatureType value in an array of feature types. Each element in the array must contain a valid feature type that corresponds to a feature selector in the iSelector array. To obtain the valid feature types for a font, call the function ATSUGetFontFeatureTypes. 
iSelector

A pointer to the initial ATSUFontFeatureSelector value in an array of feature selectors. Each element in the array must contain a valid feature selector that corresponds to a feature type in the iType array. To obtain the valid feature selectors for a font, call the function ATSUGetFontFeatureSelectors. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUSetFontFeatures function enables you to set multiple font features for a style object. Any unset font features retain their font-defined default values. To set style attributes and font variations for a style object, call the functions ATSUSetAttributes and ATSUSetVariations, respectively.

The constants that represent font feature types are defined in the header file SFNTLayoutTypes.h. When you use ATSUI to access and set font features, you must use the constants defined in this header file, which are described in Inside Mac OS X: Rendering Unicode Text With ATSUI. As feature types can be added at any time, you should check Apple’s font feature registry website for the most up-to-date list of font feature types and selectors: http://developer.apple.com/fonts/Registry/index.html.
Version Notes

Prior to ATSUI 1.2, ATSUSetFontFeatures does not remove contradictory font features. You are responsible for maintaining your own list and removing contradictory settings when they occur. Beginning with ATSUI 1.2, ATSUSetFontFeatures removes contradictory font features if they are set. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUSetFontFeatures (
   ATSUStyle iStyle,
   ItemCount iFeatureCount,
   const ATSUFontFeatureType *iType,
   const ATSUFontFeatureSelector *iSelector
);

/*ATSUGetFontFeatureSelectors

Obtains the available feature selectors for a given feature type in a font.

OSStatus ATSUGetFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount iMaximumSelectors,
   ATSUFontFeatureSelector *oSelectors,
   Boolean *oSelectorIsOnByDefault,
   ItemCount *oActualSelectorCount,
   Boolean *oIsMutuallyExclusive
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iType

An ATSUFontFeatureType value specifying one of the font’s supported feature types. To obtain the available feature types for a font, call the function ATSUGetFontFeatureTypes. 
iMaximumSelectors

An ItemCount value specifying the maximum number of feature selectors to obtain for the font’s specified feature type. Typically, this is equivalent to the number of elements in the oSelectors array.
oSelectors

A pointer to memory you have allocated for an array of ATSUFontFeatureSelector values. You can call the function ATSUCountFontFeatureSelectors to obtain the number of available feature selectors for a given font feature type and thus determine the amount of memory to allocate. On return, the array contains constants identifying each available feature selector for the given feature type. The constants that represent font feature selectors are defined in the header file SFNTLayoutTypes.h and are described in Inside Mac OS X: Rendering Unicode Text With ATSUI. 
oSelectorIsOnByDefault

A pointer to memory you have allocated for an array of Boolean values. The number of elements in this array should correspond to the number of elements in the oSelectors array. On return, the array contains Boolean values indicating whether the corresponding feature selector in the oSelectors array is on or off. If true, the feature selector is on by default; if false, off. 
oActualSelectorCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature selectors defined for the given feature type. This value may be greater than the value you specify in the iMaximumSelectors parameter. 
oIsMutuallyExclusive

A pointer to a Boolean value. On return, the value indicates whether the feature selectors for the given feature type are exclusive or nonexclusive. If a feature type is exclusive you can choose only one of its available feature selectors at a time, such as whether to display numbers as proportional or fixed-width. If a feature type is nonexclusive, you can enable any number of feature selectors at once. If true, the feature type is exclusive and only one selector can be used at a time.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

A given font may not support all possible feature types and selectors. If you select features that are not available in a font, you won’t see a change in the glyph’s appearance. To determine the available features of a font, you can call the functions ATSUGetFontFeatureTypes and ATSUGetFontFeatureSelectors.

The ATSUGetFontFeatureSelectors function reads the font data table for the specified font and obtains its supported feature selectors for the given feature types. You can then use this information both to present the user a list of font features from which to select and to call such functions as ATSUSetFontFeatures with more accuracy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount iMaximumSelectors,
   ATSUFontFeatureSelector *oSelectors,
   Boolean *oSelectorIsOnByDefault,
   ItemCount *oActualSelectorCount,
   Boolean *oIsMutuallyExclusive
);

/*ATSUCountFontFeatureSelectors

Obtains the number of available feature selectors for a given feature type in a font.

OSStatus ATSUCountFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount *oSelectorCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iType

An ATSUFontFeatureType value specifying one of the font’s supported feature types. To obtain the available feature types for a font, call the function ATSUGetFontFeatureTypes. 
oSelectorCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature selectors defined for the feature type by the font.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCountFontFeatureSelectors function obtains the total number of feature selectors defined for a given feature type in the font. You can use the count produced by ATSUCountFontFeatureSelectors to determine how much memory to allocate for the oSelectors array in the function ATSUGetFontFeatureSelectors.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUCountFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount *oSelectorCount
);

/*ATSUGetFontFeatureTypes

Obtains the available feature types of a font.

OSStatus ATSUGetFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount iMaximumTypes,
   ATSUFontFeatureType *oTypes,
   ItemCount *oActualTypeCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iMaximumTypes

An ItemCount value specifying the maximum number of feature types to obtain for the font. Typically, this is equivalent to the number of elements in the oTypes array.
oTypes

A pointer to memory you have allocated for an array of ATSUFontFeatureType values. You can call the function ATSUCountFontFeatureTypes to obtain the number of available feature types for a given font and thus determine the amount of memory to allocate. On return, the array contains constants identifying each type of feature that is defined for the font. The constants that represent font feature types are defined in the header file SFNTLayoutTypes.h and are described in Inside Mac OS X: Rendering Unicode Text With ATSUI. 
oActualTypeCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature types defined in the font. This may be greater than the value you specify in the iMaximumTypes parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

A given font may not support all possible feature types and selectors. If you select features that are not available in a font, you won’t see a change in the glyph’s appearance. To determine the available features of a font, you can call the functions ATSUGetFontFeatureTypes and ATSUGetFontFeatureSelectors.

The ATSUGetFontFeatureTypes function reads the font data table for the specified font and obtains its supported feature types. You can then use this information both to present the user a list of font features from which to select and to call such functions as ATSUSetFontFeatures with more accuracy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount iMaximumTypes,
   ATSUFontFeatureType *oTypes,
   ItemCount *oActualTypeCount
);

/*ATSUCountFontVariations

Obtains the number of defined variation axes in a font.

OSStatus ATSUCountFontVariations (
   ATSUFontID iFont,
   ItemCount *oVariationCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
oVariationCount

A pointer to an ItemCount value. On return, the value specifies the number of variation axes defined for the font.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCountFontVariations function obtains the total number of variation axes defined for a font. You can use the count produced by ATSUCountFontVariations to get information about a specific font variation axis from the function ATSUGetIndFontVariation.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUCountFontVariations (
   ATSUFontID iFont,
   ItemCount *oVariationCount
);

/*ATSUCountFontFeatureTypes

Obtains the number of available feature types in a font.

OSStatus ATSUCountFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount *oTypeCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
oTypeCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature types defined for the font.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCountFontFeatureTypes function obtains the total number of feature types defined for a font. You can use the count produced by ATSUCountFontFeatureTypes to determine how much memory to allocate for the oTypes array in the function ATSUGetFontFeatureTypes. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUCountFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount *oTypeCount
);

/*ATSUSetVariations

Sets font variation axes and values in a style object.

OSStatus ATSUSetVariations (
   ATSUStyle iStyle,
   ItemCount iVariationCount,
   const ATSUFontVariationAxis *iAxes,
   const ATSUFontVariationValue *iValue
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to set font variation values. 
iVariationCount

An ItemCount value specifying the number of font variation values to set. This value should correspond to the number of elements in the iAxes and iValue arrays.
iAxes

A pointer to the initial ATSUFontVariationAxis value in an array of font variation axes. Each element in the array must represent a valid variation axis tag that corresponds to a variation value in the iValue array. To obtain a valid variation axis tag for a font, you can call the functions ATSUGetIndFontVariation or ATSUGetFontInstance. 
iValue

A pointer to the initial ATSUFontVariationValue value in an array of font variation values. Each element in the array must contain a value that is valid for the corresponding variation axis in the iAxes parameter. You can obtain a font’s maximum, minimum, and default values for a given variation axis by calling the function ATSUGetIndFontVariation. You can obtain the font variation axis values for a font instance by calling ATSUGetFontInstance. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

If you supply font variation axes and values to the ATSUSetVariations function, you can change the appearance of a style object’s font accordingly. You may specify any number of variation axes and values in a style object. Any of the font’s variations that you do not set retain their font-defined default values.

You can also use the ATSUSetVariations function to supply your own value within any variation axes defined for the font. However, if the font does not support the variation axis you specify, your custom variation has no visual effect.

By calling the function ATSUGetIndFontVariation, you can obtain a variation axis and its maximum, minimum, and default values for a font.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUSetVariations (
   ATSUStyle iStyle,
   ItemCount iVariationCount,
   const ATSUFontVariationAxis *iAxes,
   const ATSUFontVariationValue *iValue
);

/*ATSUGetIndFontVariation

Obtains a variation axis and its value range for a font.

OSStatus ATSUGetIndFontVariation (
   ATSUFontID iFont,
   ItemCount iVariationIndex,
   ATSUFontVariationAxis *oATSUFontVariationAxis,
   ATSUFontVariationValue *oMinimumValue,
   ATSUFontVariationValue *oMaximumValue,
   ATSUFontVariationValue *oDefaultValue
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iVariationIndex

An ItemCount value specifying an index into the array of variation axes for the font. This index identifies the font variation axis to examine. Because this index is zero-based, you must pass a value between 0 and one less than the value produced in the oVariationCount parameter of the function ATSUCountFontVariations.
oATSUFontVariationAxis

A pointer to an ATSUFontVariationAxis value. On return, the value provides a four-character code identifying the font variation axis corresponding to the specified index. 
oMinimumValue

A pointer to an ATSUFontVariationValue value. On return, the value identifies the variation axis minimum. 
oMaximumValue

A pointer to an ATSUFontVariationValue value. On return, the value identifies the variation axis maximum. 
oDefaultValue

A pointer to an ATSUFontVariationValue value. On return, the value identifies the variation axis default. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

By calling the function ATSUGetIndFontVariation, you can obtain a variation axis and its maximum, minimum, and default values for a font.

If you supply font variation axes and values to the function ATSUSetVariations, you can change the appearance of a style object’s font accordingly.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetIndFontVariation (
   ATSUFontID iFont,
   ItemCount iVariationIndex,
   ATSUFontVariationAxis *oATSUFontVariationAxis,
   ATSUFontVariationValue *oMinimumValue,
   ATSUFontVariationValue *oMaximumValue,
   ATSUFontVariationValue *oDefaultValue
);

/*ATSUFontCount

Obtains the number of ATSUI-compatible fonts installed on a user’s system.

OSStatus ATSUFontCount (
   ItemCount *oFontCount
);
Parameters
oFontCount

A pointer to an ItemCount value. On return, the value specifies the current number of ATSUI-compatible fonts installed on the user’s system.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUFontCount function obtains the number of fonts on a user’s system that are compatible with ATSUI. Incompatible fonts include those that cannot be used to represent Unicode, the missing-character glyph font, and fonts whose names begin with a period or a percent sign. You can use the count produced in the oFontCount parameter to determine the amount of memory to allocate for the oFontIDs array in the function ATSUGetFontIDs.

It is important to note that the set of installed ATSUI-compatible fonts may change while your application is running. In Mac OS X, the set of installed fonts may change at any time. Although in Mac OS 9, fonts cannot be removed from the Fonts folder while an application other than the Finder is running, they can be removed from other locations, and it is possible for fonts to be added.

Additionally, just because the number of fonts stays the same between two successive calls to ATSUFontCount, this does not mean that the font lists are the same. It is possible for a font to be added and another removed between two successive calls to ATSUFontCount, leaving the total number unchanged.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUFontCount (
   ItemCount *oFontCount
);

/*ATSUGetFontIDs

Obtains a list of all the ATSUI-compatible fonts installed on the user’s system. 

OSStatus ATSUGetFontIDs (
   ATSUFontID *oFontIDs,
   ItemCount iArraySize,
   ItemCount *oFontCount
);
Parameters
oFontIDs

A pointer to memory you have allocated for an array of ATSUFontID values. On return, the array contains unique identifiers for each of the ATSUI-compatible fonts installed on the user’s system. You should allocate enough memory to contain an array the size of the count produced by the function ATSUFontCount. 
iArraySize

An ItemCount value specifying the maximum number of fonts to obtain. Typically, this is equivalent to the number of ATSUFontID values for which you have allocated memory in the oFontIDs parameter.
oFontCount

A pointer to an ItemCount value. On return, the value specifies the actual number of ATSUI-compatible fonts installed on the user’s system. This may be greater than the value you specified in the iArraySize parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetFontIDs function obtains the IDs of all the fonts on the user’s system except for the last-resort font. It is important to note that the set of installed ATSUI-compatible fonts may change while your application is running. In Mac OS X, the set of installed fonts may change at any time. Although in Mac OS 9, fonts cannot be removed from the Fonts folder while an application other than the Finder is running, they can be removed from other locations, and it is possible for fonts to be added.

To ensure an accurate representation of the set of installed ATSUI-compatible fonts, you should call ATSUGetFontIDs to rebuild your font menu each time your application is brought to the foreground.

Finally, note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change across system restarts.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontIDs (
   ATSUFontID *oFontIDs,
   ItemCount iArraySize,
   ItemCount *oFontCount
);

/*ATSUFindFontName

Obtains a name string and index value for the first font in a name table that matches the specified ATSUI font ID, name code, platform, script, and/or language.

OSStatus ATSUFindFontName (
   ATSUFontID iFontID,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ByteCount iMaximumNameLength,
   Ptr oName,
   ByteCount *oActualNameLength,
   ItemCount *oFontNameIndex
);
Parameters
iFontID

The ATSUFontID value of the font for which to obtain a name string. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
iFontNameCode

The FontNameCode value of the font for which to obtain a name string. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file.
iFontNamePlatform

A FontPlatformCode value specifying the encoding of the font, for example, kFontUnicodePlatform, kFontMacintoshPlatform, kFontReservedPlatform, kFontMicrosoftPlatform, or kFontCustomPlatform. If you pass the kFontNoPlatformCode constant, ATSUFindFontName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontPlatformCode type and a list of possible values.
iFontNameScript

A FontScriptCode value specifying the script code of the font, for example, kFontRomanScript. If you pass the kFontNoScriptCode constant, ATSUFindFontName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontScriptCode type and a list of possible values.
iFontNameLanguage

A FontLanguageCode value specifying the language of the font, for example, kFontNorwegianLanguage. If you pass the kFontNoLanguageCode constant, ATSUFindFontName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontLanguageCode type and a list of possible values.
iMaximumNameLength

A ByteCount value specifying the maximum length of the font name to obtain. Typically, this is equivalent to the size of the buffer that you have allocated in the oName parameter. To determine this length, see the Discussion.
oName

A pointer to a buffer. On return, the buffer contains the name string of the first font in the font name table matching your specified parameters. If the buffer you allocate is not large enough, ATSUFindFontName produces a partial string.
oActualNameLength

A pointer to a ByteCount value. On return, the value specifies the actual length of the complete name string. This may be greater than the value passed in the iMaximumNameLength parameter. You should check this value to ensure that you have allocated sufficient memory and therefore obtained the complete name string for the font.
oFontNameIndex

A pointer to an ItemCount value. On return, the value provides a 0-based index to the font name in the font name table.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUFindFontName function obtains a name string and index value for the first font in a name table that matches the specified ATSUI font ID, name code, platform, script, and/or language.

Typically you use the ATSUFindFontName function by calling it twice, as follows:
Pass NULL for the oName and OFontNameIndex parameters, 0 for the iMaximumNameLength parameter, and valid values for the other parameters. ATSUFindFontName returns the length of the font name string in the oActualNameLength parameter.
Allocate enough space for a buffer of the returned size, then call the function again, passing a valid pointer to the buffer in the oName parameter. On return, the buffer contains the font name string. 

To obtain an ATSUI font ID for the first font in a name table that matches the specified name string, name code, platform, script, and/or language, call the function ATSUFindFontFromName. To obtain the font name string, name code, platform, script, and language for the font that matches an ATSUI font ID and name table index, call the function ATSUGetIndFontName.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicode.h*/
OSStatus ATSUFindFontName (
   ATSUFontID iFontID,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ByteCount iMaximumNameLength,
   Ptr oName,
   ByteCount *oActualNameLength,
   ItemCount *oFontNameIndex
);

#ifdef __cplusplus
}
#endif

#endif