#ifndef VIDEO_H
#define VIDEO_H

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif


//#include <HYS/QD/Video.h>
#include <APPLE/QD/Video.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif


/*Data Structures

Mac OS uses the data structures listed in this section to communicate with graphics drivers. The interface file Video.h contains the latest information about these structures.
struct VPBlock{
    long    vpBaseOffset;   /always 0 for Slot Mgr independent drivers/
    short   vpRowBytes;     /width of each row of video memory/
    Rect    pBounds;        /Bounds Rect for the video display/
    short   vpVersion;      /Pixel Map version number/
    short   vpPackType;
    long    vpPackSize;
    long    vpHRes;         /horizres of the device (pixels per inch)/
    long    vpVRes;         /vertres of the device (pixels per inch)/
    short   vpPixelType;    /defines the pixel type/
    short   vpPixelSize;    /number of bits in pixel/
    short   vpCmpCount;     /number of components in pixel/
    short   vpCmpSize;      /number of bits per component/
    long    vpPlaneBytes;   /offset from one plane to the next/
}; 

In PCI-based graphics drivers, the vpBaseOffset is always 0. The base address of video RAM for the current page, is the BaseAddress value returned by the GetCurrentMode routine. 
struct VDEntryRecord{
    Ptr     csTable;        /pointer to color table entry/
}; 

struct VDGrayRecord{
    Boolean     csMode;     /same as GDDevType value (0=color,1=mono)/
    SInt8       filler;
}; 

struct VDSetEntryRecord{
    ColorSpec   csTable;   /pointer to an array of color specs/
    short       csStart;    /which spec in array to start with, or-1/
    short       csCount;    /number of colors pecentries to set/
}; 

struct VDGammaRecord{
    Ptr         csGTable;   /pointer to gamma table/
}; 

struct VDSwitchInfoRec{
    UInt16      csMode;         /relative bit depth/
    UInt32      csData;         /display mode ID/
    UInt16      csPage;         /page to switch in/
    Ptr         csBaseAddr;     /base address of page (return value)/
    UInt32      csReserved;     /reserved (set to 0)/
}; 

struct VDTimingInfoRec{
    UInt32      csTimingMode;       /timing mode (alaInitGDevice)/
    UInt32      csTimingReserved;   /reserved/
    UInt32      csTimingFormat;     /what format is the timing info/
    UInt32      csTimingData;       /data supplied by driver/
    UInt32      csTimingFlags;      /information/
}; 

struct VDDisplayConnectInfoRec{
    UInt16      csDisplayType;          /type of display connected/
    UInt8       csConnectTaggedType;    /typeoftagging/
    UInt8       csConnectTaggedData;    /taggingdata/
    UInt32      csConnectFlags;         /info about the connection/
    UInt32      csDisplayComponent;     /display component if card has direct /
                                        / connection todisplay (future)/
    UInt32      csConnectReserved;      /reserved/
}; 

struct VDPageInfo{
    short       csMode;
    long        csData;
    short       csPage;
    Ptr         csBaseAddr;
}; 

struct VDResolutionInfoRec {
    DisplayModeID       csPreviousDisplayModeID;    / ID of the previous resolution /
                                                    / in a chain /
    DisplayModeID       csDisplayModeID;            / ID of the next resolution /
    unsigned long       csHorizontalPixels;         / # of pixels in a horizontal /
                                                    / line at the max depth /
    unsigned long       csVerticalLines;            / # of lines in a screen at the /
                                                    / max depth /
    Fixed               csRefreshRate;              / vertical refresh rate, Hz /
    DepthMode           csMaxDepthMode;             / 0x80-based max bit depth /
    unsigned long       csResolutionFlags;          / flag bits /
    unsigned long       csReserved;                 / reserved /
}; 

typedef struct VDResolutionInfoRec VDResolutionInfoRec; 

/ csResolutionFlags bit flags for VDResolutionInfoRec/
enum {
    kResolutionHasMultipleDepthSizes = 0
        / this mode has different csHorizontalPixels, csVerticalLines at /
        / different depths (usually slightly larger at lower depths) /
}; 

struct VDVideoParametersInfoRec{
DisplayModeID  csDisplayModeID;  /ID of the target resolution/
DepthMode      csDepthMode;     /resolution's relative bit depth/
VPBlockPtr     csVPBlockPtr;    /pointer to video parameter block/
UInt32         csPageCount;     /number of pages supported by the
                resolution/
VideoDeviceType csDeviceType;    /direct, fixed,orCLUT/
UInt32         csReserved;       /reserved/
}; 

struct VDFlagRecord{
SInt8csMode;                 /interrupts enabled or disabled/
SInt8filler;                 /reserved/
}; 

struct VDGetGammaListRec{
GammaTableID  csPreviousGammaTableID;  /ID of previous gamma table/
GammaTableID  csGammaTableID;         /ID of gamma table following
                                       csPreviousDisplayModeID/
UInt32        csGammaTableSize;      /size of gamma table in bytes/
char          csGammaTableName[32];  /gamma table name (C string)/
}; 

struct VDRetrieveGammaRec{
GammaTableID  csGammaTableID;    /ID of gamma table to retrieve/
GammaTbl     csGammaTablePtr;   /location to copy desired gamma to/
}; 

struct VDSupportsHardwareCursorRec{
Boolean    csSupportsHardwareCursor;  /true if HW ursor supported/
SInt8      filler;
}; 

struct VDSetHardwareCursorRec{
void   csCursorRef;
}; 

struct VDDrawHardwareCursorRec{
SInt32   csCursorX;
SInt32   csCursorY;
SInt32   csCursorVisible;
}; 

struct VDSyncInfoRec{
UInt8   csMode;
UInt8   csFlags;
}; 

struct VDConvolutionInfoRec{
DisplayModeID csDisplayModeID;/ID of resolution we want info on/
DepthMode     csDepthMode;/Relative bit depth/
UInt32   csPage;
UInt32   csFlags;
UInt32   csReserved;
}; 

struct VDPowerStateRec {
    unsigned long       powerState;
    unsigned long       powerFlags;
    unsigned long       powerReserved1;
    unsigned long       powerReserved2;
}; 

typedef UInt32 DisplayModeID;
typedef UInt32 VideoDeviceType;
typedef UInt32 GammaTableID; 

/  Power Mode constants for VDPowerStateRec.powerState./
    kAVPowerOff,
    kAVPowerStandby,
    kAVPowerSuspend,
    kAVPowerOn
}; 

enum {
/  Power Mode constants for VDPowerStateRec.powerFlags./
    kPowerStateNeedsRefreshBit= 0,
    kPowerStateNeedsRefreshMask= (1L << 0)
}; 

/bit definitions for the get/set sync call/
enum{
kDisableHorizontalSyncBit=0,
kDisableVerticalSyncBit    =1,
kDisableCompositeSyncBit=2,
kEnableSyncOnBlue    =3,
kEnableSyncOnGreen    =4,
kEnableSyncOnRed    =5,
kNoSeparateSyncControlBit=6,
kHorizontalSyncMask    =0x01,
kVerticalSyncMask    =0x02,
kCompositeSyncMask    =0x04,
kDPMSSyncMask    =0x7,
kSyncOnBlueMask        =0x08,
kSyncOnGreenMask    =0x10,
kSyncOnRedMask        =0x20,
kSyncOnMask     =0x38
}; 

/Bit definitions for the get/set convolution call/
enum{
kConvolved=0,
kLiveVideoPassThru=1,
kConvolvedMask    =0x01,
kLiveVideoPassThruMask=0x02
}; 

/csTimingFormat values in VDTimingInfo/
/timing info follows DeclROM format/
enum{
kDeclROMtables='decl'
};
enum{
    timingInvalid             = 0,   / unknown timing; user must confirm/
    timingApple_512x384_60hz  = 130, / 512x384 (60 Hz) Rubik timing/
    timingApple_560x384_60hz  = 135, / 560x384 (60 Hz) Rubik-560 timing/
    timingApple_640x480_67hz  = 140, / 640x480 (67 Hz) HR timing/
    timingApple_640x400_67hz  = 145, / 640x400 (67 Hz) HR-400 timing/
    timingVESA_640x480_60hz   = 150, / 640x480 (60 Hz) VGA timing/
    timingApple_640x870_75hz  = 160, / 640x870 (75 Hz) FPD timing/
    timingApple_640x818_75hz  = 165, / 640x818 (75 Hz) FPD-818 timing/
    timingApple_832x624_75hz  = 170, / 832x624 (75 Hz) GoldFish timing/
    timingVESA_800x600_56hz   = 180, / 800x600 (56 Hz) SVGA timing/
    timingVESA_800x600_60hz   = 182, / 800x600 (60 Hz) SVGA timing/
    timingVESA_800x600_72hz   = 184, / 800x600 (72 Hz) SVGA timing/
    timingVESA_800x600_75hz   = 186, / 800x600 (75 Hz) SVGA timing/
    timingVESA_1024x768_60hz  = 190, / 1024x768 (60 Hz) VESA 1K-60Hz/
    timingVESA_1024x768_70hz  = 200, / 1024x768 (70 Hz) VESA 1K-70Hz/
    timingApple_1024x768_75hz = 210, / 1024x768 (75 Hz) Apple 19" RGB/
    timingApple_1152x870_75hz = 220, / 1152x870 (75 Hz) Apple 21" RGB/
    timingAppleNTSC_ST        = 230, / 512x384 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingAppleNTSC_FF        = 232, / 640x480 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingAppleNTSC_STconv    = 234, / 512x384 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingAppleNTSC_FFconv    = 236, / 640x480 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingApplePAL_ST         = 238, / 640x480 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingApplePAL_FF         = 240, / 768x576 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingApplePAL_STconv     = 242, / 640x480 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingApplePAL_FFconv     = 244, / 768x576 (60 Hz, interlaced,
                                                     nonconvolved)/
    timingVESA_1280x960_75hz   = 250, / 1280x960 (75 Hz)/
    timingVESA_1280x1024_60hz  = 260, / 1280x1024 (60 Hz)/
    timingVESA_1280x1024_75hz  = 262, / 1280x1024 (75 Hz)/
    timingVESA_1600x1200_60hz  = 280, / 1600x1200 (60 Hz) VESA proposed/
    timingVESA_1600x1200_65hz  = 282, / 1600x1200 (65 Hz) VESA proposed/
    timingVESA_1600x1200_70hz  = 284, / 1600x1200 (70 Hz) VESA proposed/
    timingVESA_1600x1200_75hz  = 286, / 1600x1200 (75 Hz) VESA proposed/
    timingVESA_1600x1200_80hz  = 288  / 1600x1200 (80 Hz) VESA proposed 
                                          (pixel clock is 216 Mhz dot clock)/ /csConnectFlags values in VDDisplayConnectInfo/
enum{
kAllModesValid        =0,
kAllModesSafe    =1,
kReportsTagging    =2,
kHasDirectConnection=3,
kIsMonoDev        =4,
kUncertainConnection=5,
kTaggingInfoNonStandard=6,
kReportsDDCConnection=7,
kHasDDCConnection=8
}; 
/csDisplayType values in VDDisplayConnectInfo/
enum{
    kUnknownConnect             =1,
    kPanelConnect               =2,        /for use with fixed-in-place LCD panels /
    kPanelTFTConnect            =2,        /alias fork PanelConnect/
    kFixedModeCRTConnect        =3,        /for use with fixed-mode
                                                (i.e.verylimitedrange)displays /
    kMultiModeCRT1Connect       =4,        /320x200maybe,12"maybe, 13"(default), 
                                                16" certain,19"maybe,21"maybe/
    kMultiModeCRT2Connect       =5,        /320x200maybe,12"maybe,13"certain,
                                                16" (default),19"certain,21"maybe/
    kMultiModeCRT3Connect       =6,        /320x200maybe,12"maybe,13"certain,
                                                16" certain,19"default,21"certain/
    kMultiModeCRT4Connect       =7,        /expansiontolargemultimode
                                                (notyetused)/
    kModelessConnect            =8,        /expansion to modeless model 
                                                (notyetused)/
    kFullPageConnect            =9,        /640x818(to get 8bpp in 512K case) 
                                                and640x870(thesetwoonly)/
    kVGAConnect                 =10,       /640x480VGA default-- 
                                                question everything else/
    kNTSCConnect                =11,       /NTSCST(default),FF,STconv,FFconv/
    kPALConnect                 =12,       /PALST(default),FF,STconv,FFconv/
    kHRConnect                  =13,       /640x400 (to get 8bpp in 256K case) 
                                                and640x480(these two only)/
    kPanelFSTNConnect           =14        /for use with fixed-in-place LCDFSTN
                                                (aka"Super twist ")panels/
}; 
/csTimingFlags values in VDTimingInfoRec/
enum{
    kModeValid              =0,    /says that this mode should NOT be trimmed/
    kModeSafe               =1,    /this mode does not need confirmation/
    kModeDefault            =2,    /default mode for this type connection/
    kModeShowNow            =3,    /this mode should always be shown(even
                                        though it may require a confirm)/
    kModeNotResize          =4,    /shouldnotbeusedtoresizethedisplay, 
                                    e.g.mode selects different connector on card/
    kModeRequiresPan        =5     /has more pixels than are actually displayed/
}; 

typedef unsigned short DepthMode;
enum{
kDepthMode1=128,
kDepthMode2=129,
kDepthMode3=130,
kDepthMode4=131,
kDepthMode5=132,
kDepthMode6=133 

typedef unsigned char RawSenseCode; enum{
kRSCZero=0,
kRSCOne=1,
kRSCTwo=2,
kRSCThree=3,
kRSCFour=4,
kRSCFive =5,
kRSCSix=6,
kRSCSeven=7
}; 

typedef unsigned char Extended SenseCode;
enum{
    kESCZero21Inch                  =0x00,        /21"RGB/
    kESCOnePortraitMono              =0x14,        /portraitMonochrome/
    kESCTwo12Inch                    =0x21,        /12"RGB/
    kESCThree21InchRadius            =0x31,        /21"RGB(Radius)/
    kESCThree21InchMonoRadius=0x34,                /21"monochrome(Radius)/
    kESCThree21InchMono              =0x35,        /21"monochrome/
    kESCFourNTSC                     =0x0A,        /NTSC/
    kESCFivePortrait                 =0x1E,        /PortraitRGB/
    kESCSixMSB1                      =0x03,        /Multiscanband-1(13"thru16")/
    kESCSixMSB2                      =0x0B,        /Multiscanband-2(13"thru19")/
    kESCSixMSB3                      =0x23,        /Multiscanband-3(13"thru21")/
    kESCSixStandard                  =0x2B,        /13"/14"RGBor12"Monochrome/
    kESCSevenPAL                     =0x00,        /PAL/
    kESCSevenNTSC                    =0x14,        /NTSC/
    kESCSevenVGA                     =0x17,        /VGA/
    kESCSeven16Inch                  =0x2D,        /16"RGB(GoldFish)/
    kESCSevenPALAlternate            =0x30,        /PAL(alternate)/
    kESCSeven19Inch                  =0x3A,        /Third-party19"/
    kESCSevenNoDisplay               =0x3F         /Nodisplayconnected/
}; 

enum {
    kDisplayModeIDCurrent = 0x0,                    // reference the current DisplayModeID
    kDisplayModeIDInvalid = 0xffffffff,             // a bogus DisplayModeID in all cases
    kDisplayModeIDFindFirstResolution = 0xfffffffe,                 // used in
                                                                    // GetNextResolution to
                                                                    // reset iterator
    kDisplayModeIDNoMoreResolutions = 0xfffffffd                    // used in
                                                                    // GetNextResolution to
                                                                    // indicate end of list
} 

enum {
    kGammaTableIDFindFirst = 0xfffffffe,                // get the first gamma table ID
    kGammaTableIDNoMoreTables = 0xfffffffd,             // used to indicate end of list
    kGammaTableIDSpecific = 0x0    // return the info for the given table ID
}*/


typedef unsigned short DepthMode;
enum{
kDepthMode1=128,
kDepthMode2=129,
kDepthMode3=130,
kDepthMode4=131,
kDepthMode5=132,
kDepthMode6=133 
};

typedef UInt32 DisplayModeID;

struct VDSwitchInfoRec{
    UInt16      csMode;         //relative bit depth
    UInt32      csData;         //isplay mode ID
    UInt16      csPage;         //page to switch in/
    Ptr         csBaseAddr;     //base address of page (return value)/
    UInt32      csReserved;     //reserved (set to 0)/
};
typedef struct VDSwitchInfoRec VDSwitchInfoRec;
typedef VDSwitchInfoRec *               VDSwitchInfoPtr;

struct VDSetEntryRecord{
    ColorSpec *  csTable;   /*pointer to an array of color specs*/
    short       csStart;    /*which spec in array to start with, or-1*/
    short       csCount;    /*number of colors pecentries to set*/
}; 
typedef  struct  VDSetEntryRecord VDSetEntryRecord;

struct VDResolutionInfoRec {
    DisplayModeID       csPreviousDisplayModeID;    // ID of the previous resolution /
                                                    //in a chain /
    DisplayModeID       csDisplayModeID;            // ID of the next resolution /
    unsigned long       csHorizontalPixels;         // # of pixels in a horizontal /
                                                    // line at the max depth /
    unsigned long       csVerticalLines;           // # of lines in a screen at the /
                                                    // max depth /
    Fixed               csRefreshRate;              // vertical refresh rate, Hz /
    DepthMode           csMaxDepthMode;             // 0x80-based max bit depth /
    unsigned long       csResolutionFlags;          // flag bits /
    unsigned long       csReserved;                 //reserved /
}; 
typedef struct VDResolutionInfoRec  VDResolutionInfoRec;
typedef VDResolutionInfoRec  *            VDResolutionInfoPtr;

struct VDTimingInfoRec{
    UInt32      csTimingMode;       //timing mode (alaInitGDevice)/
    UInt32      csTimingReserved;   //reserved/
    UInt32      csTimingFormat;     //what format is the timing info/
    UInt32      csTimingData;       //data supplied by driver/
    UInt32      csTimingFlags;      //information/
}; 
typedef  struct VDTimingInfoRec  VDTimingInfoRec;
typedef VDTimingInfoRec *  VDTimingInfoPtr;

struct VPBlock{
    long    vpBaseOffset;   //always 0 for Slot Mgr independent drivers/
    short   vpRowBytes;     //width of each row of video memory/
    Rect    vpBounds;        //Bounds Rect for the video display/
    short   vpVersion;      //Pixel Map version number/
    short   vpPackType;
    long    vpPackSize;
    long    vpHRes;         //horizres of the device (pixels per inch)/
    long    vpVRes;         //vertres of the device (pixels per inch)/
    short   vpPixelType;    //defines the pixel type/
    short   vpPixelSize;    //number of bits in pixel/
    short   vpCmpCount;     //number of components in pixel/
    short   vpCmpSize;      //number of bits per component/
    long    vpPlaneBytes;   //offset from one plane to the next/
}; 
typedef struct  VPBlock VPBlock;
typedef VPBlock * VPBlockPtr;

//csTimingFlags values in VDTimingInfoRec/
enum{
    kModeValid              =0,    //says that this mode should NOT be trimmed/
    kModeSafe               =1,    //this mode does not need confirmation/
    kModeDefault            =2,    //default mode for this type connection/
    kModeShowNow            =3,    //this mode should always be shown(even
                                      //  though it may require a confirm)/
    kModeNotResize          =4,    //shouldnotbeusedtoresizethedisplay, 
                                    //e.g.mode selects different connector on card/
    kModeRequiresPan        =5     //has more pixels than are actually displayed/
}; 


#endif