#ifndef MOVIES_H
#define MOVIES_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef COREAUDIO_H
#include <CoreAudio/CoreAudio.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef  QUICKTIMEERRORS_H
#include <QuickTime/QuickTimeErrors.h>
#endif

#include <APPLE/QuickTime/Movies.h>
//#include <HYS/QuickTime/Movies.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Text Wired ActionskActionTextTrackPasteText = 12288,// (C string theText, long startSelection, long
                                        endSelection ) //


Replaces a selection in the text track with theText. kActionTextTrackSetTextBox = 12291,// (short left, short top, short right,
                                    short bottom) //


Changes the textBox of text track to the passed in size. kActionTextTrackSetTextStyle = 12292,// (Handle textStyle) //


Changes text track style - a TextStyle record. kActionTextTrackSetSelection = 12293,// (long startSelection, long endSelection )  //


Sets the text track selection. kActionTextTrackSetBackgroundColor = 12294,// (ModifierTrackGraphicsModeRecord
                                                backgroundColor ) //


Sets the text track background color. kActionTextTrackSetForegroundColor = 12295,// (ModifierTrackGraphicsModeRecord
                                            foregroundColor ) //


Sets the text color. kActionTextTrackSetFace = 12296,// (long fontFace ) //


Sets the text face (style) of all text. kActionTextTrackSetFont = 12297,// (long fontID ) //


Sets the text font of all text. kActionTextTrackSetSize = 12298,// (long fontSize ) //


Sets the text size of all text. kActionTextTrackSetAlignment = 12299,// (short alignment ) //


Sets the text alignment as in:    teJustLeft                  = 0,
    teJustCenter                = 1,
    teJustRight                 = -1,
    teForceLeft                 = -2, // new names for the
                                 Justification (word alignment) styles //
    teFlushDefault              = 0, //flush according to the line
                                 direction //
    teCenter                    = 1, //center justify (word alignment) //
    teFlushRight                = -1,//flush right for all scripts //
kActionTextTrackSetHilite = 12300,// (long startHighlight, long endHighlight,
                                    ModifierTrackGraphicsModeRecord  highlightColor ) //


Highlights from the startHighlight offset to the endHighlight offset. kActionTextTrackSetDropShadow = 12301,// (Point dropShadow, short transparency ) //


Sets the drop shadow parameters. This only works if displayFlags has been set with dfDropShadow. kActionTextTrackSetDisplayFlags = 12302,// (long flags ) //


Sets the text display flags as in:    dfDontDisplay               = 1 << 0,   // Don't display the text//
    dfDontAutoScale             = 1 << 1,   // Don't scale text as track bounds  grows
                                                or shrinks//
    dfClipToTextBox             = 1 << 2,   // Clip update to the textbox//
    dfUseMovieBGColor           = 1 << 3,   // Set text background to movie's
                                                background color//
    dfShrinkTextBoxToFit        = 1 << 4,   // Compute minimum box to fit the  sample//
    dfScrollIn                  = 1 << 5,   // Scroll text in until last of text  is in
                                                view //
    dfScrollOut                 = 1 << 6,   // Scroll text out until last of text  is
                                            gone (if both set, scroll in then  out)//
    dfHorizScroll               = 1 << 7,   // Scroll text horizontally  (otherwise it's
                                                vertical)//
    dfReverseScroll             = 1 << 8,   // vert: scroll down rather than up;  horiz:
                                            scroll backwards (justfication  dependent)//
    dfContinuousScroll          = 1 << 9,   / new samples cause previous samples  to
                                            scroll out //
    dfFlowHoriz                 = 1 << 10,  // horiz scroll text flows in textbox
                                                rather than extend to right //
    dfContinuousKaraoke         = 1 << 11,  // ignore begin offset, hilite  everything
                                                up to the end offset(karaoke)//
    dfDropShadow                = 1 << 12,  // display text with a drop shadow //
    dfAntiAlias                 = 1 << 13,  // attempt to display text anti  aliased//
    dfKeyedText                 = 1 << 14,  // key the text over background//
    dfInverseHilite             = 1 << 15,  // Use inverse hiliting rather than  using
                                                hilite color//
    dfTextColorHilite           = 1 << 16   // changes text color in place of
                                                hiliting. //
kActionTextTrackSetScroll = 12303,// (long delay ) //


Sets the time delay for start of the scroll. This only works when scroll flags are set in displayFlags. kActionTextTrackRelativeScroll = 12304,// (short deltaX, short deltaY ) //


Scrolls the text in the text box by the delta amounts. kActionTextTrackFindText = 12305,// (long flags, Str255 theText,
                                    ModifierTrackGraphicsModeRecord  highlightColor ) //


Finds text in the track. Similar in operation to TextMediaFindNextText since this is what it uses. kActionTextTrackSetHyperTextFace = 12306,// (short index, long fontFace ) //


Sets the text face (style) of the indexed hypertext. kActionTextTrackSetHyperTextColor = 12307,// (short index,
                                    ModifierTrackGraphicsModeRecord  highlightColor ) //


Sets the text color of the indexed hypertext. kActionTextTrackKeyEntry = 12308,// (short character ) //


Replaces the selection with the character. kActionTextTrackSetEditable = 12310,// (short editState) //


Controls the key entry state of the text track:     #define kKeyEntryDisabled       0
    #define kKeyEntryDirect         1
    #define kKeyEntryScript         2


kKeyEntryDisabled is default. 

If kKeyEntryDirect is on, then key events are passed directly to the text track. 

If kKeyEntryScript is on, then scripted mouse and key events are allowed. kActionTextTrackMouseDown = 12309,// no params //


Passes the mouse click to the text track, which allows for selecting text or an insertion point when kKeyEntryScript is turned on.*/

enum {
//Text Wired Actions
kActionTextTrackPasteText = 12288,/* (C string theText, long startSelection, long
                                        endSelection ) */


//Replaces a selection in the text track with theText.
 kActionTextTrackSetTextBox = 12291,/* (short left, short top, short right,
                                    short bottom) */


//Changes the textBox of text track to the passed in size.
 kActionTextTrackSetTextStyle = 12292,/* (Handle textStyle) */


//Changes text track style - a TextStyle record. 
kActionTextTrackSetSelection = 12293,/* (long startSelection, long endSelection )  */


//Sets the text track selection. 
kActionTextTrackSetBackgroundColor = 12294,/* (ModifierTrackGraphicsModeRecord
                                                backgroundColor ) */


//Sets the text track background color. 
kActionTextTrackSetForegroundColor = 12295,/* (ModifierTrackGraphicsModeRecord
                                            foregroundColor ) */


//Sets the text color. 
kActionTextTrackSetFace = 12296,/* (long fontFace ) */


//Sets the text face (style) of all text. 
kActionTextTrackSetFont = 12297,/* (long fontID ) */


//Sets the text font of all text. 
kActionTextTrackSetSize = 12298,/* (long fontSize ) */


//Sets the text size of all text. 
kActionTextTrackSetAlignment = 12299,/* (short alignment ) */


//Sets the text alignment as in:    
//teJustLeft                  = 0,
//    teJustCenter                = 1,
//    teJustRight                 = -1,
//    teForceLeft                 = -2, /* new names for the
 //                                Justification (word alignment) styles */
  //  teFlushDefault              = 0, /*flush according to the line
                          //       direction */
//    teCenter                    = 1, /*center justify (word alignment) */
//    teFlushRight                = -1,/*flush right for all scripts */
kActionTextTrackSetHilite = 12300,/* (long startHighlight, long endHighlight,
                                    ModifierTrackGraphicsModeRecord  highlightColor ) */


//Highlights from the startHighlight offset to the endHighlight offset. 
kActionTextTrackSetDropShadow = 12301,/* (Point dropShadow, short transparency ) */


//Sets the drop shadow parameters. This only works if displayFlags has been set with dfDropShadow.
 kActionTextTrackSetDisplayFlags = 12302,/* (long flags ) */


//Sets the text display flags as in:   
// dfDontDisplay               = 1 << 0,   /* Don't display the text*/
//    dfDontAutoScale             = 1 << 1,   /* Don't scale text as track bounds  grows
    //                                            or shrinks*/
//    dfClipToTextBox             = 1 << 2,   /* Clip update to the textbox*/
//    dfUseMovieBGColor           = 1 << 3,   /* Set text background to movie's
 //                                               background color*/
//    dfShrinkTextBoxToFit        = 1 << 4,   /* Compute minimum box to fit the  sample*/
//    dfScrollIn                  = 1 << 5,   /* Scroll text in until last of text  is in
//                                                view */
//    dfScrollOut                 = 1 << 6,   /* Scroll text out until last of text  is
 //                                           gone (if both set, scroll in then  out)*/
 //   dfHorizScroll               = 1 << 7,   /* Scroll text horizontally  (otherwise it's
  //                                              vertical)*/
  //  dfReverseScroll             = 1 << 8,   /* vert: scroll down rather than up;  horiz:
//                                            scroll backwards (justfication  dependent)*/
//    dfContinuousScroll          = 1 << 9,   /* new samples cause previous samples  to
 //                                           scroll out */
  //  dfFlowHoriz                 = 1 << 10,  /* horiz scroll text flows in textbox
  //                                              rather than extend to right */
//    dfContinuousKaraoke         = 1 << 11,  /* ignore begin offset, hilite  everything
//                                                up to the end offset(karaoke)*/
//    dfDropShadow                = 1 << 12,  /* display text with a drop shadow */
  //  dfAntiAlias                 = 1 << 13,  /* attempt to display text anti  aliased*/
//    dfKeyedText                 = 1 << 14,  /* key the text over background*/
 //   dfInverseHilite             = 1 << 15,  /* Use inverse hiliting rather than  using
  //                                              hilite color*/
//    dfTextColorHilite           = 1 << 16   ,/* changes text color in place of
    //                                            hiliting. */
kActionTextTrackSetScroll = 12303,/* (long delay ) */


//Sets the time delay for start of the scroll. This only works when scroll flags are set in displayFlags. 
kActionTextTrackRelativeScroll = 12304,/* (short deltaX, short deltaY ) */


//Scrolls the text in the text box by the delta amounts.
 kActionTextTrackFindText = 12305,/* (long flags, Str255 theText,
                                    ModifierTrackGraphicsModeRecord  highlightColor ) */


//Finds text in the track. Similar in operation to TextMediaFindNextText since this is what it uses. 
kActionTextTrackSetHyperTextFace = 12306,/* (short index, long fontFace ) */


//Sets the text face (style) of the indexed hypertext. 
kActionTextTrackSetHyperTextColor = 12307,/* (short index,
                                    ModifierTrackGraphicsModeRecord  highlightColor ) */


//Sets the text color of the indexed hypertext. 
kActionTextTrackKeyEntry = 12308,/* (short character ) */


//Replaces the selection with the character. 
kActionTextTrackSetEditable = 12310,/* (short editState) */

//
//Controls the key entry state of the text track:  
//   #define kKeyEntryDisabled       0
//    #define kKeyEntryDirect         1
//    #define kKeyEntryScript         2
kKeyEntryDisabled =      0,
 kKeyEntryDirect    =     1,
 kKeyEntryScript    =     2,

//kKeyEntryDisabled is default. 

//If kKeyEntryDirect is on, then key events are passed directly to the text track. 

//If kKeyEntryScript is on, then scripted mouse and key events are allowed. 
kActionTextTrackMouseDown = 12309,/* no params */


//Passes the mouse click to the text track, which allows for selecting text or an insertion point when kKeyEntryScript is turned on.

};

/*Required Atoms for Wired Actions

Certain actions on a QuickTime VR movie can trigger wired actions if the appropriate event handler atoms have been added to the file. This section discusses what atoms must be included in the QuickTime VR file to support wired actions. 

As with sprite tracks, the presence of a certain atom in the media property atom container of the QTVR track enables the handling of wired actions. This atom is of type kSpriteTrackPropertyHasActions, which has a single Boolean value that must be set to true.

When certain events occur and the appropriate event handler atom is found in the QTVR file, then that atom is passed to QuickTime to perform any actions specified in the atom. The event handler atoms themselves must be added to the node information atom container in the QTVR track. There are two types of event handlers for QTVR nodes: global and hot spot specific. The currently supported global event handlers are kQTEventFrameLoaded and kQTEventIdle. The event handler atoms for these are located at the root level of the node information atom container. A global event handler atom’s type is set to the event type and its ID is set to 1.

Hot spot–specific event handler atoms are located in the specific hot spot atom as a sibling to the hot spot info atom. For these atoms, the atom type is always kQTEventType and the ID is the event type. Supported hot spot–specific event types are kQTEventMouseClick, kQTEventMouseClickEnd, kQTEventMouseClickEndTriggerButton, and kQTEventMouseEnter, kQTEventMouseExit.

The specific actions that cause these events to be generated are described as follows:
kQTEventFrameLoaded ('fram')

Generated when a node is entered, before any application-installed entering-node procedure is called (this event processing is considered part of the node setup that occurs before the application’s routine is called).
kQTEventIdle ('idle')

Generated every n ticks, where n is defined by the contents of the 
kSpriteTrackPropertyQTIdleEventsFrequency

atom (
SInt32

) in the media property atom container. When appropriate, this event is triggered before any normal idle processing occurs for the QuickTime VR movie.
kQTEventMouseClick ('clik')

Generated when the mouse goes down over a hot spot.
kQTEventMouseClickEnd ('cend')

Generated when the mouse goes up after a kQTEventMouseClick is generated, regardless of whether the mouse is still over the hot spot originally clicked. This event occurs prior to QuickTime VR’s normal mouse-up processing.
kQTEventMouseClickEndTriggerButton ('trig')

Generated when a click end triggers a hot spot (using the same criterion as used by QuickTime VR in 2.1 for link/url hot spot execution). This event occurs prior to QuickTime VR’s normal hot spot–trigger processing.
kQTEventMouseEnter ('entr'), kQTEventMouseExit ('exit')

These two events are generated when the mouse rolls into or out of a hot spot, respectively. These events occur whether or not the mouse is down and whether or not the movie is being panned. These events occur after any application-installed MouseOverHotSpotProc is called, and will be cancelled if the return value from the application’s routine indicates that QuickTimeVR’s normal over-hotspot processing should not take place.*/
 enum {
 kQTEventMouseEnter            = 'entr',
  kQTEventMouseExit             = 'exit',
 kQTEventMouseClickEnd         = 'cend',
  kQTEventMouseClickEndTriggerButton = 'trig',
};

/*New Wired OperandskOperandEventParameter = 26         // short index //


Allows key and mouse event handlers to get parameters of the triggered event. 

For the mouse:         1 : where.h
        2 : where.v
        3 : modifiers


For the key:         1 : where.h
        2 : where.v
        3 : modifiers
        4 : key
        5 : scancode
kOperandFreeMemory = 27


Returns the amount of memory free in the application heap. kOperandNetworkStatus = 28


Returns the status code of the network connection:    kQTNetworkStatusNoNetwork   = -2
    kQTNetworkStatusUncertain   = -1
    kQTNetworkStatusNotConnected = 0
    kQTNetworkStatusConnected   = 1
    kOperandMovieDuration  = 1029


Returns the duration of the target movie. kOperandMovieTimeScale = 1030


Returns the timescale of the target movie. kOperandMovieWidth = 1031


Returns the current width of the target movie. kOperandMovieHeight = 1032


Returns the current height of the target movie. kOperandMovieLoadState = 1033


Returns the load state of the target movie. <0 indicates an error.     kMovieLoadStateLoading      = 1000
    kMovieLoadStatePlayable     = 10000
    kMovieLoadStatePlaythroughOK = 20000
    kMovieLoadStateComplete     = 100000L
    kOperandMovieTrackCount   = 1034


Returns the track count of the target movie. kOperandTrackWidth = 2052


Returns the current width of the target track. kOperandTrackHeight = 2053


Returns the current height of the target track. kOperandTrackDuration = 2054


Returns the duration of the target track. kOperandSpriteTrackSpriteIDAtPoint = 3094,// short x, short y //


Returns the ID of the sprite that would be hit at the point where a mouse click occurred in the target sprite. kOperandTextTrackEditable = 6144


Returns the current key entry state of the target text track. kOperandTextTrackCopyText = 6145// long startSelection, long endSelection                                     //


Returns the selection range as a string of the target text track. kOperandTextTrackStartSelection = 6146


Returns the current starting selection point of the target text track. kOperandTextTrackEndSelection = 6147


Returns the current ending selection point of the target text track. kOperandTextTrackTextBoxLeft = 6148


Returns the left edge of the text box of target text track in text track coordinates. kOperandTextTrackTextBoxTop = 6149


Returns the top edge of the text box of target text track in text track coordinates. kOperandTextTrackTextBoxRight = 6150


Returns the right edge of the text box of target text track in text track coordinates. kOperandTextTrackTextBoxBottom = 6151


Returns the bottom edge of the text box of the target text track in text track coordinates. kOperandListCountElements = 7168// (C string parentPath) //


Returns the number of elements in the target list. kOperandListGetElementPathByIndex = 7169// (C string parentPath, short index) //


Returns the name string of the element found a parentPath and the index of the target list. kOperandListGetElementValue = 7170 // (C string elementPath) //


Returns the value of the element at elementPath of the target list. kOperandListCopyToXML= 7171     // (C string parentPath, short                                     startIndex, short endIndex) //


Returns the selection of the target list as a XML-formatted string. 

Note that the following math functions map directly to the math functions in the Macintosh interface, with the exception of kOperandDegreesToRadians and kOperandRadiansToDegrees, which are specific to QuickTime VR. kOperandSin                 = 8192          // float x  //
kOperandCos                 = 8193          // float x  //
kOperandTan                 = 8194          // float x  //
kOperandATan                = 8195          // float x  //
kOperandATan2               = 8196      // float y, float x //
kOperandDegreesToRadians    = 8197          // float x //
kOperandRadiansToDegrees    = 8198          // float x //
kOperandSquareRoot          = 8199          // float x //
kOperandExponent            = 8200          // float x //
kOperandLog                 = 8201          // float x //
kOperandFlashTrackVariable  = 9216      // [CString path, CString name] //


Returns the value of the Flash variable in the target Flash track. kOperandSystemVersion = 30


This returns the Mac version. On Windows, it currently returns 0.kOperandMovieIsActive = 1035
kOperandStringLength = 10240 // (C string text) //
kOperandStringCompare = 10241 // (C string aText, C string bText, Boolean
                                    caseSensitive, Boolan diacSensitive) //


Returns 0 for false, non-zero for true, indicating if the text is equivalent.kOperandStringSubString = 10242 // (C string text, long offset, long                                     length) //


Returns substring of text starting at 0-based offset 'offset' for length 'length'.kOperandStringConcat = 10243     // (C string aText, C string bText) //


Returns string produced by concatenating aText with bText. kOperandQuickTimeVersionRegistered


This allows the scripter to verify that specific versions of QuickTime have been registered. kOperandMovieName = 1036


Gets the target movie name, if any, stored in the user data as type 'plug' with data "moviename=theActualMovieName"kOperandMovieID             = 1037


Gets the target movie name, if any, stored in the user data as type 'plug' with data "pmovieid=##". kOperandTrackName           = 2055


Gets the target track name stored in track user data as type 'name'. kOperandTrackID             = 2056


Gets the target track ID. kOperandTrackIdleFrequency  = 2057


Gets the target track’s current idle frequency––only sprite and text currently. kOperandSpriteName = 3095


Gets the target sprite name. kOperandQTVRHotSpotsVisible = 4100


Returns whether the QuickTime VR controller is displaying the hot spots. kOperandQTVRViewCenterH = 4101


Returns the view centerH of an QuickTime VR object controller. kOperandQTVRViewCenterV = 4102


Returns the view centerH of an QuickTime VR object controller.*/

enum {
kOperandEventParameter = 26     ,    /* short index */


//Allows key and mouse event handlers to get parameters of the triggered event. 

//For the mouse:         1 : where.h
//        2 : where.v
//        3 : modifiers


//For the key:         1 : where.h
//        2 : where.v
//        3 : modifiers
//        4 : key
//      5 : scancode
kOperandFreeMemory = 27,


//Returns the amount of memory free in the application heap. kOperandNetworkStatus = 28


//Returns the status code of the network connection:  
  kQTNetworkStatusNoNetwork   = -2,
    kQTNetworkStatusUncertain   = -1,
    kQTNetworkStatusNotConnected = 0,
    kQTNetworkStatusConnected   = 1,
    kOperandMovieDuration  = 1029,


//Returns the duration of the target movie.
 kOperandMovieTimeScale = 1030,


//Returns the timescale of the target movie.
 kOperandMovieWidth = 1031,


//Returns the current width of the target movie.
 kOperandMovieHeight = 1032,


//Returns the current height of the target movie. 
kOperandMovieLoadState = 1033,


//Returns the load state of the target movie. <0 indicates an error.    
// kMovieLoadStateLoading      = 1000,
//    kMovieLoadStatePlayable     = 10000,
 //   kMovieLoadStatePlaythroughOK = 20000,
//    kMovieLoadStateComplete     = 100000L,
 //   kOperandMovieTrackCount   = 1034,


//Returns the track count of the target movie. 
kOperandTrackWidth = 2052,


//Returns the current width of the target track. 
kOperandTrackHeight = 2053,


//Returns the current height of the target track. 
kOperandTrackDuration = 2054,


//Returns the duration of the target track. 
kOperandSpriteTrackSpriteIDAtPoint = 3094,/* short x, short y */


//Returns the ID of the sprite that would be hit at the point where a mouse click occurred in the target sprite.
 kOperandTextTrackEditable = 6144,


//Returns the current key entry state of the target text track.
 kOperandTextTrackCopyText = 6145,/* long startSelection, long endSelection                                     */


//Returns the selection range as a string of the target text track. 
kOperandTextTrackStartSelection = 6146,


//Returns the current starting selection point of the target text track.
 kOperandTextTrackEndSelection = 6147,


//Returns the current ending selection point of the target text track. 
kOperandTextTrackTextBoxLeft = 6148,


//Returns the left edge of the text box of target text track in text track coordinates.
 kOperandTextTrackTextBoxTop = 6149,


//Returns the top edge of the text box of target text track in text track coordinates. 
kOperandTextTrackTextBoxRight = 6150,


//Returns the right edge of the text box of target text track in text track coordinates. 
kOperandTextTrackTextBoxBottom = 6151,


//Returns the bottom edge of the text box of the target text track in text track coordinates. 
kOperandListCountElements = 7168,/* (C string parentPath) */


//Returns the number of elements in the target list. 
kOperandListGetElementPathByIndex = 7169,/* (C string parentPath, short index) */


//Returns the name string of the element found a parentPath and the index of the target list. 
kOperandListGetElementValue = 7170, /* (C string elementPath) */


//Returns the value of the element at elementPath of the target list.
 kOperandListCopyToXML= 7171 ,    /* (C string parentPath, short                                     startIndex, short endIndex) */


//Returns the selection of the target list as a XML-formatted string. 

//Note that the following math functions map directly to the math functions in the Macintosh //interface, with the exception of kOperandDegreesToRadians and kOperandRadiansToDegrees, which are specific to QuickTime VR.
 kOperandSin                 = 8192   ,       /* float x  */
kOperandCos                 = 8193     ,     /* float x  */
kOperandTan                 = 8194    ,      /* float x  */
kOperandATan                = 8195    ,      /* float x  */
kOperandATan2               = 8196    ,  /* float y, float x */
kOperandDegreesToRadians    = 8197    ,      /* float x */
kOperandRadiansToDegrees    = 8198   ,       /* float x */
kOperandSquareRoot          = 8199    ,      /* float x */
kOperandExponent            = 8200     ,     /* float x */
kOperandLog                 = 8201   ,       /* float x */
kOperandFlashTrackVariable  = 9216   ,   /* [CString path, CString name] */


//Returns the value of the Flash variable in the target Flash track. 
kOperandSystemVersion = 30,


//This returns the Mac version. On Windows, it currently returns 0.
kOperandMovieIsActive = 1035,
kOperandStringLength = 10240 ,/* (C string text) */
kOperandStringCompare = 10241 ,/* (C string aText, C string bText, Boolean
                                    caseSensitive, Boolan diacSensitive) */


//Returns 0 for false, non-zero for true, indicating if the text is equivalent.
kOperandStringSubString = 10242 ,/* (C string text, long offset, long                                     length) */


//Returns substring of text starting at 0-based offset 'offset' for length 'length'.
kOperandStringConcat = 10243   ,  /* (C string aText, C string bText) */


//Returns string produced by concatenating aText with bText. 
//kOperandQuickTimeVersionRegistered


//This allows the scripter to verify that specific versions of QuickTime have been registered. 
kOperandMovieName = 1036,


//Gets the target movie name, if any, stored in the user data as type 'plug' with data "moviename=theActualMovieName"
kOperandMovieID             = 1037,


//Gets the target movie name, if any, stored in the user data as type 'plug' with data "pmovieid=##". 
kOperandTrackName           = 2055,


//Gets the target track name stored in track user data as type 'name'. 
kOperandTrackID             = 2056,


//Gets the target track ID.
 kOperandTrackIdleFrequency  = 2057,


//Gets the target track’s current idle frequency––only sprite and text currently. 
kOperandSpriteName = 3095,


//Gets the target sprite name. 
kOperandQTVRHotSpotsVisible = 4100,


//Returns whether the QuickTime VR controller is displaying the hot spots. 
kOperandQTVRViewCenterH = 4101,


//Returns the view centerH of an QuickTime VR object controller.
 kOperandQTVRViewCenterV = 4102,
};

/*TextMediaFindNextText Values

Constants passed to TextMediaFindNextText.

enum {
   findTextEdgeOK                = 1 << 0,
   // Okay to find text at specified sample time//
   findTextCaseSensitive         = 1 << 1,
   // Case sensitive search//
   findTextReverseSearch         = 1 << 2,
   // Search from sampleTime backwards//
   findTextWrapAround            = 1 << 3,
   // Wrap search when beginning or end of movie is hit//
   findTextUseOffset             = 1 << 4 // Begin search at the given character offset into sample rather than edge//
};
Declared In
Movies.h*/
enum {
//   findTextEdgeOK                = 1 << 0,
   /* Okay to find text at specified sample time*/
//   findTextCaseSensitive         = 1 << 1,
   /* Case sensitive search*/
//   findTextReverseSearch         = 1 << 2,
   /* Search from sampleTime backwards*/
   findTextWrapAround            = 1 << 3,
   /* Wrap search when beginning or end of movie is hit*/
   findTextUseOffset             = 1 << 4 /* Begin search at the given character offset into sample rather than edge*/
};

/*Movie Controller Actions

mcActionDoScript allows a movie to send requests to execute scripts of various sorts to a host application. The parameter is of type QTDoScriptPtr.
struct QTDoScriptRecord {
        long scriptTypeFlags;
        char *command;
        char *arguments;
};
typedef QTDoScriptRecord *QTDoScriptPtr;


These are the constants currently defined for the scriptTypeFlags field:enum {
        kScriptIsUnknownType = 1L << 0
        kScriptIsJavaScript = 1L << 1,
        kScriptIsLingoEvent = 1L << 2,
        kScriptIsVBEvent = 1L << 3,
        kScriptIsProjectorCommand = 1L << 4
};


For more information, see the explanation above of the new wired action kActionDoScript.mcActionRestartAtTime


This allows a movie to be restarted at a particular time and rate.

The parameter is a QTRestartAtTimePtr. struct QTRestartAtTimeRecord {
    TimeValue       startTime;  // time scale is the movie timescale//
    Fixed           rate;       // if rate is 0, the movie's current
                                rate is maintained//
};
typedef struct QTRestartAtTimeRecord QTRestartAtTimeRecord;
typedef QTRestartAtTimeRecord *QTRestartAtTimePtr;


For more information, see the explanation above of the new wired action kActionMovieRestartAtTime.*/
struct QTDoScriptRecord {
        long scriptTypeFlags;
        char *command;
        char *arguments;
};
typedef struct QTDoScriptRecord QTDoScriptRecord ; 
typedef QTDoScriptRecord *QTDoScriptPtr;


/*Required Atoms for Wired Actions

Certain actions on a QuickTime VR movie can trigger wired actions if the appropriate event handler atoms have been added to the file. This section discusses what atoms must be included in the QuickTime VR file to support wired actions. 

As with sprite tracks, the presence of a certain atom in the media property atom container of the QTVR track enables the handling of wired actions. This atom is of type kSpriteTrackPropertyHasActions, which has a single Boolean value that must be set to true.

When certain events occur and the appropriate event handler atom is found in the QTVR file, then that atom is passed to QuickTime to perform any actions specified in the atom. The event handler atoms themselves must be added to the node information atom container in the QTVR track. There are two types of event handlers for QTVR nodes: global and hot spot specific. The currently supported global event handlers are kQTEventFrameLoaded and kQTEventIdle. The event handler atoms for these are located at the root level of the node information atom container. A global event handler atom’s type is set to the event type and its ID is set to 1.

Hot spot–specific event handler atoms are located in the specific hot spot atom as a sibling to the hot spot info atom. For these atoms, the atom type is always kQTEventType and the ID is the event type. Supported hot spot–specific event types are kQTEventMouseClick, kQTEventMouseClickEnd, kQTEventMouseClickEndTriggerButton, and kQTEventMouseEnter, kQTEventMouseExit.

The specific actions that cause these events to be generated are described as follows:
kQTEventFrameLoaded ('fram')

Generated when a node is entered, before any application-installed entering-node procedure is called (this event processing is considered part of the node setup that occurs before the application’s routine is called).
kQTEventIdle ('idle')

Generated every n ticks, where n is defined by the contents of the 
kSpriteTrackPropertyQTIdleEventsFrequency

atom (
SInt32

) in the media property atom container. When appropriate, this event is triggered before any normal idle processing occurs for the QuickTime VR movie.
kQTEventMouseClick ('clik')

Generated when the mouse goes down over a hot spot.
kQTEventMouseClickEnd ('cend')

Generated when the mouse goes up after a kQTEventMouseClick is generated, regardless of whether the mouse is still over the hot spot originally clicked. This event occurs prior to QuickTime VR’s normal mouse-up processing.
kQTEventMouseClickEndTriggerButton ('trig')

Generated when a click end triggers a hot spot (using the same criterion as used by QuickTime VR in 2.1 for link/url hot spot execution). This event occurs prior to QuickTime VR’s normal hot spot–trigger processing.
kQTEventMouseEnter ('entr'), kQTEventMouseExit ('exit')

These two events are generated when the mouse rolls into or out of a hot spot, respectively. These events occur whether or not the mouse is down and whether or not the movie is being panned. These events occur after any application-installed MouseOverHotSpotProc is called, and will be cancelled if the return value from the application’s routine indicates that QuickTimeVR’s normal over-hotspot processing should not take place. */
enum {
  kQTEventFrameLoaded           = 'fram',
 kQTEventMouseClick  = 'clik' ,
};

/*quicktime.std.StdQTConstants4
public static final int	bandwidthManagementPrefsType	1651992425
public static final int	canMovieImportValidateDataReferences	2097152
public static final int	canMovieImportWithIdle	1048576
public static final int	codecDSequenceSingleField	64
public static final int	codecFlagDiffFrame	512
public static final int	codecFlagOutUpdateOnNextIdle	512
public static final int	connectionSpeedPrefsType	1668509796
public static final int	doTheRightThing	0
public static final int	flashMediaType	1718383464
public static final int	freeAtomType	1718838629
public static final int	hintsSingleField	1048576
public static final int	k16GrayCodecType	1647392359
public static final int	k32AlphaGrayCodecType	1647522401
public static final int	k422YpCbCr10CodecType	1983000880
public static final int	k422YpCbCr16CodecType	1983000886
public static final int	k422YpCbCr8CodecType	846624121
public static final int	k4444YpCbCrA8CodecType	1983131704
public static final int	k4444YpCbCrA8RCodecType	1916022840
public static final int	k444YpCbCr10CodecType	1983131952
public static final int	k444YpCbCr8CodecType	1983066168
public static final int	k48RGBCodecType	1647589490
public static final int	k64ARGBCodecType	1647719521
public static final int	kActionAddChannelSubscription	6155
public static final int	kActionApplicationNumberAndString	8192
public static final int	kActionDoScript	6158
public static final int	kActionFlashTrackGotoFrameLabel	10244
public static final int	kActionFlashTrackGotoFrameNumber	10243
public static final int	kActionFlashTrackSetPan	10240
public static final int	kActionFlashTrackSetZoom	10241
public static final int	kActionFlashTrackSetZoomRect	10242
public static final int	kActionMovieRestartAtTime	1038
public static final int	kActionMovieTrackAddChildMovie	11264
public static final int	kActionMovieTrackLoadChildMovie	11265
public static final int	kActionOpenCustomActionHandler	6157
public static final int	kActionQD3DNamedObjectRotateTo	9218
public static final int	kActionQD3DNamedObjectScaleTo	9217
public static final int	kActionQD3DNamedObjectTranslateTo	9216
public static final int	kActionRemoveChannelSubscription	6156
public static final int	kActionSendQTEventToTrackObject	6154
public static final int	kActionSpriteTrackConcatVariables	7172
public static final int	kActionSpriteTrackDisposeSprite	7170
public static final int	kActionSpriteTrackNewSprite	7169
public static final int	kActionSpriteTrackSetVariable	7168
public static final int	kActionSpriteTrackSetVariableToMovieBaseURL	7174
public static final int	kActionSpriteTrackSetVariableToMovieURL	7173
public static final int	kActionSpriteTrackSetVariableToString	7171
public static final int	kActionStatusString	6153
public static final int	kActionTrackSetCursor	2054
public static final int	kActionTrackSetGraphicsMode	2055
public static final int	kBrightnessContrastImageFilterType	1651663727
public static final int	kCharacteristicCanStep	1937007984
public static final int	kCharacteristicHasNoDuration	1852798057
public static final int	kCustomActionHandler	1668641652
public static final int	kCustomHandlerDesc	1684370275
public static final int	kCustomHandlerID	1768169504
public static final int	kEventKey	1801812256
public static final int	kFakeRGBCodecType	1718773602
public static final int	kFirstAction	1024
public static final int	kFirstApplicationAction	8192
public static final int	kFirstFlashTrackAction	10240
public static final int	kFirstMovieAction	1024
public static final int	kFirstMovieTrackAction	11264
public static final int	kFirstMusicAction	5120
public static final int	kFirstQD3DNamedObjectAction	9216
public static final int	kFirstQTVRAction	4096
public static final int	kFirstSpriteAction	3072
public static final int	kFirstSpriteTrackAction	7168
public static final int	kFirstSystemAction	6144
public static final int	kFirstTrackAction	2048
public static final int	kFlashMediaFrameLabelToMovieTimeSelect	265
public static final int	kFlashMediaFrameNumberToMovieTimeSelect	264
public static final int	kFlashMediaGetDisplayedFrameNumberSelect	263
public static final int	kFlashMediaGetRefConBoundsSelect	260
public static final int	kFlashMediaGetRefConIDSelect	261
public static final int	kFlashMediaIDToRefConSelect	262
public static final int	kFlashMediaSetPanSelect	257
public static final int	kFlashMediaSetZoomRectSelect	259
public static final int	kFlashMediaSetZoomSelect	258
public static final int	kGetMovieImporterDontConsiderFileOnlyImporters	64
public static final int	kGraphicsImporterDontDoGammaCorrection	1
public static final int	kICMGetChainChild	2
public static final int	kICMGetChainParent	1
public static final int	kICMGetChainUltimateChild	3
public static final int	kICMGetChainUltimateParent	0
public static final int	kICMPixelFormatIsIndexed	16
public static final int	kICMPixelFormatIsPlanarMask	15
public static final int	kICMPixelFormatIsSupportedByQD	32
public static final int	kImageDescriptionAlternateCodec	1937074547
public static final int	kImageDescriptionClassicAtomFormat	1635020653
public static final int	kImageDescriptionColorSpace	1668508003
public static final int	kImageDescriptionEffectDataFormat	1719165812
public static final int	kImageDescriptionGammaLevel	1734438241
public static final int	kImageDescriptionPrivateDataFormat	1886546294
public static final int	kImageDescriptionQTAtomFormat	1903452532
public static final int	kImageDescriptionSampleFormat	1768187501
public static final int	kIndeo4CodecType	1230386225
public static final int	kLastAction	11265
public static final int	kLastAction4	11265
public static final int	kLastApplicationAction	8192
public static final int	kLastFlashTrackAction	10244
public static final int	kLastMovieAction	1038
public static final int	kLastMovieTrackAction	11265
public static final int	kLastMusicAction	5121
public static final int	kLastQD3DNamedObjectAction	9218
public static final int	kLastQTVRAction	4100
public static final int	kLastSpriteAction	3083
public static final int	kLastSpriteTrackAction	7174
public static final int	kLastSystemAction	6158
public static final int	kLastTrackAction	2055
public static final int	kLensFlareImageFilterType	1818586739
public static final int	kMCActivateSelect	25
public static final int	kMCAdjustCursorSelect	48
public static final int	kMCClearSelect	34
public static final int	kMCClickSelect	28
public static final int	kMCCopySelect	31
public static final int	kMCCutSelect	32
public static final int	kMCDoActionSelect	9
public static final int	kMCDrawBadgeSelect	42
public static final int	kMCDrawSelect	24
public static final int	kMCEnableEditingSelect	29
public static final int	kMCGetClipSelect	41
public static final int	kMCGetControllerBoundsRectSelect	16
public static final int	kMCGetControllerBoundsRgnSelect	18
public static final int	kMCGetControllerInfoSelect	37
public static final int	kMCGetControllerPortSelect	13
public static final int	kMCGetCurrentTimeSelect	22
public static final int	kMCGetDoActionsProcSelect	50
public static final int	kMCGetIndMovieSelect	5
public static final int	kMCGetInterfaceElementSelect	49
public static final int	kMCGetMenuStringSelect	44
public static final int	kMCGetVisibleSelect	15
public static final int	kMCGetWindowRgnSelect	19
public static final int	kMCIdleSelect	26
public static final int	kMCInvalidateSelect	47
public static final int	kMCIsControllerAttachedSelect	11
public static final int	kMCIsEditingEnabledSelect	30
public static final int	kMCIsPlayerEventSelect	7
public static final int	kMCKeySelect	27
public static final int	kMCMovieChangedSelect	20
public static final int	kMCNewAttachedControllerSelect	23
public static final int	kMCPasteSelect	33
public static final int	kMCPositionControllerSelect	36
public static final int	kMCPtInControllerSelect	46
public static final int	kMCRemoveAllMoviesSelect	6
public static final int	kMCRemoveAMovieSelect	3
public static final int	kMCRemoveMovieSelect	6
public static final int	kMCSetActionFilterSelect	8
public static final int	kMCSetActionFilterWithRefConSelect	45
public static final int	kMCSetClipSelect	40
public static final int	kMCSetControllerAttachedSelect	10
public static final int	kMCSetControllerBoundsRectSelect	17
public static final int	kMCSetControllerPortSelect	12
public static final int	kMCSetDurationSelect	21
public static final int	kMCSetMovieSelect	2
public static final int	kMCSetUpEditMenuSelect	43
public static final int	kMCSetVisibleSelect	14
public static final int	kMCUndoSelect	35
public static final int	kMedia3DGetCameraAngleAspectSelect	266
public static final int	kMedia3DGetCameraDataSelect	264
public static final int	kMedia3DGetCameraRangeSelect	270
public static final int	kMedia3DGetCurrentGroupSelect	259
public static final int	kMedia3DGetNamedObjectListSelect	257
public static final int	kMedia3DGetRendererListSelect	258
public static final int	kMedia3DGetViewObjectSelect	271
public static final int	kMedia3DRotateNamedObjectToSelect	262
public static final int	kMedia3DScaleNamedObjectToSelect	261
public static final int	kMedia3DSetCameraAngleAspectSelect	265
public static final int	kMedia3DSetCameraDataSelect	263
public static final int	kMedia3DSetCameraRangeSelect	269
public static final int	kMedia3DTranslateNamedObjectToSelect	260
public static final int	kMovieControllerDontDisplayToUser	2
public static final int	kMovieControllerQTVRFlag	1
public static final int	kMovieMediaAltText	1634497652
public static final int	kMovieMediaAutoPlay	1886151033
public static final int	kMovieMediaBackgroundColor	1651204972
public static final int	kMovieMediaClipBegin	1668051042
public static final int	kMovieMediaClipDuration	1668051044
public static final int	kMovieMediaDataReference	1835885682
public static final int	kMovieMediaDefaultDataReferenceID	1684304489
public static final int	kMovieMediaEnableFrameStepping	1701734003
public static final int	kMovieMediaFitClipIfNecessary	1751737444
public static final int	kMovieMediaFitFill	1718185068
public static final int	kMovieMediaFitMeet	1835361652
public static final int	kMovieMediaFitNone	0
public static final int	kMovieMediaFitScroll	1935897199
public static final int	kMovieMediaFitSlice	1936484707
public static final int	kMovieMediaGetChildDoMCActionCallbackSelect	258
public static final int	kMovieMediaGetChildMovieDataReferenceSelect	262
public static final int	kMovieMediaGetCurrentMoviePropertySelect	260
public static final int	kMovieMediaGetCurrentTrackPropertySelect	261
public static final int	kMovieMediaGetDoMCActionCallbackSelect	259
public static final int	kMovieMediaHeight	1752440864
public static final int	kMovieMediaLeft	1818584692
public static final int	kMovieMediaLoadChildMovieFromDataReferenceSelect	264
public static final int	kMovieMediaLoop	1819242352
public static final int	kMovieMediaRectangleAtom	1919247220
public static final int	kMovieMediaRegionAtom	1919248233
public static final int	kMovieMediaSetChildMovieDataReferenceSelect	263
public static final int	kMovieMediaSlaveAudio	1936482677
public static final int	kMovieMediaSlaveGraphicsMode	1936484210
public static final int	kMovieMediaSlaveTime	1936487529
public static final int	kMovieMediaSlaveTrackDuration	1936487538
public static final int	kMovieMediaSpatialAdjustment	1718187040
public static final int	kMovieMediaTitle	1953068140
public static final int	kMovieMediaTop	1953460256
public static final int	kMovieMediaUseMIMEType	1835625829
public static final int	kMovieMediaWidth	2003050528
public static final int	kMoviePropertyDuration	1685418593
public static final int	kMoviePropertyMatrix	1836348024
public static final int	kMoviePropertyNaturalBounds	1851880546
public static final int	kMoviePropertyTime	1953066358
public static final int	kMoviePropertyTimeScale	1953066355
public static final int	kMoviePropertyTrackList	1953264500
public static final int	kMpegYUV420CodecType	1836676470
public static final int	kMusicFlagDontPlay2Soft	1
public static final int	kMusicFlagDontSlaveToMovie	2
public static final int	kMusicMediaGetIndexedTunePlayerSelect	257
public static final int	kOperandComponentVersion	22
public static final int	kOperandConnectionSpeed	6
public static final int	kOperandCustomActionHandlerIDIsOpen	5
public static final int	kOperandGMTDay	7
public static final int	kOperandGMTHours	10
public static final int	kOperandGMTMinutes	11
public static final int	kOperandGMTMonth	8
public static final int	kOperandGMTSeconds	12
public static final int	kOperandGMTYear	9
public static final int	kOperandLocalDay	13
public static final int	kOperandLocalHours	16
public static final int	kOperandLocalMinutes	17
public static final int	kOperandLocalMonth	14
public static final int	kOperandLocalSeconds	18
public static final int	kOperandLocalYear	15
public static final int	kOperandMaxLoadedTimeInMovie	25
public static final int	kOperandOriginalHandlerRefcon	23
public static final int	kOperandPlatformRunningOn	20
public static final int	kOperandQuickTimeVersion	21
public static final int	kOperandRegisteredForQuickTimePro	19
public static final int	kOperandSubscribedToChannel	3
public static final int	kOperandTicks	24
public static final int	kOperandUniqueCustomActionHandlerID	4
public static final int	kPlatformMacintosh	1
public static final int	kPlatformWindows	2
public static final int	kPNGCodecType	1886283552
public static final int	kQDesign2Compression	1363430706
public static final int	kQDesignCompression	1363430723
public static final int	kQTEventKey	1801812256
public static final int	kQTEventMouseMoved	1836021605
public static final int	kQTEventMovieLoaded	1819238756
public static final int	kQTEventRecordAtomType	1701995875
public static final int	kQTFileTypeFlash	1398228556
public static final int	kQTFileTypeFlashPix	1179675000
public static final int	kQTFileTypeFLC	1179402528
public static final int	kQTFileTypePNG	1347307366
public static final int	kQTFileTypeTIFF	1414088262
public static final int	kQTIdlePriority	10
public static final int	kQTNonRealTimePriority	20
public static final int	kQTRealTimePriority	30
public static final int	kQTRegistrationDialogForceDialog	4
public static final int	kQTRegistrationDialogShowDialog	2
public static final int	kQTRegistrationDialogTimeOutFlag	1
public static final int	kQTSettingsComponentVersion	1986359923
public static final int	kQTSettingsDVExportLockedAudio	1819239275
public static final int	kQTSettingsDVExportNTSC	1685480310
public static final int	kQTSettingsGraphicsFileImportSequence	1936617845
public static final int	kQTSettingsGraphicsFileImportSequenceEnabled	1701732706
public static final int	kQTSettingsMovieExportEnableSound	1701737327
public static final int	kQTSettingsMovieExportEnableVideo	1701738089
public static final int	kQTSettingsMovieExportSaveCompressedMovie	1668116589
public static final int	kQTSettingsMovieExportSaveForInternet	1717662580
public static final int	kQTSettingsMovieExportSaveOptions	1935767141
public static final int	kQTSettingsTimeDuration	1685418593
public static final int	kQTSRTSPDataType	1920234352
public static final int	kQTSSDPDataType	1935962144
public static final int	kQTSStreamMediaType	1937011309
public static final int	kQTTIFFCompression_PackBits	32773
public static final int	kQUALCOMMCompression	1365470320
public static final int	kScalingCodecType	1935892844
public static final int	kScriptIsJavaScript	2
public static final int	kScriptIsLingoEvent	4
public static final int	kScriptIsProjectorCommand	16
public static final int	kScriptIsUnknownType	1
public static final int	kScriptIsVBEvent	8
public static final int	kSorensonYUV9CodecType	1937339961
public static final int	kSpriteBehaviorsAtomType	1650813025
public static final int	kSpriteCursorBehaviorAtomType	1668445042
public static final int	kSpriteFloatingPointVariableAtomType	1718382455
public static final int	kSpriteImageBehaviorAtomType	1768776039
public static final int	kSpriteImageDataRefAtomType	1768780389
public static final int	kSpriteImageDataRefTypeAtomType	1768780404
public static final int	kSpriteImageDefaultImageIndexAtomType	1684366953
public static final int	kSpriteMediaCountImagesSelect	261
public static final int	kSpriteMediaCountSpritesSelect	260
public static final int	kSpriteMediaDisposeSpriteSelect	277
public static final int	kSpriteMediaGetActionVariableAsStringSelect	279
public static final int	kSpriteMediaGetActionVariableSelect	274
public static final int	kSpriteMediaGetDisplayedSampleNumberSelect	263
public static final int	kSpriteMediaGetImageNameSelect	265
public static final int	kSpriteMediaGetIndImageDescriptionSelect	262
public static final int	kSpriteMediaGetIndImagePropertySelect	275
public static final int	kSpriteMediaGetPropertySelect	258
public static final int	kSpriteMediaGetSpriteActionsForQTEventSelect	272
public static final int	kSpriteMediaGetSpriteNameSelect	264
public static final int	kSpriteMediaGetSpritePropertySelect	267
public static final int	kSpriteMediaHitTestAllSpritesSelect	268
public static final int	kSpriteMediaHitTestOneSpriteSelect	269
public static final int	kSpriteMediaHitTestSpritesSelect	259
public static final int	kSpriteMediaNewSpriteSelect	276
public static final int	kSpriteMediaSetActionVariableSelect	273
public static final int	kSpriteMediaSetActionVariableToStringSelect	278
public static final int	kSpriteMediaSetPropertySelect	257
public static final int	kSpriteMediaSetSpritePropertySelect	266
public static final int	kSpriteMediaSpriteIDToIndexSelect	271
public static final int	kSpriteMediaSpriteIndexToIDSelect	270
public static final int	kSpritePropertyActionHandlingSpriteID	8
public static final int	kSpriteStatusStringsBehaviorAtomType	1936946290
public static final int	kSpriteStringVariableAtomType	1937011319
public static final int	kSpriteVariablesContainerAtomType	2002874995
public static final int	kStatusHasCodeNumber	8
public static final int	kStatusIsError	16
public static final int	kStatusStringIsStreamingStatus	4
public static final int	kStatusStringIsURLLink	2
public static final int	kSystemIsWindows9x	65536
public static final int	kSystemIsWindowsNT	131072
public static final int	kTargetChildMovieMovieID	1836019049
public static final int	kTargetChildMovieMovieName	1836019054
public static final int	kTargetChildMovieTrackID	1836020841
public static final int	kTargetChildMovieTrackIndex	1836020856
public static final int	kTargetChildMovieTrackName	1836020846
public static final int	kTargetMovieID	1836018020
public static final int	kTargetMovieName	1836019297
public static final int	kTargetParentMovie	1836019809
public static final int	kTargetQD3DNamedObjectName	1851879009
public static final int	kTargetRootMovie	1836020335
public static final int	kTextAlignment	10
public static final int	kTextBackColor	5
public static final int	kTextDisplayFlags	13
public static final int	kTextDropShadow	12
public static final int	kTextFace	7
public static final int	kTextFont	8
public static final int	kTextForeColor	6
public static final int	kTextHilite	11
public static final int	kTextMediaAddHiliteSampleSelect	260
public static final int	kTextMediaAddTESampleSelect	259
public static final int	kTextMediaAddTextSampleSelect	258
public static final int	kTextMediaDrawRawSelect	265
public static final int	kTextMediaFindNextTextSelect	261
public static final int	kTextMediaHiliteTextSampleSelect	262
public static final int	kTextMediaRawIdleSelect	268
public static final int	kTextMediaRawSetupSelect	267
public static final int	kTextMediaSetTextProcSelect	257
public static final int	kTextMediaSetTextPropertySelect	266
public static final int	kTextMediaSetTextSampleDataSelect	263
public static final int	kTextScroll	14
public static final int	kTextSetSelection	4
public static final int	kTextSize	9
public static final int	kTextTEStyle	3
public static final int	kTextTextHandle	1
public static final int	kTextTextPtr	2
public static final int	kTIFFCodecType	1952540262
public static final int	kTrackModifierAngleAspectCamera	14
public static final int	kTrackPropertyInstantiation	1768846196
public static final int	kTrackPropertyMediaType	1836349808
public static final int	kTweenType3dAngleAspectCameraData	862151009
public static final int	kUserDataTextAuthor	-1453230732
public static final int	kUserDataTextChapter	-1453102992
public static final int	kUserDataTextComment	-1453101708
public static final int	kUserDataTextCreationDate	-1453039239
public static final int	kUserDataTextDescription	-1453038221
public static final int	kUserDataTextDirector	-1453037198
public static final int	kUserDataTextDisclaimer	-1453037197
public static final int	kUserDataTextEditDate1	-1452973007
public static final int	kUserDataTextHostComputer	-1452772492
public static final int	kUserDataTextKeywords	-1452579463
public static final int	kUserDataTextMake	-1452449429
public static final int	kUserDataTextModel	-1452445852
public static final int	kUserDataTextOriginalFormat	-1452905100
public static final int	kUserDataTextOriginalSource	-1452051869
public static final int	kUserDataTextPerformers	-1452248474
public static final int	kUserDataTextProducer	-1452248476
public static final int	kUserDataTextProduct	-1454353852
public static final int	kUserDataTextSoftware	-1452050574
public static final int	kUserDataTextSpecialPlaybackRequirements	-1452120719
public static final int	kUserDataTextWarning	-1451789714
public static final int	kUserDataTextWriter	-1451789708
public static final int	kUserDataUnicodeBit	128
public static final int	kVideoMediaGetCodecParameterSelect	272
public static final int	kVideoMediaGetStallCountSelect	270
public static final int	kVideoMediaGetStatisticsSelect	262
public static final int	kVideoMediaResetStatisticsSelect	261
public static final int	kVideoMediaSetCodecParameterSelect	271
public static final int	kYUV420CodecType	2033463856
public static final int	kZoomTransitionType	2054123373
public static final int	mcActionDoScript	78
public static final int	mcActionGetIndChapter	80
public static final int	mcActionLinkToURLExtended	81
public static final int	mcActionMovieChanged	77
public static final int	mcActionRestartAtTime	79
public static final int	mediaHandlerFlagBaseClient	1
public static final int	mediaQualityBest	192
public static final int	mediaQualityBetter	128
public static final int	mediaQualityDraft	0
public static final int	mediaQualityNormal	64
public static final int	movieBackwardPointerResourceType	1650549611
public static final int	movieDataAtomType	1835295092
public static final int	movieExecuteWiredActionDontExecute	1
public static final int	movieExportTimeScale	1953395555
public static final int	movieExportUseConfiguredSettings	1969448551
public static final int	movieFileType	1299148630
public static final int	movieForwardPointerResourceType	1718579813
public static final int	movieImportResultComplete	64
public static final int	movieImportResultNeedIdles	32
public static final int	movieImportWithIdle	16
public static final int	movieMediaType	1836019574
public static final int	movieProgressClose	2
public static final int	movieProgressOpen	0
public static final int	movieProgressUpdatePercent	1
public static final int	movieResourceAtomType	1836019574
public static final int	movieResourceType	1836019574
public static final int	movieScrapType	1836019574
public static final int	newMovieAsyncOK	256
public static final int	newMovieDontAutoUpdateClock	32
public static final int	newMovieIdleImportOK	1024
public static final int	pdActionFetchPreview	13
public static final int	progressOpAddMovieSelection	5
public static final int	progressOpCopy	6
public static final int	progressOpCut	7
public static final int	progressOpExportMovie	12
public static final int	progressOpFlatten	1
public static final int	progressOpImportMovie	11
public static final int	progressOpInsertMovieSegment	3
public static final int	progressOpInsertTrackSegment	2
public static final int	progressOpLoadMediaIntoRam	10
public static final int	progressOpLoadMovieIntoRam	8
public static final int	progressOpLoadTrackIntoRam	9
public static final int	progressOpPaste	4
public static final int	quickTimeImageFileColorSyncProfileAtom	1768514403
public static final int	skipAtomType	1936419184
public static final int	wideAtomPlaceholderType	2003395685
public static final int	wiredActionHandlerType	2003399269*/
enum{
kActionApplicationNumberAndString=	8192,
kActionSpriteTrackSetVariable	=7168,
mcActionDoScript	=78,
kActionAddChannelSubscription=	6155,
kActionRemoveChannelSubscription=	6156,
progressOpExportMovie=	12,
};

/*MCAdjustCursor Values

Constants passed to MCAdjustCursor.

enum {
   kQTCursorOpenHand             = -19183,
   kQTCursorClosedHand           = -19182,
   kQTCursorPointingHand         = -19181,
   kQTCursorRightArrow           = -19180,
   kQTCursorLeftArrow            = -19179,
   kQTCursorDownArrow            = -19178,
   kQTCursorUpArrow              = -19177,
   kQTCursorIBeam                = -19176
};
Declared In
Movies.h, HIMovieView.h*/
enum {
   kQTCursorOpenHand             = -19183,
   kQTCursorClosedHand           = -19182,
   kQTCursorPointingHand         = -19181,
   kQTCursorRightArrow           = -19180,
   kQTCursorLeftArrow            = -19179,
   kQTCursorDownArrow            = -19178,
   kQTCursorUpArrow              = -19177,
   kQTCursorIBeam                = -19176,
   kActionTrackSetCursor	=2054,
};

/*The specific actions that cause these events to be generated are described as follows:
kQTEventFrameLoaded ('fram')

Generated when a node is entered, before any application-installed entering-node procedure is called (this event processing is considered part of the node setup that occurs before the application’s routine is called).
kQTEventIdle ('idle')

Generated every n ticks, where n is defined by the contents of the 
kSpriteTrackPropertyQTIdleEventsFrequency

atom (
SInt32

) in the media property atom container. When appropriate, this event is triggered before any normal idle processing occurs for the QuickTime VR movie.
kQTEventMouseClick ('clik')

Generated when the mouse goes down over a hot spot.
kQTEventMouseClickEnd ('cend')

Generated when the mouse goes up after a kQTEventMouseClick is generated, regardless of whether the mouse is still over the hot spot originally clicked. This event occurs prior to QuickTime VR’s normal mouse-up processing.
kQTEventMouseClickEndTriggerButton ('trig')

Generated when a click end triggers a hot spot (using the same criterion as used by QuickTime VR in 2.1 for link/url hot spot execution). This event occurs prior to QuickTime VR’s normal hot spot–trigger processing.
kQTEventMouseEnter ('entr'), kQTEventMouseExit ('exit')

These two events are generated when the mouse rolls into or out of a hot spot, respectively. These events occur whether or not the mouse is down and whether or not the movie is being panned. These events occur after any application-installed MouseOverHotSpotProc is called, and will be cancelled if the return value from the application’s routine indicates that QuickTimeVR’s normal over-hotspot processing should not take place.*/
enum {
  kQTEventIdle                  = 'idle',
};

/*Set the allowedFlags to flags from the following enumeration, or zero fetching without constraints.
enum {
    kActionFlagActionIsDelta                = 1L << 1,
    kActionFlagParameterWrapsAround = 1L << 2,
    kActionFlagActionIsToggle               = 1L << 3
}; 

If allowedFlags is not set to zero, set the min, max, current, and isUnsignedValue fields to appropriate values based on the data type being fetched.*/
enum {
    kActionFlagActionIsDelta                = 1L << 1,
    kActionFlagParameterWrapsAround = 1L << 2,
    kActionFlagActionIsToggle               = 1L << 3
}; 


/*Arithmetic and Logical Operator IDs

Constants that identify arithmetic and logical operations.

kOperatorAdd                  = 'add '
kOperatorSubtract             = 'sub '
kOperatorMultiply             = 'mult'
kOperatorDivide               = 'div '
kOperatorOr                   = 'or  '
kOperatorAnd                  = 'and '
kOperatorNot                  = 'not '
kOperatorLessThan             = '<   '
kOperatorLessThanEqualTo      = '<=  '
kOperatorEqualTo              = '=   '
kOperatorNotEqualTo           = '!=  '
kOperatorGreaterThan          = '>   '
kOperatorGreaterThanEqualTo   = '>=  '
kOperatorModulo               = 'mod '
kOperatorIntegerDivide        = 'idiv'
kOperatorAbsoluteValue        = 'abs '
kOperatorNegate               = 'neg '*/
enum {
kOperatorAdd                  = 'add ',
kOperatorSubtract             = 'sub ',
kOperatorMultiply             = 'mult',
kOperatorDivide               = 'div ',
kOperatorOr                   = 'or  ',
kOperatorAnd                  = 'and ',
kOperatorNot                  = 'not ',
kOperatorLessThan             = '<   ',
kOperatorLessThanEqualTo      = '<=  ',
kOperatorEqualTo              = '=   ',
kOperatorNotEqualTo           = '!=  ',
kOperatorGreaterThan          = '>   ',
kOperatorGreaterThanEqualTo   = '>=  ',
kOperatorModulo               = 'mod ',
kOperatorIntegerDivide        = 'idiv',
kOperatorAbsoluteValue        = 'abs ',
kOperatorNegate               = 'neg ',
};

/*GetMediaDataRef Values

Constants passed to GetMediaDataRef.

enum {
   dataRefSelfReference          = 1 << 0,
   dataRefWasNotResolved         = 1 << 1
};
Declared In
Movies.h*/
enum {
   dataRefSelfReference          = 1 << 0,
   dataRefWasNotResolved         = 1 << 1
};


/*Modifier Input Types

The media input map describes the meaning of each input to a track. Each track has particular attributes associated with it, such as size, position, and volume. The media input map of that track describes the mapping of track modifier inputs to track properties. When you want to modify the attributes of a track, you can insert a track modifier input such as kTrackModifierTypeMatrix into the input map. The values stored in the modifier input you inserted will affect the values that are currently stored with the track.

Custom media handlers can define additional input types as necessary. Apple Computer reserves all input types consisting entirely of lowercase letters.

The following input types are currently defined:
enum {
    kTrackModifierTypeMatrix            = 1,
    kTrackModifierTypeClip              = 2,
    kTrackModifierTypeGraphicsMode      = 5,
    kTrackModifierTypeVolume            = 3,
    kTrackModifierTypeBalance           = 4,
    kTrackModifierTypeImage             = 'vide',
    kTrackModifierObjectMatrix          = 6,
    kTrackModifierObjectGraphicsMode    = 7,
    kTrackModifierType3d4x4Matrix       = 8,
    kTrackModifierCameraData            = 9 
    kTrackModifierSoundLocalization     = 10
};

Term	
Definition

kTrackModifierTypeMatrix	
Data sent to this input should be in the form of a QuickTime MatrixRecordMovie Data Types. The matrix is concatenated with the track and movie matrices to determine the tracks final location and size. The matrix modifier describes relative, not absolute, position and scaling.

kTrackModifierTypeClip	
Data sent to this input should be in the form of a QuickDraw region. The region is intersected with the track's source box.

kTrackModifierTypeGraphicsMode	
Data sent to this input should be in the form of a ModifierTrackGraphicsModeRecord data type. The contents of the record are used as the graphics mode setting for the track. The graphics mode is not combined with the track's current graphics mode, but rather overrides it.

kTrackModifierTypeVolume	
Data sent to this input should be in the form of a 16-bit fixed-point number. This is the same format in which QuickTime sound volume levels are stored. The volume level is used as a scaling factor on the sound track's level. It is multiplied with the track and movie volumes to determine the track's overall volume.

kTrackModifierTypeBalance	
Data sent to this input should be in the form of a 8-bit fixed-point number. This is the same format in which QuickTime balance values are stored. The balance value is used as the balance setting for the track. Unlike the volume modifier, it is not concatenated with the track's current balance level, but overrides the current balance level.

kTrackModifierTypeImage	
Data sent to this input should be compressed video data, typically from a video track. This input type can be used with sprite tracks. For sprite tracks, the image data is used to replace the image of a specified image index in the sprite track. The index of the image to replace must be specified in the media input map when the reference is created.

kTrackModifierObjectMatrix	
Data sent to this input should be in the form of a QuickTime MatrixRecordMovie Data Types. The matrix is sent to a particular object within the receiving track, as specified by the kTrackModifierObjectID atom in the input map. The matrix acts as an override to the object's current matrix. For example, the matrix could be sent to a sprite within a sprite track. It would cause the sprite to move, not the entire sprite track as would kTrackModifierMatrixMovie Data Types.

kTrackModifierObjectGraphicsMode	
Data sent to this input should be in the form of a ModifierTrackGraphicsModeRecord data type. The contents of the record are used to vary the opacity of an object within the track. For example, you would use data sent to this input to vary the opacity of a sprite within a sprite track, rather than modifying the opacity of the entire sprite track.

kTrackModifierSoundLocalization	
Data sent to this input should be in the form of a sound localization data record (SSpLocalizationDataMovie Data Types). This data overrides the sound localization settings already in use by the track.*/
enum {
    kTrackModifierTypeMatrix            = 1,
    kTrackModifierTypeClip              = 2,
    kTrackModifierTypeGraphicsMode      = 5,
    kTrackModifierTypeVolume            = 3,
    kTrackModifierTypeBalance           = 4,
    kTrackModifierTypeImage             = 'vide',
    kTrackModifierObjectMatrix          = 6,
    kTrackModifierObjectGraphicsMode    = 7,
    kTrackModifierType3d4x4Matrix       = 8,
    kTrackModifierCameraData            = 9 ,
    kTrackModifierSoundLocalization     = 10
};



/*This allows you to send a wired movie message to a host application like QuickTime Player. 

The application message can be one of the following defines:kQTAppMessageSoftwareChanged = 1        /* notification to app that
                                        installed QuickTime
                                        software has been updated/
kQTAppMessageWindowCloseRequested = 3   / request for app to close
                                        window containing
                                        movie controller/
kQTAppMessageExitFullScreenRequested = 4/ request for app to turn off
                                        full screen mode if active/
kActionFlashTrackSetFlashVariable = 10245 / (C string path, C string
                        name, C string value, Boolean updateFocus) /*/
enum {
kQTAppMessageSoftwareChanged = 1  ,      /* notification to app that
                                        installed QuickTime
                                        software has been updated*/
kQTAppMessageWindowCloseRequested = 3  , /* request for app to close
                                        window containing
                                        movie controller*/
kQTAppMessageExitFullScreenRequested = 4,/* request for app to turn off
                                        full screen mode if active*/
kActionFlashTrackSetFlashVariable = 10245 /* (C string path, C string
                        name, C string value, Boolean updateFocus) */
};
/*quicktime.std.StdQTConstants5
public static final int	attributeValueKindBoolean	4
public static final int	attributeValueKindCaseSensEnum	64
public static final int	attributeValueKindCharString	0
public static final int	attributeValueKindColor	16
public static final int	attributeValueKindEnum	32
public static final int	attributeValueKindInteger	1
public static final int	attributeValueKindOnOff	8
public static final int	attributeValueKindPercent	2
public static final int	codecImageBufferIsInAGPMemory	16
public static final int	codecImageBufferIsInPCIMemory	32
public static final int	codecImageBufferIsOverlaySurface	2
public static final int	codecSrcMustBeImageBuffer	4
public static final int	codecUsesOverlaySurface	1
public static final int	elementFlagAlwaysSelfContained	1
public static final int	elementFlagPreserveWhiteSpace	2
public static final int	handlerCanPicSave	8192
public static final int	hintsNoRenderingTimeOut	2097152
public static final int	kActionDoCompressedActions	6159
public static final int	kActionDontPassKeyEvent	6163
public static final int	kActionFlashTrackDoButtonActions	10246
public static final int	kActionFlashTrackSetFlashVariable	10245
public static final int	kActionListAddElement	13312
public static final int	kActionListExchangeLists	13318
public static final int	kActionListPasteFromXML	13315
public static final int	kActionListRemoveElements	13313
public static final int	kActionListServerQuery	13319
public static final int	kActionListSetElementValue	13314
public static final int	kActionListSetFromURL	13317
public static final int	kActionListSetMatchingFromXML	13316
public static final int	kActionLoadComponent	6161
public static final int	kActionMovieTrackLoadChildMovieWithQTListParams	11266
public static final int	kActionQTVREnableHotSpot	4101
public static final int	kActionQTVRShowHotSpots	4102
public static final int	kActionQTVRTranslateObject	4103
public static final int	kActionSendAppMessage	6160
public static final int	kActionSetFocus	6162
public static final int	kActionSpriteExchangeLists	3084
public static final int	kActionTextTrackFindText	12305
public static final int	kActionTextTrackKeyEntry	12308
public static final int	kActionTextTrackMouseDown	12309
public static final int	kActionTextTrackPasteText	12288
public static final int	kActionTextTrackRelativeScroll	12304
public static final int	kActionTextTrackSetAlignment	12299
public static final int	kActionTextTrackSetBackgroundColor	12294
public static final int	kActionTextTrackSetDisplayFlags	12302
public static final int	kActionTextTrackSetDropShadow	12301
public static final int	kActionTextTrackSetEditable	12310
public static final int	kActionTextTrackSetFace	12296
public static final int	kActionTextTrackSetFont	12297
public static final int	kActionTextTrackSetForegroundColor	12295
public static final int	kActionTextTrackSetHilite	12300
public static final int	kActionTextTrackSetHyperTextColor	12307
public static final int	kActionTextTrackSetHyperTextFace	12306
public static final int	kActionTextTrackSetScroll	12303
public static final int	kActionTextTrackSetSelection	12293
public static final int	kActionTextTrackSetSize	12298
public static final int	kActionTextTrackSetTextBox	12291
public static final int	kActionTextTrackSetTextStyle	12292
public static final int	kActionTrackSetBassTreble	2057
public static final int	kActionTrackSetIdleFrequency	2056
public static final int	kFetchAsBooleanPtr	1
public static final int	kFetchAsComponentDescriptionPtr	15
public static final int	kFetchAsCString	16
public static final int	kFetchAsFixedPtr	12
public static final int	kFetchAsFloatPtr	8
public static final int	kFetchAsHandle	6
public static final int	kFetchAsLongPtr	3
public static final int	kFetchAsMatrixRecordPtr	4
public static final int	kFetchAsModifierTrackGraphicsModeRecord	5
public static final int	kFetchAsNewAtomContainer	10
public static final int	kFetchAsPointPtr	9
public static final int	kFetchAsQTEventRecordPtr	11
public static final int	kFetchAsRgnHandle	14
public static final int	kFetchAsSetControllerValuePtr	13
public static final int	kFetchAsShortPtr	2
public static final int	kFetchAsStr255	7
public static final int	kFirstMultiTargetAction	13312
public static final int	kFirstTextTrackAction	12288
public static final int	kFlashMediaDoButtonActionsSelect	268
public static final int	kFlashMediaGetFlashVariableSelect	266
public static final int	kFlashMediaGetSupportedSwfVersionSelect	269
public static final int	kFlashMediaSetFlashVariableSelect	267
public static final int	kGetMovieImporterAutoImportOnly	1024
public static final int	kICMSequenceTaskName	1953390957
public static final int	kICMSequenceTaskWeight	1953981801
public static final int	kLastAction5	13319
public static final int	kLastMultiTargetAction	13319
public static final int	kLastTextTrackAction	12310
public static final int	kMCAddMovieSegmentSelect	51
public static final int	kMCTrimMovieSegmentSelect	52
public static final int	kMediaQTIdleFrequencySelector	1768187505
public static final int	kMHInfoEncodedFrameRate	1869767028
public static final int	kMovieAnchorDataRefIsDefault	1
public static final int	kMovieLoadStateComplete	100000
public static final int	kMovieLoadStateLoading	1000
public static final int	kMovieLoadStatePlayable	10000
public static final int	kMovieLoadStatePlaythroughOK	20000
public static final int	kMovieMediaPrerollTime	1886545266
public static final int	kOperandATan	8195
public static final int	kOperandATan2	8196
public static final int	kOperandCanHaveFocus	5124
public static final int	kOperandCos	8193
public static final int	kOperandDegreesToRadians	8197
public static final int	kOperandEventParameter	26
public static final int	kOperandExponent	8200
public static final int	kOperandFlashTrackVariable	9216
public static final int	kOperandFreeMemory	27
public static final int	kOperandHasFocus	5125
public static final int	kOperandListCopyToXML	7171
public static final int	kOperandListCountElements	7168
public static final int	kOperandListGetElementPathByIndex	7169
public static final int	kOperandListGetElementValue	7170
public static final int	kOperandLog	8201
public static final int	kOperandMovieDuration	1029
public static final int	kOperandMovieHeight	1032
public static final int	kOperandMovieID	1037
public static final int	kOperandMovieIsActive	1035
public static final int	kOperandMovieLoadState	1033
public static final int	kOperandMovieName	1036
public static final int	kOperandMovieTimeScale	1030
public static final int	kOperandMovieTrackCount	1034
public static final int	kOperandMovieWidth	1031
public static final int	kOperandNetworkStatus	28
public static final int	kOperandQTVRHotSpotsVisible	4100
public static final int	kOperandQTVRViewCenterH	4101
public static final int	kOperandQTVRViewCenterV	4102
public static final int	kOperandQuickTimeVersionRegistered	29
public static final int	kOperandRadiansToDegrees	8198
public static final int	kOperandSin	8192
public static final int	kOperandSpriteName	3095
public static final int	kOperandSpriteTrackSpriteIDAtPoint	3094
public static final int	kOperandSquareRoot	8199
public static final int	kOperandStringCompare	10241
public static final int	kOperandStringConcat	10243
public static final int	kOperandStringLength	10240
public static final int	kOperandStringSubString	10242
public static final int	kOperandSystemVersion	30
public static final int	kOperandTan	8194
public static final int	kOperandTextTrackCopyText	6145
public static final int	kOperandTextTrackEditable	6144
public static final int	kOperandTextTrackEndSelection	6147
public static final int	kOperandTextTrackStartSelection	6146
public static final int	kOperandTextTrackTextBoxBottom	6151
public static final int	kOperandTextTrackTextBoxLeft	6148
public static final int	kOperandTextTrackTextBoxRight	6150
public static final int	kOperandTextTrackTextBoxTop	6149
public static final int	kOperandTextTrackTextLength	6152
public static final int	kOperandTrackBass	2058
public static final int	kOperandTrackDuration	2054
public static final int	kOperandTrackID	2056
public static final int	kOperandTrackIdleFrequency	2057
public static final int	kOperandTrackName	2055
public static final int	kOperandTrackTreble	2059
public static final int	kParameterUsageCircularDegrees	1684367203
public static final int	kParameterUsageCircularRadians	1918985315
public static final int	kQTAllowAggressiveImporters	16
public static final int	kQTAllowImportersThatWouldCreateNewFile	8
public static final int	kQTAllowOpeningStillImagesAsMovies	4
public static final int	kQTAppMessageDisplayChannels	5
public static final int	kQTAppMessageEnterFullScreenRequested	6
public static final int	kQTAppMessageExitFullScreenRequested	4
public static final int	kQTAppMessageSoftwareChanged	1
public static final int	kQTAppMessageWindowCloseRequested	3
public static final int	kQTBandwidthChangeRequest	4
public static final int	kQTBandwidthNotifyGoodToGo	2
public static final int	kQTBandwidthNotifyNeedToStop	1
public static final int	kQTBandwidthQueueRequest	8
public static final int	kQTBandwidthScheduledRequest	16
public static final int	kQTBandwidthVoluntaryRelease	32
public static final int	kQTCloneDontCopyEdits	2
public static final int	kQTCloneShareSamples	1
public static final int	kQTDontLookForMovieImporterIfGraphicsImporterFound	2
public static final int	kQTDontUseDataToFindImporter	1
public static final int	kQTEventListReceived	1818850164
public static final int	kQTEventPayloadIsQTList	1
public static final int	kQTGetMIMETypeInfoIsQuickTimeMovieType	1836019574
public static final int	kQTGetMIMETypeInfoIsUnhelpfulType	1685417314
public static final int	kQTListElementTypeEmpty	1701671028
public static final int	kQTListElementTypeFloat	1718382433
public static final int	kQTListElementTypeList	1818850164
public static final int	kQTListElementTypeString	1937011232
public static final int	kQTNetworkStatusConnected	1
public static final int	kQTNetworkStatusNoNetwork	-2
public static final int	kQTNetworkStatusNotConnected	0
public static final int	kQTNetworkStatusUncertain	-1
public static final int	kQTParseTextHREFBaseURL	1651864172
public static final int	kQTParseTextHREFChapter	1667785072
public static final int	kQTParseTextHREFClickPoint	1668049259
public static final int	kQTParseTextHREFDelimiter	1684368493
public static final int	kQTParseTextHREFEMBEDArgs	1835165028
public static final int	kQTParseTextHREFHREF	1752327526
public static final int	kQTParseTextHREFIsAutoHREF	1635087471
public static final int	kQTParseTextHREFIsServerMap	1936548208
public static final int	kQTParseTextHREFRecomposeHREF	1919447654
public static final int	kQTParseTextHREFTarget	1952543335
public static final int	kQTParseTextHREFText	1952807028
public static final int	kQTParseTextHREFURL	1970433056
public static final int	kQTParseTextHREFUseAltDelim	1634497636
public static final int	kQTPhotoshopLayerClipping	1818455152
public static final int	kQTPhotoshopLayerFlags	1818651751
public static final int	kQTPhotoshopLayerMode	1819111268
public static final int	kQTPhotoshopLayerName	-1452511635
public static final int	kQTPhotoshopLayerOpacity	1819242593
public static final int	kQTPhotoshopLayerUnicodeName	1819635305
public static final int	kQTRealTimeSharedPriority	25
public static final int	kScriptIsAppleScript	32
public static final int	kTargetCurrentQTEventParams	1702260833
public static final int	kTextEditState	21
public static final int	kTextEndSelection	23
public static final int	kTextHyperTextColor	17
public static final int	kTextHyperTextFace	16
public static final int	kTextKeyEntry	18
public static final int	kTextLength	22
public static final int	kTextMediaGetTextPropertySelect	269
public static final int	kTextMouseDown	19
public static final int	kTextRelativeScroll	15
public static final int	kTextSelection	4
public static final int	kTextStartSelection	22
public static final int	kTextTextBox	20
public static final int	kTextTextBoxBottom	27
public static final int	kTextTextBoxLeft	24
public static final int	kTextTextBoxRight	26
public static final int	kTextTextBoxTop	25
public static final int	kUserDataTextAlbum	-1453233054
public static final int	kUserDataTextArtist	-1455336876
public static final int	kUserDataTextComposer	-1453101203
public static final int	kUserDataTextEncodedBy	-1452970397
public static final int	kUserDataTextGenre	-1452841618
public static final int	kUserDataTextOriginalArtist	-1452314523
public static final int	kUserDataTextTrack	-1451986325
public static final int	kUserDataTextURLLink	-1451920788
public static final short	mcActionAppMessageReceived	85
public static final short	mcActionAutoPlay	83
public static final short	mcActionEvaluateExpressionWithType	89
public static final short	mcActionGetMovieActive	92
public static final short	mcActionGetMovieID	91
public static final short	mcActionGetMovieName	90
public static final short	mcActionMovieFinished	86
public static final short	mcActionPauseToBuffer	84
public static final short	mcActionSetVolumeStep	82
public static final int	mDisableIdleActions	4096
public static final int	mDoIdleActionsBeforeDraws	2048
public static final int	mIgnorePortOrigin	8192
public static final int	mPrecompositeOnly	512
public static final int	mSoundOnly	1024
public static final int	mWantIdleActions	32
public static final int	nameSpaceIDNone	0
public static final int	nullDataHandlerSubType	1853189228
public static final int	pointerDataHandlerSubType	1886679584
public static final int	txtProcDefaultDisplay	0
public static final int	txtProcDoDisplay	2
public static final int	txtProcDontDisplay	1
public static final int	videoFlagDontLeanAhead	1
public static final int	xmlContentTypeCharData	2
public static final int	xmlContentTypeElement	1
public static final int	xmlContentTypeInvalid	0
public static final int	xmlIdentifierInvalid	0
public static final int	xmlIdentifierUnrecognized	-1
public static final int	xmlParseComponentSubType	2020437024
public static final int	xmlParseComponentType	1885434483
public static final int	xmlParseFlagAllowUnquotedAttributeValues	2
public static final int	xmlParseFlagAllowUppercase	1
public static final int	xmlParseFlagEventParseOnly	4*/
enum {
kQTAppMessageEnterFullScreenRequested =	6,
mcActionAppMessageReceived	=85,
mcActionAutoPlay	=83
};


/*quicktime.std.StdQTConstants

public static final int	aliasDataHandlerSubType	1634494835
public static final int	appleDataCompressorSubType	1633969507
public static final int	audioMediaCharacteristic	1700885107
public static final int	baseMediaType	1735291491
public static final int	callOldBits	2
public static final int	callStdBits	1
public static final int	canMovieExportAuxDataHandle	128
public static final int	canMovieExportFiles	16
public static final int	canMovieExportFromProcedures	32768
public static final int	canMovieExportHandles	8
public static final int	canMovieExportValidateMovie	65536
public static final int	canMovieImportDataReferences	262144
public static final int	canMovieImportFiles	2
public static final int	canMovieImportHandles	1
public static final int	canMovieImportInPlace	2048
public static final int	canMovieImportPartial	8192
public static final int	canMovieImportValidateFile	512
public static final int	canMovieImportValidateHandles	256
public static final int	channelFlagDontOpenResFile	2
public static final int	channelFlagHasDependency	4
public static final int	channelPlayAllData	4
public static final int	channelPlayFast	1
public static final int	channelPlayHighQuality	2
public static final int	channelPlayNormal	0
public static final int	clipAID	1668049264
public static final int	clockComponentType	1668050795
public static final int	codecCanAsync	8192
public static final int	codecCanAsyncWhen	65536
public static final int	codecCanClipRectangular	256
public static final int	codecCanClipVertical	128
public static final int	codecCanCopyPrev	32
public static final int	codecCanCopyPrevComp	4096
public static final int	codecCanDoIndirectSurface	33554432
public static final int	codecCanFastDither	1024
public static final int	codecCanLockSurface	-2147483648
public static final int	codecCanMakeMask	16384
public static final int	codecCanManagePrevBuffer	262144
public static final int	codecCanMask	2
public static final int	codecCanMatte	4
public static final int	codecCanRemapColor	512
public static final int	codecCanRemapResolution	536870912
public static final int	codecCanScale	1
public static final int	codecCanShieldCursor	131072
public static final int	codecCanShift	32768
public static final int	codecCanSpool	64
public static final int	codecCanSrcExtract	2048
public static final int	codecCanTransferMode	16
public static final int	codecCanTransform	8
public static final int	codecCompletionDest	2
public static final int	codecCompletionDontUnshield	4
public static final int	codecCompletionDropped	64
public static final int	codecCompletionForceChainFlush	32
public static final int	codecCompletionSource	1
public static final int	codecCompletionUnlockBits	16
public static final int	codecCompletionWentOffscreen	8
public static final int	codecConditionCatchUpDiff	16384
public static final int	codecConditionCodecChangedMask	-2147483648
public static final int	codecConditionDoCursor	8192
public static final int	codecConditionFirstBand	1
public static final int	codecConditionFirstFrame	4
public static final int	codecConditionFirstScreen	4096
public static final int	codecConditionLastBand	2
public static final int	codecConditionMaskMayBeChanged	32768
public static final int	codecConditionNewAccuracy	1024
public static final int	codecConditionNewClut	512
public static final int	codecConditionNewDepth	8
public static final int	codecConditionNewDestination	2048
public static final int	codecConditionNewMask	64
public static final int	codecConditionNewMatte	128
public static final int	codecConditionNewSrcRect	32
public static final int	codecConditionNewTransferMode	256
public static final int	codecConditionNewTransform	16
public static final int	codecConditionToBuffer	65536
public static final int	codecFlagCatchUpDiff	4096
public static final int	codecFlagDontOffscreen	32
public static final int	codecFlagDontUseNewImageBuffer	1024
public static final int	codecFlagForceKeyFrame	128
public static final int	codecFlagImageBufferNotSourceImage	8192
public static final int	codecFlagInterlaceUpdate	2048
public static final int	codecFlagLiveGrab	512
public static final int	codecFlagNoScreenUpdate	8
public static final int	codecFlagOnlyScreenUpdate	256
public static final int	codecFlagOutUpdateOnDataSourceChange	1024
public static final int	codecFlagOutUpdateOnTimeChange	4096
public static final int	codecFlagReenable	16384
public static final int	codecFlagSequenceSensitive	2048
public static final int	codecFlagSupportDisable	8192
public static final int	codecFlagUpdatePrevious	4
public static final int	codecFlagUpdatePreviousComp	64
public static final int	codecFlagUsedImageBuffer	32768
public static final int	codecFlagUsedNewImageBuffer	16384
public static final int	codecFlagUseImageBuffer	1
public static final int	codecFlagUseScreenBuffer	2
public static final int	codecFlagWasCompressed	16
public static final int	codecHandlesInputs	16777216
public static final int	codecHasVolatileBuffer	524288
public static final int	codecHighQuality	768
public static final int	codecImageBufferIsOnScreen	2097152
public static final int	codecInfoDepth1	1
public static final int	codecInfoDepth16	16
public static final int	codecInfoDepth2	2
public static final int	codecInfoDepth24	64
public static final int	codecInfoDepth32	32
public static final int	codecInfoDepth33	128
public static final int	codecInfoDepth34	256
public static final int	codecInfoDepth36	512
public static final int	codecInfoDepth4	4
public static final int	codecInfoDepth40	1024
public static final int	codecInfoDepth8	8
public static final int	codecInfoDoes1	1
public static final int	codecInfoDoes16	16
public static final int	codecInfoDoes2	2
public static final int	codecInfoDoes32	32
public static final int	codecInfoDoes4	4
public static final int	codecInfoDoes8	8
public static final int	codecInfoDoesBlend	524288
public static final int	codecInfoDoesDither	64
public static final int	codecInfoDoesDouble	2048
public static final int	codecInfoDoesHalf	8192
public static final int	codecInfoDoesHorizFlip	65536
public static final int	codecInfoDoesLossless	4096
public static final int	codecInfoDoesMask	512
public static final int	codecInfoDoesQuad	4096
public static final int	codecInfoDoesQuarter	16384
public static final int	codecInfoDoesRateConstrain	8388608
public static final int	codecInfoDoesRecompress	2097152
public static final int	codecInfoDoesRotate	32768
public static final int	codecInfoDoesShrink	256
public static final int	codecInfoDoesSpool	4194304
public static final int	codecInfoDoesStretch	128
public static final int	codecInfoDoesTemporal	1024
public static final int	codecInfoDoesVertFlip	131072
public static final int	codecInfoDoesWarp	1048576
public static final int	codecInfoHasEffectParameterList	262144
public static final int	codecInfoResourceType	1667523433
public static final int	codecInfoSequenceSensitive	8192
public static final int	codecInfoStoresClut	2048
public static final int	codecInterfaceVersion	2
public static final int	codecIsDirectToScreenOnly	1073741824
public static final int	codecIsSequenceSensitive	67108864
public static final int	codecLockBitsShieldCursor	1
public static final int	codecLosslessQuality	1024
public static final int	codecLowQuality	256
public static final int	codecMaxQuality	1023
public static final int	codecMinimumDataSize	32768
public static final int	codecMinQuality	0
public static final int	codecNormalQuality	512
public static final int	codecProgressClose	2
public static final int	codecProgressOpen	0
public static final int	codecProgressUpdatePercent	1
public static final int	codecRequiresMaskBits	268435456
public static final int	codecRequiresOffscreen	134217728
public static final int	codecWantsDestinationPixels	4194304
public static final int	codecWantsRegionMask	1048576
public static final int	codecWantsSpecialScaling	8388608
public static final int	colorTableAID	1668571490
public static final int	compositeIn	0
public static final int	compressedMovieAID	1668116342
public static final int	compressedMovieDataAID	1668118116
public static final int	compressorComponentType	1768776559
public static final int	createFilePreviewComponentType	1886216555
public static final int	createMovieFileDeleteCurFile	-2147483648
public static final int	createMovieFileDontCreateMovie	1073741824
public static final int	createMovieFileDontCreateResFile	268435456
public static final int	createMovieFileDontOpenFile	536870912
public static final int	currentIn	0
public static final int	dataCompressionAtomAID	1684238189
public static final int	dataCompressorComponentType	1684238189
public static final int	dataDecompressorComponentType	1684301155
public static final int	dataHandlerType	1684565106
public static final int	dataInfoAID	1684631142
public static final int	dataRefAID	1685218662
public static final int	dataRefContainerAID	1685218915
public static final int	dataRefSelfReference	1
public static final int	dataRefWasNotResolved	2
public static final int	decompressorComponentType	1768776803
public static final int	defaultDither	0
public static final int	defaultProgressFuntion	-1
public static final int	dfAntiAlias	8192
public static final int	dfClipToTextBox	4
public static final int	dfContinuousKaraoke	2048
public static final int	dfContinuousScroll	512
public static final int	dfDontAutoScale	2
public static final int	dfDontDisplay	1
public static final int	dfDropShadow	4096
public static final int	dfFlowHoriz	1024
public static final int	dfHorizScroll	128
public static final int	dfInverseHilite	32768
public static final int	dfKeyedText	16384
public static final int	dfReverseScroll	256
public static final int	dfScrollIn	32
public static final int	dfScrollOut	64
public static final int	dfShrinkTextBoxToFit	16
public static final int	dfTextColorHilite	65536
public static final int	dfUseMovieBGColor	8
public static final int	digiInDoesBW	8192
public static final int	digiInDoesColor	4096
public static final int	digiInDoesComponent	1024
public static final int	digiInDoesComposite	256
public static final int	digiInDoesGenLock	128
public static final int	digiInDoesNTSC	1
public static final int	digiInDoesPAL	2
public static final int	digiInDoesSECAM	4
public static final int	digiInDoesSVideo	512
public static final int	digiInSignalLock	-2147483648
public static final int	digiInVTR_Broadcast	2048
public static final int	digiOutDoes1	1
public static final int	digiOutDoes16	16
public static final int	digiOutDoes2	2
public static final int	digiOutDoes32	32
public static final int	digiOutDoes4	4
public static final int	digiOutDoes8	8
public static final int	digiOutDoesAsyncGrabs	33554432
public static final int	digiOutDoesBlend	524288
public static final int	digiOutDoesCompress	134217728
public static final int	digiOutDoesCompressOnly	268435456
public static final int	digiOutDoesCompressPartiallyVisible	1073741824
public static final int	digiOutDoesDither	64
public static final int	digiOutDoesDouble	2048
public static final int	digiOutDoesHorizFlip	65536
public static final int	digiOutDoesHW_DMA	2097152
public static final int	digiOutDoesHWPlayThru	4194304
public static final int	digiOutDoesILUT	8388608
public static final int	digiOutDoesKeyColor	16777216
public static final int	digiOutDoesMask	512
public static final int	digiOutDoesPlayThruDuringCompress	536870912
public static final int	digiOutDoesQuad	4096
public static final int	digiOutDoesQuarter	8192
public static final int	digiOutDoesRotate	32768
public static final int	digiOutDoesShrink	256
public static final int	digiOutDoesSixteenth	16384
public static final int	digiOutDoesSkew	262144
public static final int	digiOutDoesStretch	128
public static final int	digiOutDoesUnreadableScreenBits	67108864
public static final int	digiOutDoesVertFlip	131072
public static final int	digiOutDoesWarp	1048576
public static final int	dmaDepth1	1
public static final int	dmaDepth16	16
public static final int	dmaDepth2	2
public static final int	dmaDepth2Gray	64
public static final int	dmaDepth32	32
public static final int	dmaDepth4	4
public static final int	dmaDepth4Gray	128
public static final int	dmaDepth8	8
public static final int	dmaDepth8Gray	256
public static final int	dontAutoFileMovieImport	64
public static final int	dontRegisterWithEasyOpen	1024
public static final int	dropShadowOffsetType	1685221487
public static final int	dropShadowTranslucencyType	1685221492
public static final int	DVCMediaType	1685480224
public static final int	editListAID	1701606260
public static final int	editsAID	1701082227
public static final int	effectIsRealtime	0
public static final int	elOptionsIncludeNoneInList	1
public static final int	evenField1ToEvenFieldOut	1
public static final int	evenField1ToOddFieldOut	2
public static final int	evenField2ToEvenFieldOut	16
public static final int	evenField2ToOddFieldOut	32
public static final int	findTextCaseSensitive	2
public static final int	findTextEdgeOK	1
public static final int	findTextReverseSearch	4
public static final int	findTextUseOffset	16
public static final int	findTextWrapAround	8
public static final int	flattenActiveTracksOnly	4
public static final int	flattenAddMovieToDataFork	1
public static final int	flattenCompressMovieResource	32
public static final int	flattenDontInterleaveFlatten	8
public static final int	flattenForceMovieResourceBeforeMovieData	64
public static final int	flattenFSSpecPtrIsDataRefRecordPtr	16
public static final int	flushFromRam	4
public static final int	forceDither	1
public static final int	forceUpdateNewBuffer	2
public static final int	forceUpdateRedraw	1
public static final int	fullScreenAllowEvents	2
public static final int	fullScreenDontChangeMenuBar	4
public static final int	fullScreenHideCursor	1
public static final int	fullScreenPreflightSize	8
public static final int	genericMediaInfoAID	1735223662
public static final int	genericMediaInfoHeaderAID	1735223396
public static final int	grabPictCurrentImage	4
public static final int	grabPictIgnoreClip	2
public static final int	grabPictOffScreen	1
public static final int	graphicsExporterCanTranscode	2
public static final int	graphicsExporterComponentType	1735550328
public static final int	graphicsExporterIsBaseExporter	1
public static final int	graphicsExporterUsesImageCompressor	4
public static final int	graphicsImporterComponentType	1735551344
public static final int	graphicsImporterDoesntDrawAllPixels	1
public static final int	graphicsImporterDontKnowIfDrawAllPixels	2
public static final int	graphicsImporterDrawsAllPixels	0
public static final int	graphicsImporterUsesImageDecompressor	8388608
public static final int	graphicsModeComposition	259
public static final int	graphicsModePreBlackAlpha	258
public static final int	graphicsModePreMulColorAlpha	261
public static final int	graphicsModePreWhiteAlpha	257
public static final int	graphicsModeStraightAlpha	256
public static final int	graphicsModeStraightAlphaBlend	260
public static final int	gxClosedFrameFill	2
public static final int	gxEvenOddFill	3
public static final int	gxFrameFill	1
public static final int	gxHollowFill	2
public static final int	gxInverseEvenOddFill	5
public static final int	gxInverseFill	5
public static final int	gxInverseSolidFill	5
public static final int	gxInverseWindingFill	6
public static final int	gxNoFill	0
public static final int	gxOpenFrameFill	1
public static final int	gxSolidFill	3
public static final int	gxWindingFill	4
public static final int	handleDataHandlerSubType	1752065132
public static final int	handlerAID	1751411826
public static final int	handlerCanClip	2
public static final int	handlerCanHandleComplexMatrix	1024
public static final int	handlerCanMatte	4
public static final int	handlerCanSend	512
public static final int	handlerCanSendImageData	4096
public static final int	handlerCanTransferMode	8
public static final int	handlerCGrafPortOnly	256
public static final int	handlerHasSpatial	1
public static final int	handlerNeedsBuffer	16
public static final int	handlerNoIdle	32
public static final int	handlerNoScheduler	64
public static final int	handlerWantsDestinationPixels	2048
public static final int	handlerWantsTime	128
public static final int	hasMovieExportUserInterface	32
public static final int	hasMovieImportMIMEList	16384
public static final int	hasMovieImportUserInterface	4
public static final int	hintsAllowBlacklining	16384
public static final int	hintsAllowDynamicResize	524288
public static final int	hintsAllowInterlace	64
public static final int	hintsDontDraw	8192
public static final int	hintsDontPurge	4
public static final int	hintsDontUseVideoOverlaySurface	65536
public static final int	hintsHighQuality	256
public static final int	hintsIgnoreBandwidthRestrictions	131072
public static final int	hintsInactive	2048
public static final int	hintsLoop	2
public static final int	hintsOffscreen	4096
public static final int	hintsPalindrome	512
public static final int	hintsPlayingEveryFrame	262144
public static final int	hintsScrubMode	1
public static final int	hintsUseScreenBuffer	32
public static final int	hintsUseSoundInterp	128
public static final int	icmFrameTimeHasVirtualStartTimeAndDuration	1
public static final int	identityMatrixType	0
public static final int	imageTranscodererComponentType	1768780899
public static final int	inputMapAID	1768776048
public static final int	instSamplePreProcessFlag	1
public static final int	k3DMediaRendererCode	1919119204
public static final int	k3DMediaRendererEntry	1919250020
public static final int	k3DMediaRendererName	1851878757
public static final int	kAccessKeyAtomType	1633905529
public static final int	kAccessKeySystemFlag	1
public static final int	kAction	1633907822
public static final int	kActionCase	6144
public static final int	kActionDebugStr	6148
public static final int	kActionFlagActionIsDelta	2
public static final int	kActionFlagActionIsToggle	8
public static final int	kActionFlagParameterWrapsAround	4
public static final int	kActionFlags	1718378855
public static final int	kActionGoToURL	6146
public static final int	kActionListAtomType	1818850164
public static final int	kActionMovieChanged	1037
public static final int	kActionMovieGoToBeginning	1029
public static final int	kActionMovieGoToEnd	1030
public static final int	kActionMovieGoToTime	1027
public static final int	kActionMovieGoToTimeByName	1028
public static final int	kActionMoviePlaySelection	1035
public static final int	kActionMovieSetLanguage	1036
public static final int	kActionMovieSetLoopingFlags	1026
public static final int	kActionMovieSetRate	1025
public static final int	kActionMovieSetSelection	1033
public static final int	kActionMovieSetSelectionByName	1034
public static final int	kActionMovieSetVolume	1024
public static final int	kActionMovieStepBackward	1032
public static final int	kActionMovieStepForward	1031
public static final int	kActionMusicPlayNote	5120
public static final int	kActionMusicSetController	5121
public static final int	kActionParameter	1885434477
public static final int	kActionParameterMaxValue	1835104374
public static final int	kActionParameterMinValue	1835626102
public static final int	kActionPopAndGotoLabeledTime	6152
public static final int	kActionPopAndGotoTopTime	6151
public static final int	kActionPushCurrentTime	6149
public static final int	kActionPushCurrentTimeWithLabel	6150
public static final int	kActionQTVRGoToNodeID	4100
public static final int	kActionQTVRSetFieldOfView	4098
public static final int	kActionQTVRSetPanAngle	4096
public static final int	kActionQTVRSetTiltAngle	4097
public static final int	kActionQTVRShowDefaultView	4099
public static final int	kActionSendQTEventToSprite	6147
public static final int	kActionSpriteClickOnCodec	3079
public static final int	kActionSpritePassMouseToCodec	3078
public static final int	kActionSpriteRotate	3082
public static final int	kActionSpriteScale	3081
public static final int	kActionSpriteSetGraphicsMode	3076
public static final int	kActionSpriteSetImageIndex	3073
public static final int	kActionSpriteSetLayer	3075
public static final int	kActionSpriteSetMatrix	3072
public static final int	kActionSpriteSetVisible	3074
public static final int	kActionSpriteStretch	3083
public static final int	kActionSpriteTranslate	3080
public static final int	kActionTarget	1952543335
public static final int	kActionTrackSetBalance	2049
public static final int	kActionTrackSetClip	2053
public static final int	kActionTrackSetEnabled	2050
public static final int	kActionTrackSetLayer	2052
public static final int	kActionTrackSetMatrix	2051
public static final int	kActionTrackSetVolume	2048
public static final int	kActionWhile	6145
public static final int	kaiCopyrightType	1080258681
public static final int	kaiInstGMQualityType	1903518060
public static final int	kaiInstInfoType	1768517222
public static final int	kaiInstrumentRefType	1769104742
public static final int	kaiKeyRangeInfoType	1936289382
public static final int	kaiKnobListType	1802396268
public static final int	kaiLibraryDescType	1818522467
public static final int	kaiLibraryInfoType	1818848870
public static final int	kaiNoteRequestInfoType	1853125233
public static final int	kaiOtherStrType	1937011232
public static final int	kaiPictType	1885954932
public static final int	kaiSampleDataQUIDType	1903520100
public static final int	kaiSampleDataType	1935958388
public static final int	kaiSampleDescType	1935962979
public static final int	kaiSampleInfoType	1936550254
public static final int	kaiToneDescType	1953459813
public static final int	kaiWriterType	1081569908
public static final int	kAlphaCompositorTransitionType	1651273316
public static final int	kAlphaGainImageFilterType	1734437230
public static final int	kAnimationCodecType	1919706400
public static final int	kAnySubType	0
public static final int	kAnyType	0
public static final int	kAppleSysexCmdAtomicInstrument	16
public static final int	kAppleSysexCmdDeveloper	32512
public static final int	kAppleSysexCmdSampleBreak	2
public static final int	kAppleSysexCmdSampleSize	1
public static final int	kAppleSysexID	17
public static final int	kAtomInterpolateIsOptional	2
public static final int	kAtomNoFlags	0
public static final int	kAtomNotInterpolated	1
public static final int	kAVRJPEGCodecType	1635152416
public static final int	kBackgroundSpriteLayerNum	32767
public static final int	kBaseCodecType	1650553701
public static final int	kBaseGraphicsExporterSubType	1650553701
public static final int	kBaseInstrumentSubType	1650553701
public static final int	kBlurImageFilterType	1651275122
public static final int	kBMPCodecType	1465011269
public static final int	kCharacteristicCanSendVideo	1987276388
public static final int	kCharacteristicNonLinear	1852796524
public static final int	kCharacteristicProvidesActions	1633907822
public static final int	kCharacteristicProvidesURLs	1970433132
public static final int	kChromaKeyTransitionType	1667982713
public static final int	kCinepakCodecType	1668704612
public static final int	kCircularGradient	1
public static final int	kClarisWorks	1112490575
public static final int	kClockCanHandleIntermittentSound	4
public static final int	kClockImplementsCallBacks	2
public static final int	kClockRateIsLinear	1
public static final int	kCloudCodecType	1668050805
public static final int	kCMYKCodecType	1668118891
public static final int	kCodecFrameTypeDifference	2
public static final int	kCodecFrameTypeDroppableDifference	3
public static final int	kCodecFrameTypeKey	1
public static final int	kCodecFrameTypeUnknown	0
public static final int	kColorSyncImageFilterType	1937337955
public static final int	kColorTintImageFilterType	1953066612
public static final int	kCommentAtomType	2003335456
public static final int	kComponentVideoCodecType	2037741106
public static final int	kComponentVideoSigned	2037741173
public static final int	kComponentVideoUnsigned	2037741171
public static final int	kConditionalAtomType	1952805748
public static final int	kControlEventControllerFieldPos	16
public static final int	kControlEventControllerFieldWidth	8
public static final int	kControlEventLen	1
public static final int	kControlEventType	2
public static final int	kControlEventValueFieldPos	0
public static final int	kControlEventValueFieldWidth	16
public static final int	kControllerAfterTouch	33
public static final int	kControllerBalance	8
public static final int	kControllerBreath	2
public static final int	kControllerCeleste	94
public static final int	kControllerChorus	93
public static final int	kControllerEditPart	113
public static final int	kControllerExpression	11
public static final int	kControllerFoot	4
public static final int	kControllerHeight	16
public static final int	kControllerLever1	16
public static final int	kControllerLever2	17
public static final int	kControllerLever3	18
public static final int	kControllerLever4	19
public static final int	kControllerLever5	80
public static final int	kControllerLever6	81
public static final int	kControllerLever7	82
public static final int	kControllerLever8	83
public static final int	kControllerMasterCPULoad	116
public static final int	kControllerMasterFeatures	118
public static final int	kControllerMasterPolyphony	117
public static final int	kControllerMasterTranspose	114
public static final int	kControllerMasterTune	114
public static final int	kControllerMasterVolume	115
public static final short	kControllerMaximum	32767
public static final short	kControllerMinimum	-32768
public static final int	kControllerModulationWheel	1
public static final int	kControllerPan	10
public static final int	kControllerPartTranspose	40
public static final int	kControllerPartVolume	42
public static final int	kControllerPhaser	95
public static final int	kControllerPitchBend	32
public static final int	kControllerPortamento	65
public static final int	kControllerPortamentoTime	5
public static final int	kControllerReverb	91
public static final int	kControllerSoftPedal	67
public static final int	kControllerSostenuto	66
public static final int	kControllerSustain	64
public static final int	kControllerTremolo	92
public static final int	kControllerTuneTranspose	41
public static final int	kControllerTuneVolume	43
public static final int	kControllerVolume	7
public static final int	kConvolveImageFilterType	1734700651
public static final int	kCrossFadeTransitionType	1685286006
public static final int	kCurrentlyNativeEndian	1
public static final int	kCurrentlyNotNativeEndian	2
public static final int	kCurveAddAtomToVectorStreamSelect	266
public static final int	kCurveAddPathAtomToVectorStreamSelect	267
public static final int	kCurveAddZeroAtomToVectorStreamSelect	268
public static final int	kCurveAntialiasControlAtom	1634628713
public static final int	kCurveAntialiasOff	0
public static final int	kCurveAntialiasOn	-1
public static final int	kCurveARGBColorAtom	1634887522
public static final int	kCurveCountPointsInPathSelect	259
public static final int	kCurveCreateVectorStreamSelect	265
public static final int	kCurveDepthAlwaysOffscreenMask	-2147483648
public static final int	kCurveEndAtom	2053468783
public static final int	kCurveFillTypeAtom	1718185068
public static final int	kCurveGetAtomDataFromVectorStreamSelect	269
public static final int	kCurveGetLengthSelect	256
public static final int	kCurveGetNearestPathPointSelect	263
public static final int	kCurveGetPathPointSelect	260
public static final int	kCurveGradientAngleAtom	1634625388
public static final int	kCurveGradientOffsetAtom	1667591796
public static final int	kCurveGradientRadiusAtom	1918985321
public static final int	kCurveGradientRecordAtom	1735549284
public static final int	kCurveGradientTypeAtom	1735550068
public static final int	kCurveInsertPointIntoPathSelect	261
public static final int	kCurveJoinAttributesAtom	1785686382
public static final int	kCurveLengthToPointSelect	257
public static final int	kCurveMinimumDepthAtom	1835626084
public static final int	kCurveMiterLimitAtom	1835627634
public static final int	kCurveNewPathSelect	258
public static final int	kCurvePathAtom	1885434984
public static final int	kCurvePathPointToLengthSelect	264
public static final int	kCurvePenThicknessAtom	1885695604
public static final int	kCurveSetPathPointSelect	262
public static final int	kDataHCanRead	1
public static final int	kDataHCanStreamingWrite	64
public static final int	kDataHCanWrite	8
public static final int	kDataHExtendedSchedule	2020896356
public static final int	kDataHMustCheckDataRef	128
public static final int	kDataHSpecialRead	2
public static final int	kDataHSpecialReadFile	4
public static final int	kDataHSpecialWrite	16
public static final int	kDataHSpecialWriteFile	32
public static final int	kDataRate144ModemRate	1400
public static final int	kDataRate288ModemRate	2800
public static final int	kDataRateDualISDNRate	11200
public static final int	kDataRateInfiniteRate	2147483647
public static final int	kDataRateISDNRate	5600
public static final int	kDataRateT1Rate	150000
public static final int	kDataRefExtensionChokeSpeed	1667788651
public static final int	kDataRefExtensionInitializationData	1684108385
public static final int	kDataRefExtensionMacOSFileType	1718909296
public static final int	kDataRefExtensionMIMEType	1835625829
public static final int	kDataRefFileExtensionTag	1702392864
public static final int	kDataRefIsSelfContained	1
public static final int	kDataRefMimeTypeTag	1835625829
public static final int	kDataRefQTFileTypeTag	1718909296
public static final int	kDefaultKnobValue	2147483646
public static final int	kDeleteCurFile	-2147483648
public static final int	kDisableControl	1
public static final int	kDisableWhenEqual	17
public static final int	kDisableWhenGreaterThan	49
public static final int	kDisableWhenLessThan	33
public static final int	kDisableWhenNotEqual	1
public static final int	kDontUseValidateToFindGraphicsImporter	1
public static final int	kDVCNTSCCodecType	1685480224
public static final int	kDVCPALCodecType	1685480304
public static final int	kDVCProNTSCCodecType	1685483630
public static final int	kDVCProPALCodecType	1685483632
public static final int	kEdgeDetectImageFilterType	1701078885
public static final int	keepInRam	1
public static final int	kEffectBlendMode	1649241956
public static final int	kEffectBorderColor	1650682994
public static final int	kEffectBorderWidth	2003395700
public static final int	kEffectBottomAlphaPin	1885957698
public static final int	kEffectDataSourceType	1685353332
public static final int	kEffectDirectionBottom	2
public static final int	kEffectDirectionLeft	1
public static final int	kEffectDirectionRight	3
public static final int	kEffectDirectionTop	0
public static final int	kEffectFromDirection	1718775661
public static final int	kEffectGainValue	1734437230
public static final int	kEffectGenericType	1734698598
public static final int	kEffectHorizontalRepeat	1752134249
public static final int	kEffectManufacturerAtom	1835101813
public static final int	kEffectNameAtom	1851878757
public static final int	kEffectOffsetValue	1868981875
public static final int	kEffectPercentage	1885564532
public static final int	kEffectPreMultiplyAlpha	2
public static final int	kEffectPreMultiplyColor	1835232370
public static final int	kEffectRawSource	0
public static final int	kEffectReverseAlpha	3
public static final int	kEffectSlideAngle	1634625388
public static final int	kEffectSoftBorder	1936680564
public static final int	kEffectSourceName	1936876320
public static final int	kEffectSrcAtom	1936876320
public static final int	kEffectStraightAlpha	1
public static final int	kEffectTopAlphaPin	1885957716
public static final int	kEffectTypeAtom	1954115685
public static final int	kEffectVerticalRepeat	1986359924
public static final int	kEffectWhatAtom	2003329396
public static final int	kEffectWipe	2003847492
public static final int	kEmbossImageFilterType	1701667443
public static final int	kEventLen	1
public static final int	kEventLengthFieldPos	30
public static final int	kEventLengthFieldWidth	2
public static final int	kEventPartFieldPos	24
public static final int	kEventPartFieldWidth	5
public static final int	kEventTypeFieldPos	29
public static final int	kEventTypeFieldWidth	3
public static final int	kExplodeTransitionType	2020633711
public static final int	kExpressionContainerAtomType	1702391922
public static final int	kFieldInfoImageDescriptionExtension	1718183276
public static final int	kFieldOrderUnknown	0
public static final int	kFieldsStoredF1F2DisplayedF1F2	1
public static final int	kFieldsStoredF1F2DisplayedF2F1	2
public static final int	kFieldsStoredF2F1DisplayedF1F2	5
public static final int	kFieldsStoredF2F1DisplayedF2F1	6
public static final int	kFilmNoiseImageFilterType	1718447731
public static final int	kFireCodecType	1718186597
public static final int	kFirstDrumkit	16385
public static final int	kFirstGMInstrument	1
public static final int	kFirstGSInstrument	129
public static final int	kFirstROMInstrument	32768
public static final int	kFirstUserInstrument	65536
public static final int	kFLCCodecType	1718380899
public static final int	kFlushFirstQueuedFrame	1
public static final int	kFlushLastQueuedFrame	0
public static final int	kFMSComponentSubType	1179472672
public static final int	kGeneralEventAtomicInstrument	6
public static final int	kGeneralEventKnob	7
public static final int	kGeneralEventLen	2
public static final int	kGeneralEventLengthBits	3
public static final int	kGeneralEventLengthFieldPos	0
public static final int	kGeneralEventLengthFieldWidth	16
public static final int	kGeneralEventMIDIChannel	8
public static final int	kGeneralEventNoOp	10
public static final int	kGeneralEventNoteRequest	1
public static final int	kGeneralEventPartChange	9
public static final int	kGeneralEventPartKey	4
public static final int	kGeneralEventPartMix	12
public static final int	kGeneralEventSubtypeFieldPos	16
public static final int	kGeneralEventSubtypeFieldWidth	14
public static final int	kGeneralEventTuneDifference	5
public static final int	kGeneralEventType	15
public static final int	kGeneralEventUsedNotes	11
public static final int	kGetAtomicInstAllKnobs	32
public static final int	kGetAtomicInstNoExpandedSamples	1
public static final int	kGetAtomicInstNoInstrumentInfo	8
public static final int	kGetAtomicInstNoKnobList	4
public static final int	kGetAtomicInstNoOriginalSamples	2
public static final int	kGetAtomicInstNoSamples	3
public static final int	kGetAtomicInstOriginalKnobList	16
public static final int	kGetInstrumentInfoMidiUserInst	2
public static final int	kGetInstrumentInfoNoBuiltIn	1
public static final int	kGetInstrumentInfoNoIText	4
public static final int	kGetMovieImporterAllowNewFile	2
public static final int	kGetMovieImporterDontConsiderGraphicsImporters	4
public static final int	kGetMovieImporterValidateToFind	1
public static final int	kGIFCodecType	1734960672
public static final int	kGKON	1196117838
public static final int	kGMSynthComponentSubType	1735204896
public static final int	kGradientTransitionType	1835103348
public static final int	kGraphicsCodecType	1936548640
public static final int	kGraphicsExportDescription	1684370275
public static final int	kGraphicsExportExtension	1702392864
public static final int	kGraphicsExportFileType	1718909296
public static final int	kGraphicsExportGroup	1702391919
public static final int	kGraphicsExportMIMEType	1835625829
public static final int	kGraphicsFlagsGray	1
public static final int	kGraphicsNoFlags	0
public static final int	kGroupAlignText	65536
public static final int	kGroupMatrix	262144
public static final int	kGroupNoFlags	0
public static final int	kGroupNoName	524288
public static final int	kGroupSurroundBox	131072
public static final int	kH261CodecType	1748121137
public static final int	kH263CodecType	1748121139
public static final int	kHSLColorBalanceImageFilterType	1752394850
public static final int	kImageCodecSettingsFieldCount	1718183276
public static final int	kImageCodecSettingsFieldOrdering	1717858157
public static final int	kImageCodecSettingsFieldOrderingF1F2	1
public static final int	kImageCodecSettingsFieldOrderingF2F1	2
public static final int	kImplodeTransitionType	1836084335
public static final int	kInitialRotationAtom	1768845935
public static final int	kInputMapSubInputID	1937072745
public static final int	kInstKnobMissingDefault	1
public static final int	kInstKnobMissingUnknown	0
public static final int	kInstrumentComponentType	1768846196
public static final int	kInstrumentExactMatch	2
public static final int	kInstrumentMatchGMNumber	16
public static final int	kInstrumentMatchGSNumber	32
public static final int	kInstrumentMatchName	4
public static final int	kInstrumentMatchNumber	8
public static final int	kInstrumentMatchSynthesizerName	2
public static final int	kInstrumentMatchSynthesizerType	1
public static final int	kInstrumentRecommendedSubstitute	1
public static final int	kInstrumentRoland8BitQuality	5
public static final int	kIrisTransitionType	1936551986
public static final int	kITextAtomType	1769240692
public static final int	kITextRemoveEverythingBut	0
public static final int	kITextRemoveLeaveSuggestedAlternate	2
public static final int	kITextStringAtomType	1952807028
public static final int	kJPEGCodecType	1785750887
public static final int	kJPEGHuffmanTablesImageDescriptionExtension	1835690100
public static final int	kJPEGQuantizationTablesImageDescriptionExtension	1835692404
public static final int	kKeyFrameAndAllOverrides	4
public static final int	kKeyFrameAndSingleOverride	2
public static final int	kKnobBasic	8
public static final int	kKnobEventKnobFieldPos	16
public static final int	kKnobEventKnobFieldWidth	14
public static final int	kKnobEventType	11
public static final int	kKnobEventValueHighFieldPos	0
public static final int	kKnobEventValueHighFieldWidth	16
public static final int	kKnobEventValueLowFieldPos	0
public static final int	kKnobEventValueLowFieldWidth	16
public static final int	kKnobFixedPoint16	2048
public static final int	kKnobFixedPoint8	1024
public static final int	kKnobGroupStart	128
public static final int	kKnobInterruptUnsafe	32
public static final int	kKnobKeyrangeOverride	64
public static final int	kKnobReadOnly	16
public static final int	kKnobTypeBoolean	8192
public static final int	kKnobTypeButton	40960
public static final int	kKnobTypeGroupName	4096
public static final int	kKnobTypeHertz	36864
public static final int	kKnobTypeInstrument	20480
public static final int	kKnobTypeMilliseconds	28672
public static final int	kKnobTypeNote	12288
public static final int	kKnobTypeNumber	0
public static final int	kKnobTypePan	16384
public static final int	kKnobTypePercentage	32768
public static final int	kKnobTypeSetting	24576
public static final int	kLastDrumkit	16512
public static final int	kLastGMInstrument	128
public static final int	kLastGSInstrument	16383
public static final int	kLastROMInstrument	65535
public static final int	kLastUserInstrument	131071
public static final int	kLinearGradient	0
public static final int	kListElementDataType	1684108409
public static final int	kListElementType	1954115685
public static final int	kMacPaintCodecType	1346589767
public static final int	kMarkerEventBeat	1
public static final int	kMarkerEventEnd	0
public static final int	kMarkerEventLen	1
public static final int	kMarkerEventSubtypeFieldPos	16
public static final int	kMarkerEventSubtypeFieldWidth	8
public static final int	kMarkerEventTempo	2
public static final int	kMarkerEventType	3
public static final int	kMarkerEventValueFieldPos	0
public static final int	kMarkerEventValueFieldWidth	16
public static final int	kMatrixTransitionType	1936551988
public static final int	kMCIEColorTable	256
public static final int	kMCIEDepressedButtonPicture	3
public static final int	kMCIEDisabledButtonPicture	2
public static final int	kMCIEDisabledSizeBoxPicture	5
public static final int	kMCIEDisabledUnavailableButtonPicture	7
public static final int	kMCIEDoButtonIconsDropOnDepress	258
public static final int	kMCIEEnabledButtonPicture	1
public static final int	kMCIEEnabledSizeBoxPicture	4
public static final int	kMCIEEnabledUnavailableButtonPicture	6
public static final int	kMCIEIsFlatAppearance	257
public static final int	kMCIESoundSlider	128
public static final int	kMCIESoundThumb	129
public static final int	kMediaPropertyHasActions	105
public static final int	kMediaPropertyNonLinearAtomType	1852796524
public static final int	kMediaVideoParamBlackLevel	6
public static final int	kMediaVideoParamBrightness	1
public static final int	kMediaVideoParamContrast	2
public static final int	kMediaVideoParamHue	3
public static final int	kMediaVideoParamSaturation	5
public static final int	kMediaVideoParamSharpness	4
public static final int	kMediaVideoParamWhiteLevel	7
public static final int	kMicrosoftVideo1CodecType	1836283491
public static final int	kMIDIAftertouch	208
public static final int	kMIDIBeginSystemExclusive	240
public static final int	kMIDIChannel1	0
public static final int	kMIDIChannel10	9
public static final int	kMIDIChannel11	10
public static final int	kMIDIChannel12	11
public static final int	kMIDIChannel13	12
public static final int	kMIDIChannel14	13
public static final int	kMIDIChannel15	14
public static final int	kMIDIChannel16	15
public static final int	kMIDIChannel2	1
public static final int	kMIDIChannel3	2
public static final int	kMIDIChannel4	3
public static final int	kMIDIChannel5	4
public static final int	kMIDIChannel6	5
public static final int	kMIDIChannel7	6
public static final int	kMIDIChannel8	7
public static final int	kMIDIChannel9	8
public static final int	kMIDIChannelPressure	208
public static final int	kMIDIControlChange	176
public static final int	kMIDIEndSystemExclusive	247
public static final int	kMIDIImport20Playable	4
public static final int	kMIDIImportSilenceAfter	2
public static final int	kMIDIImportSilenceBefore	1
public static final int	kMIDIImportWantLyrics	8
public static final int	kMIDIManagerComponentSubType	1835886450
public static final int	kMIDINoteOff	128
public static final int	kMIDINoteOn	144
public static final int	kMIDIPitchBend	224
public static final int	kMIDIPolyPressure	160
public static final int	kMIDIProgramChange	192
public static final int	kMimeInfoDescriptionTag	1684370275
public static final int	kMimeInfoDoNotOverrideExistingFileTypeAssociation	1852794465
public static final int	kMimeInfoFileExtensionTag	1702392864
public static final int	kMimeInfoFileTypeTag	1718909296
public static final int	kMimeInfoGroupTag	1735552880
public static final int	kMimeInfoMimeTypeTag	1835625829
public static final int	kMotionJPEGACodecType	1835692129
public static final int	kMotionJPEGBCodecType	1835692130
public static final int	kMotionJPEGTag	1835692135
public static final int	kMovieExportAbsoluteTime	1
public static final int	kMovieExportRelativeTime	2
public static final int	kMovieExportTextOnly	0
public static final int	kMoviePlayer	1414942532
public static final int	kMovieVersion	0
public static final int	kMShp	1297311856
public static final int	kMusicComponentType	1836413801
public static final int	kMusicLoopTypeNormal	0
public static final int	kMusicLoopTypePalindrome	1
public static final int	kMusicPacketPortFound	2
public static final int	kMusicPacketPortLost	1
public static final int	kMusicPacketTimeGap	3
public static final int	kNameAtom	1851878757
public static final int	kNewImageGWorldErase	1
public static final int	kNoAtom	1852796517
public static final int	kNoDrumKit	16384
public static final int	kNoMaximumLongFixed	-2147483648
public static final int	kNoMinimumLongFixed	2147483647
public static final int	kNonLinearTweenHeader	1852601448
public static final int	kNoPrecision	-1
public static final int	kNoQTIdleEvents	-1
public static final int	kNoScaleLongFixed	0
public static final int	kNoteAllocatorComponentType	1852798049
public static final int	kNoteEventDurationFieldPos	0
public static final int	kNoteEventDurationFieldWidth	11
public static final int	kNoteEventDurationMax	2047
public static final int	kNoteEventLen	1
public static final int	kNoteEventPitchFieldPos	18
public static final int	kNoteEventPitchFieldWidth	6
public static final int	kNoteEventPitchOffset	32
public static final int	kNoteEventType	1
public static final int	kNoteEventVolumeFieldPos	11
public static final int	kNoteEventVolumeFieldWidth	7
public static final int	kNoteEventVolumeOffset	0
public static final int	kNoteRequestNoGM	1
public static final int	kNoteRequestNoSynthType	2
public static final int	kNoteRequestSynthMustMatch	4
public static final int	kOMSComponentSubType	1330467616
public static final int	kOnlyDrawToSpriteWorld	1
public static final int	kOpenDMLJPEGCodecType	1684890161
public static final int	kOperandAtomType	1869640302
public static final int	kOperandConstant	2
public static final int	kOperandExpression	1
public static final int	kOperandKeyIsDown	5122
public static final int	kOperandMouseLocalHLoc	5120
public static final int	kOperandMouseLocalVLoc	5121
public static final int	kOperandMovieIsLooping	1026
public static final int	kOperandMovieLoopIsPalindrome	1027
public static final int	kOperandMovieRate	1025
public static final int	kOperandMovieTime	1028
public static final int	kOperandMovieVolume	1024
public static final int	kOperandQTVRFieldOfView	4098
public static final int	kOperandQTVRNodeID	4099
public static final int	kOperandQTVRPanAngle	4096
public static final int	kOperandQTVRTiltAngle	4097
public static final int	kOperandRandom	5123
public static final int	kOperandSpriteBoundsBottom	3075
public static final int	kOperandSpriteBoundsLeft	3072
public static final int	kOperandSpriteBoundsRight	3074
public static final int	kOperandSpriteBoundsTop	3073
public static final int	kOperandSpriteFirstCornerX	3084
public static final int	kOperandSpriteFirstCornerY	3085
public static final int	kOperandSpriteFourthCornerX	3090
public static final int	kOperandSpriteFourthCornerY	3091
public static final int	kOperandSpriteID	3082
public static final int	kOperandSpriteImageIndex	3076
public static final int	kOperandSpriteImageRegistrationPointX	3092
public static final int	kOperandSpriteImageRegistrationPointY	3093
public static final int	kOperandSpriteIndex	3083
public static final int	kOperandSpriteLayer	3078
public static final int	kOperandSpriteSecondCornerX	3086
public static final int	kOperandSpriteSecondCornerY	3087
public static final int	kOperandSpriteThirdCornerX	3088
public static final int	kOperandSpriteThirdCornerY	3089
public static final int	kOperandSpriteTrackNumImages	3081
public static final int	kOperandSpriteTrackNumSprites	3080
public static final int	kOperandSpriteTrackVariable	3079
public static final int	kOperandSpriteVisible	3077
public static final int	kOperandTrackBalance	2049
public static final int	kOperandTrackEnabled	2050
public static final int	kOperandTrackHeight	2053
public static final int	kOperandTrackLayer	2051
public static final int	kOperandTrackVolume	2048
public static final int	kOperandTrackWidth	2052
public static final int	kOperatorAbsoluteValue	1633841952
public static final int	kOperatorAdd	1633969184
public static final int	kOperatorAnd	1634624544
public static final int	kOperatorAtomType	1869636978
public static final int	kOperatorDivide	1684633120
public static final int	kOperatorEqualTo	1025515552
public static final int	kOperatorGreaterThan	1042292768
public static final int	kOperatorGreaterThanEqualTo	1044193312
public static final int	kOperatorIntegerDivide	1768188278
public static final int	kOperatorLessThan	1008738336
public static final int	kOperatorLessThanEqualTo	1010638880
public static final int	kOperatorModulo	1836016672
public static final int	kOperatorMultiply	1836412020
public static final int	kOperatorNegate	1852139296
public static final int	kOperatorNot	1852797984
public static final int	kOperatorNotEqualTo	557654048
public static final int	kOperatorOr	1869750304
public static final int	kOperatorSubtract	1937072672
public static final int	kParameterAlternateCodecID	1
public static final int	kParameterAlternateCodecName	1937072755
public static final int	kParameterAlternateDataType	1634497585
public static final int	kParameterAtomTypeAndID	1954115685
public static final int	kParameterDataBehavior	1684632684
public static final int	kParameterDataDefaultItem	1684434036
public static final int	kParameterDataRange	1918987879
public static final int	kParameterDataType	1684108385
public static final int	kParameterDataUsage	1970496800
public static final int	kParameterDependencyID	1
public static final int	kParameterDependencyName	1684366704
public static final int	kParameterEnumList	1701737837
public static final int	kParameterImageNoFlags	0
public static final int	kParameterInfoCopyright	-1453100935
public static final int	kParameterInfoDescription	-1452708250
public static final int	kParameterInfoIDs	1
public static final int	kParameterInfoLongName	-1452383891
public static final int	kParameterInfoManufacturer	-1452449426
public static final int	kParameterInfoPicture	-1452250760
public static final int	kParameterInfoWindowTitle	-1451790732
public static final int	kParameterItemCheckBox	1667786104
public static final int	kParameterItemColorPicker	1885954923
public static final int	kParameterItemControl	1668183148
public static final int	kParameterItemDragImage	1768776039
public static final int	kParameterItemEditDouble	1685026146
public static final int	kParameterItemEditFixed	1718188132
public static final int	kParameterItemEditLong	1819242087
public static final int	kParameterItemEditText	1701079412
public static final int	kParameterItemGroupDivider	1684633193
public static final int	kParameterItemLine	1818848869
public static final int	kParameterItemPopUp	1886351477
public static final int	kParameterItemRadioCluster	1918985321
public static final int	kParameterItemStaticText	1937006964
public static final int	kParameterListDependsUponColorProfiles	1886547814
public static final int	kParameterListDependsUponFonts	1718578804
public static final int	kParameterRepeatableFalse	0
public static final int	kParameterRepeatableID	1
public static final int	kParameterRepeatableName	1885697125
public static final int	kParameterRepeatableTrue	1
public static final int	kParameterSourceCountID	1
public static final int	kParameterSourceCountName	1936876403
public static final int	kParameterTitleID	1
public static final int	kParameterTitleName	1851878757
public static final int	kParameterTypeDataBitField	1651470188
public static final int	kParameterTypeDataColorValue	1668115570
public static final int	kParameterTypeDataCubic	1668637289
public static final int	kParameterTypeDataDouble	11
public static final int	kParameterTypeDataEnum	1701737837
public static final int	kParameterTypeDataFixed	3
public static final int	kParameterTypeDataImage	1768776039
public static final int	kParameterTypeDataLong	2
public static final int	kParameterTypeDataNURB	1853190754
public static final int	kParameterTypeDataRGBValue	8
public static final int	kParameterTypeDataText	1952807028
public static final int	kParameterUsage3by3Matrix	862091571
public static final int	kParameterUsage3DPoint	2021227040
public static final int	kParameterUsageDegrees	1684367218
public static final int	kParameterUsageMicroseconds	-1250728605
public static final int	kParameterUsageMilliseconds	1836279139
public static final int	kParameterUsagePercent	1885564532
public static final int	kParameterUsagePixels	1885960300
public static final int	kParameterUsagePoint	2021204000
public static final int	kParameterUsageRadians	1918985331
public static final int	kParameterUsageRectangle	1919247220
public static final int	kParameterUsageSeconds	1936024435
public static final int	kParameterValidationFinalValidation	1
public static final int	kParameterValidationNoFlags	0
public static final int	kParameterVersionID	1
public static final int	kParameterVersionName	1986359923
public static final int	kParameterWhatID	1
public static final int	kParameterWhatName	2003329396
public static final int	kParentAtomIsContainer	0
public static final int	kPhotoCDCodecType	1802527588
public static final int	kPhotoshop	943868237
public static final int	kPickDontMix	1
public static final int	kPickEditAllowEdit	8
public static final int	kPickEditAllowPick	16
public static final int	kPickEditControllers	64
public static final int	kPickEditSynthGlobal	32
public static final int	kPickSameSynth	2
public static final int	kPickUserInsts	4
public static final int	kPictureCompressor	1886419049
public static final int	kPlanarRGBCodecType	943870035
public static final int	kPopupStoreAsString	65536
public static final int	kPushTransitionType	1886745448
public static final int	kQTColorSyncProfile	1768121197
public static final int	kQTDontRecompress	1684960370
public static final int	kQTEventFrameLoaded	1718772077
public static final int	kQTEventIdle	1768189029
public static final int	kQTEventMouseClick	1668049259
public static final int	kQTEventMouseClickEnd	1667591780
public static final int	kQTEventMouseClickEndTriggerButton	1953655143
public static final int	kQTEventMouseEnter	1701737586
public static final int	kQTEventMouseExit	1702390132
public static final int	kQTEventRequestToModifyMovie	1919250797
public static final int	kQTEventType	1702260340
public static final int	kQTFileType3DMF	860114246
public static final int	kQTFileTypeAIFC	1095321155
public static final int	kQTFileTypeAIFF	1095321158
public static final int	kQTFileTypeAudioCDTrack	1953653099
public static final int	kQTFileTypeAVI	1449547552
public static final int	kQTFileTypeBMP	1112363110
public static final int	kQTFileTypeDVC	1685480225
public static final int	kQTFileTypeGIF	1195984486
public static final int	kQTFileTypeJFIF	1246774599
public static final int	kQTFileTypeJPEG	1246774599
public static final int	kQTFileTypeMacPaint	1347310663
public static final int	kQTFileTypeMIDI	1298752617
public static final int	kQTFileTypeMovie	1299148630
public static final int	kQTFileTypeMuLaw	1431060823
public static final int	kQTFileTypePhotoShop	943870035
public static final int	kQTFileTypePICS	1346978643
public static final int	kQTFileTypePicture	1346978644
public static final int	kQTFileTypeQuickDrawGXPicture	1902405496
public static final int	kQTFileTypeQuickTimeImage	1903454566
public static final int	kQTFileTypeSGIImage	777209673
public static final int	kQTFileTypeSoundDesignerII	1399075430
public static final int	kQTFileTypeSystemSevenSound	1936091500
public static final int	kQTFileTypeTargaImage	1414547779
public static final int	kQTFileTypeText	1413830740
public static final int	kQTFileTypeWave	1463899717
public static final int	kQTInterlaceStyle	6909027
public static final int	kQTMIDIComponentType	1835623529
public static final int	kQTMSKnobEnv1AttackTimeID	33554471
public static final int	kQTMSKnobEnv1DecayTimeID	33554472
public static final int	kQTMSKnobEnv1ExpOptionsID	33554477
public static final int	kQTMSKnobEnv1ReleaseTimeID	33554476
public static final int	kQTMSKnobEnv1SustainInfiniteID	33554475
public static final int	kQTMSKnobEnv1SustainLevelID	33554473
public static final int	kQTMSKnobEnv1SustainTimeID	33554474
public static final int	kQTMSKnobEnv2AttackTimeID	33554478
public static final int	kQTMSKnobEnv2DecayTimeID	33554479
public static final int	kQTMSKnobEnv2ExpOptionsID	33554484
public static final int	kQTMSKnobEnv2ReleaseTimeID	33554483
public static final int	kQTMSKnobEnv2SustainInfiniteID	33554482
public static final int	kQTMSKnobEnv2SustainLevelID	33554480
public static final int	kQTMSKnobEnv2SustainTimeID	33554481
public static final int	kQTMSKnobExclusionGroupID	33554460
public static final int	kQTMSKnobFilterFrequencyEnvelopeDepthID	33554491
public static final int	kQTMSKnobFilterFrequencyEnvelopeID	33554490
public static final int	kQTMSKnobFilterKeyFollowID	33554487
public static final int	kQTMSKnobFilterQEnvelopeDepthID	33554493
public static final int	kQTMSKnobFilterQEnvelopeID	33554492
public static final int	kQTMSKnobFilterQID	33554489
public static final int	kQTMSKnobFilterTransposeID	33554488
public static final int	kQTMSKnobLastIDPlus1	33554496
public static final int	kQTMSKnobPitchEnvelopeDepthID	33554486
public static final int	kQTMSKnobPitchEnvelopeID	33554485
public static final int	kQTMSKnobPitchLFODelayID	33554451
public static final int	kQTMSKnobPitchLFODepthFromWheelID	33554469
public static final int	kQTMSKnobPitchLFODepthID	33554455
public static final int	kQTMSKnobPitchLFOOffsetID	33554459
public static final int	kQTMSKnobPitchLFOPeriodID	33554453
public static final int	kQTMSKnobPitchLFOQuantizeID	33554456
public static final int	kQTMSKnobPitchLFORampTimeID	33554452
public static final int	kQTMSKnobPitchLFOShapeID	33554454
public static final int	kQTMSKnobPitchSensitivityID	33554467
public static final int	kQTMSKnobPitchTransposeID	33554450
public static final int	kQTMSKnobReverbThresholdID	33554494
public static final int	kQTMSKnobStartID	33554432
public static final int	kQTMSKnobStereoDefaultPanID	33554457
public static final int	kQTMSKnobStereoPositionKeyScalingID	33554458
public static final int	kQTMSKnobSustainInfiniteID	33554462
public static final int	kQTMSKnobSustainTimeID	33554461
public static final int	kQTMSKnobVelocityHighID	33554465
public static final int	kQTMSKnobVelocityLowID	33554464
public static final int	kQTMSKnobVelocitySensitivityID	33554466
public static final int	kQTMSKnobVolumeAttackTimeID	33554433
public static final int	kQTMSKnobVolumeAttackVelScalingID	33554495
public static final int	kQTMSKnobVolumeDecayKeyScalingID	33554437
public static final int	kQTMSKnobVolumeDecayTimeID	33554434
public static final int	kQTMSKnobVolumeExpOptionsID	33554470
public static final int	kQTMSKnobVolumeLFODelayID	33554439
public static final int	kQTMSKnobVolumeLFODepthFromWheelID	33554468
public static final int	kQTMSKnobVolumeLFODepthID	33554443
public static final int	kQTMSKnobVolumeLFOPeriodID	33554441
public static final int	kQTMSKnobVolumeLFORampTimeID	33554440
public static final int	kQTMSKnobVolumeLFOShapeID	33554442
public static final int	kQTMSKnobVolumeLFOStereoID	33554463
public static final int	kQTMSKnobVolumeOverallID	33554444
public static final int	kQTMSKnobVolumeRelease1RateID	33554436
public static final int	kQTMSKnobVolumeReleaseTimeID	33554438
public static final int	kQTMSKnobVolumeSustainLevelID	33554435
public static final int	kQTMSKnobVolumeVelocity127ID	33554445
public static final int	kQTMSKnobVolumeVelocity16ID	33554449
public static final int	kQTMSKnobVolumeVelocity32ID	33554448
public static final int	kQTMSKnobVolumeVelocity64ID	33554447
public static final int	kQTMSKnobVolumeVelocity96ID	33554446
public static final int	kQTPNGFilterAdaptivePerRow	1634102388
public static final int	kQTPNGFilterAverage	3
public static final int	kQTPNGFilterBestForColorType	1650879604
public static final int	kQTPNGFilterNone	0
public static final int	kQTPNGFilterPaeth	4
public static final int	kQTPNGFilterPreference	1835952486
public static final int	kQTPNGFilterSub	1
public static final int	kQTPNGFilterUp	2
public static final int	kQTPNGInterlaceAdam7	1
public static final int	kQTPNGInterlaceNone	0
public static final int	kQTPNGInterlaceStyle	6909027
public static final int	kQTResolutionSettings	1919251311
public static final int	kQTSettingsAudioCDTrack	1953653099
public static final int	kQTSettingsAudioCDTrackRateShift	1920165990
public static final int	kQTSettingsEffect	1701209701
public static final int	kQTSettingsMIDI	1296647241
public static final int	kQTSettingsMIDISettingFlags	1937011815
public static final int	kQTSettingsSound	1936684398
public static final int	kQTSettingsText	1952807028
public static final int	kQTSettingsTextDescription	1684370275
public static final int	kQTSettingsTextSettingFlags	1937011815
public static final int	kQTSettingsTextSize	1936292453
public static final int	kQTSettingsTextTimeFraction	1953066342
public static final int	kQTSettingsTime	1953066341
public static final int	kQTSettingsVideo	1986618469
public static final int	kQTTargetDataSize	1684108154
public static final int	kQTTIFFCompression_None	1
public static final int	kQTTIFFCompressionMethod	1953064547
public static final int	kQTTIFFLittleEndian	1953064549
public static final int	kQTVideoOutputDontDisplayToUser	1
public static final int	kQTVODecompressorComponent	1668116596
public static final int	kQTVODecompressorContinuous	1668247156
public static final int	kQTVODecompressors	1684366191
public static final int	kQTVODecompressorType	1684370553
public static final int	kQTVODimensions	1684630894
public static final int	kQTVODisplayModeItem	1902407017
public static final int	kQTVOName	1851878757
public static final int	kQTVOPixelType	1885960300
public static final int	kQTVORefreshRate	1919247986
public static final int	kQTVOResolution	1919251308
public static final int	kQuickDrawCodecType	1902408311
public static final int	kQuickDrawGXCodecType	1902405496
public static final int	kRadialTransitionType	1936551987
public static final int	kRandomWipeTransitionType	409
public static final int	kRawCodecType	1918990112
public static final int	kRestEventDurationFieldPos	0
public static final int	kRestEventDurationFieldWidth	24
public static final int	kRestEventDurationMax	16777215
public static final int	kRestEventLen	1
public static final int	kRestEventType	0
public static final int	kRGBColorBalanceImageFilterType	1919378018
public static final int	kScaleSpritesToScaleWorld	2
public static final int	kScreenFloodMethodAlpha	2
public static final int	kScreenFloodMethodKeyColor	1
public static final int	kScreenFloodMethodNone	0
public static final int	kSetAtomicInstCallerGuarantees	8
public static final int	kSetAtomicInstCallerTosses	4
public static final int	kSetAtomicInstDontPreprocess	128
public static final int	kSetAtomicInstInterruptSafe	16
public static final int	kSetAtomicInstKeepOriginalInstrument	1
public static final int	kSetAtomicInstShareAcrossParts	2
public static final int	kSGICodecType	777209673
public static final int	kSharpenImageFilterType	1936224880
public static final int	kSlideTransitionType	1936484708
public static final int	kSoftSynthComponentSubType	1936924704
public static final int	kSolarizeImageFilterType	1936682098
public static final int	kSorensonCodecType	1398165809
public static final int	kSpriteAtomType	1936749172
public static final int	kSpriteImageAtomType	1768776039
public static final int	kSpriteImageDataAtomType	1768776801
public static final int	kSpriteImageGroupIDAtomType	1768777586
public static final int	kSpriteImageNameAtomType	1851878757
public static final int	kSpriteImagePropertyGroupID	1001
public static final int	kSpriteImagePropertyRegistrationPoint	1000
public static final int	kSpriteImageRegistrationAtomType	1768780391
public static final int	kSpriteImagesContainerAtomType	1768776564
public static final int	kSpriteNameAtomType	1851878757
public static final int	kSpritePropertyGraphicsMode	6
public static final int	kSpritePropertyImageDataPtr	3
public static final int	kSpritePropertyImageDataSize	7
public static final int	kSpritePropertyImageDescription	2
public static final int	kSpritePropertyImageIndex	100
public static final int	kSpritePropertyLayer	5
public static final int	kSpritePropertyMatrix	1
public static final int	kSpritePropertyVisible	4
public static final int	kSpriteSharedDataAtomType	1684434036
public static final int	kSpriteTrackPropertyBackgroundColor	101
public static final int	kSpriteTrackPropertyHasActions	105
public static final int	kSpriteTrackPropertyOffscreenBitDepth	102
public static final int	kSpriteTrackPropertyQTIdleEventsFrequency	107
public static final int	kSpriteTrackPropertySampleFormat	103
public static final int	kSpriteTrackPropertyScaleSpritesToScaleWorld	104
public static final int	kSpriteTrackPropertyVisible	106
public static final int	kSpriteUsesImageIDsAtomType	1970496883
public static final int	kSpriteWorldDidDraw	1
public static final int	kSpriteWorldDontAutoInvalidate	8
public static final int	kSpriteWorldHighQuality	4
public static final int	kSpriteWorldInvisible	16
public static final int	kSpriteWorldNeedsToDraw	2
public static final int	kSpriteWorldPreflight	2
public static final int	kSynthesizerConnectionFMS	16
public static final int	kSynthesizerConnectionMMgr	2
public static final int	kSynthesizerConnectionMono	1
public static final int	kSynthesizerConnectionOMS	4
public static final int	kSynthesizerConnectionQT	8
public static final int	kSynthesizerConnectionUnavailable	256
public static final int	kSynthesizerDLS	32768
public static final int	kSynthesizerDynamicChannel	128
public static final int	kSynthesizerDynamicVoice	1
public static final int	kSynthesizerGM	16384
public static final int	kSynthesizerHardware	64
public static final int	kSynthesizerHasSamples	8
public static final int	kSynthesizerHasSystemChannel	512
public static final int	kSynthesizerHogsSystemChannel	256
public static final int	kSynthesizerMicrotone	4
public static final int	kSynthesizerMixedDrums	16
public static final int	kSynthesizerOffline	4096
public static final int	kSynthesizerSlowSetPart	1024
public static final int	kSynthesizerSoftware	32
public static final int	kSynthesizerSoundLocalization	65536
public static final int	kSynthesizerUsesMIDIPort	2
public static final int	kTargaCodecType	1952932128
public static final int	kTargetMovie	1836019574
public static final int	kTargetSpriteID	1936746852
public static final int	kTargetSpriteIndex	1936746862
public static final int	kTargetSpriteName	1936748129
public static final int	kTargetTrackID	1953655140
public static final int	kTargetTrackIndex	1953655150
public static final int	kTargetTrackName	1953656417
public static final int	kTargetTrackType	1953657977
public static final int	kTeachText	1953785204
public static final int	kTrackModifierCameraData	9
public static final int	kTrackModifierInput	26990
public static final int	kTrackModifierInputName	1851878757
public static final int	kTrackModifierObjectGraphicsMode	7
public static final int	kTrackModifierObjectID	1868720484
public static final int	kTrackModifierObjectImageIndex	11
public static final int	kTrackModifierObjectLayer	12
public static final int	kTrackModifierObjectMatrix	6
public static final int	kTrackModifierObjectQTEventSend	1702260340
public static final int	kTrackModifierObjectVisible	13
public static final int	kTrackModifierPanAngle	1885433376
public static final int	kTrackModifierReference	1936945763
public static final int	kTrackModifierSoundLocalizationData	10
public static final int	kTrackModifierTiltAngle	1953066100
public static final int	kTrackModifierType	29817
public static final int	kTrackModifierType3d4x4Matrix	8
public static final int	kTrackModifierTypeBalance	4
public static final int	kTrackModifierTypeClip	2
public static final int	kTrackModifierTypeGraphicsMode	5
public static final int	kTrackModifierTypeImage	1986618469
public static final int	kTrackModifierTypeMatrix	1
public static final int	kTrackModifierTypeVolume	3
public static final int	kTrackModifierVerticalFieldOfViewAngle	1718580768
public static final int	kTrackReferenceChapterList	1667785072
public static final int	kTrackReferenceModifier	1936945763
public static final int	kTrackReferenceTimeCode	1953325924
public static final int	kTuneDontClipNotes	2
public static final int	kTuneExcludeEdgeNotes	4
public static final int	kTuneLoopUntil	16
public static final int	kTuneMixMute	1
public static final int	kTuneMixSolo	2
public static final int	kTunePlayConcurrent	64
public static final int	kTunePlayDifference	32
public static final int	kTunePlayerComponentType	1953853029
public static final int	kTuneQuickStart	8
public static final int	kTuneStartNewMaster	16384
public static final int	kTuneStartNow	1
public static final int	kTuneStopFade	1
public static final int	kTuneStopInstant	4
public static final int	kTuneStopReleaseChannels	8
public static final int	kTuneStopSustain	2
public static final int	kTween3dInitialCondition	1768124004
public static final int	kTweenData	1684108385
public static final int	kTweenDuration	1953981557
public static final int	kTweenEntry	1953981806
public static final int	kTweenFlags	1718378855
public static final int	kTweenInterpolateStyle	1769174137
public static final int	kTweenInterpolationID	1768846450
public static final int	kTweenOutputMax	1869439352
public static final int	kTweenOutputMin	1869441390
public static final int	kTweenPictureData	1346978644
public static final int	kTweenRegionData	1902408295
public static final int	kTweenReturnDelta	1
public static final int	kTweenSequenceElement	1936028005
public static final int	kTweenStartOffset	1953985396
public static final int	kTweenType	1953984116
public static final int	kTweenType3dCameraData	862151021
public static final int	kTweenType3dMatrix	862806388
public static final int	kTweenType3dMatrixNonLinear	862874738
public static final int	kTweenType3dQuaternion	863073633
public static final int	kTweenType3dRotate	863137652
public static final int	kTweenType3dRotateAboutAxis	863134072
public static final int	kTweenType3dRotateAboutPoint	863134064
public static final int	kTweenType3dRotateAboutVector	863139427
public static final int	kTweenType3dScale	863200097
public static final int	kTweenType3dSoundLocalizationData	863202403
public static final int	kTweenType3dTranslate	863269473
public static final int	kTweenType3dVRObject	863400559
public static final int	kTweenTypeAtomList	1635020653
public static final int	kTweenTypeFixed	3
public static final int	kTweenTypeFixedPoint	12
public static final int	kTweenTypeFloat	3
public static final int	kTweenTypeGraphicsModeWithRGBColor	9
public static final int	kTweenTypeLong	2
public static final int	kTweenTypeMatrix	7
public static final int	kTweenTypeMultiMatrix	1836412013
public static final int	kTweenTypePathToFixedPoint	1735943792
public static final int	kTweenTypePathToMatrixRotation	1735946354
public static final int	kTweenTypePathToMatrixTranslation	1735945588
public static final int	kTweenTypePathToMatrixTranslationAndRotation	1735945586
public static final int	kTweenTypePathXtoY	1735948409
public static final int	kTweenTypePathYtoX	1735948664
public static final int	kTweenTypePoint	4
public static final int	kTweenTypePolygon	1886350457
public static final int	kTweenTypeQDRect	5
public static final int	kTweenTypeQDRegion	6
public static final int	kTweenTypeQTFloatDouble	11
public static final int	kTweenTypeQTFloatSingle	10
public static final int	kTweenTypeRGBColor	8
public static final int	kTweenTypeShort	1
public static final int	kTweenTypeSpin	1936746862
public static final int	kUndefined1EventType	8
public static final int	kUndefined2EventType	12
public static final int	kUndefined3EventType	13
public static final int	kUndefined4EventType	14
public static final int	kUnknownKnobValue	2147483647
public static final int	kUserDataMovieControllerType	1668577648
public static final int	kUserDataName	1851878757
public static final int	kUserDataTextCopyright	-1453100935
public static final int	kUserDataTextFullName	-1452383891
public static final int	kUserDataTextInformation	-1452708250
public static final int	kVDIGControlledFrameRate	-1
public static final int	kVectorCodecType	1885434984
public static final int	kVendorApple	1634758764
public static final int	kVersionCheckMask	1
public static final int	kVersionCheckMin	0
public static final int	kVideoCodecType	1919973985
public static final int	kVis3	1449751347
public static final int	kVoiceCountDynamic	-1
public static final int	kWaterRippleCodecType	1919512684
public static final int	kWhichAction	2003331427
public static final int	kWindowsRawCodecType	1465008471
public static final int	kWipeTransitionType	1936552052
public static final int	kXControlEventControllerFieldPos	0
public static final int	kXControlEventControllerFieldWidth	16
public static final int	kXControlEventLen	2
public static final int	kXControlEventType	10
public static final int	kXControlEventValueFieldPos	0
public static final int	kXControlEventValueFieldWidth	16
public static final int	kXEventLen	2
public static final int	kXEventLengthBits	2
public static final int	kXEventPartFieldPos	16
public static final int	kXEventPartFieldWidth	12
public static final int	kXEventTypeFieldPos	28
public static final int	kXEventTypeFieldWidth	4
public static final int	kXNoteEventDurationFieldPos	0
public static final int	kXNoteEventDurationFieldWidth	22
public static final int	kXNoteEventDurationMax	4194303
public static final int	kXNoteEventLen	2
public static final int	kXNoteEventPitchFieldPos	0
public static final int	kXNoteEventPitchFieldWidth	16
public static final int	kXNoteEventType	9
public static final int	kXNoteEventVolumeFieldPos	22
public static final int	kXNoteEventVolumeFieldWidth	7
public static final int	linearMatrixType	4
public static final int	linearTranslateMatrixType	5
public static final int	loadBackwardTrackEdits	16
public static final int	loadForwardTrackEdits	8
public static final int	loadSettingsAID	1819238756
public static final int	loopTimeBase	1
public static final int	maintainTimeBaseZero	4
public static final int	mAtEnd	16
public static final int	matrixFlagScale1x	64
public static final int	matrixFlagScale2x	128
public static final int	matrixFlagScaleHalf	32
public static final int	matteAID	1835103348
public static final int	matteCompAID	1802330484
public static final short	mcActionActivate	3
public static final short	mcActionAdjustCursor	65
public static final short	mcActionBadgeClick	44
public static final short	mcActionClickAndHoldPoint	67
public static final short	mcActionControllerSizeChanged	26
public static final short	mcActionCustomButtonClick	60
public static final short	mcActionDeactivate	4
public static final short	mcActionDraw	2
public static final short	mcActionEvaluateExpression	73
public static final short	mcActionExecuteAllActionsForQTEvent	63
public static final short	mcActionExecuteOneActionForQTEvent	64
public static final short	mcActionFetchParameterAs	74
public static final short	mcActionForceTimeTableUpdate	61
public static final short	mcActionGetChapterTime	71
public static final short	mcActionGetCursorByID	75
public static final short	mcActionGetCursorSettingEnabled	56
public static final short	mcActionGetDragEnabled	51
public static final short	mcActionGetExternalMovie	70
public static final short	mcActionGetFlags	39
public static final short	mcActionGetKeysEnabled	33
public static final short	mcActionGetLooping	22
public static final short	mcActionGetLoopIsPalindrome	24
public static final short	mcActionGetNextURL	76
public static final short	mcActionGetPlayEveryFrame	41
public static final short	mcActionGetPlayRate	42
public static final short	mcActionGetPlaySelection	35
public static final short	mcActionGetSelectionBegin	53
public static final short	mcActionGetSelectionDuration	54
public static final short	mcActionGetTimeSliderRect	49
public static final short	mcActionGetUseBadge	37
public static final short	mcActionGetVolume	15
public static final short	mcActionGoToTime	12
public static final short	mcActionIdle	1
public static final short	mcActionKey	6
public static final short	mcActionLinkToURL	59
public static final short	mcActionMouseDown	5
public static final short	mcActionMovieClick	45
public static final short	mcActionMovieEdited	50
public static final short	mcActionPerformActionList	72
public static final short	mcActionPlay	8
public static final short	mcActionPrerollAndPlay	55
public static final short	mcActionResume	47
public static final short	mcActionSetColorTable	58
public static final short	mcActionSetControllerKeysEnabled	48
public static final short	mcActionSetControllerTimeLimits	62
public static final short	mcActionSetCursorSettingEnabled	57
public static final short	mcActionSetDragEnabled	52
public static final short	mcActionSetFlags	38
public static final short	mcActionSetGrowBoxBounds	25
public static final short	mcActionSetKeysEnabled	32
public static final short	mcActionSetLooping	21
public static final short	mcActionSetLoopIsPalindrome	23
public static final short	mcActionSetPlayEveryFrame	40
public static final short	mcActionSetPlaySelection	34
public static final short	mcActionSetSelectionBegin	29
public static final short	mcActionSetSelectionDuration	30
public static final short	mcActionSetUseBadge	36
public static final short	mcActionSetVolume	14
public static final short	mcActionShowBalloon	43
public static final short	mcActionShowMessageString	68
public static final short	mcActionShowStatusString	69
public static final short	mcActionStep	18
public static final short	mcActionSuspend	46
public static final short	mcActionUseTrackForTimeTable	66
public static final int	mcFlagsDontInvalidate	16
public static final int	mcFlagSuppressMovieFrame	1
public static final int	mcFlagSuppressSpeakerButton	4
public static final int	mcFlagSuppressStepButtons	2
public static final int	mcFlagsUseCustomButton	32
public static final int	mcFlagsUseWindowPalette	8
public static final int	mcInfoClearAvailable	16
public static final int	mcInfoCopyAvailable	4
public static final int	mcInfoCutAvailable	2
public static final int	mcInfoEditingEnabled	512
public static final int	mcInfoHasSound	32
public static final int	mcInfoIsInPalindrome	256
public static final int	mcInfoIsLooping	128
public static final int	mcInfoIsPlaying	64
public static final int	mcInfoMovieIsInteractive	1024
public static final int	mcInfoPasteAvailable	8
public static final int	mcInfoUndoAvailable	1
public static final int	mcMenuClear	6
public static final int	mcMenuCopy	4
public static final int	mcMenuCut	3
public static final int	mcMenuPaste	5
public static final int	mcMenuUndo	1
public static final int	mcNotVisible	8
public static final int	mcPositionDontInvalidate	32
public static final int	mcScaleMovieToFit	2
public static final int	mcTopLeftMovie	1
public static final int	mcWithBadge	4
public static final int	mcWithFrame	16
public static final int	mDidDraw	1
public static final int	mDrawAgain	8
public static final int	mediaAID	1835297121
public static final int	mediaHandlerType	1835560050
public static final int	mediaHeaderAID	1835296868
public static final int	mediaInfoAID	1835626086
public static final int	mediaSampleNotSync	1
public static final int	mediaSampleShadowSync	2
public static final int	mHitTestBounds	1
public static final int	mHitTestImage	2
public static final int	mHitTestInvisible	4
public static final int	mHitTestIsClick	8
public static final int	mInvisible	2
public static final int	mMustDraw	8
public static final int	mNeedsToDraw	4
public static final int	mOpaque	1
public static final int	movieAID	1836019574
public static final int	movieBackwardPointerResourceType	1650549611
public static final int	movieBufferHintsAID	1835165288
public static final int	movieControllerComponentType	1886151033
public static final int	movieDataAtomType	1835295092
public static final int	movieDataRefAliasAID	1835299425
public static final int	movieDrawingCallAlways	1
public static final int	movieDrawingCallWhenChanged	0
public static final int	movieExportDuration	1685418593
public static final int	movieExportHeight	1751476084
public static final int	movieExportMustGetSourceMediaType	524288
public static final int	movieExportNeedsResourceFork	131072
public static final int	movieExportType	1936746868
public static final int	movieExportVideoFilter	1768320116
public static final int	movieExportWidth	2003072104
public static final int	movieFileSpecValid	8
public static final int	movieFileType	1299148630
public static final int	movieForwardPointerResourceType	1718579813
public static final int	movieHeaderAID	1836476516
public static final int	movieImportCreateTrack	1
public static final int	movieImportInParallel	2
public static final int	movieImportMustUseTrack	4
public static final int	movieImportResultUsedMultipleTracks	8
public static final int	movieImportSubTypeIsFileExtension	4096
public static final int	movieImportType	1700885536
public static final int	movieInDataForkResID	-1
public static final int	movieResourceAtomType	1836019574
public static final int	movieResourceType	1836019574
public static final int	movieScrapDontZeroScrap	1
public static final int	movieScrapOnlyPutMovie	2
public static final int	movieScrapType	1836019574
public static final int	movieToFileOnlyExport	4
public static final int	movieTrackCharacteristic	2
public static final int	movieTrackEnabledOnly	4
public static final int	movieTrackMediaType	1
public static final int	mPartialDraw	16
public static final int	MPEGMediaType	1297106247
public static final int	mPreflightDraw	32
public static final int	mSyncDrawing	64
public static final int	musicMediaType	1836413801
public static final int	newMovieActive	1
public static final int	newMovieDontAskUnresolvedDataRefs	4
public static final int	newMovieDontAutoAlternates	8
public static final int	newMovieDontResolveDataRefs	2
public static final int	newMovieDontUpdateForeBackPointers	16
public static final int	nextTimeEdgeOK	16384
public static final int	nextTimeIgnoreActiveSegment	32768
public static final int	nextTimeMediaEdit	2
public static final int	nextTimeMediaSample	1
public static final int	nextTimeStep	16
public static final int	nextTimeSyncSample	8
public static final int	nextTimeTrackEdit	4
public static final int	noDefaultOpcodes	4
public static final int	ntscIn	0
public static final int	ntscReallyIn	3
public static final int	oddField1ToEvenFieldOut	4
public static final int	oddField1ToOddFieldOut	8
public static final int	oddField2ToEvenFieldOut	64
public static final int	oddField2ToOddFieldOut	128
public static final int	palIn	1
public static final int	palindromeLoopTimeBase	2
public static final int	pasteInParallel	1
public static final int	pdActionActivateSubPanel	10
public static final int	pdActionConductStopAlert	11
public static final int	pdActionConfirmDialog	1
public static final int	pdActionGetDialogValues	4
public static final int	pdActionGetSubPanelMenu	9
public static final int	pdActionModelessCallback	12
public static final int	pdActionSetAppleMenu	2
public static final int	pdActionSetColorPickerEventProc	7
public static final int	pdActionSetDialogTitle	8
public static final int	pdActionSetEditMenu	3
public static final int	pdActionSetPreviewPicture	6
public static final int	pdActionSetPreviewUserItem	5
public static final int	pdOptionsAllowOptionalInterpolations	2
public static final int	pdOptionsCollectOneValue	1
public static final int	pdOptionsModalDialogBox	4
public static final int	perspectiveMatrixType	6
public static final int	pnotComponentNeedsNoCache	2
public static final int	pnotComponentWantsEvents	1
public static final int	preloadAlways	1
public static final int	preloadOnlyIfEnabled	2
public static final int	propertyAtomAID	1668244581
public static final int	qtcbNeedsRateChanges	1
public static final int	qtcbNeedsStartStopChanges	4
public static final int	qtcbNeedsTimeChanges	2
public static final int	qtVideoOutputComponentBaseSubType	1650553701
public static final int	qtVideoOutputComponentType	1987016052
public static final int	quickTimeImageFileImageDataAtom	1768186228
public static final int	quickTimeImageFileImageDescriptionAtom	1768190819
public static final int	quickTimeImageFileMetaDataAtom	1835365473
public static final int	referenceMovieComponentCheckAID	1919771492
public static final int	referenceMovieDataRateAID	1919771762
public static final int	referenceMovieDataRefAID	1919185510
public static final int	referenceMovieDescriptorAID	1919771745
public static final int	referenceMovieQualityAID	1919775093
public static final int	referenceMovieRecordAID	1919775329
public static final int	referenceMovieVersionCheckAID	1919776355
public static final int	reservedForUseByGraphicsImporters	8388608
public static final int	resourceDataHandlerSubType	1920168547
public static final int	rgbComponentIn	2
public static final int	rgbComponentSyncIn	3
public static final int	rgnClipAID	1668441966
public static final int	sampleTableAID	1937007212
public static final int	scaleMatrixType	2
public static final int	scaleTranslateMatrixType	3
public static final int	scAllowZeroFrameRate	4
public static final int	scAllowZeroKeyFrameRate	8
public static final int	scCancelItem	2
public static final int	scCodecFlagsType	1667656807
public static final int	scCodecManufacturerType	1668114034
public static final int	scCodecSettingsType	1667523939
public static final int	scColorTableType	1668052340
public static final int	scCompressFlagIgnoreIdenticalFrames	1
public static final int	scCompressImage	11
public static final int	scCompressionListType	1668577644
public static final int	scCompressPicture	12
public static final int	scCompressPictureFile	13
public static final int	scCompressSequenceBegin	15
public static final int	scCompressSequenceEnd	17
public static final int	scCompressSequenceFrame	16
public static final int	scCustomItem	3
public static final int	scDataRateSettingsType	1685217652
public static final int	scDefaultPictFileSettings	19
public static final int	scDefaultPictHandleSettings	18
public static final int	scDefaultPixMapSettings	20
public static final int	scDisableFrameRateItem	64
public static final int	scDontDetermineSettingsFromTestImage	4
public static final int	scExtendedProcsType	2020635235
public static final int	scForceKeyValueType	1802725741
public static final int	scGetBestDeviceRect	7
public static final int	scGetCompression	1
public static final int	scGetInfo	21
public static final int	scListEveryCodec	2
public static final int	scNewGWorld	23
public static final int	scOKItem	1
public static final int	scPositionDialog	3
public static final int	scPositionRect	2
public static final int	scPreferCropping	1
public static final int	scPreferenceFlagsType	1886545254
public static final int	scPreferScaling	2
public static final int	scPreferScalingAndCropping	3
public static final int	scProgressProcType	1886547815
public static final int	scRequestImageSettings	10
public static final int	scRequestSequenceSettings	14
public static final int	scSequenceIDType	1936028021
public static final int	scSetInfo	22
public static final int	scSetTestImagePictFile	5
public static final int	scSetTestImagePictHandle	4
public static final int	scSetTestImagePixMap	6
public static final int	scSettingsChangedItem	-1
public static final int	scSettingsStateType	1936946273
public static final int	scShowBestDepth	16
public static final int	scShowMotionSettings	1
public static final int	scSoundChannelCountType	1936941923
public static final int	scSoundCompressionType	1936941940
public static final int	scSoundSampleRateType	1936945780
public static final int	scSoundSampleSizeType	1936946035
public static final int	scSpatialSettingsType	1936749676
public static final int	scTemporalSettingsType	1953526380
public static final int	scTestImageHeight	80
public static final int	scTestImageWidth	80
public static final int	scUseMovableModal	32
public static final int	scUserCancelled	1
public static final int	scWindowPositionType	2003723383
public static final int	sdiIn	7
public static final int	searchTextDontGoToFoundTime	65536
public static final int	searchTextDontHiliteFoundText	131072
public static final int	searchTextEnabledTracksOnly	524288
public static final int	searchTextOneTrackOnly	262144
public static final int	secamIn	2
public static final int	seqGrabAppendToFile	8
public static final int	seqGrabChannelType	1936155496
public static final int	seqGrabComponentType	1650553447
public static final int	seqGrabCompressionPanelType	1668116594
public static final int	seqGrabDataProcDoesOverlappingReads	256
public static final int	seqGrabDataProcIsInterruptSafe	128
public static final int	seqGrabDontAddMovieResource	16
public static final int	seqGrabDontMakeMovie	32
public static final int	seqGrabDontUseTempMemory	4
public static final int	seqGrabHasBounds	1
public static final int	seqGrabHasDiscreteSamples	4
public static final int	seqGrabHasVolume	2
public static final int	seqGrabPanelType	1936158830
public static final int	seqGrabPause	1
public static final int	seqGrabPauseForMenu	3
public static final int	seqGrabPlayDuringRecord	4
public static final int	seqGrabPreExtendFile	64
public static final int	seqGrabPreview	2
public static final int	seqGrabRecord	1
public static final int	seqGrabSettingsPreviewOnly	1
public static final int	seqGrabSourcePanelType	1936684402
public static final int	seqGrabToDisk	1
public static final int	seqGrabToMemory	2
public static final int	seqGrabUnpause	0
public static final int	seqGrabWriteAppend	0
public static final int	seqGrabWriteFill	2
public static final int	seqGrabWriteReserve	1
public static final int	sfpItemCreatePreviewButton	14
public static final int	sfpItemPreviewAreaUser	11
public static final int	sfpItemPreviewDividerUser	13
public static final int	sfpItemPreviewStaticText	12
public static final int	sfpItemShowPreviewButton	15
public static final int	sgChannelAtom	1667785070
public static final int	sgChannelDescription	1667527523
public static final int	sgChannelSettings	1668506996
public static final int	sgChannelSettingsAtom	1668575085
public static final int	sgClipType	1668049264
public static final int	sgcSoundChannelCountType	1935894638
public static final int	sgcSoundCompressionType	1935895920
public static final int	sgcSoundGainType	1734437230
public static final int	sgcSoundInputType	1936289392
public static final int	sgcSoundSampleRateType	1936875892
public static final int	sgcSoundSampleSizeType	1936943482
public static final int	sgcVideoBlackLevelType	1651272556
public static final int	sgcVideoBrigtnessType	1651665268
public static final int	sgcVideoContrastType	1953657716
public static final int	sgcVideoDigitizerType	1986292071
public static final int	sgcVideoFilterType	1986423924
public static final int	sgcVideoFormatType	1987277924
public static final int	sgcVideoHueType	1752524064
public static final int	sgcVideoInputType	1986621040
public static final int	sgcVideoRectType	1987208052
public static final int	sgcVideoSaturationType	1935766642
public static final int	sgcVideoSharpnessType	1936224880
public static final int	sgcVideoWhiteLevelType	2003334252
public static final int	sgDeviceListDontCheckAvailability	2
public static final int	sgDeviceListWithIcons	1
public static final int	sgDeviceNameFlagDeviceUnavailable	1
public static final int	sgDeviceNameType	1851878757
public static final int	sgFlagControlledGrab	1
public static final int	sgMatrixType	1836348024
public static final int	sgPanelDescription	1885631331
public static final int	sgPanelFlagForPanel	1
public static final int	sgPanelSettings	1886610804
public static final int	sgPanelSettingsAtom	1886678893
public static final int	sgPlayFlagsType	1886157158
public static final int	sgUsageType	1970496800
public static final int	sgVolumeType	1987013749
public static final int	showFilePreviewComponentType	1886285684
public static final int	showUserSettingsDialog	2
public static final int	soundLocalizationAID	1936486243
public static final int	soundMediaInfoHeaderAID	1936549988
public static final int	soundMediaType	1936684398
public static final int	spriteHitTestBounds	1
public static final int	spriteHitTestImage	2
public static final int	spriteHitTestInvisibleSprites	4
public static final int	spriteHitTestIsClick	8
public static final int	spriteHitTestLocInDisplayCoordinates	16
public static final int	spriteMediaType	1936749172
public static final int	standardCompressionSubType	1768776039
public static final int	standardCompressionSubTypeSound	1936684398
public static final int	standardCompressionType	1935893609
public static final int	sTChunkOffset64AID	1668232756
public static final int	sTChunkOffsetAID	1937007471
public static final int	sTSampleDescAID	1937011556
public static final int	sTSampleIDAID	1937008996
public static final int	sTSampleSizeAID	1937011578
public static final int	sTSampleToChunkAID	1937011555
public static final int	sTShadowSyncAID	1937011560
public static final int	sTSyncSampleAID	1937011571
public static final int	sTTimeToSampAID	1937011827
public static final int	suppressDither	2
public static final int	sVideoIn	1
public static final int	systemMicrosecondClock	1835623282
public static final int	systemMillisecondClock	1835625580
public static final int	systemSecondClock	1936024431
public static final int	systemTickClock	1953063787
public static final int	tc24HourMax	2
public static final int	tcCounter	8
public static final int	tcdfShowTimeCode	1
public static final int	tcDropFrame	1
public static final int	tcNegTimesOK	4
public static final int	tcSourceRefNameType	1851878757
public static final int	tctNegFlag	128
public static final int	textMediaType	1952807028
public static final int	threeDeeMediaType	1902392164
public static final int	threeDMediaType	1902392164
public static final int	timeBaseAfterStopTime	2
public static final int	timeBaseBeforeStartTime	1
public static final int	timeCodeMediaType	1953325924
public static final int	trackAID	1953653099
public static final int	trackEnable	1
public static final int	trackHeaderAID	1953196132
public static final int	trackInMovie	2
public static final int	trackInPoster	8
public static final int	trackInPreview	4
public static final int	trackReferenceAID	1953654118
public static final int	trackUsageInMovie	2
public static final int	trackUsageInPoster	8
public static final int	trackUsageInPreview	4
public static final int	translateMatrixType	1
public static final int	triggerAtStart	1
public static final int	triggerAtStop	2
public static final int	triggerRateChange	0
public static final int	triggerRateEqual	16
public static final int	triggerRateGT	8
public static final int	triggerRateGTE	24
public static final int	triggerRateLT	4
public static final int	triggerRateLTE	20
public static final int	triggerRateNotEqual	28
public static final int	triggerTimeBwd	2
public static final int	triggerTimeEither	3
public static final int	triggerTimeFwd	1
public static final int	tvTunerIn	6
public static final int	tweenComponentType	1953981806
public static final int	tweenMediaType	1953981806
public static final int	unkeepInRam	2
public static final int	urlDataHandlerSubType	1970433056
public static final int	useColorMatching	4
public static final int	userDataAID	1969517665
public static final int	vdBroadcastMode	0
public static final int	vdDigitizerBW	0
public static final int	vdDigitizerRGB	1
public static final int	vdigInterfaceRev	2
public static final int	vdPlayThruOff	0
public static final int	vdPlayThruOn	1
public static final int	vdTypeAlpha	1
public static final int	vdTypeBasic	0
public static final int	vdTypeKey	3
public static final int	vdTypeMask	2
public static final int	vdUseAnyField	0
public static final int	vdUseEvenField	2
public static final int	vdUseOddField	1
public static final int	vdVTRMode	1
public static final int	videoDigitizerComponentType	1986618471
public static final int	videoMediaInfoHeaderAID	1986881636
public static final int	videoMediaType	1986618469
public static final int	visualMediaCharacteristic	1702454643
public static final int	yuvComponentIn	4
public static final int	yuvComponentSyncIn	5
public static final int	zlibDataCompressorSubType	2053925218*/
enum {
   	mcActionSuspend	=46,
   	mcActionUseTrackForTimeTable	=66,
        mcActionMovieEdited	=50,
        mcActionResume	=47,
        mcActionGetExternalMovie	= 70,
        mcActionExecuteOneActionForQTEvent	=64,
        mcActionGetUseBadge	=37,
        mcActionGoToTime	=12,
        mcActionStep	=18,
        mcActionPrerollAndPlay	=55,
};

enum{
kActionCase	=6144,
kOperandConstant	=2,
kActionDebugStr	=6148,
kActionGoToURL=	6146,
kActionMusicPlayNote=	5120,
kActionSpriteStretch	=3083,
kActionSpriteRotate	=3082,
kActionSpriteTranslate=	3080,
kActionSpriteSetGraphicsMode	=3076,
kActionMovieSetSelectionByName	=1034,
kActionMovieSetSelection	=1033,
kActionMovieStepBackward	=1032,
kActionMovieStepForward	 = 1031,
kActionMoviePlaySelection=	1035,
kActionTrackSetVolume=	2048,
kActionTrackSetBalance=	2049,
kOperandSpriteTrackVariable=	3079,
kActionPopAndGotoLabeledTime=	6152,
kActionPopAndGotoTopTime=	6151,
kActionPushCurrentTimeWithLabel	=6150,
kActionMovieGoToBeginning	=1029,
kActionMovieGoToTimeByName=	1028,
kActionMovieGoToEnd	=1030,
kActionMovieSetLanguage	=1036,
kActionTrackSetEnabled	=2050,
kActionMovieGoToTime	=1027,
kActionSendQTEventToSprite	=6147,
kActionPushCurrentTime	=6149,
kActionTrackSetLayer=	2052,
kActionTrackSetMatrix	=2051,
kActionTrackSetClip	=2053,
kActionSpriteSetMatrix	=3072,
kActionSpriteSetImageIndex	=3073,
kActionSpriteSetVisible=	3074,
kActionSpriteSetLayer	=3075,
kActionSpriteScale	=3081,
kActionMovieSetRate=	1025,
kActionMovieSetLoopingFlags=	1026,
kActionMovieSetVolume	=1024,
kActionQTVRSetPanAngle = 	4096,
kOperandSpriteBoundsBottom	=3075,
kOperandSpriteBoundsRight	=3074,
kOperandSpriteBoundsTop	=3073,
kOperandSpriteBoundsLeft	=3072,
kActionQTVRGoToNodeID=	4100,
kActionQTVRShowDefaultView	=4099,
kActionQTVRSetFieldOfView	=4098,
kActionQTVRSetTiltAngle=	4097,
kOperandMouseLocalVLoc=	5121,
kOperandMouseLocalHLoc=	5120,
};

/*SpriteWorldHitTest Values

Constants passed to SpriteWorldHitTest.

enum {
   spriteHitTestBounds           = 1L << 0,
   /    point must only be within sprite's bounding box/
   spriteHitTestImage            = 1L << 1,
   /  point must be within the shape of the sprite's image/
   spriteHitTestInvisibleSprites = 1L << 2,
   /  invisible sprites may be hit tested/
   spriteHitTestIsClick          = 1L << 3,
   /  for codecs that want mouse events/
   spriteHitTestLocInDisplayCoordinates = 1L << 4,
   /    set if you want to pass a display coordiate point to SpriteHitTest/
   spriteHitTestTreatAllSpritesAsHitTestable = 1L << 5 / set if you want to override each sprites hittestable property as true/
};*/
enum {
   spriteHitTestBounds           = 1L << 0,
   /*    point must only be within sprite's bounding box*/
   spriteHitTestImage            = 1L << 1,
   /*  point must be within the shape of the sprite's image*/
   spriteHitTestInvisibleSprites = 1L << 2,
   /*  invisible sprites may be hit tested*/
   spriteHitTestIsClick          = 1L << 3,
   /*  for codecs that want mouse events*/
   spriteHitTestLocInDisplayCoordinates = 1L << 4,
   /*    set if you want to pass a display coordiate point to SpriteHitTest*/
   spriteHitTestTreatAllSpritesAsHitTestable = 1L << 5 /* set if you want to override each sprites hittestable property as true*/
};
/*QuickTime Preferences Dialog Options

Constants that represent options for QuickTime preference dialogs.

enum {
   pdActionConfirmDialog         = 1,
   / no param/
   pdActionSetAppleMenu          = 2,
   / param is MenuRef/
   pdActionSetEditMenu           = 3,
   / param is MenuRef/
   pdActionGetDialogValues       = 4,
   / param is QTAtomContainer/
   pdActionSetPreviewUserItem    = 5,
   / param is long/
   pdActionSetPreviewPicture     = 6,
   / param is QTParamPreviewPtr;/
   pdActionSetColorPickerEventProc = 7,
   / param is UserEventUPP/
   pdActionSetDialogTitle        = 8,
   / param is StringPtr /
   pdActionGetSubPanelMenu       = 9,
   / param is MenuRef /
   pdActionActivateSubPanel      = 10,
   / param is long /
   pdActionConductStopAlert      = 11,
   / param is StringPtr /
   pdActionModelessCallback      = 12,
   / param is QTParamDialogEventPtr /
   pdActionFetchPreview          = 13,
   / param is QTParamFetchPreviewPtr /
   pdActionSetDialogSettings     = 14,
   / param is QTAtomContainer /
   pdActionGetDialogSettings     = 15,
   / param is QTAtomContainer /
   pdActionGetNextSample         = 16,
   / param is QTAtomContainer with effect sample to change - createdDialog may be NIL /
   pdActionGetPreviousSample     = 17,
   / param is QTAtomContainer with effect sample to change - createdDialog may be NIL /
   pdActionCompactSample         = 18,
   / param is QTAtomContainer with effect sample to compact,
   - createdDialog may be NIL /
   pdActionSetEditCallout        = 19,
   / param is QTParamPreviewCalloutPtr,
   can be NIL /
   pdActionSetSampleTime         = 20,
   / param is QTParamSampleTimePtr,
   can be NIL /
   pdActionDoEditCommand         = 21,
   / param is long with menu command (ie,
   mcMenuCut etc) /
   pdActionGetSubPanelMenuValue  = 22,
   / param is long and returns current sub-panel value selected by the effect /
   / Action codes and typedefs used for custom controls within effects /
   pdActionCustomNewControl      = 23,
   / param is QTCustomControlNewPtr /
   pdActionCustomDisposeControl  = 24,
   / param is QTCustomControlNewPtr /
   pdActionCustomPositionControl = 25,
   / param is QTCustomControlPositionControlPtr /
   pdActionCustomShowHideControl = 26,
   / param is QTCustomControlShowHideControlPtr /
   pdActionCustomHandleEvent     = 27,
   / param is QTCustomControlHandleEventPtr /
   pdActionCustomSetFocus        = 28,
   / param is QTCustomControlSetFocusPtr /
   pdActionCustomSetEditMenu     = 29,
   / param is QTCustomControlSetEditMenuPtr /
   pdActionCustomSetPreviewPicture = 30,
   / param is QTCustomControlSetPreviewPicturePtr /
   pdActionCustomSetEditCallout  = 31,
   / param is QTCustomControlSetEditCalloutPtr /
   pdActionCustomGetEnableValue  = 32,
   / param is QTCustomControlGetEnableValuePtr /
   pdActionCustomSetSampleTime   = 33,
   / param is QTCustomControlSetSampleTimePtr /
   pdActionCustomGetValue        = 34,
   / param is QTCustomControlGetValue /
   pdActionCustomDoEditCommand   = 35,
   / param is QTCustomControlDoEditCommand /
   / more actions for the dialog /
   pdActionRunInEventLoop        = 36,
   / param is QTEventLoopDescriptionPtr - OS X only/
   pdActionConvertSettingsToXML  = 37,
   / param is QTAtomContainer inbound,
   Handle outbound contains the XML - createdDialog may be NIL /
   pdActionConvertSettingsToXMLWithComments = 38,
   / param is QTAtomContainer inbound,
   Handle outbound contains the XML with comments - createdDialog may be NIL /
   pdActionConvertSettingsToText = 39,
   / param is QTAtomContainer inbound,
   Handle outbound contains human readable text - createdDialog may be NIL /
   pdActionConvertXMLToSettings  = 40,
   / param is Handle inbound,
   QTAtomContainer outbound contains parameters - createdDialog may be NIL /
   pdActionSetPropertyComponent  = 41    / param is QTParamComponentPropertyPtr /
};
enum {
   pdOptionsCollectOneValue      = 0x00000001,
   / should collect a single value only/
   pdOptionsAllowOptionalInterpolations = 0x00000002,
   / non-novice interpolation options are shown /
   pdOptionsModalDialogBox       = 0x00000004,
   / dialog box should be modal /
   pdOptionsEditCurrentEffectOnly = 0x00000008,
   / List of effects will not be shown /
   pdOptionsHidePreview          = 0x00000010,
   / Preview item will not be shown /
   pdOptionsDisplayAsSheet       = 0x00000020 / Dialog will be used as a sheet (on platforms that support it) /
};
enum {
   pdSampleTimeDisplayOptionsNone = 0x00000000
};
Constants
pdActionModelessCallback

Parameter is QTParamDialogEventPtr. 

Available in Mac OS X v10.0 and later.
pdActionFetchPreview

Parameter is QTParamFetchPreviewPtr. 

Available in Mac OS X v10.0 and later.
pdActionSetDialogSettings

Parameter is QTAtomContainer. 

Available in Mac OS X v10.2 and later.
pdActionGetDialogSettings

Parameter is QTAtomContainer. 

Available in Mac OS X v10.2 and later.
pdActionGetNextSample

Parameter is QTAtomContainer with effect sample to change - createdDialog may be NIL. 

Available in Mac OS X v10.2 and later.
pdActionGetPreviousSample

Parameter is QTAtomContainer with effect sample to change - createdDialog may be NIL. 

Available in Mac OS X v10.2 and later.
pdActionCompactSample

Parameter is QTAtomContainer with effect sample to compact, - createdDialog may be NIL. 

Available in Mac OS X v10.2 and later.
pdActionSetEditCallout

Parameter is QTParamPreviewCalloutPtr, can be NIL. 

Available in Mac OS X v10.2 and later.
pdActionSetSampleTime

Parameter is QTParamSampleTimePtr, can be NIL. 

Available in Mac OS X v10.2 and later.
pdActionDoEditCommand

Parameter is long with menu command (that is, mcMenuCut etc). 

Available in Mac OS X v10.2 and later.
pdActionGetSubPanelMenuValue

Parameter is long and returns current sub-panel value selected by the effect. 

Available in Mac OS X v10.2 and later.
pdActionCustomNewControl

Parameter is QTCustomControlNewPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomDisposeControl

Parameter is QTCustomControlNewPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomPositionControl

Parameter is QTCustomControlPositionControlPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomShowHideControl

Parameter is QTCustomControlShowHideControlPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomHandleEvent

Parameter is QTCustomControlHandleEventPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomSetFocus

Parameter is QTCustomControlSetFocusPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomSetEditMenu

Parameter is QTCustomControlSetEditMenuPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomSetPreviewPicture

Parameter is QTCustomControlSetPreviewPicturePtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomSetEditCallout

Parameter is QTCustomControlSetEditCalloutPtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomGetEnableValue

Parameter is QTCustomControlGetEnableValuePtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomSetSampleTime

Parameter is QTCustomControlSetSampleTimePtr. 

Available in Mac OS X v10.2 and later.
pdActionCustomGetValue

Parameter is QTCustomControlGetValue. 

Available in Mac OS X v10.2 and later.
pdActionCustomDoEditCommand

Parameter is QTCustomControlDoEditCommand. 

Available in Mac OS X v10.2 and later.
pdActionRunInEventLoop

Parameter is QTEventLoopDescriptionPtr - OS X only. 

Available in Mac OS X v10.3 and later.
pdActionConvertSettingsToXML

Parameter is QTAtomContainer inbound, Handle outbound contains the XML - createdDialog may be NIL. 

Available in Mac OS X v10.3 and later.
pdActionConvertSettingsToXMLWithComments

Parameter is QTAtomContainer inbound, Handle outbound contains the XML with comments - createdDialog may be NIL. 

Available in Mac OS X v10.3 and later.
pdActionConvertSettingsToText

Parameter is QTAtomContainer inbound, Handle outbound contains human readable text - createdDialog may be NIL. 

Available in Mac OS X v10.3 and later.
pdActionConvertXMLToSettings

Parameter is Handle inbound, QTAtomContainer outbound contains parameters - createdDialog may be NIL. 

Available in Mac OS X v10.3 and later.
pdActionSetPropertyComponent

Parameter is QTParamComponentPropertyPtr. 

Available in Mac OS X v10.3 and later.
pdOptionsModalDialogBox

Dialog box should be modal. 

Available in Mac OS X v10.0 and later.
pdOptionsEditCurrentEffectOnly

List of effects will not be shown. 

Available in Mac OS X v10.2 and later.
pdOptionsHidePreview

Preview item will not be shown. 

Available in Mac OS X v10.2 and later.*/
enum {
   pdActionConfirmDialog         = 1,
   /* no param*/
   pdActionSetAppleMenu          = 2,
   /* param is MenuRef*/
   pdActionSetEditMenu           = 3,
   /* param is MenuRef*/
   pdActionGetDialogValues       = 4,
   /* param is QTAtomContainer*/
   pdActionSetPreviewUserItem    = 5,
   /* param is long*/
   pdActionSetPreviewPicture     = 6,
   /* param is QTParamPreviewPtr;*/
   pdActionSetColorPickerEventProc = 7,
   /* param is UserEventUPP*/
   pdActionSetDialogTitle        = 8,
   /* param is StringPtr */
   pdActionGetSubPanelMenu       = 9,
   /* param is MenuRef* */
   pdActionActivateSubPanel      = 10,
   /* param is long */
   pdActionConductStopAlert      = 11,
   /* param is StringPtr */
   pdActionModelessCallback      = 12,
   /* param is QTParamDialogEventPtr */
   pdActionFetchPreview          = 13,
   /* param is QTParamFetchPreviewPtr */
   pdActionSetDialogSettings     = 14,
   /* param is QTAtomContainer */
   pdActionGetDialogSettings     = 15,
   /* param is QTAtomContainer */
   pdActionGetNextSample         = 16,
   /* param is QTAtomContainer with effect sample to change - createdDialog may be NIL */
   pdActionGetPreviousSample     = 17,
   /* param is QTAtomContainer with effect sample to change - createdDialog may be NIL */
   pdActionCompactSample         = 18,
   /* param is QTAtomContainer with effect sample to compact,
   - createdDialog may be NIL */
   pdActionSetEditCallout        = 19,
   /* param is QTParamPreviewCalloutPtr,
   can be NIL */
   pdActionSetSampleTime         = 20,
   /* param is QTParamSampleTimePtr,
   can be NIL */
   pdActionDoEditCommand         = 21,
   /* param is long with menu command (ie,
   mcMenuCut etc) */
   pdActionGetSubPanelMenuValue  = 22,
   /* param is long and returns current sub-panel value selected by the effect */
   /* Action codes and typedefs used for custom controls within effects */
   pdActionCustomNewControl      = 23,
   /* param is QTCustomControlNewPtr */
   pdActionCustomDisposeControl  = 24,
   /* param is QTCustomControlNewPtr */
   pdActionCustomPositionControl = 25,
   /* param is QTCustomControlPositionControlPtr */
   pdActionCustomShowHideControl = 26,
   /* param is QTCustomControlShowHideControlPtr */
   pdActionCustomHandleEvent     = 27,
   /* param is QTCustomControlHandleEventPtr */
   pdActionCustomSetFocus        = 28,
   /* param is QTCustomControlSetFocusPtr */
   pdActionCustomSetEditMenu     = 29,
   /* param is QTCustomControlSetEditMenuPtr */
   pdActionCustomSetPreviewPicture = 30,
   /* param is QTCustomControlSetPreviewPicturePtr */
   pdActionCustomSetEditCallout  = 31,
   /* param is QTCustomControlSetEditCalloutPtr */
   pdActionCustomGetEnableValue  = 32,
   /* param is QTCustomControlGetEnableValuePtr */
   pdActionCustomSetSampleTime   = 33,
   /* param is QTCustomControlSetSampleTimePtr */
   pdActionCustomGetValue        = 34,
   /* param is QTCustomControlGetValue */
   pdActionCustomDoEditCommand   = 35,
   /* param is QTCustomControlDoEditCommand */
   /* more actions for the dialog */
   pdActionRunInEventLoop        = 36,
   /* param is QTEventLoopDescriptionPtr - OS X only*/
   pdActionConvertSettingsToXML  = 37,
   /* param is QTAtomContainer* inbound,
   Handle* outbound contains the XML - createdDialog may be NIL */
   pdActionConvertSettingsToXMLWithComments = 38,
   /* param is QTAtomContainer* inbound,
   Handle* outbound contains the XML with comments - createdDialog may be NIL */
   pdActionConvertSettingsToText = 39,
   /* param is QTAtomContainer* inbound,
   Handle* outbound contains human readable text - createdDialog may be NIL */
   pdActionConvertXMLToSettings  = 40,
   /* param is Handle* inbound,
   QTAtomContainer* outbound contains parameters - createdDialog may be NIL */
   pdActionSetPropertyComponent  = 41    /* param is QTParamComponentPropertyPtr */
};
enum {
   pdOptionsCollectOneValue      = 0x00000001,
   /* should collect a single value only*/
   pdOptionsAllowOptionalInterpolations = 0x00000002,
   /* non-novice interpolation options are shown */
   pdOptionsModalDialogBox       = 0x00000004,
   /* dialog box should be modal */
   pdOptionsEditCurrentEffectOnly = 0x00000008,
   /* List of effects will not be shown */
   pdOptionsHidePreview          = 0x00000010,
   /* Preview item will not be shown */
   pdOptionsDisplayAsSheet       = 0x00000020 /* Dialog will be used as a sheet (on platforms that support it) */
};
enum {
   pdSampleTimeDisplayOptionsNone = 0x00000000
};


/*Media Characteristics

Constants that represent the characteristics of media.

enum {
   VisualMediaCharacteristic     = 'eyes',
   AudioMediaCharacteristic      = 'ears',
   kCharacteristicCanSendVideo   = 'vsnd',
   kCharacteristicProvidesActions = 'actn',
   kCharacteristicNonLinear      = 'nonl',
   kCharacteristicCanStep        = 'step',
   kCharacteristicHasNoDuration  = 'noti',
   kCharacteristicHasSkinData    = 'skin',
   kCharacteristicProvidesKeyFocus = 'keyf',
   kCharacteristicSupportsDisplayOffsets = 'dtdd'
};
Constants
AudioMediaCharacteristic

Value ='ears'. Instructs the Movie Toolbox to search all tracks that play sound. 

Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

enum {
   VisualMediaCharacteristic     = 'eyes',
   AudioMediaCharacteristic      = 'ears',
   kCharacteristicCanSendVideo   = 'vsnd',
   kCharacteristicProvidesActions = 'actn',
   kCharacteristicNonLinear      = 'nonl',
   kCharacteristicCanStep        = 'step',
   kCharacteristicHasNoDuration  = 'noti',
   kCharacteristicHasSkinData    = 'skin',
   kCharacteristicProvidesKeyFocus = 'keyf',
   kCharacteristicSupportsDisplayOffsets = 'dtdd'
};


/*Discussion

The size in bytes of this atom structure. 
udType
Discussion

Constant kUserDataName, designating atom type 'name'. 
data
Discussion

A name string. 
Parent Atom
'udta' 
Parent atom can contain only one atom of this type. 
Programming Info*/
enum {
kUserDataName = 'name'
};


/*Parameter Dialog Box Preview Image Specifier

This data structure contains a picture that will be used as one of the preview images in the preview window of the standard parameters dialog box. The preview window shows previews of the effects the user chooses in the dialog box. QuickTime provides a default images, but you can replace one or more of these by calling QTStandardParameterDialogDoAction (or its low-level equivalent, ImageCodecStandardParameterDialogDoAction ) with a pdActionSetPreviewPicture action selector.

The sourceID numbers correspond to the sources an effect uses. For example, an effect that uses one source will use the preview image with sourceID set to 1, while a two source effect will use preview pictures 1 and 2.struct QTParamPreviewRecord {
    long        sourceID;
    PicHandle   sourcePicture;
};
typedef struct QTParamPreviewRecord QTParamPreviewRecord;
typedef QTParamPreviewRecord *QTParamPreviewPtr;

Term	
Definition

sourceID	
The number of the preview image.

sourcePicture	
The preview image itself.*/
struct QTParamPreviewRecord {
    long        sourceID;
    PicHandle   sourcePicture;
};
typedef struct QTParamPreviewRecord QTParamPreviewRecord;
typedef QTParamPreviewRecord *QTParamPreviewPtr;


/*Full Screen Flags

Constants that represent flags for full screen displays.

enum {
   fullScreenHideCursor          = 1L << 0,
   fullScreenAllowEvents         = 1L << 1,
   fullScreenDontChangeMenuBar   = 1L << 2,
   fullScreenPreflightSize       = 1L << 3,
   fullScreenDontSwitchMonitorResolution = 1L << 4,
   fullScreenCaptureDisplay      = 1 << 5L,
   / capturedisplay is a mac os x specific parameter *
   fullScreenCaptureAllDisplays  = 1 << 6L / capturealldisplays is a mac os x specific parameter *
};
Constants
fullScreenHideCursor

If this flag is set, BeginFullScreen hides the cursor. This is useful if you are going to play a QuickTime movie and do not want the cursor to be visible over the movie. 

Available in Mac OS X v10.0 and later.
fullScreenAllowEvents

If this flag is set, your application intends to allow other applications to run (by calling WaitNextEvent to grant them processing time). In this case, BeginFullScreen does not change the monitor resolution, because other applications might depend on the current resolution. 

Available in Mac OS X v10.0 and later.
fullScreenDontChangeMenuBar

If this flag is set, BeginFullScreen does not hide the menu bar. This is useful if you want to change the resolution of the monitor but still need to allow the user to access the menu bar. 

Available in Mac OS X v10.0 and later.
fullScreenPreflightSize

If this flag is set, BeginFullScreen doesn't change any monitor settings, but returns the actual height and width that it would use if this bit were not set. This allows applications to test for the availability of a monitor setting without having to switch to it. 

Available in Mac OS X v10.0 and later.
fullScreenCaptureDisplay

Capturedisplay is a Mac OS X specific parameter. 

Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
enum {
   fullScreenHideCursor          = 1L << 0,
   fullScreenAllowEvents         = 1L << 1,
   fullScreenDontChangeMenuBar   = 1L << 2,
   fullScreenPreflightSize       = 1L << 3,
   fullScreenDontSwitchMonitorResolution = 1L << 4,
   fullScreenCaptureDisplay      = 1 << 5L,
   /* capturedisplay is a mac os x specific parameter */
   fullScreenCaptureAllDisplays  = 1 << 6L /* capturealldisplays is a mac os x specific parameter */
};


/*movieFileSpecValid

Constants grouped with movieFileSpecValid.

enum {
   pasteInParallel               = 1 << 0,
   showUserSettingsDialog        = 1 << 1,
   movieToFileOnlyExport         = 1 << 2,
   movieFileSpecValid            = 1 << 3
};*/
enum {
  // pasteInParallel               = 1 << 0,
   showUserSettingsDialog        = 1 << 1,
   movieToFileOnlyExport         = 1 << 2,
   movieFileSpecValid            = 1 << 3
};

/*Sprite Properties

Constants that represent the properties of sprites.

enum {
   kGetSpriteWorldInvalidRegionAndLeaveIntact = -1L,
   kGetSpriteWorldInvalidRegionAndThenSetEmpty = -2L
};
enum {
   kKeyFrameAndSingleOverride    = 1L << 1,
   kKeyFrameAndAllOverrides      = 1L << 2
};
enum {
   kNoQTIdleEvents               = -1
};
enum {
   kOnlyDrawToSpriteWorld        = 1L << 0,
   kSpriteWorldPreflight         = 1L << 1
};
enum {
   kScaleSpritesToScaleWorld     = 1L << 1,
   kSpriteWorldHighQuality       = 1L << 2,
   kSpriteWorldDontAutoInvalidate = 1L << 3,
   kSpriteWorldInvisible         = 1L << 4,
   kSpriteWorldDirtyInsteadOfFlush = 1L << 5
};
enum {
   kSpritePropertyMatrix         = 1,
   kSpritePropertyImageDescription = 2,
   kSpritePropertyImageDataPtr   = 3,
   kSpritePropertyVisible        = 4,
   kSpritePropertyLayer          = 5,
   kSpritePropertyGraphicsMode   = 6,
   kSpritePropertyImageDataSize  = 7,
   kSpritePropertyActionHandlingSpriteID = 8,
   kSpritePropertyCanBeHitTested = 9,
   kSpritePropertyImageIndex     = 100,
   kSpriteTrackPropertyBackgroundColor = 101,
   kSpriteTrackPropertyOffscreenBitDepth = 102,
   kSpriteTrackPropertySampleFormat = 103,
   kSpriteTrackPropertyScaleSpritesToScaleWorld = 104,
   kSpriteTrackPropertyHasActions = 105,
   kSpriteTrackPropertyVisible   = 106,
   kSpriteTrackPropertyQTIdleEventsFrequency = 107,
   kSpriteTrackPropertyAllSpritesHitTestingMode = 108,
   kSpriteTrackPropertyPreferredDepthInterpretationMode = 109,
   kSpriteImagePropertyRegistrationPoint = 1000,
   kSpriteImagePropertyGroupID   = 1001
};
Declared In
Movies.h*/
enum {
   kGetSpriteWorldInvalidRegionAndLeaveIntact = -1L,
   kGetSpriteWorldInvalidRegionAndThenSetEmpty = -2L
};
enum {
   kKeyFrameAndSingleOverride    = 1L << 1,
   kKeyFrameAndAllOverrides      = 1L << 2
};
enum {
   kNoQTIdleEvents               = -1
};
enum {
   kOnlyDrawToSpriteWorld        = 1L << 0,
   kSpriteWorldPreflight         = 1L << 1
};
enum {
   kScaleSpritesToScaleWorld     = 1L << 1,
   kSpriteWorldHighQuality       = 1L << 2,
   kSpriteWorldDontAutoInvalidate = 1L << 3,
   kSpriteWorldInvisible         = 1L << 4,
   kSpriteWorldDirtyInsteadOfFlush = 1L << 5
};
enum {
   kSpritePropertyMatrix         = 1,
   kSpritePropertyImageDescription = 2,
   kSpritePropertyImageDataPtr   = 3,
   kSpritePropertyVisible        = 4,
   kSpritePropertyLayer          = 5,
   kSpritePropertyGraphicsMode   = 6,
   kSpritePropertyImageDataSize  = 7,
   kSpritePropertyActionHandlingSpriteID = 8,
   kSpritePropertyCanBeHitTested = 9,
   kSpritePropertyImageIndex     = 100,
   kSpriteTrackPropertyBackgroundColor = 101,
   kSpriteTrackPropertyOffscreenBitDepth = 102,
   kSpriteTrackPropertySampleFormat = 103,
   kSpriteTrackPropertyScaleSpritesToScaleWorld = 104,
   kSpriteTrackPropertyHasActions = 105,
   kSpriteTrackPropertyVisible   = 106,
   kSpriteTrackPropertyQTIdleEventsFrequency = 107,
   kSpriteTrackPropertyAllSpritesHitTestingMode = 108,
   kSpriteTrackPropertyPreferredDepthInterpretationMode = 109,
   kSpriteImagePropertyRegistrationPoint = 1000,
   kSpriteImagePropertyGroupID   = 1001
};

/*Tween Type and Tween Component Subtype Constants

The following constants specify tween types. If a tween type is identified by a four-character code, the four-character code is also the component subtype of the tween component that is invoked for the tween. If a tween type is identified by a numeric constant, such as kTweenTypeShort, tweens of that type are processed by QuickTime rather than by a tween component.
enum {
    kTweenTypeShort = 1,
    kTweenTypeLong = 2,
    kTweenTypeFixed = 3,
    kTweenTypePoint = 4,
    kTweenTypeQDRect = 5,
    kTweenTypeQDRegion = 6,
    kTweenTypeMatrix = 7,
    kTweenTypeRGBColor = 8,
    kTweenTypeGraphicsModeWithRGBColor = 9,
    kTweenTypeQTFloatSingle = 10,
    kTweenTypeQTFloatDouble = 11,
    kTweenTypeFixedPoint = 12,
    kTweenType3dScale = FOUR_CHAR_CODE('3sca'),
    kTweenType3dTranslate = FOUR_CHAR_CODE('3tra'),
    kTweenType3dRotate = FOUR_CHAR_CODE('3rot'),
    kTweenType3dRotateAboutPoint = FOUR_CHAR_CODE('3rap'),
    kTweenType3dRotateAboutAxis = FOUR_CHAR_CODE('3rax'),
    kTweenType3dRotateAboutVector = FOUR_CHAR_CODE('3rvc'),
    kTweenType3dQuaternion = FOUR_CHAR_CODE('3qua'),
    kTweenType3dMatrix = FOUR_CHAR_CODE('3mat'),
    kTweenType3dCameraData = FOUR_CHAR_CODE('3cam'),
    kTweenType3dSoundLocalizationData = FOUR_CHAR_CODE('3slc'),
    kTweenTypePathToMatrixTranslation = FOUR_CHAR_CODE('gxmt'),
    kTweenTypePathToMatrixTranslationAndRotation =FOUR_CHAR_CODE('gxmr'),
    kTweenTypePathToFixedPoint = FOUR_CHAR_CODE('gxfp'),
    kTweenTypePathXtoY = FOUR_CHAR_CODE('gxxy'),
    kTweenTypePathYtoX = FOUR_CHAR_CODE('gxyx'),
    kTweenTypeAtomList = FOUR_CHAR_CODE('atom'),
    kTweenTypePolygon = FOUR_CHAR_CODE('poly')
    kTweenTypePathToMatrixRotation = FOUR_CHAR_CODE('gxpr'),
    kTweenTypeMultiMatrix = FOUR_CHAR_CODE('mulm'),
    kTweenTypeSpin = FOUR_CHAR_CODE('spin'),
    kTweenType3dMatrixNonLinear = FOUR_CHAR_CODE('3nlr'),
    kTweenType3dVRObject = FOUR_CHAR_CODE('3vro')
    };*/

enum {
    kTweenTypeShort = 1,
    kTweenTypeLong = 2,
    kTweenTypeFixed = 3,
    kTweenTypePoint = 4,
    kTweenTypeQDRect = 5,
    kTweenTypeQDRegion = 6,
    kTweenTypeMatrix = 7,
    kTweenTypeRGBColor = 8,
    kTweenTypeGraphicsModeWithRGBColor = 9,
    kTweenTypeQTFloatSingle = 10,
    kTweenTypeQTFloatDouble = 11,
    kTweenTypeFixedPoint = 12,
    kTweenType3dScale = FOUR_CHAR_CODE('3sca'),
    kTweenType3dTranslate = FOUR_CHAR_CODE('3tra'),
    kTweenType3dRotate = FOUR_CHAR_CODE('3rot'),
    kTweenType3dRotateAboutPoint = FOUR_CHAR_CODE('3rap'),
    kTweenType3dRotateAboutAxis = FOUR_CHAR_CODE('3rax'),
    kTweenType3dRotateAboutVector = FOUR_CHAR_CODE('3rvc'),
    kTweenType3dQuaternion = FOUR_CHAR_CODE('3qua'),
    kTweenType3dMatrix = FOUR_CHAR_CODE('3mat'),
    kTweenType3dCameraData = FOUR_CHAR_CODE('3cam'),
    kTweenType3dSoundLocalizationData = FOUR_CHAR_CODE('3slc'),
    kTweenTypePathToMatrixTranslation = FOUR_CHAR_CODE('gxmt'),
    kTweenTypePathToMatrixTranslationAndRotation =FOUR_CHAR_CODE('gxmr'),
    kTweenTypePathToFixedPoint = FOUR_CHAR_CODE('gxfp'),
    kTweenTypePathXtoY = FOUR_CHAR_CODE('gxxy'),
    kTweenTypePathYtoX = FOUR_CHAR_CODE('gxyx'),
    kTweenTypeAtomList = FOUR_CHAR_CODE('atom'),
    kTweenTypePolygon = FOUR_CHAR_CODE('poly'),
    kTweenTypePathToMatrixRotation = FOUR_CHAR_CODE('gxpr'),
    kTweenTypeMultiMatrix = FOUR_CHAR_CODE('mulm'),
    kTweenTypeSpin = FOUR_CHAR_CODE('spin'),
    kTweenType3dMatrixNonLinear = FOUR_CHAR_CODE('3nlr'),
    kTweenType3dVRObject = FOUR_CHAR_CODE('3vro')
    };


/*QTParameterDialogOptions

Abst_QTParameterDialogOptions

typedef long QTParameterDialogOptions;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTParameterDialogOptions;

/*QTParameterDialog

Abst_QTParameterDialog

typedef long QTParameterDialog;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTParameterDialog;


/*Discussion

The following sample code shows how to retrieve the connection speed setting from the QuickTime preferences:
struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;
. . .
OSErr                       err;
QTAtomContainer             prefs;
QTAtom                      prefsAtom;
long                        dataSize;
Ptr                         atomData;
ConnectionSpeedPrefsRecord  prefrec;
err =GetQuickTimePreference(ConnectionSpeedPrefsType, &amp;prefs);
if (err ==noErr) {
    prefsAtom =QTFindChildByID(prefs, kParentAtomIsContainer,
                                  ConnectionSpeedPrefsType, 1, nil);
    if (!prefsAtom) {
        // set the default setting to 28.8kpbs
        prefrec.connectionSpeed =kDataRate288ModemRate;
    } else {
        err =QTGetAtomDataPtr(prefs, prefsAtom, &dataSize,
                                                         &atomData);
        if (dataSize !=sizeof(ConnectionSpeedPrefsRecord)) {
            // the prefs record wasn't the right size,
            // so it must be corrupt -- set to the default
            prefrec.connectionSpeed =kDataRate288ModemRate;
        } else {
            // everything was fine -- read the connection speed
            prefrec =*(ConnectionSpeedPrefsRecord *)atomData;
        }
    }
    QTDisposeAtomContainer(prefs);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;


/*Interesting Times Flags

The interestingTimeFlags parameter for the interesting time functions (GetMovieNextInterestingTime, GetTrackNexttInterestingTime, and GetMediaNextInterestingTime ) specifies a set of bit flags that specify search criteria. Normally, you use one of the interesting time functions to step forward to the next frame.

These functions work well for most media types, including video and text. However, because QuickTime stores an entire MPEG stream as a single sample, stepping to the next sample skips to the end of the sequence. To solve this problem, QuickTime introduced a new flag for the interesting time calls: nextTimeStep. This flag returns the time of the next frame, even if there are multiple frames per sample, for all media types including video, text, and MPEG. Applications that implement single stepping capabilities should always use this flag instead of nextTimeMediaSample.
enum {
    nextTimeStep    = 1 << 4
};

Term	
Definition

nextTimeStep	
Searches for the next frame in the movie's media. Set this flag to 1 to step to the next frame.*/

enum {
    nextTimeStep    = 1 << 4
};



 

/*GetMovieImporter Flags

Constants that represent <codeVoice>GetMovieImporter</codeVoice> flags.

enum {
   kGetMovieImporterValidateToFind = 1L << 0,
   kGetMovieImporterAllowNewFile = 1L << 1,
   kGetMovieImporterDontConsiderGraphicsImporters = 1L << 2,
   kGetMovieImporterDontConsiderFileOnlyImporters = 1L << 6,
   kGetMovieImporterAutoImportOnly = 1L << 10 /*reject aggressive movie importers which have dontAutoFileMovieImport set*
};
Declared In
Movies.h*/
enum {
   kGetMovieImporterValidateToFind = 1L << 0,
   kGetMovieImporterAllowNewFile = 1L << 1,
   kGetMovieImporterDontConsiderGraphicsImporters = 1L << 2,
   kGetMovieImporterDontConsiderFileOnlyImporters = 1L << 6,
   kGetMovieImporterAutoImportOnly = 1L << 10 /* reject aggressive movie importers which have dontAutoFileMovieImport set*/
};

/*GetMovieIndTrackType Values

Constants passed to GetMovieIndTrackType.

enum {
   movieTrackMediaType           = 1 << 0,
   movieTrackCharacteristic      = 1 << 1,
   movieTrackEnabledOnly         = 1 << 2
};
Declared In
Movies.h*/
enum {
   movieTrackMediaType           = 1 << 0,
   movieTrackCharacteristic      = 1 << 1,
   movieTrackEnabledOnly         = 1 << 2
};

/*FlattenMovieData Values

Constants passed to FlattenMovieData.

enum {
   flattenAddMovieToDataFork     = 1L << 0,
   flattenActiveTracksOnly       = 1L << 2,
   flattenDontInterleaveFlatten  = 1L << 3,
   flattenFSSpecPtrIsDataRefRecordPtr = 1L << 4,
   flattenCompressMovieResource  = 1L << 5,
   flattenForceMovieResourceBeforeMovieData = 1L << 6
};*/

enum {
   flattenAddMovieToDataFork     = 1L << 0,
   flattenActiveTracksOnly       = 1L << 2,
   flattenDontInterleaveFlatten  = 1L << 3,
   flattenFSSpecPtrIsDataRefRecordPtr = 1L << 4,
   flattenCompressMovieResource  = 1L << 5,
   flattenForceMovieResourceBeforeMovieData = 1L << 6
};



/*CreateMovieFile Values

Constants passed to CreateMovieFile.

enum {
   createMovieFileDeleteCurFile  = 1L << 31,
   createMovieFileDontCreateMovie = 1L << 30,
   createMovieFileDontOpenFile   = 1L << 29,
   createMovieFileDontCreateResFile = 1L << 28
};
Constants
createMovieFileDontOpenFile

Controls whether the function opens the new movie file. If you set this flag to 1, the Movie Toolbox does not open the new movie file. In this case, the function ignores the outDataHandler parameter. If you set this flag to 0, the Movie Toolbox opens the new movie file and returns its reference number into the field referenced by outDataHandler. 

Available in Mac OS X v10.0 and later.*/
enum {
   createMovieFileDeleteCurFile  = 1L << 31,
   createMovieFileDontCreateMovie = 1L << 30,
   createMovieFileDontOpenFile   = 1L << 29,
   createMovieFileDontCreateResFile = 1L << 28
};



/*Movie Controller Options

Constants that represent options for movie controllers.

enum {
   kMCIEEnabledButtonPicture     = 1,
   kMCIEDisabledButtonPicture    = 2,
   kMCIEDepressedButtonPicture   = 3,
   kMCIEEnabledSizeBoxPicture    = 4,
   kMCIEDisabledSizeBoxPicture   = 5,
   kMCIEEnabledUnavailableButtonPicture = 6,
   kMCIEDisabledUnavailableButtonPicture = 7,
   kMCIESoundSlider              = 128,
   kMCIESoundThumb               = 129,
   kMCIEColorTable               = 256,
   kMCIEIsFlatAppearance         = 257,
   kMCIEDoButtonIconsDropOnDepress = 258
};
enum {
   mcFlagSuppressMovieFrame      = 1 << 0,
   mcFlagSuppressStepButtons     = 1 << 1,
   mcFlagSuppressSpeakerButton   = 1 << 2,
   mcFlagsUseWindowPalette       = 1 << 3,
   mcFlagsDontInvalidate         = 1 << 4,
   mcFlagsUseCustomButton        = 1 << 5
};
enum {
   mcInfoUndoAvailable           = 1 << 0,
   mcInfoCutAvailable            = 1 << 1,
   mcInfoCopyAvailable           = 1 << 2,
   mcInfoPasteAvailable          = 1 << 3,
   mcInfoClearAvailable          = 1 << 4,
   mcInfoHasSound                = 1 << 5,
   mcInfoIsPlaying               = 1 << 6,
   mcInfoIsLooping               = 1 << 7,
   mcInfoIsInPalindrome          = 1 << 8,
   mcInfoEditingEnabled          = 1 << 9,
   mcInfoMovieIsInteractive      = 1 << 10
};
Constants
kMCIESoundThumb

The indicator on the sound slider. 

Available in Mac OS X v10.0 and later.
mcFlagSuppressMovieFrame

If this flag is set to 1, the controller does not display a frame around the movie. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
mcFlagSuppressStepButtons

If this flag is set to 1, the controller does not display the step buttons. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
mcFlagSuppressSpeakerButton

If this flag is set to 1, the controller does not display the speaker button. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
mcFlagsUseWindowPalette

If this flag is set to 1, the movie controller does not manage the window palette. This ensures that a movie's colors are reproduced as accurately as possible. This flag is particularly useful for movies with custom color tables. By default, this flag is set to 0. 

Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
enum {
   kMCIEEnabledButtonPicture     = 1,
   kMCIEDisabledButtonPicture    = 2,
   kMCIEDepressedButtonPicture   = 3,
   kMCIEEnabledSizeBoxPicture    = 4,
   kMCIEDisabledSizeBoxPicture   = 5,
   kMCIEEnabledUnavailableButtonPicture = 6,
   kMCIEDisabledUnavailableButtonPicture = 7,
   kMCIESoundSlider              = 128,
   kMCIESoundThumb               = 129,
   kMCIEColorTable               = 256,
   kMCIEIsFlatAppearance         = 257,
   kMCIEDoButtonIconsDropOnDepress = 258
};//movies.h
enum {
   mcFlagSuppressMovieFrame      = 1 << 0,
   mcFlagSuppressStepButtons     = 1 << 1,
   mcFlagSuppressSpeakerButton   = 1 << 2,
   mcFlagsUseWindowPalette       = 1 << 3,
   mcFlagsDontInvalidate         = 1 << 4,
   mcFlagsUseCustomButton        = 1 << 5
};
enum {
   mcInfoUndoAvailable           = 1 << 0,
   mcInfoCutAvailable            = 1 << 1,
   mcInfoCopyAvailable           = 1 << 2,
   mcInfoPasteAvailable          = 1 << 3,
   mcInfoClearAvailable          = 1 << 4,
   mcInfoHasSound                = 1 << 5,
   mcInfoIsPlaying               = 1 << 6,
   mcInfoIsLooping               = 1 << 7,
   mcInfoIsInPalindrome          = 1 << 8,
   mcInfoEditingEnabled          = 1 << 9,
   mcInfoMovieIsInteractive      = 1 << 10
};

/*Text Properties

Constants that represent the properties of text.

enum {
   / set property parameter / get property parameter
   kTextTextHandle               = 1,
   / Handle / preallocated Handle
   kTextTextPtr                  = 2,
   / Pointer
   kTextTEStyle                  = 3,
   / TextStyle  / TextStyle 
   kTextSelection                = 4,
   / long [2] / long [2]
   kTextBackColor                = 5,
   / RGBColor  / RGBColor /
   kTextForeColor                = 6,
   / RGBColor  / RGBColor /
   kTextFace                     = 7,
   / long / long /
   kTextFont                     = 8,
   / long / long /
   kTextSize                     = 9,
   / long / long /
   kTextAlignment                = 10,
   / short  / short /
   kTextHilite                   = 11,
   / hiliteRecord  / hiliteRecord /
   kTextDropShadow               = 12,
   / dropShadowRecord  / dropShadowRecord /
   kTextDisplayFlags             = 13,
   / long / long /
   kTextScroll                   = 14,
   / TimeValue  / TimeValue /
   kTextRelativeScroll           = 15,
   / Point /
   kTextHyperTextFace            = 16,
   / hyperTextSetFace  / hyperTextSetFace /
   kTextHyperTextColor           = 17,
   / hyperTextSetColor  / hyperTextSetColor /
   kTextKeyEntry                 = 18,
   / short/
   kTextMouseDown                = 19,
   / Point /
   kTextTextBox                  = 20,
   / Rect  / Rect /
   kTextEditState                = 21,
   / short / short /
   kTextLength                   = 22    /       / long /
};
enum {
   dfDontDisplay                 = 1 << 0,
   / Don't display the text/
   dfDontAutoScale               = 1 << 1,
   / Don't scale text as track bounds grows or shrinks/
   dfClipToTextBox               = 1 << 2,
   / Clip update to the textbox/
   dfUseMovieBGColor             = 1 << 3,
   / Set text background to movie's background color/
   dfShrinkTextBoxToFit          = 1 << 4,
   / Compute minimum box to fit the sample/
   dfScrollIn                    = 1 << 5,
   / Scroll text in until last of text is in view /
   dfScrollOut                   = 1 << 6,
   / Scroll text out until last of text is gone (if both set,
   scroll in then out)/
   dfHorizScroll                 = 1 << 7,
   / Scroll text horizontally (otherwise it's vertical)/
   dfReverseScroll               = 1 << 8,
   / vert: scroll down rather than up; horiz: scroll backwards (justfication dependent)/
   dfContinuousScroll            = 1 << 9,
   / new samples cause previous samples to scroll out /
   dfFlowHoriz                   = 1 << 10,
   / horiz scroll text flows in textbox rather than extend to right /
   dfContinuousKaraoke           = 1 << 11,
   / ignore begin offset,
   hilite everything up to the end offset(karaoke)/
   dfDropShadow                  = 1 << 12,
   / display text with a drop shadow /
   dfAntiAlias                   = 1 << 13,
   / attempt to display text anti aliased/
   dfKeyedText                   = 1 << 14,
   / key the text over background/
   dfInverseHilite               = 1 << 15,
   / Use inverse hiliting rather than using hilite color/
   dfTextColorHilite             = 1 << 16 / changes text color in place of hiliting. /
};
Constants
kTextSelection

Long [2] long [2]. 

Available in Mac OS X v10.0 and later.
kTextScroll

The text scroll position. 

Available in Mac OS X v10.0 and later.
kTextRelativeScroll

Point. 

Available in Mac OS X v10.0 and later.
kTextHyperTextFace

HyperTextSetFace hyperTextSetFace. 

Available in Mac OS X v10.0 and later.
kTextHyperTextColor

HyperTextSetColor hyperTextSetColor. 

Available in Mac OS X v10.0 and later.
kTextKeyEntry

Short. 

Available in Mac OS X v10.0 and later.
kTextMouseDown

Point. 

Available in Mac OS X v10.0 and later.
kTextTextBox

Rect Rect. 

Available in Mac OS X v10.0 and later.
kTextEditState

Short short. 

Available in Mac OS X v10.0 and later.
kTextLength

Long. 

Available in Mac OS X v10.0 and later.
dfDontDisplay

Does not display the specified sample. 

Available in Mac OS X v10.0 and later.
dfDontAutoScale

Does not scale the text if the track bounds increase. 

Available in Mac OS X v10.0 and later.
dfClipToTextBox

Clips to just the text box. This is useful if the text overlays the video. 

Available in Mac OS X v10.0 and later.
dfUseMovieBGColor

Set text background to movie’s background color. 

Available in Mac OS X v10.0 and later.
dfShrinkTextBoxToFit

Recalculates size of the textBox parameter to just fit the given text and stores this rectangle with the text data. 

Available in Mac OS X v10.0 and later.
dfScrollIn

Scrolls the text in until the last of the text is in view. This flag is associated with the scrollDelay parameter. 

Available in Mac OS X v10.0 and later.
dfScrollOut

Scrolls text out until the last of the text is out of view. This flag is associated with the scrollDelay parameter. If both dfScrollIn and dfScrollOut are set, the text is scrolled in, then out. 

Available in Mac OS X v10.0 and later.
dfHorizScroll

Scrolls a single line of text horizontally. If the dfHorizScroll flag is not set, then the scrolling is vertical. 

Available in Mac OS X v10.0 and later.
dfReverseScroll

If set, scrolls vertically down, rather than up. If not set, horizontal scrolling proceeds toward the left rather than toward the right. 

Available in Mac OS X v10.0 and later.*/
enum {
   /* set property parameter / get property parameter*/
   kTextTextHandle               = 1,
   /* Handle / preallocated Handle*/
   kTextTextPtr                  = 2,
   /* Pointer*/
   kTextTEStyle                  = 3,
   /* TextStyle * / TextStyle **/
   kTextSelection                = 4,
   /* long [2] / long [2]*/
   kTextBackColor                = 5,
   /* RGBColor * / RGBColor **/
   kTextForeColor                = 6,
   /* RGBColor * / RGBColor **/
   kTextFace                     = 7,
   /* long / long **/
   kTextFont                     = 8,
   /* long / long **/
   kTextSize                     = 9,
   /* long / long **/
   kTextAlignment                = 10,
   /* short * / short **/
   kTextHilite                   = 11,
   /* hiliteRecord * / hiliteRecord **/
   kTextDropShadow               = 12,
   /* dropShadowRecord * / dropShadowRecord **/
   kTextDisplayFlags             = 13,
   /* long / long **/
   kTextScroll                   = 14,
   /* TimeValue * / TimeValue **/
   kTextRelativeScroll           = 15,
   /* Point **/
   kTextHyperTextFace            = 16,
   /* hyperTextSetFace * / hyperTextSetFace **/
   kTextHyperTextColor           = 17,
   /* hyperTextSetColor * / hyperTextSetColor **/
   kTextKeyEntry                 = 18,
   /* short*/
   kTextMouseDown                = 19,
   /* Point **/
   kTextTextBox                  = 20,
   /* Rect * / Rect **/
   kTextEditState                = 21,
   /* short / short **/
   kTextLength                   = 22    /*       / long **/
};
enum {
   dfDontDisplay                 = 1 << 0,
   /* Don't display the text*/
   dfDontAutoScale               = 1 << 1,
   /* Don't scale text as track bounds grows or shrinks*/
   dfClipToTextBox               = 1 << 2,
   /* Clip update to the textbox*/
   dfUseMovieBGColor             = 1 << 3,
   /* Set text background to movie's background color*/
   dfShrinkTextBoxToFit          = 1 << 4,
   /* Compute minimum box to fit the sample*/
   dfScrollIn                    = 1 << 5,
   /* Scroll text in until last of text is in view */
   dfScrollOut                   = 1 << 6,
   /* Scroll text out until last of text is gone (if both set,
   scroll in then out)*/
   dfHorizScroll                 = 1 << 7,
   /* Scroll text horizontally (otherwise it's vertical)*/
   dfReverseScroll               = 1 << 8,
   /* vert: scroll down rather than up; horiz: scroll backwards (justfication dependent)*/
   dfContinuousScroll            = 1 << 9,
   /* new samples cause previous samples to scroll out */
   dfFlowHoriz                   = 1 << 10,
   /* horiz scroll text flows in textbox rather than extend to right */
   dfContinuousKaraoke           = 1 << 11,
   /* ignore begin offset,
   hilite everything up to the end offset(karaoke)*/
   dfDropShadow                  = 1 << 12,
   /* display text with a drop shadow */
   dfAntiAlias                   = 1 << 13,
   /* attempt to display text anti aliased*/
   dfKeyedText                   = 1 << 14,
   /* key the text over background*/
   dfInverseHilite               = 1 << 15,
   /* Use inverse hiliting rather than using hilite color*/
   dfTextColorHilite             = 1 << 16 /* changes text color in place of hiliting. */
};



/*Audio Property IDs

The following constants identify audio properties.
enum {
    kQTAudioPropertyID_Gain = 'gain',
    kQTAudioPropertyID_Mute = 'mute',
    kQTAudioPropertyID_Balance = 'bala',
    kQTAudioPropertyID_Fade = 'fade',
    kQTAudioPropertyID_SummaryChannelLayout = 'clay',
    kQTAudioPropertyID_DeviceChannelLayout = 'dcly',
    kQTAudioPropertyID_FormatString = 'fstr',
    kQTAudioPropertyID_ChannelLayoutString = 'lstr',
    kQTAudioPropertyID_SampleRateString = 'rstr',
    kQTAudioPropertyID_SampleSizeString = 'sstr',
    kQTAudioPropertyID_BitRateString = 'bstr',
    kQTAudioPropertyID_SummaryString = 'asum'
};

kQTAudioPropertyID_Gain = 'gain'

Used to get and set a Float32 value that represents the audio gain of a movie or track. The gain level is multiplicative; eg. 0.0 is silent, 0.5 is –6dB, 1.0 is 0dB (ie. the audio from the movie is not modified), 2.0 is +6dB, etc. The gain level can be set higher than 1.0 in order to allow quiet movies and tracks to be boosted in volume. Settings higher than 1.0 may result in audio clipping, of course. The setting is not stored in the movie or track; it is used only until the movie or track is disposed. 
kQTAudioPropertyID_Mute = 'mute'

Used to get and set a Boolean value that indicates the audio mute state of a movie or track. If TRUE, the movie or track is muted. The setting is not stored in the movie or track; it is used only until the movie or track is disposed.
kQTAudioPropertyID_Balance = 'bala'

Used to get and set a Float32 value that represents the audio balance of a movie. It is supported only for movies, not tracks. –1.0 means full left, 0.0 means centered, and 1.0 means full right. The setting is not stored in the movie; it is used only until the movie is disposed.
kQTAudioPropertyID_Fade = 'fade'

Used to get and set a Float32 value that represents the audio fade of a movie. It is supported only for movies, not tracks. 1.0 means full forward, 0.0 means centered, and –1.0 means full rearward. The setting is not stored in the movie; it is used only until the movie is disposed.
kQTAudioPropertyID_SummaryChannelLayout = 'clay'

Used to get an AudioChannelLayout value that represents the summary audio channel layout of a movie or other grouping of audio streams. All like-labelled channels are combined, so there are no duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4 channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C—It will _not_ be L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. This is a variable-size property, because it it may contain an array of channel descriptions. You must get the size by calling a function such as QTGetMoviePropertyInfo, allocate a structure of that size, and then get the property.
kQTAudioPropertyID_DeviceChannelLayout = 'dcly'

Used to get an AudioChannelLayout value that represents the audio channel layout of the device a movie is playing to. This is a variable-size property, because it it may contain an array of channel descriptions. You must get the size by calling a function such as QTGetMoviePropertyInfo, allocate a structure of that size, and then get the property.
kQTAudioPropertyID_FormatString = 'fstr'

Used with kQTPropertyClass_Audio to get a CFStringRef value containing a localized, human readable string that describes an audio format; for example, “MPEG Layer 3.” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_ChannelLayoutString = 'lstr'

Used with kQTPropertyClass_Audio to get a CFStringRef value containing a localized, human readable string that describes an audio channel layout; for example, “5.0 (L R C Ls Rs).” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_SampleRateString = 'rstr'

Used to get a CFStringRef value containing a localized, human readable string that describes an audio sample rate; for example, “44.100 kHz.” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_SampleSizeString = 'sstr'

Used to get a CFStringRef value containing a localized, human readable string that describes an audio sample size; for example, “24-bit.” This property will return a valid string only if the audio format is uncompressed (LPCM). You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_BitRateString = 'bstr'

Used to get a CFStringRef value containing a localized, human readable string that describes an audio bit rate; for example, “12 kbps.” You may get this property from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
kQTAudioPropertyID_SummaryString = 'asum'

Used to get a CFStringRef value containing a localized, human readable string that summarizes an audio format; for example, “16-bit Integer (Big Endian), Stereo (L R), 48.000 kHz.” You may get this property from a SoundDescription handle by calling QTSoundDescriptionGetProperty or from a StandardAudioCompression (scdi or audi) component instance by calling QTGetComponentProperty.
The following constants identify audio properties.*/
enum {
    kQTAudioPropertyID_Gain = 'gain',
    kQTAudioPropertyID_Mute = 'mute',
    kQTAudioPropertyID_Balance = 'bala',
    kQTAudioPropertyID_Fade = 'fade',
    kQTAudioPropertyID_SummaryChannelLayout = 'clay',
    kQTAudioPropertyID_DeviceChannelLayout = 'dcly',
    kQTAudioPropertyID_FormatString = 'fstr',
    kQTAudioPropertyID_ChannelLayoutString = 'lstr',
    kQTAudioPropertyID_SampleRateString = 'rstr',
    kQTAudioPropertyID_SampleSizeString = 'sstr',
    kQTAudioPropertyID_BitRateString = 'bstr',
    kQTAudioPropertyID_SummaryString = 'asum'
};



/*Movie Audio Mixes

Three new four-character constants define the mix of audio channels for several functions:
kQTAudioMeter_StereoMix = 'stmx'
kQTAudioMeter_DeviceMix = kQTAudioPropertyID_DeviceChannelLayout = 'dcly'
kQTAudioMeter_MonoMix = 'momx'

kQTAudioMeter_StereoMix

Meter a stereo (two-channel) mix of the enabled sound tracks in the movie. This option is offered only for MovieAudioFrequencyMetering.
kQTAudioMeter_DeviceMix

Meter the movie’s mix to the AudioChannelLayout of the device the movie is playing to. To determine the channel layout of this mix, you call the kAudioPropertyID_DeviceChannelLayout movie property.
kQTAudioMeter_MonoMix

Meter the movie as if it had been mixed to monaural. This option is offered only for MovieAudioFrequencyMetering.

The constants listed above are passed by the following QuickTime 7 functions:
GetMovieAudioFrequencyLevels
GetMovieAudioFrequencyMeteringBandFrequencies
GetMovieAudioFrequencyMeteringNumBands
GetMovieAudioVolumeLevels
GetMovieAudioVolumeMeteringEnabled
SetMovieAudioFrequencyMeteringNumBands
SetMovieAudioVolumeMeteringEnabled*/
enum {
kQTAudioMeter_StereoMix = 'stmx',
kQTAudioMeter_DeviceMix = kQTAudioPropertyID_DeviceChannelLayout ,
kQTAudioMeter_MonoMix = 'momx'
};

/*Audio Properties

The following is a list of the new audio properties available in QuickTime 7.1.

enum {
   kQTAudioRenderQuality_PlaybackDefault = 0x8000,
   kQTAudioPropertyID_RenderQuality = 'qual',
   kQTMovieAudioExtractionAudioPropertyID_RenderQuality = 'qual',
   kQTAudioPropertyID_DeviceASBD = 'dasd',
   kQTAudioPropertyID_SummaryASBD = 'sasd',
   kQTAudioPropertyID_RateChangesPreservePitch = 'aucp',
   kQTAudioPropertyID_Pitch  = 'pitc',
   kQTSCAudioPropertyID_RenderQuality = 'qlty',
};
Constants
kQTAudioPropertyID_DeviceASBD

This is a get-only property and returns the AudioStreamBasicDescription of the device the movie is playing to. The interesting fields are the sample rate, which reflects device’s current state, and the number of channels, which matches what is reported by kQTAudioPropertyID_DeviceChannelLayout.
kQTAudioPropertyID_SummaryASBD

Get-only. Returns the AudioStreamBasicDescription corresponding to the Summary Mix of a movie. This describes non-interleaved, Float32 linear PCM data, with a sample rate equal to the highest audio sample rate found among the sound tracks contributing to the AudioContext mix, and a number of channels that matches what is reported by kQTAudioPropertyID_SummaryChannelLayout.
kQTAudioPropertyID_RateChangesPreservePitch

This property was introduced in QuickTime 7 and must be set in order for pitch changes to take effect. When the playback rate is not unity, audio must be resampled in order to play at the new rate. The default resampling affects the pitch of the audio (for example, playing at 2x speed raises the pitch by an octave, 1/2x lowers an octave). If this property is set on the Movie, an alternative algorithm may be used, which alters the speed without changing the pitch. Because this is more computationally expensive, this property may be silently ignored on some slow CPUs. Media handlers may query this movie property and honor it when performing Scaled Edits. This property can be specified as a property to the NewMovieFromProperties API. Currently, it has no effect when set on an open movie.
kQTAudioPropertyID_Pitch

The movie pitch adjustment. This adjusts the pitch of all audio tracks that contribute to the AudioContext mix. Pitch control takes effect only if kQTAudioPropertyID_RateChangesPreservePitch is in effect; otherwise, returns kQTMessageNotHandledErr. The Float32 value is specified in cents: 0.0 == no change, 1.0 == one cent up, 100.0 == one semi-tone up, -1.0 == one cent down. The most useful ranges for pitch are +/- 1200, that is, one octave.
kQTAudioPropertyID_RenderQuality

Movie audio render quality takes effect for movie playback. UInt32 values are as defined in AudioUnit/AudioUnitProperties.h and vary from 0x00 (kRenderQuality_Min) to 0x7F (kRenderQuality_Max). A special value kQTAudioRenderQuality_PlaybackDefault) is also defined which resets the quality settings of the playback processing chain to values that are chosen to be an optimal balance of performance and quality.
kQTMovieAudioExtractionAudioPropertyID_RenderQuality

Sets the render quality to be used for this audio extraction session. UInt32 values are as defined in AudioUnit/AudioUnitProperties.h and vary from 0x00(kRenderQuality_Min) to 0x7F (kRenderQuality_Max). A special value (kQTAudioRenderQuality_PlaybackDefault) is also defined which resets the quality settings to the same values that were chosen by default for playback.
kQTSCAudioPropertyID_RenderQuality

Specifies the quality with which QuickTime should render the audio stream during the compression/decompression/transcode operation. Accepted constants are those used by AudioUnits (defined in AudioUnitProperties.h): kRenderQuality_Max, kRenderQuality_High, kRenderQuality_Medium, kRenderQuality_Low, kRenderQuality_Min. Available in QuickTimeComponents.h.
Declared In
Movies.h*/
enum {
   kQTAudioRenderQuality_PlaybackDefault = 0x8000,
   kQTAudioPropertyID_RenderQuality = 'qual',
   kQTMovieAudioExtractionAudioPropertyID_RenderQuality = 'qual',
   kQTAudioPropertyID_DeviceASBD = 'dasd',
   kQTAudioPropertyID_SummaryASBD = 'sasd',
   kQTAudioPropertyID_RateChangesPreservePitch = 'aucp',
   kQTAudioPropertyID_Pitch  = 'pitc',
   kQTSCAudioPropertyID_RenderQuality = 'qlty',
};


/*QuickTime 5 includes the addition of two new functions –– CanQuickTimeOpenFile and CanQuickTimeOpenDataRef, discussed in this section. The CanQuickTimeOpenFile call determines whether QuickTime can open a given file or, in general, files of a given type. The CanQuickTimeOpenDataRef call is similar to CanQuickTimeOpenFile except that it uses a data reference instead of a file.

The input flags for CanQuickTimeOpenFile and CanQuickTimeOpenFileDataRef are defined as follows:
enum {
    kQTDontUseDataToFindImporter = 1L << 0,
    kQTDontLookForMovieImporterIfGraphicsImporterFound = 1L << 1,
    kQTAllowOpeningStillImagesAsMovies = 1L << 2,
    kQTAllowImportersThatWouldCreateNewFile = 1L << 3,
    kQTAllowAggressiveImporters = 1L << 4
};*/
enum {
    kQTDontUseDataToFindImporter = 1L << 0,
    kQTDontLookForMovieImporterIfGraphicsImporterFound = 1L << 1,
    kQTAllowOpeningStillImagesAsMovies = 1L << 2,
    kQTAllowImportersThatWouldCreateNewFile = 1L << 3,
    kQTAllowAggressiveImporters = 1L << 4
};


/*SetMovieDrawingCompleteProc Values

Constants passed to SetMovieDrawingCompleteProc.

enum {
   movieDrawingCallWhenChanged   = 0,
   movieDrawingCallAlways        = 1
};
Declared In
Movies.h*/
enum {
   movieDrawingCallWhenChanged   = 0,
   movieDrawingCallAlways        = 1
};

/*NewMovieController Values

Constants passed to NewMovieController.

enum {
   mcTopLeftMovie                = 1 << 0,
   / usually centered *
   mcScaleMovieToFit             = 1 << 1,
   / usually only scales down *
   mcWithBadge                   = 1 << 2,
   / give me a badge *
   mcNotVisible                  = 1 << 3,
   / don't show controller *
   mcWithFrame                   = 1 << 4 / gimme a frame *
};*/
enum {
   mcTopLeftMovie                = 1 << 0,
   /* usually centered */
   mcScaleMovieToFit             = 1 << 1,
   /* usually only scales down */
   mcWithBadge                   = 1 << 2,
   /* give me a badge */
   mcNotVisible                  = 1 << 3,
   /* don't show controller */
   mcWithFrame                   = 1 << 4 /* gimme a frame */
};



/*Constants

This section lists the constants that were added to QuickTime after an early release. Most of the constants are used as flags for QuickTime functions; they allow the programmer to pass numeric data as a meaningful name.#define kFix1 = (0x00010000);             /* fixed point value equal to 1.0 *
#define gestaltQuickTime 'qtim'           / Movie Toolbox availability *
#define MovieFileType 'MooV'              / movie file type *
#define VideoMediaType 'vide'             / video media type *
#define SoundMediaType 'soun'             / sound media type *
#define MediaHandlerType 'mhlr'           / media handler type *
#define DataHandlerType 'dhlr'            / data handler type *
#define TextMediaType 'text'              / text media type *
#define GenericMediaType 'gnrc'           / base media handler type *
#define DoTheRightThing = 0L              /*indicates default flag settings
                                                 for Movie Toolbox functions *
/ sound volume values in trackVolume parameter of NewMovieTrack function *
#define kFullVolume         = 0x100       / full, natural volume
                                                 (8.8 format) *
#define kNoVolume           =   0         * no volume *
/ constants for whichMediaTypes parameter of GetMovieNextInterestingTime
    function *
#define VisualMediaCharacteristic 'eyes'  / visual media *
#define AudioMediaCharacteristic 'ears'   / audio media 
 
enum
{
/ media quality settings in quality parameter of SetMediaQuality function *
    mediaQualityDraft           = 0x0000,    / lowest quality level *
    mediaQualityNormal          = 0x0040,    * acceptable quality level *
    mediaQualityBetter          = 0x0080,    / better quality level *
    mediaQualityBest            = 0x00C0     / best quality level *
};
 
*values for callBackFlags field of QuickTime callback header structure used
    by clock components to communicate scheduling information about a
    callback event to the Movie Toolbox *
enum
{
    qtcbNeedsRateChanges           = 1,    / rate changes *
    qtcbNeedsTimeChanges           = 2,    / time changes *
    qtcbNeedsStartStopChanges      = 4     * time base changes at start &
                                                stop times *
};
 
/* dialog items to include in dialog box definition for use with
    SFPGetFilePreview function *
enum
{
    sfpItemPreviewAreaUser         = 11,       /* user preview area *
    sfpItemPreviewStaticText       = 12,       /* static text preview *
    sfpItemPreviewDividerUser      = 13,       /* user divider preview *
    sfpItemCreatePreviewButton     = 14,       /* create preview button *
    sfpItemShowPreviewButton       = 15        /* show preview button *
};
 
enum
{                       
    movieInDataForkResID           = -1        /* magic resource ID *
};
 
/* flags for LoadIntoRAM functions *
enum
{
    keepInRam                  = 1<<0,     / load and make so data  
                                                 cannot be purged *
    unkeepInRam                = 1<<1,     /mark data so it can be purged *
    flushFromRam               = 1<<2,     / empty handles and purge data
                                                 from memory *
    loadForwardTrackEdits      = 1<<3,     /* load only data around track edits;
                                                 play movie forward *
    loadBackwardTrackEdits     = 1<<4      /* load only data around edits;
                                                 play movie in reverse *
};
 
/* flag for PasteHandleIntoMovie function *
enum
{
    pasteInParallel = 1         /* changes function to take contents and type of
                                     handle and add to movie *
};
 
/* text description display flags used in TextMediaAddTextSample and
      TextMediaAddTESample *
enum
{
    dfDontDisplay           = 1<<0,   /* don't display the text *
    dfDontAutoScale         = 1<<1,   /* don't scale text as track
                                           bounds grows or shrinks *
    dfClipToTextBox         = 1<<2,   /* clip update to the text box *
    dfUseMovieBGColor       = 1<<3,   /* set text background to movie's
                                           background color *
    dfShrinkTextBoxToFit    = 1<<4,   /* compute minimum box to fit the
                                           sample *
    dfScrollIn              = 1<<5,   /* scroll text in until last of
                                           text is in view *
    dfScrollOut             = 1<<6    /* scroll text out until last of text is
                                           gone (if dfScrollIn is also set, 
                                           scroll in then out) *
    dfHorizScroll           = 1<<7,   /* scroll text horizontally; otherwise,
                                           it's vertical *
    dfReverseScroll         = 1<<8    /* vertically scroll down and horizontally
                                         scroll up; justification-dependent *
};
 
/* find flags for TextMediaFindNextText function *
    findTextEdgeOK           = 1<<0,     /* OK to find text at specified
                                              sample time *
    findTextCaseSensitive    = 1<<1,     / case-sensitive search *
    findTextReverseSearch    = 1<<2,     /* search from sampleTime backward *
    findTextWraparound       = 1<<3,     /* wrap search when beginning or end
                                              of movie is reached */  
 
/* return display flags for application-defined text function *
enum
{
    txtProcDefaultDisplay    = 0,        /* use the media's default settings *
    txtProcDontDisplay       = 1,        /* don't display the text *
    txtProcDoDisplay         = 2         /* display the text *
};
 
enum
{
hintsScrubMode               = 1<<0,    /* toolbox can display key frames when
                                              movie is repositioned *
hintsAllowInterlace          = 1<<6,    /* use interlace option for compressor
                                              components *
hintsUseSoundInterp          = 1<<7     /* turn on sound interpolation *
};
typedef unsigned long playHintsEnum;*/
enum {
 kFix1 = 0x00010000,             /* fixed point value equal to 1.0 */
//gestaltQuickTime = 'qtim'  ,         /* Movie Toolbox availability */
MovieFileType= 'MooV'  ,            /* movie file type */
//#define VideoMediaType 'vide'             /* video media type */
//#define SoundMediaType 'soun'             /* sound media type */
//#define MediaHandlerType 'mhlr'           /* media handler type */
//#define DataHandlerType 'dhlr'            /* data handler type */
//#define TextMediaType 'text'              /* text media type */
GenericMediaType ='gnrc'    ,       /* base media handler type */
DoTheRightThing  = 0L   ,           /* indicates default flag settings
                                                 //for Movie Toolbox functions */  

/* sound volume values in trackVolume parameter of NewMovieTrack function */
//#define kFullVolume         = 0x100       /* full, natural volume
//                                                 (8.8 format) */ 
//#define kNoVolume           =   0         /* no volume */
/* constants for whichMediaTypes parameter of GetMovieNextInterestingTime
    function */
// VisualMediaCharacteristic= 'eyes' , /* visual media */
// AudioMediaCharacteristic= 'ears'  , /* audio media */
 };

enum
{
/* media quality settings in quality parameter of SetMediaQuality function */
    mediaQualityDraft           = 0x0000,    /* lowest quality level */
    mediaQualityNormal          = 0x0040,    /* acceptable quality level */
    mediaQualityBetter          = 0x0080,    /* better quality level */
    mediaQualityBest            = 0x00C0     /* best quality level */
};
 
/*values for callBackFlags field of QuickTime callback header structure used
    by clock components to communicate scheduling information about a
    callback event to the Movie Toolbox */
enum
{
    qtcbNeedsRateChanges           = 1,    /* rate changes */
    qtcbNeedsTimeChanges           = 2,    /* time changes */
    qtcbNeedsStartStopChanges      = 4     /* time base changes at start &
                                                stop times */ 
};
 
/* dialog items to include in dialog box definition for use with
    SFPGetFilePreview function */
enum
{
    sfpItemPreviewAreaUser         = 11,       /* user preview area */
    sfpItemPreviewStaticText       = 12,       /* static text preview */
    sfpItemPreviewDividerUser      = 13,       /* user divider preview */
    sfpItemCreatePreviewButton     = 14,       /* create preview button */
    sfpItemShowPreviewButton       = 15        /* show preview button */
};
 
enum
{                       
    movieInDataForkResID           = -1        /* magic resource ID */
};
 
/* flags for LoadIntoRAM functions */
enum
{
    keepInRam                  = 1<<0,     /* load and make so data  
                                                 cannot be purged */ 
    unkeepInRam                = 1<<1,     /* mark data so it can be purged */ 
    flushFromRam               = 1<<2,     /* empty handles and purge data
                                                 from memory */ 
    loadForwardTrackEdits      = 1<<3,     /* load only data around track edits;
                                                 play movie forward */ 
    loadBackwardTrackEdits     = 1<<4      /* load only data around edits;
                                                 play movie in reverse */ 
};
 
/* flag for PasteHandleIntoMovie function */
enum
{
    pasteInParallel = 1         /* changes function to take contents and type of
                                     handle and add to movie */ 
};
 
/* text description display flags used in TextMediaAddTextSample and
      TextMediaAddTESample */
 
enum {
/* find flags for TextMediaFindNextText function */
    findTextEdgeOK           = 1<<0,     /* OK to find text at specified
                                              sample time */ 
    findTextCaseSensitive    = 1<<1,     /* case-sensitive search */
    findTextReverseSearch    = 1<<2,     /* search from sampleTime backward */
    findTextWraparound       = 1<<3,     /* wrap search when beginning or end
                                              of movie is reached */  
 };
/* return display flags for application-defined text function */
enum
{
    txtProcDefaultDisplay    = 0,        /* use the media's default settings */
    txtProcDontDisplay       = 1,        /* don't display the text */
    txtProcDoDisplay         = 2         /* display the text */
};
 
typedef unsigned long playHintsEnum;

/*Using pdActionCustomDoEditCommand to Handle Edit Commands

pdActionCustomDoEditCommand tells your control to handle edit commands if it allow focus and type in boxes.

All custom controls must implement this call if they support edit boxes. 
struct QTCustomControlDoEditCommandRecord {
    void * storage; / storage for the control*
    long command; /*command to execute, return 0 here if processed*
};
typedef struct QTCustomControlDoEditCommandRecord QTCustomControlDoEditCommandRecord;
 
typedef QTCustomControlDoEditCommandRecord * QTCustomControlDoEditCommandPtr;
typedef long QTParameterDialog;a
enum {
    elOptionsIncludeNoneInList  = 0x00000001 / "None" effect is included
                                                in list *
};
typedef long QTEffectListOptions;
enum {
    pdOptionsCollectOneValue = 0x00000001, / should collect a single
                                            value only*
pdOptionsAllowOptionalInterpolations = 0x00000002, / non-novice
                                    interpolation options are shown *
pdOptionsModalDialogBox = 0x00000004, /dialog box should be modal *
pdOptionsEditCurrentEffectOnly = 0x00000008, / List of effects will not
                                                be shown /
pdOptionsHidePreview = 0x00000010 / Preview item will not be shown *
enum {
    effectIsRealtime = 0 / effect can be rendered in real time *
};*/

struct QTCustomControlDoEditCommandRecord {
    void * storage; /* storage for the control*/
    long command; /* command to execute, return 0 here if processed*/
};
typedef struct QTCustomControlDoEditCommandRecord QTCustomControlDoEditCommandRecord;
 
typedef QTCustomControlDoEditCommandRecord * QTCustomControlDoEditCommandPtr;
typedef long QTParameterDialog;
enum {
    elOptionsIncludeNoneInList  = 0x00000001 /* "None" effect is included
                                                in list */
};
typedef long QTEffectListOptions;
//enum {
//    pdOptionsCollectOneValue = 0x00000001, /* should collect a single
//                                            value only*/
//pdOptionsAllowOptionalInterpolations = 0x00000002, /* non-novice
//                                    interpolation options are shown */
//pdOptionsModalDialogBox = 0x00000004, /* dialog box should be modal */
//pdOptionsEditCurrentEffectOnly = 0x00000008/* List of effects will not
                                           //     be shown */
//pdOptionsHidePreview = 0x00000010 /* Preview item will not be shown */
//};
enum {
    effectIsRealtime = 0 /* effect can be rendered in real time */
};
/*Properties of the movie that is extracted from kQTPropertyClass_MovieAudioExtraction_Movie include the following movie class IDs: 
kQTMovieAudioExtractionMoviePropertyID_CurrentTime. The value is a TimeRecord, which you can set and get. When setting, you set the timescale to anything you want (for example, the output audio sample rate or the movie timescale). When getting, the timescale will be output audio sample rate for best accuracy.
kQTMovieAudioExtractionMoviePropertyID_AllChannelsDiscrete. The value is Boolean (which is settable and gettable). Set to implement export of all audio channels without mixing. When this is set and the extraction audio stream basic description (ASBD) or channel layout are read back, you get information relating to the re-mapped movie.
kQTMovieAudioExtractionMoviePropertyID_CurrentTime = ‘time’. The value is a TimeRecord , which is gettable and settable.*/

enum{
kQTMovieAudioExtractionMoviePropertyID_CurrentTime = 'time'
};


/*Returns the load state of the target movie. <0 indicates an error.   
  kMovieLoadStateLoading      = 1000,    
 kMovieLoadStatePlayable     = 10000,    
 kMovieLoadStatePlaythroughOK = 20000,  
   kMovieLoadStateComplete     = 100000L
kOperandMovieTrackCount = 1034,*/
enum{
kMovieLoadStateLoading      = 1000,
 kMovieLoadStatePlayable     = 10000,
 kMovieLoadStatePlaythroughOK = 20000,
 kMovieLoadStateComplete     = 100000L,
kOperandMovieTrackCount = 1034,
};
/*QTPropertyClass_SampleTable

Constants grouped with kQTPropertyClass_SampleTable.

enum {
   /*
   * Property class for sample tables.
   */
//   kQTPropertyClass_SampleTable  = 'qtst',
   /*
   * The total decode duration of all samples in the sample table.
   * Read-only.
   */
//   kQTSampleTablePropertyID_TotalDecodeDuration = 'tded',
   /* TimeValue64,
   Read */
   /*
   * The least display offset in the table. (-50 is a lesser offset
   * than 20.)  Read-only.
   */
//   kQTSampleTablePropertyID_MinDisplayOffset = '<ddd',
   /* TimeValue64,
   Read */
   /*
   * The greatest display offset in the table. (20 is a greater offset
   * than -50.)  Read-only.
   */
//   kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd',
   /* TimeValue64,
   Read */
   /*
   * The least display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
//   kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis',
   /* TimeValue64,
   Read */
   /*
   * The greatest display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
  // kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' /* TimeValue64,
//   Read */
//};
//Declared In
//Movies.h*/

enum {
   /*
   * Property class for sample tables.
   */
   kQTPropertyClass_SampleTable  = 'qtst',
   /*
   * The total decode duration of all samples in the sample table.
   * Read-only.
   */
   kQTSampleTablePropertyID_TotalDecodeDuration = 'tded',
   /* TimeValue64,
   Read */
   /*
   * The least display offset in the table. (-50 is a lesser offset
   * than 20.)  Read-only.
   */
   kQTSampleTablePropertyID_MinDisplayOffset = '<ddd',
   /* TimeValue64,
   Read */
   /*
   * The greatest display offset in the table. (20 is a greater offset
   * than -50.)  Read-only.
   */
   kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd',
   /* TimeValue64,
   Read */
   /*
   * The least display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
   kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis',
   /* TimeValue64,
   Read */
   /*
   * The greatest display time of all samples in the table,
   relative to
   * the decode time of the first sample in the table.  Read-only.
   */
   kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' /* TimeValue64,
   Read */
};



/*QTSampleTableGetSampleFlags Values

Constants passed to QTSampleTableGetSampleFlags.

enum {
   mediaSampleNotSync            = 1 << 0,
   // sample is not a sync sample (eg. is frame differenced 
   mediaSampleShadowSync         = 1 << 1,
   // sample is a shadow sync 
   mediaSampleDroppable          = 1 << 27,
   // sample is not required to be decoded for later samples to be decoded properly
   mediaSamplePartialSync        = 1 << 16,
   //sample is a partial sync (e.g
   //I frame after open GOP)
   mediaSampleHasRedundantCoding = 1 << 24,
   // sample is known to contain redundant coding 
   mediaSampleHasNoRedundantCoding = 1 << 25,
   / sample is known not to contain redundant coding 
   mediaSampleIsDependedOnByOthers = 1 << 26,
   // one or more other samples depend upon the decode of this sample 
   mediaSampleIsNotDependedOnByOthers = 1 << 27,
   // synonym for mediaSampleDroppable 
   mediaSampleDependsOnOthers    = 1 << 28,
   // sample's decode depends upon decode of other samples 
   mediaSampleDoesNotDependOnOthers = 1 << 29,
   // sample's decode does not depend upon decode of other samples 
   mediaSampleEarlierDisplayTimesAllowed = 1 << 30 / samples later in decode order may have earlier display times 
};
Constants
mediaSampleNotSync

Returned for frame-differenced video sample data. 

Available in Mac OS X v10.0 and later.*/

enum {
   mediaSampleNotSync            = 1 << 0,
   /* sample is not a sync sample (eg. is frame differenced */
   mediaSampleShadowSync         = 1 << 1,
   /* sample is a shadow sync */
   mediaSampleDroppable          = 1 << 27,
   /* sample is not required to be decoded for later samples to be decoded properly */
   mediaSamplePartialSync        = 1 << 16,
   /* sample is a partial sync (e.g.,
   I frame after open GOP) */
   mediaSampleHasRedundantCoding = 1 << 24,
   /* sample is known to contain redundant coding */
   mediaSampleHasNoRedundantCoding = 1 << 25,
   /* sample is known not to contain redundant coding */
   mediaSampleIsDependedOnByOthers = 1 << 26,
   /* one or more other samples depend upon the decode of this sample */
   mediaSampleIsNotDependedOnByOthers = 1 << 27,
   /* synonym for mediaSampleDroppable */
   mediaSampleDependsOnOthers    = 1 << 28,
   /* sample's decode depends upon decode of other samples */
   mediaSampleDoesNotDependOnOthers = 1 << 29,
   /* sample's decode does not depend upon decode of other samples */
   mediaSampleEarlierDisplayTimesAllowed = 1 << 30 /* samples later in decode order may have earlier display times */
};
/*Metadata Property IDs

The property IDs in this section are used with functions of the form QTMetaData...

Following are constants for the QTMetaDataRef type:
kPropertyClass_QTMetaData = 'meta'

The QuickTime metadata property class.
kQTMetaDataPropertyID_StorageFormats = 'fmts'

The list of storage formats of type QTMetaDataStorageFormat associated with a QTMetaDataRef object. The read-only return value is a C-style array of OSType values.
kQTMetaDataPropertyID_OwnerType = 'ownt'

The owner type associated with a QTMetaDataRef object. The read-only return value is an OSType (QT_MOVIE_TYPE, QT_TRACK_TYPE, or QT_MEDIA_TYPE).
kQTMetaDataPropertyID_Owner = 'ownr'

The owner associated with a QTMetaDataRef object, which does not necessarily need an owner. The read-only return value is type Movie, Track, or Media.

Following are constants for the QTMetaDataItem type:
kPropertyClass_QTMetaDataItem = 'mdit'

The metadata item property class ID
kQTMetaDataItemPropertyID_Value = 'valu'

The value of the metadata item. The read-only return value is a C-style array of values of type UInt8.
kQTMetaDataItemPropertyID_DataType = 'dtyp'

The value type of the metadata item. The read/write return value is type UInt32.
kQTMetaDataItemPropertyID_StorageFormat = 'sfmt'

The storage format of the metadata item. The read-only return value is type QTMetaDataStorageFormat.
kQTMetaDataItemPropertyID_Key = 'key ' [last char is space]

The key associated with the metadata item. The read/write return value is a C-style array of values of type UInt8.
kQTMetaDataItemPropertyID_KeyFormat = 'keyf'

The format of the metadata item key. The read/write return value is type OSType.
kQTMetaDataItemPropertyID_Locale = 'loc '

The locale identifier based on the naming convention defined by the International Components for Unicode (ICU). The identifier consists of two pieces of ordered information: a language code and a region code. The language code is based on the ISO 639-1 standard, which defines two-character codes, such as en and fr, for the world’s most commonly used languages. If a two-letter code is not available, then ISO 639-2 three-letter identifiers are accepted as well; for example, haw for Hawaiian. The region code is defined by ISO 3166-1. It is all uppercase and is appended, with an underscore, after the language code; for example en_US, en_GB, and fr_FR. The read/write return value is a C string of type UInt32.*/
enum {
kPropertyClass_QTMetaData = 'meta' ,
kQTMetaDataPropertyID_StorageFormats = 'fmts',
kQTMetaDataPropertyID_OwnerType = 'ownt',
kQTMetaDataPropertyID_Owner = 'ownr'
};

enum {
kPropertyClass_QTMetaDataItem = 'mdit',
kQTMetaDataItemPropertyID_Value = 'valu',
kQTMetaDataItemPropertyID_DataType = 'dtyp',
kQTMetaDataItemPropertyID_StorageFormat = 'sfmt',
kQTMetaDataItemPropertyID_Key = 'key ' ,
kQTMetaDataItemPropertyID_KeyFormat = 'keyf',
kQTMetaDataItemPropertyID_Locale = 'loc '
};


/*inDataType

A data type from the following list: kQTMetaDataTypeBinary = 0, kQTMetaDataTypeUTF8 = 1, kQTMetaDataTypeUTF16BE = 2, kQTMetaDataTypeMacEncodedText = 3, kQTMetaDataTypeSignedIntegerBE = 21, kQTMetaDataTypeUnsignedIntegerBE = 22, kQTMetaDataTypeFloat32BE = 23, kQTMetaDataTypeFloat64BE = 24With kQTMetaDataTypeSignedIntegerBE and kQTMetaDataTypeUnsignedIntegerBE, the size of the integer is determined by the value size.*/
enum {
 kQTMetaDataTypeBinary = 0, 
kQTMetaDataTypeUTF8 = 1,
 kQTMetaDataTypeUTF16BE = 2,
 kQTMetaDataTypeMacEncodedText = 3, 
kQTMetaDataTypeSignedIntegerBE = 21, 
kQTMetaDataTypeUnsignedIntegerBE = 22,
 kQTMetaDataTypeFloat32BE = 23,
kQTMetaDataTypeFloat64BE = 24
};

/*Metadata Format Constants

The format constants in this section are used with functions of the form QTMetaData...

Following are constants for the QTMetaDataStorageFormat type:
kQTMetaDataStorageFormatQuickTime = 'mdta'

The QuickTime metadata storage format
kQTMetaDataKeyFormatQuickTime = 'mdta'

Reverse DNS format
kQTMetaDataStorageFormatiTunes = 'itms'

The iTunes metadata storage format

Following are constants for the QTMetaDataKeyFormat type:
kQTMetaDataKeyFormatiTunesShortForm = 'itsk'

A four-character code
kQTMetaDataKeyFormatiTunesLongForm = 'itlk'

Reverse DNS format

Following are constants for user data formats:
kQTMetaDataStorageFormatUserData = 'udta'

User data storage format
kQTMetaDataKeyFormatUserData = 'udta',

User data key storage format*/
enum {
kQTMetaDataStorageFormatQuickTime = 'mdta' ,
kQTMetaDataKeyFormatQuickTime = 'mdta',
kQTMetaDataStorageFormatiTunes = 'itms',
kQTMetaDataKeyFormatiTunesShortForm = 'itsk',
kQTMetaDataKeyFormatiTunesLongForm = 'itlk',
kQTMetaDataStorageFormatUserData = 'udta',
kQTMetaDataKeyFormatUserData = 'udta',
};

/*Hint Flags

Constants that represent hint flags.

enum {
   hintsScrubMode                = 1 << 0,
   // mask == && (if flags == scrub on,
   f//lags != scrub off) 
   hintsLoop                     = 1 << 1,
   hintsDontPurge                = 1 << 2,
   hintsUseScreenBuffer          = 1 << 5,
   hintsAllowInterlace           = 1 << 6,
   hintsUseSoundInterp           = 1 << 7,
   hintsHighQuality              = 1 << 8,
   // slooooow 
   hintsPalindrome               = 1 << 9,
   hintsInactive                 = 1 << 11,
   hintsOffscreen                = 1 << 12,
   hintsDontDraw                 = 1 << 13,
   hintsAllowBlacklining         = 1 << 14,
   hintsDontUseVideoOverlaySurface = 1 << 16,
   hintsIgnoreBandwidthRestrictions = 1 << 17,
   hintsPlayingEveryFrame        = 1 << 18,
   hintsAllowDynamicResize       = 1 << 19,
   hintsSingleField              = 1 << 20,
   hintsNoRenderingTimeOut       = 1 << 21,
   hintsFlushVideoInsteadOfDirtying = 1 << 22,
   hintsEnableSubPixelPositioning = 1L << 23,
   hintsRenderingMode            = 1L << 24,
   hintsAllowIdleSleep           = 1L << 25,
   // asks media handlers not to call UpdateSystemActivity etc 
   hintsDeinterlaceFields        = 1L << 26
};
Constants
hintsAllowIdleSleep

Asks media handlers not to call UpdateSystemActivity etc. 

Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
enum {
   hintsScrubMode                = 1 << 0,
   /* mask == && (if flags == scrub on,
   flags != scrub off) */
   hintsLoop                     = 1 << 1,
   hintsDontPurge                = 1 << 2,
   hintsUseScreenBuffer          = 1 << 5,
   hintsAllowInterlace           = 1 << 6,
   hintsUseSoundInterp           = 1 << 7,
   hintsHighQuality              = 1 << 8,
   /* slooooow */
   hintsPalindrome               = 1 << 9,
   hintsInactive                 = 1 << 11,
   hintsOffscreen                = 1 << 12,
   hintsDontDraw                 = 1 << 13,
   hintsAllowBlacklining         = 1 << 14,
   hintsDontUseVideoOverlaySurface = 1 << 16,
   hintsIgnoreBandwidthRestrictions = 1 << 17,
   hintsPlayingEveryFrame        = 1 << 18,
   hintsAllowDynamicResize       = 1 << 19,
   hintsSingleField              = 1 << 20,
   hintsNoRenderingTimeOut       = 1 << 21,
   hintsFlushVideoInsteadOfDirtying = 1 << 22,
   hintsEnableSubPixelPositioning = 1L << 23,
   hintsRenderingMode            = 1L << 24,
   hintsAllowIdleSleep           = 1L << 25,
   /* asks media handlers not to call UpdateSystemActivity etc */
   hintsDeinterlaceFields        = 1L << 26
};
/*loopTimeBase

Constants grouped with loopTimeBase.

enum {
   loopTimeBase                  = 1,
   palindromeLoopTimeBase        = 2,
   maintainTimeBaseZero          = 4
};
Declared In
Movies.h*/
enum {
   loopTimeBase                  = 1,
   palindromeLoopTimeBase        = 2,
   maintainTimeBaseZero          = 4
};


/*New Movie Property Codes

The following codes are stored in the propClass fields of QTNewMoviePropertyElement data structures, which pass them to NewMovieFromProperties.kQTPropertyClass_DataLocation = 'dloc',
        kQTDataLocationPropertyID_DataReference             = 'dref',
           // DataReferenceRecord *
        kQTDataLocationPropertyID_CFStringNativePath        = 'cfnp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringPosixPath         = 'cfpp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringHFSPath           = 'cfhp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringWindowsPath       = 'cfwp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFURL                     = 'cfur',
           // CFURLRef *
        kQTDataLocationPropertyID_QTDataHandler             = 'qtdh',
           // DataHandler *
        kQTDataLocationPropertyID_Scrap                     = 'scrp',
           // NULL
        kQTDataLocationPropertyID_LegacyMovieResourceHandle = 'rezh',
           // Handle *
        kQTDataLocationPropertyID_MovieUserProc             = 'uspr',
           // QTNewMovieUserProcRecord *
        kQTDataLocationPropertyID_ResourceFork              = 'rfrk',
           // SInt16 *
        kQTDataLocationPropertyID_DataFork                  = 'dfrk',
           // SInt16 *
 
kQTPropertyClass_Audio = 'audi',
        kQTAudioPropertyID_RateChangesPreservePitch         = 'aucp', // Boolean *
 
 kQTPropertyClass_Context = 'ctxt',
        kQTContextPropertyID_AudioContext       = 'audi',
           // QTAudioContextRef *
        kQTContextPropertyID_VisualContext      = 'visu',
           // QTVisualContextRef *
 
 kQTPropertyClass_MovieResourceLocator = 'rloc',
        kQTMovieResourceLocatorPropertyID_LegacyResID   = 'rezi',
           // SInt16 * (input/output property)
        kQTMovieResourceLocatorPropertyID_LegacyResName = 'rezn',
           // Str255   (output property)
        kQTMovieResourceLocatorPropertyID_FileOffset    = 'foff',
           // UInt64 *
        kQTMovieResourceLocatorPropertyID_Callback      = 'calb',
           // User-defined
 
 kQTPropertyClass_MovieInstantiation = 'mins',
        kQTMovieInstantiationPropertyID_DontResolveDataRefs         = 'rdrn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAskUnresolvedDataRefs   = 'aurn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoAlternates          = 'aaln',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontUpdateForeBackPointers  = 'fbpn',
           // Boolean *
        kQTMovieInstantiationPropertyID_AsyncOK                     = 'asok',
           // Boolean *
        kQTMovieInstantiationPropertyID_IdleImportOK                = 'imok',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoUpdateClock         = 'aucl',
           // Boolean *
        kQTMovieInstantiationPropertyID_ResultDataLocationChanged   = 'dlch',
           // Boolean * (output property)
 
 kQTPropertyClass_NewMovieProperty = 'mprp',
        kQTNewMoviePropertyID_DefaultDataRef        = 'ddrf',
           // DataReferenceRecord *
        kQTNewMoviePropertyID_Active                = 'actv',
           // Boolean *
        kQTNewMoviePropertyID_DontInteractWithUser  = 'intn',
           // Boolean **/
enum {
kQTPropertyClass_DataLocation = 'dloc',
        kQTDataLocationPropertyID_DataReference             = 'dref',
           // DataReferenceRecord *
        kQTDataLocationPropertyID_CFStringNativePath        = 'cfnp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringPosixPath         = 'cfpp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringHFSPath           = 'cfhp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFStringWindowsPath       = 'cfwp',
           // CFStringRef *
        kQTDataLocationPropertyID_CFURL                     = 'cfur',
           // CFURLRef *
        kQTDataLocationPropertyID_QTDataHandler             = 'qtdh',
           // DataHandler *
        kQTDataLocationPropertyID_Scrap                     = 'scrp',
           // NULL
        kQTDataLocationPropertyID_LegacyMovieResourceHandle = 'rezh',
           // Handle *
        kQTDataLocationPropertyID_MovieUserProc             = 'uspr',
           // QTNewMovieUserProcRecord *
        kQTDataLocationPropertyID_ResourceFork              = 'rfrk',
           // SInt16 *
        kQTDataLocationPropertyID_DataFork                  = 'dfrk',
           // SInt16 *
 
kQTPropertyClass_Audio = 'audi',
       // kQTAudioPropertyID_RateChangesPreservePitch         = 'aucp', // Boolean *
 
 kQTPropertyClass_Context = 'ctxt',
        kQTContextPropertyID_AudioContext       = 'audi',
           // QTAudioContextRef *
        kQTContextPropertyID_VisualContext      = 'visu',
           // QTVisualContextRef *
 
 kQTPropertyClass_MovieResourceLocator = 'rloc',
        kQTMovieResourceLocatorPropertyID_LegacyResID   = 'rezi',
           // SInt16 * (input/output property)
        kQTMovieResourceLocatorPropertyID_LegacyResName = 'rezn',
           // Str255   (output property)
        kQTMovieResourceLocatorPropertyID_FileOffset    = 'foff',
           // UInt64 *
        kQTMovieResourceLocatorPropertyID_Callback      = 'calb',
           // User-defined
 
 kQTPropertyClass_MovieInstantiation = 'mins',
        kQTMovieInstantiationPropertyID_DontResolveDataRefs         = 'rdrn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAskUnresolvedDataRefs   = 'aurn',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoAlternates          = 'aaln',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontUpdateForeBackPointers  = 'fbpn',
           // Boolean *
        kQTMovieInstantiationPropertyID_AsyncOK                     = 'asok',
           // Boolean *
        kQTMovieInstantiationPropertyID_IdleImportOK                = 'imok',
           // Boolean *
        kQTMovieInstantiationPropertyID_DontAutoUpdateClock         = 'aucl',
           // Boolean *
        kQTMovieInstantiationPropertyID_ResultDataLocationChanged   = 'dlch',
           // Boolean * (output property)
 
 kQTPropertyClass_NewMovieProperty = 'mprp',
        kQTNewMoviePropertyID_DefaultDataRef        = 'ddrf',
           // DataReferenceRecord *
        kQTNewMoviePropertyID_Active                = 'actv',
           // Boolean *
        kQTNewMoviePropertyID_DontInteractWithUser  = 'intn',
           // Boolean *
};

/*QTNewMoviePropertyElement

Stores a movie property for NewMovieFromProperties.

struct QTNewMoviePropertyElement {
   QTPropertyClass       propClass;
   QTPropertyID          propID;
   ByteCount             propValueSize;
   QTPropertyValuePtr    propValueAddress;
   OSStatus              propStatus;
};
Fields
propClass
Discussion

A four-character code designating the class of a movie property. See New Movie Property Codes.
propID
Discussion

The ID of the property.
propValueSize
Discussion

The size in bytes of the property passed in propValueAddress.
propValueAddress
Discussion

A pointer to a movie property. Since the data type is fixed for each element's property class and ID, these is no ambiguity about the data type for its property value.
propStatus
Discussion

Indicates any problems with the property. For example, if a property is not understood by the function it is passed to, this field is set appropriately. See the discussion in NewMovieFromProperties.
Discussion

When you call NewMovieFromProperties, you allocate and own arrays of these elements to pass to it, as well as the property values that each element points to. You are responsible for disposing of all of these memory allocations.
Related Functions
Associated function: NewMovieFromProperties 
Declared In
Movies.h*/
struct QTNewMoviePropertyElement {
   QTPropertyClass       propClass;
   QTPropertyID          propID;
   ByteCount             propValueSize;
   QTPropertyValuePtr    propValueAddress;
   OSStatus              propStatus;
};
typedef struct QTNewMoviePropertyElement QTNewMoviePropertyElement;

/*/*Atom ID Codes

Identify the four-character type codes of atoms.

enum {
   ConnectionSpeedPrefsType      = 'cspd',
   ConnectionSpeedIsValidPrefsType = 'vspd'
};
enum {
   kEffectNameAtom               = 'name',
   // name of effect 
   kEffectTypeAtom               = 'type',
   //codec sub-type for effect 
   kEffectManufacturerAtom       = 'manu' // codec manufacturer for effect 
};
enum {
   kGraphicsExportGroup          = 'expo',
   kGraphicsExportFileType       = 'ftyp',
   kGraphicsExportMIMEType       = 'mime',
   kGraphicsExportExtension      = 'ext ',
   kGraphicsExportDescription    = 'desc'
};
enum {
   kInputMapSubInputID           = 'subi'
};
enum {
   kMovieMediaDataReference      = 'mmdr',
   // data reference
   kMovieMediaDefaultDataReferenceID = 'ddri',
   //atom id
   kMovieMediaSlaveTime          = 'slti',
   // boolean
   kMovieMediaSlaveAudio         = 'slau',
   // boolean
   kMovieMediaSlaveGraphicsMode  = 'slgr',
   // boolean
   kMovieMediaAutoPlay           = 'play',
   // boolean
   kMovieMediaLoop               = 'loop',
   / /UInt8 (0=no loop,
   1=loop,
   2=palindrome loop)
   kMovieMediaUseMIMEType        = 'mime',
   / string indicating the MIME type to use for the dataref (usually not required)
   kMovieMediaTitle              = 'titl',
   // string of the media's title (tooltips)
   kMovieMediaAltText            = 'altt',
   / string of alternate text if media isn't loaded
   kMovieMediaClipBegin          = 'clpb',
   / MovieMediaTimeRecord of start time of embedded media/
   kMovieMediaClipDuration       = 'clpd',
   /MovieMediaTimeRecord of duration of embedded media/
   kMovieMediaRegionAtom         = 'regi',
   / contains subatoms that describe layout/
   kMovieMediaSlaveTrackDuration = 'sltr',
   / Boolean indicating that media handler should adjust track and media based on actual embedded movie duration/
   kMovieMediaEnableFrameStepping = 'enfs',
   / boolean. if true stepping on external movie steps frames within embedded movie./
   kMovieMediaBackgroundColor    = 'bkcl',
   / RGBColor./
   kMovieMediaPrerollTime        = 'prer' / SInt32 indicating preroll time/
};
enum {
   kMovieMediaSpatialAdjustment  = 'fit ',
   / OSType from kMovieMediaFit/
   kMovieMediaRectangleAtom      = 'rect',
   kMovieMediaTop                = 'top ',
   kMovieMediaLeft               = 'left',
   kMovieMediaWidth              = 'wd  ',
   kMovieMediaHeight             = 'ht  '
};
enum {
   kQTEventType                  = 'evnt',
   kAction                       = 'actn',
   kWhichAction                  = 'whic',
   kActionParameter              = 'parm',
   kActionTarget                 = 'targ',
   kActionFlags                  = 'flag',
   kActionParameterMinValue      = 'minv',
   kActionParameterMaxValue      = 'maxv',
   kActionListAtomType           = 'list',
   kExpressionContainerAtomType  = 'expr',
   kConditionalAtomType          = 'test',
   kOperatorAtomType             = 'oper',
   kOperandAtomType              = 'oprn',
   kCommentAtomType              = 'why ',
   kCustomActionHandler          = 'cust',
   kCustomHandlerID              = 'id  ',
   kCustomHandlerDesc            = 'desc',
   kQTEventRecordAtomType        = 'erec'
};
enum {
   kQTParseTextHREFText          = 'text',
   / string/
   kQTParseTextHREFBaseURL       = 'burl',
   / string/
   kQTParseTextHREFClickPoint    = 'clik',
   / Point; if present,
   QTParseTextHREF will expand URLs to support server-side image maps/
   kQTParseTextHREFUseAltDelim   = 'altd',
   / boolean; if no kQTParseTextHREFDelimiter,
   delim is ':'/
   kQTParseTextHREFDelimiter     = 'delm',
   /character/
   kQTParseTextHREFRecomposeHREF = 'rhrf' / Boolean; if true,
   QTParseTextHREF returns recomposed HREF with URL expanded as appropriate/
};
enum {
   kQTResolutionSettings         = 'reso',
   kQTTargetDataSize             = 'dasz',
   kQTDontRecompress             = 'dntr',
   kQTInterlaceStyle             = 'ilac',
   kQTColorSyncProfile           = 'iccp',
   kQTThumbnailSettings          = 'thum',
   kQTEnableExif                 = 'exif',
   / UInt8 (boolean)/
   kQTMetaData                   = 'meta'
};
enum {
   kQTSConnectionPrefsType       = 'stcm',
   / root atom that all other atoms are contained in/
   /    kQTSNotUsedForProxyPrefsType = 'nopr',
   //        comma-delimited list of URLs that are never used for proxies/
   kQTSConnectionMethodPrefsType = 'mthd',
   /      connection method (OSType that matches one of the following three)/
   kQTSDirectConnectPrefsType    = 'drct',
   /       used if direct connect (QTSDirectConnectPrefsRecord)/
   /    kQTSRTSPProxyPrefsType =     'rtsp',
   //   used if RTSP Proxy (QTSProxyPrefsRecord)/
   kQTSSOCKSPrefsType            = 'sock' /      used if SOCKS Proxy (QTSProxyPrefsRecord)/
};
enum {
   kQTSNullNotification          = 'null',
   / NULL /
   kQTSErrorNotification         = 'err ',
   / QTSErrorParams,
   optional /
   kQTSNewPresDetectedNotification = 'newp',
   / QTSNewPresDetectedParams* /
   kQTSPresBeginChangingNotification = 'prcb',
   / NULL /
   kQTSPresDoneChangingNotification = 'prcd',
   / NULL /
   kQTSPresentationChangedNotification = 'prch',
   / NULL /
   kQTSNewStreamNotification     = 'stnw',
   / QTSNewStreamParams* /
   kQTSStreamBeginChangingNotification = 'stcb',
   / QTSStream /
   kQTSStreamDoneChangingNotification = 'stcd',
   / QTSStream /
   kQTSStreamChangedNotification = 'stch',
   / QTSStreamChangedParams/
   kQTSStreamGoneNotification    = 'stgn',
   / QTSStreamGoneParams/
   kQTSPreviewAckNotification    = 'pvak',
   / QTSStream /
   kQTSPrerollAckNotification    = 'pack',
   / QTSStream /
   kQTSStartAckNotification      = 'sack',
   / QTSStream /
   kQTSStopAckNotification       = 'xack',
   / QTSStream /
   kQTSStatusNotification        = 'stat',
   / QTSStatusParams/
   kQTSURLNotification           = 'url ',
   / QTSURLParams/
   kQTSDurationNotification      = 'dura',
   / QTSDurationAtom/
   kQTSNewPresentationNotification = 'nprs',
   / QTSPresentation /
   kQTSPresentationGoneNotification = 'xprs',
   / QTSPresentation /
   kQTSPresentationDoneNotification = 'pdon',
   / NULL /
   kQTSBandwidthAlertNotification = 'bwal',
   / QTSBandwidthAlertParams/
   kQTSAnnotationsChangedNotification = 'meta' / NULL /
};
enum {
   kQTSStatisticsInfo            = 'stat',
   / QTSStatisticsParams* /  
   kQTSMinStatusDimensionsInfo   = 'mstd',
   / QTSDimensionParams/
   kQTSNormalStatusDimensionsInfo = 'nstd',
   /QTSDimensionParams* /
   kQTSTotalDataRateInfo         = 'drtt',
   / UInt32,
   add to what's there /
   kQTSTotalDataRateInInfo       = 'drti',
   / UInt32,
   add to what's there /
   kQTSTotalDataRateOutInfo      = 'drto',
   / UInt32*,
   add to what's there * /
   kQTSLostPercentInfo           = 'lpct',
   / * QTSLostPercentParams*,
   add to what's there * /
   kQTSNumViewersInfo            = 'nviw',
   / *  UInt32* *  /
   kQTSMediaTypeInfo             = 'mtyp',
   / *  OSType* * /
   kQTSNameInfo                  = 'name',
   / * QTSNameParams* * /
   kQTSCanHandleSendDataType     = 'chsd',
   /* QTSCanHandleSendDataTypeParams* * /   
   kQTSAnnotationsInfo           = 'meta',
   / * QTAtomContainer * /
   kQTSRemainingBufferTimeInfo   = 'btms',
   / * UInt32* remaining buffer time before playback,
   in microseconds * /
   kQTSInfo_SettingsText         = 'sttx',
   / * QTSSettingsTextParams* * /
   kQTSInfo_AverageFrameRate     = 'fps ' / *   UnsignedFixed* * /
};
enum {
   kQTSStreamMediaType           = 'strm'
};
enum {
   kQTSTargetBufferDurationInfo  = 'bufr',
   / * Fixed* in seconds; expected,
   not actual * /
   kQTSDurationInfo              = 'dura',
   / * QTSDurationAtom* * /
   kQTSSoundLevelMeteringEnabledInfo = 'mtrn',
   /* Boolean* * /
   kQTSSoundLevelMeterInfo       = 'levm',
   /* LevelMeterInfoPtr * /
   kQTSSourceTrackIDInfo         = 'otid',
   / * UInt32* * /
   kQTSSourceLayerInfo           = 'olyr',
   / * UInt16* * /
   kQTSSourceLanguageInfo        = 'olng',
   / * UInt16* * /
   kQTSSourceTrackFlagsInfo      = 'otfl',
   / * SInt32* * /
   kQTSSourceDimensionsInfo      = 'odim',
   / * QTSDimensionParams* * /
   kQTSSourceVolumesInfo         = 'ovol',
   /* QTSVolumesParams* * /
   kQTSSourceMatrixInfo          = 'omat',
   / * MatrixRecord* * /
   kQTSSourceClipRectInfo        = 'oclp',
   / * Rect* * /
   kQTSSourceGraphicsModeInfo    = 'ogrm',
   /* QTSGraphicsModeParams* * /  
   kQTSSourceScaleInfo           = 'oscl',
   / * Point* * /
   kQTSSourceBoundingRectInfo    = 'orct',
   / * Rect* * /
   kQTSSourceUserDataInfo        = 'oudt',
   /* UserData * / 
   kQTSSourceInputMapInfo        = 'oimp',
   / * QTAtomContainer * /
   kQTSInfo_DataProc             = 'datp',
   /* QTSDataProcParams* * /
   kQTSInfo_SendDataExtras       = 'dext',
   / * QTSSendDataExtrasParams* * /
   kQTSInfo_HintTrackID          = 'htid',
   / * long* * /
   kQTSInfo_URL                  = 'url ',
   / * Handle*,
   cstring in handle * /
   kQTSInfo_Authentication       = 'auup',
   /* QTSAuthenticationParams * /
   kQTSInfo_MediaPacketizer      = 'rmpk' / * ComponentInstance * /
};
enum {
   kQTVRNodeHeaderAtomType       = 'ndhd',
   kQTVRHotSpotParentAtomType    = 'hspa',
   kQTVRHotSpotAtomType          = 'hots',
   kQTVRHotSpotInfoAtomType      = 'hsin',
   kQTVRLinkInfoAtomType         = 'link'
};
enum {
   kQTVRObjectInfoAtomID         = 1,
   kQTVRObjectImageTrackRefAtomID = 1,
   /* New with 2.1,
   it adds a track reference to select between multiple image tracks* /
   kQTVRObjectHotSpotTrackRefAtomID = 1  /* New with 2.1,
   it adds a track reference to select between multiple hotspot tracks* /
};
enum {
   kQTVRStringAtomType           = 'vrsg',
   kQTVRStringEncodingAtomType   = 'vrse',
   /* New with 2.1* /
   kQTVRPanoSampleDataAtomType   = 'pdat',
   kQTVRObjectInfoAtomType       = 'obji',
   kQTVRImageTrackRefAtomType    = 'imtr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.* /
   kQTVRHotSpotTrackRefAtomType  = 'hstr',
   / * Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.* /
   kQTVRAngleRangeAtomType       = 'arng',
   kQTVRTrackRefArrayAtomType    = 'tref',
   kQTVRPanConstraintAtomType    = 'pcon',
   kQTVRTiltConstraintAtomType   = 'tcon',
   kQTVRFOVConstraintAtomType    = 'fcon',
   kQTVRCubicViewAtomType        = 'cuvw',
   /* New with 5.0* /
   kQTVRCubicFaceDataAtomType    = 'cufa' / * New with 5.0* /
};
enum {
   kQTVRWorldHeaderAtomType      = 'vrsc',
   kQTVRImagingParentAtomType    = 'imgp',
   kQTVRPanoImagingAtomType      = 'impn',
   kQTVRObjectImagingAtomType    = 'imob',
   kQTVRNodeParentAtomType       = 'vrnp',
   kQTVRNodeIDAtomType           = 'vrni',
   kQTVRNodeLocationAtomType     = 'nloc',
   kQTVRCursorParentAtomType     = 'vrcp',
   /* New with 2.1* /
   kQTVRCursorAtomType           = 'CURS',
   /* New with 2.1* /
   kQTVRColorCursorAtomType      = 'crsr' /* New with 2.1* /
};
enum {
   kSpriteAtomType               = 'sprt',
   kSpriteImagesContainerAtomType = 'imct',
   kSpriteImageAtomType          = 'imag',
   kSpriteImageDataAtomType      = 'imda',
   kSpriteImageDataRefAtomType   = 'imre',
   kSpriteImageDataRefTypeAtomType = 'imrt',
   kSpriteImageGroupIDAtomType   = 'imgr',
   kSpriteImageRegistrationAtomType = 'imrg',
   kSpriteImageDefaultImageIndexAtomType = 'defi',
   kSpriteSharedDataAtomType     = 'dflt',
   kSpriteNameAtomType           = 'name',
   kSpriteImageNameAtomType      = 'name',
   kSpriteUsesImageIDsAtomType   = 'uses',
   /* leaf data is an array of QTAtomID's,
   one per image used* /
   kSpriteBehaviorsAtomType      = 'beha',
   kSpriteImageBehaviorAtomType  = 'imag',
   kSpriteCursorBehaviorAtomType = 'crsr',
   kSpriteStatusStringsBehaviorAtomType = 'sstr',
   kSpriteVariablesContainerAtomType = 'vars',
   kSpriteStringVariableAtomType = 'strv',
   kSpriteFloatingPointVariableAtomType = 'flov'
};
enum {
   kTargetMovie                  = 'moov',
   /* no data * /
   kTargetMovieName              = 'mona',
   / * (PString movieName) * /
   kTargetMovieID                = 'moid',
   /* (long movieID) * /
   kTargetRootMovie              = 'moro',
   /* no data * /
   kTargetParentMovie            = 'mopa',
   / * no data * /
   kTargetChildMovieTrackName    = 'motn',
   / * (PString childMovieTrackName) * /
   kTargetChildMovieTrackID      = 'moti',
   /* (long childMovieTrackID) *  /
   kTargetChildMovieTrackIndex   = 'motx',
   /* (long childMovieTrackIndex) * /
   kTargetChildMovieMovieName    = 'momn',
   /* (PString childMovieName) * /
   kTargetChildMovieMovieID      = 'momi',
   /* (long childMovieID) * /
   kTargetTrackName              = 'trna',
   /* (PString trackName) * /
   kTargetTrackID                = 'trid',
   / * (long trackID) * /
   kTargetTrackType              = 'trty',
   / * (OSType trackType) * /
   kTargetTrackIndex             = 'trin',
   /* (long trackIndex) * /
   kTargetSpriteName             = 'spna',
   / * (PString spriteName) * /
   kTargetSpriteID               = 'spid',
   /* (QTAtomID spriteID) * /
   kTargetSpriteIndex            = 'spin',
   / * (short spriteIndex) * /
   kTargetQD3DNamedObjectName    = 'nana',
   / * (CString objectName) * /
   kTargetCurrentQTEventParams   = 'evpa' / * no data * /
};
enum {
   kTrackModifierInput           = 0x696E,
   /* is really 'in'* /
   kTrackModifierType            = 0x7479,
   /* is really 'ty'* /
   kTrackModifierReference       = 'ssrc',
   kTrackModifierObjectID        = 'obid',
   kTrackModifierInputName       = 'name'
};
enum {
   kTrackPropertyMediaType       = 'mtyp',
   /* OSType* /
   kTrackPropertyInstantiation   = 'inst' /* MovieMediaInstantiationInfoRecord* /
};
enum {
   kTrackReferenceChapterList    = 'chap',
   kTrackReferenceTimeCode       = 'tmcd',
   kTrackReferenceModifier       = 'ssrc'
};
enum {
   kTweenEntry                   = 'twen',
   kTweenData                    = 'data',
   kTweenType                    = 'twnt',
   kTweenStartOffset             = 'twst',
   kTweenDuration                = 'twdu',
   kTweenFlags                   = 'flag',
   kTweenOutputMin               = 'omin',
   kTweenOutputMax               = 'omax',
   kTweenSequenceElement         = 'seqe',
   kTween3dInitialCondition      = 'icnd',
   kTweenInterpolationID         = 'intr',
   kTweenRegionData              = 'qdrg',
   kTweenPictureData             = 'PICT',
   kListElementType              = 'type',
   kListElementDataType          = 'daty',
   kNameAtom                     = 'name',
   kInitialRotationAtom          = 'inro',
   kNonLinearTweenHeader         = 'nlth'
};
enum {
   MovieAID                      = 'moov',
   MovieHeaderAID                = 'mvhd',
   ClipAID                       = 'clip',
   RgnClipAID                    = 'crgn',
   MatteAID                      = 'matt',
   MatteCompAID                  = 'kmat',
   TrackAID                      = 'trak',
   UserDataAID                   = 'udta',
   TrackHeaderAID                = 'tkhd',
   EditsAID                      = 'edts',
   EditListAID                   = 'elst',
   MediaAID                      = 'mdia',
   MediaHeaderAID                = 'mdhd',
   MediaInfoAID                  = 'minf',
   VideoMediaInfoHeaderAID       = 'vmhd',
   SoundMediaInfoHeaderAID       = 'smhd',
   GenericMediaInfoHeaderAID     = 'gmhd',
   GenericMediaInfoAID           = 'gmin',
   DataInfoAID                   = 'dinf',
   DataRefAID                    = 'dref',
   SampleTableAID                = 'stbl',
   STSampleDescAID               = 'stsd',
   STTimeToSampAID               = 'stts',
   STSyncSampleAID               = 'stss',
   STSampleToChunkAID            = 'stsc',
   STShadowSyncAID               = 'stsh',
   HandlerAID                    = 'hdlr',
   STSampleSizeAID               = 'stsz',
   STChunkOffsetAID              = 'stco',
   STChunkOffset64AID            = 'co64',
   STSampleIDAID                 = 'stid',
   STCompositionOffsetAID        = 'ctts',
   STSampleDependencyAID         = 'sdtp',
   STCompositionShiftLeastGreatestAID = 'cslg',
   STPartialSyncSampleAID        = 'stps',
   DataRefContainerAID           = 'drfc',
   TrackReferenceAID             = 'tref',
   ColorTableAID                 = 'ctab',
   LoadSettingsAID               = 'load',
   PropertyAtomAID               = 'code',
   InputMapAID                   = 'imap',
   MovieBufferHintsAID           = 'mbfh',
   MovieDataRefAliasAID          = 'mdra',
   SoundLocalizationAID          = 'sloc',
   CompressedMovieAID            = 'cmov',
   CompressedMovieDataAID        = 'cmvd',
   DataCompressionAtomAID        = 'dcom',
   ReferenceMovieRecordAID       = 'rmra',
   ReferenceMovieDescriptorAID   = 'rmda',
   ReferenceMovieDataRefAID      = 'rdrf',
   ReferenceMovieVersionCheckAID = 'rmvc',
   ReferenceMovieDataRateAID     = 'rmdr',
   ReferenceMovieComponentCheckAID = 'rmcd',
   ReferenceMovieQualityAID      = 'rmqu',
   ReferenceMovieLanguageAID     = 'rmla',
   ReferenceMovieCPURatingAID    = 'rmcs',
   ReferenceMovieAlternateGroupAID = 'rmag',
   ReferenceMovieNetworkStatusAID = 'rnet',
   CloneMediaAID                 = 'clon',
   FileTypeAID                   = 'ftyp',
   SecureContentInfoAID          = 'sinf',
   SecureContentSchemeTypeAID    = 'schm',
   SecureContentSchemeInfoAID    = 'schi'
};
enum {
   MovieResourceAtomType         = 'moov',
   MovieDataAtomType             = 'mdat',
   FreeAtomType                  = 'free',
   SkipAtomType                  = 'skip',
   WideAtomPlaceholderType       = 'wide'
};
enum {
   quickTimeImageFileImageDescriptionAtom = 'idsc',
   quickTimeImageFileImageDataAtom = 'idat',
   quickTimeImageFileMetaDataAtom = 'meta',
   quickTimeImageFileColorSyncProfileAtom = 'iicc'
};
Constants
kMovieMediaDefaultDataReferenceID

Atom id. 

Available in Mac OS X v10.0 and later.
kMovieMediaSlaveTime

Boolean. 

Available in Mac OS X v10.0 and later.
kMovieMediaSlaveGraphicsMode

Boolean. 

Available in Mac OS X v10.0 and later.
kMovieMediaBackgroundColor

RGBColor.. 

Available in Mac OS X v10.0 and later.
kMovieMediaPrerollTime

SInt32 indicating preroll time. 

Available in Mac OS X v10.0 and later.
kQTParseTextHREFText

String. 

Available in Mac OS X v10.0 and later.
kQTEnableExif

UInt8 (Boolean). 

Available in Mac OS X v10.1 and later.
kTargetChildMovieTrackIndex

(long childMovieTrackIndex). 

Available in Mac OS X v10.0 and later.
kTargetChildMovieMovieName

(PString childMovieName). 

Available in Mac OS X v10.0 and later.
kTargetTrackType

(OSType trackType). 

Available in Mac OS X v10.0 and later.
kTargetTrackIndex

(long trackIndex). 

Available in Mac OS X v10.0 and later.
kTargetSpriteName

(PString spriteName). 

Available in Mac OS X v10.0 and later.
kTargetSpriteID

(QTAtomID spriteID). 

Available in Mac OS X v10.0 and later.
kTargetQD3DNamedObjectName

(CString objectName). 

Available in Mac OS X v10.0 and later.
kTargetCurrentQTEventParams

No data. 

Available in Mac OS X v10.0 and later.*/
enum {
   ConnectionSpeedPrefsType      = 'cspd',
   ConnectionSpeedIsValidPrefsType = 'vspd'
};
enum {
   kEffectNameAtom               = 'name',
   /* name of effect */
   kEffectTypeAtom               = 'type',
   /* codec sub-type for effect */
   kEffectManufacturerAtom       = 'manu' /* codec manufacturer for effect */
};
enum {
   kGraphicsExportGroup          = 'expo',
   kGraphicsExportFileType       = 'ftyp',
   kGraphicsExportMIMEType       = 'mime',
   kGraphicsExportExtension      = 'ext ',
   kGraphicsExportDescription    = 'desc'
};
enum {
   kInputMapSubInputID           = 'subi'
};
enum {
   kMovieMediaDataReference      = 'mmdr',
   /* data reference*/
   kMovieMediaDefaultDataReferenceID = 'ddri',
   /* atom id*/
   kMovieMediaSlaveTime          = 'slti',
   /* boolean*/
   kMovieMediaSlaveAudio         = 'slau',
   /* boolean*/
   kMovieMediaSlaveGraphicsMode  = 'slgr',
   /* boolean*/
   kMovieMediaAutoPlay           = 'play',
   /* boolean*/
   kMovieMediaLoop               = 'loop',
   /* UInt8 (0=no loop,
   1=loop,
   2=palindrome loop)*/
   kMovieMediaUseMIMEType        = 'mime',
   /* string indicating the MIME type to use for the dataref (usually not required)*/
   kMovieMediaTitle              = 'titl',
   /* string of the media's title (tooltips)*/
   kMovieMediaAltText            = 'altt',
   /* string of alternate text if media isn't loaded*/
   kMovieMediaClipBegin          = 'clpb',
   /* MovieMediaTimeRecord of start time of embedded media*/
   kMovieMediaClipDuration       = 'clpd',
   /* MovieMediaTimeRecord of duration of embedded media*/
   kMovieMediaRegionAtom         = 'regi',
   /* contains subatoms that describe layout*/
   kMovieMediaSlaveTrackDuration = 'sltr',
   /* Boolean indicating that media handler should adjust track and media based on actual embedded movie duration*/
   kMovieMediaEnableFrameStepping = 'enfs',
   /* boolean. if true stepping on external movie steps frames within embedded movie.*/
   kMovieMediaBackgroundColor    = 'bkcl',
   /* RGBColor.*/
   kMovieMediaPrerollTime        = 'prer' /* SInt32 indicating preroll time*/
};
enum {
   kMovieMediaSpatialAdjustment  = 'fit ',
   /* OSType from kMovieMediaFit**/
   kMovieMediaRectangleAtom      = 'rect',
   kMovieMediaTop                = 'top ',
   kMovieMediaLeft               = 'left',
   kMovieMediaWidth              = 'wd  ',
   kMovieMediaHeight             = 'ht  '
};
enum {
   kQTEventType                  = 'evnt',
   kAction                       = 'actn',
   kWhichAction                  = 'whic',
   kActionParameter              = 'parm',
   kActionTarget                 = 'targ',
   kActionFlags                  = 'flag',
   kActionParameterMinValue      = 'minv',
   kActionParameterMaxValue      = 'maxv',
   kActionListAtomType           = 'list',
   kExpressionContainerAtomType  = 'expr',
   kConditionalAtomType          = 'test',
   kOperatorAtomType             = 'oper',
   kOperandAtomType              = 'oprn',
   kCommentAtomType              = 'why ',
   kCustomActionHandler          = 'cust',
   kCustomHandlerID              = 'id  ',
   kCustomHandlerDesc            = 'desc',
   kQTEventRecordAtomType        = 'erec'
};
enum {
   kQTParseTextHREFText          = 'text',
   /* string*/
   kQTParseTextHREFBaseURL       = 'burl',
   /* string*/
   kQTParseTextHREFClickPoint    = 'clik',
   /* Point; if present,
   QTParseTextHREF will expand URLs to support server-side image maps*/
   kQTParseTextHREFUseAltDelim   = 'altd',
   /* boolean; if no kQTParseTextHREFDelimiter,
   delim is ':'*/
   kQTParseTextHREFDelimiter     = 'delm',
   /* character*/
   kQTParseTextHREFRecomposeHREF = 'rhrf' /* Boolean; if true,
   QTParseTextHREF returns recomposed HREF with URL expanded as appropriate*/
};
enum {
   kQTResolutionSettings         = 'reso',
   kQTTargetDataSize             = 'dasz',
   kQTDontRecompress             = 'dntr',
   kQTInterlaceStyle             = 'ilac',
   kQTColorSyncProfile           = 'iccp',
   kQTThumbnailSettings          = 'thum',
   kQTEnableExif                 = 'exif',
   /* UInt8 (boolean)*/
   kQTMetaData                   = 'meta'
};
enum {
   kQTSConnectionPrefsType       = 'stcm',
   /* root atom that all other atoms are contained in*/
   /*    kQTSNotUsedForProxyPrefsType = 'nopr',
   //        comma-delimited list of URLs that are never used for proxies*/
   kQTSConnectionMethodPrefsType = 'mthd',
   /*      connection method (OSType that matches one of the following three)*/
   kQTSDirectConnectPrefsType    = 'drct',
   /*       used if direct connect (QTSDirectConnectPrefsRecord)*/
   /*    kQTSRTSPProxyPrefsType =     'rtsp',
   //   used if RTSP Proxy (QTSProxyPrefsRecord)*/
   kQTSSOCKSPrefsType            = 'sock' /*       used if SOCKS Proxy (QTSProxyPrefsRecord)*/
};
enum {
   kQTSNullNotification          = 'null',
   /* NULL */
   kQTSErrorNotification         = 'err ',
   /* QTSErrorParams*,
   optional */
   kQTSNewPresDetectedNotification = 'newp',
   /* QTSNewPresDetectedParams* */
   kQTSPresBeginChangingNotification = 'prcb',
   /* NULL */
   kQTSPresDoneChangingNotification = 'prcd',
   /* NULL */
   kQTSPresentationChangedNotification = 'prch',
   /* NULL */
   kQTSNewStreamNotification     = 'stnw',
   /* QTSNewStreamParams* */
   kQTSStreamBeginChangingNotification = 'stcb',
   /* QTSStream */
   kQTSStreamDoneChangingNotification = 'stcd',
   /* QTSStream */
   kQTSStreamChangedNotification = 'stch',
   /* QTSStreamChangedParams* */
   kQTSStreamGoneNotification    = 'stgn',
   /* QTSStreamGoneParams* */
   kQTSPreviewAckNotification    = 'pvak',
   /* QTSStream */
   kQTSPrerollAckNotification    = 'pack',
   /* QTSStream */
   kQTSStartAckNotification      = 'sack',
   /* QTSStream */
   kQTSStopAckNotification       = 'xack',
   /* QTSStream */
   kQTSStatusNotification        = 'stat',
   /* QTSStatusParams* */
   kQTSURLNotification           = 'url ',
   /* QTSURLParams* */
   kQTSDurationNotification      = 'dura',
   /* QTSDurationAtom* */
   kQTSNewPresentationNotification = 'nprs',
   /* QTSPresentation */
   kQTSPresentationGoneNotification = 'xprs',
   /* QTSPresentation */
   kQTSPresentationDoneNotification = 'pdon',
   /* NULL */
   kQTSBandwidthAlertNotification = 'bwal',
   /* QTSBandwidthAlertParams* */
   kQTSAnnotationsChangedNotification = 'meta' /* NULL */
};
enum {
   kQTSStatisticsInfo            = 'stat',
   /* QTSStatisticsParams* */
   kQTSMinStatusDimensionsInfo   = 'mstd',
   /* QTSDimensionParams* */
   kQTSNormalStatusDimensionsInfo = 'nstd',
   /* QTSDimensionParams* */
   kQTSTotalDataRateInfo         = 'drtt',
   /* UInt32*,
   add to what's there */
   kQTSTotalDataRateInInfo       = 'drti',
   /* UInt32*,
   add to what's there */
   kQTSTotalDataRateOutInfo      = 'drto',
   /* UInt32*,
   add to what's there */
   kQTSLostPercentInfo           = 'lpct',
   /* QTSLostPercentParams*,
   add to what's there */
   kQTSNumViewersInfo            = 'nviw',
   /* UInt32* */
   kQTSMediaTypeInfo             = 'mtyp',
   /* OSType* */
   kQTSNameInfo                  = 'name',
   /* QTSNameParams* */
   kQTSCanHandleSendDataType     = 'chsd',
   /* QTSCanHandleSendDataTypeParams* */
   kQTSAnnotationsInfo           = 'meta',
   /* QTAtomContainer */
   kQTSRemainingBufferTimeInfo   = 'btms',
   /* UInt32* remaining buffer time before playback,
   in microseconds */
   kQTSInfo_SettingsText         = 'sttx',
   /* QTSSettingsTextParams* */
   kQTSInfo_AverageFrameRate     = 'fps ' /* UnsignedFixed* */
};
enum {
   kQTSStreamMediaType           = 'strm'
};
enum {
   kQTSTargetBufferDurationInfo  = 'bufr',
   /* Fixed* in seconds; expected,
   not actual */
   kQTSDurationInfo              = 'dura',
   /* QTSDurationAtom* */
   kQTSSoundLevelMeteringEnabledInfo = 'mtrn',
   /* Boolean* */
   kQTSSoundLevelMeterInfo       = 'levm',
   /* LevelMeterInfoPtr */
   kQTSSourceTrackIDInfo         = 'otid',
   /* UInt32* */
   kQTSSourceLayerInfo           = 'olyr',
   /* UInt16* */
   kQTSSourceLanguageInfo        = 'olng',
   /* UInt16* */
   kQTSSourceTrackFlagsInfo      = 'otfl',
   /* SInt32* */
   kQTSSourceDimensionsInfo      = 'odim',
   /* QTSDimensionParams* */
   kQTSSourceVolumesInfo         = 'ovol',
   /* QTSVolumesParams* */
   kQTSSourceMatrixInfo          = 'omat',
   /* MatrixRecord* */
   kQTSSourceClipRectInfo        = 'oclp',
   /* Rect* */
   kQTSSourceGraphicsModeInfo    = 'ogrm',
   /* QTSGraphicsModeParams* */
   kQTSSourceScaleInfo           = 'oscl',
   /* Point* */
   kQTSSourceBoundingRectInfo    = 'orct',
   /* Rect* */
   kQTSSourceUserDataInfo        = 'oudt',
   /* UserData */
   kQTSSourceInputMapInfo        = 'oimp',
   /* QTAtomContainer */
   kQTSInfo_DataProc             = 'datp',
   /* QTSDataProcParams* */
   kQTSInfo_SendDataExtras       = 'dext',
   /* QTSSendDataExtrasParams* */
   kQTSInfo_HintTrackID          = 'htid',
   /* long* */
   kQTSInfo_URL                  = 'url ',
   /* Handle*,
   cstring in handle */
   kQTSInfo_Authentication       = 'auup',
   /* QTSAuthenticationParams */
   kQTSInfo_MediaPacketizer      = 'rmpk' /* ComponentInstance */
};
enum {
   kQTVRNodeHeaderAtomType       = 'ndhd',
   kQTVRHotSpotParentAtomType    = 'hspa',
   kQTVRHotSpotAtomType          = 'hots',
   kQTVRHotSpotInfoAtomType      = 'hsin',
   kQTVRLinkInfoAtomType         = 'link'
};
enum {
   kQTVRObjectInfoAtomID         = 1,
   kQTVRObjectImageTrackRefAtomID = 1,
   /* New with 2.1,
   it adds a track reference to select between multiple image tracks*/
   kQTVRObjectHotSpotTrackRefAtomID = 1  /* New with 2.1,
   it adds a track reference to select between multiple hotspot tracks*/
};
enum {
   kQTVRStringAtomType           = 'vrsg',
   kQTVRStringEncodingAtomType   = 'vrse',
   /* New with 2.1*/
   kQTVRPanoSampleDataAtomType   = 'pdat',
   kQTVRObjectInfoAtomType       = 'obji',
   kQTVRImageTrackRefAtomType    = 'imtr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.*/
   kQTVRHotSpotTrackRefAtomType  = 'hstr',
   /* Parent is kQTVRObjectInfoAtomType. Required if track ref is not 1 as required by 2.0 format.*/
   kQTVRAngleRangeAtomType       = 'arng',
   kQTVRTrackRefArrayAtomType    = 'tref',
   kQTVRPanConstraintAtomType    = 'pcon',
   kQTVRTiltConstraintAtomType   = 'tcon',
   kQTVRFOVConstraintAtomType    = 'fcon',
   kQTVRCubicViewAtomType        = 'cuvw',
   /* New with 5.0*/
   kQTVRCubicFaceDataAtomType    = 'cufa' /* New with 5.0*/
};
enum {
//   kQTVRWorldHeaderAtomType      = 'vrsc',
   //kQTVRImagingParentAtomType    = 'imgp',
   //kQTVRPanoImagingAtomType      = 'impn',
   //kQTVRObjectImagingAtomType    = 'imob',
   //kQTVRNodeParentAtomType       = 'vrnp',
   //kQTVRNodeIDAtomType           = 'vrni',
   //kQTVRNodeLocationAtomType     = 'nloc',
   kQTVRCursorParentAtomType     = 'vrcp',
   /* New with 2.1*/
   kQTVRCursorAtomType           = 'CURS',
   /* New with 2.1*/
   kQTVRColorCursorAtomType      = 'crsr' /* New with 2.1*/
};
enum {
   kSpriteAtomType               = 'sprt',
   kSpriteImagesContainerAtomType = 'imct',
   kSpriteImageAtomType          = 'imag',
   kSpriteImageDataAtomType      = 'imda',
   kSpriteImageDataRefAtomType   = 'imre',
   kSpriteImageDataRefTypeAtomType = 'imrt',
   kSpriteImageGroupIDAtomType   = 'imgr',
   kSpriteImageRegistrationAtomType = 'imrg',
   kSpriteImageDefaultImageIndexAtomType = 'defi',
   kSpriteSharedDataAtomType     = 'dflt',
   kSpriteNameAtomType           = 'name',
   kSpriteImageNameAtomType      = 'name',
   kSpriteUsesImageIDsAtomType   = 'uses',
   /* leaf data is an array of QTAtomID's,
   one per image used*/
   kSpriteBehaviorsAtomType      = 'beha',
   kSpriteImageBehaviorAtomType  = 'imag',
   kSpriteCursorBehaviorAtomType = 'crsr',
   kSpriteStatusStringsBehaviorAtomType = 'sstr',
   kSpriteVariablesContainerAtomType = 'vars',
   kSpriteStringVariableAtomType = 'strv',
   kSpriteFloatingPointVariableAtomType = 'flov'
};
enum {
   kTargetMovie                  = 'moov',
   /* no data */
   kTargetMovieName              = 'mona',
   /* (PString movieName) */
   kTargetMovieID                = 'moid',
   /* (long movieID) */
   kTargetRootMovie              = 'moro',
   /* no data */
   kTargetParentMovie            = 'mopa',
   /* no data */
   kTargetChildMovieTrackName    = 'motn',
   /* (PString childMovieTrackName) */
   kTargetChildMovieTrackID      = 'moti',
   /* (long childMovieTrackID) */
   kTargetChildMovieTrackIndex   = 'motx',
   /* (long childMovieTrackIndex) */
   kTargetChildMovieMovieName    = 'momn',
   /* (PString childMovieName) */
   kTargetChildMovieMovieID      = 'momi',
   /* (long childMovieID) */
   kTargetTrackName              = 'trna',
   /* (PString trackName) */
   kTargetTrackID                = 'trid',
   /* (long trackID) */
   kTargetTrackType              = 'trty',
   /* (OSType trackType) */
   kTargetTrackIndex             = 'trin',
   /* (long trackIndex) */
   kTargetSpriteName             = 'spna',
   /* (PString spriteName) */
   kTargetSpriteID               = 'spid',
   /* (QTAtomID spriteID) */
   kTargetSpriteIndex            = 'spin',
   /* (short spriteIndex) */
   kTargetQD3DNamedObjectName    = 'nana',
   /* (CString objectName) */
   kTargetCurrentQTEventParams   = 'evpa' /* no data */
};
enum {
   kTrackModifierInput           = 0x696E,
   /* is really 'in'*/
   kTrackModifierType            = 0x7479,
   /* is really 'ty'*/
   kTrackModifierReference       = 'ssrc',
   kTrackModifierObjectID        = 'obid',
   kTrackModifierInputName       = 'name'
};
enum {
   kTrackPropertyMediaType       = 'mtyp',
   /* OSType*/
   kTrackPropertyInstantiation   = 'inst' /* MovieMediaInstantiationInfoRecord*/
};
enum {
   kTrackReferenceChapterList    = 'chap',
   kTrackReferenceTimeCode       = 'tmcd',
   kTrackReferenceModifier       = 'ssrc'
};
enum {
   kTweenEntry                   = 'twen',
   kTweenData                    = 'data',
   kTweenType                    = 'twnt',
   kTweenStartOffset             = 'twst',
   kTweenDuration                = 'twdu',
   kTweenFlags                   = 'flag',
   kTweenOutputMin               = 'omin',
   kTweenOutputMax               = 'omax',
   kTweenSequenceElement         = 'seqe',
   kTween3dInitialCondition      = 'icnd',
   kTweenInterpolationID         = 'intr',
   kTweenRegionData              = 'qdrg',
   kTweenPictureData             = 'PICT',
   kListElementType              = 'type',
   kListElementDataType          = 'daty',
   kNameAtom                     = 'name',
   kInitialRotationAtom          = 'inro',
   kNonLinearTweenHeader         = 'nlth'
};
enum {
   MovieAID                      = 'moov',
   MovieHeaderAID                = 'mvhd',
   ClipAID                       = 'clip',
   RgnClipAID                    = 'crgn',
   MatteAID                      = 'matt',
   MatteCompAID                  = 'kmat',
   TrackAID                      = 'trak',
   UserDataAID                   = 'udta',
   TrackHeaderAID                = 'tkhd',
   EditsAID                      = 'edts',
   EditListAID                   = 'elst',
   MediaAID                      = 'mdia',
   MediaHeaderAID                = 'mdhd',
   MediaInfoAID                  = 'minf',
   VideoMediaInfoHeaderAID       = 'vmhd',
   SoundMediaInfoHeaderAID       = 'smhd',
   GenericMediaInfoHeaderAID     = 'gmhd',
   GenericMediaInfoAID           = 'gmin',
   DataInfoAID                   = 'dinf',
   DataRefAID                    = 'dref',
   SampleTableAID                = 'stbl',
   STSampleDescAID               = 'stsd',
   STTimeToSampAID               = 'stts',
   STSyncSampleAID               = 'stss',
   STSampleToChunkAID            = 'stsc',
   STShadowSyncAID               = 'stsh',
   HandlerAID                    = 'hdlr',
   STSampleSizeAID               = 'stsz',
   STChunkOffsetAID              = 'stco',
   STChunkOffset64AID            = 'co64',
   STSampleIDAID                 = 'stid',
   STCompositionOffsetAID        = 'ctts',
   STSampleDependencyAID         = 'sdtp',
   STCompositionShiftLeastGreatestAID = 'cslg',
   STPartialSyncSampleAID        = 'stps',
   DataRefContainerAID           = 'drfc',
   TrackReferenceAID             = 'tref',
   ColorTableAID                 = 'ctab',
   LoadSettingsAID               = 'load',
   PropertyAtomAID               = 'code',
   InputMapAID                   = 'imap',
   MovieBufferHintsAID           = 'mbfh',
   MovieDataRefAliasAID          = 'mdra',
   SoundLocalizationAID          = 'sloc',
   CompressedMovieAID            = 'cmov',
   CompressedMovieDataAID        = 'cmvd',
   DataCompressionAtomAID        = 'dcom',
   ReferenceMovieRecordAID       = 'rmra',
   ReferenceMovieDescriptorAID   = 'rmda',
   ReferenceMovieDataRefAID      = 'rdrf',
   ReferenceMovieVersionCheckAID = 'rmvc',
   ReferenceMovieDataRateAID     = 'rmdr',
   ReferenceMovieComponentCheckAID = 'rmcd',
   ReferenceMovieQualityAID      = 'rmqu',
   ReferenceMovieLanguageAID     = 'rmla',
   ReferenceMovieCPURatingAID    = 'rmcs',
   ReferenceMovieAlternateGroupAID = 'rmag',
   ReferenceMovieNetworkStatusAID = 'rnet',
   CloneMediaAID                 = 'clon',
   FileTypeAID                   = 'ftyp',
   SecureContentInfoAID          = 'sinf',
   SecureContentSchemeTypeAID    = 'schm',
   SecureContentSchemeInfoAID    = 'schi'
};
enum {
   MovieResourceAtomType         = 'moov',
   MovieDataAtomType             = 'mdat',
   FreeAtomType                  = 'free',
   SkipAtomType                  = 'skip',
   WideAtomPlaceholderType       = 'wide'
};
enum {
   quickTimeImageFileImageDescriptionAtom = 'idsc',
   quickTimeImageFileImageDataAtom = 'idat',
   quickTimeImageFileMetaDataAtom = 'meta',
   quickTimeImageFileColorSyncProfileAtom = 'iicc'
};

/*QTAtomID

Abst_QTAtomID

typedef long QTAtomID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTAtomID;

/*QTAtomType

Represents a type used by the Movie Toolkit API.

typedef long QTAtomType;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef long QTAtomType;


/*QTAtom

Abst_QTAtom

typedef long QTAtom;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long QTAtom;

/*QTAtomContainer

Abst_QTAtomContainer

typedef Handle QTAtomContainer;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle QTAtomContainer;

/*MovieController

Abst_MovieController

typedef ComponentInstance MovieController;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentInstance MovieController;

/*Discussion

The following constants identify sound description properties.
enum {
    kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay',
    kQTSoundDescriptionPropertyID_MagicCookie = 'kuki',
    kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd',
    kQTSoundDescriptionPropertyID_UserReadableText = 'text'
};

Special Considerations
kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay'

Used to get or set an AudioChannelLayout value. This is a variable-size property because it may contain an array of Channel Descriptions. You must get the size by calling QTSoundDescriptionGetPropertyInfo, allocate a structure of that size, and then get the property.
kQTSoundDescriptionPropertyID_MagicCookie = 'kuki'

Used to get or set opaque bytes. This is a variable-size property, because it is completely defined by the codec that uses the cookie. You must get the size by calling QTSoundDescriptionGetPropertyInfo, allocate a structure of that size, and then get the property.
kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd'

Used to get an AudioStreamBasicDescription value.
kQTSoundDescriptionPropertyID_UserReadableText = 'text'

Used to get a CFStringRef value. QTSoundDescriptionGetProperty does a CFRetain of the returned CFString on behalf of the caller, so the caller is responsible for calling CFRelease on the returned CFString.
Version Notes

Introduced in QuickTime 7.
Availability
Carbon status: Supported C interface file: Movies.h*/
enum {
    kQTSoundDescriptionPropertyID_AudioChannelLayout = 'clay',
    kQTSoundDescriptionPropertyID_MagicCookie = 'kuki',
    kQTSoundDescriptionPropertyID_AudioStreamBasicDescription = 'asbd',
    kQTSoundDescriptionPropertyID_UserReadableText = 'text'
};



/*Media Identifiers

Identify media types in QuickTime.

enum {
   VideoMediaType                = 'vide',
   SoundMediaType                = 'soun',
   TextMediaType                 = 'text',
   BaseMediaType                 = 'gnrc',
   MPEGMediaType                 = 'MPEG',
   MusicMediaType                = 'musi',
   TimeCodeMediaType             = 'tmcd',
   SpriteMediaType               = 'sprt',
   FlashMediaType                = 'flsh',
   MovieMediaType                = 'moov',
   TweenMediaType                = 'twen',
   ThreeDeeMediaType             = 'qd3d',
   SkinMediaType                 = 'skin',
   HandleDataHandlerSubType      = 'hndl',
   PointerDataHandlerSubType     = 'ptr ',
   NullDataHandlerSubType        = 'null',
   ResourceDataHandlerSubType    = 'rsrc',
   URLDataHandlerSubType         = 'url ',
   AliasDataHandlerSubType       = 'alis',
   WiredActionHandlerType        = 'wire'
};
Constants
SoundMediaType

Sound channel. 

Available in Mac OS X v10.0 and later.
TextMediaType

Text media. 

Available in Mac OS X v10.0 and later.*/
enum {
   VideoMediaType                = 'vide',
   SoundMediaType                = 'soun',
   TextMediaType                 = 'text',
   BaseMediaType                 = 'gnrc',
   MPEGMediaType                 = 'MPEG',
   MusicMediaType                = 'musi',
   TimeCodeMediaType             = 'tmcd',
   SpriteMediaType               = 'sprt',
   FlashMediaType                = 'flsh',
   MovieMediaType                = 'moov',
   TweenMediaType                = 'twen',
   ThreeDeeMediaType             = 'qd3d',
   SkinMediaType                 = 'skin',
   HandleDataHandlerSubType      = 'hndl',
   PointerDataHandlerSubType     = 'ptr ',
   NullDataHandlerSubType        = 'null',
   ResourceDataHandlerSubType    = 'rsrc',
   URLDataHandlerSubType         = 'url ',
   AliasDataHandlerSubType       = 'alis',
   WiredActionHandlerType        = 'wire'
};

/*New Movie Properties

Constants that represent the properties of new movies.

enum {
   newMovieActive                = 1 << 0,
   newMovieDontResolveDataRefs   = 1 << 1,
   newMovieDontAskUnresolvedDataRefs = 1 << 2,
   newMovieDontAutoAlternates    = 1 << 3,
   newMovieDontUpdateForeBackPointers = 1 << 4,
   newMovieDontAutoUpdateClock   = 1 << 5,
   newMovieAsyncOK               = 1 << 8,
   newMovieIdleImportOK          = 1 << 10,
   newMovieDontInteractWithUser  = 1 << 11
};*/
enum {
   newMovieActive                = 1 << 0,
   newMovieDontResolveDataRefs   = 1 << 1,
   newMovieDontAskUnresolvedDataRefs = 1 << 2,
   newMovieDontAutoAlternates    = 1 << 3,
   newMovieDontUpdateForeBackPointers = 1 << 4,
   newMovieDontAutoUpdateClock   = 1 << 5,
   newMovieAsyncOK               = 1 << 8,
   newMovieIdleImportOK          = 1 << 10,
   newMovieDontInteractWithUser  = 1 << 11
};

/*SampleDescriptionPtr

Abst_SampleDescriptionPtr

typedef SampleDescription * SampleDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SampleDescription * SampleDescriptionPtr;

/*SoundDescriptionPtr

Abst_SoundDescriptionPtr

typedef SoundDescription * SoundDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SoundDescription * SoundDescriptionPtr;


/*SampleDescriptionHandle

Abst_SampleDescriptionHandle

typedef SampleDescriptionPtr * SampleDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SampleDescriptionPtr * SampleDescriptionHandle;


/*SoundDescriptionHandle

Abst_SoundDescriptionHandle

typedef SoundDescriptionPtr * SoundDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SoundDescriptionPtr * SoundDescriptionHandle;

/*TrackRecord

Contains a track.

struct TrackRecord {
   long    data[1];
};
Fields
data
Discussion

An array of track data.
Programming Info
C interface file: Movies.h*/
struct TrackRecord {
   long    data[1];
};
typedef struct TrackRecord  TrackRecord  ;
/*Track

Abst_Track

typedef TrackRecord * Track;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TrackRecord * Track;

/*MediaRecord

Undocumented

struct MediaRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Programming Info
C interface file: Movies.h*/
struct MediaRecord {
   long    data[1];
};
typedef struct MediaRecord  MediaRecord;
/*Media

Abst_Media

typedef MediaRecord * Media;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MediaRecord * Media;

/*MovieRecord

Undocumented

struct MovieRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Programming Info
C interface file: Movies.h*/
struct MovieRecord {
   long    data[1];
};
typedef  struct MovieRecord MovieRecord;
/*Abst_Movie

typedef MovieRecord * Movie;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MovieRecord * Movie; 


/*DataHandler

Abst_DataHandler

typedef ComponentInstance DataHandler;
Availability
Available in Mac OS X v10.0 and later.
Movies.h*/
typedef ComponentInstance DataHandler;


/*QTAtomContainer

Abst_QTAtomContainer

typedef Handle QTAtomContainer;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle QTAtomContainer;

/*ivate:
    /*
        typedef OSErr (*MovieDrawingCompleteProcPtr) (Movie theMovie, long refCon);
     *
    static pascal OSErr MyClassMovieDrawingCompleteProc(Movie theMovie, long refCon);
    static MovieDrawingCompleteUPP sMovieDrawingCompleteUPP;
           Movie                   mMovie;*/
typedef OSErr (*MovieDrawingCompleteProcPtr) (Movie theMovie, long refCon);

/*MovieDrawingCompleteUPP

Abst_MovieDrawingCompleteUPP

typedef STACK_UPP_TYPE(MovieDrawingCompleteProcPtr) MovieDrawingCompleteUPP;*/
typedef STACK_UPP_TYPE(MovieDrawingCompleteProcPtr) MovieDrawingCompleteUPP;

/*Data References

The Movie Toolbox fully supports a media that refers to data in more than one file. By allowing a single media to refer to more than one file, the toolbox allows better playback performance and easier editing, primarily by reducing the number of tracks in a movie. Use the SetMediaDefaultDataRefIndex function to control which of a media’s files you access when you add new sample data.

To fully specify a data reference, it is necessary to provide the data reference itself, along with its type; the data reference handle does not contain the type of the data reference. The DataReferenceRecord data structure contains both of these pieces of information, making it possible to pass them to functions as a single parameter. The FlattenMovieData function uses the information in the data reference structure to flatten a movie to a data reference instead of to a file.
struct DataReferenceRecord {
    OSType  dataRefType;
    Handle  dataRef;
};
typedef struct DataReferenceRecord DataReferenceRecord;
typedef DataReferenceRecord *DataReferencePtr;

Field	
Definition

dataRefType	
Specifies the type of data reference. For an alias data reference, you set the parameter to rAliasType, indicating that the reference is an alias. For a handle data reference, set the parameter to HandleDataHandlerSubTypeMovie Data Types.

dataRef	
Specifies the actual data reference. This parameter contains a handle to the information that identifies the file to be used. The type of information stored in the handle depends on the value of the dataRefType parameter. For example, if your application is loading the movie from a file, this parameter would contain an alias to the movie file.*/
struct DataReferenceRecord {
    OSType  dataRefType;
    Handle  dataRef;
};
typedef struct DataReferenceRecord DataReferenceRecord;
typedef DataReferenceRecord *DataReferencePtr;

/*QTNextTaskNeededSoonerCallbackProc

Called when QuickTime decides that the next task is needed sooner than previously reported by QTGetTimeUntilNextTask.

typedef void (*QTNextTaskNeededSoonerCallbackProcPtr) (TimeValue duration, unsigned long flags, void *refcon);

If you name your function MyQTNextTaskNeededSoonerCallbackProc, you would declare it this way:

void MyQTNextTaskNeededSoonerCallbackProc (
   TimeValue        duration,
   unsigned long    flags,
   void             *refcon );
Parameters
duration

The new duration to the next task, expressed in the time scale set by a previous call to QTInstallNextTaskNeededSoonerCallback.
flags

Undocumented
refcon

A pointer to a reference constant. You can use this parameter to point to a data structure containing any information your callback may need.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Discussion

You can use this callback to reschedule the Carbon event loop timer if the next QuickTime task is needed sooner than projected by QTGetTimeUntilNextTask. This callback may be called at interrupt time or from another thread on Mac OS X.
See Also

This callback is installed by QTInstallNextTaskNeededSoonerCallback. See also NewQTNextTaskNeededSoonerCallbackUPP.*/
typedef void (*QTNextTaskNeededSoonerCallbackProcPtr) (TimeValue duration, unsigned long flags, void *refcon);

/*QTNextTaskNeededSoonerCallbackUPP

Abst_QTNextTaskNeededSoonerCallbackUPP

typedef STACK_UPP_TYPE(QTNextTaskNeededSoonerCallbackProcPtr) QTNextTaskNeededSoonerCallbackUPP;*/
typedef STACK_UPP_TYPE(QTNextTaskNeededSoonerCallbackProcPtr) QTNextTaskNeededSoonerCallbackUPP;


/*MCActionFilterWithRefConProc

Responds to movie controller actions with a reference constant.

typedef Boolean (*MCActionFilterWithRefConProcPtr) (MovieController mc, short action, void *params, long refCon);

If you name your function MyMCActionFilterWithRefConProc, you would declare it this way:

Boolean MyMCActionFilterWithRefConProc (
   MovieController    mc,
   short              action,
   void               *params,
   long               refCon );
Parameters
mc

Specifies the movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

A movie controller action. For a list of actions, see Chapter 2 of Inside Macintosh: QuickTime Components.
params

A pointer to a structure, such as QTStatusStringRecord, that passes information to the callback. See Movies.h.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

Undocumented
Declared In
Movies.h, HIMovieView.h*/
typedef Boolean (*MCActionFilterWithRefConProcPtr) (MovieController mc, short action, void *params, long refCon);

/*MCActionFilterWithRefConUPP

Represents a type used by the Movie Controller API.

typedef STACK_UPP_TYPE(MCActionFilterWithRefConProcPtr) MCActionFilterWithRefConUPP;
Declared In
Movies.h, HIMovieView.h*/

typedef STACK_UPP_TYPE(MCActionFilterWithRefConProcPtr) MCActionFilterWithRefConUPP;

/*CallBackRecord

Stores data for a QTCallBackProc.

struct CallBackRecord {
   long    data[1];
};
Fields
data
Discussion

Callback data.
Programming Info
C interface file: Movies.h*/
struct CallBackRecord {
   long    data[1];
};
typedef struct CallBackRecord CallBackRecord;

/*QTCallBack

Abst_QTCallBack

typedef CallBackRecord * QTCallBack;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CallBackRecord * QTCallBack;

/*QTCallBackProc

A generic callback function, installed by CallMeWhen.

typedef void (*QTCallBackProcPtr) (QTCallBack cb, long refCon);

If you name your function MyQTCallBackProc, you would declare it this way:

void MyQTCallBackProc (
   QTCallBack    cb,
   long          refCon );
Parameters
cb

A pointer to a CallBackRecord structure containing the callback's data.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
See Also

See the CallMeWhen and NewQTCallBackUPP functions.*/
typedef void (*QTCallBackProcPtr) (QTCallBack cb, long refCon);

/*QTCallBackUPP

Abst_QTCallBackUPP

typedef STACK_UPP_TYPE(QTCallBackProcPtr) QTCallBackUPP;*/
typedef STACK_UPP_TYPE(QTCallBackProcPtr) QTCallBackUPP;

/*QTAudioFrequencyLevels

Stores the frequency meter level settings for the audio channels in a movie mix.

struct QTAudioFrequencyLevels {
   UInt32     numChannels;
   UInt32     numFrequencyBands;
   Float32    level[1];
};
Fields
numChannels
Discussion

The number of audio channels.
numFrequencyBands
Discussion

The number of frequency bands for each channel.
level
Discussion

A 32-bit floating-point value for each frequency band. The frequency bands for each channel are stored contiguously, with all the band levels for the first channel first, all the band levels for the second channel next, etc. The total number of 32-bit values in this field equals numFrequencyBands times numChannels.
Related Functions
Associated function: GetMovieAudioFrequencyLevels 
Declared In
Movies.h*/

typedef struct QTAudioFrequencyLevels {
   UInt32     numChannels;
   UInt32     numFrequencyBands;
   Float32    level[1];
} QTAudioFrequencyLevels;

/*MediaHandler

Abst_MediaHandler

typedef ComponentInstance MediaHandler;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentInstance MediaHandler;

/*TextDescriptionPtr

Represents a type used by the Movie Manager API.

typedef TextDescription * TextDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef TextDescription * TextDescriptionPtr;

/*TextDescriptionHandle

Represents a type used by the Movie Manager API.

typedef TextDescriptionPtr * TextDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef TextDescriptionPtr * TextDescriptionHandle;



/*QTTweenerRecord

Stores a tween for the QTNewTween function.

struct QTTweenerRecord {
   long    data[1];
};
Fields
data
Discussion

An array of data that constitutes a tween.
Declared In
Movies.h*/

struct QTTweenerRecord {
   long    data[1];
};
typedef struct QTTweenerRecord QTTweenerRecord;

/*QTTweener

Represents a type used by the Movie Toolkit API.

typedef QTTweenerRecord * QTTweener;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef QTTweenerRecord * QTTweener;


/*TweenerDataProc

A callback the tween component calls with the value generated by a tween operation.

typedef ComponentResult (*TweenerDataProcPtr) (TweenRecord *tr, void *tweenData, long tweenDataSize, long dataDescriptionSeed, Handle dataDescription,
ICMCompletionProcRecordPtr asyncCompletionProc, UniversalProcPtr transferProc, void *refCon);

If you name your function MyTweenerDataProc, you would declare it this way:

ComponentResult MyTweenerDataProc (
   TweenRecord                   *tr,
   void                          *tweenData,
   long                          tweenDataSize,
   long                          dataDescriptionSeed,
   Handle                        dataDescription,
   ICMCompletionProcRecordPtr    asyncCompletionProc,
   UniversalProcPtr              transferProc,
   void                          *refCon );
Parameters
tr

A pointer to the tween record for the tween operation.
tweenData

A pointer to the generated tween value.
tweenDataSize

The size, in bytes, of the tween value.
dataDescriptionSeed

The starting value for the calculation. Every time the content of the dataDescription handle changes, this value should be incremented.
dataDescription

Specifies a handle containing a description of the tween value passed. For basic types such as integers, the calling tween component should set this parameter to NIL. For more complex types such as compressed image data, the calling tween component should set this handle to contain a description of the tween value, such as an image description.
asyncCompletionProc

A pointer to a completion procedure for asynchronous operations. The calling tween component should set the value of this parameter to NIL.
transferProc

A pointer to a procedure to transfer the data. The calling tween component should set the value of this parameter to NIL.
refCon

A pointer to a reference constant. The calling tween component should set the value of this parameter to NIL.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
Movies.h*/
typedef struct TweenRecord TweenRecord;

typedef ComponentResult (*TweenerDataProcPtr)(
TweenRecord *tr,
void *tweenData,
long tweenDataSize,
long dataDescriptionSeed,
Handle dataDescription,
ICMCompletionProcRecordPtr asyncCompletionProc,
UniversalProcPtr transferProc,
void *refCon);

/*TweenerDataUPP

Represents a type used by the Movie Toolkit API.

typedef STACK_UPP_TYPE(TweenerDataProcPtr) TweenerDataUPP;
Declared In
Movies.h*/
typedef STACK_UPP_TYPE(TweenerDataProcPtr) TweenerDataUPP;


/*TweenRecord

Passes information to your tween component's TweenDoTween method.

struct TweenRecord {
   long               version;
   QTAtomContainer    container;
   QTAtom             tweenAtom;
   QTAtom             dataAtom;
   Fixed              percent;
   TweenerDataUPP     dataProc;
   void *             private1;
   void *             private2;
};
Fields
version
Discussion

The version number of this structure. This field is initialized to 0.
container
Discussion

The atom container that contains the tween data.
tweenAtom
Discussion

The atom for this tween entry's data in the container.
percent
Discussion

The percentage by which to change the data.
dataProc
Discussion

The procedure the tween component calls to send the tweened value to the receiving track.
private1
Discussion

Reserved.
private2
Discussion

Reserved.
Related Functions
TweenerDataProc
TweenerDoTween 
Declared In
QuickTimeComponents.h*/

struct TweenRecord {
   long               version;
   QTAtomContainer    container;
   QTAtom             tweenAtom;
   QTAtom             dataAtom;
   Fixed              percent;
   TweenerDataUPP     dataProc;
   void *             private1;
   void *             private2;
};

/*MovieRgnCoverProc

Undocumented

typedef OSErr (*MovieRgnCoverProcPtr) (Movie theMovie, RgnHandle changedRgn, long refcon);

If you name your function MyMovieRgnCoverProc, you would declare it this way:

OSErr MyMovieRgnCoverProc (
   Movie        theMovie,
   RgnHandle    changedRgn,
   long         refcon );
Parameters
theMovie

Specifies the movie for this operation.
changedRgn

Undocumented
refcon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
Movies.h*/
typedef OSErr (*MovieRgnCoverProcPtr) (Movie theMovie, RgnHandle changedRgn, long refcon);

/*MovieRgnCoverUPP

Represents a type used by the Movie Toolkit API.

typedef STACK_UPP_TYPE(MovieRgnCoverProcPtr) MovieRgnCoverUPP;
Declared In
Movies.h*/
typedef STACK_UPP_TYPE(MovieRgnCoverProcPtr) MovieRgnCoverUPP;

/*SpriteRecord

Contains a sprite.

struct SpriteRecord {
   long    data[1];
};
Fields
data
Discussion

An array of sprite data.
Declared In
Movies.h*/

struct SpriteRecord {
   long    data[1];
};
typedef struct SpriteRecord SpriteRecord;

/*Sprite

Represents a type used by the Movie Toolkit API.

typedef SpriteRecord * Sprite;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef SpriteRecord * Sprite;

/*SpriteWorldRecord

Contains a sprite world.

struct SpriteWorldRecord {
   long    data[1];
};
Fields
data
Discussion

An array of sprite world data.
Declared In
Movies.h*/
struct SpriteWorldRecord {
   long    data[1];
};
typedef struct SpriteWorldRecord SpriteWorldRecord;

/*SpriteWorld

Represents a type used by the Movie Toolkit API.

typedef SpriteWorldRecord * SpriteWorld;
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
typedef SpriteWorldRecord * SpriteWorld;

/*MoviePrePrerollCompleteProc

Undocumented

typedef void (*MoviePrePrerollCompleteProcPtr) (Movie theMovie, OSErr prerollErr, void *refcon);

If you name your function MyMoviePrePrerollCompleteProc, you would declare it this way:

void MyMoviePrePrerollCompleteProc (
   Movie    theMovie,
   OSErr    prerollErr,
   void     *refcon );
Parameters
theMovie

Specifies the movie for this operation.
prerollErr

Undocumented
refcon

Pointer to a reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
See Also

See the PrePrerollMovie and NewMoviePrePrerollCompleteUPP functions.*/

typedef void (*MoviePrePrerollCompleteProcPtr) (Movie theMovie, OSErr prerollErr, void *refcon);


/*MoviePrePrerollCompleteUPP

Abst_MoviePrePrerollCompleteUPP

typedef STACK_UPP_TYPE(MoviePrePrerollCompleteProcPtr) MoviePrePrerollCompleteUPP;*/
typedef STACK_UPP_TYPE(MoviePrePrerollCompleteProcPtr) MoviePrePrerollCompleteUPP;

/*TrackTransferProc

Called when a track is forced to draw into a particular graphics world, which may be different from that of the movie.

typedef OSErr (*TrackTransferProcPtr) (Track t, long refCon);

If you name your function MyTrackTransferProc, you would declare it this way:

OSErr MyTrackTransferProc (
   Track    t,
   long     refCon );
Parameters
t

A track designator.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
See Also

See the SetTrackGWorld and NewTrackTransferUPP functions.*/
typedef OSErr (*TrackTransferProcPtr) (Track t, long refCon);

/*TrackTransferUPP

Abst_TrackTransferUPP

typedef STACK_UPP_TYPE(TrackTransferProcPtr) TrackTransferUPP;*/
typedef STACK_UPP_TYPE(TrackTransferProcPtr) TrackTransferUPP;

/*QTEventRecord

Records a user event for QuickTime.

struct QTEventRecord {
   long      version;
   OSType    eventType;
   Point     where;
   long      flags;
};
Fields
version
Discussion

Undocumented
eventType
Discussion

Undocumented
where
Discussion

The location of the cursor at the time the event was posted.
flags
Discussion

Undocumented
Discussion

This structure is used by the kActionSendQTEventToSprite action.
Related Functions
ActionsProc
CallComponentExecuteWiredAction
MediaGetActionsForQTEvent
SpriteMediaGetSpriteActionsForQTEvent 
Programming Info
C interface file: Movies.h*/
struct QTEventRecord {
   long      version;
   OSType    eventType;
   Point     where;
   long      flags;
};
typedef struct QTEventRecord QTEventRecord;

/*QTEventRecordPtr

Abst_QTEventRecordPtr

typedef QTEventRecord * QTEventRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef QTEventRecord * QTEventRecordPtr;

/*MoviePreviewCallOutProc

Controls the playing of a movie's preview.

typedef Boolean (*MoviePreviewCallOutProcPtr) (long refcon);

If you name your function MyMoviePreviewCallOutProc, you would declare it this way:

Boolean MyMoviePreviewCallOutProc (
   long    refcon );
Parameters
refcon

A reference constant you specified when you called PlayMoviePreview.
Return Value

If your function sets this value to FALSE, the Movie Toolbox stops the preview and returns to your application.
Discussion

If you call GetMovieActiveSegment from within your callback, the Movie Toolbox can change the active movie segment to be the preview segment of the movie. The Movie Toolbox will restore the active segment when the preview is done playing.
See Also

See PlayMoviePreview.*/
typedef Boolean (*MoviePreviewCallOutProcPtr) (long refcon);

/*MoviePreviewCallOutUPP

Abst_MoviePreviewCallOutUPP

typedef STACK_UPP_TYPE(MoviePreviewCallOutProcPtr) MoviePreviewCallOutUPP;*/
typedef STACK_UPP_TYPE(MoviePreviewCallOutProcPtr) MoviePreviewCallOutUPP;

/*TextMediaProc

A callback that can be called whenever a text sample is displayed in a movie.

typedef OSErr (*TextMediaProcPtr) (Handle theText, Movie theMovie, short *displayFlag, long refcon);

If you name your function MyTextMediaProc, you would declare it this way:

OSErr MyTextMediaProc (
   Handle    theText,
   Movie     theMovie,
   short     *displayFlag,
   long      refcon );
Parameters
theText

A handle to the text being displayed.
theMovie

Specifies the movie for this operation.
displayFlag

Undocumented
refcon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
See Also

See the TextMediaSetTextProc and NewTextMediaUPP functions.*/
typedef OSErr (*TextMediaProcPtr) (Handle theText, Movie theMovie, short *displayFlag, long refcon);


/*TextMediaUPP

Abst_TextMediaUPP

typedef STACK_UPP_TYPE(TextMediaProcPtr) TextMediaUPP;*/
typedef STACK_UPP_TYPE(TextMediaProcPtr) TextMediaUPP;

#include <APPLE/QuickTime/Movies_E.h>

/*MovieProgressUPP

Abst_MovieProgressUPP

typedef STACK_UPP_TYPE(MovieProgressProcPtr) MovieProgressUPP;*/
typedef STACK_UPP_TYPE(MovieProgressProcPtr) MovieProgressUPP;

//Functions

/*MonvieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags );

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void );

/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );

/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );

/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia );

/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );

/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);

/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );

/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);

/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );

/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia );

/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia );

/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia );

/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh );

/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );

/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );

/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );

/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );

/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );

/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );

/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc );

/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie );

/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );

/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void );

/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );

/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );

/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext);

/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );

/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );

/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );

/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate 

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie );

/*PutUserDataIntoHandle

Returns a handle to a user data structure.

OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );
Parameters
theUserData

The user data structure.
h

A handle to the UserDataRecord structure pointed to by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );

/*NewUserDataFromHandle

Creates a new user data structure from a handle.

OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );
Parameters
h

A handle to the data structure specified in theUserData.
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );

/*DisposeUserData

Disposes of a user data structure created by NewUserData.

OSErr DisposeUserData (
   UserData    theUserData );
Parameters
theUserData

The user data structure that is to be disposed of. It is acceptable but unnecessary to pass NIL in this parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DisposeUserData (
   UserData    theUserData );

/*QTSoundDescriptionGetProperty

Gets a particular property of a sound description.

OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);
Parameters
inDesc

The sound description being interrogated.
inPropClass

The class of the property being requested. 
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

A pointer to the property value buffer.
outPropValueSizeUsed

The actual size of the returned property value (can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);

/*MCDoAction

Invokes a movie controller component and makes it perform a specified action.

ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

The action to be taken. See Movie Controller Actions.
params

A pointer to the parameter data appropriate to the action. See Movie Controller Actions for information about the parameters required for each supported action.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );

/*ExitMoviesOnThread

Indicates to QuickTime that the client will no longer be using QuickTime on the current thread.

OSErr ExitMoviesOnThread (void);
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a previous call to EnterMoviesOnThread was not made.
Discussion

This function should be called before exiting from a spawned thread that uses QuickTime. It undoes the setup performed by EnterMoviesOnThread. Each call to EnterMoviesOnThread should be matched with a call to this function. This function should not be called on a thread without a previous call to EnterMoviesOnThread.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExitMoviesOnThread (void);

/*EnterMoviesOnThread

Indicates that the client will be using QuickTime on the current thread.

OSErr EnterMoviesOnThread (UInt32 inFlags);
Parameters
inFlags

Flag (see below) indicating how the executing thread will use QuickTime. Setting the thread mode is a convenience provided by this function. Pass 0 for the default options. See these constants: 
kQTEnterMoviesFlagDontSetComponentsThreadMode
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. This function returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a second call on the thread was made that used incompatible flags (for example, the first call required a shared state but a subsequent call required a private state).
Discussion

This function is analogous to EnterMovies. It initializes QuickTime and prepares QuickTime for calls from its thread. Unlike EnterMovies, this function allows the client to indicate if its access to QuickTime requires sharing of QuickTime state with the main thread. The default is to maintain a private state. 
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr EnterMoviesOnThread (UInt32 inFlags);

/*QTNewAlias

Creates a Mac OS alias to a file.

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );
Parameters
fss

A pointer to an FSSpec structure that specifies a file.
alias

On return, a pointer to a handle to a new AliasRecord structure that defines an alias to the file. If the function was unable to create an alias, the handle is set to NIL. This function does not create relative aliases. For further information about Mac OS file aliases, see Chapter 4 of Inside Macintosh: Files.
minimal

If you pass TRUE, the function writes in the AliasRecord structure only the target name, parent directory ID, volume name and creation date, and volume mounting information. If you pass FALSE, it fills out the structure fully.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );

/*QTLockContainer

Locks an atom container in memory.

OSErr QTLockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be locked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to lock an atom container before calling QTGetAtomDataPtr to directly access a leaf atom's data. When you have finished accessing a leaf atom's data, you should call QTUnlockContainer. You may make nested pairs of calls to QTLockContainer and QTUnlockContainer; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTLockContainer (
   QTAtomContainer    container );

/*QTFindChildByIndex

Retrieves an atom by index from the child list of the specified parent atom.

QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
index

The index of the atom to be retrieved.
id

A pointer to an uninitialized QTAtomID data structure. On return, if the atom specified by index was found, the QTAtomID data structure contains the atom's ID. If you don't want this function to return the atom's ID, set the value of the id parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and index within that type from a parent atom's child list. The following code illustrates one way to use it:// QTFindChildByIndex coding example
if ((propertyAtom =QTFindChildByIndex (sprite, kParentAtomIsContainer,
    kSpritePropertyImageIndex, 1, NIL)) ==0)
    FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
        kSpritePropertyImageIndex, 1, 1, sizeof(short),&imageIndex,
        NIL));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );

/*QTGetAtomDataPtr

Retrieves a pointer to the atom data for a specified leaf atom.

OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be retrieved.
dataSize

On return, contains a pointer to the length, in bytes, of the leaf atom's data.
atomData

On return, contains a pointer to the leaf atom's data.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function in retrieve a pointer to a leaf atom's data so that you can access the data directly.
Special Considerations

To ensure that the pointer returned in the atomData parameter will remain valid if memory is moved, you should call QTLockContainer before you call this function. If you call QTLockContainer, you should call QTUnlockContainer when you have finished using the atomData pointer. If you pass a locked atom container to a function that resizes atom containers, the function returns an error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );

/*QTUnlockContainer

Unlocks an atom container in memory.

OSErr QTUnlockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be unlocked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to unlock an atom container when you have finished accessing a leaf atom's data. You may make nested pairs of calls to QTLockContainer and this function; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTUnlockContainer (
   QTAtomContainer    container );

/*QTDisposeAtomContainer

Disposes of an atom container.

OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );
Parameters
atomData

The atom container to be disposed of.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to dispose of an atom container data structure that was created by QTNewAtomContainer or QTCopyAtom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );

/*NewMovieFromProperties

Creates a new movie using movie properties.

OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );
Parameters
inputPropertyCount

The number of properties in the array passed in inputProperties.
inputProperties

A pointer to a property array describing how to instantiate the movie. See QTNewMoviePropertyElement.
outputPropertyCount

The number of properties in the array passed in outputProperties.
outputProperties

A pointer to a property array to receive output parameters. See QTNewMoviePropertyElement. You may pass NULL if you don't want this information. The caller is responsible for calling the appropriate routines to dispose of any property values returned here. Since callers specify the property classes and IDs, they know who to call to dispose of the property values.
theMovie

A pointer to a variable that receives the new movie.
Return Value

An error code. Returns memFullErr if the function could not allocate memory, paramErr if inputProperties or theMovie is NULL, or noErr if there is no error.
Discussion

This function can be used in all the cases where an existing NewMovieFrom... call is used. When calling this function, you supply a set of input properties that describe the information required to instantiate the movie (its data reference, audio context, visual context, and so on). You can also supply a set of output properties that you may be interested in; for example, information about whether the data reference was changed. See New Movie Property Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );

/*GoToBeginningOfMovie

Repositions a movie to play from its start.

void GoToBeginningOfMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Discussion

If the movie is in preview mode, the function goes to the start of the preview segment of the movie. In all other cases, this function goes to the start of the movie, where the movie time value is 0. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GoToBeginningOfMovie (
   Movie    theMovie );

/*GetMovieTimeBase

Returns a movie's time base.

TimeBase GetMovieTimeBase (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's TimeBaseRecord structure.
Special Considerations

The Movie Toolbox disposes of a movie's time base when you dispose of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase GetMovieTimeBase (
   Movie    theMovie );

/*StopMovie

Stops the playback of a movie.

void StopMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void StopMovie (
   Movie    theMovie );

/*GetTrackMedia

Determines the media that contains a track's sample data.

Media GetTrackMedia (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The media identifier for the media that contains the track's sample data. If the function could not locate the media, it sets this returned value to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Media GetTrackMedia (
   Track    theTrack );

/*SetTimeBaseFlags

Sets the contents of the control flags of a time base.

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
timeBaseFlags

The control flags for this time base (see below). You may set only one flag to 1. Be sure to set unused flags to 0. See these constants: 
loopTimeBase
palindromeLoopTimeBase
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );

/*SetMoviePlayHints

Provides information to the Movie Toolbox that can influence movie playback.

void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

The optimizations that can be used with this movie. Each bit in the flags parameter corresponds to a specific optimization (see below). Be sure to set unused flags to 0. See these constants: 

hintsScrubMode

hintsUseSoundInterp

hintsAllowInterlace

hintsAllowBlacklining

hintsDontPurge

hintsInactive

hintsHighQuality
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the Movie Toolbox to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single optimization without altering the settings of other flags.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function accepts a flag in which you specify optimizations that the Movie Toolbox can use during movie playback. These optimizations apply to all of the media structures used by the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );


/*SetTimeBaseMasterTimeBase

Assigns a master time base to a time base.

void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
master

The master time base to be assigned to this time base. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the slave time scale. This parameter allows you to set an offset between the time base and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or another time base. Don't use this function to assign a master time base to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );

/*SetTrackEnabled

Enables or disables a track.

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
isEnabled

Enables or disables the track. Set this parameter to TRUE to enable the track. Set this parameter to FALSE to disable the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );

/*SetMovieRate

Sets a movie's playback rate.

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
rate

The new movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. This value immediately changes the rate at which the movie is playing. A value of 1 starts the movie playing at normal speed, a value of 2 causes the movie to play at double speed, -2 starts the movie playing backward at double speed, and so on. A value of 0 stops the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Use this function to change the speed at which a movie is playing. You do not normally use this function to start and stop movies; use the higher level functions StartMovie and StopMovie instead. If you start a movie using this function, you should call PrePrerollMovie and PrerollMovie first, to set up any network connections, buffers, and data structures necessary to play the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );

/*QTMetaDataRelease

Decrements the retain count of a metadata object.

void QTMetaDataRelease ( QTMetaDataRef inMetaData );
Discussion

This function releases a metadata object by decrementing its reference count. When the count becomes 0 the memory allocated to the object is freed and the object is destroyed. If you retain a metadata object you are responsible for releasing it when you no longer need it.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTMetaDataRelease ( QTMetaDataRef inMetaData );

/*QTMetaDataGetItemProperty

Returns a property of a metadata item.

OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
inPropValueSize

Size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the item's property value.
outPropValueSizeUsed

On return, the actual size of buffer space used.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the property being asked about, buffersTooSmall if the allocated buffer is too small to hold the property, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );

/*QTMetaDataGetItemPropertyInfo

Returns information about a property of a metadata item.

OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the item property being asked about, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );

/*QTMetaDataGetNextItem

Returns the next metadata item corresponding to a specified key.

OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );
Parameters
inMetaData

The metadata object for this operation.
inMetaDataFormat

The metadata storage format used by the object passed in inMetaData. The format may be UserData storage, iTunes metadata storage, or QuickTime metadata storage. Not all objects will include all forms of storage, and other storage formats may appear in the future. Pass kQTMetaDataStorageFormatWildcard to target all storage formats.
inCurrentItem

The opaque, unique UInt64 identifier of the current metadata item to start the search. Your application obtains this item identifier from such functions as QTMetaDataAddItem.
inKeyFormat

The format of the key.
inKeyPtr

A pointer to the key of the item to be fetched next. You may pass NULL in this parameter if you are not interested in any specific key.
inKeySize

The size of the key in bytes.
outNextItem

The ID of the next metadata item after the item specified by inCurrentItem that has the specified key.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, kQTMetaDataInvalidStorageFormatErr if the metatada storage format is invalid, kQTMetaDataInvalidKeyErr if the key or its format is invalid, kQTMetaDataNoMoreItemErr if the last item has been fetched, or noErr if there is no error. See Metadata Error Codes.
Discussion

If the item designated by inCurrentItem is kQTMetaDataItemUninitialized, the function returns the first item with the specified key in the storage format. If it refers to a valid item in the storage format, the function will return the next item with the key after the item designated by inCurrentItem.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );

/*QTCopyMovieMetaData

Retains a movie's metadata object and returns it.

OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
outMetaData

A pointer to an opaque metadata object wrapper associated with the movie passed in inMovie.
Return Value

Returns invalidMovie if the movie passed in inMovie is invalid, or noErr if there is no error. 
Discussion

This function returns the metadata object associated with a movie. The object has retain/release semantics. It has already been retained before returning, but you should call QTMetaDataRelease when you are done. Because the movie can be disposed of at any time, the QTMetaDataRef may be valid when the movie no longer exists. In this case, the function will fail with a kQTMetaDataInvalidMetaDataErr error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );

/*GetMovieTimeScale

Returns the time scale of a movie.

TimeScale GetMovieTimeScale (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A long integer that contains the movie's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMovieTimeScale (
   Movie    theMovie );

/*GetMovieIndTrackType

Searches for all of a movie's tracks that share a given media type or media characteristic.

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
index

The index value of the track for this operation. This is not that same as the track's index value in the movie. Rather, this parameter is an index into the set of tracks that meet your other selection criteria.
trackType

Contains either a media type or a media characteristic value. The toolbox applies this value to the search, and returns information about tracks that meet this criterion. You indicate whether you have specified a media type or characteristic value by setting the flags parameter appropriately.
flags

Contains flags (see below) that control the search operation. Note that you may not set both movieTrackMediaType and movieTrackCharacteristic to 1. See these constants: 
movieTrackMediaType
movieTrackCharacteristic
movieTrackEnabledOnly
Return Value

A track identifier.
Discussion

The toolbox returns the track identifier that corresponds to the track that meets your selection criteria. If the toolbox cannot find a matching track, in returns a value of NIL. Note that the index parameter does not work the same way that is does in GetMovieIndTrack. With GetMovieIndTrackType, the index parameter specifies an index into the set of tracks that meet your other selection criteria. For example, in order to find the third track that supports the sound characteristic, you would call the function in the following manner:theTrack =GetMovieIndTrackType (theMovie, 3, AudioMediaCharacteristic, movieTrackCharacteristic);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );

/*GetMediaDecodeDuration

Returns the decode duration of a media.

TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's decode duration. A media's decode duration is the sum of the decode durations of its samples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );

/*GetMediaDisplayDuration

Returns the display duration of a media.

TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's display duration. A media's display duration is its display end time minus its display start time. For media without nonzero display offsets, the decode duration and display duration are the same.
Discussion

When inserting media with display offsets into a track, use display time:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );

/*GetMediaSampleCount

Determines the number of samples in a media.

long GetMediaSampleCount (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

The number of samples in the media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMediaSampleCount (
   Media    theMedia );

/*GetMediaTimeScale

Determines a media's time scale.

TimeScale GetMediaTimeScale (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMediaTimeScale (
   Media    theMedia );

/*GetTrackDuration

Returns the duration of a track.

TimeValue GetTrackDuration (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The duration of the specified track, expressed in the time scale of the movie that contains the track.
Discussion

The duration corresponds to the ending time of the track in the movie's time coordinate system (remember that all tracks start at movie time 0).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackDuration (
   Track    theTrack );

/*GetMediaSampleDescription

Retrieves a SampleDescription structure from a media.

void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to retrieve. This index corresponds to the structure itself, not to the samples in the media. Index numbers start with 1.
descH

Specifies a handle that is to receive the SampleDescription structure. The Movie Toolbox correctly resizes this handle for the returned structure. If there is no description for the specified index, the function returns this handle unchanged. Your application must allocate and dispose of this handle.
Discussion

The Movie Toolbox identifies a media's sample descriptions with an index value, ranging from 1 to the number of sample descriptions in the media. Sample description indexes provide a convenient way to access each sample description in a media. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

The format of sample descriptions differs by media type. Sample descriptions for image data are defined by ImageDescription structures. Sample descriptions for sound are defined by SoundDescription structures. Sample descriptions for text are defined by TextDescription structures.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );

/*SampleNumToMediaDecodeTime

Finds the decode time for a specified sample.

void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );

/*MediaDecodeTimeToSampleNum

Finds the sample for a specified decode time.

void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
decodeTime

A 64-bit time value that represents the decode time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a variable that is to receive the sample number. The function returns the sample number that identifies the sample that contains data for the specified decode time, or 0 if it is not found.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDecodeTime is out of the decode time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );

/*GetMediaSample2

Retrieves sample data from a media file.

OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataOut

A pointer to a buffer to receive sample data. The buffer must be large enough to contain at least maxDataSize bytes. If you do not want to receive sample data, pass NULL.
maxDataSize

The maximum number of bytes allocated to hold the sample data.
size

A pointer to memory where the function returns the number of bytes of sample data returned in the memory area specified by dataOut. Set this parameter to NULL if you are not interested in this information.
decodeTime

The starting time of the sample to be retrieved in decode time. You must specify this value in the media's time scale.
sampleDecodeTime

A pointer to a time value in decode time. The function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NULL.
decodeDurationPerSample

A pointer to a time value in decode time. The Movie Toolbox returns the duration of each sample in the media. Set this parameter to NULL if you don't want this information.
displayOffset

A pointer to a time value. The function updates this time value to indicate the display offset of the returned sample. This time value is expressed in the media's time scale. Set this parameter to NULL if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NULL.
sampleFlags

A pointer to a short integer in which the function returns flags that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NULL: mediaSampleNotSync This flag is set to 1 if the sample is not a sync sample and to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, maxSizeToGrowTooSmall if the sample data is larger than maxDataSize, or noErr if there is no error.
Discussion

Whereas GetMediaSample takes a resizable Handle and a maxSizeToGrow parameter, GetMediaSample2 takes a pointer and a maxDataSize parameter. If you want to read a sample into a Handle, you can use the following code:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );

/*GetMediaNextInterestingDecodeTime

Searches for decode times of interest in a media.

void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
interestingTimeFlags

Flags that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, or nextTimeSyncSample flags to 1. Set unused flags to 0: nextTimeMediaSample Set this flag to 1 to search for the next sample. nextTimeMediaEdit Set this flag to 1 to search for the next group of samples. nextTimeSyncSample Set this flag to 1 to search for the next sync sample. nextTimeEdgeOK Set this flag to 1 to accept information about elements that begin or end at the time specified by the decodeTime parameter. When this flag is set the function returns valid information about the beginning and end of a media. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
decodeTime

Specifies the starting point for the search in decode time. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingDecodeTime

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NULL if you are not interested in this information.
interestingDecodeDuration

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the duration of the interesting time in the media's time coordinate system. Set this parameter to NULL if you don't want this information; this lets the function works faster.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );

/*GetTrackMovie

Determines the movie that contains a specified track.

Movie GetTrackMovie (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The identifier of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Movie GetTrackMovie (
   Track    theTrack );

/*GetTrackNextInterestingTime

Searches for times of interest in a track.

void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works more quickly.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. In this case, sync samples don't rely on preceding frames for content. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );


/*TrackTimeToMediaDisplayTime

Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.

TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );
Parameters
value

A 64-bit time value that represents the track's time value; it must be expressed in the time scale of the movie that contains the track.
theTrack

A track identifier, which your application obtains from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A 64-bit time value that represents the corresponding time in media display time, in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );


/*GetTrackEditRate

Returns the rate of the track edit of a specified track at an indicated time.

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );
Parameters
theTrack

The track identifier for which the rate of a track edit (at the time given in the atTime parameter) is to be determined.
atTime

Indicates a time value at which the rate of a track edit (of a track identified in the parameter theTrack) is to be determined.
Return Value

The rate of the track edit of the specified track at the specified time.
Discussion

This function is useful if you are stepping through track edits directly in your application or if you are a client of QuickTime's base media handler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );

/*CopyMediaMutableSampleTable

Obtains information about sample references in a media in the form of a sample table.

OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
startDecodeTime

A 64-bit time value that represents the starting decode time of the sample references to be retrieved. You must specify this value in the media's time scale.
sampleStartDecodeTime

A pointer to a time value. The function updates this time value to indicate the actual decode time of the first returned sample reference. If you are not interested in this information, set this parameter to NULL. The returned time may differ from the time you specified with the startDecodeTime parameter. This will occur if the time you specified falls in the middle of a sample.
maxNumberOfSamples

A 64-bit signed integer that contains the maximum number of sample references to be returned. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate to the media.
maxDecodeDuration

A 64-bit time value that represents the maximum decode duration to be returned. The function does not return samples with greater decode duration than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media.
sampleTableOut

A reference to an opaque sample table object. When you are done with the returned sample table, release it with QTSampleTableRelease.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

To find out how many samples were returned in the sample table, call QTSampleTableGetNumberOfSamples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );

/*QTSampleTableGetNumberOfSamples

Returns the number of samples in a sample table.

SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object.
Return Value

A 64-bit signed integer that contains the number of samples, or 0 if sampleTable is NULL.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );

/*QTSampleTableGetDecodeDuration

Returns the decode duration of a sample.

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the decode duration of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );


/*QTSampleTableGetDataSizePerSample

Returns the data size of a sample.

ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The size of the sample in bytes. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableGetSampleFlags

Returns the media sample flags of a sample.

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A constant that describes characteristics of the sample (see below). Returns 0 if sampleTable is NULL or if the sample number is out of range.
Discussion

This function can return one or more of the following constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableCopySampleDescription

Retrieves a sample description from a sample table.

OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleDescriptionID

The sample description ID.
mediaSampleDescriptionIndexOut

A pointer to a variable to receive a media sample description index. If the sample description came from a media, this is the index that could be passed to GetMediaSampleDescription to retrieve the same sample description handle. The index will be 0 if the sample description did not come directly from a media. Pass NULL if you do not want to receive this information.
sampleDescriptionHOut

A pointer to a variable to receive a newly allocated sample description handle. Pass NULL if you do not want one. The caller is responsible for disposing the returned sample description handle using DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );

/*SampleNumToMediaDisplayTime

Finds the display time for a specified sample.

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );

/*QTSampleTableGetProperty

Returns the value of a specific sample table property.

OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
sampleTable

A reference to an opaque sample table object.
inPropClass

Pass the following constant to define the property class: kQTPropertyClass_SampleTable = 'qtst' Property of a sample table. See these constants: 
kQTPropertyClass_SampleTable
inPropID

Pass one of these constants to define the property ID: kQTSampleTablePropertyID_TotalDecodeDuration = 'tded' The total decode duration of all samples in the sample table. Read-only. kQTSampleTablePropertyID_MinDisplayOffset = '<ddd' The least display offset in the table. Negative offsets are less than positive offsets. Read-only. kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd' The greatest display offset in the table. Positive offsets are greater than negative offsets. Read-only. kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis' The least display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' The greatest display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. See these constants: 
kQTSampleTablePropertyID_TotalDecodeDuration
kQTSampleTablePropertyID_MinDisplayOffset
kQTSampleTablePropertyID_MaxDisplayOffset
kQTSampleTablePropertyID_MinRelativeDisplayTime
kQTSampleTablePropertyID_MaxRelativeDisplayTime
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

On return, the actual size of the property value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );

/*QTSampleTableRelease

Decrements the retain count of a sample table.

void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object. If you pass NULL in this parameter, nothing happens.
Discussion

If the retain count decreases to zero, the sample table is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );

/*MediaDisplayTimeToSampleNum

Finds the sample number for a specified display time.

void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
displayTime

A 64-bit time value that represents the display time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The function returns the sample number that identifies the sample for the specified display time, or 0 if it is not found.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDisplayTime is out of the display time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );

/*GetMediaAdvanceDecodeTime

Returns the advance decode time of a media.

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's advance decode time. A media's advance decode time is the absolute value of the greatest-magnitude negative display offset of its samples, or 0 if there are no samples with negative display offsets. This is the amount that the decode time axis must be adjusted ahead of the display time axis to ensure that no sample's adjusted decode time is later than its display time. For media without nonzero display offsets, the advance decode time is 0.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );

/*GetTrackDimensions

Determines a track's source rectangle.

void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A pointer to a fixed-point number. The Movie Toolbox returns the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A pointer to a fixed-point number. The Movie Toolbox returns the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );

/*QTSampleTableGetDisplayOffset

Returns the offset from decode time to display time of a sample.

TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the offset from decode time to display time of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTSampleTableGetSampleDescriptionID

Returns the sample description ID of a sample.

QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The sample's sample description ID. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );

/*QTNewDataReferenceFromCFURL

Creates a URL data reference from a CFURL.

OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );
Parameters
url

A reference to a Core Foundation struct that represents the URL to which you want a URL data reference. These structs contain two parts: the string and a base URL, which may be empty. With a relative URL, the string alone does not fully specify the address; with an absolute URL it does.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: Movies.h*/
OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );

/*PutMovieIntoHandle

Creates a new movie resource.

OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
publicMovie

The handle that is to receive the new movie resource. The function resizes the handle if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this handle to store a QuickTime movie in a specialized storage format.
Special Considerations

Note that you cannot use this new movie with other Movie Toolbox functions, except for NewMovieFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );


/*NewMovieFromHandle

Creates a movie in memory from a movie resource or a handle you obtained from PutMovieIntoHandle.

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
h

A handle to the movie resource from which the movie is to be loaded.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromHandle. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The toolbox sets the value to TRUE if any references were changed. Set the dataRefWasChanged parameter to NIL if you don't want to receive this information.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromHandle. To change the graphics world for the new movie, your application should use SetMovieGWorld.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );

/*DetachMovieFromCurrentThread

Detaches a movie from the current thread.

OSErr DetachMovieFromCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr DetachMovieFromCurrentThread (Movie m);


/*AttachMovieToCurrentThread

Attaches a movie to the current thread.

OSErr AttachMovieToCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AttachMovieToCurrentThread (Movie m);

/*QTGetEffectSpeed

Returns the speed of the effect, expressed in frames per second.

OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );
Parameters
parameters

Contains parameter values for the effect.
pFPS

The speed of the effect is returned in this parameter, expressed in frames per second. Effects can also return the pre-defined constant effectIsRealtime (see below) as their speed. See these constants: 
effectIsRealtime
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The value returned should not be treated as an absolute measurement of effect performance. In particular, most effects only return one value, regardless of parameter settings and hardware. This value is an estimate of execution speed on a reference hardware platform. Actual performance will vary depending on hardware, configuration and parameter options.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );


/*QTCountChildrenOfType

Returns the number of atoms of a given type in the child list of the specified parent atom.

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
childType

The atom type for this operation. To retrieve the total number of atoms in the child list, set this parameter to 0. 
Return Value

The number of atoms of a given type in the child list of the specified parent atom.
Discussion

You can call this function to determine the number of atoms of a specified type in a parent atom's child list. If the total number of atoms in the parent atom's child list is 0, the parent atom is a leaf atom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );

/*QTNextChildAnyType

Returns the next atom in the child list of the specified parent atom.

OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
currentChild

The last atom retrieved by this function. To retrieve the first atom in the child list, set the value of currentChild to 0.
nextChild

A pointer to an uninitialized QT atom data structure. On return, the data structure contains the offset of the next atom in the child list after the atom specified by currentChild, or 0 if the atom specified by currentChild was the last atom in the list.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to iterate through all the atoms in a parent atom's child list, regardless of their types and IDs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );

/*QTGetAtomTypeAndID

Retrieves an atom's type and ID.

OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );
Parameters
container

The atom container that contains the atom.
atom

The atom whose type and ID should be retrieved.
atomType

A pointer to an atom type. On return, this parameter points to the type of the specified atom. You can pass NIL for this parameter if you don't need this information.
id

A pointer to an atom ID. On return, this parameter points to the ID of the specified atom. You can pass NIL for this parameter if you don't need this information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );

/*SetMovieActive

Activates or deactivates a movie.

void SetMovieActive (
   Movie      theMovie,
   Boolean    active );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
active

Activates or deactivates the movie. Set this parameter to TRUE to activate the movie; set this parameter to FALSE to deactivate the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieActive (
   Movie      theMovie,
   Boolean    active );


/*IsMovieDone

Determines if a particular movie has completely finished playing.

Boolean IsMovieDone (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

Returns TRUE if the specified movie has finished playing, otherwise returns FALSE.
Discussion

A movie with a positive rate (playing forward) is considered done when its movie time reaches the movie end time. Conversely, a movie with a negative rate (playing backward) is considered done when its movie time reaches the movie start time. If your application has changed the movie's active segment, the status returned by this function is relative to the active segment, rather than to the entire movie. You can use SetMovieActiveSegment to change a movie's active segment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean IsMovieDone (
   Movie    theMovie );


/*GetMovieBox

Returns a movie's boundary rectangle, which is a rectangle that encompasses all of the movie's enabled tracks.

void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle. GetMovieBox returns the coordinates of the movie's boundary rectangle into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The movie box is in the coordinate system of the movie's graphics world and defines the movie's boundaries over the entire duration of the movie. The movie's boundary rectangle defines the size and shape of the movie before the Movie Toolbox applies the display clipping region. The following code sample illustrates the use of GetMovieBox:// GetMovieBox coding example
// See "Discovering QuickTime," page 218
void main (void)
{
    WindowRef       pMacWnd;
    Rect            rectWnd;
    Rect            rectMovie;
    Movie           movie;
    Boolean         bDone =FALSE;
    OSErr           nErr;
    EventRecord     er;
    WindowRef       pWhichWnd;
    short           nPart;
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    nErr =EnterMovies();
    if (nErr !=noErr)
        return;
 
    SetRect(&rectWnd, 100, 100, 200, 200);
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pMovie", FALSE,
                            noGrowDocProc, (WindowRef)-1, TRUE, 0);
    SetPort(pMacWnd);
    movie =GetMovie();
    if (movie ==NIL)
        return;
 
    GetMovieBox(movie, &rectMovie);
    OffsetRect(&rectMovie, -rectMovie.left, -rectMovie.top);
    SetMovieBox(movie, &rectMovie);
 
    SizeWindow(pMacWnd, rectMovie.right, rectMovie.bottom, TRUE);
    ShowWindow(pMacWnd);
    SetMovieGWorld(movie, (CGrafPtr)pMacWnd, NIL);
 
    StartMovie(movie);
 
    . . .
 
    DisposeMovie(movie);
    DisposeWindow(pMacWnd);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect );

/*NewMovieController

Locates a movie controller component and assigns a movie to that controller.

ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags );
Parameters
theMovie

The movie to be associated with the movie controller.
movieRect

A pointer to the Rect structure that is to define the display boundaries of the movie and its controller.
someFlags

Contains flags (see below) that control the operation. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by the movieRect parameter and scales the movie to fit in that rectangle. The control portion of the controller is also placed within that rectangle. You may control how the movie and the control are drawn by setting one or more flags to 1. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcWithBadge
mcNotVisible
mcWithFrame
Return Value

The ID of the new controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags );


/*DisposeMovieDrawingCompleteUPP

Disposes of a MovieDrawingCompleteUPP pointer.

void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP );
Parameters
userUPP

A MovieDrawingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP );

/*DisposeMovieController

Disposes of a movie controller.

void DisposeMovieController (
   ComponentInstance    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from the Component Manager's OpenComponent or OpenDefaultComponent function, or from the NewMovieController function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function is implemented by the Movie Toolbox, not by movie controller components. If you are creating your own movie controller component, you do not have to support this function. The following code snippet illustrates its use:// DisposeMovieController coding example
// See "Discovering QuickTime," page 221
// Resource identifiers
#define IDM_OPEN         101
char            szMovieFile[MAX_PATH];              // Name of movie file
Movie           movie;                              // Movie object
MovieController mc;                                 // Movie controller
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    ...
    ...
    InitializeQTML(0);                          // Initialize QuickTime
    EnterMovies();                              // Initialize Toolbox
    ...
    //  Main message loop
    ...
    ExitMovies();                               // Terminate Toolbox
    TerminateQTML();                            // Terminate QuickTime
}  // end WinMain
//
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    MSG             msg;
    EventRecord     er;
 
    . . .                                       // Fill in contents of MSG structure
 
    WinEventToMacEvent(&msg, &er);                  // Convert message to a QT event
    MCIsPlayerEvent(mc, (const EventRecord *)&er);  // Pass event to movie controller
 
    switch (iMsg) {
        case WM_CREATE:
            CreatePortAssociation(hwnd, NIL, 0L);  // Register window with QT
            break;
        case WM_COMMAND:
            switch (LOWORD(wParam)) {
                case IDM_OPEN:
                    MyCloseMovie();                 // Close previous movie, if any
 
                    if (MyGetFile(szMovieFile))         // Get file name from user
                        MyOpenMovie(hwnd, szMovieFile); // Open the movie
                    break;
                    . . .
                default:
                    return DefWindowProc(hwnd, iMsg, wParam, lParam);
            }  // end switch (LOWORD(wParam))
            break;
        case WM_CLOSE:
            DestroyPortAssociation(GetNativeWindowPort(hwnd));  // Unregister window
            break;
        . . .
        default:
            return DefWindowProc(hwnd, iMsg, wParam, lParam);
 
    }  // end switch (iMsg)
 
    return 0;
}  // end WndProc
//
BOOL MyGetFile (char *lpszMovieFile)
{
    OPENFILENAME         ofn;
 
    // Fill in contents of OPENFILENAME structure
                ...
                ...
 
     if (GetOpenFileName(&ofn))                     // Let user select file
        return TRUE;
    else
        return FALSE;
}  // end MyGetFile
//
void MyOpenMovie (HWND hwnd, char szFileName[255])
{
    short   nFileRefNum =0;
    FSSpec  fss;
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);   // Set graphics port
    NativePathNameToFSSpec(szFileName, &fss, 0);    // Convert pathname and make FSSpec
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);    // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,     // Get movie from file
                    NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                    // Close movie file
 
    mc =NewMovieController(movie, ...);            // Make movie controller
        ...
        ...
 
}  // end MyOpenMovie
//
void MyCloseMovie (void)
{
    if (mc)                                     // Destroy movie controller, if any
        DisposeMovieController(mc);
 
    if (movie)                                  // Destroy movie object, if any
        DisposeMovie(movie);
}  // end MyCloseMovie

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieController (
   ComponentInstance    mc );


/*NewMovieDrawingCompleteUPP

Allocates a Universal Procedure Pointer for the MovieDrawingCompleteProc callback.

MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieDrawingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine );

/*SetMovieDrawingCompleteProc

Assigns a drawing-complete function to a movie.

void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon );
Parameters
theMovie

The movie for this operation.
flags

Contains flags (see below) that control when your drawing complete function is called. See these constants: 
movieDrawingCallWhenChanged
movieDrawingCallAlways
proc

A pointer to your MovieDrawingCompleteProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

The reference constant you supplied when your application called your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls this function based upon guidelines you establish when you assign the function to the movie. 
Special Considerations

Some media handlers may take less efficient playback paths when a drawing-complete function is used, so it should be used only when absolutely necessary.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon );

/*MCIdle

Performs idle processing for a movie controller.

ComponentResult MCIdle (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCIdle (
   MovieController    mc );

/*QTNewDataReferenceFromFSRef

Creates an alias data reference from a file specification.

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );
Parameters
fileRef

A pointer to an opaque file system reference.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You can use File Manager functions to construct a file specification for a file to which you want the new alias data reference to point. Then you can pass the reference to other Movie Toolbox functions that take a data reference. To construct a file specification, the file must already exist. To create an alias data reference for a file that does not exist yet, such as a new file to be created by a Movie Toolbox function, call QTNewDataReferenceFromFSRefCFString.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );

/*CanQuickTimeOpenDataRef

Determines whether referenced data can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags );
Parameters
dataRef

A handle to the referenced data.
dataRefType

The type of data reference pointed to by dataRef; see Data References.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given area of data. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags );


/*QTInstallNextTaskNeededSoonerCallback

Installs a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback.
scale

The time scale that QuickTime will use when reporting the duration until the next time QuickTime needs to be called, via QTGetTimeUntilNextTask.
flags

Unused; set to 0.
refcon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This routine installs a callback procedure that specifies when QuickTime next needs to be tasked. The callback procedure may be called at interrupt time or from another Mac OS X thread, so you must be careful not to cause race conditions. You can install or uninstall multiple callback procedures if necessary; they will be called in sequence. You can also install the same callback multiple times with different refcon values, in which case it will be called once with each refcon value.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon );

/*QTGetTimeUntilNextTask

Reports the duration until the next time QuickTime needs to run a task.

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale );
Parameters
duration

A pointer to the duration until the next time QuickTime needs access to the processor. If the returned duration is 0, QuickTime needs to run a task immediately.
scale

The time scale in which to express the returned duration. For example, pass 60 if you want the duration value expressed in ticks (60ths of a second).
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Periodically, applications have to give processing time to QuickTime by calling a function such as MCIsPlayerEvent. Instead of routinely calling MCIsPlayerEvent 10 to 20 times per second, you can call QTGetTimeUntilNextTask to determine when QuickTime next needs access to the processor. The result is a more efficent use of processor resources. To handle cases when QuickTime may need to run a task earlier than projected by this function, you can install a QTNextTaskNeededSoonerCallbackProc callback.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale );

/*QTUninstallNextTaskNeededSoonerCallback

Removes a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback that you installed by a previous call to QTInstallNextTaskNeededSoonerCallback.
refcon

A pointer to the reference constant that you passed when the callback was installed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You pass this routine both a pointer to a callback procedure and a pointer to its reference constant, so you can uninstall one instance of a callback that you installed more than once with different refcon values.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon );

/*QTGetMovieProperty

Returns the value of a specific movie property.

OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );

/*QTGetMoviePropertyInfo

Returns information about the properties of a movie.

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags );

/*CanQuickTimeOpenFile

Determines whether a file can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags );
Parameters
fileSpec

Points to an FSSpec structure that identifies a file. To ask about a particular file type or file name suffix in general, pass NIL.
fileType

Contains the file type if already known, or 0 if not known. If fileSpec is provided and fileType is 0, QuickTime will determine the file type. If you pass NIL in fileSpec and 0 in fileNameExtension, you must pass a file type here.
fileNameExtension

Contains the file name suffix if already known, or 0 if not known. The file name suffix should be encoded as an uppercase four character code with trailing spaces; for instance, the suffix ".png" should be encoded as 'PNG ', or 0x504E4720. If fileSpec is provided and fileNameExtension is 0, QuickTime will examine fileSpec to determine the file name suffix. If you pass NIL in fileSpec and 0 in fileType, you must pass a file name suffix here.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given file or, in general, files of a given type. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags );

/*QTNewDataReferenceFromURLCFString

Creates a URL data reference from a CFString that represents a URL string.

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
urlString

A CFString that represents a URL string.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );

/*CreateMovieControl

Creates a movie control object to pass to the Mac OS Control Manager.

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl );
Parameters
theWindow

The window in which the control is placed.
localRect

A pointer to a Rect structure that describes in local coordinates the window in which the movie control is placed. If NIL is passed, the movie control is positioned at 0,0 within the window; it will have the natural dimensions of the movie plus the height of the movie controls if they are visible. If 0 height and width is passed, this parameter is interpreted as an anchor point and the top left point of the movie control will be located at this position with height and width as in the NIL case. For all other cases of rectangles, the movie control is centered within the rectangle by default and is sized to fit within it while maintaining the movie's aspect ratio.
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
options

Constants (see below) that determine parts of the movie control's appearance. See these constants: 
kMovieControlOptionHideController
kMovieControlOptionLocateTopLeft
kMovieControlOptionEnableEditing
kMovieControlOptionHandleEditingHI
kMovieControlOptionSetKeysEnabled
kMovieControlOptionManuallyIdled
returnedControl

A handle to a ControlRecord struct. This defines a movie control, suitable for passing to Mac OS Control Manager functions.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes. This routine returns an error if there is a problem with one of the parameters or if an error occurred while creating the underlying movie controller or the custom control itself. If an error is returned, the value of returnedControl is undefined.
Discussion

The Carbon Movie Control is implemented as a custom control, which installs an event handler to handle the Carbon Events sent to controls. When a Carbon Movie Control is created for a movie, a movie controller is also created. The movie control then directs user interface events to the controller. The application can install event handlers on the Carbon Movie Control to handle such things as contextual menu clicks or to intercept events to do special processing. Control Manager calls can be made as well.
Special Considerations

The control can be deleted by calling the Mac OS function DisposeControl. Note that the control is automatically disposed of if the enclosing window is destroyed. Note, too, that the underlying movie controller is disposed of when the control is deleted.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl );

/*GetMovieAudioFrequencyLevels

Returns the current frequency meter levels of a movie mix.

OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
pAveragePowerLevels

A pointer to a QTAudioFrequencyLevels structure (page 325).
Return Value

An error code. Returns noErr if there is no error.
Discussion

In the structure pointed to by pAveragePowerLevels, the numChannels field must be set to the number of channels in the movie mix being metered and the numBands field must be set to the number of bands being metered (as previously configured). Enough memory for the structure must be allocated to hold 32-bit values for all bands in all channels. This function returns the current frequency meter levels in the level field of the structure, with all the band levels for the first channel first, all the band levels for the second channel next and so on.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels );

/*SetMovieAudioFrequencyMeteringNumBands

Configures frequency metering for a particular audio mix in a movie.

OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
ioNumBands

A pointer to memory that stores the number of bands being metered. On calling this function, you specify the number of frequency bands you want to meter. If that number is higher than is possible (determined by factors such as the sample rate of the audio being metered), the function will return the number of bands it is actually going to meter. You can pass NIL or a pointer to 0 to disable metering.
Return Value

An error code. Returns noErr if there is no error.
Discussion

See GetMovieAudioFrequencyMeteringNumBands.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands );

/*GetMovieUserData

Obtains access to a movie's user data list.

UserData GetMovieUserData (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The UserDataRecord structure for the movie. If the function could not locate the movie's user data, it sets this return value to NIL.
Discussion

This function returns a reference to the movie's user data list, which is valid until you dispose of the movie. When you save the movie, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetMovieUserData (
   Movie    theMovie );


/*GetMovieDuration

Returns the duration of a movie.

TimeValue GetMovieDuration (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The duration of the designated movie.
Discussion

This function returns a time value, expressed in the movie's time scale, that is calculated to be the maximum durations of all the tracks in the movie. The following code sample illustrates its use:// GetMovieDuration coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieDuration (
   Movie    theMovie );

/*NewMovie

Creates a new movie in memory.

Movie NewMovie (
   long    flags );
Parameters
flags

Flags (see below) that specify control information for the new movie. Be sure to set unused flags to 0.
Return Value

The identifier for the new movie. If NewMovie fails, the returned identifier is set to NIL. You can use GetMoviesError to obtain the error result, or noErr if there was no error. See Error Codes.
Discussion

You can use NewMovie to create a new empty movie, which contains no tracks. The Movie Toolbox initializes the data structures for the new movie. Your application assigns the data to the movie by calling the functions that are described in NewMovieTrack.

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovie. To change the graphics world for the new movie, your application should use SetMovieGWorld. The default QuickTime movie time scale is 600 units per second; however, this number may change in the future. The default time scale was chosen because it is convenient for working with common video frame rates of 30, 25, 24, 15, 12, 10, and 8.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie NewMovie (
   long    flags );

/*GetUserDataText

Retrieves language-tagged text from an item in a user data list.

OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data. The GetUserDataText function resizes this handle as appropriate. Your application must dispose of the handle when you are done with it.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
itlRegionTag

The language code of the text to be retrieved. See Localization Codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, and the item's type value and language code. The Movie Toolbox retrieves the specified text from the user data item.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );

/*QTFindChildByID

Retrieves an atom by ID from the child list of the specified parent atom.

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
id

The ID of the atom to be retrieved.
index

A pointer to an uninitialized short integer. On return, if the atom specified by the id parameter was found, the integer contains the atom's index. If you don't want this function to return the atom's index, set the value of the index parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and ID from a parent atom's child list. The following code shows how you can use this function to insert a copy of container B's atoms as children of the 'abcd' atom in container A:// QTFindChildByID coding example
QTAtom targetAtom;
targetAtom =QTFindChildByID (containerA, kParentAtomIsContainer, 'abcd',
    1000, NIL);
FailOSErr (QTInsertChildren (containerA, targetAtom, containerB));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index );


/*QTSetAtomData

Changes the data of a leaf atom.

OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData );
Parameters
container

The atom container that contains the atom to be modified.
atom

The atom to be modified.
dataSize

The length, in bytes, of the data pointed to by the atomData parameter.
atomData

A pointer to the new data for the atom.
Return Value

Only leaf atoms contain data; this function returns an error if you pass it to a nonleaf atom. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to replace a leaf atom's data with new data. The atom container specified by the container parameter should not be locked. The following code illustrates using this function to update an atom container that describes a sprite:// QTSetAtomData coding example
OSErr SetSpriteData (QTAtomContainer sprite, Point *location,
    short *visible, short *layer, short *imageIndex)
{
    OSErr err =noErr;
    QTAtom propertyAtom;
 
    // if the sprite's visible property has a new value
    if (visible)
    {
        // retrieve the atom for the visible property
        // -- if none exists, insert one
        if ((propertyAtom =QTFindChildByIndex (sprite,
            kParentAtomIsContainer, kSpritePropertyVisible, 1,
            NIL)) ==0)
            FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
                kSpritePropertyVisible, 1, 1, sizeof(short), visible,
                NIL))
 
        // if an atom does exist, update its data
        else
            FailOSErr (QTSetAtomData (sprite, propertyAtom,
                sizeof(short), visible));
    }

Special Considerations

This function may move memory; if the pointer specified by the atomData parameter is a dereferenced handle, you should lock the handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData );

/*GetMediaHandler

Obtains a reference to a media handler component.

MediaHandler GetMediaHandler (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A media handler component instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MediaHandler GetMediaHandler (
   Media    theMedia );

/*TextMediaAddTextSample

Adds a single block of styled text to an existing media.

ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime );
Parameters
mh

The media handler for the text media obtained by GetMediaHandler.
text

A pointer to a block of text.
size

Indicates the size of the text block, in bytes.
fontNumber

The number for the font in which to display the text.
fontSize

Indicates the size of the font.
textFace

Indicates the typeface or style of the text (that is, bold, italic, and so on).
textColor

A pointer to an RGBColor structure specifying the color of the text. Passing NIL for this parameter in defaults to black.
backColor

A pointer to an RGBColor structure specifying the text background color. Passing NIL for this parameter in defaults to white.
textJustification

Indicates the justification of the text (see below). See these constants: 
textBox

A pointer to a Rect structure that defines the box within which the text is to be displayed. The box is relative to the track bounds.
displayFlags

Contains the text display flags (see below). See these constants: 
dfDontDisplay
dfDontAutoScale
dfClipToTextBox
dfShrinkTextBoxToFit
dfScrollIn
dfScrollOut
dfHorizScroll
dfReverseScroll
dfContinuousScroll
dfFlowHoriz
dfContinuousKaraoke
dfDropShadow
dfAntiAlias
dfKeyedText
dfInverseHilite
dfTextColorHilite
scrollDelay

Indicates the delay in scrolling associated with the setting of the dfScrollIn and dfScrollOut display flags. If the value of the scrollDelay parameter is greater than 0 and the dfScrollIn flag is set, the text pauses when it has scrolled all the way in for the amount of time specified by scrollDelay. If the dfScrollOut flag is set, the pause occurs first before the text scrolls out. If both these flags are set, the pause occurs at the midpoint between scrolling in and scrolling out.
hiliteStart

The beginning of the text to be highlighted.
hiliteEnd

The end of the text to be highlighted. If the hiliteEnd parameter is greater than the hiliteStart parameter, then the text is highlighted from the selection specified by hiliteStart to hiliteEnd. To specify additional highlighting, you can use TextMediaAddHiliteSample.
rgbHiliteColor

Contains a pointer to an RGBColor structure that defines the color for highlighting. If this parameter is not NIL, then the specified color is used when highlighting the text indicated by the hiliteStart and hiliteEnd parameters. Otherwise, the default system highlight color is used.
duration

A time value that specifies how long the text sample should last. This duration is expressed in the media's time base.
sampleTime

Contains a pointer to a time value. The actual media time at which the sample was added is returned here.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Special Considerations

Be sure to turn on the dfDropShadow display flag after you call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime );

/*MCSetVisible

Lets your application control the visibility of a movie controller.

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
visible

Set to TRUE to cause the controller to be visible, or FALSE to make the controller invisible.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible );


/*MCIsControllerAttached

Returns a value that indicates whether a movie controller is attached to its movie.

ComponentResult MCIsControllerAttached (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is attached, the returned value is set to 1. If the controller is not attached, the returned value is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsControllerAttached (
   MovieController    mc );

/*GetTimeBaseTime

Obtains the current time value from a time base.

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
s

The time scale in which to return the current time value. Set this parameter to 0 to retrieve the time in the preferred time scale of the time base.
tr

A pointer to a time structure that is to receive the current time value. This is an optional parameter. If you don't want the time value represented in a time structure, set this parameter to NIL.
Return Value

The time base's current time.
Discussion

This function returns a time value that contains the current time from the specified time base in the specified time scale. The function returns this value even if you specify a time structure with the tr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr );


/*SetTimeBaseMasterClock

Assigns a clock component to a time base.

void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
clockMeister

The clock component to be assigned to this time base. Your application can obtain this component identifier from FindNextComponent.
slaveZero

A pointer to the time, in the clock's time scale, that corresponds to a 0 time value for the slave time base. This parameter allows you to set an offset between the time base and the clock component. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or from another time base. Don't use this function to assign a clock to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero );


/*GetTimeBaseMasterClock

Determines the clock component that is assigned to a time base.

ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
Return Value

A reference to a component instance. If a clock component is not assigned to the time base, the returned reference is NIL. In this case, the time base relies on another time base for its time source. Use GetTimeBaseMasterTimeBase to obtain the time base reference to that master time base.
Discussion

This function returns a reference to a component instance of the clock component that provides a time source to the specified time base. Every time base derives its time from either a clock component or from another time base. If a time base derives its time from a clock component, use this function to obtain the component instance of the clock component.
Special Considerations

The Component Manager allows a single component to serve multiple client applications at the same time. Each client application has a unique connection to the component, identified by a component instance. Don't close this connection; the time base is using it to maintain its time source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb );

/*OpenMovieFile

Opens a specified movie file.

OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission );
Parameters
fileSpec

A pointer to the FSSpec structure for the movie file to be opened.
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. This reference number refers to the file fork that contains the movie resource. If the movie is stored in the data fork of the file, the returned reference number corresponds to the data fork.
permission

The permission level for the file (see below). If your application is only going to play the movie that is stored in the file, you can open the file with read permission. If you plan to add data to the file or change data in the file, you should open the file with write permission. See these constants: 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application must open a movie file before reading movie data from it or writing movie data to it. You can open a movie file more than once; be sure to call CloseMovieFile once for each time you call this function. Note that opening the movie file with write permission does not prevent other applications from reading data from the movie file.

If the specified file has a resource fork, this function opens the resource fork and returns a file reference number to the resource fork. If the movie file does not have a resource fork (that is, it is a single-fork movie file), this function opens the data fork instead. In this case, your application cannot use AddMovieResource with the movie file.

The following is an example of using OpenMovieFile:// OpenMovieFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by OpenMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission );

/*NewMovieFromFile

Creates a new movie in memory from a movie file or from any type of file for which QuickTime provides an import component (AIFF, JPEG, MPEG-4, etc).

OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
resRefNum

The movie file from which the movie is to be loaded. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the resId parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The Movie Toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
resName

A pointer to a character string that is to receive the name of the movie resource that is loaded. If you set the resName parameter to NIL, the Movie Toolbox does not return the resource name.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromFile. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The Movie Toolbox sets the value to TRUE if any references were changed. Use UpdateMovieResource to preserve these changes. Set this parameter to NIL if you don't want to receive this information. See NewMovieTrack for more information about data references.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromFile. To change the graphics world for the new movie, your application should use SetMovieGWorld.

The following is an example of using this function:// NewMovieFromFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Special Considerations

This function works with some files that don't contain movie resources. When it encounters a file that does not contain a movie resource, it tries to find a movie import component that can understand the data and create a movie. It also works for MPEG, uLaw (.AU), and Wave (.WAV) file types. In some cases, the data in a file is already sufficiently well formatted for QuickTime or its components to understand. For example, the AIFF movie data import component can understand AIFF sound files and import the sound data into a QuickTime movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged );

/*CloseMovieFile

Closes an open movie file.

OSErr CloseMovieFile (
   short    resRefNum );
Parameters
resRefNum

The movie file to close. Your application obtains this reference number from OpenMovieFile.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code shows a typical use of CloseMovieFile.// CloseMovieFile coding example
// See "Discovering QuickTime," page 50
void OpenMovie (HWND hwnd, char *szFileName)
{
    short   nFileRefNum =0;
    FSSpec  fss;
    // Convert path to FSSpec
    NativePathNameToFSSpec(szFileName, &fss, 0);
    // Set graphics port
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);   // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,    // Get movie from file
                        NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                   // Close movie file
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CloseMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CloseMovieFile (
   short    resRefNum );

/*CreateMovieFile

Creates a movie file, creates an empty movie which references the file, and opens the movie file with write permission.

OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Controls movie file creation flags (see below). See these constants: 
createMovieFileDontCreateResFile
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. If you set this parameter to NIL, the Movie Toolbox creates the movie file but does not open the file.
newmovie

A pointer to a field that is to receive the identifier of the new movie. CreateMovieFile returns the identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you set this parameter to NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how CreateMovieFile may be used to create and open a QuickTime movie file.// CreateMovieFile coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);   // See "Discovering QuickTime," page 244
    CreateMySoundTrack(movie);   // See "Discovering QuickTime," page 250
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CreateMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie );

/*AddMovieResource

Adds a movie resource to a specified resource file.

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to add to the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file to which the resource is to be added. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by resId is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. AddMovieResource assigns resource ID numbers sequentially, starting at 128. If resId is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value. Set resId to movieInDataForkResID to add the new resource to the movie file's data fork (see below). See these constants: 
movieInDataForkResID
resName

Points to a character string that contains the name of the movie resource. If you set resName to NIL, the toolbox creates an unnamed resource.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function adds the movie to the file, effectively saving any changes you have made to the movie. To use this function with single-fork movie files, pass movieInDataForkResID as the resId parameter. After updating the movie file, AddMovieResource clears the movie changed flag, indicating that the movie has not been changed.// AddMovieResource coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See next section
    CreateMySoundTrack(movie);      // See next section
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by AddMovieToStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName );

/*SetMovieBox

Sets a movie's boundary rectangle.

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle that contains the coordinates of the new boundary rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox changes the rectangle by modifying the translation and scale values of the movie's matrix to accommodate the new boundary rectangle.

The movie box might not have its upper-left corner set at (0,0) in its display window when the movie is first loaded. Consequently, your application may need to adjust the position of the movie box so that it appears in the appropriate location within your application's document window. If you don't reset the movie position, the movie might not be visible when it starts playing. The following sample code demonstrates how to do this://Zeroing the boundary rectangle with SetMovieBox
GetMovieBox (movie, &movieBox);
OffsetRect (&movieBox, -movieBox.left, -movieBox.top);
SetMovieBox (movie, &movieBox);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect );

/*ClearMoviesStickyError

Clears the sticky error value.

void ClearMoviesStickyError ( void );
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The Movie Toolbox saves the same result code in the sticky error value. Your application clears the sticky error value by calling ClearMoviesStickyError. The Movie Toolbox then places the first nonzero result code from any toolbox function used by your application into the sticky error value. The Movie Toolbox does not update the sticky error value until your application clears it again.
Special Considerations

Many Movie Toolbox functions don't return an error as a function result; you must use GetMoviesError to obtain the result code. Even if a function explicitly returns an error as a function result, that result is also available using GetMoviesError. The Movie Toolbox does not place a result code into the sticky error value until the field has been cleared. Your application is responsible for clearing the sticky error value to ensure that it does not contain a stale result code.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ClearMoviesStickyError ( void );

/*GetTrackVolume

Returns a track's current volume setting.

short GetTrackVolume (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's current volume setting. The values returned in the high and low words range from 0x0000 (silence) to 0x0100 (full volume). You can use constants (see below) to test for full volume and no volume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackVolume (
   Track    theTrack );


/*GetMediaDataRef

Returns a copy of a specified data reference.

OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

The index value that corresponds to the data reference. It must be less than or equal to the value that is returned by GetMediaDataRefCount.
dataRef

A pointer to a field that is to receive a handle to the data reference. The media handler returns a handle to information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If the function cannot locate the specified data reference, the handler sets this returned value to NIL. Set the dataRef parameter to NIL if you are not interested in this information.
dataRefType

A pointer to a field that is to receive the type of data reference. If the data reference is an alias, the media handler sets this value to 'alis'. Set the dataRefType parameter to NIL if you are not interested in this information.
dataRefAttributes

A pointer to a field that is to receive the reference's attribute flags (see below). Unused flags are set to 0. See these constants: 
dataRefSelfReference
dataRefWasNotResolved
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to retrieve information about a data reference. For example, you might want to verify the condition of a movie's data references after loading the movie from its movie file. You could use this function to check each data reference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes );

/*InsertTrackSegment

Copies data into a track.

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. This function places a copy of the segment, which is obtained from the source track, into this destination track. The media for the destination track must be opened for writing by calling BeginMediaEdits in order for the data to be copied. If the media is not opened for writing, the segment will be copied by reference. At the end of the editing session, your application must call EndMediaEdits if it has called BeginMediaEdits.
srcIn

The start of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
srcDuration

The duration of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the time scale of the movie that contains the destination track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are copying data between tracks, make sure that the two tracks are of the same type. For example, you cannot copy a segment from a sound track into a video track. If you have assigned a progress function to the movie that contains the destination track, the Movie Toolbox calls that progress function during long copy operations.
Special Considerations

If you copy a segment without calling BeginMediaEdits on the destination track's media, the data can be copied later by flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );


/*CopyTrackSettings

Copies many settings from one track to another, overwriting the destination settings.

OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. The CopyTrackSettings function uses the settings from the source track, which you specify with the srcTrack parameter, to replace the current settings of this track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function copies matrix information, track volume, the clipping region, user data, matte information, media language, quality, user data, and other media-specific settings (such as sound balance and video graphics mode). It does not copy any alternate group information pertaining to the track. This function does not copy the track's contents. To work with track contents, you should use segment-editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack );

/*GetMoviesStickyError

Returns the contents of the sticky error value.

OSErr GetMoviesStickyError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the sticky error value.
Discussion

The sticky error value contains the first nonzero result code from any Movie Toolbox function that you called after having cleared the sticky error with ClearMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesStickyError ( void );

/*UpdateMovieResource

Replaces the contents of a movie resource in a specified movie file.

OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to place in the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file that contains the resource to be changed. Your application obtains this value from OpenMovieFile.
resId

The resource to be changed. This value is obtained from a previous call to NewMovieFromFile, NewMovieFromDataRef, or AddMovieResource. If you specify a single-fork movie file by passing the movieInDataForkResID constant, the Movie Toolbox places the movie resource into the file's data fork.
resName

Points to a new name for the resource. If you don't want to change the resource's name, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the movie that is to be placed into the resource. This function can accommodate single-fork movie files. After updating the movie file, this function clears the movie changed flag.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by UpdateMovieInStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName );

/*SetTrackLayer

Sets a track's layer.

void SetTrackLayer (
   Track    theTrack,
   short    layer );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
layer

The track's layer number. Layers are numbered from -32,768 through 32,767. When you create a new track, the Movie Toolbox sets its track number to 0.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackLayer (
   Track    theTrack,
   short    layer );

/*GetTrackLayer

Retrieves a track's layer.

short GetTrackLayer (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's layer number.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackLayer (
   Track    theTrack );


/*GetTrackOffset

Determines the time difference between the start of a track and the start of the movie that contains the track.

TimeValue GetTrackOffset (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The time difference between the start of the specified track and the start of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackOffset (
   Track    theTrack );

/*SetMovieTimeValue

Sets a movie's time value.

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
newtime

The new time value. You must ensure that the time value is in the movie's time scale.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime );

/*GetTrackSegmentDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world during a specified segment.

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to consider. This time value must be expressed in the movie's time coordinate system. The duration parameter specifies the length of the segment.
duration

The length of the segment to consider. Set this parameter to 0 to consider an instant in time.
Return Value

A handle to the region the specified track occupies in its movie's graphics world during a specified segment. If the track does not have a spatial representation during the specified segment, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

This function allocates the region and returns a handle to it. This region is valid for the specified segment.
Special Considerations

Your application must dispose of the returned region when you are done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration );


/*GetMovieGWorld

Returns a movie's graphics world.

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

A pointer to a field that is to receive a pointer to a CGrafPort structure. Set this parameter to NIL if you don't want this information.
gdh

A pointer to a field that is to receive a handle to a GDevice structure. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh );


/*GetMovieMatrix

Retrieves a movie's transformation matrix.

void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to a MatrixRecord structure, where GetMovieMatrix returns the movie's matrix.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix );

/*GetTrackMatrix

Retrieves a track's transformation matrix.

void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure. The GetTrackMatrix function returns the track's matrix into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix );

/*TrackTimeToMediaTime

Converts a track's time value to a time value that is appropriate to the track's media, using the track's edit list.

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack );
Parameters
value

The track's time value; must be expressed in the time scale of the movie that contains the track.
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The track's time value, but in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack );

/*GetMediaSample

Returns a sample from a movie data file.

OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOut

A handle. The GetMediaSample function returns the sample data into this handle. The function increases the size of this handle, if necessary. You can specify the handle's maximum size with the maxSizeToGrow parameter.
maxSizeToGrow

The maximum number of bytes of sample data to be returned. The GetMediaSample function does not increase the handle specified by the dataOut parameter to a size greater than you specify with this parameter. Set this value to 0 to enforce no limit on the number of bytes to be returned.
size

A pointer to a long integer. The GetMediaSample function updates the field referred to by the size parameter with the number of bytes of sample data returned in the handle specified by the dataOut parameter. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. The GetMediaSample function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The GetMediaSample function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The GetMediaSample function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The GetMediaSample function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSample returns flags (see below) that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );

/*SetMediaSampleDescription

Changes the contents of a particular SampleDescription structure of a specified media.

OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to be changed. This index corresponds to the SampleDescription structure itself, not the samples in the media. This long integer must be between 1 and the largest SampleDescription index.
descH

The handle to the SampleDescription structure. If there is no description for the specified index, the function returns this handle unchanged.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );

/*GetTrackDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world.

RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to the region the specified track occupies in a movie's graphics world.
Discussion

This function allocates the region and returns a handle to the region. If the track does not have a spatial representation at the current movie time, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Special Considerations

Your application must dispose of the returned region when you are done with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack );

/*AddMediaSample

Adds sample data and a description to a media.

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataIn

A handle to the sample data. The AddMediaSample function adds this data to the media specified by the parameter theMedia. You specify the number of bytes of sample data with the size parameter. You can use the inOffset parameter to specify a byte offset into the data referred to by this handle.
inOffset

Specifies an offset into the data referred to by the handle contained in the dataIn parameter. Set this parameter to 0 if there is no offset.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
durationPerSample

The duration of each sample to be added. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60 to add a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output (I/O). You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Contains flags (see below) that control the add operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the sample data to the media, the AddMediaSample function returns the time where the sample was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application specifies the sample and the media for the operation. AddMediaSample updates the media so that it contains the sample data. One call to this function can add several samples to a media; however, all the samples must be the same size. Samples are always appended to the end of the media. Furthermore, the media duration is extended each time a sample is added.// AddMediaSample coding example
// See "Discovering QuickTime," page 250
#define kSoundSampleDuration    1
#define kSyncSample             0
#define kTrackStart             0
#define kMediaStart             0
#define kFix1                   0x00010000
void CreateMySoundTrack (Movie movie)
{
    Track                       track;
    Media                       media;
    Handle                      hSound =NIL;
    SoundDescriptionHandle      hSoundDesc =NIL;
    long                        lDataOffset;
    long                        lDataSize;
    long                        lNumSamples;
    hSound =GetResource(soundListRsrc, 128);
    if (hSound ==NIL)
        return;
    hSoundDesc =(SoundDescriptionHandle)NewHandle(4);
 
    CreateMySoundDescription(hSound,
                            hSoundDesc,
                            &lDataOffset,
                            &lNumSamples,
                            &lDataSize);
 
    track =NewMovieTrack(movie, 0, 0, kFullVolume);
    media =NewTrackMedia(track, SoundMediaType,
                                FixRound((**hSoundDesc).sampleRate),
                                NIL, 0);
    BeginMediaEdits(media);
    AddMediaSample(media,
                    hSound,
                    lDataOffset,        // offset in data
                    lDataSize,
                    kSoundSampleDuration,   // duration of each sound
                                            //  sample
                    (SampleDescriptionHandle)hSoundDesc,
                    lNumSamples,
                    kSyncSample,        // self-contained samples
                    NIL);
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                            kTrackStart,    // track start time
                            kMediaStart,    // media start time
                            GetMediaDuration(media),
                            kFix1);
    if (hSoundDesc !=NIL)
        DisposeHandle((Handle)hSoundDesc);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );


/*DeleteTrackSegment

Removes a specified segment from a track.

OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
startTime

A time value specifying the starting point of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
duration

A time value that specifies the duration of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration );

/*ExtendMediaDecodeDurationToDisplayEndTime

Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.

OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
mediaChanged

A pointer to a Boolean that returns TRUE if any samples in the media were adjusted, FALSE otherwise. If you don't want to receive this information, set this parameter to NULL.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

After adding a complete, well-formed set of samples to a media, the media's display end time should be the same as the media's decode end time (also called the media decode duration). However, this is not necessarily the case after individual sample-adding operations, and hence it is possible for a media to be left with a display end time later than its decode end time (if adding a sequence of frames is aborted halfway, for example).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged );

/*QTGetDataReferenceFullPathCFString

Returns the full pathname of the target of the data reference as a CFString.

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath );
Parameters
dataRef

An alias data reference to which you want a new data reference that points to the directory.
dataRefType

The type the input data reference; must be AliasDataHandlerSubType.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
outPath

A pointer to a CFStringRef entity where a reference to the newly created CFString will be returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters was NIL or the value of dataRefType is not AliasDataHandlerSubType.
Discussion

This function creates a new CFString that represents the full pathname of the target pointed to by the input data reference, which must be an alias data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath );


/*QTNewDataReferenceFromFSRefCFString

Creates an alias data reference from a file reference pointing to a directory and a file name.

OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
directoryRef

A pointer to an opaque file specification that specifies the directory of the newly created alias data reference.
fileName

A reference to a CFString that specifies the name of the file.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

This function is useful for creating an alias data reference to a file that does not exist yet. Note that you cannot construct an FSRef for a nonexistent file. You can use File Manager functions to construct an FSRef for the directory. Depending on where your file name comes from, you may already have it in a form of CFString, or you may have to call CFString functions to create a new CFString for the file name. Then you can pass the new alias data reference to other Movie Toolbox functions that take a data reference. If you already have an FSRef for the file you want, you can call QTNewDataReferenceFromFSRef instead.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );


/*MCActivate

Lets a controller respond to activate, deactivate, suspend, and resume events.

ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
activate

The nature of the event. Set this parameter to TRUE for activate and resume events. Set it to FALSE for deactivate and suspend events.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate );




/*MCDraw

Responds to an update event.

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the update event has occurred.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w );


/*MCGetControllerBoundsRect

Returns a movie controller's boundary rectangle.

ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that is to receive the coordinates of the movie controller's boundary rectangle. If there is insufficient screen space to display the controller, the function may return an empty structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds );

/*StartMovie

Starts the movie playing from the current movie time.

void StartMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You are not required to call this function to start a movie. It is included in the QuickTime API for convenience. Before playing the movie, the Movie Toolbox makes the movie active, prerolls the movie, and sets the movie to its preferred playback rate. You can use SetMoviePreferredRate to change this setting. 
Special Considerations

A movie's current time is saved when a movie is stored in a movie file. Therefore, your application should appropriately position a movie before playing the movie. Use GoToBeginningOfMovie to set a movie to play from its start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void StartMovie (
   Movie    theMovie );

/*GetMovieRate

Returns a movie's playback rate.

Fixed GetMovieRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The rate at which the movie is currently playing, expressed as a 32-bit fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. A value of 1 indicates normal speed, a value of 2 indicates double speed, -2 means the movie is playing backward at double speed, and so on. A value of 0 means the movie is paused or stopped.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


Fixed GetMovieRate (
   Movie    theMovie );


/*InstallReceiveHandler

Installs a receive handler function for one or all of your application’s windows.

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
);
Parameters
receiveHandler

A pointer to a receive handler function. Installing a receive handler function allows your application to accept a drag by getting drag item flavor data from the Drag Manager when the user releases the mouse button while dragging over one of your application’s windows. 
theWindow

A reference to the window for which to install the receive handler. When a drop occurs over this window, the Drag Manager calls your receive handler function to allow your application to accept the drag. If you pass NULL, the receive handler function is installed in the default handler space for your application. Receive handler functions installed in this way are called when a drop occurs over any window that belongs to your application. You may install more than one receive handler function on a single window.
handlerRefCon

A pointer to a reference constant that will be forwarded to your receive handler function when it is called by the Drag Manager. Use this constant to pass any data you wish to forward to your drag receive handler. 
Return Value

A result code. See “Drag Manager Result Codes”.
Discussion

The Drag Manager sequentially calls all of the receive handler functions installed on a window when a drop occurs in that window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Drag.h*/

OSErr InstallReceiveHandler (
   DragReceiveHandlerUPP receiveHandler,
   WindowRef theWindow,
   void * handlerRefCon
);

/*GetMovieNaturalBoundsRect

Gets a movie's natural boundary rectangle.

void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
naturalBounds

A pointer to a Rect structure that represents the movie's bounding rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds );

/*MCClick

Lets a controller respond when the user clicks in a movie controller window.

ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
where

The location of the click. This value is expressed in the local coordinates of the window specified by the w parameter. Your application must convert this value from the global coordinates returned in the EventRecord structure.
when

Indicates when the user pressed the mouse button. You obtain this value from the EventRecord structure.
modifiers

Specifies modifier flags for the event. You obtain this value from the EventRecord structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers );

/*MCIsPlayerEvent

Handles all events for a movie controller.

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
e

A pointer to the current EventRecord structure.
Return Value

A long integer indicating whether the movie controller component handled the event. The component sets this long integer to 1 if it handled the event. Your application should then skip the rest of its event loop and wait for the next event. The return value is 0 otherwise. Your application must then handle the event as part of its normal event processing.
Discussion

The movie controller component does everything necessary to support the movie controller and its associated movie. For example, the component calls MoviesTask for each movie. The movie controller component also handles suspend and resume events. It treats suspend events as deactivate requests and resume events as activate requests.

The following sample code shows how to convert Windows messages to Macintosh events and then pass those events to the QuickTime movie controller, using this function:// MCIsPlayerEvent coding example
// See "Discovering QuickTime," page 240
MovieController   mc;                   // Movie controller for movie
LRESULT CALLBACK WndProc
        (HWND       hwnd,               // Handle to window
         UINT       iMsg,               // Message type
         WPARAM     wParam,             // Message-dependent parameter
         LPARAM     lParam)             // Message-dependent parameter
{
    MSG             msg;                // Windows message structure
    EventRecord     er;                 // Macintosh event record
    DWORD           dwPos;              // Mouse coordinates of message
    msg.hwnd        =hwnd;             // Window handle
    msg.message     =iMsg;             // Message type
    msg.wParam      =wParam;           // Word-length parameter
    msg.lParam      =lParam;           // Long-word parameter
 
    msg.time =GetMessageTime();        // Get time of message
    dwPos  =GetMessagePos();           // Get mouse position
    msg.pt.x =LOWORD(dwPos);           // Extract x coordinate
    msg.pt.y =HIWORD(dwPos);           // Extract y coordinate
 
    WinEventToMacEvent(&msg, &er);      // Convert to event
    MCIsPlayerEvent(mc, &er);           // Pass event to QuickTime
 
    switch (iMsg) {                     // Dispatch on message type
 
        . . .       // Handle message according to type
 
    }  // end switch (iMsg)
 
}  // end WndProc

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e );

/*GetMovieNextInterestingTime

Searches for times of interest in a movie's enabled tracks.

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeStep
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
numMediaTypes

The number of media types in the table referred to by the whichMediaType parameter. Set this parameter to 0 to search all media types.
whichMediaTypes

A pointer to an array of media type constants (see below). You can use this parameter to limit the search to a specified set of media types. Each entry in the table referred to by this parameter identifies a media type to be included in the search. You use the numMediaTypes parameter to indicate the number of entries in the table. Set this parameter to NIL to search all media types. See these constants: 
VisualMediaCharacteristic
AudioMediaCharacteristic
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. If you are not interested in this information, set this parameter to NIL.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works faster.
Discussion

The following code sample shows the use of GetMovieNextInterestingTime to return, through the time parameter, the starting time of the first video sample of the specified QuickTime movie. The trick here is to set the nextTimeEdgeOK flag, to indicate that you want to get the starting time of the beginning of the movie. If this function encounters an error, it returns a (bogus) starting time of -1, as shown below:static OSErr QTStep_GetStartTimeOfFirstVideoSample (Movie theMovie,
                                                    TimeValue *theTime)
{
    short           myFlags;
    OSType          myTypes[1];
 
    *theTime =kBogusStartingTime;               // a bogus starting time
    if (theMovie ==NIL)
        return(invalidMovie);
 
    myFlags =nextTimeMediaSample + nextTimeEdgeOK;
                                 // we want the first sample in the movie
    myTypes[0] =VisualMediaCharacteristic;      // we want video samples
    GetMovieNextInterestingTime(theMovie, myFlags, 1, myTypes,
                                      (TimeValue)0, fixed1, theTime, NIL);
    return(GetMoviesError());
}

Special Considerations

This function examines only the movie's enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration );

/*FlattenMovie

Creates a new movie file containing a specified movie.

void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Set this parameter to the Script Manager constant smSystemScript to use the system script; set it to smCurrentScript to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by the resId parameter is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. The Movie Toolbox assigns resource ID numbers sequentially, starting at 128. If the resId parameter is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value.
resName

Points to a character string with the name of the movie resource. If you set the resName parameter to NIL, the toolbox creates an unnamed resource.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The file created by FlattenMovie also contains all the data for the movie; that is, the Movie Toolbox resolves any data references and includes the corresponding movie data in the new movie file.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName );


/*MCSetControllerBoundsRect

Lets you change the position and size of a movie controller.

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that contains the new boundary Rect structure for the movie controller.
Return Value

See Error Codes. Returns a value of controllerBoundsNotExact if the boundary rectangle has been changed but does not correspond to the rectangle you specified. In this case, the new boundary rectangle is always smaller than the requested rectangle. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds );

/*MCSetControllerPort

Lets your application set the graphics port for a movie controller.

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
gp

A pointer to the new graphics port for the movie controller. Set this parameter to NIL to use the current graphics port.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Movie controller components use MCSetControllerPort each time you create a new movie controller. Hence, your component must be set to a valid port before creating a new movie controller. You can use this function to place a movie and its associated movie controller in different graphics ports. If you are using an attached controller, both the controller and the movie's graphics ports are changed. If you are using a detached controller, this function changes only the graphics port of the control portion of the controller. You must use SetMovieGWorld followed by MCMovieChanged to change other portions.pascal ComponentResult MCSetControllerPort (MovieController mc,
                                            CGrafPtr gp);

Special Considerations

The movie controller component may use the foreground and background colors from the graphics port at the time this function is called to colorize the movie controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp );

/*MCGetIndMovie

Lets your application to retrieve the movie reference for a movie that is associated with a movie controller.

Movie MCGetIndMovie (
   MovieController    mc,
   short              index );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
index

Index for the movie. When set to 0, this call duplicates the action of the previous call to this function.
Return Value

The movie identifier for the movie that is assigned to the specified controller, or NIL if there is no movie assigned to the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCGetIndMovie (
   MovieController    mc,
   short              index );

/*MCGetControllerPort

Returns a movie controller's color graphics port.

CGrafPtr MCGetControllerPort (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A pointer to the movie controller's CGrafPort structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
CGrafPtr MCGetControllerPort (
   MovieController    mc );

/*MCGetWindowRgn

Determines the window region that is actually in use by a controller and its movie.

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
Return Value

A handle to the MacRegion structure for the window that is actually in use. Your application must dispose of this structure.
Discussion

The region returned by this function contains only the visible portions of the controller and its movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w );

/*GetMoviePosterPict

Creates a QuickDraw picture that contains a movie's poster.

PicHandle GetMoviePosterPict (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePosterPict (
   Movie    theMovie );

/*&GetMoviePreferredRate

Returns a movie's default playback rate.

Fixed GetMoviePreferredRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's default playback rate.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Fixed GetMoviePreferredRate (
   Movie    theMovie );

/*CopyMovieSettings

Copies many settings from one movie to another, overwriting the destination settings in the process.

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dstMovie

The destination movie for this operation. The CopyMovieSettings function uses the settings from the source movie, which is specified by the srcMovie parameter, to replace the current settings of this movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to copy certain important settings from one movie to another. It copies the preferred rate and volume, source clipping region, matrix information, and user data; it does not copy the movie's contents. To work with movie contents, you should use segment editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie );

/*SetMovieMatrix

Sets a movie's transformation matrix.

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to the MatrixRecord structure for the movie. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox uses a movie's matrix to map a movie from its display coordinate system to its graphics world.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix );

/*SetMovieClipRgn

Establishes a movie's clipping region.

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
theClip

A handle to the movie's clipping region. The Movie Toolbox makes a copy of this region. Your application must dispose of the region referred to by this parameter when you are done with it. Set this parameter to NIL to disable clipping for the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The clipping region is saved with the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip );

/*PutMovieIntoTypedHandle

Takes a movie, or a single track from within that movie, and converts it into a handle of a specified type.

OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
targetTrack

The track to convert.
handleType

The type of the new data.
publicMovie

The actual handle in which to place the new data.
start

The start time of the segment of the movie or track to be converted.
dur

The duration of the segment of the movie or track to be converted.
flags

Condition of the conversion. Set this parameter to 0.
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, this function will use it. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp );

/*LoadMovieIntoRam

Loads a movie's data into memory.

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to load.
duration

The length of the segment to load. Use GetMovieDuration to determine the length of the entire movie. Note that the Movie Toolbox may load more data than you specify due to the way the data is loaded.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags );

/*SetMovieDefaultDataRef

Sets a movie's default data reference and type.

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dataRef

A handle to the data reference. The type of information to be placed in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType );

/*GetSoundDescriptionExtension

Gets the current extension to a SoundDescription structure.

OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType );
Parameters
desc

A handle to a SoundDescription structure.
extension

A pointer to a handle that, on return, contains the extension.
idType

A four-byte signature that identifies the type of data in the extension.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType );

/*AddSoundDescriptionExtension

Adds an extension to a SoundDescription structure.

OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType );
Parameters
desc

A handle to the SoundDescription structure to add the extension to.
extension

The handle containing the extension data.
idType

A four-byte signature identifying the type of data being added to the SoundDescription.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Two extensions are defined to the SoundDescription record. The first is the slope, intercept, minClip, and maxClip parameters for audio, represented as an atom of type 'flap'. The second extension is the ability to store data specific to a given audio codec, using a SoundDescriptionV1 structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType );


/*AddUserDataText

Places language-tagged text into an item in a user data list.

OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A handle to the data to be added to the user data list.
udType

The type that is to be assigned to the new item.
index

The item to which the text is to be added. This parameter must specify an item in the user data list identified by theUserData.
itlRegionTag

The region code of the text to be added. If there is already text with this region code in the item, the function replaces the existing text with the data specified by the data parameter. See Inside Macintosh: Text for more information about language and region codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, the data to be added, the data's type value, and the language code of the data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );


/*SetQuickTimePreference

Sets a particular preference in the QuickTime preferences.

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom );
Parameters
preferenceType

The type of preference to set (see below); also see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A QT atom containing the preference information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom );

/*QTInsertChild

Creates a new child atom of the specified parent atom.

OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
atomType

The type of the new atom to be inserted.
id

The ID of the new atom to be inserted. This ID must be unique among atoms of the same type for the specified parent. If you set this parameter to 0, the function assigns a unique ID to the atom.
index

The index of the new atom among atoms with the same parent. To insert the first atom for the specified parent, you should set this parameter to 1. To insert an atom as the last atom in the child list, you should set this parameter to 0. Index values greater than the index of the last atom in the child list plus 1 are invalid.
dataSize

The size of the data for the new atom. If the new atom is to be a parent atom or if you want to add the atom's data later, you should pass 0 for this parameter. To create the new atom as a leaf atom that contains data, you should specify the data using the data parameter and and its size using the dataSize parameter.
data

A pointer to a buffer containing the data for the new atom. If you set the value of the dataSize parameter to 0, you should pass NIL for this parameter.
newAtom

A pointer to data of type QTAtom. On return, this parameter points to the newly created atom. You can pass NIL for this parameter if you don't need a reference to the newly created atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new child atom. The new child atom has the specified atom type and atom ID, and is inserted into its parent atom's child list at the specified index. Any existing atoms at the same index or greater are moved toward the end of the child list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom );

/*QTNewAtomContainer

Creates a new atom container.

OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData );
Parameters
atomData

A pointer to an unallocated atom container data structure. On return, this parameter points to an allocated atom container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates a new, empty atom container structure. Once you have created an atom container, you can manipulate it using the atom container functions. The following example illustrates using this function to create a new QT atom container and add an atom:// QTNewAtomContainer coding example
QTAtom firstAtom;
QTAtomContainer container;
OSErr err
err =QTNewAtomContainer (&container);
if (!err)
    err =QTInsertChild (container, kParentAtomIsContainer, 'abcd',
        1000, 1, 0, NIL, &firstAtom);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData );

/*GetQuickTimePreference

Retrieves a particular preference from the QuickTime preferences.

OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom );
Parameters
preferenceType

A preference type to be retrieved (see below); see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A pointer to the returned preference atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following sample code shows how to retrieve the connection speed setting from the QuickTime preferences:struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;
. . .
OSErr                       err;
QTAtomContainer             prefs;
QTAtom                      prefsAtom;
long                        dataSize;
Ptr                         atomData;
ConnectionSpeedPrefsRecord  prefrec;
err =GetQuickTimePreference(ConnectionSpeedPrefsType, &amp;prefs);
if (err ==noErr) {
    prefsAtom =QTFindChildByID(prefs, kParentAtomIsContainer,
                                  ConnectionSpeedPrefsType, 1, nil);
    if (!prefsAtom) {
        // set the default setting to 28.8kpbs
        prefrec.connectionSpeed =kDataRate288ModemRate;
    } else {
        err =QTGetAtomDataPtr(prefs, prefsAtom, &dataSize,
                                                         &atomData);
        if (dataSize !=sizeof(ConnectionSpeedPrefsRecord)) {
            // the prefs record wasn't the right size,
            // so it must be corrupt -- set to the default
            prefrec.connectionSpeed =kDataRate288ModemRate;
        } else {
            // everything was fine -- read the connection speed
            prefrec =*(ConnectionSpeedPrefsRecord *)atomData;
        }
    }
    QTDisposeAtomContainer(prefs);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom );

/*DeleteTrackReference

Removes a track reference from a track.

OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference.
index

The index value of the reference to be deleted. You obtain this index value when you create the track reference.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function deletes a track reference from a track. If there are additional track references with higher index values, the toolbox automatically renumbers those references, decrementing their index values by 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );

/*GetTrackReference

Retrieves the track identifier contained in an existing track reference.

Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References.
index

The index value of the reference found. You obtain this index value when you create the track reference.
Return Value

The track identifier for the specified track. If the toolbox cannot locate the track reference corresponding to your specifications, it returns a value of NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );

/*GetTrackReferenceCount

Determines how many track references of a given type exist for a track.

long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References. The toolbox determines the number of track references of this type.
Return Value

A long integer that specifies the number of track references of the specified type in the track. If there are no references of the type you have specified, the function returns a value of 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType );

/*GetNextTrackReferenceType

Determines all of the track reference types that are defined for a given track.

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference. Set this parameter to 0 to retrieve the first track reference type. On subsequent requests, use the previous value returned by this function.
Return Value

An OSType containing the next track reference type value defined for the track; see Data References.
Discussion

There is no implied ordering of the values returned by this function . When you reach the end of the track's reference types, this function sets the returned value to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType );

/*GetMovieImporterForDataRef

Gets the movie importer component for a movie.

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer );
Parameters
dataRefType

The type of data reference; see Data References.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
flags

Flags (see below) that modify this function's behavior. See these constants: 
kGetMovieImporterDontConsiderGraphicsImporters
importer

A pointer to an importer component that can import the movie. Returns NIL if no importer can be found.
Return Value

If this function is allowed to use async calls (by being passed kGetMovieImporterUseAsyncCalls in the flags parameter), it returns notEnoughDataErr if it would block. You can access this error return through GetMoviesError and GetMoviesStickyError, as well as in the function result. For other errors, see Error Codes.
Discussion

You can use GetMovieImporterForDataRef to determine if a file can be opened by QuickTime as a movie (for example, in a drag-and-drop operation) as illustrated below:AliasHandle            alias;
MovieImportComponent   mi;
NewAliasMinimal(&reply.sfFile, &alias);
GetMovieImporterForDataRef(rAliasType, (Handle)alias,
kGetMovieImporterDontConsiderGraphicsImporters, &mi);
DisposeHandle((Handle)alias);
if (mi !=NIL) {
    // this file can be opened as a movie
    . . .
    }

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer );

/*GetUserData

Returns a specified user data item.

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data from the specified item. GetUserData resizes this handle as appropriate to accommodate the item. Your application is responsible for releasing this handle when you are done with it. Set this parameter to NIL if you don't want to retrieve the user data item. This can be useful if you want to verify that a user data item exists, but you don't need to work with the item's contents.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index );

/*GetTrackUserData

Obtains access to a track's user data list.

UserData GetTrackUserData (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A reference to the specified track's user data. If the function could not locate the track's user data, it sets this returned value to NIL.
Discussion

This function returns a reference to the track's user data list, which is valid until you dispose of the track. When you save the track, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetTrackUserData (
   Track    theTrack );

/*GetTimeBaseFlags

Obtains the control flags of a time base.

long GetTimeBaseFlags (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

Control flags (see below). Unused flags are set to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

long GetTimeBaseFlags (
   TimeBase    tb );

/*SetUserDataItem

Sets an item in a user data list.

OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this item reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer to the data item to be set in a user data list.
size

The size of the information pointed to by the data parameter.
udType

The type value assigned to the new item.
index

The item's index value. This parameter must specify an item in the user data list identified by theUserData. An index value of 0 or 1 implies the first item, which is created if it doesn't already exist.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );

/*RemoveUserData

Removes an item from a user data list.

OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
udType

The item's type value.
index

The item's index value. This parameter must specify an item in the user data list identified by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

After the Movie Toolbox removes the item, it renumbers the remaining items of that type so that their index values are sequential and start at 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index );

/*CountUserDataType

Determines the number of items of a given type in a user data list.

short CountUserDataType (
   UserData    theUserData,
   OSType      udType );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData functions.
udType

The type. The Movie Toolbox determines the number of items of this type in the user data list.
Return Value

The number of items of the given type in the user data list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short CountUserDataType (
   UserData    theUserData,
   OSType      udType );

/*GetUserDataItem

Returns a specified user data item.

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer that is to receive the data from the specified item.
size

The size of the item.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );

/*SetMoviePreferredVolume

Sets a movie's preferred volume setting.

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The preferred volume setting of the movie. The volume parameter must contain a 16-bit, fixed-point number that contains the movie's default volume. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You may find the constants shown below useful. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A movie's tracks may have their own volume settings. Use SetTrackVolume to set the volume of an individual track. A track's volume is scaled by the movie's volume to produce the track's final volume.
Special Considerations

After calling this function you must save the changes it has made, for example by updating or flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume );

/*GetMovieVolume

Returns a movie's current volume setting.

short GetMovieVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The current volume setting for the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMovieVolume (
   Movie    theMovie );

/*GetMoviePreferredVolume

Returns a movie's preferred volume setting.

short GetMoviePreferredVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's preferred volume setting.
Discussion

A movie's tracks have their own volume settings. A track's volume is scaled by the movie's volume to produce the track's final volume. On Macintosh computers, the movie's volume is further scaled by the sound volume that the user controls from the Sound control panel.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMoviePreferredVolume (
   Movie    theMovie );

/*MCPositionController

Controls the position of a movie and its controller on the computer display.

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
movieRect

A pointer to a Rect structure that specifies the coordinates of the movie's boundary Rect structure.
controllerRect

A pointer to a Rect structure that specifies the coordinates of the controller's boundary Rect structure. The movie controller component always centers the control portion of the controller inside this rectangle. The movie controller component only uses this parameter when the control portion of the controller is detached from the movie. If you are working with an attached controller, you can set this parameter to NIL.
someFlags

Flags (see below) that control how the movie is drawn. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by movieRect and scales the movie to fit in that rectangle. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcPositionDontInvalidate
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags );

/*MCSetControllerAttached

Lets your application control whether a movie controller is attached to its movie or detached from it.

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
attach

The action for this function. Set the attach parameter to TRUE to cause the controller to be attached to its movie. Set this parameter to FALSE to detach the controller from its movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach );

/*MCGetVisible

Returns a value that indicates whether or not a movie controller is visible.

ComponentResult MCGetVisible (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is visible, the function result is set to 1. If the controller is not showing, the function result is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCGetVisible (
   MovieController    mc );

/*MCUndo

Lets your application discard the effects of the most recent edit operation.

ComponentResult MCUndo (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCUndo (
   MovieController    mc );

/*MCCut

Returns a copy of the current movie selection from the movie associated with a specified controller and then removes the current movie selection from the source movie.

Movie MCCut (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the current movie selection.
Discussion

Your application is responsible for the returned movie. MCCut returns a movie containing the current selection from the movie associated with the specified controller. If the user has not made a selection, the returned movie reference is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCCut (
   MovieController    mc );

/*(MCCopy

Returns a copy of the current movie selection from the movie associated with a specified controller.

Movie MCCopy (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
Movie MCCopy (
   MovieController    mc );

/*MCPaste

Inserts a specified movie at the current movie time in the movie associated with a specified controller.

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
srcMovie

The movie to be inserted into the current selection in the movie associated with the movie controller specified by the mc parameter. If you set this parameter to NIL, the movie controller component retrieves the source movie from the scrap.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie );

/*MCClear

Removes the current movie selection from the movie associated with a specified controller.

ComponentResult MCClear (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClear (
   MovieController    mc );

/*PutMovieOnScrap

Places a movie into the Macintosh scrap.

OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieScrapFlags

Flags (see below) that control the operation. Be sure to set unused flags to 0. See these constants: 
movieScrapDontZeroScrap
movieScrapOnlyPutMovie
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags );

/*MCGetControllerInfo

Determines the current status of a movie controller and its associated movie, for menu highlighting.

ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
someFlags

A pointer to flags (see below) that specify the current status and capabilities of the controller. More than one flag may be set to 1. See these constants: 
mcInfoUndoAvailable
mcInfoCutAvailable
mcInfoCopyAvailable
mcInfoPasteAvailable
mcInfoClearAvailable
mcInfoHasSound
mcInfoIsPlaying
mcInfoIsLooping
mcInfoIsInPalindrome
mcInfoEditingEnabled
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can use the information returned by this function to control your application's menu highlighting.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags );

/*MCEnableEditing

Enables and disables editing for a movie controller.

ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
enabled

Specifies whether to enable or disable editing for the controller. Set this parameter to TRUE to enable editing; set it to FALSE to disable editing.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Once editing is enabled for a controller, the user may edit the movie associated with the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled );


/*MCSetActionFilterWithRefCon

Establishes an action filter function for a movie controller.

ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
blob

A pointer to your MCActionFilterWithRefConProc callback. Set this parameter to NIL to remove an existing callback.
refCon

A reference constant value. The movie controller component passes this reference constant to your action filter callback each time it calls it. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The movie controller component calls your action filter function each time the component receives an action for its movie controller. Your filter function is then free to handle the action or to refer it back to the movie controller component. If you refer it back to the movie controller component, the component handles the action.

If your filter function handles an action, you can handle the action in any way you desire. For example, your filter function could change the operation of movie controller buttons. More commonly, applications use the action filter function to monitor actions of the controller. For instance, your filter function might enable you to find out when the user clicks the play button, so that your application can enable appropriate menu selections. Alternatively, you can use the filter function to detect when the user resizes the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon );

/*NewMCActionFilterWithRefConUPP

Allocates a Universal Procedure Pointer for the MCActionFilterWithRefConProc callback.

MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMCActionFilterWithRefConProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine );

/*SetMovieProgressProc

Attaches a progress function to a movie.

void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
p

Points to your MovieProgressProc callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls your function only during long operations. It ensures that your progress function is called regularly, but not too often.

The following Movie Toolbox functions use progress functions: ConvertFileToMovieFile, CutMovieSelection, CopyMovieSelection, AddMovieSelection, and InsertMovieSegment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon );

/*ExitMovies

Automatically called when an application quits.

void ExitMovies ( void );
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You only need to call this function if you finish with the Movie Toolbox long before your application is ready to quit. When you call ExitMovies, the Movie Toolbox releases the private storage (which may be significant) that was allocated when you called EnterMovies. As a general rule, your application seldom uses this function; the following code illustrates an exception:// ExitMovies coding example
// See "Discovering QuickTime," page 225
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HANDLE      hAccelTable;
 
    if  (!hPrevInstance)                   // Is there a previous instance?
        if (!(InitApplication(hInstance)))      // Register window class
            return FALSE;                       // Report failure
 
    if (InitializeQTML(0) !=0) {                       // Initialize QTML
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (InitializeQTML(0) !=0)
 
    if (EnterMovies() !=0) {                       // Initialize QuickTime
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (EnterMovies() !=0)
 
    if (!(InitInstance(hInstance, nCmdShow)))         // Create main window
        return FALSE;                                 // Report failure
 
    hAccelTable =LoadAccelerators(hInstance,     // Load accelerator table
                    MAKEINTRESOURCE(IDR_ACCELSIMPLESDI));
 
    //  Main message loop
 
    while (GetMessage(&msg, NIL, 0, 0))        // Retrieve next message
        if (!TranslateAccelerator(msg.hwnd,    // Check for kbd accelerator
                        hAccelTable, &msg)) {
            TranslateMessage(&msg);     // Convert virtual key to character
            DispatchMessage(&msg);      // Send message to window procedure
        }  // end if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
 
    ExitMovies();                                   // Terminate Toolbox
    TerminateQTML();                                // Terminate QuickTime
 
    return msg.wParam;
}  // end WinMain

Special Considerations

Before calling ExitMovies, be sure that you have closed your connections to any components that use the Movie Toolbox, such as movie controllers, sequence grabbers, and so on.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ExitMovies ( void );

/*QTDoTween

Runs a tween component.

OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon );
Parameters
tween

The tween to be run.
atTime

A value that defines the time to run the tween.
result

A handle to the result of the tweening operation.
resultSize

A pointer to the size of the result.
tweenDataProc

A Universal Procedure Pointer that accesses a TweenerDataProc callback.
tweenDataRefCon

A pointer to a reference constant to be passed to your callback. Use this constant to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon );

/*QTCopyAtomDataToPtr

Copies the specified leaf atom's data to a buffer.

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
sizeOrLessOK

Specifies whether the function may copy fewer bytes than the number of bytes specified by the size parameter. The buffer may be larger than the amount of atom data if you set the value of this parameter to TRUE. You can determine the size of an atom's data by calling QTGetAtomDataPtr.
size

The length, in bytes, of the buffer pointed to by the targetPtr parameter.
targetPtr

A pointer to a buffer. On return, the buffer contains the atom data.
actualSize

A pointer to a long integer which, on return, contains the number of bytes copied to the buffer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing a data buffer, to retrieve a copy of a leaf atom's data. The buffer must be large enough to contain the atom's data.
Special Considerations

This function may move memory.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize );

/*MCSetUpEditMenu

Correctly highlights and names the items in your application's Edit menu.

ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
modifiers

The current modifiers from the mouse-down or key-down event to which you are responding.
mh

A menu handler for your current Edit menu. The first six items in your Edit menu should be the standard editing commands: Undo, a blank line, Cut, Copy, Paste, and Clear.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh );

/*DeleteMovieFile

Deletes a movie file.

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by DeleteMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec );

/*FlattenMovieData

Creates a new movie and a file that contains all the movie data.

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. These flags affect how the toolbox adds movies to the new movie file later. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

This parameter usually contains a pointer to the file system specification for the movie file to be created. In place of a FSSpec pointer, QuickTime lets you pass a pointer to a data reference structure to receive the flattened movie data.
creator

The creator value for the new file.
scriptTag

Contains constants (see below) that specify the script in which the movie file should be created. See Inside Macintosh: Text for more information about scripts and script tags. See these constants: 
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets this returned identifier to NIL.
Discussion

This function will take any movie and optionally make it self-contained, interleaved, and Fast Start. Unlike FlattenMovie, this function does not add the new movie resource to the new movie file; instead, FlattenMovieData returns the new movie to your application. Your application must dispose of the returned movie. You can use this function to create a single-fork movie file, by setting the flattenAddMovieToDataFork flag in the movieFlattenFlags parameter to 1. The Movie Toolbox then places the movie into the data fork of the movie file. Instead of flattening to a file, you can specify a data reference to flatten a movie to. The following two code samples show flattening a movie to a data location and to a file:// FlattenMovieData used to flatten a movie to a data location
// create a 0-length handle
    myHandle =NewHandleClear(mySize);
    if (myHandle ==NIL)
        goto bail;
 
// fill in the data reference record
    myDataRefRec.dataRefType =HandleDataHandlerSubType;
    myDataRefRec.dataRef =NewHandle(sizeof(Handle));
    if (myDataRefRec.dataRef ==NIL)
        goto bail;
    *((Handle *)*(myDataRefRec.dataRef)) =myHandle;
    myFlags =flattenFSSpecPtrIsDataRefRecordPtr;
    myFile =(FSSpec *)&myDataRefRec;
    // flatten the source movie into the handle
    myMemMovie =FlattenMovieData(mySrcMovie, myFlags, myFile, 0L,
                                  smSystemScript, 0L);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork |
        flattenForceMovieResourceBeforeMovieData,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
// FlattenMovieData used to flatten a movie to a Fast Start file
// See "Discovering QuickTime," page 257
myErr =OpenMovieFile(&myTempSpec, &myTempResRefNum, fsRdPerm);
if (myErr !=noErr)
    goto bail;
myErr =NewMovieFromFile(&myTempMovie, myTempResRefNum, NIL, 0, 0, 0);
if (myErr !=noErr)
    goto bail;
SetMovieProgressProc(myTempMovie, (MovieProgressUPP)-1, 0L);
// flatten the temporary file into a new movie file; put the movie
// resource first so that progressive downloading is possible
myPanoMovie =FlattenMovieData(
                        myTempMovie,
                        flattenDontInterleaveFlatten
                        | flattenAddMovieToDataFork
                        | flattenForceMovieResourceBeforeMovieData,
                        &myDestSpec,
                        FOUR_CHAR_CODE('TVOD'),
                        smSystemScript,
                        createMovieFileDeleteCurFile
                        | createMovieFileDontCreateResFile);

Special Considerations

Through the SetTrackLoadSettings function, the Movie Toolbox allows you to set a movie's preloading guidelines when you create the movie. The preload information is preserved when you save or flatten the movie (using either FlattenMovie or FlattenMovieData). In flattened movies, the tracks that are to be preloaded are stored at the start of the movie, rather than being interleaved with the rest of the movie data. This greatly improves preload performance because it is not necessary for the device storing the movie data to seek during retrieval of the data to be preloaded. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags );

/*SetMovieCoverProcs

Sets the callbacks invoked when a movie is covered or uncovered.

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
uncoverProc

Points to a MovieRgnCoverProc callback. This function is called whenever one of your movie's tracks is removed from the screen or resized, revealing a previously hidden screen region. If you want to remove this uncover function, set this parameter to NIL. When the uncoverProc parameter is NIL the function uses the default uncover function, which erases the uncovered area.
coverProc

Points to a MovieRgnCoverProc callback. The Movie Toolbox calls this function whenever one of your movies covers a portion of the screen. If you want to remove the cover function, set this parameter to NIL. When the coverProc parameter is NIL the function uses the default cover function, which does nothing.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If a movie with semi-transparent tracks has a movie uncover procedure, set with this function, the uncover procedure is called before each frame to fill or erase the background.
Version Notes

Before QuickTime 1.6.1, the Movie Toolbox performed the erase, which limited a cover procedure-aware application's options.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon );

/*NewMovieRgnCoverUPP

Allocates a Universal Procedure Pointer for the MovieRgnCoverProc callback.

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieRgnCoverProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine );

/*GetMediaQuality

Returns a media's quality level value.

short GetMediaQuality (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A short integer whose bits indicate quality constants (see below). More than one of these bits may be set to 1.
Discussion

The Movie Toolbox uses this quality value to influence which track of a movie it selects to play on a given computer. This even applies to sound media. The low-order 6 bits specify pixel depths and the upper 2 bits specify quality levels. If a bit is set to 1, the media can be played at the corresponding depth and quality level.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
short GetMediaQuality (
   Media    theMedia );

/*SetSpriteProperty

Sets the specified property of a sprite.

OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue );
Parameters
theSprite

The sprite for this operation.
propertyType

The property you want to modify (see below). See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpritePropertyCanBeHitTested
propertyValue

The new value of the property. Depending on the property type, you set the propertyValue parameter to either a pointer to the property value or the property value itself, cast as a void pointer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You animate a sprite by modifying its properties, using this function. It invalidates the sprite's sprite world as needed. Here is sample code that uses this function to modify a sprite's properties:// SetSpriteProperty coding example
// See "Discovering QuickTime," page 345
#define kNumSprites             4
#define kNumSpaceShipImages     24
Rect            gBounceBox;
Sprite          gSprites[kNumSprites];
Rect            gDestRects[kNumSprites];
Point           gDeltas[kNumSprites];
short           gCurrentImages[kNumSprites];
Handle          gCompressedPictures[kNumSpaceShipImages];
void MyMoveSprites (void)
{
    short           nIndex;
    MatrixRecord    matrix;
 
    SetIdentityMatrix(&matrix);
    // for each sprite
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        // modify the sprite's matrix
        OffsetRect(&gDestRects[nIndex], gDeltas[nIndex].h,
                    gDeltas[nIndex].v);
 
        if ((gDestRects[nIndex].right >
=gBounceBox.right) ||
            (gDestRects[nIndex].left <=gBounceBox.left))
            gDeltas[nIndex].h =-gDeltas[nIndex].h;
 
        if ((gDestRects[nIndex].bottom >
=gBounceBox.bottom) ||
            (gDestRects[nIndex].top <=gBounceBox.top))
            gDeltas[nIndex].v =-gDeltas[nIndex].v;
 
        matrix.matrix[2][0] =((long)gDestRects[nIndex].left << 16);
        matrix.matrix[2][1] =((long)gDestRects[nIndex].top << 16);
 
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyMatrix,
                            &matrix);
 
        // change the sprite's image
        gCurrentImages[nIndex]++;
        if (gCurrentImages[nIndex] >
=(kNumSpaceShipImages *
                                        (nIndex+1)))
            gCurrentImages[nIndex] =0;
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyImageDataPtr,
            *gCompressedPictures[gCurrentImages[nIndex] / (nIndex+1)]);
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue );

/*DisposeSprite

Disposes of a sprite.

void DisposeSprite (
   Sprite    theSprite );
Parameters
theSprite

The sprite to be disposed of.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You call this function to dispose of a sprite created by NewSprite. The image description handle and image data pointer associated with the sprite are not disposed of by this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeSprite (
   Sprite    theSprite );

/*DisposeSpriteWorld

Disposes of a sprite world.

void DisposeSpriteWorld (
   SpriteWorld    theSpriteWorld );
Parameters
theSpriteWorld

The sprite world to dispose of. It is safe to pass NIL to this function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You call this function to dispose of a sprite world created by NewSpriteWorld. This function also disposes of all of the sprites associated with the sprite world. This function does not dispose of the graphics worlds associated with the sprite world. Here is an example of using it:// DisposeSpriteWorld coding example
// See "Discovering QuickTime," page 347
#define kNumSprites             4
#define kNumSpaceShipImages     24
SpriteWorld                 gSpriteWorld =NIL;
Sprite                      gSprites[kNumSprites];
Handle                      gCompressedPictures[kNumSpaceShipImages];
ImageDescriptionHandle      gImageDescriptions[kNumSpaceShipImages];
void MyDisposeEverything (void)
{
    short           nIndex;
    // dispose of the sprite world and associated graphics world
    if (gSpriteWorld)
        DisposeSpriteWorld(gSpriteWorld);
 
    // dispose of each sprite's image data
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        if (gCompressedPictures[nIndex])
            DisposeHandle(gCompressedPictures[nIndex]);
        if (gImageDescriptions[nIndex])
            DisposeHandle((Handle)gImageDescriptions[nIndex]);
    }
    DisposeGWorld(spritePlane);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeSpriteWorld (
   SpriteWorld    theSpriteWorld );


/*NewSpriteWorld

Creates a new sprite world.

OSErr NewSpriteWorld (
   SpriteWorld    *newSpriteWorld,
   GWorldPtr      destination,
   GWorldPtr      spriteLayer,
   RGBColor       *backgroundColor,
   GWorldPtr      background );
Parameters
newSpriteWorld

A pointer to a field that is to receive the new sprite world's identifier. On return, this field contains the identifier for the newly created sprite world.
destination

A pointer to a CGrafPort structure that defines the graphics world to be used as the destination.
spriteLayer

A pointer to a CGrafPort structure that defines the graphics world to be used as the sprite layer.
backgroundColor

A pointer to an RGBColor structure that defines the color to be used as the background color. If you pass a background graphics world to this function by setting the background parameter, you can set this parameter to NIL.
background

A pointer to a CGrafPort structure that defines the graphics world to be used as the background. If you pass a background color to this function by setting the backgroundColor parameter, you can set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new sprite world with associated destination and sprite layer graphics worlds, and either a background color or a background graphics world. Once created, you can manipulate the sprite world and add sprites to it using other sprite Movie Toolbox functions.

The newSpriteWorld, destination, and spriteLayer parameters are all required. You should specify a background color, a background graphics world, or both. You should not pass NIL for both parameters. If you specify both a background graphics world and a background color, the sprite world is filled with the background color before the background sprites are drawn. If no background color is specified, black is the default. If you specify a background graphics world, it should have the same dimensions and depth as the graphics world specified by spriteLayer. If you draw to the graphics worlds associated with a sprite world using standard QuickDraw and QuickTime functions, your drawing is erased by the sprite world's background color. The sprite world created by this function has an identity matrix and does not have a clip shape.

Here is an example of creating a sprite world:// NewSpriteWorld coding example
// See "Discovering QuickTime," page 166
GWorldPtr       pSpritePlane =NIL;
SpriteWorld     spriteWorld =NIL;
Rect            rectBounce;
RGBColor        rgbcBackground;
void CreateSpriteStuff (Rect *pWndRect, CGrafPtr pMacWnd)
{
    OSErr       nErr;
    Rect        rect;
    // calculate the size of the destination
    rect =*pWndRect;
    OffsetRect(&rect, -rect.left, -rect.top);
    rectBounce =rect;
    InsetRect(&rectBounce, 16, 16);
    // create a sprite graphics world with a bit depth of 16
    NewGWorld(&pSpritePlane, 16, &rect, NIL, NIL, useTempMem);
    if (pSpritePlane ==NIL)
        NewGWorld(&pSpritePlane, 16, &rect, NIL, NIL, 0);
    if (pSpritePlane !=NIL) {
        LockPixels(pSpritePlane->
portPixMap);
        rgbcBackground.red =
        rgbcBackground.green =
        rgbcBackground.blue =0;
        // create a sprite world
        nErr =NewSpriteWorld(&spriteWorld, (CGrafPtr)pMacWnd,
            pSpritePlane, &rgbcBackground, NIL);
    }
}

Special Considerations

Before calling this function, you should lock the pixel maps of the sprite layer and background graphics worlds. These graphics worlds must remain valid and locked for the lifetime of the sprite world. The sprite world does not own the graphics worlds that are associated with it; it is the caller's responsibility to dispose of the graphics worlds when they are no longer needed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewSpriteWorld (
   SpriteWorld    *newSpriteWorld,
   GWorldPtr      destination,
   GWorldPtr      spriteLayer,
   RGBColor       *backgroundColor,
   GWorldPtr      background );

/*NewSprite

Creates a new sprite in a specified sprite world.

OSErr NewSprite (
   Sprite                    *newSprite,
   SpriteWorld               itsSpriteWorld,
   ImageDescriptionHandle    idh,
   Ptr                       imageDataPtr,
   MatrixRecord              *matrix,
   Boolean                   visible,
   short                     layer );
Parameters
newSprite

A pointer to field that is to receive the new sprite's identifier. On return, this field contains the identifier of the newly created sprite.
itsSpriteWorld

The sprite world with which the new sprite should be associated.
idh

A handle to an ImageDescription structure of the sprite's image.
imageDataPtr

A pointer to the sprite's image data.
matrix

A pointer to the sprite's MatrixRecord structure. If you pass NIL, an identity matrix is assigned to the sprite.
visible

Specifies whether the sprite is visible.
layer

The sprite's layer. Sprites with lower layer values appear in front of sprites with higher layer values. If you want to create a sprite that is drawn to the background graphics world, you should specify the constant kBackgroundSpriteLayerNum for the layer parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The visible parameter, the layer parameter, and the newSprite and itsSpriteWorld parameters are required. You can defer assigning image data to the sprite by passing NIL for both the idh and imageDataPtr parameters. If you choose to defer assigning image data, you must call SetSpriteProperty to assign the image description handle and image data to the sprite before the next call to SpriteWorldIdle.
Special Considerations

The caller owns the image description handle and the image data pointer; it is the caller's responsibility to dispose of them after it disposes of a sprite.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewSprite (
   Sprite                    *newSprite,
   SpriteWorld               itsSpriteWorld,
   ImageDescriptionHandle    idh,
   Ptr                       imageDataPtr,
   MatrixRecord              *matrix,
   Boolean                   visible,
   short                     layer );

/*SpriteWorldIdle

Allows a sprite world to update its invalid areas.

OSErr SpriteWorldIdle (
   SpriteWorld    theSpriteWorld,
   long           flagsIn,
   long           *flagsOut );
Parameters
theSpriteWorld

The sprite world for this operation.
flagsIn

Contains flags (see below) describing actions that may take place during the idle. For the default behavior, set this parameter to 0. See these constants: 
kOnlyDrawToSpriteWorld
flagsOut

On return, a pointer to flags (see below) describing actions that took place during the idle period. This parameter is optional; if you do not need the information, set it to NIL. See these constants: 
kSpriteWorldDidDraw
kSpriteWorldNeedsToDraw
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This is the only sprite function that causes drawing to occur; you should call it as often as is necessary. Typically, you would make changes in perspective for a number of sprites and then call SpriteWorldIdle to redraw the changed sprites.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SpriteWorldIdle (
   SpriteWorld    theSpriteWorld,
   long           flagsIn,
   long           *flagsOut );

/*GetMoviePict

Creates a QuickDraw picture from a specified movie at a specified time.

PicHandle GetMoviePict (
   Movie        theMovie,
   TimeValue    time );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The movie time from which the image is to be taken.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Discussion

This function uses only those movie tracks that are currently enabled and would therefore be used in playback. Your application may call this function even if the movie is inactive.
Special Considerations

Your application must dispose of this picture handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePict (
   Movie        theMovie,
   TimeValue    time );

/*ConvertMovieToFile

Takes a specified movie (or a single track within that movie) and converts it into a specified file and type, supporting a Save As dialog box.

OSErr ConvertMovieToFile (
   Movie                theMovie,
   Track                onlyTrack,
   FSSpec               outputFile,
   OSType               fileType,
   OSType               creator,
   ScriptCode           scriptTag,
   short                resID,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The source movie for this conversion operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
onlyTrack

The track within the source movie for this conversion operation. To specify all tracks, set the value of this parameter to 0.
outputFile

A pointer to the file specification for the destination file.
fileType

The data type of the destination file for the movie specified in the parameter theMovie.
creator

The creator value for the output file if it is a new one.
scriptTag

The script into which the movie should be converted if the output file is a new one. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
resID

A pointer to a field that is to receive the resource ID of the open movie. If you don't want to receive this information, set the resID parameter to NIL.
flags

Contains flags (see below) that control whether and how the Save As dialog box appears. See these constants: 
showUserSettingsDialog
movieToFileOnlyExport
movieFileSpecValid
userComp

If you want a particular movie export component to perform the conversion, you may pass the component or an instance of that component in this parameter. Otherwise, set it to 0 to allow the Movie Toolbox to use the appropriate component. If you pass in a component instance, it is used by ConvertMovieToFile. This allows you to communicate directly with the component before making this call to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this call.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application controls whether a Save As dialog box appears by setting the value of the flags parameter. The dialog box lets the user specify the file name and type. Supported types include standard QuickTime movies, flattened movies, single-fork flattened movies, and any format that is supported by a movie data export component. The following code snippets show how to call ConvertMovieToFile to provide a simple export capability and how to save a sound-only QuickTime movie as a WAV file.// Providing an export capability with ConvertMovieToFile
err =ConvertMovieToFile (theMovie,     / identifies movie /
                    NIL,                / all tracks /
                    NIL,                / no output file /
                    0,                  / no file type /
                    0,                  / no creator /
                    -1,                 / script /
                    NIL,                / no resource ID /
                    createMovieFileDeleteCurFile |
                        showUserSettingsDialog |
                        movieToFileOnlyExport,
                    0);                 / no specific component /
// Saving a sound-only QuickTime movie as a WAVE file
// See "Discovering QuickTime," page 257
void SndSnip_SaveSoundMovieAsWAVEFile (Movie theMovie)
{
    StandardFileReply   myReply;
    // have the user select the name and location of the new WAVE file
    StandardPutFile("\pSave sound movie file as:",
                                           "\pUntitled.wav", &myReply);
    if (!myReply.sfGood)
        return;
    // use the default progress procedure, if any
    SetMovieProgressProc(theMovie, (MovieProgressUPP)-1L, 0);
    // export the movie into a file
    ConvertMovieToFile( theMovie,               // the movie to convert
                        NIL,                   // all tracks in the movie
                        &myReply.sfFile,        // the output file
                        kQTFileTypeWave,        // the output file type
                        FOUR_CHAR_CODE('TVOD'), // the output file creator
                        smSystemScript,         // the script
                        NIL,                   // no resource ID
                                                //   to be returned
                        0L,                     // no flags
                        NIL);                  // no specific component
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr ConvertMovieToFile (
   Movie                theMovie,
   Track                onlyTrack,
   FSSpec               *outputFile,
   OSType               fileType,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp );

/*NewUserData

Creates a new user data structure.

OSErr NewUserData (
   UserData    *theUserData );
Parameters
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserData (
   UserData    *theUserData );

/*BeginFullScreen

Begins full-screen mode for a specified graphics device.

OSErr BeginFullScreen (
   Ptr          *restoreState,
   GDHandle     whichGD,
   short        *desiredWidth,
   short        *desiredHeight,
   WindowRef    *newWindow,
   RGBColor     *eraseColor,
   long         flags );
Parameters
restoreState

On exit, a pointer to a block of private state data that contains information on how to return from full-screen mode. This value is passed to EndFullScreen to enable it to return the monitor to its previous state.
whichGD

A handle to the graphics device to put into full-screen mode. Set this parameter to NIL to select the main screen.
desiredWidth

On entry, a pointer to a short integer that contains the desired width, in pixels, of the images to be displayed. On exit, that short integer is set to the actual number of pixels that can be displayed horizontally. Set this parameter to 0 to leave the width of the display unchanged.
desiredHeight

On entry, a pointer to a short integer that contains the desired height, in pixels, of the images to be displayed. On exit, that short integer is set to the actual number of pixels that can be displayed vertically. Set this parameter to 0 to leave the height of the display unchanged.
newWindow

On entry, a window-creation value. If this parameter is NIL, no window is created for you. If this parameter has any other value, BeginFullScreen creates a new window that is large enough to fill the entire screen and returns a pointer to that window in this parameter. You should not dispose of that window yourself; instead, EndFullScreen will do so.
eraseColor

The color to use when erasing the full-screen window created by BeginFullScreen if newWindow is not NIL on entry. If this parameter is NIL, BeginFullScreen uses black when initially erasing the window's content area.
flags

A set of bit flags (see below) that control certain aspects of the full-screen mode. See these constants: 
fullScreenHideCursor
fullScreenAllowEvents
fullScreenDontChangeMenuBar
fullScreenPreflightSize
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function returns, in the restoreState parameter, a pointer to a block of private state information that indicates how to return from full-screen mode. You pass that pointer as a parameter to the EndFullScreen function. The following sample code contains functions that illustrate how to play a QuickTime movie full screen. It prompts the user for a movie, opens that movie, configures it to play full screen, associates a movie controller, and lets the controller handle events. Your application would call QTFullScreen_EventLoopAction in its event loop (on the Mac OS) or when it gets idle events (on Windows).enum {
    fullScreenHideCursor            =1L << 0,
    fullScreenAllowEvents           =1L << 1,
    fullScreenDontChangeMenuBar     =1L << 2,
    fullScreenPreflightSize         =1L << 3
};
// QTFullScreen_PlayOnFullScreen
// Prompt the user for a movie and play it full screen.
OSErr QTFullScreen_PlayOnFullScreen (void)
{
    FSSpec              myFSSpec;
    Movie               myMovie =NIL;
    short               myRefNum =0;
    SFTypeList          myTypeList ={MovieFileType, 0, 0, 0};
    StandardFileReply   myReply;
    long                myFlags =fullScreenDontChangeMenuBar
                                                 | fullScreenAllowEvents;
    OSErr               myErr =noErr;
 
    StandardGetFilePreview(NIL, 1, myTypeList, &myReply);
    if (!myReply.sfGood)
        goto bail;
 
    // make an FSSpec record
    FSMakeFSSpec(myReply.sfFile.vRefNum, myReply.sfFile.parID,
                                          myReply.sfFile.name, &myFSSpec);
    myErr =OpenMovieFile(&myFSSpec, &myRefNum, fsRdPerm);
    if (myErr !=noErr)
        goto bail;
    // now fetch the first movie from the file
    myErr =NewMovieFromFile(&myMovie, myRefNum, NIL, NIL,
                                                    newMovieActive, NIL);
    if (myErr !=noErr)
        goto bail;
 
    CloseMovieFile(myRefNum);
    // set up for full-screen display
    myErr =BeginFullScreen(&gRestoreState, NIL, 0, 0,
                                       &gFullScreenWindow, NIL, myFlags);
#if TARGET_OS_WIN32
    // on Windows, set a window procedure for the new window
    // and associate a port with that window
    QTMLSetWindowWndProc(gFullScreenWindow, QTFullScreen_HandleMessages);
    CreatePortAssociation(GetPortNativeWindow(gFullScreenWindow), NIL, 0L);
#endif
    SetMovieGWorld(myMovie, (CGrafPtr)gFullScreenWindow,
                            GetGWorldDevice((CGrafPtr)gFullScreenWindow));
    SetMovieBox(myMovie, &gFullScreenWindow->
portRect);
    // create the movie controller
    gMC =NewMovieController(myMovie, &gFullScreenWindow->
portRect, 0);

Version Notes

The Macintosh human interface guidelines suggest that the menu bar must always be present, and that information must always appear in windows. However, many multimedia applications have chosen to change the look and feel of the interface based on their needs. The number of details to keep track of when doing this continues to increase. To help solve this problem, QuickTime 2.1 added functions to put a graphics device into full screen mode. The key elements to displaying full screen movies are the calls BeginFullScreen and EndFullScreen, introduced in QuickTime 2.5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr BeginFullScreen (
   Ptr          *restoreState,
   GDHandle     whichGD,
   short        *desiredWidth,
   short        *desiredHeight,
   WindowRef    *newWindow,
   RGBColor     *eraseColor,
   long         flags );

/*EndFullScreen

Ends full-screen mode for a graphics device.

OSErr EndFullScreen (
   Ptr     fullState,
   long    flags );
Parameters
fullState

The pointer to private state information returned by a previous call to BeginFullScreen.
flags

Reserved. Set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function restores the graphics device and other settings to the state specified by the private state information pointed to by the fullState parameter. The resulting state is that that was in effect prior to the immediately previous call to BeginFullScreen. The following code illustrates its use:OSErr QTFullScreen_RestoreScreen (void)
{
    OSErr       myErr =noErr;
 
#if TARGET_OS_WIN32
    DestroyPortAssociation((CGrafPtr)gFullScreenWindow);
#endif
    DisposeMovieController(gMC);
    myErr =EndFullScreen(gRestoreState, 0L);
 
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndFullScreen (
   Ptr     fullState,
   long    flags );

/*QTDismissStandardParameterDialog

Closes a standard parameter dialog box that was created using QTCreateStandardParameterDialog.

OSErr QTDismissStandardParameterDialog (
   QTParameterDialog    createdDialog );
Parameters
createdDialog

The reference to the standard parameters dialog box that is returned by QTCreateStandardParameterDialog.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function disposes of all memory associated with the dialog box.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTDismissStandardParameterDialog (
   QTParameterDialog    createdDialog );

/*QTIsStandardParameterDialogEvent

Determines if a Macintosh event is processed by a standard parameter dialog box created by QTCreateStandardParameterDialog.

OSErr QTIsStandardParameterDialogEvent (
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog );
Parameters
pEvent

The Macintosh event.
createdDialog

The reference to the standard parameters dialog box that is returned by QTCreateStandardParameterDialog.
Return Value

See below.
Discussion

After you create a standard parameter dialog box, pass every Macintosh event through this function to determine if your application should handle the event. Once the dialog box has been confirmed or cancelled by the user, you should no longer call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTIsStandardParameterDialogEvent (
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog );

/*QTStandardParameterDialogDoAction

Lets you change some of the default behaviors of the standard parameter dialog box.

OSErr QTStandardParameterDialogDoAction (
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params );
Parameters
createdDialog

The reference to the dialog box created by calling QTCreateStandardParameterDialog.
action

Determines which of the actions (see below) supported by this function will be performed. See these constants: 
pdActionSetAppleMenu
pdActionSetEditMenu
pdActionSetPreviewPicture
pdActionSetDialogTitle
pdActionGetSubPanelMenu
pdActionActivateSubPanel
pdActionConductStopAlert
params

Optional parameters to the action. The type passed in this parameter depends on the value of the action parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function allows you to change some of the default behaviors of a standard parameter dialog box you create using the QTCreateStandardParameterDialog function. To choose which of the available customizations to perform, pass an action selector value in the action parameter and, optionally, a single parameter in params.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTStandardParameterDialogDoAction (
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params );

/*QTCreateStandardParameterDialog

Creates a dialog box that allows the user to choose an effect from the list of effects passed to the function.

OSErr QTCreateStandardParameterDialog (
   QTAtomContainer             effectList,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   QTParameterDialog           *createdDialog );
Parameters
effectList

A list of the effects that the user can choose from. In most cases you should call QTGetEffectsList to generate this list. If you pass NIL in this parameter, the function calls QTGetEffectsList to retrieve the list of all currently installed effects; this list is then presented to the user.
parameters

An effect description containing the default parameter values for the effect. If the effect named in the parameter description is in effectlist, that effect is displayed when the dialog is first shown and its parameter values are set from the parameter description. Pass in an empty atom container to have the dialog box display the first effect in the list, set to its default parameters. On return, this atom container holds an effect description for the effect selected by the user, including the parameter settings. This effect description can then be added to the media of an effect track. You will need to add source atoms to this container for effects that require sources.
dialogOptions

Options (see below) that control the behavior of the dialog. See these constants: 
pdOptionsCollectOneValue
pdOptionsAllowOptionalInterpolations
createdDialog

Returns a reference to the dialog box that is created by this function. You should pass this value only to QTIsStandardParameterDialogEvent and QTDismissStandardParameterDialog. 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates and displays a standard parameter dialog box that allows the user to choose an effect from the list in the effectList parameter. The dialog box also allows the user to choose values for the parameters of the effect, to preview the effects as they choose and customize them, and to get more information about each effect. Your application must call the Mac OS function WaitNextEvent and QTIsStandardParameterDialogEvent to allow the user to interact with the dialog box that is shown. Note that the dialog box will remain hidden until the first event is processed by QTIsStandardParameterDialogEvent. At this point, the dialog box will be displayed. You can modify the default behavior of the dialog box that is created by calling QTStandardParameterDialogDoAction.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCreateStandardParameterDialog (
   QTAtomContainer             effectList,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   QTParameterDialog           *createdDialog );

/*QTGetEffectsList

Returns a QT atom container holding a list of the currently installed effects components.

OSErr QTGetEffectsList (
   QTAtomContainer        *returnedList,
   long                   minSources,
   long                   maxSources,
   QTEffectListOptions    getOptions );
Parameters
returnedList

If the function returns noErr, this parameter contains a newly created QT atom container holding a list of their currently installed effects. Any data stored in the parameter on entry is overwritten by the list of effects. It is the responsibility of the calling application to dispose of the storage by calling QTDisposeAtomContainer once the list is no longer required.
minSources

The minimum number of sources that an effect must have to be added to the list. Pass -1 as this parameter to specify no minimum.
maxSources

The maximum number of sources that an effect can have to be added to the list. Pass -1 as this parameter to specify no maximum. The minSources and maxSources parameters allow you to restrict which effects are returned in the list, by specifying the minimum and maximum number of sources that qualifying effects can have.
getOptions

Options (see below) that control which effects are added to the list. If you pass 0, the function includes every effect, except the "none" effect and any prohibited by the values of minSources and maxSources. See these constants: 
elOptionsIncludeNoneInList
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The returned list contains two atoms for each effect component. The first atom, of type kEffectNameAtom, contains the name of the effect. The second atom, of type kEffectTypeAtom, contains the type of the effect, which is the sub-type of the effect component. This list is sorted alphabetically on the names of the effects. You can constrain the list to certain types of effects, such as those that take two sources. Use this function to obtain a list of effects that you can pass to QTCreateStandardParameterDialog.
Special Considerations

This function can take a fairly long time to execute, as it searches the system for installed effects components. You will normally want to call this function once when your application starts, or after a pair of suspend and resume events.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectsList (
   QTAtomContainer        *returnedList,
   long                   minSources,
   long                   maxSources,
   QTEffectListOptions    getOptions );

/*PrePrerollMovie

Sets up any necessary network connections to receive streaming content.

OSErr PrePrerollMovie (
   Movie                         m,
   TimeValue                     time,
   Fixed                         rate,
   MoviePrePrerollCompleteUPP    proc,
   void                          *refcon );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
proc

The MoviePrePrerollCompleteProc callback you want called when pre-prerolling is complete. If a completion proc is specified, PrePrerollMovie operates asynchronously. You must call MoviesTask periodically during asynchronous operation. If no completion proc is specified, PrePrerollMovie operates synchronously.
refcon

A reference constant that is passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Before a movie is played, it is normally prerolled. During preroll, the Movie Toolbox tells the appropriate media handlers to load the movie data, allocate sound channels, start up image-decompression sequences, and so on. Before a movie that contains streaming content is prerolled, it must be pre-prerolled. This sets up any necessary network connections between the client and the server. If a movie contains streaming content (one or more 'strm' tracks), you must call this function before calling PrerollMovie. If the movie does not contain streaming content, calling this function has no effect. If your application calls PrerollMovie, it should always call this function first. If you play movies using a movie controller, you don't need to preroll or pre-preroll the movie explicitly; it is done for you automatically. If a completion proc is specified in the proc parameter, this function operates asynchronously; it returns almost immediately and calls the completion proc when pre-prerolling is complete.
Special Considerations

You must call MoviesTask periodically to grant time for pre-prerolling during asynchronous operation. If no completion proc is specified, this function operates synchronously; the function will not return until pre-prerolling is complete. This can take a long time, particularly if a dial-up network connection must be established.
Version Notes

Introduced in QuickTime 4. Beginning with QuickTime 4, your application should call this function any time it calls PrerollMovie.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrePrerollMovie (
   Movie                         m,
   TimeValue                     time,
   Fixed                         rate,
   MoviePrePrerollCompleteUPP    proc,
   void                          *refcon );

/*NewMoviePrePrerollCompleteUPP

Allocates a Universal Procedure Pointer for the MoviePrePrerollCompleteProc callback.

MoviePrePrerollCompleteUPP NewMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMoviePrePrerollCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MoviePrePrerollCompleteUPP NewMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteProcPtr    userRoutine );

/*SetTrackVolume

Sets a track's current volume.

void SetTrackVolume (
   Track    theTrack,
   short    volume );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
volume

The current volume setting of the track represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You can use constants (see below) for full volume and no volume. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackVolume (
   Track    theTrack,
   short    volume );

/*ConvertFileToMovieFile

Converts a file to a movie file and supports a user settings dialog box for import operations.

OSErr ConvertFileToMovieFile (
   const FSSpec         *inputFile,
   const FSSpec         *outputFile,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp,
   MovieProgressUPP     proc,
   long                 refCon );
Parameters
inputFile

A pointer to the file system specification for the file to be converted into a movie file.
outputFile

A pointer to the file specification for the destination movie file.
creator

The creator value for the file if it is a new one.
scriptTag

The script in which the movie file should be converted. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
resID

A pointer to a field that is to receive the resource ID of the file to be converted. If you don't want to receive the resource ID, set this parameter to NIL.
flags

Contains flags (see below) that control movie file conversion and determine whether or not the user settings dialog box appears. See these constants: 
createMovieFileDeleteCurFile
movieToFileOnlyExport
movieFileSpecValid
showUserSettingsDialog
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, it will be used by ConvertFileToMovieFile. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
proc

Points to your progress callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function. See MovieProgressProc for the interface your progress callback must support.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify an input file and convert it to a movie file. Because some conversions may take a nontrivial amount of time, you can pass a standard movie progress function in the proc and refCon parameters.
Special Considerations

Once you are finished working with a movie, you should release the resources used by the movie by calling DisposeMovie. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr ConvertFileToMovieFile (
   const FSSpec         *inputFile,
   const FSSpec         *outputFile,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp,
   MovieProgressUPP     proc,
   long                 refCon );

/*SetTrackMatte

Sets a track's matte.

void SetTrackMatte (
   Track           theTrack,
   PixMapHandle    theMatte );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
theMatte

A handle to the matte. The Movie Toolbox makes a copy of the matte, including its ColorTable structure and pixels. Consequently, your application must dispose of the matte when you are done with it. Set this parameter to NIL to remove the track's matte.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This matte defines which of the track's pixels are displayed in a movie. You must specify the matte in a PixMap structure. The Movie Toolbox displays the weighted average of the track and its destination based on the corresponding pixel in the matte.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackMatte (
   Track           theTrack,
   PixMapHandle    theMatte );

/*GetTrackMatte

Retrieves a copy of a track's matte.

PixMapHandle GetTrackMatte (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to a PixMap structure that represents the specified track's matte. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

The matte defines which of the track's pixels are displayed in a movie, and it is valid for the entire duration of the movie.
Special Considerations

You should use DisposeMatte to dispose of the matte when you are finished with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
PixMapHandle GetTrackMatte (
   Track    theTrack );

/*DisposeMatte

Disposes of a matte obtained from the GetTrackMatte function.

void DisposeMatte (
   PixMapHandle    theMatte );
Parameters
theMatte

Handle to the matte to be disposed. Your application obtains this handle from GetTrackMatte.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMatte (
   PixMapHandle    theMatte );

/*GetMovieDisplayBoundsRgn

Determines a movie's display boundary region.

RgnHandle GetMovieDisplayBoundsRgn (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a MacRegion structure that the function allocates. If the movie does not have a spatial representation at the current time, the function returns an empty region. If the function could not satisfy the request, it sets the returned handle to NIL.
Discussion

The display boundary region encloses all of a movie's enabled tracks after the track matrix, track clip, movie matrix, and movie clip have been applied to them. This region is in the display coordinate system of the movie's graphics world. The Movie Toolbox derives the display boundary region only from enabled tracks, and only from those tracks that are used in the current display mode (that is, movie, poster, or preview). The display boundary region is valid for the current movie time.
Special Considerations

Your application must dispose of the returned handle when it is done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetMovieDisplayBoundsRgn (
   Movie    theMovie );

/*GetTrackPict

Creates a QuickDraw picture from a specified track at a specified time.

PicHandle GetTrackPict (
   Track        theTrack,
   TimeValue    time );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The time at which the image is taken.
Return Value

A handle to the specified picture. If the function could not create the picture, the returned handle is set to NIL.
Special Considerations

Your application must dispose of the returned picture handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetTrackPict (
   Track        theTrack,
   TimeValue    time );

/*GetMoviePosterTime

Returns the poster's time in a movie.

TimeValue GetMoviePosterTime (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The time in the movie from which its poster is taken.
Discussion

Since a movie poster has no duration, it is defined by a point in time within the movie. The time value returned by GetMoviePosterTime is in the time coordinate system of the movie and represents the starting time for the movie frame that contains the poster image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMoviePosterTime (
   Movie    theMovie );

/*NewTrackTransferUPP

Allocates a Universal Procedure Pointer for the TrackTransferProc callback.

TrackTransferUPP NewTrackTransferUPP (
   TrackTransferProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewTrackTransferProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TrackTransferUPP NewTrackTransferUPP (
   TrackTransferProcPtr    userRoutine );

/*SetTrackGWorld

Forces a track to draw into a particular graphics world, which may be different from that of the movie.

void SetTrackGWorld (
   Track               theTrack,
   CGrafPtr            port,
   GDHandle            gdh,
   TrackTransferUPP    proc,
   long                refCon );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
port

Points to the graphics port structure or graphics world to which to draw the track. Set this parameter to NIL to use the movie's graphics port.
gdh

A handle to the movie's graphics device structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
proc

A pointer to your TrackTransferProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

A value to pass to your TrackTransferProc callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

After this function draws a track, it calls your transfer callback to copy the track to the actual movie graphics world. When your transfer callback is called, the current graphics world is set to the correct destination. You can also install a transfer callback and set the graphics world to NIL. In this case, the function calls your callback only as a notification that the track has been drawn; no transfer needs to take place.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackGWorld (
   Track               theTrack,
   CGrafPtr            port,
   GDHandle            gdh,
   TrackTransferUPP    proc,
   long                refCon );

/*QTRemoveChildren

Removes all the children of an atom from the specified atom container.

OSErr QTRemoveChildren (
   QTAtomContainer    container,
   QTAtom             atom );
Parameters
container

The atom container for this operation. The atom container must not be locked.
atom

The atom whose children should be removed. To remove all the atoms in the atom container, pass a value of kParentAtomIsContainer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTRemoveChildren (
   QTAtomContainer    container,
   QTAtom             atom );

/*SetMediaPropertyAtom

Sets the property atom container of a media handler.

OSErr SetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    propertyAtom );
Parameters
theMedia

A reference to the media handler for this operation.
propertyAtom

Specifies a QT atom container that contains the property atoms for the track associated with the media handler.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to set properties for the track associated with the specified media handler. The contents of the QT atom container are defined by the media handler. Here is some sample code that uses this function to define the background color for a sprite track:// SetMediaPropertyAtom coding example
// See "Discovering QuickTime," page 360
if (bWithBackgroundPicture) {
    QTAtomContainer         qtacTrackProperties;
    RGBColor                rgbcBackColor;
    rgbcBackColor.red =EndianU16_NtoB(0x8000);
    rgbcBackColor.green =EndianU16_NtoB(0);
    rgbcBackColor.blue =EndianU16_NtoB0(xffff);
    // create a new atom container for sprite track properties
    QTNewAtomContainer(&qtacTrackProperties);
    // add an atom for the background color property
    QTInsertChild(qtacTrackProperties, 0,
        kSpriteTrackPropertyBackgroundColor, 1, 1, sizeof(RGBColor),
        &rgbcBackColor, NIL);
    // set the sprite track's properties
    nErr =SetMediaPropertyAtom(media, qtacTrackProperties);
    QTDisposeAtomContainer(qtacTrackProperties);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    propertyAtom );

/*SpriteMediaHitTestAllSprites

Determines whether any sprites are at a specified location.

ComponentResult SpriteMediaHitTestAllSprites (
   MediaHandler    mh,
   long            flags,
   Point           loc,
   QTAtomID        *spriteHitID );
Parameters
mh

The sprite media handler for this operation.
flags

Specifies flags (see below) that control the hit testing operation. See these constants: 
spriteHitTestBounds
spriteHitTestImage
spriteHitTestInvisibleSprites
spriteHitTestIsClick
spriteHitTestLocInDisplayCoordinates
loc

A point in the coordinate system of the sprite track's movie to test for the existence of a sprite.
spriteHitID

A pointer to a short integer. On return, this integer contains the ID of the frontmost sprite at the location specified by loc. If no sprite exists at the location, the function sets the value of this parameter to 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to determine whether any sprites exist at a specified location in the coordinate system of a sprite track's movie. You can pass flags to this function to control the hit testing operation more precisely. For example, you may want the hit test operation to detect a sprite whose bounding box contains the specified location.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaHitTestAllSprites (
   MediaHandler    mh,
   long            flags,
   Point           loc,
   QTAtomID        *spriteHitID );

/*SpriteMediaGetSpriteProperty

Retrieves the value of the specified sprite or sprite track property.

ComponentResult SpriteMediaGetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );
Parameters
mh

The sprite media handler for this operation.
spriteID

The ID of the sprite for this operation. Pass 'Trck' to return the properties of a whole sprite track.
propertyType

A constant (see below) that specifies the property whose value should be retrieved. See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpriteTrackPropertyAllSpritesHitTestingMode
kSpriteTrackPropertyPreferredDepthInterpretationMode
propertyValue

On return, a pointer to the value of the property; the data type of that value depends on the property.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Function introduced in QuickTime 3 or earlier. The kSpriteTrackPropertyAllSpritesHitTestingMode and kSpriteTrackPropertyPreferredDepthInterpretationMode constants were added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaGetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );

/*SpriteMediaSetSpriteProperty

Sets the specified property of a sprite or sprite track.

ComponentResult SpriteMediaSetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );
Parameters
mh

The sprite media handler for this operation.
spriteID

The ID of the sprite for this operation. Pass 'Trck' to set the properties of a whole sprite track.
propertyType

A constant (see below) that specifies the property whose value should be set. See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpriteTrackPropertyAllSpritesHitTestingMode
kSpriteTrackPropertyPreferredDepthInterpretationMode
propertyValue

A pointer to the new value of the selected property. The type of data you pass for this parameter depends on the property type.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Function introduced in QuickTime 3 or earlier. The kSpriteTrackPropertyAllSpritesHitTestingMode and kSpriteTrackPropertyPreferredDepthInterpretationMode constants were added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaSetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );

/*SetMovieVolume

Sets a movie's current volume but does not store the setting in the movie.

void SetMovieVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The current volume setting of the movie represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You can use the constants shown below. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The setting made by this function is not persistent. To store a volume setting in the movie, call SetMoviePreferredVolume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieVolume (
   Movie    theMovie,
   short    volume );

/*QTSetTrackProperty

Sets the value of a specific track property.

OSErr QTSetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstQTPropertyValuePtr inPropValueAddress );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the property value.
inPropValueAddress

A pointer to the the property value.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine sets the value of a specific track property.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTSetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstQTPropertyValuePtr inPropValueAddress );

/*QTGetTrackPropertyInfo

Returns information about the properties of a track.

OSErr QTGetTrackPropertyInfo (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTPropertyValueType *outPropType,
   ByteCount *outPropValueSize,
   UInt32 *outPropertyFlags );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. 
outPropertyFlags

A pointer to memory allocated to hold property flags on return. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns information about the properties of a track.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetTrackPropertyInfo (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTPropertyValueType *outPropType,
   ByteCount *outPropValueSize,
   UInt32 *outPropertyFlags );

/*QTGetTrackProperty

Returns the value of a specific track property.

OSErr QTGetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   QTPropertyValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns the value of a specific track property. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   QTPropertyValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );

/*QTRemoveTrackPropertyListener

Removes a track property monitoring callback

OSErr QTRemoveTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTTrackPropertyListenerProc callback. 
inUserData

User data to be passed to the callback. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine removes a track property monitoring callback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTRemoveTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );

/*QTRemoveMoviePropertyListener

Removes a movie property monitoring callback.

OSErr QTRemoveMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTMoviePropertyListenerProc callback.
inUserData

User data to be passed to the callback.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTRemoveMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );

/*QTAddTrackPropertyListener

Installs a callback to monitor a track property.

OSErr QTAddTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTTrackPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine installs a callback to monitor a track property.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTAddTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );

/*QTAddMoviePropertyListener

Installs a callback to monitor a movie property.

OSErr QTAddMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTMoviePropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTAddMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );

/*QTSetMovieProperty

Sets the value of a specific movie property.

OSErr QTSetMovieProperty (
   Movie                      inMovie,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the property value.
inPropValueAddress

A pointer to the the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTSetMovieProperty (
   Movie                      inMovie,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );

/*GetTrackEnabled

Determines whether a track is currently enabled.

Boolean GetTrackEnabled (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

TRUE if the specified track is currently enabled, FALSE otherwise.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean GetTrackEnabled (
   Track    theTrack );

/*FlattenMovieDataToDataRef

Performs a flattening operation to a movie at a storage location.

Movie FlattenMovieDataToDataRef (
   Movie         theMovie,
   long          movieFlattenFlags,
   Handle        dataRef,
   OSType        dataRefType,
   OSType        creator,
   ScriptCode    scriptTag,
   long          createMovieFileFlags );
Parameters
theMovie

The movie passed into this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Constants (see below) that control the process of adding movie data to the new container. QuickTime will read these flags later when it adds movies to the storage. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenForceMovieResourceBeforeMovieData
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets the returned identifier to NIL.
Discussion

This function performs a flattening operation to the destination data reference.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
Movie FlattenMovieDataToDataRef (
   Movie         theMovie,
   long          movieFlattenFlags,
   Handle        dataRef,
   OSType        dataRefType,
   OSType        creator,
   ScriptCode    scriptTag,
   long          createMovieFileFlags );

/*QTMovieNeedsTimeTable

Returns whether a movie is being progressively downloaded.

OSErr QTMovieNeedsTimeTable (
   Movie      theMovie,
   Boolean    *needsTimeTable );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
needsTimeTable

If TRUE, the movie is being progressively downloaded. If an error occurs, this parameter is set to FALSE.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

A movie can be progressively downloaded when its data is received over a network connection or other slow data channel. Progressive downloads are not necessary when the data for the movie is on a local disk. The Movie Toolbox creates a time table for a movie when either this function or GetMaxLoadedTimeInMovie is called for the movie, but the time table is used only by the toolbox and is not accessible to applications. The toolbox disposes of the time table when the download is complete.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTMovieNeedsTimeTable (
   Movie      theMovie,
   Boolean    *needsTimeTable );

/*UpdateMovieInStorage

Updates a movie at a storage location.

OSErr UpdateMovieInStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function, which is similar to OpenMovieStorage, replaces the content of the movie in the storage associated with the specified data handler.
Version Notes

Introduced in QuickTime 6. Supersedes UpdateMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr UpdateMovieInStorage (
   Movie          theMovie,
   DataHandler    dh );

/*OpenMovieStorage

Opens a data handler for movie storage.

OSErr OpenMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   long           flags,
   DataHandler    *outDataHandler );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
flags

A constant (see below) that determines the reading and writing capabilities of the data handler. See these constants: 
kDataHCanRead
kDataHCanWrite
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie file. Your application uses this value when calling other Movie Toolbox functions that work with movie files. If you pass NIL, the Movie Toolbox creates the movie storage but does not open it.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is rarely used. It is an alternative to OpenMovieFile.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr OpenMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   long           flags,
   DataHandler    *outDataHandler );

/*MCGetControllerBoundsRgn

Returns the actual region occupied by the controller and its movie.

RgnHandle MCGetControllerBoundsRgn (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A handle to a MacRegion structure that reflects the size, shape, and location of the controller. Your application must dispose of this structure.
Discussion

As with MCGetControllerBoundsRect, this function returns a region even if the controller is hidden. Some movie controllers may not be rectangular in shape. If the movie is not attached to its controller, the boundary region encloses only the control portion of the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
RgnHandle MCGetControllerBoundsRgn (
   MovieController    mc );

/*MCInvalidate

Invalidates a region of a movie controller's display.

ComponentResult MCInvalidate (
   MovieController    mc,
   WindowRef          w,
   RgnHandle          invalidRgn );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
invalidRgn

A handle to a MacRegion structure that defines a region to invalidate.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCInvalidate (
   MovieController    mc,
   WindowRef          w,
   RgnHandle          invalidRgn );

/*MCMovieChanged

Informs a movie controller component that your application has used the Movie Toolbox to change the characteristics of its associated movie.

ComponentResult MCMovieChanged (
   MovieController    mc,
   Movie              m );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
m

The movie that has been changed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCMovieChanged (
   MovieController    mc,
   Movie              m );

/*GetMovieLoadState

Returns a value that indicates the state of a movie's loading process.

long GetMovieLoadState (
   Movie    theMovie );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A constant (see below) that indicates the movie's loading status.
Discussion

This function lets your code perform relative comparisons against movie loading milestones to determine if certain operations make sense. Its return values are ordered so that they conform to this rule:kMovieLoadStateError
< kMovieLoadStateLoading
< kMovieLoadStatePlayable
< kMovieLoadStateComplete

Special Considerations

Because of the "voting system" involved, an application checking for the load state should throttle its calling of the routine. Not calling GetMovieLoadState more often than every quarter of a second is a good place to start.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMovieLoadState (
   Movie    theMovie );

/*SetMediaInputMap

Replaces the media's existing input map with a given input map.

OSErr SetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    inputMap );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
inputMap

The media input map for this operation. If the input map is set to NIL, the media's input map is reset to an empty input map.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify the media you want to set so you can modify or empty its input map. It makes a copy of the input map passed to it. The following sample code illustrates how to update an input map, using this function and GetMediaInputMap:// SetMediaInputMap coding example
QTAtomContainer inputMap;
QTAtom inputAtom;
OSType inputType;
Media aVideoMedia =GetTrackMedia(aVideoTrack);
GetMediaInputMap (aVideoMedia, &inputMap);
QTInsertChild(inputMap, kParentAtomIsContainer, kTrackModifierInput,
        addedIndex, 0,0, nil, &inputAtom);
inputType =kTrackModifierTypeClip;
QTInsertChild (inputMap, inputAtom, kTrackModifierType, 1, 0,
        sizeof(inputType), &inputType, nil);
SetMediaInputMap(aVideoMedia, inputMap);
QTDisposeAtomContainer(inputMap);

Special Considerations

Use QTNewAtomContainer to create an empty input map.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    inputMap );

/*AddTrackReference

Adds a new track reference to a track.

OSErr AddTrackReference (
   Track     theTrack,
   Track     refTrack,
   OSType    refType,
   long      *addedIndex );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refTrack

The track to be identified in the track reference.
refType

The type of reference.
addedIndex

A pointer to a long integer. The toolbox returns the index value assigned to the new track reference. If you don't want this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how AddTrackReference can be used to add a modifier track reference to a sprite track.// AddTrackReference coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddTrackReference (
   Track     theTrack,
   Track     refTrack,
   OSType    refType,
   long      *addedIndex );

/*DisposeCallBack

Disposes of a callback event.

void DisposeCallBack (
   QTCallBack    cb );
Parameters
cb

The callback event for the operation. You obtain this value from NewCallBack.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You should call this function when you are done with each callback event.
Special Considerations

Don't call this function at interrupt time.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeCallBack (
   QTCallBack    cb );

/*SetMovieMasterTimeBase

Assigns a master time base to a movie.

void SetMovieMasterTimeBase (
   Movie               theMovie,
   TimeBase            tb,
   const TimeRecord    *slaveZero );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
tb

The master time base to be assigned to this movie. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the movie. This parameter allows you to set an offset between the movie and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieMasterTimeBase (
   Movie               theMovie,
   TimeBase            tb,
   const TimeRecord    *slaveZero );

/*SetTimeBaseValue

Sets the current time of a time base.

void SetTimeBaseValue (
   TimeBase     tb,
   TimeValue    t,
   TimeScale    s );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
t

The new time value.
s

The time scale of the new time value.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseValue (
   TimeBase     tb,
   TimeValue    t,
   TimeScale    s );

/*CallMeWhen

Schedules a callback event.

OSErr CallMeWhen (
   QTCallBack       cb,
   QTCallBackUPP    callBackProc,
   long             refCon,
   long             param1,
   long             param2,
   long             param3 );
Parameters
cb

The callback event for the operation. You obtain this identifier from NewCallBack.
callBackProc

Points to your callback function, described in QTCallBackProc.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
param1

Contains scheduling information. The Movie Toolbox interprets this parameter based on the value of the cbType parameter to NewCallBack. If cbType is set to callBackAtTime, the param1 parameter contains flags (see below) indicating when to invoke your callback function for this callback event. If the cbType parameter is set to callBackAtRate, param1 contains flags (see below) indicating when to invoke your callback function for this event. Be sure to set unused flags to 0.
param2

Contains scheduling information. The Movie Toolbox interprets this parameter based on the value of the cbType parameter to NewCallBack. If cbType is set to callBackAtTime, the param2 parameter contains the time value at which your callback function is to be invoked for this event. The param1 parameter contains flags affecting when the Movie Toolbox calls your function. If cbType is set to callBackAtRate, the param2 parameter contains the rate value at which your callback function is to be invoked for this event. The param1 parameter contains flags affecting when the Movie Toolbox calls your function.
param3

The time scale in which to interpret the time value that is stored in param3 if cbType is set to callBackAtTime.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function from your callback function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CallMeWhen (
   QTCallBack       cb,
   QTCallBackUPP    callBackProc,
   long             refCon,
   long             param1,
   long             param2,
   long             param3 );

/*NewCallBack

Creates a new callback event.

QTCallBack NewCallBack (
   TimeBase    tb,
   short       cbType );
Parameters
tb

The callback event's time base. You obtain this identifier from NewTimeBase.
cbType

Constants (see below) that specify when the callback event is to be invoked. The value of this field governs how the Movie Toolbox interprets the data supplied in the param1, param2, and param3 parameters to the CallMeWhen function. In addition, if the high-order bit of the cbType parameter is set to 1 (this bit is defined by the callBackAtInterrupt flag), the event can be invoked at interrupt time. See these constants: 
callBackAtTime
callBackAtRate
callBackAtTimeJump
callBackAtExtremes
callBackAtInterrupt
Return Value

A pointer to a CallBackRecord structure containing the new callback event.
Special Considerations

The callback event created is not active until you schedule it by calling the CallMeWhen function. You must not call this function at interrupt time.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTCallBack NewCallBack (
   TimeBase    tb,
   short       cbType );

/*NewQTCallBackUPP

Allocates a Universal Procedure Pointer for the QTCallBackProc callback.

QTCallBackUPP NewQTCallBackUPP (
   QTCallBackProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTCallBackProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
#define NewQTCallBackProc(userRoutine)                      NewQTCallBackUPP(userRoutine)
QTCallBackUPP NewQTCallBackUPP (
   QTCallBackProcPtr    userRoutine );

/*HIMovieViewSetMovie

Sets the view's current movie.

OSStatus HIMovieViewSetMovie (
   HIViewRef inView,
   Movie inMovie );
Parameters
inView

The HIMovieView.
inMovie

The new movie to display.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine sets the view's current movie.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
OSStatus HIMovieViewSetMovie (
   HIViewRef inView,
   Movie inMovie );

/*HIMovieViewChangeAttributes

Changes the views attributes.

OSStatus HIMovieViewChangeAttributes (
   HIViewRef inView,
   OptionBits inAttributesToSet,
   OptionBits inAttributesToClear );
Parameters
inView

The HIMovieView.
inAttributesToSet

Attributes to set.
inAttributesToClear

Attributes to clear.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Setting an attribute takes precedence over clearing the attribute.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
OSStatus HIMovieViewChangeAttributes (
   HIViewRef inView,
   OptionBits inAttributesToSet,
   OptionBits inAttributesToClear );

/*HIMovieViewGetControllerBarSize

Returns the size of the visible movie controller bar.

HISize HIMovieViewGetControllerBarSize (
   HIViewRef inView );
Parameters
inView

The HIMovieView.
Return Value

Undocumented.
Discussion

The size of the visible movie controller bar is returned. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
HISize HIMovieViewGetControllerBarSize (
   HIViewRef inView );

/*AddMediaSampleReference

Works with samples that have already been added to a movie data file.

OSErr AddMediaSampleReference (
   Media                      theMedia,
   long                       dataOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOffset

The offset into the movie data file. This parameter is used differently by each data handler. For example, for the standard HFS data handler, this parameter specifies the offset into the file. This parameter contains either data you add yourself or the data offset returned by GetMediaSampleReference.
size

The number of bytes of sample data to be identified by the reference. This parameter indicates the total number of bytes in the sample data, not the number of bytes per sample. Use numberOfSamples to indicate the number of samples that are contained in the reference.
durationPerSample

The duration of each sample in the reference. You must specify this parameter in the media's time scale. For example, if you are referring to sound that was sampled at 22 kHz in a media that contains a sound track with the same time scale, to add a reference to a single sample you would set durationPerSample to 1. Similarly, if you are referring to video that was recorded at 10 frames per second in a video media that has a time scale of 60, you would set this parameter to 6 to add a reference to a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a sound description structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the reference. For details, see AddMediaSample. If the media does not require a SampleDescription structure, set this parameter to NIL.
sampleFlags

Contains flags (see below) that control the operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the reference to the media, the AddMediaSampleReference function returns the time where the reference was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function does not add sample data to the file or device that contains a media. Rather, it defines references to sample data that you previously added to a movie data file. Instead of actually writing out samples to disk, this function writes out references to existing samples, which you specify in dataOffset and the size parameter. As with AddMediaSample, your application specifies the media for the operation. Note that one reference may refer to more than one sample; all the samples described by a reference must be the same size. This function does not update the movie data file as part of the add operation. Therefore, your application does not have to call BeginMediaEdits before calling AddMediaSampleReference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddMediaSampleReference (
   Media                      theMedia,
   long                       dataOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );

/*SetMovieSelection

Sets a movie's current selection.

void SetMovieSelection (
   Movie        theMovie,
   TimeValue    selectionTime,
   TimeValue    selectionDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
selectionTime

A time value specifying the starting point of the current selection.
selectionDuration

A time value that specifies the duration of the current selection.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieSelection (
   Movie        theMovie,
   TimeValue    selectionTime,
   TimeValue    selectionDuration );

/*AddMovieSelection

Adds one or more tracks to a movie.

void AddMovieSelection (
   Movie    theMovie,
   Movie    src );
Parameters
theMovie

The destination movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
src

The source movie for this operation. AddMovieSelection adds the tracks from this movie to the destination movie. The function adds these tracks at the time specified by the current selection in the destination movie.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function scales the source movie so that it fits into the destination selection. If the current selection in the destination movie has a 0 duration, the Movie Toolbox adds the segment at the beginning of the current selection. The entire source movie is used regardless of the selection in the source movie. The Movie Toolbox removes any empty tracks from the destination movie after the add operation. If you have assigned a progress function to the destination movie, the Movie Toolbox calls that progress function during long add operations. Following is an example of using this function:// AddMovieSelection coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Special Considerations

Some Movie Toolbox functions can take a long time to execute. For example, if you call FlattenMovie and specify a large movie, the Movie Toolbox must read and write all the sample data for the movie. During such operations you may wish to display some kind of progress indicator to the user. A progress function is an application-defined function that you can create to track the progress of time-consuming activities and keep the user informed. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void AddMovieSelection (
   Movie    theMovie,
   Movie    src );

/*ScaleMovieSegment

Changes the duration of a segment of a movie.

OSErr ScaleMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    oldDuration,
   TimeValue    newDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
startTime

The start of the segment. The oldDuration parameter specifies the segment's duration. This time value must be expressed in the movie's time scale.
oldDuration

The original duration of the segment in the source movie. This time value must be expressed in the movie's time scale.
newDuration

The new duration of the segment. This time value must be expressed in the movie's time scale. The function alters the segment to accommodate the new duration.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox scales the segment to accommodate the new duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr ScaleMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    oldDuration,
   TimeValue    newDuration );

/*GetDataHandler

Retrieves the best data handler component to use with a given data reference.

Component GetDataHandler (
   Handle    dataRef,
   OSType    dataHandlerSubType,
   long      flags );
Parameters
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by the dataHandlerSubType parameter.
dataHandlerSubType

Identifies both the type of data reference and, by implication, the component subtype value assigned to the data handler components that operate on data references of that type.
flags

Contains flags (see below) that indicate the way in which you intend to use the data handler component. Note that not all data handlers necessarily support all services; for example, some data handler components may not support streaming writes. Set the appropriate flags to 1. See these constants: 
kDataHCanRead
kDataHCanWrite
kDataHCanStreamingWrite
Return Value

The best data handler component conforming to the parameters passed in.
Discussion

Once you have used this function to get information about the best data handler component for your data reference, you can open and use the component using Component Manager functions. If the function returns a value of NIL, the toolbox was unable to find an appropriate data handler component. For more information about the error that caused a return of NIL, call GetMoviesError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Component GetDataHandler (
   Handle    dataRef,
   OSType    dataHandlerSubType,
   long      flags );

/*GetMediaSampleReference

Obtains reference information about samples that are stored in a movie data file.

OSErr GetMediaSampleReference (
   Media                      theMedia,
   long                       *dataOffset,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOffset

A pointer to a long integer. GetMediaSampleReference updates the field referred to by this parameter with the offset to the sample data. This parameter is used differently by each media handler. For example, the hierarchical file system (HFS) media handler returns an offset into the file that contains the media data.
size

A pointer to a long integer. GetMediaSampleReference updates the field referred to by the size parameter with the number of bytes of sample data referred to by the reference. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample reference to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. GetMediaSampleReference updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. GetMediaSampleReference returns the structure corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want the SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. GetMediaSampleReference returns an index value to the SampleDescription structure that corresponds to the returned sample data. To retrieve the media sample description, pass this index in the descH parameter of GetMediaSampleDescription. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return a reference that refers to more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. GetMediaSampleReference updates the field referred to by this parameter with the number of samples referred to by the returned reference. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSampleReference returns flags (see below) that describe the samples referred to by the returned reference. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSampleReference (
   Media                      theMedia,
   long                       *dataOffset,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );

/*AddMediaDataRef

Adds a data reference to a media.

OSErr AddMediaDataRef (
   Media     theMedia,
   short     *index,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

A pointer to a short integer. The Movie Toolbox returns the index value that is assigned to the new data reference. Your application can use this index to identify the reference to other Movie Toolbox functions, such as GetMediaDataRef. If the Movie Toolbox cannot add the data reference to the media, it sets the returned index value to 0.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter.
dataRefType

The type of data reference. If the data reference is an alias, you must set this parameter to rAliasType.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddMediaDataRef (
   Media     theMedia,
   short     *index,
   Handle    dataRef,
   OSType    dataRefType );

/*NewMovieProgressUPP

Allocates a Universal Procedure Pointer for the MovieProgressProc callback.

MovieProgressUPP NewMovieProgressUPP (
   MovieProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieProgressUPP NewMovieProgressUPP (
   MovieProgressProcPtr    userRoutine );

/*DisposeMovieTrack

Removes a track from a movie.

void DisposeMovieTrack (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The following code snippet illustrates the use of DisposeMovieTrack:// DisposeMovieTrack coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovieTrack (
   Track    theTrack );

/*GetMediaDataRefCount

Determines the number of data references in a media.

OSErr GetMediaDataRefCount (
   Media    theMedia,
   short    *count );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
count

A pointer to a field that is to receive the number of data references in the media.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRefCount (
   Media    theMedia,
   short    *count );

/*SetTrackDimensions

Establishes a track's source rectangle.

void SetTrackDimensions (
   Track    theTrack,
   Fixed    width,
   Fixed    height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A fixed-point number that specifies the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A fixed-point number that specifies the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If you change the dimensions of an existing track, the media data is scaled to fit into the new rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackDimensions (
   Track    theTrack,
   Fixed    width,
   Fixed    height );

/*SetTrackMatrix

Establishes a track's transformation matrix.

void SetTrackMatrix (
   Track                 theTrack,
   const MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure that contains the track's new matrix. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackMatrix (
   Track                 theTrack,
   const MatrixRecord    *matrix );

/*ConvertTimeScale

Converts a time from one time scale into a time that is relative to another time scale.

void ConvertTimeScale (
   TimeRecord    *theTime,
   TimeScale     newScale );
Parameters
theTime

A pointer to a time structure that contains the time value to be converted. ConvertTimeScale replaces the contents of this time structure with the time value relative to the specified time scale.
newScale

The time scale for this operation.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function does not include the rate associated with the time value in the conversion; therefore, you should use this function when you want to convert time durations, but not when converting time values.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ConvertTimeScale (
   TimeRecord    *theTime,
   TimeScale     newScale );

/*GetMediaNextInterestingTime

Searches for times of interest in a media.

void GetMediaNextInterestingTime (
   Media        theMedia,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit or nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the media's time coordinate system. Set this parameter to NIL if you don't want this information; this lets the function works faster.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. They do this by deriving frames from sync samples, which don't rely on preceding frames for content.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMediaNextInterestingTime (
   Media        theMedia,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );

/*GetTrackID

Determines a track's unique track ID value.

long GetTrackID (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's unique track ID value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackID (
   Track    theTrack );

/*QTInsertChildren

Inserts a container of atoms as children of the specified parent atom.

OSErr QTInsertChildren (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomContainer    childrenContainer );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
childrenContainer

The atom container that contains the child atoms to be inserted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to insert a container of atoms as children of a parent atom in another atom container. Each child atom is inserted as the last atom of its type and is assigned a corresponding index. The ID of a child atom to be inserted must not duplicate that of an existing child atom of the same type. The following code shows how you can use this function to create a container, insert an atom, and insert another container as a child of the atom:// QTInsertChildren coding example
FailOSErr (QTInsertChild (outerContainer, kParentAtomIsContainer,
    kSpriteAtomType, spriteID, 0, 0, NIL, &newParentAtom));
FailOSErr (QTInsertChildren (outerContainer, newParentAtom,
    innerContainer));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChildren (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomContainer    childrenContainer );

/*QTCopyAtomDataToHandle

Copies the specified leaf atom's data to a handle.

OSErr QTCopyAtomDataToHandle (
   QTAtomContainer    container,
   QTAtom             atom,
   Handle             targetHandle );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
targetHandle

A handle. On return, the handle contains the atom's data. The handle must not be locked. This function resizes the handle, if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing an initialized handle, to retrieve a copy of a leaf atom's data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCopyAtomDataToHandle (
   QTAtomContainer    container,
   QTAtom             atom,
   Handle             targetHandle );

/*QTCopyAtom

Copies an atom and its children to a new atom container.

OSErr QTCopyAtom (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomContainer    *targetContainer );
Parameters
container

The atom container that contains the atom to be copied.
atom

The atom to be copied. To duplicate the entire container, pass a value of kParentAtomIsContainer for the atom parameter.
targetContainer

A pointer to an uninitialized atom container data structure. On return, this parameter points to an atom container that contains a copy of the atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The caller is responsible for disposing of the new atom container by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCopyAtom (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomContainer    *targetContainer );

/*GetMediaPropertyAtom

Retrieves the property atom container of a media handler.

OSErr GetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    *propertyAtom );
Parameters
theMedia

A reference to the media handler for this operation.
propertyAtom

A pointer to a QT atom container. On return, the atom container contains the property atoms for the track associated with the media handler.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call GetMediaPropertyAtom to retrieve the properties of the track associated with the specified media handler. The contents of the returned QT atom container are defined by the media handler.
Special Considerations

The caller is responsible for disposing of the QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    *propertyAtom );

/*QTReplaceAtom

Replaces the contents of an atom and its children with a different atom and its children.

OSErr QTReplaceAtom (
   QTAtomContainer    targetContainer,
   QTAtom             targetAtom,
   QTAtomContainer    replacementContainer,
   QTAtom             replacementAtom );
Parameters
targetContainer

The atom container that contains the atom to be replaced. The atom container must not be locked.
targetAtom

The atom to be replaced.
replacementContainer

The atom container that contains the replacement atom.
replacementAtom

The replacement atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The target atom and the replacement atom must be of the same type. The target atom maintains its original atom ID. This function does not modify the replacement container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTReplaceAtom (
   QTAtomContainer    targetContainer,
   QTAtom             targetAtom,
   QTAtomContainer    replacementContainer,
   QTAtom             replacementAtom );

/*QTRemoveAtom

Removes an atom and its children from the specified atom container.

OSErr QTRemoveAtom (
   QTAtomContainer    container,
   QTAtom             atom );
Parameters
container

The atom container for this operation. The atom container must not be locked.
atom

The atom to be removed from the container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to remove a particular atom and its children from an atom container. To remove all the atoms in an atom container, you should use QTRemoveChildren.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTRemoveAtom (
   QTAtomContainer    container,
   QTAtom             atom );

/*SetMoviePosterTime

Sets the poster time for the movie.

void SetMoviePosterTime (
   Movie        theMovie,
   TimeValue    posterTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
posterTime

The starting time for the movie frame that contains the poster image, expressed in the movie's time coordinate system.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Since a movie poster is a still frame, it is defined by a point in time within the movie. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePosterTime (
   Movie        theMovie,
   TimeValue    posterTime );

/*InsertMovieSegment

Copies part of one movie to another.

OSErr InsertMovieSegment (
   Movie        srcMovie,
   Movie        dstMovie,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. This function obtains the movie segment from the source movie specified in this parameter.
dstMovie

The destination movie for this operation. The function places a copy of the segment, which it obtained from the source movie, into this destination movie.
srcIn

The start of the segment in the source movie. This time value must be expressed in the source movie's time scale.
srcDuration

The duration of the segment in the source movie. This time value must be expressed in the source movie's time scale.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the destination movie's time scale.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are not copying data from one location in a movie to a different point in the same movie, this function may create new tracks, as appropriate. Before adding a track to the destination movie, the Movie Toolbox looks in the destination movie for tracks that have the same characteristics as the tracks in the source movie. The toolbox considers several characteristics when searching for an appropriate track, including track spatial dimensions, track matrix, track clipping region, track matte, alternate group affiliation, media time scale, media type, media language, and data reference (that is, referring to the same file). If the Movie Toolbox cannot find an appropriate track in the destination movie, it creates a new track with the proper characteristics.
Special Considerations

If you have assigned a progress function to the destination movie, the Movie Toolbox calls that progress function during long copy operations. Some Movie Toolbox functions can take a long time to execute. For example, if you call FlattenMovie and specify a large movie, the Movie Toolbox must read and write all the sample data for the movie. During such operations you may wish to display some kind of progress indicator to the user.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMovieSegment (
   Movie        srcMovie,
   Movie        dstMovie,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );

/*AddEmptyTrackToMovie

Duplicates a track from a movie into the same movie or into another movie.

OSErr AddEmptyTrackToMovie (
   Track     srcTrack,
   Movie     dstMovie,
   Handle    dataRef,
   OSType    dataRefType,
   Track     *dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstMovie

The destination movie for this operation. This can be the same movie as the source track or a different movie.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
dstTrack

The newly created track's identifier is returned in this parameter. If AddEmptyTrackToMovie fails, the resulting track identifier is set to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function returns a newly created, empty track. The newly created track has the same media type and track settings as the specified track. However, no data is copied from the source track to the new track. To copy data from the source track to the new track, use InsertTrackSegment after calling AddEmptyTrackToMovie.
Version Notes

This function has been available since QuickTime 2.0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddEmptyTrackToMovie (
   Track     srcTrack,
   Movie     dstMovie,
   Handle    dataRef,
   OSType    dataRefType,
   Track     *dstTrack );

/*DisposeMovieProgressUPP

Disposes of a MovieProgressUPP pointer.

void DisposeMovieProgressUPP (
   MovieProgressUPP    userUPP );
Parameters
userUPP

A MovieProgressUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieProgressUPP (
   MovieProgressUPP    userUPP );

/*PlayMoviePreview

Plays a movie's preview.

void PlayMoviePreview (
   Movie                     theMovie,
   MoviePreviewCallOutUPP    callOutProc,
   long                      refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
callOutProc

A pointer to a MoviePreviewCallOutProc callback in your application. The Movie Toolbox calls this function repeatedly while the movie preview is playing. You can use this function to stop the preview. If you don't want to assign a function, set this parameter to NIL.
refcon

A reference constant that the Movie Toolbox passes to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function sets the movie into preview mode, plays the movie preview, sets the movie back to normal playback mode, and returns to your application. The Movie Toolbox plays the preview in the movie's graphics world. Note that if you call the GetMovieActiveSegment function from within your movie callout function, the Movie Toolbox will have changed the active movie segment to be the preview segment of the movie. The Movie Toolbox restores the active segment when the preview is done playing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void PlayMoviePreview (
   Movie                     theMovie,
   MoviePreviewCallOutUPP    callOutProc,
   long                      refcon );

/*ShowMovieInformation

Displays a movie's information.

void ShowMovieInformation (
   Movie             theMovie,
   ModalFilterUPP    filterProc,
   long              refCon );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
filterProc

A Universal Procedure Pointer that accesses a ModalFilterProc callback.
refCon

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ShowMovieInformation (
   Movie             theMovie,
   ModalFilterUPP    filterProc,
   long              refCon );

/*GetMovieSelection

Returns information about a movie's current selection.

void GetMovieSelection (
   Movie        theMovie,
   TimeValue    *selectionTime,
   TimeValue    *selectionDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
selectionTime

A pointer to a time value. The GetMovieSelection function places the starting time of the current selection into the field referred to by this parameter. Set this parameter to NIL if you don't want this information.
selectionDuration

A pointer to a time value. The GetMovieSelection function places the duration of the current selection into the field referred to by this parameter. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieSelection (
   Movie        theMovie,
   TimeValue    *selectionTime,
   TimeValue    *selectionDuration );

/*CreateShortcutMovieFile

Creates a movie file that just contains a reference to another movie.

OSErr CreateShortcutMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   Handle          targetDataRef,
   OSType          targetDataRefType );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains movie file creation flags (see below). See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
targetDataRef

A handle to the data referred to by the movie that this function creates.
targetDataRefType

The type of the data referred to by the movie that this function creates; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateShortcutMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   Handle          targetDataRef,
   OSType          targetDataRefType );

/*DisposeTimeBase

Disposes of a time base once you are finished with it.

void DisposeTimeBase (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTimeBase (
   TimeBase    tb );

/*SetTimeBaseRate

Sets the rate of a time base.

void SetTimeBaseRate (
   TimeBase    tb,
   Fixed       r );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
r

The rate of the time base.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Rates may be set to negative values. Negative rates cause time to move backward for the time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseRate (
   TimeBase    tb,
   Fixed       r );

/*NewTimeBase

Obtains a new time base.

TimeBase NewTimeBase ( void );
Return Value

The ID of the new time base.
Discussion

This function sets the rate of the time base to 0, the start time to its minimum value, the time value to 0, and the stop time to its maximum value. The function assigns the default clock component to the new time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase NewTimeBase ( void );

/*DeleteMovieSegment

Removes a specified segment from a movie.

OSErr DeleteMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
startTime

A time value specifying the starting point of the segment to be deleted.
duration

A time value that specifies the duration of the segment to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration. The following code snippet shows DeleteMovieSegment being used while adding a modifier track to a movie.// DeleteMovieSegment coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    duration );

/*MediaTimeToSampleNum

Lets you find the sample that contains the data for a specified time.

void MediaTimeToSampleNum (
   Media        theMedia,
   TimeValue    time,
   long         *sampleNum,
   TimeValue    *sampleTime,
   TimeValue    *sampleDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
time

The time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The Movie Toolbox returns the sample number that identifies the sample that contains data for the time specified by the time parameter.
sampleTime

A pointer to a time value. The MediaTimeToSampleNum function updates this time value to indicate the starting time of the sample that contains data for the time specified by the time parameter. This time value is expressed in the media's time scale. Set this parameter to NIL if you don't want this information.
sampleDuration

A pointer to a time value. The Movie Toolbox returns the duration of the sample that contains data for the time specified by the time parameter. This time value is expressed in the media's time scale. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MediaTimeToSampleNum (
   Media        theMedia,
   TimeValue    time,
   long         *sampleNum,
   TimeValue    *sampleTime,
   TimeValue    *sampleDuration );

/*LoadTrackIntoRam

Loads a track's data into memory.

OSErr LoadTrackIntoRam (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to load. You must specify this time value in the movie's time coordinate system.
duration

The length of the segment to load. Use GetTrackDuration to determine the length of the entire movie. Note that the media handler may load more data than you specify.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

If the track does not fit, the function returns an error. See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr LoadTrackIntoRam (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration,
   long         flags );

/*MovieSearchText

Searches for text in a movie.

OSErr MovieSearchText (
   Movie        theMovie,
   Ptr          text,
   long         size,
   long         searchFlags,
   Track        *searchTrack,
   TimeValue    *searchTime,
   long         *searchOffset );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
text

The text to be searched for.
size

The size of the text.
searchFlags

Flags (see below) that narrow the search process. See these constants: 
searchTextDontGoToFoundTime
searchTextDontHiliteFoundText
searchTextOneTrackOnly
searchTextEnabledTracksOnly
searchTrack

On return, a pointer to the found track.
searchTime

On return, a pointer to the found time.
searchOffset

On return, a pointer to the found offset to the text.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr MovieSearchText (
   Movie        theMovie,
   Ptr          text,
   long         size,
   long         searchFlags,
   Track        *searchTrack,
   TimeValue    *searchTime,
   long         *searchOffset );

/*TextMediaSetTextProc

Specifies a custom function to be called whenever a text sample is displayed in a movie.

ComponentResult TextMediaSetTextProc (
   MediaHandler    mh,
   TextMediaUPP    TextProc,
   long            refcon );
Parameters
mh

The text media handler obtained by GetMediaHandler.
TextProc

A Universal Procedure Pointer that points to a TextMediaProc callback.
refcon

Indicates a reference constant that will be passed to your callback. Use this parameter to point to a data structure containing any information your function needs. Set this parameter to 0 if you don't need it.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaSetTextProc (
   MediaHandler    mh,
   TextMediaUPP    TextProc,
   long            refcon );

/*DisposeTextMediaUPP

Disposes of a TextMediaUPP pointer.

void DisposeTextMediaUPP (
   TextMediaUPP    userUPP );
Parameters
userUPP

A TextMediaUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTextMediaUPP (
   TextMediaUPP    userUPP );

/*NewTextMediaUPP

Allocates a Universal Procedure Pointer for the TextMediaProc callback.

TextMediaUPP NewTextMediaUPP (
   TextMediaProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewTextMediaProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TextMediaUPP NewTextMediaUPP (
   TextMediaProcPtr    userRoutine );

/*SetMovieAudioContext

Targets a movie to render into an audio context.

OSStatus SetMovieAudioContext (
   Movie      movie,
   QTAudioContextRef    audioContext;
Parameters
movie

The movie.
audioContext

The audio context that the movie will render into.
Return Value

An error code. Returns noErr if there is no error. .
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioContext (
   Movie      movie,
   QTAudioContextRef    audioContext);

#ifdef __cplusplus
}
#endif
#endif

