#ifndef OS_OSMETACLASS_H
#define OS_OSMETACLASS_H

#include <sys/types.h>

#include <libkern/OSReturn.h>
#include <kern/debug.h>
#include <HYS/libkern/c++/OSMetaClass.h>

/*OSDeclareCommonStructors


DO NOT USE. Basic helper macro for the OSDeclare for Default and Abstract macros, qv. 
public

#define OSDeclareCommonStructors(className) \ 
    private: \ 
    static const OSMetaClass * const superClass; \ 
    public: \ 
    static const OSMetaClass * const metaClass; \ 
    static class MetaClass : public OSMetaClass { \ 
    public: \ 
    MetaClass(); \ 
    virtual OSObject *alloc() const; \ 
    } gMetaClass; \ 
    friend class className ::MetaClass; \ 
    virtual const OSMetaClass * getMetaClass() const; \ 
    protected: \ 
    className (const OSMetaClass *); \ 
    virtual ~ className () 
Parameters
className
Name of class (NO QUOTES).*/
#define OSDeclareCommonStructors(className) \
    private: \
    static const OSMetaClass * const superClass; \
    public: \
    static const OSMetaClass * const metaClass; \
    static class MetaClass : public OSMetaClass { \
    public: \
    MetaClass(); \
    virtual OSObject *alloc() const; \
    } gMetaClass; \
    friend class className ::MetaClass; \
    virtual const OSMetaClass * getMetaClass() const; \
    protected: \
    className (const OSMetaClass *); \
    virtual ~ className ()

/*OSDeclareDefaultStructors


Declares runtime type information data and interfaces (one of the macros used in the class declaration of all subclasses of OSObject). 
public

#define OSDeclareDefaultStructors(className) \ 
    private: \ 
    static const OSMetaClass * const superClass; \ 
    public: \ 
    static const OSMetaClass * const metaClass; \ 
    static class MetaClass : public OSMetaClass { \ 
    public: \ 
    MetaClass(); \ 
    virtual OSObject *alloc() const; \ 
    } gMetaClass; \ 
    friend class className ::MetaClass; \ 
    virtual const OSMetaClass * getMetaClass() const; \ 
    protected: \ 
    className (const OSMetaClass *); \ 
    virtual ~ className (); \ 
    public: \ 
    className (); \ 
    protected: 
Parameters
className
Name of class (NO QUOTES).
Discussion 

By convention this should be 'called' immediately after the opening brace in a class declaration. It leaves the current privacy state as 'protected:'.*/
#define OSDeclareDefaultStructors(className) \
    private: \
    static const OSMetaClass * const superClass; \
    public: \
    static const OSMetaClass * const metaClass; \
    static class MetaClass : public OSMetaClass { \
    public: \
    MetaClass(); \
    virtual OSObject *alloc() const; \
    } gMetaClass; \
    friend class className ::MetaClass; \
    virtual const OSMetaClass * getMetaClass() const; \
    protected: \
    className (const OSMetaClass *); \
    virtual ~ className (); \
    public: \
    className (); \
    protected:


/*OSDefineMetaClassWithInit


DO NOT USE. Basic helper macro for the OSDefineMetaClass for the default and Abstract macros, qv.
public

#define OSDefineMetaClassWithInit(className, superClassName, init) \ 
    // Class global data // \ 
    className ::MetaClass className ::gMetaClass; \ 
    const OSMetaClass / const className ::metaClass = \ 
    & className ::gMetaClass; \ 
    const OSMetaClass / const className ::superClass = \ 
    & superClassName ::gMetaClass; \ 
    // Class member functions // \ 
    className :: className(const OSMetaClass /meta) \ 
    : superClassName (meta) { } \ 
    className ::~ className() { } \ 
    const OSMetaClass / className ::getMetaClass() const \ 
    { return &gMetaClass; } \ 
    // The ::MetaClass constructor // \ 
    className ::MetaClass::MetaClass() \ 
    : OSMetaClass(#className, className::superClass, sizeof(className)) \ 
    { init; } 
Parameters
className
Name of class (NO QUOTES and NO MACROS).
superClassName
Name of super class (NO QUOTES and NO MACROS).
init
Name of a function to call after the OSMetaClass is constructed.*/
#define OSDefineMetaClassWithInit(className, superClassName, init) \
    /* Class global data */ \
    className ::MetaClass className ::gMetaClass; \
    const OSMetaClass * const className ::metaClass = \
    & className ::gMetaClass; \
    const OSMetaClass * const className ::superClass = \
    & superClassName ::gMetaClass; \
    /* Class member functions */ \
    className :: className(const OSMetaClass *meta) \
    : superClassName (meta) { } \
    className ::~ className() { } \
    const OSMetaClass * className ::getMetaClass() const \
    { return &gMetaClass; } \
    /* The ::MetaClass constructor */ \
    className ::MetaClass::MetaClass() \
    : OSMetaClass(#className, className::superClass, sizeof(className)) \
    { init; }

/*OSDefineDefaultStructors


DO NOT USE. Basic helper macro for the OSDefineMetaClass for the default and Abstract macros, qv.
public

#define OSDefineDefaultStructors(className, superClassName) \ 
    OSObject * className ::MetaClass::alloc() const \ 
    { return new className; } \ 
    className :: className () : superClassName (&gMetaClass) \ 
    { gMetaClass.instanceConstructed(); } 
Parameters
className
Name of class. NO QUOTES and NO MACROS.
superClassName
Name of super class. NO QUOTES and NO MACROS.*/
#define OSDefineDefaultStructors(className, superClassName) \
    OSObject * className ::MetaClass::alloc() const \
    { return new className; } \
    className :: className () : superClassName (&gMetaClass) \
    { gMetaClass.instanceConstructed(); }

/*OSDefineMetaClassAndStructorsWithInit


See OSDefineMetaClassAndStructors.
public

#define OSDefineMetaClassAndStructorsWithInit(className, superClassName, init) \ 
    // Class global data // \ 
    className ::MetaClass className ::gMetaClass; \ 
    const OSMetaClass / const className ::metaClass = \ 
    & className ::gMetaClass; \ 
    const OSMetaClass / const className ::superClass = \ 
    & superClassName ::gMetaClass; \ 
    // Class member functions // \ 
    className :: className(const OSMetaClass /meta) \ 
    : superClassName (meta) { } \ 
    className ::~ className() { } \ 
    const OSMetaClass / className ::getMetaClass() const \ 
    { return &gMetaClass; } \ 
    // The ::MetaClass constructor // \ 
    className ::MetaClass::MetaClass() \ 
    : OSMetaClass(#className, className::superClass, sizeof(className)) \ 
    { init; } \ 
    OSObject / className ::MetaClass::alloc() const \ 
    { return new className; } \ 
    className :: className () : superClassName (&gMetaClass) \ 
    { gMetaClass.instanceConstructed(); } 
Parameters
className
Name of class. NO QUOTES and NO MACROS.
superClassName
Name of super class. NO QUOTES and NO MACROS.
init
Name of a function to call after the OSMetaClass is constructed.
Discussion 

Define an OSMetaClass subclass and the primary constructors and destructors for a subclass of OSObject that isn't an abstract class. In general this 'function' is 'called' at the top of the file just before the first function is implemented for a particular class. Once the OSMetaClass has been constructed, at load time, call the init routine. NB you can not rely on the order of execution of the init routines.*/
#define OSDefineMetaClassAndStructorsWithInit(className, superClassName, init) \
    /* Class global data */ \
    className ::MetaClass className ::gMetaClass; \
    const OSMetaClass * const className ::metaClass = \
    & className ::gMetaClass; \
    const OSMetaClass * const className ::superClass = \
    & superClassName ::gMetaClass; \
    /* Class member functions */ \
    className :: className(const OSMetaClass *meta) \
    : superClassName (meta) { } \
    className ::~ className() { } \
    const OSMetaClass * className ::getMetaClass() const \
    { return &gMetaClass; } \
    /* The ::MetaClass constructor */ \
    className ::MetaClass::MetaClass() \
    : OSMetaClass(#className, className::superClass, sizeof(className)) \
    { init; } \
    OSObject * className ::MetaClass::alloc() const \
    { return new className; } \
    className :: className () : superClassName (&gMetaClass) \
    { gMetaClass.instanceConstructed(); }

/*OSDefineMetaClassAndStructors


Defines an OSMetaClass subclass and the runtime system routines.
public

#define OSDefineMetaClassAndStructors(className, superClassName) \ 
    // Class global data // \ 
    className ::MetaClass className ::gMetaClass; \ 
    const OSMetaClass / const className ::metaClass = \ 
    & className ::gMetaClass; \ 
    const OSMetaClass / const className ::superClass = \ 
    & superClassName ::gMetaClass; \ 
    // Class member functions // \ 
    className :: className(const OSMetaClass /meta) \ 
    : superClassName (meta) { } \ 
    className ::~ className() { } \ 
    const OSMetaClass / className ::getMetaClass() const \ 
    { return &gMetaClass; } \ 
    // The ::MetaClass constructor // \ 
    className ::MetaClass::MetaClass() \ 
    : OSMetaClass(#className, className::superClass, sizeof(className)) \ 
    { ; } \ 
    OSObject / className ::MetaClass::alloc() const \ 
    { return new className; } \ 
    className :: className () : superClassName (&gMetaClass) \ 
    { gMetaClass.instanceConstructed(); } 
Parameters
className
Name of class. NO QUOTES and NO MACROS.
superClassName
Name of super class. NO QUOTES and NO MACROS.
Discussion 

Define an OSMetaClass subclass and the primary constructors and destructors for a subclass of OSObject that isn't an abstract class. In general this 'function' is 'called' at the top of the file just before the first function is implemented for a particular class.*/
#define OSDefineMetaClassAndStructors(className, superClassName) \
    /* Class global data */ \
    className ::MetaClass className ::gMetaClass; \
    const OSMetaClass * const className ::metaClass = \
    & className ::gMetaClass; \
    const OSMetaClass * const className ::superClass = \
    & superClassName ::gMetaClass; \
    /* Class member functions */ \
    className :: className(const OSMetaClass *meta) \
    : superClassName (meta) { } \
    className ::~ className() { } \
    const OSMetaClass * className ::getMetaClass() const \
    { return &gMetaClass; } \
    /* The ::MetaClass constructor */ \
    className ::MetaClass::MetaClass() \
    : OSMetaClass(#className, className::superClass, sizeof(className)) \
    { ; } \
    OSObject * className ::MetaClass::alloc() const \
    { return new className; } \
    className :: className () : superClassName (&gMetaClass) \
    { gMetaClass.instanceConstructed(); }


//functions



class OSMetaClass;
class OSObject;
class OSString;
class OSSymbol;
class OSDictionary;
class OSSerialize;

class OSMetaClassBase{
};

class OSMetaClass : private OSMetaClassBase{

public:
/*OSMetaClass(const char *, const OSMetaClass *, unsigned int)


Constructor for OSMetaClass objects. 
protected

OSMetaClass(
    const char *inClassName, 
    const OSMetaClass *inSuperClass, 
    unsigned int inClassSize); 
Parameters
inClassName
C string of the name of the class this metaclass represents.
inSuperClassName
C string of the name of the super class.
inClassSize
size of the class.
Discussion 

This constructor is protected and cannot be used to instantiate an OSMetaClass object, i.e. OSMetaClass is an abstract class. This function stores the currently constructing OSMetaClass instance away for later processing. See preModLoad and postModLoad.*/
OSMetaClass(
    const char *inClassName, 
    const OSMetaClass *inSuperClass, 
    unsigned int inClassSize); 

/*instanceConstructed


Counts the instances of the class behind this metaclass. 
public

void instanceConstructed() const; 
Discussion 

Every non-abstract class that inherits from OSObject has a default constructor that calls its own metaclass's instanceConstructed function. This constructor is defined by the OSDefineMetaClassAndStructors macro (qv) that all OSObject subclasses must use. Also, if the instance count goes from 0 to 1, i.e. the first instance, then increment the instance count of the super class.*/
void instanceConstructed() const; 

};

#endif