#ifndef MACH_THREAD_ACT_H
#define MACH_THREAD_ACT_H 

#include <string.h>
#include <mach/ndr.h>
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/notify.h>
#include <mach/mach_types.h>
#include <mach/message.h>
#include <mach/mig_errors.h>
#include <mach/port.h>
#include <mach/std_types.h>
#include <mach/mig.h>
#include <mach/mig.h>
#include <mach/mach_types.h>


/*thread_get_state

Function - Return the execution state for a thread. 
SYNOPSIS
kern_return_t   thread_get_state
                (thread_act_t                     target_thread,
                 thread_state_flavor_t                   flavor,
                 thread_state_t                       old_state,
                 mach_msg_type_number_t         old_state_count);
PARAMETERS

target_thread 
[in thread send right] The thread for which the execution state is to be returned. The calling thread cannot specify itself. 

flavor 
[in scalar] The type of execution state to be returned. Valid values correspond to supported machined architectures. 

old_state 
[out structure] State information for the specified thread. 

old_state_count 
[in/out scalar] On input, the maximum size of the buffer; on output, the size returned (in natural-sized units). 
DESCRIPTION

The thread_get_state function returns the execution state (for example, the machine registers) for target_thread. flavor specifies the type of state information returned. 

The format of the data returned is machine specific; it is defined in \*L\*O. 
RETURN VALUES

Only generic errors apply. 
RELATED INFORMATION

Functions: task_info, thread_info, thread_set_state.*/
kern_return_t   thread_get_state
                (thread_act_t                     target_thread,
                 thread_state_flavor_t                   flavor,
                 thread_state_t                       old_state,
                 mach_msg_type_number_t         old_state_count);

#endif