#ifndef VNODE_H
#define VNODE_H

#include <sys/appleapiopts.h>
#include <sys/cdefs.h>
#include <sys/kernel_types.h>
#include <sys/signal.h>
#include <stdio.h>//hys
//#include <HYS/sys/vnode.h>
#include <APPLE/sys/vnode.h>
/*component name parameter descriptors.

See Also:
ISDOTDOT
MAKEENTRY
ISLASTCN
ISWHITEOUT
DOWHITEOUT
#define ISDOTDOT 0x002000 / current component name is .. /
    
#define MAKEENTRY 0x004000 / entry is to be added to name 
    cache /
#define ISLASTCN 0x008000 / this is last component of 
    pathname /
#define ISWHITEOUT 0x020000 / found whiteout /
#define DOWHITEOUT 0x040000 / do whiteouts /*/
#define MAKEENTRY 0x004000 /* entry is to be added to name 
    cache */
#define ISLASTCN 0x008000 /* this is last component of 
    pathname */
#define ISWHITEOUT 0x020000 /* found whiteout */
#define DOWHITEOUT 0x040000 /* do whiteouts */

/*vtagtype

enum vtagtype { 
    VT_NON,
    VT_UFS,
    VT_NFS,
    VT_MFS,
    VT_MSDOSFS,
    VT_LFS,
    VT_LOFS,
    VT_FDESC, 
    VT_PORTAL,
    VT_NULL,
    VT_UMAP,
    VT_KERNFS,
    VT_PROCFS,
    VT_AFS,
    VT_ISOFS, 
    VT_UNION,
    VT_HFS,
    VT_VOLFS,
    VT_DEVFS,
    VT_WEBDAV,
    VT_UDF,
    VT_AFP, 
    VT_CDDA,
    VT_CIFS,
    VT_OTHER
};  
Discussion 

Vnode tag types. These are for the benefit of external programs only (e.g., pstat) and should NEVER be inspected by the kernel.*/
enum vtagtype	{
	VT_NON, VT_UFS, VT_NFS, VT_MFS, VT_MSDOSFS, VT_LFS, VT_LOFS, VT_FDESC,
	VT_PORTAL, VT_NULL, VT_UMAP, VT_KERNFS, VT_PROCFS, VT_AFS, VT_ISOFS,
	VT_UNION, VT_HFS, VT_VOLFS, VT_DEVFS, VT_WEBDAV, VT_UDF, VT_AFP,
	VT_CDDA, VT_CIFS,VT_OTHER};

/*vtype

enum vtype {
    VNON,
    VREG,
    VDIR,
    VBLK,
    VCHR,
    VLNK,
    VSOCK,
    VFIFO,
    VBAD,
    VSTR, 
    VCPLX 
};  
Discussion 

Vnode types. VNON means no type.*/

enum vtype	{ VNON, VREG, VDIR, VBLK, VCHR, VLNK, VSOCK, VFIFO, VBAD, VSTR,
			  VCPLX };
typedef enum vtype vtype;

//typedef enum vtype vtype;

//func

/*vnode_isdir

int vnode_isdir(
    vnode_t);  
Discussion 

Description forthcoming*/

 int vnode_isdir(
    vnode_t);

/*vnode_create

errno_t vnode_create(
    int,
    size_t,
    void *,
    vnode_t *);  
Discussion 

Create a vnode*/

errno_t vnode_create(
    int,
    size_t,
    void *,
    vnode_t *);  

/*vnode_vid

uint32_t vnode_vid(
    vnode_t);  
Discussion 

Description forthcoming*/

uint32_t vnode_vid(
    vnode_t);  


/*vnode_getwithvid

int vnode_getwithvid(
    vnode_t,
    int);  
Discussion 

Description forthcoming*/
int vnode_getwithvid(
    vnode_t,
    int);  

/*vnode_get

int vnode_get(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_get(
    vnode_t);  

/*vnode_addfsref

int vnode_addfsref(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_addfsref(
    vnode_t);  

/*vnode_mount

mount_t vnode_mount(
    vnode_t);  
Discussion 

Description forthcoming*/

mount_t vnode_mount(
    vnode_t);  

/*vn_getpath

int vn_getpath(
    struct vnode *vp,
    char *pathbuf,
    int *len);  
Discussion 

Description forthcoming*/

int vn_getpath(
    struct vnode *vp,
    char *pathbuf,
    int *len);  

/*vnode_vtype

enum vtype vnode_vtype(
    vnode_t);  
Discussion 

Description forthcoming*/
enum vtype vnode_vtype(
    vnode_t);

/*vfs_context_ucred

ucred_t vfs_context_ucred(
    vfs_context_t);  
Discussion 

Description forthcoming*/

ucred_t vfs_context_ucred(
    vfs_context_t);  

/*vnode_fsnode

void * vnode_fsnode(
    vnode_t);  
Discussion 

Description forthcoming*/
void * vnode_fsnode(
    vnode_t);  

/*vnode_removefsref

int vnode_removefsref(
    vnode_t);  
Discussion 

Description forthcoming*/

int vnode_removefsref(
    vnode_t);  

/*vnode_clearfsnode

void vnode_clearfsnode(
    vnode_t);  
Discussion 

Description forthcoming*/
void vnode_clearfsnode(
    vnode_t);  

/*vnode_put

int vnode_put(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_put(
    vnode_t);  

/*vnode_isvroot

int vnode_isvroot(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_isvroot(
    vnode_t);  

/*vnode_isnocache

int vnode_isnocache(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_isnocache(
    vnode_t);  

/*vnode_isreg

int vnode_isreg(
    vnode_t);  
Discussion 

Description forthcoming*/

int vnode_isreg(
    vnode_t);  

/*vnode_ref

int vnode_ref(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_ref(
    vnode_t);  

/*vnode_specrdev

dev_t vnode_specrdev(
    vnode_t);  
Discussion 

Description forthcoming*/
dev_t vnode_specrdev(
    vnode_t);  

/*vnode_rele

void vnode_rele(
    vnode_t);  
Discussion 

Description forthcoming*/
void vnode_rele(
    vnode_t);  


#include <APPLE/sys/vnode_E.h>
#endif 