#include <HIServices/HIServices.h>


/*GetFrontProcess

Gets the process serial number of the front process.

OSErr GetFrontProcess (
   ProcessSerialNumber * PSN
);
Parameters
PSN

On return, a pointer to the process serial number of the process running in the foreground. 
Return Value

A result code. See Process Manager Result Codes. If no process is running in the foreground, returns procNotFound.
Discussion

You can use this function to determine if your process or some other process is in the foreground. You can use the process serial number returned in the PSN parameter in other Process Manager functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr GetFrontProcess (
   ProcessSerialNumber * PSN
){
printf ("GetFrontProcess",*PSN);
};

/*GetProcessInformation

Get information about a specific process.

Modified in Carbon

OSErr GetProcessInformation (
   const ProcessSerialNumber * PSN,
   ProcessInfoRec * info
);
Parameters
PSN

A pointer to a valid process serial number. You can pass a process serial number structure containing the constant kCurrentProcess to get information about the current process. See ProcessSerialNumber for more information.
info

On return, a pointer to a structure containing information about the specified process. 
Return Value

A result code. See Process Manager Result Codes.
Discussion

The information returned in the info parameter includes the applications name as it appears in the Application menu, the type and signature of the application, the address of the application partition, the number of bytes in the application partition, the number of free bytes in the application heap, the application that launched the application, the time at which the application was launched, and the location of the application file.

The GetProcessInformation function also returns information about the applications 'SIZE' resource and indicates whether the process is an application or a desk accessory.

You need to specify values for the processInfoLength, processName, and processAppSpec fields of the process information structure. Specify the length of the process information structure in the processInfoLength field. If you do not want information returned in the processName and processAppSpec fields, specify NULL for these fields. Otherwise, allocate at least 32 bytes of storage for the string pointed to by the processName field and, in the processAppSpec field, specify a pointer to an FSSpec structure.

The processName field may not be what you expect, especially if an application has a localized name. The processName field, if not NULL, on return will contain the filename part of the executable file of the application. If you want the localized, user-displayable name for an application, call CopyProcessName.
Special Considerations

Do not call GetProcessInformation at interrupt time.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Carbon Porting Notes

The processActiveTime field of the returned ProcessInfoRec structure is not used in Carbon on Mac OS X. In Mac OS 8 and 9, the accumulated amount of CPU time used by the process is returned in this field. In Mac OS X, the value returned in this field is always 0.

On Mac OS X, some flags in processMode will not be set as they were on Mac OS 9, even for Classic applications. Mac OS X doesn't support applications which can't be sent into the background, so modeCanBackground will always be set. Similarly, Mac OS X applications will always have mode32BitCompatible and modeHighLevelEventAware set.

Other fields in the ProcessInfoRec structure (such as processSize and processFreeMem) may also no longer be applicable.

In most cases, you should consider using ProcessInformationCopyDictionary if you are running only on Mac OS X. 
Declared In
Processes.h */

OSErr GetProcessInformation (
   const ProcessSerialNumber * PSN,
   ProcessInfoRec * info
){
printf ("GetProcessInformation",*PSN,*info);
};


/*GetCurrentProcess

Gets information about the current process, if any.

OSErr GetCurrentProcess (
   ProcessSerialNumber * PSN
);
Parameters
PSN

On output, a pointer to the process serial number of the current process, that is, the one currently accessing the CPU. This application can be running in either the foreground or the background. 
Return Value

A result code. See Process Manager Result Codes.
Discussion

Applications can use this function to find their own process serial number. Drivers can use this function to find the process serial number of the current process. You can use the returned process serial number in other Process Manager functions. 

This function is named MacGetCurrentProcess on non Macintosh platforms and GetCurrentProcess on Macintosh computers. However, even Macintosh code can use the MacGetCurrentProcess name because a macro exists that automatically maps that call to GetCurrentProcess.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr GetCurrentProcess (
   ProcessSerialNumber * PSN
){
printf ("GetCurrentProcess",*PSN);
};

/*SetFrontProcess

Moves a process to the foreground.

OSErr SetFrontProcess (
   const ProcessSerialNumber * PSN
);
Parameters
PSN

A pointer to a valid process serial number. You can also pass a process serial number structure containing the constant kCurrentProcess to refer to the current process. See ProcessSerialNumber for more information.
Return Value

A result code. See Process Manager Result Codes.
Discussion

The SetFrontProcess function moves the specified process to the foreground immediately.

If the specified process serial number is invalid or if the specified process is a background-only application, SetFrontProcess returns a nonzero result code and does not change the current foreground process.
Special Considerations

Do not call SetFrontProcess at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr SetFrontProcess (
   const ProcessSerialNumber * PSN
){
printf ("GetFrontProcess",*PSN);
};

/*GetNextProcess

Gets information about the next process, if any, in the Process Managers internal list of open processes.

OSErr GetNextProcess (
   ProcessSerialNumber * PSN
);
Parameters
PSN

On input, a pointer to the process serial number of a process. This number should be a valid process serial number returned from LaunchApplication, GetFrontProcess, or GetCurrentProcess, or a process serial number structure containing kNoProcess. For details about this structure, see ProcessSerialNumber. On return, a pointer to the process serial number of the next process, or else kNoProcess. 
Return Value

A result code. See Process Manager Result Codes.
Discussion

The Process Manager maintains a list of all open processes. You can derive this list by using repetitive calls to GetNextProcess. Begin generating the list by calling GetNextProcess and specifying the constant kNoProcess in the PSN parameter. You can then use the returned process serial number to get the process serial number of the next process. Note that the order of the list of processes is internal to the Process Manager. When the end of the list is reached, GetNextProcess returns the constant kNoProcess in the PSN parameter and the result code procNotFound.

You can use the returned process serial number in other Process Manager functions. You can also use this process serial number to specify a target application when your application sends a high-level event. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In  Processes.h*/
OSErr GetNextProcess (
   ProcessSerialNumber * PSN
){
printf ("GetNextProcess",*PSN);
};

/*ExitToShell

Terminates an application.

void ExitToShell (void);
Discussion

In general, you need to call ExitToShell only if you want your application to terminate without reaching the end of its main function.

The ExitToShell function terminates the calling process. The Process Manager removes your application from the list of open processes and performs any other necessary cleanup operations. In particular, all memory in your application partition and any temporary memory still allocated to your application is released. If necessary, the Application Died Apple event is sent to the process that launched your application.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
void ExitToShell (void){
printf ("ExitToShell");
};

/*GetProcessBundleLocation

Retrieves the file system location of the application bundle (or executable file) associated with a process.

OSStatus GetProcessBundleLocation (
   const ProcessSerialNumber * PSN,
   FSRef * location
);
Parameters
PSN

A pointer to a valid process serial number. See ProcessSerialNumber for more information.
location
Return Value

A result code. See “Process Manager Result Codes”.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSStatus GetProcessBundleLocation (
   const ProcessSerialNumber * PSN,
   FSRef * location
){
printf ("GetProcessBundleLocation",*PSN,*location);
};

/*GetProcessForPID

Obtains the process serial number from a Unix PID. 

OSStatus GetProcessForPID(
   pid_t                  pid,
   ProcessSerialNumber *  psn);
Parameters
pid

The Unix process ID (PID).
psn

On return, psn points to the process serial number.
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

Note that this call does not make sense for Classic applications, since they all share a single UNIX process ID.
Availability
Available in Mac OS X version 10.0 and later in ApplicationServices.framework.
Declared In
Processes.h*/
OSStatus GetProcessForPID(
   pid_t                  pid,
   ProcessSerialNumber *  psn){
printf ("GetProcessForPID",pid,*psn);
};

/*LaunchApplication

Launches an application.

OSErr LaunchApplication (
   LaunchPBPtr LaunchParams
);
Parameters
LaunchParams

A pointer to a LaunchParamBlockRec specifying information about the application to launch. 
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

The LaunchApplication function launches the application from the specified file and returns the process serial number, preferred partition size, and minimum partition size if the application is successfully launched.

Note that if you launch another application without terminating your application, the launched application is not actually executed until you make a subsequent call to WaitNextEvent or EventAvail.

Set the launchContinue flag in the launchControlFlags field of the launch parameter block if you want your application to continue after the specified application is launched. If you do not set this flag, LaunchApplication terminates your application after launching the specified application, even if the launch fails. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr LaunchApplication (
   LaunchPBPtr LaunchParams
){
printf ("LaunchApplication",LaunchParams);
};

/*CopyProcessName

Gets a copy of the name of a process.

OSStatus CopyProcessName (
   const ProcessSerialNumber * PSN,
   CFStringRef * name
);
Parameters
PSN

A pointer to a valid process serial number. See ProcessSerialNumber for more information.
name

A Core Foundation string that contains the name of the specified process. 
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

Because the string returned is a Core Foundation string, it can represent a multilingual name, unlike the processName field value you obtain using GetProcessInformation.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/

OSStatus CopyProcessName (
   const ProcessSerialNumber * PSN,
   CFStringRef * name
){
printf ("CopyProcessName",*PSN,*name);
};

/*SameProcess

Determines whether two process serial numbers specify the same process.

OSErr SameProcess (
   const ProcessSerialNumber * PSN1,
   const ProcessSerialNumber * PSN2,
   Boolean * result
);
Parameters
PSN1

A process serial number. 
PSN2

A process serial number.
result

On return, a pointer to a Boolean value which is TRUE if the process serial numbers passed in PSN1 and PSN2 refer to the same process; otherwise FALSE. 
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

Do not attempt to compare two process serial numbers by any means other than the SameProcess function, because the interpretation of the bits in a process serial number is internal to the Process Manager.

The values of PSN1 and PSN2 must be valid process serial numbers returned from LaunchApplication , GetNextProcess , GetFrontProcess , GetCurrentProcess , or a high-level event. You can also pass a process serial number structure containing the constant kCurrentProcess to refer to the current process. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr SameProcess (
   const ProcessSerialNumber * PSN1,
   const ProcessSerialNumber * PSN2,
   Boolean * result
){
printf ("SameProcess",*PSN1,*PSN2,*result);
};

