#define C_LANG

#include <ImageIO/ImageIO.h>
/*CGImageSourceCreateImageAtIndex

Creates a CGImage object for the image data associated with the specified index in an image source.

CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based. 
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

Returns a CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
){};


/*CGImageSourceCopyPropertiesAtIndex

Returns the properties of the image at a specified location in an image source.

CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index of the image whose properties you want to obtain. The index is zero-based. 
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply.
Return Value

A dictionary that contains the properties associated with the image.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
){};

/*CGImageDestinationFinalize

Writes image data and properties to the data, URL, or data consumer associated with the image destination.

bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
);
Parameters
idst

An image destination.
Return Value

Returns true if the image is successfully written; false otherwise.
Discussion

You must call this function or the output of the image destination will not be valid. After calling this function, no additional data is written to the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
){};


/*CGImageDestinationAddImage

Adds an image to an image destination.

void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
);
Parameters
idst

An image destination
image

The image to add. 
properties

An optional dictionary that specifies the properties of the added image.
Discussion

The function CGImageDestiantionAddImage sets the next image in the image destination. The function logs an error if you add more images than what you specified when you created the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
){};


/*CGImageSourceCreateWithURL

Creates an image source that reads from a location specified by a URL.

CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
);
Parameters
url

The URL to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
){};



/*CGImageSourceCopyTypeIdentifiers

Returns an array of uniform type identifiers (UTIs) that are supported for Quartz image sources.

CFArrayRef CGImageSourceCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image sources.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFArrayRef CGImageSourceCopyTypeIdentifiers (){};

/*CGImageDestinationCreateWithURL

Creates an image destination that writes to a location specified by a URL.

CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);
Parameters
url

The URL to write to. If the URL already exists, the data at this location is overwritten.
type

The UTI (uniform type identifier) of the resulting image file.
count

The number of images (not including thumbnail images) that the image file will contain.
options

Reserved for future use. Pass NULL.
Return Value

A Quartz image destination. You are responsible for releasing this object using CFRelease.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
){};



/*CGImageSourceCreateWithData

Creates an image source that reads from a Core Foundation data object.

CGImageSourceRef CGImageSourceCreateWithData(
   CFDataRef data,
   CFDictionaryRef options
);
Parameters
data

The data object to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/

CGImageSourceRef CGImageSourceCreateWithData(
   CFDataRef data,
   CFDictionaryRef options
){};


/*CGImageSourceCreateThumbnailAtIndex

Creates a thumbnail image of the image located at a specified location in an image source.

CGImageRef CGImageSourceCreateThumbnailAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateThumbnailAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
){};



/*CGImageSourceGetType

Returns the uniform type identifier of the source container.

CFStringRef CGImageSourceGetType(
   CGImageSourceRef isrc
);
Parameters
isrc

An image source.
Return Value

The uniform type identifier of the image.
Discussion

The uniform type identifier (UTI) of the source container can be different from the type of the images in the container. For example, the .icns format supports embedded JPEG2000. The type of the source container is "com.apple.icns" but type of the images is JPEG2000.

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs. 
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/

CFStringRef CGImageSourceGetType(
   CGImageSourceRef isrc
){};


/*CGImageSourceCopyProperties

Returns the properties of the image source.

CFDictionaryRef CGImageSourceCopyProperties (
   CGImageSourceRef isrc
   CFDictionaryRef options
);
Parameters
isrc

An image source.
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply. 
Return Value

A dictionary that contains the properties associated with the image source container.
Discussion

These properties apply to the container in general but not necessarily to any individual image contained in the image source.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyProperties (
   CGImageSourceRef isrc,
   CFDictionaryRef options
){};


/*CGImageDestinationCopyTypeIdentifiers

Returns an array of the uniform type identifiers (UTIs) that are supported for Quartz image destinations.

CFArrayRef CGImageDestinationCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image destinations.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs that can be returned.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CFArrayRef CGImageDestinationCopyTypeIdentifiers (){};


/*CGImageDestinationCreateWithData

Creates an image destination that writes to a Core Foundation mutable data object.

CGImageDestinationRef CGImageDestinationCreateWithData(
   CFMutableDataRef data,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);
Parameters
data

The data object to write to.
type

The uniform type identifier (UTI) of the resulting image file.
count

The number of images (not including thumbnail images) that the image file will contain.
options

Reserved for future use. Pass NULL.
Return Value

A Quartz image destination. You are responsible for releasing this object using CFRelease.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CGImageDestinationRef CGImageDestinationCreateWithData(
   CFMutableDataRef data,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
){};


/*kCGImagePropertyTIFFDictionary Keys

Define possible keys for kCGImagePropertyTIFFDictionary.

const CFStringRef kCGImagePropertyTIFFCompression
const CFStringRef kCGImagePropertyTIFFPhotometricInterpretation
const CFStringRef kCGImagePropertyTIFFDocumentName
const CFStringRef kCGImagePropertyTIFFImageDescription
const CFStringRef kCGImagePropertyTIFFMake
const CFStringRef kCGImagePropertyTIFFModel
const CFStringRef kCGImagePropertyTIFFOrientation
const CFStringRef kCGImagePropertyTIFFXResolution
const CFStringRef kCGImagePropertyTIFFYResolution
const CFStringRef kCGImagePropertyTIFFResolutionUnit
const CFStringRef kCGImagePropertyTIFFSoftware
const CFStringRef kCGImagePropertyTIFFTransferFunction
const CFStringRef kCGImagePropertyTIFFDateTime
const CFStringRef kCGImagePropertyTIFFArtist
const CFStringRef kCGImagePropertyTIFFHostComputer
const CFStringRef kCGImagePropertyTIFFCopyright
const CFStringRef kCGImagePropertyTIFFWhitePoint
const CFStringRef kCGImagePropertyTIFFPrimaryChromaticities
Constants
kCGImagePropertyTIFFCompression

Specifies TIFF compression.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFPhotometricInterpretation

Specifies TIFF photometric interpretation.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFDocumentName

Specifies the TIFF document name.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFImageDescription

Specifies a TIFF image description.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFMake

Specifies a TIFF make.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFModel

Specifies a TIFF model.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFOrientation

Specifies TIFF orientation.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFXResolution

Specifies the x resolution of the TIFF.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFYResolution

Specifies the y resolution of the TIFF. 

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFResolutionUnit

Specifies the units of resolution.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFSoftware

Specifies the TIFF software.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFTransferFunction

Specifies the TIFF transfer function.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFDateTime

Specifies the TIFF date and time.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFArtist

Specifies the artist.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFHostComputer

Specifies the host computer.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFCopyright

Specifies copyright information.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFWhitePoint

Specifies the white point.

Available in Mac OS X v10.4 and later.
kCGImagePropertyTIFFPrimaryChromaticities

Specifies the primary chromaticities.

Available in Mac OS X v10.4 and later.*/

 const CFStringRef kCGImagePropertyTIFFCompression;
 const CFStringRef kCGImagePropertyTIFFPhotometricInterpretation;
 const CFStringRef kCGImagePropertyTIFFDocumentName;
 const CFStringRef kCGImagePropertyTIFFImageDescription;
 const CFStringRef kCGImagePropertyTIFFMake;
 const CFStringRef kCGImagePropertyTIFFModel;
 const CFStringRef kCGImagePropertyTIFFOrientation;
 const CFStringRef kCGImagePropertyTIFFXResolution;
 const CFStringRef kCGImagePropertyTIFFYResolution;
 const CFStringRef kCGImagePropertyTIFFResolutionUnit;
 const CFStringRef kCGImagePropertyTIFFSoftware;
 const CFStringRef kCGImagePropertyTIFFTransferFunction;
 const CFStringRef kCGImagePropertyTIFFDateTime;
 const CFStringRef kCGImagePropertyTIFFArtist;
 const CFStringRef kCGImagePropertyTIFFHostComputer;
 const CFStringRef kCGImagePropertyTIFFCopyright;
 const CFStringRef kCGImagePropertyTIFFWhitePoint;
 const CFStringRef kCGImagePropertyTIFFPrimaryChromaticities;

/*Destination Properties

Specify properties for a single image in an image destination.

const CFStringRef kCGImageDestinationLossyCompressionQuality
const CFStringRef kCGImageDestinationBackgroundColor
Constants
kCGImageDestinationLossyCompressionQuality

Specifies the desired compression quality to use when writing to an image destination. If present, the value associated with this key must be a CFNumberRef data type in the range 0.0 to 1.0. A value of 1.0 specifies to use lossless compression if destination format supports it. A value of 0.0 implies to use maximum compression.

Available in Mac OS X v10.4 and later.
kCGImageDestinationBackgroundColor

Specifies the desired background color to composite against when writing an image that has an alpha component to a destination format that does not support alpha. If present, the value associated with this key must be a CGColorRef data type without an alpha component of its own. If not present, and if a background color is needed, a white color is used.

Available in Mac OS X v10.4 and later.*/

const CFStringRef kCGImageDestinationLossyCompressionQuality;
const CFStringRef kCGImageDestinationBackgroundColor;

/*Image Source Container Properties

Define properties that apply to the container in general but not necessarily to any individual image in the container.

CFStringRef kCGImagePropertyFileSize;
Constants
kCGImagePropertyFileSize

The size of the image file in bytes, if known. If present, this key is a CFNumber value. 

Available in Mac OS X v10.4 and later.
Discussion

These properties can be returned by the function CGImageSourceCopyProperties.*/
const CFStringRef kCGImagePropertyFileSize;



/*Format-Specific Dictionaries

Specifies keys for dictionaries that contain a dictionary of file-format or metadata-format specific key-values.

CFStringRef kCGImagePropertyTIFFDictionary
CFStringRef kCGImagePropertyGIFDictionary
CFStringRef kCGImagePropertyJFIFDictionary
CFStringRef kCGImagePropertyExifDictionary
CFStringRef kCGImagePropertyPNGDictionary
CFStringRef kCGImagePropertyIPTCDictionary
CFStringRef kCGImagePropertyGPSDictionary
CFStringRef kCGImagePropertyRawDictionary
CFStringRef kCGImagePropertyCIFFDictionary
CFStringRef kCGImageProperty8BIMDictionary
Constants
kCGImagePropertyTIFFDictionary

Specifies a dictionary of key-value pairs for a TIFF image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyGIFDictionary

Specifies a dictionary of key-value pairs for a GIF image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyJFIFDictionary

Specifies a dictionary of key-value pairs for a JFIF image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyExifDictionary

Specifies a dictionary of key-value pairs for a Exif image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPNGDictionary

Specifies a dictionary of key-value pairs for a PNG image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyIPTCDictionary

Specifies a dictionary of key-value pairs for a IPTC image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyGPSDictionary

Specifies a dictionary of key-value pairs for a GPS image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyRawDictionary

Specifies a dictionary of key-value pairs for a Raw image.

Available in Mac OS X v10.4 and later.
kCGImagePropertyCIFFDictionary

Specifies a dictionary of key-value pairs for a CIFF image.

Available in Mac OS X v10.4 and later.
kCGImageProperty8BIMDictionary

Specifies a dictionary of key-value pairs for an 8BIM image.

Available in Mac OS X v10.4 and later.
Discussion

Format-specific are returned by the functions CGImageSourceCopyPropertiesor CGImageSourceCopyPropertiesAtIndex and contain key-value pairs that describe file-format or metadata-format information.*/

const CFStringRef kCGImagePropertyTIFFDictionary;
const  CFStringRef kCGImagePropertyGIFDictionary;
 const  CFStringRef kCGImagePropertyJFIFDictionary;
const  CFStringRef kCGImagePropertyExifDictionary;
const CFStringRef kCGImagePropertyPNGDictionary;
 const CFStringRef kCGImagePropertyIPTCDictionary;
 const CFStringRef kCGImagePropertyGPSDictionary;
 const CFStringRef kCGImagePropertyRawDictionary;
const CFStringRef kCGImagePropertyCIFFDictionary;
const CFStringRef kCGImageProperty8BIMDictionary;


/*Individual Image Properties

Defines properties that apply to an individual image in an image source.

CFStringRef kCGImagePropertyDPIHeight;
CFStringRef kCGImagePropertyDPIWidth;
CFStringRef kCGImagePropertyPixelWidth;
CFStringRef kCGImagePropertyPixelHeight;
CFStringRef kCGImagePropertyDepth;
CFStringRef kCGImagePropertyOrientation;
CFStringRef kCGImagePropertyIsFloat;
CFStringRef kCGImagePropertyIsIndexed;
CFStringRef kCGImagePropertyHasAlpha;
CFStringRef kCGImagePropertyColorModel;
CFStringRef kCGImagePropertyProfileName;
CFStringRef kCGImagePropertyCompressQuality;
Constants
kCGImagePropertyDPIHeight

The resolution, in dots per inch, in the x dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyDPIWidth

The resolution, in dots per inch, in the y dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPixelWidth

The number of pixels in the x dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPixelHeight

The number of pixels in the y dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyDepth

The number of bits in each color sample of each pixel. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyOrientation

The intended display orientation of the image. If present, this key is a CFNumber value with the same value as defined by the TIFF and Exif specifications. The value specifies where the origin (0,0) of the image is locates, as shown in Table 1. If not present, a value of 1 is assumed.
Table 1  
Value	
Location of the origin of the image

1	
Top, left 

2	
Top, right 

3	
Bottom, right 

4	
Bottom, left 

5	
Left, top 

6	
Right, top 

7	
Right, bottom 

8	
Left, bottom 


Available in Mac OS X v10.4 and later.
kCGImagePropertyIsFloat

Specifies whether or not the image contains floating-point pixel samples. The value of this key is kCFBooleanTrue if the image contains them.

Available in Mac OS X v10.4 and later.
kCGImagePropertyIsIndexed

Specifies whether or not the image contains indexed pixel samples (sometimes called paletted samples). The value of this key is kCFBooleanTrue if the image contains them.

Available in Mac OS X v10.4 and later.
kCGImagePropertyHasAlpha

Specifies whether or not the image has an alpha channel. The value of this key is kCFBooleanTrue if the image contains an alpha channel.

Available in Mac OS X v10.4 and later.
kCGImagePropertyColorModel

The color model of the image such as, "RGB", "CMYK", "Gray", or "Lab". The value of this key is CFStringRef.

Available in Mac OS X v10.4 and later.
kCGImagePropertyProfileName

The name of the optional ICC profile embedded in the image, if known. If present, the value of this key is a CFStringRef.

Available in Mac OS X v10.4 and later.
kCGImagePropertyCompressionQuality

The desired compression quality to use when writing to an image destination. If present, this key is a CFNumber value in the range 0.0 to 1.0.
Discussion

These properties can be returned by the function CGImageSourceCopyPropertiesAtIndex.*/
 const CFStringRef kCGImagePropertyDPIHeight;
 const CFStringRef kCGImagePropertyDPIWidth;
const CFStringRef kCGImagePropertyPixelWidth;
const CFStringRef kCGImagePropertyPixelHeight;
const CFStringRef kCGImagePropertyDepth;
 const CFStringRef kCGImagePropertyOrientation;
const CFStringRef kCGImagePropertyIsFloat;
 const CFStringRef kCGImagePropertyIsIndexed;
 const CFStringRef kCGImagePropertyHasAlpha;
const CFStringRef kCGImagePropertyColorModel;
 const CFStringRef kCGImagePropertyProfileName;
 const CFStringRef kCGImagePropertyCompressQuality;



/*Image Source Option Dictionary Keys

Define keys for the options dictionary used to create an image source.

CFStringRef kCGImageSourceTypeIdentifierHint;
CFStringRef kCGImageSourceShouldAllowFloat;
CFStringRef kCGImageSourceShouldCache;
CFStringRef kCGImageSourceShouldToneCompressFloat;
CFStringRef kCGImageSourceCreateThumbnailFromImageIfAbsent;
CFStringRef kCGImageSourceCreateThumbnailFromImageAlways;
CFStringRef kCGImageSourceThumbnailMaxPixelSize;
CFStringRef kCGImageSourceCreateThumbnailWithTransform
Constants
kCGImageSourceTypeIdentifierHint

Specifies the best guess of the uniform type identifier (UTI) for the format of the image source file. If specified, the value of this key must be a CFString object. This key can be provided in the options dictionary when you create a CGImageSource object.

Available in Mac OS X v10.4 and later.
kCGImageSourceShouldAllowFloat

Specifies whether the image should be returned as a CGImage object that uses floating-point values, if supported by the file format. CGImage objects that use extended-range floating-point values may require additional processing to render in a pleasing manner. The value of this key must be a CFBoolean value. The default value is kCFBooleanFalse.

Available in Mac OS X v10.4 and later.
kCGImageSourceShouldCache

Specifies whether the image should be cached in a decoded form. The value of this key must be a CFBoolean value. The default value is kCFBooleanTrue. This key can be provided in the options dictionary that you can pass to the functions CGImageSourceCopyPropertiesAtIndex and CGImageSourceCreateImageAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceShouldToneCompressFloat

Specifies whether the image should have tone compression applied if needed. With this option, an image that contains extended-range floating-point pixel samples is compressed into the standard range of 0 to 1. The value of this key must be a CFBoolean value. The default value is kCFBooleanFalse.
kCGImageSourceCreateThumbnailFromImageIfAbsent

Specifies whether a thumbnail should be automatically created for an image if a thumbnail isn't present in the image source file. The thumbnail is created from the full image, subject to the limit specified by kCGImageSourceThumbnailMaxPixelSize. If a maximum pixel size isn't specified, then the thumbnail is the size of the full image, which in most cases is not desirable. This key must be a CFBoolean value. The default value is kCFBooleanFalse. This key can be provided in the options dictionary that you pass to the function CGImageSourceCreateThumbnailAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceCreateThumbnailFromImageAlways

Specifies whether a thumbnail should be created from the full image even if a thumbnail is present in the image source file. The thumbnail is created from the full image, subject to the limit specified by kCGImageSourceThumbnailMaxPixelSize. If a maximum pixel size isn't specified, then the thumbnail is the size of the full image, which probably isn't what you want. This key must be a CFBoolean value. The default value is kCFBooleanFalse. This key can be provided in the options dictionary that you can pass to the function CGImageSourceCreateThumbnailAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceThumbnailMaxPixelSize

Specifies the maximum width and height in pixels of a thumbnail. If this key is not specified, the width and height of a thumbnail is not limited and thumbnails may be as big as the image itself. If present, this key must be a CFNumber value. This key can be provided in the options dictionary that you pass to the function CGImageSourceCreateThumbnailAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceCreateThumbnailWithTransform

Specifies whether the thumbnail should be rotated and scaled according to the orientation and pixel aspect ratio of the full image. The value of this key must be a CFBoolean value. The default value is kCFBooleanFalse.

Available in Mac OS X v10.4 and later.*/
 const CFStringRef kCGImageSourceTypeIdentifierHint;
const CFStringRef kCGImageSourceShouldAllowFloat;
 const CFStringRef kCGImageSourceShouldCache;
 const CFStringRef kCGImageSourceShouldToneCompressFloat;
 const CFStringRef kCGImageSourceCreateThumbnailFromImageIfAbsent;
const CFStringRef kCGImageSourceCreateThumbnailFromImageAlways;
const CFStringRef kCGImageSourceThumbnailMaxPixelSize;
 const CFStringRef kCGImageSourceCreateThumbnailWithTransform;
