#ifndef OPENSCRIPTING_H
#include <OpenScripting/OpenScripting.h>
#endif

/*OSADisplay

Converts a script value to text. Your application can then use its own functions to display this text to the user. 

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptValueID

The script ID for the script value to coerce. See the OSAID data type.
desiredType

The desired text descriptor type, such as typeChar, for the resulting descriptor record. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To make the resulting text readable by humans only, so that it can’t be recompiled, specify kOSAModeDisplayForHumans. 
resultingText

A pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSADisplay function coerces the script value identiﬁed by scriptValueID to a descriptor record of the text type speciﬁed by the desiredType parameter, if possible. Valid types include the standard text descriptor types, plus any special types supported by the scripting component.

Unlike OSAGetSource, OSADisplay can coerce only script values and always produces a descriptor record of a text descriptor type. In addition, if you specify the mode ﬂag kOSAModeDisplayForHumans, the resulting text cannot be recompiled. 

If you want to get a script value in a form that you can display for humans to read, use OSADisplay. If you want the descriptor type of the descriptor record returned in the resultingText parameter to be the same as the descriptor type returned by a scripting component, use OSACoerceToDesc and specify typeWildCard as the desired type.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText){
//TODO
};


/*OSADispose

Reclaims the memory occupied by script data. 

OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script data to be disposed of. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSADispose function releases the memory assigned to the script data identiﬁed by the scriptID parameter. The script ID passed to the OSADispose function is no longer valid if the function returns successfully. A scripting component can then reuse that script ID for other script data. 

A call to OSADispose returns noErr if the script ID is kOSANullScript, although it does not dispose of anything. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID){
//TODO
};


/*OSAScriptError

Gets information about errors that occur during script execution. 

OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
selector

A value that determines what OSAScriptError returns. The value can be one of the constants described in “OSAScriptError Selectors”.
desiredType

The desired descriptor type of the resulting descriptor record. The description that follows explains how this is determined by the value passed in the selector parameter.
resultingErrorDescription

On return, a pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

Whenever the OSAExecute function returns the error errOSAScriptError, you can use the OSAScriptError function to get more speciﬁc information about the error from the scripting component that encountered it. (This information remains available only until the next call to the same scripting component.) The information returned by OSAScriptError depends on the value passed in the selector parameter, which also determines the descriptor type you should specify in the desiredType parameter.

Every scripting component should support calls to OSAScriptError that pass kOSAErrorNumber, kOSAErrorMessage, or kOSAErrorPartialResult in the selector parameter.

Some scripting components may also support calls that pass other values in the selector parameter, including kOSAErrorRange, which provides start and end positions delimiting the errant expression in the source data. If the value of the selector parameter is kOSAErrorRange, the value of desiredType must be typeOSAErrorRange.

If the value of the selector parameter is kOSAErrorNumber, scripting components may return, in the resultingErrorDescription parameter, one of the general error codes described in “Result Codes”.

If you call OSAScriptError using an instance of the generic scripting component, the generic scripting component uses the same instance of a scripting component that it used for the previous call. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription){
//TODO
};

/*OSALoad

Loads script data. 

OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptData

A pointer to the descriptor record containing the script data to be loaded. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To indicate that only the minimum script data required to run the script should be loaded, pass kOSAModePreventGetSource in this parameter. 
resultingScriptID

On return, a pointer to the script ID for the compiled script. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSALoad function loads script data and returns a script ID. The generic scripting component uses the descriptor record in the scriptData parameter to determine which scripting component should load the script. If the descriptor record is of type typeOSAGenericStorage, the generic scripting component uses the trailer at the end of the script data to identify the scripting component. If the descriptor record’s type is the subtype value for another scripting component, the generic scripting component uses the descriptor type to identify the scripting component.

If you want the script ID returned by OSALoad to identify only the minimum script data required to run the script and you are sure that you won’t need to display the source data to the user, specify the kOSAModePreventGetSource ﬂag in the modeFlags parameter.

Scripting components other than the generic scripting component can load script data only if it has been saved in a descriptor record whose descriptor type matches the scripting component’s subtype. 

Script data may change after it has been loaded—for example, if your application allows the user to edit a script’s source data. To test whether script data has been modiﬁed, pass its script ID to OSAGetScriptInfo. If it has changed, you can call OSAStore again to obtain a handle to the modiﬁed script data and save it. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID){
//TODO
};


/*OSAExecuteEvent

Handles an Apple event with the aid of a script context and obtains a script ID for the resulting script value. 

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theAppleEvent

A pointer to the Apple event to be handled. 
contextID

The script ID for the script context to be used to handle the Apple event. See the OSAID data type.
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. Other possible mode ﬂags are listed in “Mode Flags”. 
resultingScriptValueID

A pointer to the script ID for the resulting script value. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSAExecuteEvent function attempts to use the script context speciﬁed by the contextID parameter to handle the Apple event specified by the theAppleEvent parameter. If the scripting component determines that the script context can’t handle the event (for example, if a script written in AppleScript doesn’t include statements that handle the event), OSAExecuteEvent immediately returns errAEEventNotHandled rather than errOSAScriptError. This causes the Apple Event Manager to look for an appropriate handler in the application’s Apple event dispatch table or elsewhere, using standard Apple event dispatching.

If the scripting component determines that the script context can handle the event, OSAExecuteEvent executes the script context’s handler and returns the resulting script ID. If execution of the script context’s handler for the event generates an error, OSAExecuteEvent returns errOSAScriptError, and you can get more detailed error information by calling the OSAScriptError function. 

If the script context identiﬁed by the contextID parameter speciﬁes that the Apple event should be passed to the application’s default handler for that event (for example, with an AppleScript continue statement), OSAExecuteEvent passes the event to the resume dispatch function currently being used by the scripting component. The resume dispatch function dispatches the event directly to the application’s standard handler for that event (that is, without calling OSAExecuteEvent again). If the contextID parameter is kOSANullScript, the OSAExecuteEvent function passes the event directly to the resume dispatch function. If a call to the resume dispatch function is successful, execution of the script context proceeds from the point at which the resume dispatch function was called. 
Special Considerations

The OSAExecuteEvent function can generate the result code errAEEventNotHandled in at least two ways. If the scripting component determines that a script context doesn’t declare a handler for a particular event, OSAExecuteEvent immediately returns errAEEventNotHandled. If a scripting component calls its resume dispatch function during script execution and the application’s standard handler for the event fails to handle it, OSAExecuteEvent returns errOSAScriptError and a call to OSAScriptError with kOSAErrorNumber in the selector parameter returns errAEEventNotHandled as the resulting error description.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID){
//TODO
};

/*OSACoerceToDesc

Coerces a script value to a descriptor record of a desired descriptor type. 

OSAError OSACoerceToDesc (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * result
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script value to coerce. See the OSAID data type.
desiredType

The desired descriptor type of the resulting descriptor record. 
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. 
result

A pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSACoerceToDesc function coerces the script value identiﬁed by scriptValueID to a descriptor record of the type speciﬁed by the desiredType parameter, if possible. Valid types include all the standard descriptor types, plus any special types supported by the scripting component. 

If you want the descriptor type of the descriptor record returned in the result parameter to be the same as the descriptor type returned by a scripting component, use OSACoerceToDesc and specify typeWildCard as the desired type. If you want to get a script value in a form that you can display for humans to read, use OSADisplay. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSACoerceToDesc (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * result
){};


/*OSADoEvent

Handles an Apple event with the aid of a script context and obtains a reply event. 

OSAError OSADoEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   AppleEvent * reply
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theAppleEvent

A pointer to the Apple event to be handled. 
contextID

The script ID for the script context to be used to handle the Apple event. See the OSAID data type.
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. Other possible mode ﬂags are listed in “Mode Flags”. 
reply

A pointer to the reply Apple event.
Return Value

A result code. See “Result Codes”.
Discussion

The OSADoEvent function resembles both OSADoScript and OSAExecuteEvent. However, unlike OSADoScript, the script OSADoEvent executes must be in the form of a script context, and execution is initiated by an Apple event. Unlike OSAExecuteEvent, OSADoEvent returns a reply Apple event rather than the script ID of the resulting script value. 

The OSADoEvent function, like OSAExecuteEvent, attempts to use the script context speciﬁed by the contextID parameter to handle the Apple event speciﬁed by the theAppleEvent parameter. If the scripting component determines that the script context can’t handle the event (for example, if a script written in an AppleScript dialect doesn’t include statements that handle the event), OSADoEvent immediately returns errAEEventNotHandled rather than errOSAScriptError. This causes the Apple Event Manager to look for an appropriate handler in the application’s Apple event dispatch table or elsewhere, using standard Apple event dispatching.

If the scripting component determines that the script context can handle the event, OSADoEvent executes the script context’s handler for the event and returns the resulting script ID. 

The OSADoEvent function returns a reply event that contains either the resulting script value or, if an error occurred during script execution, information about the error. If the error errOSAScriptError occurs during script execution, OSADoEvent calls OSAScriptError and returns the appropriate error information in the reply. The OSADoEvent function never returns errOSAScriptError. 

If the script context speciﬁes that the Apple event should be passed to the application’s standard handler for that event (for example, with an AppleScript continue statement), OSADoEvent passes the event to the resume dispatch function currently being used by the scripting component. The resume dispatch function dispatches the event directly to the application’s standard handler for that event (that is, without calling OSADoEvent again). If the contextID parameter is kOSANullScript, the OSADoEvent function passes the event directly to the resume dispatch function. If the call to the resume dispatch function is successful, execution of the script context proceeds from the point at which the resume dispatch function was called.
Special Considerations

Like OSAExecuteEvent, OSADoEvent can generate the result code errAEEventNotHandled in at least two ways. If the scripting component determines that a script context doesn’t declare a handler for a particular event, OSADoEvent immediately returns errAEEventNotHandled. If a scripting component calls its resume dispatch function during script execution and the application’s standard handler for the event fails to handle it, OSADoEvent returns errAEEventNotHandled in the reply Apple event.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADoEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   AppleEvent * reply
){};

/*OSAGetScriptInfo

Obtains information about script data according to the value you pass in the selector parameter.

OSAError OSAGetScriptInfo (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   OSType selector,
   long * result
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent.
scriptID

The script ID for the script data about which to obtain information. See the OSAID data type.
selector

A value that determines what kind of information OSAGetScriptInfo returns. The value can be one of the constants described in “Script Information Selectors”. In addition to the standard constants, the AppleScript component also supports the kASHasOpenHandler constant. For additional information, see the Version Notes section below.
result

On return, a pointer to the requested information, which you can coerce to the appropriate descriptor type for the value speciﬁed in the selector parameter.
Return Value

A result code. See “Result Codes”.
Version Notes

In Mac OS X, if you specify kOSAScriptIsModified for the value of the selector parameter, OSAGetScriptInfo returns true if the script has been modified and false if it has not.

The following information describes the behavior of OSAGetScriptInfo in versions of the Mac OS prior to Mac OS X: Although you can specify kOSAScriptIsModified when you are using the AppleScript component without generating an error, the current version of AppleScript interprets this request conservatively. The AppleScript component stores script data in a network of interlocking structures, and running a script can cause any of these structures to be modiﬁed. If you pass a script ID is to OSAGetScriptInfo with kOSAScriptIsModified as the value of the selector parameter, the AppleScript component returns 1 if there is any possibility that the script data or related structures may have been modiﬁed, and 0 if there is no possibility that they have been modiﬁed.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAGetScriptInfo (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   OSType selector,
   long * result
){};


/*OSAStore

Gets a handle to script data in the form of a storage descriptor record.

OSAError OSAStore (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingScriptData
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script data for which to obtain a data handle. 
desiredType

The desired type of the descriptor record to be returned. If you want to store the script data in the form used by a generic storage descriptor record, specify typeOSAGenericStorage. 
modeFlags

Information used by individual scripting components. To avoid setting any mode flags, specify kOSAModeNull. To indicate that only the minimum script data required to run the script should be returned, pass kOSAModePreventGetSource in this parameter. (In this case the script data returned is not identical to the compiled script data and can’t be used to generate source data.) If the scriptID parameter identiﬁes a script context, you can pass kOSAModeDontStoreParent in this parameter to store the script context without storing its parent context.
resultingScriptData

On return, a pointer to the resulting descriptor record.
Return Value

A result code. See “Result Codes”.
Discussion

The OSAStore function writes script data to a descriptor record so that the data can later be saved in a resource or written to the data fork of a document. You can then reload the data for the descriptor record as a compiled script (although possibly with a different script ID) by passing the descriptor record to OSALoad. 

If you want the returned script data to be as small as possible and you are sure that you won’t need to display the source data to the user, specify the kOSAModePreventGetSource flag in the modeFlags parameter. If the scriptID parameter identiﬁes a script context and you don’t want the returned script data to include the associated parent context, specify the kOSAModeDontStoreParent ﬂag in the modeFlags parameter. 

The desired type is either typeOSAGenericStorage (for a generic storage descriptor record) or a speciﬁc scripting component subtype value (for a component-speciﬁc storage descriptor record). 

To store either a generic storage descriptor record or a component-speciﬁc storage descriptor record with your application’s resources, use 'scpt' as the resource type. The generic scripting component subtype, the generic storage descriptor type, and the resource type for stored script data all have the same value, though they serve different purposes. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAStore (
   ComponentInstance scriptingComponent,
   OSAID scriptID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingScriptData
){};

/*OSAGenericToRealID

Converts a generic script ID to the corresponding component-speciﬁc script ID. 

OSAError OSAGenericToRealID (
   ComponentInstance genericScriptingComponent,
   OSAID * theScriptID,
   ComponentInstance * theExactComponent
);
Parameters
genericScriptingComponent

A component instance for the generic scripting component, created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theScriptID

A pointer to the generic script ID that you want to convert. The OSAGenericToRealID function returns, in this parameter, the component-speciﬁc script ID that corresponds to the generic script ID that you pass in this parameter. See the OSAID data type.
theExactComponent

On return, a pointer to the component instance that created the script ID returned in the theScriptID parameter. 
Return Value

A result code. See “Result Codes”.
Discussion

You can’t use the generic scripting component and a generic script ID with component-speciﬁc routines. Instead, you can use the component instance and script ID returned by OSAGenericToRealID. 

Given a generic script ID (that is, a script ID returned by a call to a standard component routine via the generic scripting component), the OSAGenericToRealID function returns the equivalent component-speciﬁc script ID and the component instance that created that script ID. The OSAGenericToRealID function modiﬁes the script ID in place, changing the generic script ID you pass in the theScriptID parameter to the corresponding component-speciﬁc script ID. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSAGeneric.h*/
OSAError OSAGenericToRealID (
   ComponentInstance genericScriptingComponent,
   OSAID * theScriptID,
   ComponentInstance * theExactComponent
){};

/*OSAGetHandlerNames

Gets a list of all handler names in the specified script as an AEDescList of descriptors of type typeChar.

OSAError OSAGetHandlerNames (
   ComponentInstance scriptingComponent,
   long modeFlags,
   OSAID contextID,
   AEDescList * resultingHandlerNames
);
Parameters
scriptingComponent

Identifies the current scripting component. See the Component Manager documentation for a description of the ComponentInstance data type.
modeFlags

Information for use by the scripting component. No mode flags are applicable for this function, so pass the value kOSAModeNull. 
contextID

See the OSAID data type.
resultingHandlerNames

On return, a list of all handler names, as an AEDescList of descriptors of type typeChar. See Apple Event Manager Reference for a description of the AEDescList data type.
Return Value

A result code. See “Result Codes”.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
ASDebugging.h*/
OSAError OSAGetHandlerNames (
   ComponentInstance scriptingComponent,
   long modeFlags,
   OSAID contextID,
   AEDescList * resultingHandlerNames
){};





