#include <QuickTime/QuickTime.h>


/*SGPrepare

Instructs a sequence grabber to get ready to begin a preview or record operation.

ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
prepareForPreview

The sequence grabber component sets this parameter to TRUE to prepare for a preview operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
prepareForRecord

The sequence grabber component sets this parameter to TRUE to prepare for a record operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you do not call this function before starting a record or preview operation, the sequence grabber component makes these preparations when you start the operation. You cannot call this function after you start a preview or record operation. If you call this function without subsequently starting a record or preview operation, you should call SGRelease. This allows the sequence grabber component to release any system resources it allocated when you called this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord ){
printf ("SGPrepare", s , prepareForPreview, prepareForRecord);
};


/*PreviewShowData

Displays a preview if it does not handle events.

ComponentResult PreviewShowData (
   pnotComponent    p,
   OSType           dataType,
   Handle           data,
   const Rect       *inHere );
Parameters
p

Specifies your preview component. You obtain this identifier from OpenComponent.
dataType

The type of handle pointing to the data to be displayed in the preview.
data

A handle to the data, which is typically the same as the subtype of your preview component.
inHere

A pointer to a Rect structure that defines the area into which you draw the preview. The current port is set to the correct graphics port for drawing. You must not draw outside the given rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult PreviewShowData (
   pnotComponent    p,
   OSType           dataType,
   Handle           data,
   const Rect       *inHere ){
printf ("PreviewShowData",p,dataType,data,*inHere);
};

/*MovieImportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieImportDoUserDialog (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Handle                  theData,
   Boolean                 *canceled );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to a valid file specification. If the import request pertains to a file, the application must specify the source file with this parameter and set the theData parameter to NIL. If the request is for a handle, this parameter is set to NIL.
theData

A handle to the data to be imported. If the import request pertains to a handle, the application must specify the source of the data with this parameter, and set the theFile parameter to NIL. If the request is for a file, this parameter is set to NIL.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box; otherwise, set it to FALSE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If your component supports a user dialog box, be sure to set the hasMovieImportUserInterface flag in the componentFlags field of your component's ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportDoUserDialog (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Handle                  theData,
   Boolean                 *canceled ){
printf ("MovieImportDoUserDialog",ci,*theFile,theData,*canceled);
};


/*DisposeSGModalFilterUPP

Disposes of an SGModalFilterUPP pointer.

void DisposeSGModalFilterUPP (
   SGModalFilterUPP    userUPP );
Parameters
userUPP

An SGModalFilterUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeSGModalFilterUPP (
   SGModalFilterUPP    userUPP ){
printf ("DisposeSGModalFilterUPP",userUPP);
};




/*NewSGModalFilterUPP

Allocates a Universal Procedure Pointer for the SGModalFilterProc callback.

SGModalFilterUPP NewSGModalFilterUPP (
   SGModalFilterProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGModalFilterProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

SGModalFilterUPP NewSGModalFilterUPP (
   SGModalFilterProcPtr    userRoutine ){
printf ("NewSGModalFilterUPP",userRoutine);
};

/*SGGetVideoRect

Determines the portion of the source video image that is to be captured.

ComponentResult SGGetVideoRect (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive the dimensions of the rectangle that defines the portion of the source video image your component is going to capture.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetVideoRect (
   SGChannel    c,
   Rect         *r ){
printf ("SGGetVideoRect ",c,*r);
};

/*SGSetDataOutput

Specifies the movie file and options for a sequence grabber record operation.

ComponentResult SGSetDataOutput (
   SeqGrabComponent    s,
   const FSSpec        *movieFile,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
movieFile

A pointer to the FSSpec structure that identifies the movie file for this record operation.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk flag or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataOutput (
   SeqGrabComponent    s,
   const FSSpec        *movieFile,
   long                whereFlags ){
printf ("SGSetDataOutput ",s,*movieFile,whereFlags);
};



/*SGNewOutput

Creates a new sequence grabber output.

ComponentResult SGNewOutput (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags,
   SGOutput            *sgOut );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the destination container.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
sgOut

A pointer to a sequence grabber output. The sequence grabber component returns an output identifier that you can use with other sequence grabber component functions.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Once you have created the sequence grabber output, you can use SGSetChannelOutput to assign the output to a sequence grabber channel.
Version Notes

A sequence grabber output ties a sequence grabber channel to a specified data reference for the output of captured data. If you are capturing to a single movie file, you can continue to use SGSetDataOutput or SGSetDataRef to specify the sequence grabber's destination. However, if you want to capture movie data into several different files or data references, you must use sequence grabber outputs to do so. Even if you are using outputs, you must still use SGSetDataOutput or SGSetDataRef to identify where the sequence grabber should create the movie resource. You are responsible for creating outputs, assigning them to sequence grabber channels, and disposing of them when you are done.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewOutput (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags,
   SGOutput            *sgOut ){
printf ("SGNewOutput ",s,dataRef,dataRefType,whereFlags,*sgOut);
};


/*SGGrabPict

Lets your application obtain a Picture structure from a sequence grabber component.

ComponentResult SGGrabPict (
   SeqGrabComponent    s,
   PicHandle           *p,
   const Rect          *bounds,
   short               offscreenDepth,
   long                grabPictFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
p

A pointer to a field that is to receive a handle to the Picture structure. If the function cannot create the structure, it sets this handle to NIL.
bounds

A pointer to the boundary region for the Picture structure. By default, this rectangle lies in the current graphics port. If you set the grabPictOffScreen flag in the grabPictFlags parameter to 1, the sequence grabber places the structure in an offscreen graphics world. In this case, the rectangle is interpreted in that offscreen world.
offscreenDepth

The pixel depth for the offscreen graphics world. This parameter is typically set to 0, which chooses the best available depth. If you set the grabPictOffScreen flag in the grabPictFlags parameter to 1, the sequence grabber places the Picture structure in an offscreen graphics world. You specify the pixel depth of this offscreen graphics world with this parameter. If you are displaying the picture, this parameter is ignored.
grabPictFlags

Contains flags (see below) that control the operation. See these constants: 
grabPictOffScreen
grabPictIgnoreClip
grabPictCurrentImage
Return Value

See Error Codes. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabPict (
   SeqGrabComponent    s,
   PicHandle           *p,
   const Rect          *bounds,
   short               offscreenDepth,
   long                grabPictFlags ){
printf ("SGGrabPict",s,*p,*bounds,offscreenDepth,grabPictFlags);
};/*SGSetAdditionalSoundRates

Specifies a list of sound sample rates to be included in the sequence grabber's sound settings dialog box.

ComponentResult SGSetAdditionalSoundRates (
   SGChannel    c,
   Handle       rates );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
rates

A handle containing a list of unsigned 32-bit fixed-point values. The sequence grabber channel determines the number of sample rates contained in the handle, based on the size of the handle. If any of the requested rates are not supported directly by the available sound capture hardware, sound will be captured at one of the available hardware rates and then converted in software to the requested rate.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber channel makes a copy of the additional rates handle, so your application can immediately dispose of it after making this call.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetAdditionalSoundRates (
   SGChannel    c,
   Handle       rates ){
printf ("SGSetAdditionalSoundRates",c,rates);
};

/*SGSetChannelVolume

Sets a channel's sound volume.

ComponentResult SGSetChannelVolume (
   SGChannel    c,
   short        volume );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
volume

The volume setting of your channel represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelVolume (
   SGChannel    c,
   short        volume ){
printf ("SGSetChannelVolume",c,volume);
};



/*SGUpdate

Informs your component about update events, to update its display.

ComponentResult SGUpdate (
   SeqGrabComponent    s,
   RgnHandle           updateRgn );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
updateRgn

Indicates the part of the window that has been changed. 
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can determine the part of the window that has been changed by examining the appropriate window record. For example, they may call the sequence grabber in this manner:SGUpdate (theSG, ((WindowPeek)updateWindow)->
updateRgn);

Special Considerations

Your application should avoid drawing where the sequence grabber is displaying video. Doing so may cause some video digitizer components to stop displaying video.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGUpdate (
   SeqGrabComponent    s,
   RgnHandle           updateRgn ){
printf ("SGUpdate",s,updateRgn);
};


/*MovieExportSetSampleDescription

Requests the format of the exported data.

ComponentResult MovieExportSetSampleDescription (
   MovieExportComponent       ci,
   SampleDescriptionHandle    desc,
   OSType                     mediaType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
desc

A handle to a valid SampleDescription structure.
mediaType

The type of media the SampleDescription structure is for. For example, if the sample description was a sound description, this parameter would be set to SoundMediaType.
Return Value

See Error Codes. Returns badComponentSelector if you should be passing a QT atom container (see discussion, below). Returns noErr if there is no error.
Discussion

A movie export component may use all, some, or none of the settings from the SampleDescription structure.

If your application attempts to set the sample description using this function, and receives the badComponentSelector error, you may need to pass in the sample description using MovieExportSetSettingsFromAtomContainer. You can use MovieExportGetSettingsAsAtomContainer to obtain a correctly formatted atom container to modify.
Special Considerations

This function is not implemented by all movie export components, but is supported by the sound movie export component, for example.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetSampleDescription (
   MovieExportComponent       ci,
   SampleDescriptionHandle    desc,
   OSType                     mediaType ){
printf ("MovieExportSetSampleDescription",ci,desc,mediaType);
};


/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The client’s connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information––that is, a VBR format such as AAC–– allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a “pull” model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
){
printf ("SCAudioFillBuffer",ci,inInputDataProc,inInputDataProcRefCon,*ioOutputDataPacketSize,*outOutputData,*outPacketDescription);
};

/*TCSetDisplayOptions

Sets the text characteristics that apply to timecode information displayed in a movie.

HandlerError TCSetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
textOptions

A pointer to a TCTextOptions structure. This structure contains font and style information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCSetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions ){
printf ("TCSetDisplayOptions",mh,textOptions);
};



/*TCGetCurrentTimeCode

Retrieves the timecode and source identification information for the current movie time.

HandlerError TCGetCurrentTimeCode (
   MediaHandler      mh,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   UserData          *srcRefH );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
frameNum

A pointer to a field that is to receive the current frame number. Set this field to NIL if you don't want to retrieve the frame number.
tcdef

A pointer to a TimeCodeDef structure. The media handler returns the movie's timecode definition information. Set this parameter to NIL if you don't want this information.
tcrec

A pointer to a TimeCodeRecord structure. The media handler returns the current time value. Set this parameter to NIL if you don't want this information.
srcRefH

A pointer to a field that is to receive a handle containing the source information as a UserDataRecord structure. It is your responsibility to dispose of this structure when you are done with it. Set this field to NIL if you don't want this information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetCurrentTimeCode (
   MediaHandler      mh,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   UserData          *srcRefH ){
printf ("TCGetCurrentTimeCode",mh,*frameNum,*tcdef,*tcrec,*srcRefH);
};


/*DisposeSGDataUPP

Disposes of an SGDataUPP pointer.

void DisposeSGDataUPP (
   SGDataUPP    userUPP );
Parameters
userUPP

An SGDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeSGDataUPP (
   SGDataUPP    userUPP ){
printf ("DisposeSGDataUPP",userUPP);
};


/*SGSetChannelPlayFlags

Adjusts the speed and quality with which the sequence grabber displays data from a channel.

ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A long integer that contains flags (see below) that influence channel playback. A sequence grabber component must use one of these values. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags ){
printf ("SGSetChannelPlayFlags",c,playFlags);
};



/*SGGetChannelUsage

Determines how the sequence grabber component is using a channel.

ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

A pointer to a location that is to receive flags (see below) that specify how your channel is to be used. You may set more than one of these flags to 1. Set unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage ){
printf ("SGGetChannelUsage",c,*usage);
};

/*SGStartPreview

Instructs the sequence grabber to begin processing data from its channels.

ComponentResult SGStartPreview (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your channel component should immediately present the data to the user in the appropriate format, according to your channel's configuration. Display video data in the destination display region; play sound data at the specified volume settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartPreview (
   SeqGrabComponent    s ){
printf ("SGStartPreview ",s);
};


/*SGRelease

Instructs the sequence grabber to release any system resources it allocated when you called SGPrepare.

ComponentResult SGRelease (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record or preview operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGRelease (
   SeqGrabComponent    s ){
printf ("SGRelease",s);
};



/*SGGetChannelPlayFlags

Retrieves the playback control flags that you set with SGSetChannelPlayFlags.

ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A pointer to a long integer that is to receive flags (see below) that influence channel playback. Set unused flags to 0. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags ){
printf ("SGGetChannelPlayFlags",c,*playFlags);
};


/*SGSettingsDialog

Causes a sequence grabber to display its settings dialog box to the user.

ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
numPanels

The number of panel components to be listed in the panel component pop-up menu. You specify the panel components with the panelList parameter. You may use these parameters to limit the user's choice of panel components. If you set this parameter to 0 and the panelList parameter to NIL, the sequence grabber lists all available panel components.
panelList

A pointer to an array of component identifiers. The sequence grabber presents only these components in the panel component pop-up menu. You specify the number of identifiers in the array with the numPanels parameter. If you set this parameter to NIL, the sequence grabber lists all available panel components.
flags

Either set this to 0 or to seqGrabSettingsPreviewOnly (see below). See these constants: 
seqGrabSettingsPreviewOnly
proc

Specifies an SGModalFilterProc callback. Because the sequence grabber's settings dialog box is a movable modal dialog box, you must supply an event filter function to process update events in your window.
procRefNum

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. If the user clicks OK and the settings are acceptable to the panel and channel components, this function returns a result code of noErr.
Discussion

Because the user may change several channel configuration parameters, your application should retrieve new configuration information from the channel so that you can update any values you save, such as the channel's display boundaries or the channel device. In particular, the video rectangle for the channels may have to be adjusted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum ){
printf ("SGSettingsDialog",s,c,numPanels,panelList,flags,proc,procRefNum);
};
 
/*SGSetChannelUsage

Specifies how a channel is to be used by the sequence grabber component.

ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

Contains flags (see below) specifying how your channel is to be used. The sequence grabber component may set more than one of these flags to 1. It sets unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage ){
printf ("SGSetChannelUsage",c,usage);
};


/*SGGetPause

Determines whether the sequence grabber is paused.

ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
paused

A pointer to a field that is to receive a constant (see below) that indicates whether the sequence grabber is currently paused. See these constants: 
seqGrabUnpause
seqGrabPause
seqGrabPauseForMenu
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused ){
printf ("SGGetPause",s,*paused);
};



/*SGPause

Suspends or restarts a sequence grabber record or preview operation.

ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
pause

A constant (see below) that instructs your component to suspend or restart the current operation. See these constants: 
seqGrabUnpause
seqGrabPause
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component should not release any system resources or temporary memory associated with the current operation. You should be ready to restart the operation immediately.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause ){
printf ("SGPause ",s,pause);
};




/*SGStop

Stops a preview or record operation.

ComponentResult SGStop (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

It is dangerous to allow an update event to occur during recording. Many digitizers capture directly to the screen, and an update event will result in data loss.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStop (
   SeqGrabComponent    s ){
printf ("SGStop",s);
};

/*SGStartRecord

Instructs the sequence grabber component to begin collecting data from its channels.

ComponentResult SGStartRecord (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartRecord (
   SeqGrabComponent    s ){
printf ("SGStartRecord ",s);
};

/*SGIdle

Provides processing time for sequence grabber components.

ComponentResult SGIdle (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After starting a preview or record operation, the application calls this function as often as possible. The sequence grabber component then calls your SGIdle function. This continues until the calling application stops the operation by calling SGStop.Your SGIdle function reports several status and error conditions by means of its result code. If your component returns a nonzero result code during a record operation, the application should call SGStop so that the sequence grabber component can store the data it has collected.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGIdle (
   SeqGrabComponent    s ){
printf ("SGIdle",s);
};


/*SGSetMaximumRecordTime

Limits the duration of a record operation

ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ticks

The maximum duration for the record operation, in system ticks (sixtieths of a second). Set this parameter to 0 to remove the time limit from the operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By default, there is no time limit on a record operation. If you do not set a limit, a record operation will run until it exhausts the Operating System resources or you call SGStop. Memory and disk space are the two major limiting factors.
Special Considerations

You must call this function before you start a sequence grabber record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks ){
printf ("SGSetMaximumRecordTime",s,ticks);
};



/*SGSetChannelSettings

Configures a sequence grabber channel.

ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the channel component.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags ){
printf ("SGSetChannelSettings",s,c,ud,flags);
};

/*SGDisposeChannel

Removes a channel from a sequence grabber component.

ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The reference that identifies the channel you want to close. You obtain this reference from SGNewChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c ){
printf ("SGDisposeChannel",s,c);
};



/*SGGetChannelSettings

Retrieves the current settings of a channel used by the sequence grabber.

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

On return, a pointer to a UserDataRecord structure that contains the configuration information.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags ){
printf ("SGGetChannelSettings ",s,c,*ud,flags);
};

/*SGSetSettings

Configures a sequence grabber and its channels.

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the sequence grabber.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber disposes of any of its current channels before applying this configuration information. It then opens connections to new channels as appropriate.
Special Considerations

You can restore saved settings by using NewUserDataFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags ){
printf ("SGSetSettings",s,ud,flags);
};


/*SGGetIndChannel

Collects information about all of the channel components currently in use by a sequence grabber component.

ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
index

Specifies an index value that identifies the channel to be queried. The first channel has an index value of 1.
ref

A pointer to a field to receive a value identifying your connection to the channel. If you do not want to receive this information, set this parameter to NIL.
chanType

A pointer to a field to receive the channel's subtype value (see below). This value indicates the media type supported by the channel component. See these constants: 
VideoMediaType
SoundMediaType
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType ){
printf ("SGGetIndChannel ",s,index,*ref,*chanType);
};


/*SGGetSettings

Retrieves the current settings of all channels used by the sequence grabber.

ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A pointer to a space where the sequence grabber returns a pointer to a UserDataRecord structure that contains the configuration information. Your application is responsible for disposing of this structure when it is done with it.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags ){
printf ("SGGetSettings",s,*ud,flags);
};

/*(SGSetDataRef

Specifies the destination data reference for a record operation.

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the information that identifies the destination container.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to specify the destination for a record operation using a data reference, and to specify other options that govern the operation. This function is similar to SGSetDataOutput, and provides you with an alternative way to specify the destination.
Special Considerations

If you are performing a preview operation, you don't need to use this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags ){
printf ("SGSetDataRef ",s,dataRef,dataRefType,whereFlags);
};


/*SGInitialize

Initializes the sequence grabber component.

ComponentResult SGInitialize (
   SeqGrabComponent    s );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before you can call this function you must establish a connection to the sequence grabber component. Use OpenDefaultComponent or OpenComponent to establish a component connection, as shown below:// SGInitialize coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGInitialize (
   SeqGrabComponent    s ){
printf ("SGInitialize",s);
};

/*SGSetChannelBounds

Specifies a channel's display boundary rectangle.

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that defines your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds){
printf ("SGSetChannelBounds",c,*bounds);
};



/*SGSetGWorld

Establishes the graphics port and device for a sequence grabber component.

ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
gp

The destination graphics port, which must be a color graphics port. The sequence grabber component always sets this parameter to a valid value. To use the current graphics port, the parameter is set to NIL.
gd

A handle to the destination graphics device. The sequence grabber component always sets this parameter to a valid value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function if you are working with any channels that collect visual data. If you are working only with data that has no visual representation, you do not need to call this function. The sequence grabber component performs this operation implicitly when you call SGInitialize and the component uses your application's current graphics port. To set it to a specified window, use code such as the following:// SGSetGWorld coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Special Considerations

You cannot call this function during a record or preview operation, or after you have prepared the sequence grabber component for a record or preview operation by calling SGPrepare. The window in which the sequence grabber is to draw video frames as defined by this function must be visible before you call SGPrepare; otherwise, the sequence grabber does not display the frames properly.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd ){
printf ("SGSetGWorld",s,gp,gd);
};

/*SGGetChannelBounds

Determines a channel's display boundary rectangle.

ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that is to receive information about your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds ){
printf ("SGGetChannelBounds",c,*bounds);
};

/*SGGetChannelTimeScale

Lets the sequence grabber retrieve a channel's time scale.

ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
scale

A pointer to a time scale. Your channel component places information about its time scale into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The time scale you return typically corresponds to the time scale of the media that has been created by your channel. Applications may use this time scale in their data functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale ){
printf ("SGGetChannelTimeScale",c,*scale);
};


/*SGGetChannelSampleDescription

Retrieves a channel's sample description structure.

ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sampleDesc

A handle that is to receive the structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The channel returns a structure that is appropriate to the type of data being captured. For video channels, the channel component returns an ImageDescription structure; for sound channels, it receives a SoundDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc ){
printf ("SGGetChannelSampleDescription",c,sampleDesc);
};


/*SGGetSrcVideoBounds

Determines the size of the source video boundary rectangle.

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive information about your channel's source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

For video channel components that work with video digitizer components, the source video boundary rectangle corresponds to the video digitizer's active source rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r ){
printf ("SGGetSrcVideoBounds",c,*r);
};

/*SGDisposeDeviceList

Disposes of a device list.

ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
list

A pointer to a pointer to an SGDeviceListRecord structure. The sequence grabber disposes of the memory used by this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list ){
printf ("SGDisposeDeviceList",s,list);
};



/*SGGetChannelDeviceList

Retrieves a list of the devices that are valid for a specified channel.

ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
selectionFlags

Flags (see below) that control the data you are to return for each device. See these constants: 
sgDeviceListWithIcons
sgDeviceListDontCheckAvailability
sgDeviceListIncludeInputs
list

A pointer to a pointer to an SGDeviceListRecord structure. The channel creates this structure and returns a pointer to it in the field referred to by this parameter. Applications use SGDisposeDeviceList to dispose of the memory used by the list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function can be useful for retrieving the name of the current device. Retrieve the device list and use the selectedIndex field to determine which device is currently in use.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list ){
printf ("SGGetChannelDeviceList",c,selectionFlags,*list);
};

/*SGGetChannelDeviceAndInputNames

Returns the sequence grabber's current device and input names.

ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
outDeviceName

The current device names for display to the user.
outInputName

The current input names for display to the user.
outInputNumber

A pointer to the number of currently selected inputs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a utility call that lets you find out the sequence grabber's current device and input names, instead of having to call GetDeviceList and walk it yourself. Pass NIL for parameters you are not interested in.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber ){
printf ("SGGetChannelDeviceAndInputNames",c,outDeviceName,outInputName,*outInputNumber);
};

/*TCGetTimeCodeFlags

Retrieves the timecode control flags.

HandlerError TCGetTimeCodeFlags (
   MediaHandler    mh,
   long            *flags );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
flags

A pointer to a field that is to receive a control flag (see below). See these constants: 
tcdfShowTimeCode
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetTimeCodeFlags (
   MediaHandler    mh,
   long            *flags ){
printf ("TCGetTimeCodeFlags",mh,*flags);
};





/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci ){
printf ("SCRequestImageSettings",ci);
};


/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref ){
printf ("SGNewChannel",s,channelType,*ref);
};




/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon ){
printf ("SGGetChannelRefCon",c,*refCon);
};



/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon ){
printf ("SGSetChannelRefCon ",c,refCon);
};

/*SGSetDataProc

Specifies a data function for use by the sequence grabber.

ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
proc

A pointer to your data function. To remove your data function, set this parameter to NIL.
refCon

A reference constant. The sequence grabber provides this value to your data callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon ){
printf ("SGSetDataProc",s,proc,refCon);
};

/*SCCompressPictureFile

Compresses a Picture structure that is stored in a file.

ComponentResult SCCompressPictureFile (
   ComponentInstance    ci,
   short                srcRefNum,
   short                dstRefNum );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
srcRefNum

A reference to the file to be compressed.
dstRefNum

A reference to the file that is to receive the compressed data. This may be the same as the source file. The standard dialog component places the compressed image data into the file identified by this reference. Your application is responsible for this file after the compression operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressPictureFile (
   ComponentInstance    ci,
   short                srcRefNum,
   short                dstRefNum ){
printf ("SCCompressPictureFile",ci,srcRefNum,dstRefNum);
};

/*DataHGetInfoFlags

Provides information about the operation of a data handler component.

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags );
Parameters
dh

A data handler component.
flags

Flags (see below) that provide information about the data handler. See these constants: 
kDataHInfoFlagNeverStreams
kDataHInfoFlagCanUpdateDataRefs
kDataHInfoFlagNeedsNetworkBandwidth
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags ){
printf ("DataHGetInfoFlags ",dh,*flags);
};

/*VDGetDeviceNameAndFlags

Returns the current name and device visibility of a video digitizer.

VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
outName

The video digitizer device name.
outNameFlags

A pointer to a constant (see below) that determines whether to show or hide the VDIG device. See these constants: 
vdDeviceFlagShowInputsAsDevices
vdDeviceFlagHideDevice
Return Value

An error return of type ComponentResult. See Error Codes. Returns noErr if there is no error.
Discussion

This routine is designed to give the VDIG more control over how it is presented to the user, and to clarify the distinction between devices and inputs. Historically, the assumption has been that there is one component registered per device and that the component name is displayed. This function lets a component choose its name after registration. When this function is called, it is also a good time to check for hardware and register further VDIG components if needed, allowing for lazy initialization when the application needs to find a VDIG rather than initializing at every launch or replug.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags ){
printf ("VDGetDeviceNameAndFlags",ci,outName,*outNameFlags);
};

/*VDGetNumberOfInputs

Returns the number of input video sources that a video digitizer component supports.

VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputs

A pointer to an integer that is to receive the number of input video sources supported by the specified component. Video digitizer components number video sources sequentially, starting at 0. So, if a digitizer component supports two inputs, this function sets the field referred to by the inputs parameter to 1.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs ){
printf ("VDGetNumberOfInputs",ci,*inputs);
};


/*VDGetInputName

Gets the name of a video input.

VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name );
Parameters
ci

Specifies the video digitizer component for this operation. Applications can obtain this reference from OpenComponent or OpenDefaultComponent.
videoInput

The input video source for this request. Video digitizer components number video sources sequentially, starting at 0. So, to request information about the first video source, an application sets this parameter to 0. Applications can get the number of video sources supported by a video digitizer component by calling VDGetNumberOfInputs.
name

The video input source's name string.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name ){
printf ("VDGetInputName",ci,videoInput,name);
};


/*VDGetInput

Returns data that identifies the currently active input video source.

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
input

A pointer to a short integer that is to receive the identifier for the currently active input video source. Video digitizer components number video sources sequentially, starting at 0. So, if the first source is active, this function sets the field referred to by the input parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input ){
printf ("VDGetInput ",ci,*input);
};

/*VDGetSoundInputDriver

Retrieves information about a video digitizer's sound input driver.

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
soundDriverName

A pointer to a string. The video digitizer returns the name of its sound input driver. If the digitizer does not have an associated driver, it returns a result code of digiUnimpErr.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName ){
printf ("VDGetSoundInputDriver",ci,soundDriverName);
};


/*VDGetDataRate

Retrieves information that describes the performance capabilities of a video digitizer.

VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
milliSecPerFrame

A pointer to a long integer. The video digitizer returns a value that indicates the number of milliseconds of synchronous overhead involved in digitizing a single frame. This value includes the average delay incurred between the time when the digitizer requests a frame from its associated device, and the time at which the device delivers the frame.
framesPerSecond

A pointer to a fixed value. The video digitizer supplies the maximum rate at which it can capture video. Note that this value may differ from the rate that the application set with VDSetFrameRate.
bytesPerSecond

A pointer to a long integer. Video digitizers that can return compressed image data return a value that indicates the approximate number of bytes per second that the digitizer is generating compressed data, given the current compression and frame rate settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond ){
printf ("VDGetDataRate",*milliSecPerFrame,*framesPerSecond,*bytesPerSecond);
};


/*VDGetImageDescription

Retrieves an ImageDescription structure from a video digitizer.

VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
desc

A handle. The video digitizer fills this handle with an ImageDescription structure containing information about the digitizer's current compression settings. The digitizer resizes the handle appropriately. It is the application's responsibility to dispose of this handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc ){
printf ("VDGetImageDescription",ci,desc);
};


/*VDGetCurrentFlags

Returns status information about a specified video digitizer component.

VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputCurrentFlag

A pointer to a long integer that is to receive the current input state flags for the video digitizer component; see Video Digitizer Capabilities.
outputCurrentFlag

A pointer to a long integer that is to receive the current output state flags for the video digitizer component; see Video Digitizer Capabilities.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is often more convenient than VDGetDigitizerInfo. For example, this function provides a simple mechanism for determining whether a video digitizer is receiving a valid input signal. An application can retrieve the current input state flags and test the high-order bit by examining the sign of the returned value. If the value is negative (that is, the high-order bit, digiInSignalLock, is set to 1), the digitizer component is receiving a valid input signal.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag ){
printf ("VDGetCurrentFlags",ci,*inputCurrentFlag,*outputCurrentFlag);
};


/*MovieExportNewGetDataAndPropertiesProcs

Returns MovieExportGetPropertyProc and MovieExportGetDataProc callbacks that can be passed to MovieExportAddDataSource to create a new data source.

ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The format of the data to be generated by the returned MovieExportGetDataProc.
scale

The time scale returned from this function; this should be passed on to MovieExportAddDataSource with the procedures.
theMovie

The movie for this operation, supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
theTrack

The track for this operation. This track identifier is supplied by the Movie Toolbox.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exists in order to provide a standard way of getting data using this protocol out of a movie or track. The returned procedures must be disposed by calling MovieExportDisposeGetDataAndPropertiesProcs.
Special Considerations

This function is only implemented by movie data export components.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon ){
printf ("MovieExportNewGetDataAndPropertiesProcs",ci,trackType,scale,theMovie,theTrack,startTime,duration,getPropertyProc,getDataProc,refCon);
};


/*MovieExportAddDataSource

Defines a data source for use with an export operation performed by MovieExportFromProceduresToDataRef.

ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The type of media provided by this data source. This normally corresponds to a QuickTime media type such as VideoMediaType or SoundMediaType.
scale

The time scale for time values passed to getDataProc parameter. If the source data is being taken from a QuickTime track, this value is typically the media's time scale.
trackID

An identifier for the data source. This identifier is returned from the call.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before starting an export operation, all the data sources must be defined by calling this function once for each data source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon ){
printf("MovieExportAddDataSource",ci,trackType,scale,trackID,getPropertyProc,getDataProc,refCon);
};


/*MovieExportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theMovie

The movie containing the data to be exported.
onlyThisTrack

Specifies that the export component should only attempt to export the data from a single track. If this parameter is set to NIL, the exporter should attempt to export the entire movie, or all of the tracks in the movie that it can export. For example, an audio export component might export multiple audio tracks, mixing them if necessary. If this parameter is not NIL, the exporter should attempt to export only the specified track.
startTime

The movie time at which to begin the export operation. If you pass 0, the operation should start at the beginning of the movie or track.
duration

The duration, in movie timescale units, of the segment to be exported. To export the entire movie, or an entire track, pass in the value returned by GetMovieDuration or GetTrackDuration, minus the value passed in startTime, as described above.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box, otherwise FALSE. If the user cancels the dialog box, your component should revert to its settings as they were before executing this function.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled ){
printf("MovieExportDoUserDialog",ci,theMovie,onlyThisTrack,startTime,duration,*canceled);
};



/*DisposeMovieExportGetPropertyUPP

Disposes of a MovieExportGetPropertyUPP pointer.

void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP );
Parameters
userUPP

A MovieExportGetPropertyUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP ){
printf ("DisposeMovieExportGetPropertyUPP",userUPP);
};

/*DisposeMovieExportGetDataUPP

Disposes of a MovieExportGetDataUPP pointer.

void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP );
Parameters
userUPP

A MovieExportGetDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP ){
printf ("DisposeMovieExportGetDataUPP",userUPP);
};



/*MovieExportDisposeGetDataAndPropertiesProcs

Disposes of the memory associated with the procedures returned by MovieExportNewGetDataAndPropertiesProcs.

ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon ){
printf ("MovieExportDisposeGetDataAndPropertiesProcs",ci,getPropertyProc,getDataProc,refCon);
};

/*NewMovieExportGetPropertyUPP

Allocates a Universal Procedure Pointer for the MovieExportGetPropertyProc callback.

MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetPropertyProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine ){
printf ("NewMovieExportGetPropertyUPP",userRoutine);
};

/*NewMovieExportGetDataUPP

Allocates a Universal Procedure Pointer for the MovieExportGetDataProc callback.

MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine ){
printf ("NewMovieExportGetDataUPP",userRoutine);
};



/*MovieExportFromProceduresToDataRef

Exports data provided by MovieExportAddDataSource to a specified location.

ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference for the export operation.
dataRefType

The type identifier for the data reference specified by dataRef.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exports data provided by MovieExportAddDataSource to a location specified by dataRef and dataRefType. Typically dataRef contains a Macintosh file alias and dataRefType is set to rAliasType.
Special Considerations

Movie data export components that support export operations from procedures must set the canMovieExportFromProcedures flag in their component flags.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType ){
printf ("MovieExportFromProceduresToDataRef",ci,dataRef,dataRefType);
};





















































