//inclu

#ifndef AEOBJECTS_H
#define AEOBJECTS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef APPLEEVENTS_H
#include <AE/AppleEvents.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Key Form and Descriptor Type Object Specifier Constants

Specify possible values for the keyAEKeyForm field of an object specifier, as well as descriptor types used in resolving object specifiers.

enum {
   formAbsolutePosition = 'indx',
   formRelativePosition = 'rele',
   formTest = 'test',
   formRange = 'rang',
   formPropertyID = 'prop',
   formName = 'name',
   typeObjectSpecifier = 'obj ',
   typeObjectBeingExamined = 'exmn',
   typeCurrentContainer = 'ccnt',
   typeToken = 'toke',
   typeRelativeDescriptor = 'rel ',
   typeAbsoluteOrdinal = 'abso',
   typeIndexDescriptor = 'inde',
   typeRangeDescriptor = 'rang',
   typeLogicalDescriptor = 'logi',
   typeCompDescriptor = 'cmpd',
   typeOSLTokenList = 'ostl'
};
Constants
formAbsolutePosition

An integer or other constant indicating the position of one or more elements in relation to the beginning or end of their container. The key data consists of an integer that specifies either an offset or an ordinal position.

For descriptor type typeAbsoluteOrdinal, the data consists of one of the constants kAEFirst, kAEMiddle, kAELast, kAEAny, or kAEAll, which are described in AEDisposeToken.

For other descriptor types, the data can be coerced to either a positive integer, indicating the offset of the requested element from the beginning of the container, or a negative integer, indicating its offset from the end of the container.

Available in Mac OS X v10.0 and later.
formRelativePosition

Specifies an element position either immediately before or immediately after a container, not inside it. The key data is specified by a descriptor of type typeEnumerated whose data consists of one of the constants kAENext and kAEPrevious, which are described in AEDisposeToken. 

Available in Mac OS X v10.0 and later.
formTest

Specifies a test. The key data is specified by either a comparison descriptor or a logical descriptor.

The Apple Event Manager internally translates object specifiers of key form formTest into object specifiers of key form formWhose to optimize resolution of object specifiers. This involves collapsing the key form and key data from two object specifiers in a container hierarchy into one object specifier with the key form formWhose.

See also AEDisposeToken, “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”, CreateCompDescriptor, and CreateLogicalDescriptor.

Available in Mac OS X v10.0 and later.
formRange

Specifies a group of elements between two other elements. The key data is specified by a range descriptor, which is a coerced Apple event record of type typeRangeDescriptor that identifies two Apple event objects marking the beginning and end of a range of elements.

The data for a range descriptor consists of two keyword-specified descriptors with the keywords keyAERangeStart and keyAERangeStop.

Available in Mac OS X v10.0 and later.
formPropertyID

Specifies the property ID for an element’s property.

Available in Mac OS X v10.0 and later.
formName

Specifies the Apple event object by name.

Available in Mac OS X v10.0 and later.
typeObjectSpecifier

Specifies a descriptor used with the keyAEContainer keyword in a keyword-specified descriptor. The key data for the descriptor is an object specifier.

Available in Mac OS X v10.0 and later.
typeObjectBeingExamined

Specifies a descriptor that acts as a placeholder for each of the successive elements in a container when the Apple Event Manager tests those elements one at a time. The descriptor has a null data storage pointer. This descriptor type is used only with formTest.

Available in Mac OS X v10.0 and later.
typeCurrentContainer

Specifies a container for an element that demarcates one boundary in a range. The descriptor has a null data storage pointer. This descriptor type is used only with formRange.

Available in Mac OS X v10.0 and later.
typeToken

Specifies a descriptor whose data storage pointer refers to a structure of type AEDisposeToken.

Available in Mac OS X v10.0 and later.
typeRelativeDescriptor

Specifies a descriptor whose data consists of one of the constants kAENext or kAEPrevious, which are described in AEDisposeToken. Used with formRelativePosition.

Available in Mac OS X v10.0 and later.
typeAbsoluteOrdinal

Specifies a descriptor whose data consists of one of the constants kAEFirst, kAEMiddle, kAELast, kAEAny, or kAEAll, which are described in AEDisposeToken. Used with formAbsolutePosition.

Available in Mac OS X v10.0 and later.
typeIndexDescriptor

Specifies a descriptor whose data indicates an indexed position within a range of values.

Available in Mac OS X v10.0 and later.
typeRangeDescriptor

Specifies a range descriptor that identifies two Apple event objects marking the beginning and end of a range of elements. The data for a range descriptor consists of two keyword-specified descriptors with the keywords keyAERangeStart and keyAERangeStop, respectively, which specify the first Apple event object in the desired range and the last Apple event object in the desired range.

Available in Mac OS X v10.0 and later.
typeLogicalDescriptor

Specifies a logical descriptor. Data is one of the constants described in AEDisposeToken.

Available in Mac OS X v10.0 and later.
typeCompDescriptor

Specifies a comparison descriptor. Data is one of the constants described in AEDisposeToken.

Available in Mac OS X v10.0 and later.
typeOSLTokenList

Specifies a descriptor whose data consists of a list of tokens. (Token is defined in AEDisposeToken.)

Available in Mac OS X v10.0 and later.
Discussion

The constants in this enum that begin with “form” specify the key form for an object specifier. The key form indicates how key data should be interpreted. Key form is one of the keyword-specified descriptors described in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”.

The constants in this enum that begin with “type” specify descriptor types used in resolving object specifiers. An object specifier is a coerced Apple event record of descriptor type typeObjectSpecifier whose data consists of the four keyword-specified descriptors described in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”. One of those four keyword-specified descriptors has the type keyAEKeyData.This descriptor can contain data or nested descriptors specified by any of the descriptor type constants defined here (or by types defined by your application).*/
enum {
   formAbsolutePosition = 'indx',
   formRelativePosition = 'rele',
   formTest = 'test',
   formRange = 'rang',
   formPropertyID = 'prop',
   formName = 'name',
   typeObjectSpecifier = 'obj ',
   typeObjectBeingExamined = 'exmn',
   typeCurrentContainer = 'ccnt',
   typeToken = 'toke',
   typeRelativeDescriptor = 'rel ',
   typeAbsoluteOrdinal = 'abso',
   typeIndexDescriptor = 'inde',
   typeRangeDescriptor = 'rang',
   typeLogicalDescriptor = 'logi',
   typeCompDescriptor = 'cmpd',
   typeOSLTokenList = 'ostl'
};


/*Constants for Object Specifiers, Positions, and Logical and Comparison Operations

Specify the types of the four keyword-specified descriptors that make up the data in an object specifier, as well as constants for position, logical operations, and comparison operations.

enum {
   kAEAND = 'AND ',
   kAEOR = 'OR  ',
   kAENOT = 'NOT ',
   kAEFirst = 'firs',
   kAELast = 'last',
   kAEMiddle = 'midd',
   kAEAny = 'any ',
   kAEAll = 'all ',
   kAENext = 'next',
   kAEPrevious = 'prev',
   keyAECompOperator = 'relo',
   keyAELogicalTerms = 'term',
   keyAELogicalOperator = 'logc',
   keyAEObject1 = 'obj1',
   keyAEObject2 = 'obj2',
   keyAEDesiredClass = 'want',
   keyAEContainer = 'from',
   keyAEKeyForm = 'form',
   keyAEKeyData = 'seld'
};
Constants
kAEAND

Specifies a logical AND operation.

Available in Mac OS X v10.0 and later.
kAEOR

Specifies a logical OR operation.

Available in Mac OS X v10.0 and later.
kAENOT

Specifies a logical NOT operation.

Available in Mac OS X v10.0 and later.
kAEFirst

The first element in the specified container.

Available in Mac OS X v10.0 and later.
kAELast

Specifies the last element in the container.

Available in Mac OS X v10.0 and later.
kAEMiddle

Specifies the middle element in the container. If an object specifier specifies kAEMiddle and the number of elements in the container is even, the Apple Event Manager rounds down. For example, in a range of four words the second word is the “middle” word.

Available in Mac OS X v10.0 and later.
kAEAny

Specifies a single element chosen at random from the container.

Available in Mac OS X v10.0 and later.
kAEAll

Specifies all the elements in the container.

Available in Mac OS X v10.0 and later.
kAENext

Specifies the Apple event object after the container.

Available in Mac OS X v10.0 and later.
kAEPrevious

Specifies the Apple event object before the container.

Available in Mac OS X v10.0 and later.
keyAECompOperator

Specifies a descriptor of typeType, whose data consists of one of the constant values described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAELogicalTerms

Specifies a descriptor of type typeAEList containing one or more comparison or logical descriptors.

Available in Mac OS X v10.0 and later.
keyAELogicalOperator

Specifies a descriptor of type typeEnumerated whose data is one of the logical operators (such as kAEAND) defined in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAEObject1

Identifies a descriptor for the element that is currently being compared to the object or data specified by the descriptor for the keyword keyAEObject2. Either object can be described by a descriptor of type typeObjectSpecifier or typeObjectBeingExamined.

A descriptor of typeObjectBeingExamined acts as a placeholder for each of the successive elements in a container when the Apple Event Manager tests those elements one at a time.

Available in Mac OS X v10.0 and later.
keyAEObject2

Identifies a descriptor for the element that is currently being compared to the object or data specified by the descriptor for the keyword keyAEObject1.

The keyword keyAEObject2 can also be used with a descriptor of any other descriptor type whose data is to be compared to each element in a container.

Available in Mac OS X v10.0 and later.
keyAEDesiredClass

A four-character code that identifies the object class of the specified object or objects.

Constants for object class IDs are described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAEContainer

Specifies the container for the requested object or objects. The data is an object specifier (or in some cases a null descriptor).

Available in Mac OS X v10.0 and later.
keyAEKeyForm

A four-character code that identifies the key form for the specified object or objects.

The constants for specifying the key form are described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
keyAEKeyData

Data or nested descriptors that specify a property, name, position, range, or test, depending on the key form.

The descriptor types used in object specifiers are described in “Key Form and Descriptor Type Object Specifier Constants”.

Available in Mac OS X v10.0 and later.
Discussion

When you call the CreateLogicalDescriptor function to create a logical descriptor, you pass one of the logical operators kAEAND, kAEOR, or kAENOT in the theLogicOperator parameter. The CreateLogicalDescriptor function creates a logical descriptor that specifies a logical operation to perform on one or more operands.

The constants kAEFirst, kAELast, kAEMiddle, kAEAny, and kAEAll provide the key data for a keyword-specified descriptor of key form formAbsolutePosition and descriptor type typeAbsoluteOrdinal.

The constants kAENext, and kAEPrevious provide the key data for a keyword-specified descriptor of key form formRelativePosition.

Key form constants and descriptor type constants for object specifiers are defined in “Key Form and Descriptor Type Object Specifier Constants”.

The constants keyAELogicalTerms and keyAELogicalOperator define the keyword descriptors for a logical descriptor. A logical descriptor is a coerced Apple event record of type typeLogicalDescriptor that specifies a logical expression—that is, an expression that the Apple Event Manager evaluates to either TRUE or FALSE. You can create a logical descriptor with the CreateLogicalDescriptor function.

The data for a logical descriptor consists of two keyword-specified descriptors: the first with descriptor type keyAELogicalOperator, descriptor type typeEnumerated, and one of the logical operators defined in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations” for its data; and the second with descriptor type keyAELogicalTerms, descriptor type typeEnumerated, and one or more comparison or logical descriptors for its data. Comparison constants are described in “Comparison Operator Constants”.

The logical expression is constructed from a logical operator (one of the Boolean operators AND, OR, or NOT) and a list of logical terms to which the operator is applied (where NOT can only be used where the list of terms is a single-item list). Each logical term in the list can be either another logical descriptor or a comparison descriptor (described in “Constants for Object Specifiers, Positions, and Logical and Comparison Operations”). 

The Apple Event Manager short-circuits its evaluation of a logical expression as soon as one part of the expression fails a test. For example, if while testing a logical expression such as A AND B AND C the Apple Event Manager discovers that A AND B is not true, it will evaluate the expression to FALSE without testing C.

The constants keyAECompOperator, keyAEObject1, and keyAEObject2 define the keyword descriptors for a comparison descriptor. A comparison descriptor is a coerced Apple event record of type typeCompDescriptor that specifies an Apple event object and either another Apple event object or data for the Apple Event Manager to compare to the first object. You can create a logical descriptor with the CreateCompDescriptor function.

The Apple Event Manager can also use the information in a comparison descriptor to compare elements in a container, one at a time, either to an Apple event object or to data. The data for a comparison descriptor consists of three keyword-specified descriptors:
A descriptor with keyword keyAECompOperator, descriptor type typeType, and one of the logical operators defined in “Comparison Operator Constants” for its data. 
A descriptor with keyword keyAEObject1 and either
descriptor type typeObjectSpecifier and object specifier data to compare, or 
descriptor type typeObjectBeingExamined and a data storage pointer of NULL. 
A descriptor with keyword keyAEObject2 and either
descriptor type typeObjectSpecifier and object specifier data to compare, or 
descriptor type typeObjectBeingExamined and a data storage pointer of NULL, or 
any other descriptor type and the data to be compared for that descriptor type. 

You don’t have to support all the available comparison operators for all Apple event objects for example, the begins with operator probably doesn’t make sense for objects of type cRectangle. It is up to you to decide which comparison operators are appropriate for your application to support, and how to interpret them. If necessary, you can define your own custom comparison operators. If you think you need to do this, check the Apple Events and Scripting header files to see if existing definitions of comparison operators can be adapted to the needs of your application.

An object specifier is a coerced Apple event record of descriptor type typeObjectSpecifier whose data contains consists of four keyword-specified descriptors. The constants keyAEDesiredClass, keyAEContainer, keyAEKeyForm, and keyAEKeyData specify the keywords for the four descriptor types that together identify the specified object or objects.*/
enum {
   kAEAND = 'AND ',
   kAEOR = 'OR  ',
   kAENOT = 'NOT ',
   kAEFirst = 'firs',
   kAELast = 'last',
   kAEMiddle = 'midd',
   kAEAny = 'any ',
   kAEAll = 'all ',
   kAENext = 'next',
   kAEPrevious = 'prev',
   keyAECompOperator = 'relo',
   keyAELogicalTerms = 'term',
   keyAELogicalOperator = 'logc',
   keyAEObject1 = 'obj1',
   keyAEObject2 = 'obj2',
   keyAEDesiredClass = 'want',
   keyAEContainer = 'from',
   keyAEKeyForm = 'form',
   keyAEKeyData = 'seld'
};

/*OSLAccessorProcPtr

Your object accessor function either finds elements or properties of an Apple event object.

typedef OSErr (*OSLAccessorProcPtr) (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon
);

If you name your function MyObjectAccessorCallback, you would declare it like this:

OSErr MyObjectAccessorCallback (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon
);
Parameters
desiredClass

The object class of the desired Apple event object or objects. Constants for object class IDs are described in “Object Class ID Constants”. See DescType.
container

A pointer to a descriptor that specifies the container of the desired Apple event object or objects. See AEDesc.
containerClass

The object class of the container. Constants for object class IDs are described in “Object Class ID Constants”. See DescType.
form

The key form specified by the object specifier being resolved.Constants for key form are described in “Key Form and Descriptor Type Object Specifier Constants”. See DescType.
selectionData

A pointer to a descriptor containing the key data specified by the object specifier being resolved. See AEDesc.
value

A pointer to a descriptor where your object accessor routine stores a descriptor that identifies the found object. See AEDesc.
accessorRefcon

A reference constant. The Apple Event Manager passes this value to your object accessor function each time it calls it. The reference constant may have a value of 0.
Return Value

A result code. See “Apple Event Manager Result Codes”. Your object accessor function should return noErr if it successfully located the requested object and errAEEventNotHandled if it could not locate the object. When the Apple Event Manager receives the result code errAEEventNotHandled after calling an object accessor function, it attempts to use other methods of locating the requested objects, such as calling an equivalent system object accessor function.
Discussion

To resolve an object specifier, your application calls the AEResolve function. AEResolve in turn calls application-defined object accessor functions to locate specific Apple event objects and properties in the application’s data structures. Your application provides one or more object accessor functions that can locate all the element classes and properties it supports.

Each object accessor function provided by your application should either find elements or properties of an Apple event object. The AEResolve function uses the object class ID of the specified Apple event object and the descriptor type of the token that identifies the object’s container to determine which object accessor function to call. To install an object accessor function, use the AEInstallObjectAccessor function.

To provide a pointer to your object accessor callback function, you create a universal procedure pointer (UPP) of type OSLAccessorUPP, using the function NewOSLAccessorUPP. You can do so with code like the following:AEObjectAccessorUPP MyObjectAccessorUPP;
MyObjectAccessorUPP = NewAEObjectAccessorUPP (&MyObjectAccessorCallback)


You can then pass the UPP MyObjectAccessorUPP as a parameter to any function that installs or removes an object accessor, such as AEInstallObjectAccessor. If your application installs the same object accessor to handle more than one kind of object class or property of an Apple event, you can use the same UPP to install the accessor multiple times.

If you wish to call your object accessor callback function directly, you can use the InvokeOSLAccessorUPP function.

After you are finished with an object accessor callback function, and have removed it with the AERemoveObjectAccessor function, you can dispose of the UPP with the DisposeOSLAccessorUPP function. However, don’t dispose of the UPP if any remaining accessor function uses it or if you plan to install the accessor function again. 
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.*/
typedef OSErr (*OSLAccessorProcPtr) (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon
);

/*OSLAccessorUPP

Defines a data type for the universal procedure pointer for the OSLAccessorProcPtr callback function pointer.

typedef OSLAccessorProcPtr OSLAccessorUPP;
Discussion

For a description of an object accessor callback function, see OSLAccessorProcPtr.*/
typedef OSLAccessorProcPtr OSLAccessorUPP;

/*Data Types
struct ccntTokenRecord {                     //used for rewriting tokens //
   DescType tokenClass;                      // in place of 'ccnt' //
   AEDesc token;                             // descriptor records; only //
};                                           // of interest to those who, //
                                             // when they get ranges as //
typedef struct ccntTokenRecord ccntTokenRecord, // key data in their object //
*ccntTokenRecPtr, **ccntTokenRecHandle;      // accessor functions, 
                                             // resolve them manually

typedef AEDesc *DescPtr, **DescHandle;

//typedefs providing type checking for procedure pointers
typedef pascal OSErr (*accessorProcPtr) (DescType desiredClass,
                                          const AEDesc *container, 
                                          DescType containerClass, 
                                          DescType form,
                                          const AEDesc *selectionData, 
                                          AEDesc *value, long LongInt);
typedef pascal OSErr (*compareProcPtr)(DescType oper, const AEDesc *obj1,
                                       const AEDesc *obj2,
                                       Boolean *result);
typedef pascal OSErr (*countProcPtr)(DescType desiredClass, 
                                       DescType containerClass,
                                       const AEDesc *container, 
                                       long *result);
typedef pascal OSErr (*disposeTokenProcPtr)(AEDesc *unneededToken);
typedef pascal OSErr (*getMarkTokenProcPtr)(const AEDesc *ContainerToken, 
                                             DescType containerClass,
                                             AEDesc *result);

typedef pascal OSErr (*getErrDescProcPtr)(DescPtr *appDescPtr);*/
struct ccntTokenRecord {                     //used for rewriting tokens //
   DescType tokenClass;                      // in place of 'ccnt' //
   AEDesc token;                             // descriptor records; only //
};                                           // of interest to those who, //
                                             // when they get ranges as //
typedef struct ccntTokenRecord ccntTokenRecord, // key data in their object //
*ccntTokenRecPtr, **ccntTokenRecHandle;      // accessor functions, 
                                             // resolve them manuall
//function

/*AEObjectInit

Initializes the Object Support Library.

OSErr AEObjectInit ();
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

You must call this function before calling any of the Apple Event Manager functions that describe or manipulate Apple event objects.

You should call the AEObjectInit function to initialize the Apple Event Manager functions that handle object specifiers and Apple event objects. 
Version Notes

To make these functions available to your application with version 1.01 and earlier versions of the Apple Event Manager, you must also link the Apple Event Object Support Library with your application when you build it. For more information, see the Version Notes section for the AppleScript Gestalt Selector described in Inside Mac OS X: Gestalt Manager Reference and the function AERemoveSpecialHandler.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AEObjectInit ();

/*AEGetObjectAccessor

Gets an object accessor function from an object accessor dispatch table. 

OSErr AEGetObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP * accessor,
   long * accessorRefcon,
   Boolean isSysHandler
);
Parameters
desiredClass

The object class of the Apple event objects located by the object accessor function to get. Pass the value typeWildCard to get an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the object class. Pass the value cProperty to get an object accessor function whose entry in an object accessor dispatch table specifies cProperty (a constant used to specify a property of any object class). Some other possible values are defined in “Object Class ID Constants”. See DescType.
containerType

The descriptor type of the token that identifies the container for the objects located by the requested accessor function. (Token is defined in AEDisposeToken.) Pass the value typeWildCard to get an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the descriptor type of the token used to specify the container type. See DescType.
accessor

A universal procedure pointer. On return, a pointer to the requested object accessor function, if an object accessor dispatch table entry exists that exactly matches the values supplied in the parameters desiredClass and containerType. See OSLAccessorUPP.
accessorRefcon

A pointer to a reference constant. On return, points to the reference constant from the object accessor dispatch table entry for the specified object accessor function. The reference constant may have a value of 0.
isSysHandler

Specifies the object accessor dispatch table to get the object accessor function from. Pass TRUE to get the object accessor function from the system object accessor dispatch table or FALSE to get the object accessor function from your application’s object accessor dispatch table. Use of the system object accessor dispatch table is not recommended. 
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Calling AEGetObjectAccessor does not remove the object accessor function from an object accessor dispatch table. 
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AEGetObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP * accessor,
   long * accessorRefcon,
   Boolean isSysHandler
);

/*AERemoveObjectAccessor

Removes an object accessor function from an object accessor dispatch table. 

OSErr AERemoveObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   Boolean isSysHandler
);
Parameters
desiredClass

The object class of the Apple event objects located by the object accessor function to remove. Pass the value typeWildCard to remove an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the object class. Pass the value cProperty to remove an object accessor function whose entry in an object accessor dispatch table specifies cProperty (a constant used to specify a property of any object class). Some other possible values are defined in “Object Class ID Constants”. See DescType.
containerType

The descriptor type of the token that identifies the container for the objects located by the object accessor function to remove. (Token is defined in AEDisposeToken.) Pass the value typeWildCard to remove an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the descriptor type of the token used to specify the container type. See DescType.
theAccessor

A universal procedure pointer to the special handler to remove. Although the functionClass parameter is sufficient to identify the handler to remove, you can identify the handler explicitly as a safeguard. If you pass NULL for this parameter, the Apple Event Manager relies solely on the function class to identify the handler.A universal procedure pointer (UPP) to the object accessor function to remove. Although the parameters desiredClass and containerType are sufficient to identify the function to remove, you can identify the function explicitly by providing a UPP in this parameter. If you pass NULL for this parameter, the Apple Event Manager relies solely on the desired class and container type. See OSLAccessorUPP.
isSysHandler

Specifies the object accessor dispatch table to remove the object accessor function from. Pass TRUE to remove the object accessor function from the system object accessor dispatch table or FALSE to remove the object accessor function from your application’s object accessor dispatch table. Use of the system object accessor dispatch table is not recommended.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AERemoveObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   Boolean isSysHandler
);

/*AEInstallObjectAccessor

Adds or replaces an entry for an object accessor function to an object accessor dispatch table.

OSErr AEInstallObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   long accessorRefcon,
   Boolean isSysHandler
);
Parameters
desiredClass

The object type of the Apple event objects located by this accessor. See DescType.
containerType

The type of the token whose objects are accessed by this accessor. (Token is defined in AEDisposeToken.) The accessor function finds objects in containers specified by tokens of this type. See DescType.
theAccessor

A universal procedure pointer to the object accessor function to install. See OSLAccessorUPP.
accessorRefcon

A reference constant the Apple Event Manager passes to the object accessor function whenever it calls the function. If your object accessor function doesn’t require a reference constant, pass 0 for this parameter. To change the value of the reference constant, you must call AEInstallObjectAccessor again.
isSysHandler

Specifies the object accessor dispatch table to add the entry to. Pass TRUE to add the entry to the system object accessor dispatch table or FALSE to add the entry to your application’s object accessor dispatch table. Use of the system object accessor dispatch table is not recommended. 
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEInstallObjectAccessor function adds or replaces an entry to either the application or system object accessor dispatch table. 
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.

If your Carbon application running in Mac OS 8 or OS 9 installs a system object accessor function in its application heap, rather than in the system heap, you must call AERemoveObjectAccessor to remove the function before your application terminates.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AEInstallObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   long accessorRefcon,
   Boolean isSysHandler
);

/*NewOSLAccessorUPP

Creates a new universal procedure pointer to an object accessor function.

OSLAccessorUPP NewOSLAccessorUPP (
   OSLAccessorProcPtr userRoutine
);
Return Value

See OSLAccessorUPP.
Discussion

See the OSLAccessorProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSLAccessorUPP NewOSLAccessorUPP (
   OSLAccessorProcPtr userRoutine
);

/*InvokeOSLAccessorUPP

Calls an object accessor universal procedure pointer.

OSErr InvokeOSLAccessorUPP (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon,
   OSLAccessorUPP userUPP
);
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

See the OSLAccessorProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/

OSErr InvokeOSLAccessorUPP (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon,
   OSLAccessorUPP userUPP
);

#ifdef __cplusplus
}
#endif

#endif