
#import <AddressBook/ABTypedefs.h>
#import <AddressBook/ABGlobals.h>

@class ABRecord;
@class ABPerson;
@class ABGroup;
@class ABSearchElement;
@class ABConverter;

@interface ABAddressBook : NSObject

/*sharedAddressBook

+ (ABAddressBook *)sharedAddressBook
Discussion

Returns the unique shared instance of ABAddressBook. This method returns the address book for the logged-in user that is shared by every application. If you call this method more than once or try to create a new address book, you get a pointer to the same shared address book.
Availability
Available in Mac OS X v10.2 and later.*/
+ (ABAddressBook *)sharedAddressBook;

/*addRecord:

- (BOOL)addRecord:(ABRecord *)record
Discussion

Adds an ABPerson or ABGroup record to the Address Book database. If the record argument is nil, this method raises an exception. This method returns YES if the record was added successfully, NO otherwise. 
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeRecord:
– initWithVCardRepresentation: (ABPerson)*/
- (BOOL)addRecord:(ABRecord *)record;

/*save

- (BOOL)save
Discussion

Saves all the changes made since the last save. Returns YES if this method is successful or there were no changes, NO otherwise. 
Availability
Available in Mac OS X v10.2 and later.
See Also
– hasUnsavedChanges*/
- (BOOL)save;

/*recordsMatchingSearchElement:

- (NSArray *)recordsMatchingSearchElement:(ABSearchElement *)search
Discussion

Returns an array of records that match the given search element, or returns an empty array if no records match the search element. If search is nil, this method raises an exception. 
Availability
Available in Mac OS X v10.2 and later.
See Also
+ searchElementForProperty:label:key:value:comparison: (ABPerson)
+ searchElementForProperty:label:key:value:comparison: (ABGroup)
+ searchElementForConjunction:children: (ABSearchElement)*/
- (NSArray *)recordsMatchingSearchElement:(ABSearchElement *)search;

@end


