#import <Foundation/Foundation.h>
#import <CoreFoundation/CoreFoundation.h>

/*Person Properties

CFPlugIn defines the following domain qualifier constants.

NSString  * const kABFirstNameProperty;
NSString  * const kABLastNameProperty;
NSString  * const kABFirstNamePhoneticProperty;
NSString  * const kABLastNamePhoneticProperty;
NSString  * const kABBirthdayProperty;
NSString  * const kABOrganizationProperty;
NSString  * const kABJobTitleProperty;
NSString  * const kABHomePageProperty;
NSString  * const kABURLsProperty;
NSString  * const kABEmailProperty;
NSString  * const kABAddressProperty;
NSString  * const kABPhoneProperty;
NSString  * const kABAIMInstantProperty;
NSString  * const kABJabberInstantProperty;
NSString  * const kABMSNInstantProperty;
NSString  * const kABYahooInstantProperty;
NSString  * const kABICQInstantProperty;
NSString  * const kABNoteProperty;
NSString  * const kABMiddleNameProperty;
NSString  * const kABMiddleNamePhoneticProperty;
NSString  * const kABTitleProperty;
NSString  * const kABSuffixProperty;
NSString  * const kABNicknameProperty;
NSString  * const kABMaidenNameProperty;
NSString  * const kABOtherDatesProperty;
NSString  * const kABRelatedNamesProperty;
NSString  * const kABDepartmentProperty;
NSString  * const kABPersonFlags;
Constants
kABFirstNameProperty

First name (string).

Available in Mac OS X v10.2 and later.
kABLastNameProperty

Last name (string).

Available in Mac OS X v10.2 and later.
kABFirstNamePhoneticProperty

First name phonetic (string).

Available in Mac OS X v10.2 and later.
kABLastNamePhoneticProperty

Last name phonetic (string).

Available in Mac OS X v10.2 and later.
kABBirthdayProperty

Birth date (date).

Available in Mac OS X v10.2 and later.
kABOrganizationProperty

Company name (string)

Available in Mac OS X v10.2 and later.
kABJobTitleProperty

Job Title (string).

Available in Mac OS X v10.2 and later.
kABHomePageProperty

Home Web page (string). Deprecated in Mac OS X version 10.4.

Available in Mac OS X v10.2 and later.
kABURLsProperty

Web pages (multi-string). 

Available in Mac OS X v10.4 and later.
kABEmailProperty

email(s) (multi-string).

Available in Mac OS X v10.2 and later.
kABAddressProperty

Street Addresses (multi-dictionary).

Available in Mac OS X v10.2 and later.
kABPhoneProperty

Generic phone number (multi-string).

Available in Mac OS X v10.2 and later.
kABAIMInstantProperty

AIM Instant Messaging (multi-string).

Available in Mac OS X v10.2 and later.
kABJabberInstantProperty

Jabber Instant Messaging (multi-string).

Available in Mac OS X v10.2 and later.
kABMSNInstantProperty

MSN Instant Messaging (multi-string).

Available in Mac OS X v10.2 and later.
kABYahooInstantProperty

Yahoo Instant Messaging (multi-string).

Available in Mac OS X v10.2 and later.
kABICQInstantProperty

ICQ Instant Messaging (multi-string).

Available in Mac OS X v10.2 and later.
kABNoteProperty

Note (string).

Available in Mac OS X v10.2 and later.
kABMiddleNameProperty

Middle name (string). Not supported in the AddressBook UI.

Available in Mac OS X v10.2 and later.
kABMiddleNamePhoneticProperty

Middle name phonetic (string). Not supported in the AddressBook UI.

Available in Mac OS X v10.2 and later.
kABTitleProperty

Title as in “Sir”, “Duke”, “General”, “Cardinal”, or “Lord” (string). Not supported in the AddressBook UI.

Available in Mac OS X v10.2 and later.
kABSuffixProperty

Suffix as in “Sr.”, “Jr.”, “III”, or “Esq.” (string). Not supported in the AddressBook UI.

Available in Mac OS X v10.2 and later.
kABNicknameProperty

Nickname (string). Not supported in the AddressBook UI.

Available in Mac OS X v10.2 and later.
kABMaidenNameProperty

Maiden name (string). Not supported in the AddressBook UI.

Available in Mac OS X v10.2 and later.
kABOtherDatesProperty

Dates associated with a person (ABMultiDateProperty containing dates).

Available in Mac OS X v10.3 and later.
kABRelatedNamesProperty

Names of people related to a person (ABMultiStringProperty containing names).

Available in Mac OS X v10.3 and later.
kABDepartmentProperty

Department name (string).

Available in Mac OS X v10.3 and later.
kABPersonFlags

Property that specifies the name ordering and user configuration of a record in the Address Book application.

Available in Mac OS X v10.3 and later.*/

extern NSString * const kABFirstNameProperty;
extern NSString * const kABLastNameProperty;
extern NSString * const kABFirstNamePhoneticProperty;
extern NSString  * const kABLastNamePhoneticProperty;
extern NSString  * const kABBirthdayProperty;
extern NSString  * const kABOrganizationProperty;
extern NSString  * const kABJobTitleProperty;
extern NSString  * const kABHomePageProperty;
extern NSString  * const kABURLsProperty;
extern NSString  * const kABEmailProperty;
extern NSString  * const kABAddressProperty;
extern NSString  * const kABPhoneProperty;
extern NSString  * const kABAIMInstantProperty;
extern NSString  * const kABJabberInstantProperty;
extern NSString  * const kABMSNInstantProperty;
extern NSString  * const kABYahooInstantProperty;
extern NSString  * const kABICQInstantProperty;
extern NSString  * const kABNoteProperty;
extern NSString  * const kABMiddleNameProperty;
extern NSString  * const kABMiddleNamePhoneticProperty;
extern NSString  * const kABTitleProperty;
extern NSString  * const kABSuffixProperty;
extern NSString  * const kABNicknameProperty;
extern NSString  * const kABMaidenNameProperty;
extern NSString  * const kABOtherDatesProperty;
extern NSString  * const kABRelatedNamesProperty;
extern NSString  * const kABDepartmentProperty;
extern NSString  * const kABPersonFlags;

/*These are the keys contained in each address dictionary. Neither developers nor users can add more keys.
Constant	
Description
kABAddressStreetKey	
Street

Available in Mac OS X v10.2 and later.
kABAddressCityKey	
City

Available in Mac OS X v10.2 and later.
kABAddressStateKey	
State

Available in Mac OS X v10.2 and later.
kABAddressZIPKey	
Zip

Available in Mac OS X v10.2 and later.
kABAddressCountryKey	
Country

Available in Mac OS X v10.2 and later.
kABAddressCountryCodeKey	
Country Code

Available in Mac OS X v10.2 and later.*/
extern NSString  * const kABAddressStreetKey;	
//Street

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAddressCityKey;
//City

//Available in Mac OS X v10.2 and later.
extern NSString  * const  kABAddressStateKey;	
//State

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAddressZIPKey;	
//Zip

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAddressCountryKey;	
//Country

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAddressCountryCodeKey;	
//Country Code

//Available in Mac OS X v10.2 and later.

/*These are the default labels contained in the Address Book database for specifying different values in a multi-value list. Users can also add their own labels. 
Constant	
Description
kABEmailWorkLabel	
Home email

Available in Mac OS X v10.2 and later.
kABEmailHomeLabel	
Work email

Available in Mac OS X v10.2 and later.
kABAddressHomeLabel	
Home address

Available in Mac OS X v10.2 and later.
kABAddressWorkLabel	
Work address

Available in Mac OS X v10.2 and later.
kABPhoneWorkLabel	
Work phone number 

Available in Mac OS X v10.2 and later.
kABPhoneHomeLabel	
Home phone number

Available in Mac OS X v10.2 and later.
kABPhoneMobileLabel	
Cell phone number

Available in Mac OS X v10.2 and later.
kABPhoneMainLabel	
Main phone number

Available in Mac OS X v10.2 and later.
kABPhoneHomeFAXLabel	
Home FAX number

Available in Mac OS X v10.2 and later.
kABPhoneWorkFAXLabel	
Work FAX number

Available in Mac OS X v10.2 and later.
kABPhonePagerLabel	
Pager number

Available in Mac OS X v10.2 and later.
kABHomePageLabel	
Web page URL

Available in Mac OS X v10.4 and later.
kABAIMWorkLabel	
Work AOL instant messaging ID

Available in Mac OS X v10.2 and later.
kABAIMHomeLabel	
Home AOL instant messaging ID

Available in Mac OS X v10.2 and later.
kABJabberWorkLabel	
Work Jabber instant messaging ID

Available in Mac OS X v10.2 and later.
kABJabberHomeLabel	
Home Jabber instant messaging ID

Available in Mac OS X v10.2 and later.
kABMSNWorkLabel	
Work MSN instant messaging ID 

Available in Mac OS X v10.2 and later.
kABMSNHomeLabel	
Home MSN instant messaging ID 

Available in Mac OS X v10.2 and later.
kABYahooWorkLabel	
Work Yahoo instant messaging ID

Available in Mac OS X v10.2 and later.
kABYahooHomeLabel	
Home Yahoo instant messaging ID

Available in Mac OS X v10.2 and later.
kABICQWorkLabel	
Work ICQ instant messaging ID

Available in Mac OS X v10.2 and later.
kABICQHomeLabel	
Home ICQ instant messaging ID

Available in Mac OS X v10.2 and later.
kABAnniversaryLabel	
Anniversary date

Available in Mac OS X v10.3 and later.
kABMotherLabel	
Mother

Available in Mac OS X v10.3 and later.
kABFatherLabel	
Father

Available in Mac OS X v10.3 and later.
kABParentLabel	
Parent

Available in Mac OS X v10.3 and later.
kABSisterLabel	
Sister

Available in Mac OS X v10.3 and later.
kABBrotherLabel	
Brother

Available in Mac OS X v10.3 and later.
kABChildLabel	
Child

Available in Mac OS X v10.3 and later.
kABFriendLabel	
Friend

Available in Mac OS X v10.3 and later.
kABSpouseLabel	
Spouse

Available in Mac OS X v10.3 and later.
kABPartnerLabel	
Partner

Available in Mac OS X v10.3 and later.
kABAssistantLabel	
Assistant

Available in Mac OS X v10.3 and later.
kABManagerLabel	
Manager

Available in Mac OS X v10.3 and later*/
extern NSString  * const kABEmailWorkLabel;
//Home email

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABEmailHomeLabel	;
//Work email

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAddressHomeLabel	;
//Home address

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAddressWorkLabel	;
//Work address

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhoneWorkLabel	;
//Work phone number 

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhoneHomeLabel	;
// Home phone number

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhoneMobileLabel	;
//Cell phone number

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhoneMainLabel	;
//Main phone number

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhoneHomeFAXLabel	;
//Home FAX number

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhoneWorkFAXLabel	;
//Work FAX number

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABPhonePagerLabel	;
//Pager number

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABHomePageLabel	;
//Web page URL

//Available in Mac OS X v10.4 and later.
extern NSString  * const kABAIMWorkLabel	;
//Work AOL instant messaging ID

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAIMHomeLabel	;
//Home AOL instant messaging ID;

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABJabberWorkLabel	;
//Work Jabber instant messaging ID

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABJabberHomeLabel	;
//Home Jabber instant messaging ID;

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABMSNWorkLabel	;
//Work MSN instant messaging ID 

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABMSNHomeLabel	;
//Home MSN instant messaging ID 

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABYahooWorkLabel	;
//Work Yahoo instant messaging ID

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABYahooHomeLabel	;
//Home Yahoo instant messaging ID

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABICQWorkLabel	;
//Work ICQ instant messaging ID

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABICQHomeLabel	;
//Home ICQ instant messaging ID

//Available in Mac OS X v10.2 and later.
extern NSString  * const kABAnniversaryLabel	;
//Anniversary date

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABMotherLabel	;
//Mother

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABFatherLabel	;
//Father

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABParentLabel	;
//Parent

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABSisterLabel	;
//Sister;

//Available in Mac OS X v10.3 and later.;
extern NSString  * const kABBrotherLabel	;
//Brother

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABChildLabel	;
//Child

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABFriendLabel	;
//Friend

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABSpouseLabel	;
//Spouse

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABPartnerLabel	;
//Partner

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABAssistantLabel	;
//Assistant

//Available in Mac OS X v10.3 and later.
extern NSString  * const kABManagerLabel	;
//Manager

//Available in Mac OS X v10.3 and later
