#import <Foundation/NSObject.h>
#import <CoreData/CoreDataDefines.h>

/*Error User Info Keys

Core Data uses these string constants as keys in the user info dictionary in errors it creates.

const NSString *NSDetailedErrorsKey;
const NSString *NSValidationObjectErrorKey;
const NSString *NSValidationKeyErrorKey;
const NSString *NSValidationPredicateErrorKey;
const NSString *NSValidationValueErrorKey;
const NSString *NSAffectedStoresErrorKey;
const NSString *NSAffectedObjectsErrorKey;
Constants
NSDetailedErrorsKey

If multiple validation errors occur in one operation, they are collected in an array and added with this key to the “top-level error” of the operation.

Available in Mac OS X v10.4 and later.
NSValidationObjectErrorKey

Key for the object that failed to validate for a validation error.

Available in Mac OS X v10.4 and later.
NSValidationKeyErrorKey

Key for the key that failed to validate for a validation error.

Available in Mac OS X v10.4 and later.
NSValidationPredicateErrorKey

For predicate-based validation, key for the predicate for the condition that failed to validate.

Available in Mac OS X v10.4 and later.
NSValidationValueErrorKey

If non-nil, the key for the value for the key that failed to validate for a validation error.

Available in Mac OS X v10.4 and later.
NSAffectedStoresErrorKey

The key for stores prompting an error.

Available in Mac OS X v10.4 and later.
NSAffectedObjectsErrorKey

The key for objects prompting an error.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CoreData/CoreDataErrors.h*/

const NSString *NSDetailedErrorsKey;
const NSString *NSValidationObjectErrorKey;
const NSString *NSValidationKeyErrorKey;
const NSString *NSValidationPredicateErrorKey;
const NSString *NSValidationValueErrorKey;
const NSString *NSAffectedStoresErrorKey;
const NSString *NSAffectedObjectsErrorKey;

/*Error Codes

These error codes, defined in CoreDataErrors.h, are associated with errors generated by Core Data. For additional error codes, including NSValidationErrorMinimum and NSValidationErrorMaximum, see NSError.

enum {
NSManagedObjectValidationError                   = 1550,
NSValidationMultipleErrorsError                  = 1560,
NSValidationMissingMandatoryPropertyError        = 1570,
NSValidationRelationshipLacksMinimumCountError   = 1580,
NSValidationRelationshipExceedsMaximumCountError = 1590,
NSValidationRelationshipDeniedDeleteError        = 1600,
NSValidationNumberTooLargeError                  = 1610,
NSValidationNumberTooSmallError                  = 1620,
NSValidationDateTooLateError                     = 1630,
NSValidationDateTooSoonError                     = 1640,
NSValidationInvalidDateError                     = 1650,
NSValidationStringTooLongError                   = 1660,
NSValidationStringTooShortError                  = 1670,
NSValidationStringPatternMatchingError           = 1680,
NSManagedObjectContextLockingError               = 132000,
NSPersistentStoreCoordinatorLockingError         = 132010,
NSManagedObjectReferentialIntegrityError         = 133000,
NSManagedObjectExternalRelationshipError         = 133010,
NSManagedObjectMergeError                        = 133020,
NSPersistentStoreInvalidTypeError                = 134000,
NSPersistentStoreTypeMismatchError               = 134010,
NSPersistentStoreIncompatibleSchemaError         = 134020,
NSPersistentStoreSaveError                       = 134030,
NSPersistentStoreIncompleteSaveError             = 134040
};
Constants
NSManagedObjectValidationError

Error code to denote a generic validation error.

Available in Mac OS X v10.4 and later.
NSValidationMultipleErrorsError

Error code to denote an error containing multiple validation errors.

Available in Mac OS X v10.4 and later.
NSValidationMissingMandatoryPropertyError

Error code for a non-optional property with a nil value.

Available in Mac OS X v10.4 and later.
NSValidationRelationshipLacksMinimumCountError

Error code to denote a to-many relationship with too few destination objects.

Available in Mac OS X v10.4 and later.
NSValidationRelationshipExceedsMaximumCountError

Error code to denote a bounded, to-many relationship with too many destination objects.

Available in Mac OS X v10.4 and later.
NSValidationRelationshipDeniedDeleteError

Error code to denote some relationship with delete rule NSDeleteRuleDeny is non-empty.

Available in Mac OS X v10.4 and later.
NSValidationNumberTooLargeError

Error code to denote some numerical value is too large.

Available in Mac OS X v10.4 and later.
NSValidationNumberTooSmallError

Error code to denote some numerical value is too small.

Available in Mac OS X v10.4 and later.
NSValidationDateTooLateError

Error code to denote some date value is too late.

Available in Mac OS X v10.4 and later.
NSValidationDateTooSoonError

Error code to denote some date value is too soon.

Available in Mac OS X v10.4 and later.
NSValidationInvalidDateError

Error code to denote some date value fails to match date pattern.

Available in Mac OS X v10.4 and later.
NSValidationStringTooLongError

Error code to denote some string value is too long.

Available in Mac OS X v10.4 and later.
NSValidationStringTooShortError

Error code to denote some string value is too short.

Available in Mac OS X v10.4 and later.
NSValidationStringPatternMatchingError

Error code to denote some string value fails to match some pattern.

Available in Mac OS X v10.4 and later.
NSManagedObjectContextLockingError

Error code to denote an inability to acquire a lock in a managed object context.

Available in Mac OS X v10.4 and later.
NSPersistentStoreCoordinatorLockingError

Error code to denote an inability to acquire a lock in a persistent store.

Available in Mac OS X v10.4 and later.
NSManagedObjectReferentialIntegrityError

Error code to denote an attempt to fire a fault pointing to an object that does not exist (the store is accessible, but the object corresponding to the fault cannot be found).

Available in Mac OS X v10.4 and later.
NSManagedObjectExternalRelationshipError

Error code to denote that an object being saved has a relationship containing an object from another store.

Available in Mac OS X v10.4 and later.
NSManagedObjectMergeError

Error code to denote that a merge policy failed—Core Data is unable to complete merging.

Available in Mac OS X v10.4 and later.
NSPersistentStoreInvalidTypeError

Error code to denote an unknown persistent store type/format/version.

Available in Mac OS X v10.4 and later.
NSPersistentStoreTypeMismatchError

Error code returned by a persistent store coordinator if a store is accessed that does not match the specified type.

Available in Mac OS X v10.4 and later.
NSPersistentStoreIncompatibleSchemaError

Error code to denote that a persistent store returned an error for a save operation (this pertains to database level errors such as a missing table).

Available in Mac OS X v10.4 and later.
NSPersistentStoreSaveError

Error code to denote that a persistent store returned an error for a save operation (this pertains to errors such as permissions problems).

Available in Mac OS X v10.4 and later.
NSPersistentStoreIncompleteSaveError

Error code to denote that one or more of the stores returned an error during a save operations (the stores or objects that failed are in the corresponding user info dictionary of the NSError object).

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CoreData/CoreDataErrors.h*/
enum {
NSManagedObjectValidationError                   = 1550,
NSValidationMultipleErrorsError                  = 1560,
NSValidationMissingMandatoryPropertyError        = 1570,
NSValidationRelationshipLacksMinimumCountError   = 1580,
NSValidationRelationshipExceedsMaximumCountError = 1590,
NSValidationRelationshipDeniedDeleteError        = 1600,
NSValidationNumberTooLargeError                  = 1610,
NSValidationNumberTooSmallError                  = 1620,
NSValidationDateTooLateError                     = 1630,
NSValidationDateTooSoonError                     = 1640,
NSValidationInvalidDateError                     = 1650,
NSValidationStringTooLongError                   = 1660,
NSValidationStringTooShortError                  = 1670,
NSValidationStringPatternMatchingError           = 1680,
NSManagedObjectContextLockingError               = 132000,
NSPersistentStoreCoordinatorLockingError         = 132010,
NSManagedObjectReferentialIntegrityError         = 133000,
NSManagedObjectExternalRelationshipError         = 133010,
NSManagedObjectMergeError                        = 133020,
NSPersistentStoreInvalidTypeError                = 134000,
NSPersistentStoreTypeMismatchError               = 134010,
NSPersistentStoreIncompatibleSchemaError         = 134020,
NSPersistentStoreSaveError                       = 134030,
NSPersistentStoreIncompleteSaveError             = 134040
};
