#ifndef DISKARBITRATION_DADISK_H
#define DISKARBITRATION_DADISK_H

#include <CoreFoundation/CoreFoundation.h>
#include <IOKit/IOKitLib.h>

#include <DiskArbitration/DASession.h>

#ifdef __cplusplus
extern "C" {
#endif

/*DADiskRef

typedef struct __DADisk * DADiskRef;  
Discussion 

Type of a reference to DADisk instances.*/
typedef struct __DADisk * DADiskRef;  

//func

/*DADiskCopyDescription


Obtains the Disk Arbitration description of the specified disk. 
extern CFDictionaryRef DADiskCopyDescription(
    DADiskRef disk );  
Parameters
disk
The DADisk for which to obtain the Disk Arbitration description.
Return Value

The disk's Disk Arbitration description. 
Discussion 

This function will contact Disk Arbitration to acquire the latest description of the specified disk, unless this function is called on a disk object passed within the context of a registered callback, in which case the description is current as of that callback event. 

The caller of this function receives a reference to the returned object. The caller also implicitly retains the object and is responsible for releasing it with CFRelease().*/
extern CFDictionaryRef DADiskCopyDescription(
    DADiskRef disk );  

#ifdef __cplusplus
}
#endif 

#endif