#ifndef INTERNETCONFIG_H
#define INTERNETCONFIG_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef AE_H
#include <AE/AE.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Keys


#define kICReservedKey                  "\pkICReservedKey"
#define kICArchieAll                    "\pArchieAll"
#define kICArchiePreferred              "\pArchiePreferred"
#define kICCharacterSet                 "\pCharacterSet"
#define kICDocumentFont                 "\pDocumentFont"
#define kICDownloadFolder               "\pDownloadFolder"
#define kICEmail                        "\pEmail"
#define kICFTPHost                      "\pFTPHost"
#define kICFTPProxyAccount              "\pFTPProxyAccount"
#define kICFTPProxyHost                 "\pFTPProxyHost"
#define kICFTPProxyPassword             "\pFTPProxyPassword"
#define kICFTPProxyUser                 "\pFTPProxyUser"
#define kICFingerHost                   "\pFingerHost"
#define kICGopherHost                   "\pGopherHost"
#define kICGopherProxy                  "\pGopherProxy"
#define kICHTTPProxyHost                "\pHTTPProxyHost"
#define kICHelper                       "\pHelper•"
#define kICHelperDesc                   "\pHelperDesc•"
#define kICHelperList                   "\pHelperList•"
#define kICIRCHost                      "\pIRCHost"
#define kICInfoMacAll                   "\pInfoMacAll"
#define kICInfoMacPreferred             "\pInfoMacPreferred"
#define kICLDAPSearchbase               "\pLDAPSearchbase"
#define kICLDAPServer                   "\pLDAPServer"
#define kICListFont                     "\pListFont"
#define kICMacSearchHost                "\pMacSearchHost"
#define kICMailAccount                  "\pMailAccount"
#define kICMailHeaders                  "\pMailHeaders"
#define kICMailPassword                 "\pMailPassword"
#define kICMapping                      "\pMapping"
#define kICNNTPHost                     "\pNNTPHost"
#define kICNTPHost                      "\pNTPHost"
#define kICNewMailDialog                "\pNewMailDialog"
#define kICNewMailFlashIcon             "\pNewMailFlashIcon"
#define kICNewMailPlaySound             "\pNewMailPlaySound"
#define kICNewMailSoundName             "\pNewMailSoundName"
#define kICNewsAuthPassword             "\pNewsAuthPassword"
#define kICNewsAuthUsername             "\pNewsAuthUsername"
#define kICNewsHeaders                  "\pNewsHeaders"
#define kICNoProxyDomains               "\pNoProxyDomains"
#define kICOrganization                 "\pOrganization"
#define kICPhHost                       "\pPhHost"
#define kICPlan                         "\pPlan"
#define kICPrinterFont                  "\pPrinterFont"
#define kICQuotingString                "\pQuotingString"
#define kICRealName                     "\pRealName"
#define kICRTSPProxyHost                "\pRTSPProxyHost"
#define kICSMTPHost                     "\pSMTPHost"
#define kICScreenFont                   "\pScreenFont"
#define kICServices                     "\pServices"
#define kICSignature                    "\pSignature"
#define kICSnailMailAddress             "\pSnailMailAddress"
#define kICSocksHost                    "\pSocksHost"
#define kICTelnetHost                   "\pTelnetHost"
#define kICUMichAll                     "\pUMichAll"
#define kICUMichPreferred               "\pUMichPreferred"
#define kICUseFTPProxy                  "\pUseFTPProxy"
#define kICUseGopherProxy               "\pUseGopherProxy"
#define kICUseHTTPProxy                 "\pUseHTTPProxy"
#define kICUsePassiveFTP                "\pUsePassiveFTP"
#define kICUseRTSPProxy                 "\pUseRTSPProxy"
#define kICUseSocks                     "\pUseSocks"
#define kICWAISGateway                  "\pWAISGateway"
#define kICWWWHomePage                  "\pWWWHomePage"
#define kICWebBackgroundColour          "\pWebBackgroundColour"
#define kICWebReadColor                 "\p646F6777•WebReadColor"
#define kICWebSearchPagePrefs           "\pWebSearchPagePrefs"
#define kICWebTextColor                 "\pWebTextColor"
#define kICWebUnderlineLinks            "\p646F6777•WebUnderlineLinks"
#define kICWebUnreadColor               "\p646F6777•WebUnreadColor"
#define kICWhoisHost                    "\pWhoisHost"
Constants
kICReservedKey

Reserved for use by Internet Config.

Available in Mac OS X v10.0 and later.
kICArchieAll

Formatted string list of Archie servers.

Available in Mac OS X v10.0 and later.
kICArchiePreferred

Formatted string naming the preferred Archie server.

Available in Mac OS X v10.0 and later.
kICCharacterSet

For conversion between kTextEncodingMacRoman (“Mac”) and kTextEncodingMacRomanLatin1 (“Net”). Deprecated. Use the Text Encoding Conversion manager and Unicode instead.

Available in Mac OS X v10.0 and later.
kICDocumentFont

Font to use for proportional text.

Available in Mac OS X v10.0 and later.
kICDownloadFolder

Location in the file system for newly downloaded files.

Available in Mac OS X v10.0 and later.
kICEmail

Return address for the user.

Available in Mac OS X v10.0 and later.
kICFTPHost

Default FTP server.

Available in Mac OS X v10.0 and later.
kICFTPProxyAccount

Second-level FTP proxy authorization. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICFTPProxyHost

Default FTP proxy server. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICFTPProxyPassword

Password (scrambled) for FTP proxy user. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICFTPProxyUser

First-level FTP proxy authorization. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICFingerHost

Default finger-protocol server.

Available in Mac OS X v10.0 and later.
kICGopherHost

Default gopher-protocol server.

Available in Mac OS X v10.0 and later.
kICGopherProxy

Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICHTTPProxyHost

Default HTTP proxy server. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICHelper

Helpers for URL schemes.

Available in Mac OS X v10.0 and later.
kICHelperDesc

Descriptions for URL schemes.

Available in Mac OS X v10.0 and later.
kICHelperList

Common helpers for URL schemes.

Available in Mac OS X v10.0 and later.
kICIRCHost

Internet Relay Chat server.

Available in Mac OS X v10.0 and later.
kICInfoMacAll

Formatted list of Info-Mac servers.

Available in Mac OS X v10.0 and later.
kICInfoMacPreferred

Formatted string containing preferred Info-Mac server.

Available in Mac OS X v10.0 and later.
kICLDAPSearchbase

Default LDAP search base.

Available in Mac OS X v10.0 and later.
kICLDAPServer

Default LDAP server.

Available in Mac OS X v10.0 and later.
kICListFont

Font used for lists, such as news article lists.

Available in Mac OS X v10.0 and later.
kICMacSearchHost

Host for MacSearch queries.

Available in Mac OS X v10.0 and later.
kICMailAccount

Account from which to fetch email.

Available in Mac OS X v10.0 and later.
kICMailHeaders

Additional headers for email messages.

Available in Mac OS X v10.0 and later.
kICMailPassword

Password (scrambled) for the default mail account.

Available in Mac OS X v10.0 and later.
kICMapping

File-type mapping.

Available in Mac OS X v10.0 and later.
kICNNTPHost

Default NNTP server.

Available in Mac OS X v10.0 and later.
kICNTPHost

Default NTP (Network Time Protocol) server.

Available in Mac OS X v10.0 and later.
kICNewMailDialog

Boolean value indicating whether to display a new email dialog.

Available in Mac OS X v10.0 and later.
kICNewMailFlashIcon

Boolean value indicating whether to flash a new email icon.

Available in Mac OS X v10.0 and later.
kICNewMailPlaySound

Boolean value indicating whether to play a new email sound.

Available in Mac OS X v10.0 and later.
kICNewMailSoundName

The name of the preferred new email sound.

Available in Mac OS X v10.0 and later.
kICNewsAuthPassword

Password (scrambled) for authorized news account.

Available in Mac OS X v10.0 and later.
kICNewsAuthUsername

User name for authorized news account.

Available in Mac OS X v10.0 and later.
kICNewsHeaders

Additional headers for news messages.

Available in Mac OS X v10.0 and later.
kICNoProxyDomains

List of domains not to be proxied.

Available in Mac OS X v10.0 and later.
kICOrganization

String for the X-Organization MIME header.

Available in Mac OS X v10.0 and later.
kICPhHost

Default Ph protocol server.

Available in Mac OS X v10.0 and later.
kICPlan

Default response for finger servers.

Available in Mac OS X v10.0 and later.
kICPrinterFont

Font used to print the monospaced text displayed on screen (see kICScreenFont).

Available in Mac OS X v10.0 and later.
kICQuotingString

A short string used to indicate quoting in email and news replies.

Available in Mac OS X v10.0 and later.
kICRealName

Real name of user.

Available in Mac OS X v10.0 and later.
kICRTSPProxyHost

Default RTSP proxy server. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.1 and later.
kICSMTPHost

Default SMTP host.

Available in Mac OS X v10.0 and later.
kICScreenFont

Font for monospaced text.

Available in Mac OS X v10.0 and later.
kICServices

TCP and IP port-to-name mapping.

Available in Mac OS X v10.0 and later.
kICSignature

Block of text to append to outgoing news and email messages.

Available in Mac OS X v10.0 and later.
kICSnailMailAddress

Preferred postal mail address.

Available in Mac OS X v10.0 and later.
kICSocksHost

Default SOCKS host. (The host.domain format allows ":port" and " port")

Available in Mac OS X v10.0 and later.
kICTelnetHost

Default Telnet host.

Available in Mac OS X v10.0 and later.
kICUMichAll

Formatted list of UMich servers.

Available in Mac OS X v10.0 and later.
kICUMichPreferred

Formatted string containing preferred UMich server.

Available in Mac OS X v10.0 and later.
kICUseFTPProxy

Boolean value indicating whether to use an FTP proxy. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICUseGopherProxy

Boolean value indicating whether to use a Gopher proxy. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICUseHTTPProxy

Boolean value indicating whether to use an HTTP proxy. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.0 and later.
kICUsePassiveFTP

Boolean value indicating whether to use the PASV command for FTP transfers.

Available in Mac OS X v10.0 and later.
kICUseRTSPProxy

Boolean value indicating whether to use an RTSP proxy. Read-only in Mac OS X; use System Configuration to set this value.

Available in Mac OS X v10.1 and later.
kICUseSocks

Boolean value indicating whether to use SOCKS.

Available in Mac OS X v10.0 and later.
kICWAISGateway

Available in Mac OS X v10.0 and later.
kICWWWHomePage

User’s default Web home page.

Available in Mac OS X v10.0 and later.
kICWebBackgroundColour

Background color for Web pages.

Available in Mac OS X v10.0 and later.
kICWebReadColor

Color for Web links that have been visited.

Available in Mac OS X v10.0 and later.
kICWebSearchPagePrefs

URL for the default search engine page.

Available in Mac OS X v10.0 and later.
kICWebTextColor

Color for normal text on Web pages.

Available in Mac OS X v10.0 and later.
kICWebUnderlineLinks

Boolean value indicating whether to underline Web links.

Available in Mac OS X v10.0 and later.
kICWebUnreadColor

Color for Web links that have not been visited.

Available in Mac OS X v10.0 and later.
kICWhoisHost

Default whois server.

Available in Mac OS X v10.0 and later.*/
#define kICReservedKey                  "\pkICReservedKey"
#define kICArchieAll                    "\pArchieAll"
#define kICArchiePreferred              "\pArchiePreferred"
#define kICCharacterSet                 "\pCharacterSet"
#define kICDocumentFont                 "\pDocumentFont"
#define kICDownloadFolder               "\pDownloadFolder"
#define kICEmail                        "\pEmail"
#define kICFTPHost                      "\pFTPHost"
#define kICFTPProxyAccount              "\pFTPProxyAccount"
#define kICFTPProxyHost                 "\pFTPProxyHost"
#define kICFTPProxyPassword             "\pFTPProxyPassword"
#define kICFTPProxyUser                 "\pFTPProxyUser"
#define kICFingerHost                   "\pFingerHost"
#define kICGopherHost                   "\pGopherHost"
#define kICGopherProxy                  "\pGopherProxy"
#define kICHTTPProxyHost                "\pHTTPProxyHost"
#define kICHelper                       "\pHelper•"
#define kICHelperDesc                   "\pHelperDesc•"
#define kICHelperList                   "\pHelperList•"
#define kICIRCHost                      "\pIRCHost"
#define kICInfoMacAll                   "\pInfoMacAll"
#define kICInfoMacPreferred             "\pInfoMacPreferred"
#define kICLDAPSearchbase               "\pLDAPSearchbase"
#define kICLDAPServer                   "\pLDAPServer"
#define kICListFont                     "\pListFont"
#define kICMacSearchHost                "\pMacSearchHost"
#define kICMailAccount                  "\pMailAccount"
#define kICMailHeaders                  "\pMailHeaders"
#define kICMailPassword                 "\pMailPassword"
#define kICMapping                      "\pMapping"
#define kICNNTPHost                     "\pNNTPHost"
#define kICNTPHost                      "\pNTPHost"
#define kICNewMailDialog                "\pNewMailDialog"
#define kICNewMailFlashIcon             "\pNewMailFlashIcon"
#define kICNewMailPlaySound             "\pNewMailPlaySound"
#define kICNewMailSoundName             "\pNewMailSoundName"
#define kICNewsAuthPassword             "\pNewsAuthPassword"
#define kICNewsAuthUsername             "\pNewsAuthUsername"
#define kICNewsHeaders                  "\pNewsHeaders"
#define kICNoProxyDomains               "\pNoProxyDomains"
#define kICOrganization                 "\pOrganization"
#define kICPhHost                       "\pPhHost"
#define kICPlan                         "\pPlan"
#define kICPrinterFont                  "\pPrinterFont"
#define kICQuotingString                "\pQuotingString"
#define kICRealName                     "\pRealName"
#define kICRTSPProxyHost                "\pRTSPProxyHost"
#define kICSMTPHost                     "\pSMTPHost"
#define kICScreenFont                   "\pScreenFont"
#define kICServices                     "\pServices"
#define kICSignature                    "\pSignature"
#define kICSnailMailAddress             "\pSnailMailAddress"
#define kICSocksHost                    "\pSocksHost"
#define kICTelnetHost                   "\pTelnetHost"
#define kICUMichAll                     "\pUMichAll"
#define kICUMichPreferred               "\pUMichPreferred"
#define kICUseFTPProxy                  "\pUseFTPProxy"
#define kICUseGopherProxy               "\pUseGopherProxy"
#define kICUseHTTPProxy                 "\pUseHTTPProxy"
#define kICUsePassiveFTP                "\pUsePassiveFTP"
#define kICUseRTSPProxy                 "\pUseRTSPProxy"
#define kICUseSocks                     "\pUseSocks"
#define kICWAISGateway                  "\pWAISGateway"
#define kICWWWHomePage                  "\pWWWHomePage"
#define kICWebBackgroundColour          "\pWebBackgroundColour"
#define kICWebReadColor                 "\p646F6777•WebReadColor"
#define kICWebSearchPagePrefs           "\pWebSearchPagePrefs"
#define kICWebTextColor                 "\pWebTextColor"
#define kICWebUnderlineLinks            "\p646F6777•WebUnderlineLinks"
#define kICWebUnreadColor               "\p646F6777•WebUnreadColor"
#define kICWhoisHost                    "\pWhoisHost"

/*ICDirSpec

Holds the vRefNum and dirID of a directory.

struct ICDirSpec {
   short vRefNum;
   long dirID;
};
typedef struct ICDirSpec ICDirSpec;
typedef ICDirSpec ICDirSpecArray[4];
typedef ICDirSpecArray * ICDirSpecArrayPtr;
Discussion

An array of ICDirSpec records is supplied to the pre-Carbon-only function ICFindConfigFile to specify the search path. This array is defined to contain just 4 elements, but is in fact arbitrarily extensible.
Availability
Available in Mac OS X v10.0 and later.*/
struct ICDirSpec {
   short vRefNum;
   long dirID;
};
typedef struct ICDirSpec ICDirSpec;
typedef ICDirSpec ICDirSpecArray[4];
typedef ICDirSpecArray * ICDirSpecArrayPtr;

/*Rnternet Config esult Codes

The most common result codes returned by Internet Config are listed in the table below.
Result Code	Value	Description
icPrefNotFoundErr	-666	
The preference was not found.
icPermErr	-667	
The preference cannot be set because of premissions restrictions.
icPrefDataErr	-668	
There was a problem with the preference data.
icInternalErr	-669	
An internal error occurred.
icTruncatedErr	-670	
More data was present than was returned.
icNoMoreWritersErr	-671	
You can’t begin a write session because there is already one in progress.
icNothingToOverrideErr	-672	
There is no component for the override component to capture.
icNoURLErr	-673	
No URL was found.
icConfigNotFoundErr	-674	
No configuration was found.
icConfigInappropriateErr	-675	
The manufacturer code is incorrect.
icProfileNotFoundErr	-676	
The profile was not found.
icTooManyProfilesErr	-677	
There are too many profiles in the database.*/
enum {
icPrefNotFoundErr	=-666	,
//The preference was not found.
icPermErr=	-667	,
//The preference cannot be set because of premissions restrictions.
icPrefDataErr	=-668	,
//There was a problem with the preference data.
icInternalErr	=-669	,
//An internal error occurred.
icTruncatedErr	=-670	,
//More data was present than was returned.
icNoMoreWritersErr	=-671	,
//You can’t begin a write session because there is already one in progress.
icNothingToOverrideErr	=-672	,
//There is no component for the override component to capture.
icNoURLErr	=-673	,
//No URL was found.
icConfigNotFoundErr=	-674	,
//No configuration was found.
icConfigInappropriateErr=	-675	,
//The manufacturer code is incorrect.
icProfileNotFoundErr	=-676	,
//The profile was not found.
icTooManyProfilesErr	=-677	
//There are too many profiles in the database.*
};


/*Preference Attribute Bits and Masks

typedef UInt32 ICAttr;
enum {
   kICAttrLockedBit = 0,
   kICAttrVolatileBit = 1
};
   
enum {
   kICAttrNoChange = 0xFFFFFFFF,
   kICAttrLockedMask = 0x00000001,
   kICAttrVolatileMask = 0x00000002
};
Constants
kICAttrLockedBit

If the locked bit is set, any attempt to set the preference will result in an error. 

Available in Mac OS X v10.0 and later.
kICAttrVolatileBit

If the volatile bit is set, you should not cache the value of this preference because it is subject to non-seed changing changes.

Available in Mac OS X v10.0 and later.
kICAttrNoChange

Used when you call ICSetPref and do not want to mess around with attributes. You can supply this value and IC will not change the attribute of the preference. 

Available in Mac OS X v10.0 and later.
kICAttrLockedMask

Available in Mac OS X v10.0 and later.
kICAttrVolatileMask

Available in Mac OS X v10.0 and later.
Discussion

The ICAttr type is simply a longint containing flags that describe the attributes of a key and its data.*/
typedef UInt32 ICAttr;
enum {
   kICAttrLockedBit = 0,
   kICAttrVolatileBit = 1
};
   
enum {
   kICAttrNoChange = 0xFFFFFFFF,
   kICAttrLockedMask = 0x00000001,
   kICAttrVolatileMask = 0x00000002
};

//func

/*ICCGetPref

Unsupported

OSStatus ICCGetPref (
   ComponentInstance inst,
   ConstStr255Param key,
   ICAttr *attr,
   Ptr buf,
   SInt32 *size
);
Carbon Porting Notes

Use ICGetPref instead.
Declared In
InternetConfig.h*/
OSStatus ICCGetPref (
   ComponentInstance inst,
   ConstStr255Param key,
   ICAttr *attr,
   Ptr buf,
   SInt32 *size
);

/*ICCStart

Unsupported

OSStatus ICCStart (
   ComponentInstance *inst,
   OSType creator
);
Carbon Porting Notes

Use ICStart instead.
Declared In
InternetConfig.h*/
OSStatus ICCStart (
   ComponentInstance *inst,
   OSType creator
);

/*ICCFindConfigFile

Unsupported

OSStatus ICCFindConfigFile (
   ComponentInstance inst,
   SInt16 count,
   ICDirSpecArrayPtr folders
);
Carbon Porting Notes

Functions related to finding different IC database files are obsolete. You can simply remove these calls from your code—there are no replacement functions.
Declared In
InternetConfig.h*/
OSStatus ICCFindConfigFile (
   ComponentInstance inst,
   SInt16 count,
   ICDirSpecArrayPtr folders
);

/*ICCStop

Unsupported

OSStatus ICCStop (
   ComponentInstance inst
);
Carbon Porting Notes

Use ICStop instead.
Declared In
InternetConfig.h*/
OSStatus ICCStop (
   ComponentInstance inst
);

#ifdef __cplusplus
}
#endif

#endif