#ifndef HIARCHIVE_H
#define HIARCHIVE_H

#ifndef HIOBJECT_H
#include <HIToolbox/HIObject.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*HIArchiveRef

Defines an uncompressed archive object.

typedef struct OpaqueHIArchiveRef* HIArchiveRef;
Discussion

The structure pointed to by this reference is opaque. HIArchiveRef is a CFType, and therefore responds to CFRetain and CFRelease calls. 
Availability
Available in Mac OS X v10.4 and later.*/

typedef struct OpaqueHIArchiveRef* HIArchiveRef;

/*HIArchiveCreateForDecoding

Creates an HIArchive object to retrieve objects.

OSStatus HIArchiveCreateForDecoding(
   CFDataRef       inData,
   OptionBits      inOptions,
   HIArchiveRef *  outDecoder);
Parameters
inData

A CFData reference pointing to archived data. This archive was originally written to a data stream using HIArchiveCopyEncodedData. This data reference does not have to be the one originally returned by HIArchiveCopyEncodedData, but it must contain a copy of the same data. 
inOptions

Any decoding options. Currently the only option is kHIArchiveDecodeSuperclassForUnregisteredObjects.
outDecoder

On return, outDecoder points to the newly created HIArchive object. 
Return Value

A result code.
Discussion

You use this function when you want to retrieve data from an existing HIArchive. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/


OSStatus HIArchiveCreateForDecoding(
   CFDataRef       inData,
   OptionBits      inOptions,
   HIArchiveRef *  outDecoder);

/*HIArchiveCopyDecodedCFType

Retrieves a CFType object from an archive.

OSStatus HIArchiveCopyDecodedCFType(
   HIArchiveRef   inDecoder,
   CFStringRef    inKey,
   CFTypeRef *    outCFType);
Parameters
inDecoder

The archive holding the CFType object to retrieve. 
inKey

A Core Foundation string key identifying the CFType object to retrieve.
outCFType

On return, outCFType points to the retrieved CFType object.
Return Value

A result code.
Discussion

You also use this function for retrieving HIObjects and objects subclassed from HIObject. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveCopyDecodedCFType(
   HIArchiveRef   inDecoder,
   CFStringRef    inKey,
   CFTypeRef *    outCFType);

/*HIArchiveCreateForEncoding

Creates an HIArchive object to store objects. 

OSStatus HIArchiveCreateForEncoding(HIArchiveRef * outEncoder);
Parameters
outEncoder

On return, outEncoder points to the newly created HIArchive object. 
Return Value

A result code.
Discussion

Before you can archive any objects, you must create an HIArchive object in which to store them.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveCreateForEncoding(HIArchiveRef * outEncoder);


/*HIArchiveEncodeCFType

Stores a CFType object in an archive.

OSStatus HIArchiveEncodeCFType(
   HIArchiveRef   inEncoder,
   CFStringRef    inKey,
   CFTypeRef      inCFType) ;
Parameters
inEncoder

The archive to store the CFType object.
inKey

A Core Foundation string key identifying the CFType object.
inCFType

The CFType object to store in the archive.
Return Value

A result code. 
Discussion

You can only encode base CFType objects that correspond to archivable NSFoundation objects. For example, type CFStringRef is supported, but type HIShapeRef is not. 

You also use this function for storing HIObjects and objects subclassed from HIObject. Currently only the following HIObject subclass types support archiving:
HIObjectRef
HIViewRef
WindowRef
ControlRef
MenuRef
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/

OSStatus HIArchiveEncodeCFType(
   HIArchiveRef   inEncoder,
   CFStringRef    inKey,
   CFTypeRef      inCFType) ;

/*HIArchiveCopyEncodedData

Compresses an archive for storage.

OSStatus HIArchiveCopyEncodedData(
   HIArchiveRef   inEncoder,
   CFDataRef *    outData) ;
Parameters
inEncoder

The archive to compress.
outData

On return, outData points to the compressed archive. 
Return Value

A result code. 
Discussion

When you have finished adding data to an archive, calling HIArchiveCopyEncodedData compresses the data and returns it to you as a CFData object. You can use the returned data reference to store or transfer the data as you choose, for example writing it to a file or copying it to a pasteboard. 

After compression, you can release the original HIArchive reference by calling CFRelease. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveCopyEncodedData(
   HIArchiveRef   inEncoder,
   CFDataRef *    outData) ;

/*HIArchiveDecodeNumber

Retrieves a number from an archive. 

OSStatus HIArchiveDecodeNumber(
   HIArchiveRef   inDecoder,
   CFStringRef    inKey,
   CFNumberType   inNumberType,
   void *         outNumberValue)
Parameters
inDecoder

The archive holding the number to retrieve. 
inKey

A Core Foundation string key identifying the number to retrieve.
inNumberType

A CFNumber type identifying the type of number value to be retrieved. For example, kCFNumberSInt32Type. See CFNumber Reference in Core Foundation Reference Documentation for additional possible values. 
outNumberValue

Before calling, outNumberValue must point to a number variable of the type and size you specified in inNumberType. On return, outNumberValue points to the retrieved number.
Return Value

A result code. 
Discussion

This function is a convenience wrapper that calls HIArchiveCopyDecodedCFType to obtain a CFNumber value.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveDecodeNumber(
   HIArchiveRef   inDecoder,
   CFStringRef    inKey,
   CFNumberType   inNumberType,
   void *         outNumberValue);

/*HIArchiveEncodeNumber

Stores a number in an archive.

OSStatus HIArchiveEncodeNumber(
   HIArchiveRef   inEncoder,
   CFStringRef    inKey,
   CFNumberType   inNumberType,
   const void *   inNumberValue);
Parameters
inEncoder

The archive to store the number.
inKey

A Core Foundation string key identifying the number.
inNumberType

A CFNumber type identifying the type of number value to be stored, for example, kCFNumberSInt32Type. See CFNumber Reference in Core Foundation Reference Documentation for additional possible values.
inNumberValue

A pointer to the number value. 
Return Value

A result code.
Discussion

This function is a convenience wrapper that calls HIArchiveEncodeCFType with a CFNumber value. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
HIArchive.h*/
OSStatus HIArchiveEncodeNumber(
   HIArchiveRef   inEncoder,
   CFStringRef    inKey,
   CFNumberType   inNumberType,
   const void *   inNumberValue);

#ifdef __cplusplus
}
#endif

#endif 
