#ifndef _IOKIT_IOFIREWIREAVCLIB_H_
#define _IOKIT_IOFIREWIREAVCLIB_H_

#include <IOKit/IOCFPlugIn.h>
#include <IOKit/firewire/IOFireWireFamilyCommon.h>
#include <IOKit/avc/IOFireWireAVCConsts.h>

#include  <APPLE/IOKit/avc/IOFireWireAVCLib.h>

typedef struct
 {
IUNKNOWN_C_GUTS;

/*open


Exclusively opens a connection to the in-kernel device. 
IOReturn (*open)(
    void *self );  
Parameters
self
Pointer to IOFireWireAVCLibUnitInterface.
Return Value

Returns kIOReturnSuccess on success. 
Discussion 

Exclusively opens a connection to the in-kernel device. As long as the in-kernel device object is open, no other drivers will be able to open a connection to the device. When open, the device on the bus may disappear, but the in-kernel object representing it will stay instantiated and can begin communicating with the device again if it ever reappears.*/
IOReturn (*open)(
    void *self );  

/*AVCCommand


Sends an AV/C command to the device and returns the response. 
IOReturn (*AVCCommand)(
    void *self, 
    const UInt8 *command,
    UInt32 cmdLen,
    UInt8 *response,
    UInt32 *responseLen);  
Parameters
self
Pointer to IOFireWireAVCLibUnitInterface.
command
Pointer to command to send.
cmdLen
Length (in bytes) of command.
response
Pointer to place to store the response sent by the device.
responseLen
Pointer to place to store the length of the response. On entry, this parameter contains the size of the response buffer in bytes; on exit, it contains the number of valid bytes in the response buffer.
Discussion 

This function will block until the device returns a response or the kernel driver times out.*/
IOReturn (*AVCCommand)(
    void *self, 
    const UInt8 *command,
    UInt32 cmdLen,
    UInt8 *response,
    UInt32 *responseLen); 

/*close


Closes an exclusive access to the device. 
void (*close)(
    void *self );  
Parameters
self
Pointer to IOFireWireAVCLibUnitInterface.
Discussion 

Closes an exclusive access to the device. When a device is closed it may be unloaded by the kernel. If it is unloaded and then later reappears it will be represented by a different object. You won't be able to use this user client on the new object. The new object will have to be looked up in the I/O Registry and a new user client will have to be opened on it.*/
void (*close)(
    void *self );  

 } IOFireWireAVCLibUnitInterface;

#endif
