#ifndef IOKIT_HID_IOHIDLIB_H_
#define IOKIT_HID_IOHIDLIB_H_

#include <sys/cdefs.h>
#include <CoreFoundation/CoreFoundation.h>
#if COREFOUNDATION_CFPLUGINCOM_SEPARATE
#include <CoreFoundation/CFPlugInCOM.h>
#endif

#include <IOKit/IOTypes.h>
#include <IOKit/IOReturn.h>
#include <IOKit/hid/IOHIDKeys.h>
//#include <HYS/IOKit/hid/IOHIDLib.h>
#include <APPLE/IOKit/hid/IOHIDLib.h>
/*kIOHIDDeviceInterfaceID

#define kIOHIDDeviceInterfaceID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x78, 0xBD, 0x42, 0x0C, 0x6F, 0x14, 0x11, 0xD4, \ 
    0x94, 0x74, 0x00, 0x05, 0x02, 0x8F, 0x18, 0xD5) 
Discussion 

Interface ID for the IOHIDDeviceInterface. Corresponds to an available HID device.*/

#define kIOHIDDeviceInterfaceID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x78, 0xBD, 0x42, 0x0C, 0x6F, 0x14, 0x11, 0xD4, \ 
    0x94, 0x74, 0x00, 0x05, 0x02, 0x8F, 0x18, 0xD5) 

/*IOHIDEventStruct

See Also:
IOHIDEventStruct
struct IOHIDEventStruct { 
    IOHIDElementType type; 
    IOHIDElementCookie elementCookie; 
    SInt32 value; 
    AbsoluteTime timestamp; 
    UInt32 longValueSize; 
    void *longValue; 
};  
Discussion 

HID Event Structure*/
struct IOHIDEventStruct {
    IOHIDElementType type;
    IOHIDElementCookie elementCookie;
    SInt32 value;
    AbsoluteTime timestamp;
    UInt32 longValueSize;
    void *longValue;
};

/*IOHIDEventStruct

See Also:
IOHIDEventStruct
typedef struct IOHIDEventStruct IOHIDEventStruct;  
Discussion 

HID Event Structure*/
typedef struct IOHIDEventStruct IOHIDEventStruct;  

/*IOHIDCallbackFunction

typedef void (*IOHIDCallbackFunction) (
    void *target,
    IOReturn result,
    void *refcon,
    void *sender);  
Parameters
target
void * pointer to your data, often a pointer to an object.
result
Completion result of desired operation.
refcon
void * pointer to more data.
sender
Interface instance sending the completion routine.
Discussion 

Type and arguments of callout C function that is used when a completion routine is called, see setRemovalCallback.*/
typedef void (*IOHIDCallbackFunction) (
    void *target,
    IOReturn result,
    void *refcon,
    void *sender);  

struct IOHIDQueueInterface
{

 IUNKNOWN_C_GUTS;

/*getAsyncEventSource


Obtains the current event source. 
CFRunLoopSourceRef (*getAsyncEventSource)(
    void *self);  
Return Value

Returns a CFRunLoopSourceRef.*/
CFRunLoopSourceRef (*getAsyncEventSource)(
    void *self);  

/*getNextEvent


Reads next event from the queue. 
IOReturn (*getNextEvent)(
    void *self, 
    IOHIDEventStruct *event, 
    AbsoluteTime maxTime, 
    UInt32 timeoutMS);  
Parameters
event
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
maxtime
UNSUPPORTED. If non-zero, limits read events to those that occured on or before maxTime.
timoutMS
UNSUPPORTED. The timeout in milliseconds, a zero timeout will cause this call to be non-blocking (returning queue empty) if there is a NULL callback, and blocking forever until the queue is non-empty if there is a valid callback.
Return Value

Returns an IOReturn code.*/
IOReturn (*getNextEvent)(
    void *self, 
    IOHIDEventStruct *event, 
    AbsoluteTime maxTime, 
    UInt32 timeoutMS);  


/*removeElement


Removes an element from the queue. 
IOReturn (*removeElement)(
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns an IOReturn code. 
Discussion 

If the element has not been added to queue, an error will be returned.*/
IOReturn (*removeElement)(
    void *self,
    IOHIDElementCookie elementCookie);  


/*start


Starts event delivery to the queue. 
IOReturn (*start)(
    void *self);  
Return Value

Returns an IOReturn code.*/
IOReturn (*start)(
    void *self);  
/*addElement


Adds an element to the queue. 
IOReturn (*addElement)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    UInt32 flags);  
Parameters
elementCookie
The element of interest.
flags
Return Value

Returns an IOReturn code. 
Discussion 

If the element has already been added to queue, an error will be returned.*/
IOReturn (*addElement)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    UInt32 flags);  



/*dispose


Disposes of the current queue. 
See Also:
create
IOReturn (*dispose)(
    void *self);  */
IOReturn (*dispose)(
    void *self);


/*create(void *, UInt32, UInt32)


Creates the current queue. 
IOReturn (*create)(
    void *self, 
    UInt32 flags, 
    UInt32 depth);  
Parameters
flags
depth
The maximum number of elements in the queue before the oldest elements in the queue begin to be lost.
Return Value

Returns an IOReturn code.*/
IOReturn (*create)(
    void *self,
    UInt32 flags, 
    UInt32 depth);

/*hasElement


Checks whether an element has been added to the queue. 
Boolean (*hasElement)(
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns a Boolean value. 
Discussion 

Will return true if present, otherwise will return false.*/
Boolean (*hasElement)(
    void *self,
    IOHIDElementCookie elementCookie);  

/*stop


Stops event delivery to the queue. 
IOReturn (*stop)(
    void *self);  
Return Value

Returns an IOReturn code.*/
IOReturn (*stop)(
    void *self);  

/*createAsyncEventSource


Creates an async event source. 
IOReturn (*createAsyncEventSource)(
    void *self, 
    CFRunLoopSourceRef *source);  
Parameters
source
The newly created event source.
Return Value

Returns an IOReturn code. 
Discussion 

This will be used with setEventCallout.*/
IOReturn (*createAsyncEventSource)(
    void *self, 
    CFRunLoopSourceRef *source);  

/*setEventCallout


Sets the event callout to be called when the queue transitions to non-empty. 
IOReturn (*setEventCallout)(
    void *self, 
    IOHIDCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  
Parameters
callback
if non-NULL is a callback to be called when data is inserted to the queue
callbackTarget
The callback target passed to the callback
callbackRefcon
The callback refcon passed to the callback.
Return Value

Returns an IOReturn code. 
Discussion 

In order for this to work correctly, you must call createAsyncPort and createAsyncEventSource.*/
IOReturn (*setEventCallout)(
    void *self, 
    IOHIDCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon); 
};
typedef struct  IOHIDQueueInterface IOHIDQueueInterface;

/*IOHIDElementCallbackFunction

typedef void (*IOHIDElementCallbackFunction) (
    void *target, 
    IOReturn result, 
    void *refcon, 
    void *sender, 
    IOHIDElementCookie elementCookie);  
Parameters
target
void * pointer to your data, often a pointer to an object.
result
Completion result of desired operation.
refcon
void * pointer to more data.
sender
Interface instance sending the completion routine.
elementCookie
Element within interface instance sending completion.
Discussion 

Type and arguments of callout C function that is used when a completion routine is called, see setElementValue.*/

typedef void (*IOHIDElementCallbackFunction) (
    void *target, 
    IOReturn result, 
    void *refcon, 
    void *sender, 
    IOHIDElementCookie elementCookie);  

/*IOHIDReportCallbackFunction

typedef void (*IOHIDReportCallbackFunction) (
    void *target, 
    IOReturn result, 
    void *refcon, 
    void *sender, 
    UInt32 bufferSize);  
Parameters
target
void * pointer to your data, often a pointer to an object.
result
Completion result of desired operation.
refcon
void * pointer to more data.
sender
Interface instance sending the completion routine.
bufferSize
Size of the buffer received upon completion.
Discussion 

Type and arguments of callout C function that is used when a completion routine is called, see setReport.*/
typedef void (*IOHIDReportCallbackFunction) (
    void *target, 
    IOReturn result, 
    void *refcon, 
    void *sender, 
    UInt32 bufferSize);  

struct IOHIDOutputTransactionInterface
{
    IUNKNOWN_C_GUTS;
/*create


Creates the current transaction. 
IOReturn (*create)(
    void *self);  
Return Value

Returns an IOReturn code. 
Discussion 

This method will free any memory that has been allocated for this transaction.*/
IOReturn (*create)(
    void *self);  

/*addElement


Adds an element to the transaction. 
IOReturn (*addElement) (
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns an IOReturn code. 
Discussion 

If the element has already been added to transaction, an error will be returned.*/
IOReturn (*addElement) (
    void *self,
    IOHIDElementCookie elementCookie);  

/*getElementValue


Obtains the value of an element in a transaction. 
IOReturn (*getElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *outValueEvent);  
Parameters
elementCookie
The element of interest.
outValueEvent
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
Return Value

Returns an IOReturn code. 
Discussion 

An error will be returned if the element has not been added to the transaction.*/
IOReturn (*getElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *outValueEvent);  

/*commit


Commits the transaction. 
IOReturn (*commit)(
    void *self, 
    UInt32 timeoutMS, 
    IOHIDCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  
Parameters
timeoutMS
UNSUPPORTED
callback
UNSUPPORTED
callbackTarget
UNSUPPORTED
callbackRefcon
UNSUPPORTED
Return Value

Returns an IOReturn code. 
Discussion 

Transaction element values, if set, will be sent to the device. Otherwise, the default element value will be used. If neither are set, that element will be omitted from the commit. After a transaction is committed, transaction element values will be cleared. Default values will be preserved.*/
IOReturn (*commit)(
    void *self, 
    UInt32 timeoutMS, 
    IOHIDCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  

/*setElementValue


Sets the value of an element in a transaction. 
IOReturn (*setElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  
Parameters
elementCookie
The element of interest.
valueEvent
The event that will be filled. If a long value is present, it will be copied.
Return Value

Returns an IOReturn code. 
Discussion 

An error will be returned if the element has not been added to the transaction.*/
IOReturn (*setElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  

/*getElementDefault


Obtains the default value of an element in a transaction. 
IOReturn (*getElementDefault)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *outValueEvent);  
Parameters
elementCookie
The element of interest.
outValueEvent
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
Return Value

Returns an IOReturn code. 
Discussion 

An error will be returned if the element has not been added to the transaction.*/
IOReturn (*getElementDefault)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *outValueEvent);  

/*hasElement


Checks whether an element has been added to the transaction. 
Boolean (*hasElement) (
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns a Boolean value. 
Discussion 

Will return true if present, otherwise will return false.*/
Boolean (*hasElement) (
    void *self,
    IOHIDElementCookie elementCookie);  

/*clear


Clears the transaction. 
IOReturn (*clear)(
    void *self);  
Return Value

Returns an IOReturn code. 
Discussion 

Transaction element values will cleared. Default values will be preserved.*/
IOReturn (*clear)(
    void *self);  

/*removeElement


Removes an element from the transaction. 
IOReturn (*removeElement) (
    void *self,
    IOHIDElementCookie elementCookie);  
Parameters
elementCookie
The element of interest.
Return Value

Returns an IOReturn code. 
Discussion 

If the element has not been added to transaction, an error will be returned.*/
IOReturn (*removeElement) (
    void *self,
    IOHIDElementCookie elementCookie);  

/*setElementDefault


Sets the default value of an element in a transaction. 
IOReturn (*setElementDefault)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  
Parameters
elementCookie
The element of interest.
valueEvent
The event that will be filled. If a long value is present, it will be copied.
Return Value

Returns an IOReturn code. 
Discussion 

An error will be returned if the element has not been added to the transaction.*/
IOReturn (*setElementDefault)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  

};
typedef struct IOHIDOutputTransactionInterface IOHIDOutputTransactionInterface;


typedef struct IOHIDDeviceInterface
{
 IUNKNOWN_C_GUTS;
 IOHIDDEVICEINTERFACE_FUNCS_121;

/*allocOutputTransaction


Wrapper to return instances of the IOHIDOutputTransactionInterface. 
IOHIDOutputTransactionInterface ** (*allocOutputTransaction) (
    void *self);  
Return Value

Returns the created IOHIDOutputTransactionInterface.*/
IOHIDOutputTransactionInterface ** (*allocOutputTransaction) (
    void *self);

/*open


Opens the device. 
IOReturn (*open)(
    void *self,
    UInt32 flags);  
Parameters
flags
Flags to be passed down to the user client.
Return Value

Returns an IOReturn code.*/
IOReturn (*open)(
    void *self,
    UInt32 flags);  

/*close


Closes the device. 
IOReturn (*close)(
    void *self);  
Return Value

Returns an IOReturn code.*/
IOReturn (*close)(
    void *self);  

/*getElementValue


Obtains the most recent value of an element. 
IOReturn (*getElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  
Parameters
elementCookie
The element of interest.
valueEvent
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
Return Value

Returns an IOReturn code. 
Discussion 

This call is most useful for interrupt driven elements, such as input type elements. Since feature type element values need to be polled from the device, it is recommended to use the queryElementValue method to obtain the current value. The timestamp field in the event details the last time the element value was*/
IOReturn (*getElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent);  


/*allocQueue


Wrapper to return instances of the IOHIDQueueInterface. 
IOHIDQueueInterface ** (*allocQueue) (
    void *self);  
Return Value

Returns the created IOHIDQueueInterface.*/
IOHIDQueueInterface ** (*allocQueue) (
    void *self);

/*queryElementValue


Obtains the current value of an element. 
IOReturn (*queryElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent, 
    UInt32 timeoutMS, 
    IOHIDElementCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  
Parameters
elementCookie
The element of interest.
valueEvent
The event that will be filled. If a long value is present, it is up to the caller to deallocate it.
timeoutMS
UNSUPPORTED.
callback
UNSUPPORTED.
callbackTarget
UNSUPPORTED.
callbackRefcon
UNSUPPORTED.
Return Value

Returns an IOReturn code. 
Discussion 

This call is most useful for feature type elements. This method will poll the device for the current element value.*/
IOReturn (*queryElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent, 
    UInt32 timeoutMS, 
    IOHIDElementCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  

/*setElementValue


Sets an element value on the device. 
IOReturn (*setElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent, 
    UInt32 timeoutMS, 
    IOHIDElementCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  
Parameters
elementCookie
The element of interest.
valueEvent
The event that will be filled. If a long value is present, it will be copied.
timeoutMS
UNSUPPORTED.
callback
UNSUPPORTED.
callbackTarget
UNSUPPORTED.
callbackRefcon
UNSUPPORTED.
Return Value

Returns an IOReturn code. 
Discussion 

This call is most useful for feature type elements. It is recommended to use IOOutputTransaction for output type elements.*/
IOReturn (*setElementValue)(
    void *self, 
    IOHIDElementCookie elementCookie, 
    IOHIDEventStruct *valueEvent, 
    UInt32 timeoutMS, 
    IOHIDElementCallbackFunction callback, 
    void *callbackTarget, 
    void *callbackRefcon);  


} IOHIDDeviceInterface;

/*IOHIDCallbackFunction

typedef void (*IOHIDCallbackFunction) (
    void *target,
    IOReturn result,
    void *refcon,
    void *sender);  
Parameters
target
void * pointer to your data, often a pointer to an object.
result
Completion result of desired operation.
refcon
void * pointer to more data.
sender
Interface instance sending the completion routine.
Discussion 

Type and arguments of callout C function that is used when a completion routine is called, see setRemovalCallback.*/
typedef void (*IOHIDCallbackFunction) (
    void *target,
    IOReturn result,
    void *refcon,
    void *sender);  

/*IOHIDEventStruct

See Also:
IOHIDEventStruct
typedef struct IOHIDEventStruct IOHIDEventStruct;  
Discussion 

HID Event Structure*/

typedef struct IOHIDEventStruct IOHIDEventStruct;  


#endif 
