#ifndef OPENTRANSPORT_H
#define OPENTRANSPORT_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif

#ifdef __cplusplus
#include <stddef.h>
#endif

#include <asm-generic/errno-base.h> //hys
#include <asm-generic/errno.h> //hys

//#include <HYS/OSServices/OpenTransport.h>
#include <APPLE/OSServices/OpenTransport.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*OTUInt8Param


typedef UInt8 OTUInt8Param;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt8 OTUInt8Param;

/*TLookupBuffer

Defines the format of entries in the buffer passed back in the reply parameter of the OTLookupName function.

struct TLookupBuffer {
   UInt16 fAddressLength;
   UInt16 fNameLength;
   UInt8 fAddressBuffer[1];
};
typedef struct TLookupBuffer TLookupBuffer;
Fields
fAddressLength

Specifies the size of the address specified by the fAddressBuffer field.
fNameLength

Specifies the size of the name that is stored in the buffer following the fAddressBuffer field.
fAddressBuffer

The first byte of the address to which the entity whose name follows (in the buffer) is bound. 
Discussion

The TLookupBuffer structure defines the format of entries in the buffer passed back in the reply parameter of the OTLookupName function. When you parse the buffer in which the OTLookupName function places the names it has found, you can cast it as a TLookupBuffer structure.
Availability
Available in Mac OS X v10.0 and later.*/
struct TLookupBuffer {
   UInt16 fAddressLength;
   UInt16 fNameLength;
   UInt8 fAddressBuffer[1];
};
typedef struct TLookupBuffer TLookupBuffer;


/*MapperRef


typedef struct OpaqueMapperRef * MapperRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMapperRef * MapperRef;

/*Endpoint Flags

Specifies information about an endpoint.

enum {
   T_SENDZERO = 0x0001,
   T_XPG4_1 = 0x0002,
   T_CAN_SUPPORT_MDATA = 0x10000000,
   T_CAN_RESOLVE_ADDR = 0x40000000,
   T_CAN_SUPPLY_MIB = 0x20000000
};
Constants
T_SENDZERO

This endpoint lets you send and receive zero-length TSDUs.

Available in Mac OS X v10.0 and later.
T_XPG4_1

This endpoint supports the OTGetProtAddress function (conforms to XTI in XPG4).

Available in Mac OS X v10.0 and later.
T_CAN_SUPPORT_MDATA

This endpoint supports M_DATA, that is, it permits receiving and returning raw packets.

Available in Mac OS X v10.0 and later.
T_CAN_RESOLVE_ADDR

This endpoint supports the OTResolveAddress function.

Available in Mac OS X v10.0 and later.
T_CAN_SUPPLY_MIB

This endpoint can supply the Management Information Base (MIB) data used by the Simple Network Management Protocol (SNMP). At this time you cannot access this data.

Available in Mac OS X v10.0 and later.*/
enum {
   T_SENDZERO = 0x0001,
   T_XPG4_1 = 0x0002,
   T_CAN_SUPPORT_MDATA = 0x10000000,
   T_CAN_RESOLVE_ADDR = 0x40000000,
   T_CAN_SUPPLY_MIB = 0x20000000
};


/*T_INFINITE


enum {
   T_INFINITE = -1,
   T_INVALID = -2
};
Constants
T_INFINITE

Available in Mac OS X v10.0 and later.
T_INVALID

Available in Mac OS X v10.0 and later.*/
enum {
   T_INFINITE = -1,
   T_INVALID = -2
};


/*OTData Structure

Specifies the location and size of noncontiguous data.

struct OTData {
   void * fNext;
   void * fData;
   ByteCount fLen;
};
typedef struct OTData OTData;
Fields
fNext

A pointer to the OTData structure that describes the next data fragment. Specify a NULL pointer for the last data fragment.
fData

A pointer to the data fragment.
fLen

Specifies the size of the fragment in bytes.
Discussion

The OTData structure is an Apple extension used to specify the location and size of noncontiguous data. You use a pointer to this structure in place of a pointer to continguous data normally referenced in TNetbuf.buf field. You can send discontiguous data using the OTSndUData function, the OTSndURequest function, the OTSndUReply function, the OTSnd function, the OTSndRequest function, and the OTSndReply function.

Each OTData structure specifies the location of a data fragment, the size of the fragment, and the location of the OTData structure that specifies the location and size of the next data fragment. The data information structure is defined by the OTData type. For more information, see “Sending Noncontiguous Data.”
Availability
Available in Mac OS X v10.0 and later.*/
struct OTData {
   void * fNext;
   void * fData;
   ByteCount fLen;
};
typedef struct OTData OTData;


/*kNetbufDataIsOTData


enum {
   kNetbufDataIsOTData = 0xFFFFFFFE
};
Constants
kNetbufDataIsOTData

Available in Mac OS X v10.0 and later.*/

enum {
   kNetbufDataIsOTData = 0xFFFFFFFE
};


/*MIOC_STREAMIO


enum {
   MIOC_STREAMIO = 65,
   MIOC_TMOD = 'a',
   MIOC_STRLOG = 'b',
   MIOC_ND = 'c',
   MIOC_ECHO = 'd',
   MIOC_TLI = 'e',
   MIOC_RESERVEDf = 'f',
   MIOC_SAD = 'g',
   MIOC_ARP = 'h',
   MIOC_HAVOC = 72,
   MIOC_RESERVEDi = 'i',
   MIOC_SIOC = 'j',
   MIOC_TCP = 'k',
   MIOC_DLPI = 'l',
   MIOC_SOCKETS = 'm',
   MIOC_IPX = 'o',
   MIOC_OT = 79,
   MIOC_ATALK = 84,
   MIOC_SRL = 85,
   MIOC_RESERVEDp = 'p',
   MIOC_RESERVEDr = 'r',
   MIOC_RESERVEDs = 's',
   MIOC_CFIG = 'z'
};
Constants
MIOC_STREAMIO

Available in Mac OS X v10.0 and later.
MIOC_TMOD

Available in Mac OS X v10.0 and later.
MIOC_STRLOG

Available in Mac OS X v10.0 and later.
MIOC_ND

Available in Mac OS X v10.0 and later.
MIOC_ECHO

Available in Mac OS X v10.0 and later.
MIOC_TLI

Available in Mac OS X v10.0 and later.
MIOC_RESERVEDf

Available in Mac OS X v10.0 and later.
MIOC_SAD

Available in Mac OS X v10.0 and later.
MIOC_ARP

Available in Mac OS X v10.0 and later.
MIOC_HAVOC

Available in Mac OS X v10.0 and later.
MIOC_RESERVEDi

Available in Mac OS X v10.0 and later.
MIOC_SIOC

Available in Mac OS X v10.0 and later.
MIOC_TCP

Available in Mac OS X v10.0 and later.
MIOC_DLPI

Available in Mac OS X v10.0 and later.
MIOC_SOCKETS

Available in Mac OS X v10.0 and later.
MIOC_IPX

Available in Mac OS X v10.0 and later.
MIOC_OT

Available in Mac OS X v10.0 and later.
MIOC_ATALK

Available in Mac OS X v10.0 and later.
MIOC_SRL

Available in Mac OS X v10.0 and later.
MIOC_RESERVEDp

Available in Mac OS X v10.0 and later.
MIOC_RESERVEDr

Available in Mac OS X v10.0 and later.
MIOC_RESERVEDs

Available in Mac OS X v10.0 and later.
MIOC_CFIG

Available in Mac OS X v10.0 and later.*/
enum {
   MIOC_STREAMIO = 65,
   MIOC_TMOD = 'a',
   MIOC_STRLOG = 'b',
   MIOC_ND = 'c',
   MIOC_ECHO = 'd',
   MIOC_TLI = 'e',
   MIOC_RESERVEDf = 'f',
   MIOC_SAD = 'g',
   MIOC_ARP = 'h',
   MIOC_HAVOC = 72,
   MIOC_RESERVEDi = 'i',
   MIOC_SIOC = 'j',
   MIOC_TCP = 'k',
   MIOC_DLPI = 'l',
   MIOC_SOCKETS = 'm',
   MIOC_IPX = 'o',
   MIOC_OT = 79,
   MIOC_ATALK = 84,
   MIOC_SRL = 85,
   MIOC_RESERVEDp = 'p',
   MIOC_RESERVEDr = 'r',
   MIOC_RESERVEDs = 's',
   MIOC_CFIG = 'z'
};

/*Endpoint States

Define enpoint states for the OTGetEndpointState function.

typedef UInt32 OTXTIStates;
enum {
   T_UNINIT = 0,
   T_UNBND = 1,
   T_IDLE = 2,
   T_OUTCON = 3,
   T_INCON = 4,
   T_DATAXFER = 5,
   T_OUTREL = 6,
   T_INREL = 7
};
Constants
T_UNINIT

This endpoint has been closed and destroyed.

Available in Mac OS X v10.0 and later.
T_UNBND

This endpoint is initialized but has not yet been bound to an address.

Available in Mac OS X v10.0 and later.
T_IDLE

This endpoint has been bound to an address and is ready for use: connectionless endpoints can send or receive data; connection-oriented endpoints can initiate or listen for a connection.

Available in Mac OS X v10.0 and later.
T_OUTCON

This endpoint has initiated a connection and is waiting for the peer endpoint to accept the connection.

Available in Mac OS X v10.0 and later.
T_INCON

This endpoint has received a connection request but has not yet accepted or rejected the request.

Available in Mac OS X v10.0 and later.
T_DATAXFER

This connection-oriented endpoint can now transfer data because the connection has been established.

Available in Mac OS X v10.0 and later.
T_OUTREL

This endpoint has issued an orderly disconnect that the peer has not acknowledged. The endpoint can continue to read data, but must not send any more data.

Available in Mac OS X v10.0 and later.
T_INREL

This endpoint has received a request for an orderly disconnect, which it has not yet acknowledged. The endpoint can continue to send data until it acknowledges the disconnection request, but it must not read data.

Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTXTIStates;
enum {
   T_UNINIT = 0,
   T_UNBND = 1,
   T_IDLE = 2,
   T_OUTCON = 3,
   T_INCON = 4,
   T_DATAXFER = 5,
   T_OUTREL = 6,
   T_INREL = 7
};


/*OTReason


typedef SInt32 OTReason;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTReason;

/*OTProcessProcPtr


typedef void (*OTProcessProcPtr) (
   void *arg
);

If you name your function MyOTProcessProc, you would declare it like this:

void MyOTProcessProc (
   void *arg
);
Parameters
arg
Carbon Porting Notes

Use the OTProcessUPP type instead.*/

typedef void (*OTProcessProcPtr) (
   void *arg
);


/*OTTimeout


typedef UInt32 OTTimeout;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTTimeout;

/*The OTConfiguration Structure
Open Transport functions that open a provider take as a parameter a pointer to a configuration structure that specifies the configuration of that provider. For example, the configuration structure of an endpoint specifies which protocol modules the endpoint uses. To create a configuration structure and obtain a pointer to it, you call the function OTCreateConfiguration. To make a copy of a configuration structure, you call the function OTCloneConfiguration.

The contents of the OTConfiguration structure are private and so is the OTConfiguration data type that defines it.

struct OTConfiguration;
typedef struct OTConfiguration OTConfiguration;
See "Error Constants" for values that can be returned if the configuration was not successful.*/
struct OTConfiguration;
typedef struct OTConfiguration OTConfiguration;

/*OTLink

Allows any data structure to be used in an Open Transport list.

struct OTLink {
   OTLink * fNext;
};
typedef struct OTLink OTLink;
Fields
fNext

A pointer to the next entry in the linked list. 
Discussion

All of Open Transport’s list utilities use the linked list structure, which may be embedded in any data structure that you want to use in an Open Transport list. A linked list structure is defined by the OTLink data type.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OTLink OTLink;

struct OTLink {
   OTLink * fNext;
};



/*kOTInvalidRef


enum {
   kOTInvalidRef = 0,
   kOTInvalidProviderRef = 0,
   kOTInvalidEndpointRef = 0,
   kOTInvalidMapperRef = 0
};
Constants
kOTInvalidRef

Available in Mac OS X v10.0 and later.
kOTInvalidProviderRef

Available in Mac OS X v10.0 and later.
kOTInvalidEndpointRef

Available in Mac OS X v10.0 and later.
kOTInvalidMapperRef

Available in Mac OS X v10.0 and later.*/
enum {
   kOTInvalidRef = 0,
   kOTInvalidProviderRef = 0,
   kOTInvalidEndpointRef = 0,
   kOTInvalidMapperRef = 0
};


/*kOTNetbufDataIsOTBufferStar


enum {
   kOTNetbufDataIsOTBufferStar = 0xFFFFFFFD
};
Constants
kOTNetbufDataIsOTBufferStar

Available in Mac OS X v10.0 and later.*/

enum {
   kOTNetbufDataIsOTBufferStar = 0xFFFFFFFD
};



/*Event Codes

Define the constant names that provider functions can use for event codes, or define port-related events Open Transport can send to an client application.

typedef UInt32 OTEventCode;
enum {
   T_LISTEN = 0x0001,
   T_CONNECT = 0x0002,
   T_DATA = 0x0004,
   T_EXDATA = 0x0008,
   T_DISCONNECT = 0x0010,
   T_ERROR = 0x0020,
   T_UDERR = 0x0040,
   T_ORDREL = 0x0080,
   T_GODATA = 0x0100,
   T_GOEXDATA = 0x0200,
   T_REQUEST = 0x0400,
   T_REPLY = 0x0800,
   T_PASSCON = 0x1000,
   T_RESET = 0x2000,
   kPRIVATEEVENT = 0x10000000,
   kCOMPLETEEVENT = 0x20000000,
   T_BINDCOMPLETE = 0x20000001,
   T_UNBINDCOMPLETE = 0x20000002,
   T_ACCEPTCOMPLETE = 0x20000003,
   T_REPLYCOMPLETE = 0x20000004,
   T_DISCONNECTCOMPLETE = 0x20000005,
   T_OPTMGMTCOMPLETE = 0x20000006,
   T_OPENCOMPLETE = 0x20000007,
   T_GETPROTADDRCOMPLETE = 0x20000008,
   T_RESOLVEADDRCOMPLETE = 0x20000009,
   T_GETINFOCOMPLETE = 0x2000000A,
   T_SYNCCOMPLETE = 0x2000000B,
   T_MEMORYRELEASED = 0x2000000C,
   T_REGNAMECOMPLETE = 0x2000000D,
   T_DELNAMECOMPLETE = 0x2000000E,
   T_LKUPNAMECOMPLETE = 0x2000000F,
   T_LKUPNAMERESULT = 0x20000010,
   kOTSyncIdleEvent = 0x20000011,
   kSTREAMEVENT = 0x21000000,
   kOTReservedEvent1 = 0x21000001,
   kGetmsgEvent = 0x21000002,
   kStreamReadEvent = 0x21000003,
   kStreamWriteEvent = 0x21000004,
   kStreamIoctlEvent = 0x21000005,
   kOTReservedEvent2 = 0x21000006,
   kStreamOpenEvent = 0x21000007,
   kPollEvent = 0x21000008,
   kOTReservedEvent3 = 0x21000009,
   kOTReservedEvent4 = 0x2100000A,
   kOTReservedEvent5 = 0x2100000B,
   kOTReservedEvent6 = 0x2100000C,
   kOTReservedEvent7 = 0x2100000D,
   kOTReservedEvent8 = 0x2100000E,
   kSIGNALEVENT = 0x22000000,
   kPROTOCOLEVENT = 0x23000000,
   kOTProviderIsDisconnected = 0x23000001,
   kOTProviderIsReconnected = 0x23000002,
   kOTProviderWillClose = 0x24000001,
   kOTProviderIsClosed = 0x24000002,
   kOTPortDisabled = 0x25000001,
   kOTPortEnabled = 0x25000002,
   kOTPortOffline = 0x25000003,
   kOTPortOnline = 0x25000004,
   kOTClosePortRequest = 0x25000005,
   kOTYieldPortRequest = 0x25000005,
   kOTNewPortRegistered = 0x25000006,
   kOTPortNetworkChange = 0x25000007,
   kOTConfigurationChanged = 0x26000001,
   kOTSystemSleep = 0x26000002,
   kOTSystemShutdown = 0x26000003,
   kOTSystemAwaken = 0x26000004,
   kOTSystemIdle = 0x26000005,
   kOTSystemSleepPrep = 0x26000006,
   kOTSystemShutdownPrep = 0x26000007,
   kOTSystemAwakenPrep = 0x26000008,
   kOTStackIsLoading = 0x27000001,
   kOTStackWasLoaded = 0x27000002,
   kOTStackIsUnloading = 0x27000003
};
   
/*  The following event codes are used internally by Open Transport.*
enum {
   kOTDisablePortEvent = 0x21000001,
   kStreamCloseEvent = 0x21000006,
   kBackgroundStreamEvent = 0x21000009,
   kIoctlRecvFdEvent = 0x2100000A,
   kOTTryShutdownEvent = 0x2100000B,
   kOTScheduleTerminationEvent = 0x2100000C,
   kOTEnablePortEvent = 0x2100000D,
   kOTNewPortRegisteredEvent = 0x2100000E,
   kOTPortOfflineEvent = 0x2100000F,
   kOTPortOnlineEvent = 0x21000010,
   kOTPortNetworkChangeEvent = 0x21000011
};
Constants
T_LISTEN

A connection request has arrived. Call the OTListen function to read the request.

Available in Mac OS X v10.0 and later.
T_CONNECT

The passive peer has accepted a connection that you requested using the OTConnect function. Call the OTRcvConnect function to retrieve any data or option information that the passive peer has specified when accepting the connection or to retrieve the address to which you are actually connected. The cookie parameter to the notifier function is the sndCall parameter that you specified when calling the OTConnect function. 

Available in Mac OS X v10.0 and later.
T_DATA

Normal data has arrived. Depending on the type of service of the endpoint you are using, you can call the OTRcvUData function or the OTRcv function to read it. Continue reading data until the function returns with the kOTNoDataErr result; you will not get another indication that data has arrived until you have read all the data and got this error.

Available in Mac OS X v10.0 and later.
T_EXDATA

Expedited data has arrived. Use the OTRcv function to read it. Continue reading data by calling the OTRcv function until the function returns with the kOTNoDataErr result; you will not get another indication that data has arrived until you have read all the data and got this error.

Available in Mac OS X v10.0 and later.
T_DISCONNECT

A connection has been torn down or rejected. Use the OTRcvDisconnect function to clear the event.

If the event is used to signify that a connection has been terminated, the cookie parameter to the notifier is NULL.

If the event indicates a rejected connection request, the cookie parameter to the notification routine is the same as the sndCall parameter that you passed to the OTConnect function.

Available in Mac OS X v10.0 and later.
T_ERROR

Obsolete.

Available in Mac OS X v10.0 and later.
T_UDERR

The provider was not able to send the data you specified using the OTSndUData function even though the function returned successfully. You must call the OTRcvUDErr function to clear this event and determine why the function failed.

Available in Mac OS X v10.0 and later.
T_ORDREL

The remote client has called the OTSndOrderlyDisconnect function to initiate an orderly disconnect. You must call the OTRcvOrderlyDisconnect function to acknowledge receiving the event.

Available in Mac OS X v10.0 and later.
T_GODATA

Flow-control restrictions have been lifted. You can now send normal data.

Available in Mac OS X v10.0 and later.
T_GOEXDATA

Flow-control restrictions have been lifted. You can now send expedited data.

Available in Mac OS X v10.0 and later.
T_REQUEST

A request has arrived. Depending on the type of service for the endpoint you are using, you can call the OTRcvRequest function or the OTRcvURequest function to receive it. You must continue to call the function until it returns with the kOTNoDataErr result. 

Available in Mac OS X v10.0 and later.
T_REPLY

A response to a request has arrived. Depending on the type of service of the endpoint you are using, you can call the OTRcvReply function or OTRcvUReply function to receive it. You must continue to call the function until it returns with the kOTNoDataErr result.

Available in Mac OS X v10.0 and later.
T_PASSCON

When the OTAccept function completes, the endpoint provider passes this event to the endpoint receiving the connection (whether that endpoint is the same as or different from the endpoint that calls the OTAccept function). The cookie parameter contains the resRef parameter to the OTAccept function.

Available in Mac OS X v10.0 and later.
T_RESET

A connection-oriented endpoint has received a reset from the remote end and has flushed all unread and unsent data. This only occurs for some types of endpoints, and it generally leaves the endpoint in an unknown state.

Available in Mac OS X v10.0 and later.
kPRIVATEEVENT

Available in Mac OS X v10.0 and later.
kCOMPLETEEVENT

Available in Mac OS X v10.0 and later.
T_BINDCOMPLETE

The OTBind function has completed. The cookie parameter contains the retAddr parameter of the bind call.

Available in Mac OS X v10.0 and later.
T_UNBINDCOMPLETE

The OTUnbind function has completed. The cookie parameter is meaningless.

Available in Mac OS X v10.0 and later.
T_ACCEPTCOMPLETE

The OTAccept function has completed. The cookie parameter contains the resRef parameter to the OTAccept function. 

Available in Mac OS X v10.0 and later.
T_REPLYCOMPLETE

The OTSndUReply or OTSndReply functions have completed. The cookie parameter contains the sequence number used in the OTSndUReply or OTSndReply call. 

Available in Mac OS X v10.0 and later.
T_DISCONNECTCOMPLETE

The OTSndDisconnect function has completed. The cookie parameter contains the call parameter of the OTSndDisconnect function.

Available in Mac OS X v10.0 and later.
T_OPTMGMTCOMPLETE

The OTOptionManagement function has completed. The cookie parameter contains the ret parameter that you passed to the function.

Available in Mac OS X v10.0 and later.
T_OPENCOMPLETE

An asynchronous call to open a provider has completed. The cookie parameter contains the provider reference.

Available in Mac OS X v10.0 and later.
T_GETPROTADDRCOMPLETE

The OTGetProtAddress function has completed. The cookie parameter contains the peerAddr parameter that you passed to the OTGetProtocolAddress function. If you passed NULL for that parameter, the cookie parameter contains the address passed in the boundAddr parameter.

Available in Mac OS X v10.0 and later.
T_RESOLVEADDRCOMPLETE

The OTResolveAddress function has completed. The cookie parameter contains the retAddr parameter of the OTResolveAddress function.

Available in Mac OS X v10.0 and later.
T_GETINFOCOMPLETE

The OTGetEndpointInfo function has completed. The cookie parameter contains the info parameter of the OTGetEndpointInfo function.

Available in Mac OS X v10.0 and later.
T_SYNCCOMPLETE

The OTSync function has completed. The cookie parameter is meaningless.

Available in Mac OS X v10.0 and later.
T_MEMORYRELEASED

You are using an asynchronous endpoint that acknowledges sends and Open Transport is done using the buffers containing the data you are sending. If you called the OTSnd function, the cookie parameter contains the buf parameter. If you called the OTSndUData function, the cookie parameter contains the udata parameter. The result parameter contains the number of bytes that were sent. This might be less than the number you meant to send due to flow-control or memory restrictions.

You should not wait for the T_MEMORYRELEASED event from a previous send operation to trigger more sends. The exact time this event occurs depends on how the underlying provider is implemented. It might hold on to memory until the next send occurs, or behave in some other way which causes it to delay releasing memory.

Note that T_MEMORYRELEASED events can reenter your notifier. See OTAckSendsfor more information.

Available in Mac OS X v10.0 and later.
T_REGNAMECOMPLETE

The OTRegisterName function has completed. The cookie parameter is the reply parameter, unless it was NULL. In this case, it is the req parameter.

Available in Mac OS X v10.0 and later.
T_DELNAMECOMPLETE

The OTDeleteName function or the OTDeleteNameByID function has completed. The cookie parameter contains the name parameter or the nameId parameter of the function, respectively. 

Available in Mac OS X v10.0 and later.
T_LKUPNAMECOMPLETE

The OTLookupName function has completed. The cookie parameter contains the reply parameter of the OTLookUpName function.

Available in Mac OS X v10.0 and later.
T_LKUPNAMERESULT

An OTLookupName function has found a name and is returning it, but the lookup is not yet complete. The cookie parameter contains the reply parameter passed to the OTLookupName function.

Available in Mac OS X v10.0 and later.
kOTSyncIdleEvent

A synchronous call is waiting to complete.

Available in Mac OS X v10.0 and later.
kSTREAMEVENT

Available in Mac OS X v10.0 and later.
kOTReservedEvent1

Available in Mac OS X v10.0 and later.
kGetmsgEvent

Available in Mac OS X v10.0 and later.
kStreamReadEvent

Available in Mac OS X v10.0 and later.
kStreamWriteEvent

Available in Mac OS X v10.0 and later.
kStreamIoctlEvent

Available in Mac OS X v10.0 and later.
kOTReservedEvent2

Available in Mac OS X v10.0 and later.
kStreamOpenEvent

Available in Mac OS X v10.0 and later.
kPollEvent

Available in Mac OS X v10.0 and later.
kOTReservedEvent3

Available in Mac OS X v10.0 and later.
kOTReservedEvent4

Available in Mac OS X v10.0 and later.
kOTReservedEvent5

Available in Mac OS X v10.0 and later.
kOTReservedEvent6

Available in Mac OS X v10.0 and later.
kOTReservedEvent7

Available in Mac OS X v10.0 and later.
kOTReservedEvent8

Available in Mac OS X v10.0 and later.
kSIGNALEVENT

Available in Mac OS X v10.0 and later.
kPROTOCOLEVENT

Available in Mac OS X v10.0 and later.
kOTProviderIsDisconnected

Your provider was bound with a qlen parameter value greater than 0 and it has been disconnected (is no longer listening). You receive this event after a port has accepted a request to temporarily yield ownership of a port to another provider, which causes this provider to be disconnected from the port in question. This currently only happens with serial ports, but could also happen with other connection-oriented drivers that have characteristics similar to serial ports. You get a kOTProviderIsReconnected message when the port reverts back to this provider’s ownership.

Available in Mac OS X v10.0 and later.
kOTProviderIsReconnected

Your provider has been reconnected, that is, the cause for its disconnection has been relieved.

Available in Mac OS X v10.0 and later.
kOTProviderWillClose

When you return from the notifier function, Open Transport will close the provider whose reference is contained in the cookie parameter. The result parameter contains a result code specifying the reason why the provider had to close. For example, the user may have decided to switch links using the TCP/IP or AppleTalk control panel. The result codes that can be returned are in the range –3280 through –3285; these are documented in “Open Transport Result Codes”.

You can only get this event at system task time. Consequently, you are allowed to set the endpoint to synchronous mode (from within the notifier function) and call functions synchronously before you return from the notifier, at which point the provider is closed. After this, any calls other than OTCloseProvider will fail with a kOTOutStateErr error.

Available in Mac OS X v10.0 and later.
kOTProviderIsClosed

The provider has closed. The reason for being closed can be found in the OTResult value passed to your notifier. The reasons typically are kOTPortHasDiedErr, kOTPortWasEjectedErr, or kOTPortLostConnectionErr. At this point, any calls other than OTCloseProvider will fail with a kOTOutStateErr error.

Available in Mac OS X v10.0 and later.
kOTPortDisabled

A port has gone off line, as when the user removes a PCMCIA card while the computer is running. The OTResult parameter specifies the reason, if known, and the cookie parameter provides the port reference of the port that went off line. A port going off line often results in providers getting kOTProviderIsClosed events. There is no guarantee in Open Transport as to which of these events will be received first.

Available in Mac OS X v10.0 and later.
kOTPortEnabled

A port that had previously been disabled is now reenabled, as when the user reinserts a previously removed PCMCIA card while the computer is running. The cookie parameter is the port reference of the port that is now enabled.

Available in Mac OS X v10.0 and later.
kOTPortOffline

The port is now offline.

Available in Mac OS X v10.0 and later.
kOTPortOnline

A request has been made to close or yield this port.

Available in Mac OS X v10.0 and later.
kOTClosePortRequest

You currently are using a provider that is using a port that some other application wants to use. The OTResult parameter is the reason for the request (normally kOTNoError or kOTUserRequestedErr), and the cookie parameter is a pointer to an OTPortCloseStruct structure. 

Available in Mac OS X v10.0 and later.
kOTYieldPortRequest

Available in Mac OS X v10.0 and later.
kOTNewPortRegistered

A new port has been registered with Open Transport, as when the user inserts a new PCMCIA card. The cookie parameter is the port reference of the new port. Your provider receives this event the first time a new port is enabled. Subsequently, if a port is reenabled after being disabled, you receive the kOTPortEnabled event instead. 

Available in Mac OS X v10.0 and later.
kOTPortNetworkChange

Available in Mac OS X v10.0 and later.
kOTConfigurationChanged

Available in Mac OS X v10.0 and later.
kOTSystemSleep

Available in Mac OS X v10.0 and later.
kOTSystemShutdown

Available in Mac OS X v10.0 and later.
kOTSystemAwaken

Available in Mac OS X v10.0 and later.
kOTSystemIdle

Available in Mac OS X v10.0 and later.
kOTSystemSleepPrep

Available in Mac OS X v10.0 and later.
kOTSystemShutdownPrep

Available in Mac OS X v10.0 and later.
kOTSystemAwakenPrep

Available in Mac OS X v10.0 and later.
kOTStackIsLoading

Available in Mac OS X v10.0 and later.
kOTStackWasLoaded

Available in Mac OS X v10.0 and later.
kOTStackIsUnloading

Available in Mac OS X v10.0 and later.
kOTDisablePortEvent

Available in Mac OS X v10.0 and later.
kStreamCloseEvent

Available in Mac OS X v10.0 and later.
kBackgroundStreamEvent

Available in Mac OS X v10.0 and later.
kIoctlRecvFdEvent

Available in Mac OS X v10.0 and later.
kOTTryShutdownEvent

Available in Mac OS X v10.0 and later.
kOTScheduleTerminationEvent

Available in Mac OS X v10.0 and later.
kOTEnablePortEvent

Available in Mac OS X v10.0 and later.
kOTNewPortRegisteredEvent

Available in Mac OS X v10.0 and later.
kOTPortOfflineEvent

Available in Mac OS X v10.0 and later.
kOTPortOnlineEvent

Available in Mac OS X v10.0 and later.
kOTPortNetworkChangeEvent

Available in Mac OS X v10.0 and later.*/


typedef UInt32 OTEventCode;
enum {
   T_LISTEN = 0x0001,
   T_CONNECT = 0x0002,
   T_DATA = 0x0004,
   T_EXDATA = 0x0008,
   T_DISCONNECT = 0x0010,
   T_ERROR = 0x0020,
   T_UDERR = 0x0040,
   T_ORDREL = 0x0080,
   T_GODATA = 0x0100,
   T_GOEXDATA = 0x0200,
   T_REQUEST = 0x0400,
   T_REPLY = 0x0800,
   T_PASSCON = 0x1000,
   T_RESET = 0x2000,
   kPRIVATEEVENT = 0x10000000,
   kCOMPLETEEVENT = 0x20000000,
   T_BINDCOMPLETE = 0x20000001,
   T_UNBINDCOMPLETE = 0x20000002,
   T_ACCEPTCOMPLETE = 0x20000003,
   T_REPLYCOMPLETE = 0x20000004,
   T_DISCONNECTCOMPLETE = 0x20000005,
   T_OPTMGMTCOMPLETE = 0x20000006,
   T_OPENCOMPLETE = 0x20000007,
   T_GETPROTADDRCOMPLETE = 0x20000008,
   T_RESOLVEADDRCOMPLETE = 0x20000009,
   T_GETINFOCOMPLETE = 0x2000000A,
   T_SYNCCOMPLETE = 0x2000000B,
   T_MEMORYRELEASED = 0x2000000C,
   T_REGNAMECOMPLETE = 0x2000000D,
   T_DELNAMECOMPLETE = 0x2000000E,
   T_LKUPNAMECOMPLETE = 0x2000000F,
   T_LKUPNAMERESULT = 0x20000010,
   kOTSyncIdleEvent = 0x20000011,
   kSTREAMEVENT = 0x21000000,
   kOTReservedEvent1 = 0x21000001,
   kGetmsgEvent = 0x21000002,
   kStreamReadEvent = 0x21000003,
   kStreamWriteEvent = 0x21000004,
   kStreamIoctlEvent = 0x21000005,
   kOTReservedEvent2 = 0x21000006,
   kStreamOpenEvent = 0x21000007,
   kPollEvent = 0x21000008,
   kOTReservedEvent3 = 0x21000009,
   kOTReservedEvent4 = 0x2100000A,
   kOTReservedEvent5 = 0x2100000B,
   kOTReservedEvent6 = 0x2100000C,
   kOTReservedEvent7 = 0x2100000D,
   kOTReservedEvent8 = 0x2100000E,
   kSIGNALEVENT = 0x22000000,
   kPROTOCOLEVENT = 0x23000000,
   kOTProviderIsDisconnected = 0x23000001,
   kOTProviderIsReconnected = 0x23000002,
   kOTProviderWillClose = 0x24000001,
   kOTProviderIsClosed = 0x24000002,
   kOTPortDisabled = 0x25000001,
   kOTPortEnabled = 0x25000002,
   kOTPortOffline = 0x25000003,
   kOTPortOnline = 0x25000004,
   kOTClosePortRequest = 0x25000005,
   kOTYieldPortRequest = 0x25000005,
   kOTNewPortRegistered = 0x25000006,
   kOTPortNetworkChange = 0x25000007,
   kOTConfigurationChanged = 0x26000001,
   kOTSystemSleep = 0x26000002,
   kOTSystemShutdown = 0x26000003,
   kOTSystemAwaken = 0x26000004,
   kOTSystemIdle = 0x26000005,
   kOTSystemSleepPrep = 0x26000006,
   kOTSystemShutdownPrep = 0x26000007,
   kOTSystemAwakenPrep = 0x26000008,
   kOTStackIsLoading = 0x27000001,
   kOTStackWasLoaded = 0x27000002,
   kOTStackIsUnloading = 0x27000003
};
   
/*   The following event codes are used internally by Open Transport.*/
enum {
   kOTDisablePortEvent = 0x21000001,
   kStreamCloseEvent = 0x21000006,
   kBackgroundStreamEvent = 0x21000009,
   kIoctlRecvFdEvent = 0x2100000A,
   kOTTryShutdownEvent = 0x2100000B,
   kOTScheduleTerminationEvent = 0x2100000C,
   kOTEnablePortEvent = 0x2100000D,
   kOTNewPortRegisteredEvent = 0x2100000E,
   kOTPortOfflineEvent = 0x2100000F,
   kOTPortOnlineEvent = 0x21000010,
   kOTPortNetworkChangeEvent = 0x21000011
};


/*OTSequence


typedef SInt32 OTSequence;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTSequence;

/*OTQLen


typedef UInt32 OTQLen;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTQLen;

/*OTAddressType


typedef UInt16 OTAddressType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 OTAddressType;

/*No-Copy Receive Buffer Structure

Receives data without copying it.

struct OTBuffer {
   void * fLink;
   void * fLink2;
   OTBuffer * fNext;
   UInt8 * fData;
   ByteCount fLen;
   void * fSave;
   UInt8 fBand;
   UInt8 fType;
   UInt8 fPad1;
   UInt8 fFlags;
};
typedef struct OTBuffer OTBuffer;
Fields
fLink

Reserved.
fLink2

Reserved.
fNext

A pointer to the next OTBuffer structure in the linked chain. By tracing the chain of fNext pointers, you can access all of the data associated with the message. 
fData

A pointer to the data portion of this OTBuffer structure.
fLen

The length of data pointed to by the fData field.
fSave

Reserved.
fBand

The band used for the data transmission. It must be a value between 0 and 255.
fType

The type of the data (normally M_DATA, M_PROTO, or M_PCPROTO).
fPad1

Reserved.
fFlags

The flags associated with the data (MSGMARK, MSGDELIM).
Discussion

You use the no-copy receive buffer structure when you wish to receive data without copying it with the OTRcvUData function, the OTRcvURequest function, the OTRcvUReply function, the OTRcv function, the OTRcvRequest function, and the OTRcvReply function. 

If you are familiar with STREAMS mblk_t data structures, you can see that the no-copy receive buffer structure is just a slight modification of the mblk_t structure.

You can only use this buffer for data; you cannot use it for the address or options that may be associated with the incoming data. For example, in the case of an incoming TUnitData structure, you can only no-copy receive the udata portion, not the addr or opt fields. 
Special Considerations

Under no circumstance write to this data structure. It is read-only. If you write to it, you can crash the system.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OTBuffer OTBuffer;

struct OTBuffer {
   void * fLink;
   void * fLink2;
   OTBuffer * fNext;
   UInt8 * fData;
   ByteCount fLen;
   void * fSave;
   UInt8 fBand;
   UInt8 fType;
   UInt8 fPad1;
   UInt8 fFlags;
};



/*OTEventCode


typedef UInt32 OTEventCode;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTEventCode;

/*kT_UNSPEC


enum {
   kT_UNSPEC = 0xFFFFFFFD,
   T_ALLOPT = 0
};
Constants
kT_UNSPEC

Available in Mac OS X v10.0 and later.
T_ALLOPT

Available in Mac OS X v10.0 and later*/
enum {
   kT_UNSPEC = 0xFFFFFFFD,
   T_ALLOPT = 0
};


/*OTXTIName


typedef UInt32 OTXTIName;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTXTIName;

/*OTXTILevel


typedef UInt32 OTXTILevel;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTXTILevel;

/*OTResult


typedef SInt32 OTResult;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTResult;

/*EPERM


enum {
   EPERM = 1,
   ENOENT = 2,
   ENORSRC = 3,
   EINTR = 4,
   EIO = 5,
   ENXIO = 6,
   EBADF = 9,
   EAGAIN = 11,
   ENOMEM = 12,
   EACCES = 13,
   EFAULT = 14,
   EBUSY = 16,
   EEXIST = 17,
   ENODEV = 19,
   EINVAL = 22,
   ENOTTY = 25,
   EPIPE = 32,
   ERANGE = 34,
   EDEADLK = 35,
   EWOULDBLOCK = 35,
   EALREADY = 37,
   ENOTSOCK = 38,
   EDESTADDRREQ = 39,
   EMSGSIZE = 40,
   EPROTOTYPE = 41,
   ENOPROTOOPT = 42,
   EPROTONOSUPPORT = 43,
   ESOCKTNOSUPPORT = 44,
   EOPNOTSUPP = 45,
   EADDRINUSE = 48,
   EADDRNOTAVAIL = 49,
   ENETDOWN = 50,
   ENETUNREACH = 51,
   ENETRESET = 52,
   ECONNABORTED = 53,
   ECONNRESET = 54,
   ENOBUFS = 55,
   EISCONN = 56,
   ENOTCONN = 57,
   ESHUTDOWN = 58,
   ETOOMANYREFS = 59,
   ETIMEDOUT = 60,
   ECONNREFUSED = 61,
   EHOSTDOWN = 64,
   EHOSTUNREACH = 65,
   EPROTO = 70,
   ETIME = 71,
   ENOSR = 72,
   EBADMSG = 73,
   ECANCEL = 74,
   ENOSTR = 75,
   ENODATA = 76,
   EINPROGRESS = 77,
   ESRCH = 78,
   ENOMSG = 79,
   ELASTERRNO = 79
};
Constants
EPERM

Available in Mac OS X v10.0 and later.
ENOENT

Available in Mac OS X v10.0 and later.
ENORSRC

Available in Mac OS X v10.0 and later.
EINTR

Available in Mac OS X v10.0 and later.
EIO

Available in Mac OS X v10.0 and later.
ENXIO

Available in Mac OS X v10.0 and later.
EBADF

Available in Mac OS X v10.0 and later.
EAGAIN

Available in Mac OS X v10.0 and later.
ENOMEM

Available in Mac OS X v10.0 and later.
EACCES

Available in Mac OS X v10.0 and later.
EFAULT

Available in Mac OS X v10.0 and later.
EBUSY

Available in Mac OS X v10.0 and later.
EEXIST

Available in Mac OS X v10.0 and later.
ENODEV

Available in Mac OS X v10.0 and later.
EINVAL

Available in Mac OS X v10.0 and later.
ENOTTY

Available in Mac OS X v10.0 and later.
EPIPE

Available in Mac OS X v10.0 and later.
ERANGE

Available in Mac OS X v10.0 and later.
EDEADLK

Available in Mac OS X v10.0 and later.
EWOULDBLOCK

Available in Mac OS X v10.0 and later.
EALREADY

Available in Mac OS X v10.0 and later.
ENOTSOCK

Available in Mac OS X v10.0 and later.
EDESTADDRREQ

Available in Mac OS X v10.0 and later.
EMSGSIZE

Available in Mac OS X v10.0 and later.
EPROTOTYPE

Available in Mac OS X v10.0 and later.
ENOPROTOOPT

Available in Mac OS X v10.0 and later.
EPROTONOSUPPORT

Available in Mac OS X v10.0 and later.
ESOCKTNOSUPPORT

Available in Mac OS X v10.0 and later.
EOPNOTSUPP

Available in Mac OS X v10.0 and later.
EADDRINUSE

Available in Mac OS X v10.0 and later.
EADDRNOTAVAIL

Available in Mac OS X v10.0 and later.
ENETDOWN

Available in Mac OS X v10.0 and later.
ENETUNREACH

Available in Mac OS X v10.0 and later.
ENETRESET

Available in Mac OS X v10.0 and later.
ECONNABORTED

Available in Mac OS X v10.0 and later.
ECONNRESET

Available in Mac OS X v10.0 and later.
ENOBUFS

Available in Mac OS X v10.0 and later.
EISCONN

Available in Mac OS X v10.0 and later.
ENOTCONN

Available in Mac OS X v10.0 and later.
ESHUTDOWN

Available in Mac OS X v10.0 and later.
ETOOMANYREFS

Available in Mac OS X v10.0 and later.
ETIMEDOUT

Available in Mac OS X v10.0 and later.
ECONNREFUSED

Available in Mac OS X v10.0 and later.
EHOSTDOWN

Available in Mac OS X v10.0 and later.
EHOSTUNREACH

Available in Mac OS X v10.0 and later.
EPROTO

Available in Mac OS X v10.0 and later.
ETIME

Available in Mac OS X v10.0 and later.
ENOSR

Available in Mac OS X v10.0 and later.
EBADMSG

Available in Mac OS X v10.0 and later.
ECANCEL

Available in Mac OS X v10.0 and later.
ENOSTR

Available in Mac OS X v10.0 and later.
ENODATA

Available in Mac OS X v10.0 and later.
EINPROGRESS

Available in Mac OS X v10.0 and later.
ESRCH

Available in Mac OS X v10.0 and later.
ENOMSG

Available in Mac OS X v10.0 and later.
ELASTERRNO

Available in Mac OS X v10.0 and later.*/

enum {
#ifndef   EPERM 
   EPERM = 1,
#endif
#ifndef    ENOENT
   ENOENT = 2,
#endif
   ENORSRC = 3,
#ifndef  EINTR
   EINTR = 4,
#endif
#ifndef     EIO
   EIO = 5,
#endif
#ifndef   ENXIO
   ENXIO = 6,
#endif
#ifndef    EBADF
   EBADF = 9,
#endif
#ifndef    EAGAIN 
   EAGAIN = 11,
#endif
#ifndef  ENOMEM
   ENOMEM = 12,
#endif
#ifndef  EACCES
   EACCES = 13,
#endif
#ifndef  EFAULT
   EFAULT = 14
#endif
#ifndef    EBUSY
   EBUSY = 16,
#endif
#ifndef    EEXIST
   EEXIST = 17,
#endif
#ifndef  ENODEV
   ENODEV = 19,
#endif 
#ifndef     EINVAL 
   EINVAL = 22,
#endif
#ifndef    ENOTTY 
   ENOTTY = 25,
#endif
#ifndef    EPIPE
   EPIPE = 32,
#endif
#ifndef  ERANGE
   ERANGE = 34,
#endif
#ifndef EDEADLK
   EDEADLK = 35,
#endif
#ifndef  EWOULDBLOCK
   EWOULDBLOCK = 35,
#endif
#ifndef  EALREADY
   EALREADY = 37,
#endif
#ifndef   ENOTSOCK
   ENOTSOCK = 38,
#endif
#ifndef  EDESTADDRREQ
   EDESTADDRREQ = 39,
#endif
#ifndef  EMSGSIZE
   EMSGSIZE = 40,
#endif
#ifndef  EPROTOTYPE
   EPROTOTYPE = 41,
#endif
#ifndef    ENOPROTOOPT
   ENOPROTOOPT = 42,
#endif
#ifndef    EPROTONOSUPPORT
   EPROTONOSUPPORT = 43,
#endif
#ifndef  ESOCKTNOSUPPORT
   ESOCKTNOSUPPORT = 44,
#endif
#ifndef   EOPNOTSUPP
   EOPNOTSUPP = 45,
#endif
#ifndef    EADDRINUSE
   EADDRINUSE = 48,
#endif
#ifndef EADDRNOTAVAIL 
   EADDRNOTAVAIL = 49,
#endif
#ifndef  ENETDOWN 
   ENETDOWN = 50,
#endif
#ifndef    ENETUNREACH 
   ENETUNREACH = 51,
#endif
#ifndef  ENETRESET
   ENETRESET = 52,
#endif
#ifndef ECONNABORTED
   ECONNABORTED = 53,
#endif
#ifndef ECONNRESET 
   ECONNRESET = 54,
#endif
#ifndef    ENOBUFS
   ENOBUFS = 55,
#endif
#ifndef    EISCONN
   EISCONN = 56,
#endif
#ifndef  ENOTCONN
   ENOTCONN = 57,
#endif
#ifndef    ESHUTDOWN
   ESHUTDOWN = 58,
#endif
#ifndef  ETOOMANYREFS
   ETOOMANYREFS = 59,
#endif
#ifndef   ETIMEDOUT 
   ETIMEDOUT = 60,
#endif
#ifndef    ECONNREFUSED
   ECONNREFUSED = 61,
#endif
#ifndef  EHOSTDOWN 
   EHOSTDOWN = 64,
#endif
#ifndef    EHOSTUNREACH
   EHOSTUNREACH = 65,
#endif
#ifndef EPROTO
   EPROTO = 70,
#endif
#ifndef ETIME
   ETIME = 71,
#endif
#ifndef ENOSR 
   ENOSR = 72,
#endif
#ifndef  EBADMSG
   EBADMSG = 73,
#endif
#ifndef    ECANCEL
   ECANCEL = 74,
#endif
#ifndef ENOSTR
   ENOSTR = 75,
#endif
#ifndef    ENODATA 
   ENODATA = 76,
#endif
#ifndef  EINPROGRESS
   EINPROGRESS = 77,
#endif
#ifndef ESRCH
   ESRCH = 78,
#endif
#ifndef    ENOMSG 
   ENOMSG = 79,
#endif
#ifndef ELASTERRNO
   ELASTERRNO = 79
#endif
};


/*Open Transport Flags and Status Codes

Specify information about data transmitted with the OTSnd or OTRcv functions, or specify options for the OTOptionManagement function, or indicate the result status of an option negotiation.

typedef UInt32 OTFlags;
/   These flags are used when sending and receiving data.The constants
defined are masks./
enum {
   T_MORE = 0x0001,
   T_EXPEDITED = 0x0002,
   T_ACKNOWLEDGED = 0x0004,
   T_PARTIALDATA = 0x0008,
   T_NORECEIPT = 0x0010,
   T_TIMEDOUT = 0x0020
};
   
/ These flags are used in the TOptMgmt structure to request services./
enum {
   T_NEGOTIATE = 0x0004,
   T_CHECK = 0x0008,
   T_DEFAULT = 0x0010,
   T_CURRENT = 0x0080
};
   
/   These flags are used in the TOptMgmt and TOption structures
to   return results./
enum {
   T_SUCCESS = 0x0020,
   T_FAILURE = 0x0040,
   T_PARTSUCCESS = 0x0100,
   T_READONLY = 0x0200,
   T_NOTSUPPORT = 0x0400
};
Constants
T_MORE

There is more data for the current TSDU or ETSDU. The next send or receive operation will handle additional data for this TSDU or ETSDU.

Available in Mac OS X v10.0 and later.
T_EXPEDITED

On sends, the data is sent as expedited data if the endpoint supports expedited data. On receives, the flag indicates that expedited data was sent.

Available in Mac OS X v10.0 and later.
T_ACKNOWLEDGED

The transaction must be acknowledged before the send or receive function can complete.

Available in Mac OS X v10.0 and later.
T_PARTIALDATA

There is more data for the current TSDU or ETSDU. Unlike T_MORE, T_PARTIALDATA does not guarantee that the next send or receive operation will handle additional data for this TSDU or ETSDU.

Available in Mac OS X v10.0 and later.
T_NORECEIPT

There is no need to send a T_REPLY_COMPLETE event to complete the transaction. If you don’t need to know when the transaction is actually done, you can set this flag to improve performance.

Available in Mac OS X v10.0 and later.
T_TIMEDOUT

The reply timed out. If a protocol such as ATP loses the acknowledgment for a transaction that needs to be acknowledged, the transaction will eventually time out. Since the reply didn’t really fail (it just timed out), Open Transport can send a T_REPLY_COMPLETE event to complete the transaction and set this flag to explain what happened.

Available in Mac OS X v10.0 and later.
T_NEGOTIATE

Negotiate the option values specified in the opt.buf field of the req parameter.

The overall result of the negotiation is specified by the flags field of the ret parameter. The opt.buf field of the ret parameter points to a buffer where negotiated values for each option are placed.

Available in Mac OS X v10.0 and later.
T_CHECK

Verify whether the endpoint supports the options referenced by the opt.buf field of the req parameter. The overall result of the verification is specified by the flags field of the ret parameter. Specific verification results are returned in the opt.buf field of the ret parameter.

Available in Mac OS X v10.0 and later.
T_DEFAULT

Retrieve the default value for those options in the buffer referenced by the req->opt.buf field. To retrieve default values for all the options supported by an endpoint, include just the option T_ALLOPT in the options buffer.Option values are returned in the opt.buf field of the ret parameter.

Available in Mac OS X v10.0 and later.
T_CURRENT

Retrieve the current value for those options that the endpoint supports and that are specified in the buffer referenced by the req->opt.buf field. To retrieve current values for all the options that an endpoint supports, include just the option T_ALLOPT in the options buffer.Option values are returned in the opt.buf field of the ret parameter.

Available in Mac OS X v10.0 and later.
T_SUCCESS

The requested value was negotiated.

Available in Mac OS X v10.0 and later.
T_FAILURE

The negotiation failed.

Available in Mac OS X v10.0 and later.
T_PARTSUCCESS

A lower requested value was negotiated.

Available in Mac OS X v10.0 and later.
T_READONLY

The option was read-only.

Available in Mac OS X v10.0 and later.
T_NOTSUPPORT

The endpoint does not support the requested value.

Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTFlags;
/*   These flags are used when sending and receiving data.The constants
defined are masks.*/
enum {
   T_MORE = 0x0001,
   T_EXPEDITED = 0x0002,
   T_ACKNOWLEDGED = 0x0004,
   T_PARTIALDATA = 0x0008,
   T_NORECEIPT = 0x0010,
   T_TIMEDOUT = 0x0020
};
   
/* These flags are used in the TOptMgmt structure to request services.*/
enum {
   T_NEGOTIATE = 0x0004,
   T_CHECK = 0x0008,
   T_DEFAULT = 0x0010,
   T_CURRENT = 0x0080
};
   
/*   These flags are used in the TOptMgmt and TOption structures
to   return results.*/
enum {
   T_SUCCESS = 0x0020,
   T_FAILURE = 0x0040,
   T_PARTSUCCESS = 0x0100,
   T_READONLY = 0x0200,
   T_NOTSUPPORT = 0x0400
};


/*ProviderRef


typedef struct OpaqueProviderRef * ProviderRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueProviderRef * ProviderRef;

/*Endpoint Service Types

Contains values that Open Transport can return in the servtype field of the TEndpointInfo structure.

typedef UInt32 OTServiceType;
enum {
   T_COTS = 1,
   T_COTS_ORD = 2,
   T_CLTS = 3,
   T_TRANS = 5,
   T_TRANS_ORD = 6,
   T_TRANS_CLTS = 7
};
Constants
T_COTS

Connection-oriented transactionless service without orderly release.

Available in Mac OS X v10.0 and later.
T_COTS_ORD

Connection-oriented transactionless service with optional orderly release.

Available in Mac OS X v10.0 and later.
T_CLTS

Connectionless transactionless service.

Available in Mac OS X v10.0 and later.
T_TRANS

Connection-oriented transaction-based service without orderly release.

Available in Mac OS X v10.0 and later.
T_TRANS_ORD

Connection-oriented transaction-based service with optional orderly release.

Available in Mac OS X v10.0 and later.
T_TRANS_CLTS

Connectionless transaction-based service.

Available in Mac OS X v10.0 and later.*/

typedef UInt32 OTServiceType;
enum {
   T_COTS = 1,
   T_COTS_ORD = 2,
   T_CLTS = 3,
   T_TRANS = 5,
   T_TRANS_ORD = 6,
   T_TRANS_CLTS = 7
};


/*OTDataSize


typedef SInt32 OTDataSize;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 OTDataSize;

/*EndpointRef


typedef struct OpaqueEndpointRef * EndpointRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEndpointRef * EndpointRef;

/*OTClientContextPtr


typedef struct OpaqueOTClientContextPtr * OTClientContextPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueOTClientContextPtr * OTClientContextPtr;

/*OTInitializationFlags


typedef UInt32 OTInitializationFlags;
enum {
   kInitOTForApplicationMask = 1,
   kInitOTForExtensionMask = 2
};
Constants
kInitOTForApplicationMask

Available in Mac OS X v10.0 and later.
kInitOTForExtensionMask

Available in Mac OS X v10.0 and later.*/
typedef UInt32 OTInitializationFlags;
enum {
   kInitOTForApplicationMask = 1,
   kInitOTForExtensionMask = 2
};

/*OTConfigurationRef


typedef struct OTConfiguration * OTConfigurationRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OTConfiguration * OTConfigurationRef;

/*OTOpenFlags


typedef UInt32 OTOpenFlags;
enum {
   kO_ASYNC = 0x01,
   kO_NDELAY = 0x04,
   kO_NONBLOCK = 0x04
};
Constants
kO_ASYNC

Available in Mac OS X v10.0 and later.
kO_NDELAY

Available in Mac OS X v10.0 and later.
kO_NONBLOCK

Available in Mac OS X v10.0 and later.*/

typedef UInt32 OTOpenFlags;
enum {
   kO_ASYNC = 0x01,
   kO_NDELAY = 0x04,
   kO_NONBLOCK = 0x04
};

/*TEndpointInfo

Describes the initial characteristics of an endpoint that you opened by calling the OTOpenEndpointInContext function; returned by calling OTGetEndpointInfo.

struct TEndpointInfo {
   OTDataSize addr;
   OTDataSize options;
   OTDataSize tsdu;
   OTDataSize etsdu;
   OTDataSize connect;
   OTDataSize discon;
   OTServiceType servtype;
   UInt32 flags;
};
typedef struct TEndpointInfo TEndpointInfo;
Fields
addr
options

A value greater than or equal to 0 indicates the maximum number of bytes needed to store the protocol-specific options that this endpoint supports, if any. A value of T_INVALID (-2) indicates that this endpoint has no protocol-specific options that you can set; they are read-only. A value of -3 specifies that the provider does not support any options. 
tsdu

For a transactionless endpoint, a positive value indicates the maximum number of bytes in a transport service data unit (TSDU) for this endpoint. A value of T_INFINITE (-1) indicates that there is no limit to the size of a TSDU. A value of 0 indicates that the provider does not support the concept of a TSDU. This means that you cannot send data with logical boundaries preserved across a connection. A value of T_INVALID indicates that this endpoint cannot transfer normal data (as opposed to expedited data). 

For a transaction-based endpoint, this field indicates the maximum number of bytes in a response. 

etsdu

For a transactionless endpoint, a positive value indicates the maximum number of bytes in an expedited transport service data unit (ETSDU) for this endpoint. A value of T_INFINITE indicates that there is no limit to the size of a ETSDU. A value of 0 indicates that this endpoint does not support the concept of an ETSDU. This means that you must not send expedited data with logical boundaries preserved across a connection. A value of T_INVALID indicates that this endpoint cannot transfer expedited data.

For a transaction-based endpoint, this field indicates the maximum number of bytes in a request. 

connect

For a connection-oriented endpoint, a value greater than or equal to 0 indicates the maximum amount of data (in bytes) that you can send with the OTConnect function or the OTAccept function. A value of T_INVALID indicates that this endpoint does not let you send data with these functions. This field is meaningless for other types of endpoints.
discon

For a connection-oriented endpoint, a value greater than or equal to 0 indicates the maximum amount of data (in bytes) that you can send using the OTSndDisconnect function. A value of T_INVALID indicates that this endpoint does not let you send data with disconnection requests. This field is meaningless for other types of endpoints.
servtype

A constant that indicates what kind of service the endpoint provides. Possible values are given by the “Endpoint Service Types” enumeration.
flags

A bit FIeld that provides additional information about the endpoint. Possible values are given by the “Endpoint Flags” enumeration.
Availability
Available in Mac OS X v10.0 and later.*/
struct TEndpointInfo {
   OTDataSize addr;
   OTDataSize options;
   OTDataSize tsdu;
   OTDataSize etsdu;
   OTDataSize connect;
   OTDataSize discon;
   OTServiceType servtype;
   UInt32 flags;
};
typedef struct TEndpointInfo TEndpointInfo;

/*OTByteCount


typedef ByteCount OTByteCount;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ByteCount OTByteCount;

/*TNetbuf

Specifies the location and size of a buffer that contains an address, option information, or user data.

struct TNetbuf {
   ByteCount maxlen;
   ByteCount len;
   UInt8 * buf;
};
typedef struct TNetbuf TNetbuf;
Fields
maxlen

The size (in bytes) of the buffer to which the buf field points. You must set the maxlen field before passing a TNetbuf structure to a provider function as an output parameter. Open Transport ignores this field if you pass the TNetbuf structure as an input parameter.
len

The actual length (in bytes) of the information in the buffer to which the buf field points. If you are using the TNetbuf structure as an input parameter, you must set this field.

If you pass the TNetbuf structure as an output parameter, on return the provider function sets this field to the number of bytes the function has actually placed in the buffer referenced by the buf field.
buf

A pointer to a buffer. You must make sure that the buf field points to a valid buffer and that the buffer is large enough to store the information for which it is intended.
Discussion

You use a TNetbuf structure to specify the location and size of a buffer that contains an address, option information, or user data. Provider functions use TNetbuf structures both as input parameters and output parameters. If you use a TNetbuf structure as an input parameter, you specify the location and size of a buffer containing information you want to send. If you use a TNetbuf structure as an output parameter, you specify the location and the maximum size of the buffer used to hold information when the function returns.

You use a TNetbuf structure to describe the location and size of contiguous data. Open Transport allows you to describe noncontiguous data with the OTData structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TNetbuf {
   ByteCount maxlen;
   ByteCount len;
   UInt8 * buf;
};
typedef struct TNetbuf TNetbuf;


/*The Option Management Structure

Manages the req and ret parameters of the OTOptionManagement function

struct TOptMgmt {
   TNetbuf opt;
   OTFlags flags;
};
typedef struct TOptMgmt TOptMgmt;
Fields
opt

A TNetbuf structure describing the buffer containing option information. The opt.maxlen field specifies the maximum size of the buffer. The opt.len field specifies the actual size of the buffer, and the opt.buf field contains the address of the buffer.

On input, as part of the req parameter, the buffer contains TOption structures describing the options to be negotiated or verified, or contains the names of options whose default or current values you are interested in. You must allocate this buffer, place in it the structures describing the options of interest, and set the opt.len field to the size of the buffer.

On output, as part of the ret parameter, the buffer contains the actual values of the options you described in the req parameter. You must allocate a buffer to hold the option information when the function returns and set the opt.maxlen field to the maximum length of this buffer. When the function returns, the opt.len field is set to the actual length of the buffer.

flags

For the req parameter, the flags field indicates the action to be taken as defined by the action flags enumeration (page 570). For the ret parameter, the flags field indicates the overall success or failure of the operation performed by the OTOptionManagement function, as defined by the “Open Transport Flags and Status Codes” enumeration. 
Discussion

The option management structure is used for the req and ret parameters of the OTOptionManagement function. The req parameter is used to verify or negotiate option values. The ret parameter returns information about an endpoint’s default, current, or negotiated values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TOptMgmt {
   TNetbuf opt;
   OTFlags flags;
};
typedef struct TOptMgmt TOptMgmt;

/*The TOption Structure

Stores information about a single option in a buffer.

struct TOption {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
   UInt32 value[1];
};
typedef struct TOption TOption;
Fields
len

The size (in bytes) of the option information, including the header. 
level

The protocol for which the option is defined. 
name

The name of the option. 
status

A status code specifying whether the negotiation has succeeded or failed. Possible values are given by the “Open Transport Flags and Status Codes” enumeration 
value

The option value. To have the endpoint select an appropriate value, you can specify the constant T_UNSPEC.
Discussion

The TOption structure stores information about a single option in a buffer. All functions that you use to change or verify option values use a buffer containing TOption structures to store option information. For each option in the buffer, the TOption structure specifies the total length occupied by the option, the protocol level of the option, the option name, the status of a negotiated value, and the value of the option.

You use the TOption structure with the OPT_NEXTHDR macro, the OTCreateOptionString function, the OTNextOption function, and the OTFindOption function.
Availability
Available in Mac OS X v10.0 and later.*/
struct TOption {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
   UInt32 value[1];
};
typedef struct TOption TOption;

/*The TOptionHeader Structure

Stores information about options in a buffer.

struct TOptionHeader {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
};
typedef struct TOptionHeader TOptionHeader;
Fields
len

The size (in bytes) of the option information, including the header. 
level

The protocol affected. 
name

The option name. 
status

The status value. Possible values are given by the “Open Transport Flags and Status Codes”.
Availability
Available in Mac OS X v10.0 and later.*/
struct TOptionHeader {
   ByteCount len;
   OTXTILevel level;
   OTXTIName name;
   UInt32 status;
};
typedef struct TOptionHeader TOptionHeader;


/*kOTOptionHeaderSize


enum {
   kOTOptionHeaderSize = sizeof(TOptionHeader),
   kOTBooleanOptionDataSize = sizeof(UInt32),
   kOTBooleanOptionSize = kOTOptionHeaderSize + kOTBooleanOptionDataSize,
   kOTOneByteOptionSize = kOTOptionHeaderSize + 1,
   kOTTwoByteOptionSize = kOTOptionHeaderSize + 2,
   kOTFourByteOptionSize = kOTOptionHeaderSize + sizeof(UInt32)
};
Constants
kOTOptionHeaderSize

Available in Mac OS X v10.0 and later.
kOTBooleanOptionDataSize

Available in Mac OS X v10.0 and later.
kOTBooleanOptionSize

Available in Mac OS X v10.0 and later.
kOTOneByteOptionSize

Available in Mac OS X v10.0 and later.
kOTTwoByteOptionSize

Available in Mac OS X v10.0 and later.
kOTFourByteOptionSize

Available in Mac OS X v10.0 and later.*/
enum {
   kOTOptionHeaderSize = sizeof(TOptionHeader),
   kOTBooleanOptionDataSize = sizeof(UInt32),
   kOTBooleanOptionSize = kOTOptionHeaderSize + kOTBooleanOptionDataSize,
   kOTOneByteOptionSize = kOTOptionHeaderSize + 1,
   kOTTwoByteOptionSize = kOTOptionHeaderSize + 2,
   kOTFourByteOptionSize = kOTOptionHeaderSize + sizeof(UInt32)
};

/*OTNotifyProcPtr


typedef void (*OTNotifyProcPtr) (
   void *contextPtr,
   OTEventCode code,
   OTResult result,
   void *cookie
);

If you name your function MyOTNotifyProc, you would declare it like this:

void MyOTNotifyProc (
   void *contextPtr,
   OTEventCode code,
   OTResult result,
   void *cookie
);
Parameters
contextPtr
code
result
cookie
Carbon Porting Notes

This is a function type for a callback. Use the type OTNotifyUPP instead.*/

typedef void (*OTNotifyProcPtr) (
   void *contextPtr,
   OTEventCode code,
   OTResult result,
   void *cookie
);


/*OTNotifyUPP


typedef OTNotifyProcPtr OTNotifyUPP;
Discussion

For more information, see the description of the OTNotifyUPP () callback function.*/
typedef OTNotifyProcPtr OTNotifyUPP;

/*Buffer Information Structure

A convenience structure for keeping track of where your application left off in an OTBuffer structure.

struct OTBufferInfo {
   OTBuffer * fBuffer;
   ByteCount fOffset;
   UInt8 fPad;
};
typedef struct OTBufferInfo OTBufferInfo;
Fields
fBuffer

A pointer to the no-copy receive buffer. 
fOffset

An offset indicating how far into the buffer you have read.
fPad

Reserved.
Discussion

The buffer information structure is provided for your convenience in keeping track of where you last left off in an OTBuffer structure. Because the no-copy receive buffer structure (OTBuffer) is read-only, you may need to copy the data in sections as you progress through the no-copy receive buffer. The utility function OTReadBuffer is used with this structure to easily copy the data out of an OTBuffer structure.
Availability
Available in Mac OS X v10.0 and later.*/
struct OTBufferInfo {
   OTBuffer * fBuffer;
   ByteCount fOffset;
   UInt8 fPad;
};
typedef struct OTBufferInfo OTBufferInfo;

/*TBind

Describes the protocol address to which an endpoint is currently bound or connected, or specifies the protocol address to which you wish to bind or connect the endpoint.

struct TBind {
   TNetbuf addr;
   OTQLen qlen;
};
typedef struct TBind TBind;
Fields
addr

A TNetbuf structure that contains information about an address. The addr.maxlen field specifies the maximum size of the address, the addr.len field specifies the actual length of the address, and the addr.buf field points to the buffer containing the address. 

When specifying an address, you must allocate a buffer for the address and initialize it; you must set the addr.buf field to point to this buffer; and you must set the addr.len field to the size of the address.

When requesting an address, you must allocate a buffer in which the address is to be placed; you must set the addr.buf field to point to this buffer; and you must set the addr.maxlen field to the maximum size of the address that is being returned. You determine this value by examining the addr field of the TEndpointInfo structure for the endpoint.

qlen

For a connection-oriented endpoint, the maximum number of connection requests that can be concurrently outstanding for this endpoint. For more information, see the description of the OTBind function. For connectionless endpoints, this field has no meaning. 
Discussion

The TBind structure describes the protocol address to which an endpoint is currently bound or connected, or specifies the protocol address to which you wish to bind or connect the endpoint. For a connection-oriented endpoint, the TBind structure also specifies the actual or desired number of connection requests that can be concurrently outstanding for the endpoint. 

You pass the TBind structure as a parameter to the OTBind function, the OTGetProtAddress function, and the OTResolveAddress function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TBind {
   TNetbuf addr;
   OTQLen qlen;
};
typedef struct TBind TBind;

/*TCall

Specifies the options and data associated with establishing a connection.

struct TCall {
   TNetbuf addr;
   TNetbuf opt;
   TNetbuf udata;
   OTSequence sequence;
};
typedef struct TCall TCall;
Fields
addr

A TNetbuf structure that specifies the location and size of an address buffer 
opt

A TNetbuf structure that specifies the location and size of an options buffer. 
udata

A TNetbuf structure that specifies the location and size of a buffer for data associated with a connection or disconnection request. 
sequence

A 32-bit value used by the OTListen and OTAccept functions to specify the connection ID. 
Discussion

You use the TCall structure to specify the options and data associated with establishing a connection. You pass a pointer to this structure as a parameter to the OTConnect function, the OTRcvConnect function, the OTListen function, and the OTAccept function.

If you are using the TCall structure to send information, you must allocate a buffer and initialize it to contain the information. Set the .buf field of each TNetbuf to point to the buffer, and then specify the size of the buffer using the .len field. Set this field to 0 if you are not sending data.

If you are using the TCall structure to receive information, you must allocate a buffer into which the function can place the information when it returns. Then set the .buf field of all the TNetbufs to point to this buffer, and set the .maxlen field to the maximum size of the information. Set this field to 0 if you are not interested in receiving information.
Availability
Available in Mac OS X v10.0 and later.*/
struct TCall {
   TNetbuf addr;
   TNetbuf opt;
   TNetbuf udata;
   OTSequence sequence;
};
typedef struct TCall TCall;

/*Timestamp Data Type

Contains an Open Transport timestamp.

typedef UnsignedWide OTTimeStamp;
Discussion

The timestamp data type is a 64-bit value that contains an Open Transport timestamp. The timestamp has unspecified units; you must use one of the timestamp manipulation functions described in “Timestamp Utility Functions” to convert the timestamp to known quantities. The timestamp data type is defined by the OTTimeStamp data type.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UnsignedWide OTTimeStamp;


/*LIFO List Structure

Supports last-in, first-out lists in Open Transport.

struct OTLIFO {
   OTLink * fHead;
};
typedef struct OTLIFO OTLIFO;
Fields
fHead

A pointer to the first entry in the linked list. Set this to nil to initialize the structure before using it. 
Discussion

Open Transport LIFO (last-in, first-out) lists use the LIFO list structure. You must initialize this structure by setting the structure’s fHead field to NULL before using the LIFO list. Most Open Transport LIFO list operations are atomic.
Availability
Available in Mac OS X v10.0 and later.*/
struct OTLIFO {
   OTLink * fHead;
};
typedef struct OTLIFO OTLIFO;

/*TDiscon

Specifies data sent with the OTSndDisconnect function and retrieved by the OTRcvDisconnect function.

struct TDiscon {
   TNetbuf udata;
   OTReason reason;
   OTSequence sequence;
};
typedef struct TDiscon TDiscon;
Fields
udata

A TNetbuf structure that references data sent with the OTSndDisconnect function or received by the OTRcvDisconnect function. 
reason

A 32-bit value specifying an error code that identifies the reason for the disconnection. These codes are supplied by the protocol. For additional information, consult the documentation provided for the protocol you are using. 
sequence

A 32-bit value specifying an outstanding connection request that has been rejected. This field is meaningful only when you have issued several connection requests to the same endpoint and are awaiting the results. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TDiscon {
   TNetbuf udata;
   OTReason reason;
   OTSequence sequence;
};
typedef struct TDiscon TDiscon;

/*TLookupRequest

Specifies the entity name to be looked up by the OTLookupName function.

struct TLookupRequest {
   TNetbuf name;
   TNetbuf addr;
   UInt32 maxcnt;
   OTTimeout timeout;
   OTFlags flags;
};
typedef struct TLookupRequest TLookupRequest;
Fields
name

A TNetbuf structure specifying the location and size of a buffer that contains the name to be looked up. You must allocate a buffer that contains the name, set the name.buf field to point to it, and set the name.len field to the length of the name.
addr

A TNetbuf structure describing the address of the node where you expect the names to be stored. You should normally supply 0 for addr.len. This causes the provider to use internal defaults for the starting point of the search. For a protocol family such as AppleTalk, in which every node has access to name and address information, this parameter is meaningless.

Specifying an address has meaning for those protocols that use a dedicated server or other device to store name information. In such a case, the name specified would override the protocol’s default address. To specify an address, you would need to allocate a buffer containing the address, set the addr.buf field to point to it, and set the addr.len field to the length of the address. Consult the documentation supplied with your protocol to determine whether you can or should specify an address.

maxcnt

A long specifying the number of names you expect to be returned. Some protocols allow the use of wildcard characters in specifying a name. As a result, the OTLookupName function might find multiple names matching the specified name pattern. If you expect a specific number of replies for a particular name or do not expect to exceed a specific number, you should specify this number to obtain faster execution. Otherwise, set this field to 0xffff ffff; in this case, the timeout value will control the lookup.
timeout

A long specifying the amount of time, in milliseconds, that should elapse before Open Transport gives up searching for a name. Specify 0 to leave the timeout value up to the underlying naming system. 
flags
Discussion

You use the TLookupRequest structure to specify the entity name to be looked up by the OTLookupName function and to set additional values that the mapper provider uses to circumscribe the search.
Availability
Available in Mac OS X v10.0 and later.*/
struct TLookupRequest {
   TNetbuf name;
   TNetbuf addr;
   UInt32 maxcnt;
   OTTimeout timeout;
   OTFlags flags;
};
typedef struct TLookupRequest TLookupRequest;

/*TLookupReply

Stores information passed back to your application by the OTLookupName function.

struct TLookupReply {
   TNetbuf names;
   UInt32 rspcount;
};
typedef struct TLookupReply TLookupReply;
Fields
names

A TNetbuf structure that specifies the size and location of a buffer into which the OTLookupName function, on return, places the names it has found. You must allocate the buffer into which the replies are stored when the function returns; you must set the names.buf field to point to it; and you must set the names.maxlen field to the size of the buffer. 
rspcount

A long specifying, on return, the number of names found.
Discussion

You use the TLookupReply structure to store information passed back to you by the OTLookupName function. The information includes both a pointer to a buffer (containing registered entity names matching the criterion specified with the TLookupRequest structure) and the number of names found.
Availability
Available in Mac OS X v10.0 and later.*/
struct TLookupReply {
   TNetbuf names;
   UInt32 rspcount;
};
typedef struct TLookupReply TLookupReply;

/*OTNextLookupBuffer Macro
Returns the address of the next lookup buffer.

#define OTNextLookupBuffer(buf)\
   ((TLookupBuffer*)\
      ((char*)buf + ((offsetof(TLookupBuffer, fAddressBuffer) + 
buf->fAddressLength + buf->fNameLength + 3) & ~3)))
This macro takes the address of a TLookupBuffer and returns the address of the next one.*/

#define OTNextLookupBuffer(buf)\
   ((TLookupBuffer*)\
      ((char*)buf + ((offsetof(TLookupBuffer, fAddressBuffer) + \
buf->fAddressLength + buf->fNameLength + 3) & ~3)))

/*TUnitData

Describes the data being sent with the OTSndUData function and the data being read with the OTRcvUData function.function (page 467)

struct TUnitData {
   TNetbuf addr;
   TNetbuf opt;
   TNetbuf udata;
};
typedef struct TUnitData TUnitData;
Fields
addr

A TNetbuf structure for address information. 
opt

A TNetbuf structure for option information. 
udata

A TNetbuf structure for data. 
Discussion

You use the TUnitData structure to describe the data being sent with the OTSndUData function and the data being read with the OTRcvUData function; you pass this structure as a parameter to each of these functions. When sending data you must initialize the buf and len fields of all the TNetbuf structures. When receiving data, you must initialize the buf and maxlen fields of all the TNetbuf structures.
Availability
Available in Mac OS X v10.0 and later.*/
struct TUnitData {
   TNetbuf addr;
   TNetbuf opt;
   TNetbuf udata;
};
typedef struct TUnitData TUnitData;


//function

/*InitOpenTransportInContext

Initializes the parts of Open Transport for use by the application or code resource. (Deprecated in Mac OS X v10.4.)

OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);
Parameters
flags

Tells Open Transport whether your code is an application or a plug-in.
outClientContext

Returns the client context pointer. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

In Carbon, the InitOpenTransportInContext function acts like the pre-Carbon InitOpenTransport function, except that it takes parameters that specify initialization context explicitly.

Use the flags parameter to tell Open Transport whether your code is an application or some other target (for example, a plug-in that runs in an application context but is not the application itself). The second parameter returns the client context pointer, which you must pass to other asset-creation routines. For more information, see Understanding Open Transport Asset Tracking at http://developer.apple.com/technotes/tn/tn1173.html.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);

/*OTOpenEndpointInContext

Opens an endpoint that operates synchronously. (Deprecated in Mac OS X v10.4.)

EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
info
err
clientContext
Return Value

See the description of the EndpointRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);

/*OTCreateConfiguration

Creates a structure defining a provider’s configuration. (Deprecated in Mac OS X v10.4.)

Modified

OTConfigurationRef OTCreateConfiguration (
   const char * path
);
Parameters
path

A pointer to a character string describing the provider.
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCreateConfiguration function creates a configuration structure that defines the software modules, hardware ports, and options that Open Transport is to use when you call a function to open a provider. This is a private structure, defined by the OTConfiguration data type . To create one, you use the path parameter to pass the OTCreateConfiguration function a string describing the provider service desired.

The simplest possible value of the path parameter is a single protocol module name of the highest-level protocol you want to use; for example, “tcp.” If you do not specify a complete communications path, the Open Transport software uses default settings to construct the rest of the path. For example, if you specify “adsp” for the path parameter, Open Transport defaults to using the AppleTalk DataStream Protocol (ADSP) protocol module layered above the Datagram Delivery Protocol (DDP) protocol module and with LocalTalk on the default port, which is the printer port.

If you want to identify a particular port in the configuration string, you use the port name to do so (described in the section “About Port Information,” beginning on page 6-5). More typically, however, you leave this value blank— for example, using a string with only “adsp” or “adsp, ddp,” which configures the provider with whatever port is specified in the control panel.

To specify more than one protocol module, separate the module names with commas. You can also specify values for options by putting them in parentheses after the protocol name; for example, “adsp, ddp (Checksum=1)” specifies that ADSP is to run on top of DDP and that the checksum option is enabled.

If Open Transport cannot parse the list that you pass in the path parameter, the OTCreateConfiguration function returns ((OTConfiguration*)-1L). If there is insufficient memory to create an OTConfiguration structure, the OTCreateConfiguration function returns NULL.

The OTCreateConfiguration function returns a pointer to the configuration structure it creates. You pass this pointer as a parameter to the open-provider functions such as the OTOpenEndpoint or OTOpenMapper functions.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Passing inline options to OTCreateConfiguration-for example, OTCreateConfiguration("tcp(NoDelay=1)")-is not supported on Mac OS X. Instead, you should explicitly set any options using the function OTOptionManagement.

Declared In
OpenTransport.h*/

OTConfigurationRef OTCreateConfiguration (
   const char * path
);

/*OTCloseProvider

Closes a provider of any type—endpoint, mapper, or service provider. (Deprecated in Mac OS X v10.4.)

OSStatus OTCloseProvider (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTCloseProvider function closes the provider that you specify in the ref parameter. Closing the provider deletes all memory reserved for it in the system heap, deletes its resources, and cancels any provider functions that are currently executing.

Open Transport does not guarantee that all outstanding functions have completed before it closes the provider. It is ultimately your responsibility to make sure that all provider functions that you care about have finished executing, before you close and delete a provider.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTCloseProvider (
   ProviderRef ref
);

/*CloseOpenTransportInContext

Unregisters your application or code resource connection to Open Transport. (Deprecated in Mac OS X v10.4.)

void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);
Parameters
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

The CloseOpenTransportinContext function acts like the pre-Carbon CloseOpenTransport function except that it takes an additional parameter, an OTClientContextPtr, which can be NULL for applications. Other types of clients must provide a valid client context pointer.
Declared In
OpenTransport.h*/
void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);

/*OTGetEndpointInfo

Obtains information about an endpoint that has been opened. (Deprecated in Mac OS X v10.4.)

OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);
Parameters
ref
info
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTGetEndpointInfo function returns information about
the maximum size of buffers used to specify an endpoint’s address and option values
the maximum size of normal and expedited data you can transfer using this endpoint or, for transaction-based endpoints, the maximum size of requests and replies
the size of data you can transfer when initiating or tearing down a connection
the services supported by the endpoint
any additional characteristics of this endpoint
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);

/*OTAllocMemInContext

Allocates memory using an explicit client context. (Deprecated in Mac OS X v10.4.)

void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);
Parameters
size
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);

/*OTOptionManagement

Determines an endpoint’s current or default option values or changes these values. (Deprecated in Mac OS X v10.4.)

OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);
Parameters
ref
req
ret
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

To use the OTOptionManagement function, you must have opened an endpoint using the OTOpenEndpoint or OTAsyncOpenEndpoint functions.

You use the OTOptionManagement function to negotiate, retrieve, or verify an endpoint’s protocol options. If the endpoint is in asynchronous mode and you have not installed a notifier function, it is not possible to determine when the function completes.

The action taken by the OTOptionManagement function is determined by the setting of the req->flags field. The following bulleted items describe the different operations that you can perform and the flag settings that you use to specify these operations.
To negotiate values for the endpoint, you must call the OTOptionManagement function, specifying T_NEGOTIATE for the req->flags field. The endpoint provider evaluates the requested options, negotiates the values, and returns the resulting values in the option management structure pointed to by the ret->opt.buf field. The status field of each returned option is set to a constant that indicates the result of the negotiation. These constants are described by the “Open Transport Flags and Status Codes” enumeration.

For any protocol specified, you can negotiate for the default values of all options supported by the endpoint by specifying the value T_ALLOPT for the name field of the TOption structure. This might be useful if you want to change current settings or if negotiations for other values have failed. The success of the negotiations depends partly on the state of the endpoint—that is, simply because these are default values does not guarantee a completely successful negotiation. When the function returns, the resulting values are returned, option by option, in the buffer pointed to by the ret->opt.buf field.
To retrieve an endpoint’s default option values, call the OTOptionManagement function, specifying T_DEFAULT for the req->flags field. You must also specify the name of the option (but not its value) in the TOption structure that you create for each of the options you are interested in.

When the function returns, it passes the default values for the options back to you in the buffer pointed to by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.

When getting an endpoint’s default option values, you can specify T_ALLOPT for the option name. This returns all supported options for the specified level with their default values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To retrieve an endpoint’s current option values, call the OTOptionManagement function, specifying T_CURRENT for the req->flags field. For each option in the buffer referenced by the req->opt.buf field, specify the name of the option you are interested in. The function ignores any option valuesyou specify.

When the function returns, it passes the current values for the options back to you in the buffer referenced by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the “Open Transport Flags and Status Codes” enumeration.

When retrieving an endpoint’s current option values, you can specify T_ALLOPT for the option name. The function returns all supported options for the specified protocol, with their current values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To check whether an endpoint provider supports certain options or option values, you must call the OTOptionManagement function, specifying T_CHECK for the req->flags field. Checking options or their values does not change the current settings of an endpoint’s options.
To check whether an option is supported, set the name field of the TOption structure to the option name, but do not specify an option value. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set to T_SUCCESS if the option is supported, T_NOTSUPPORT if it is not supported or needs additional client privileges, and T_READONLY if it is read-only.
To check whether an option value is supported, set the name field of the TOption structure to the option name, and set the value field to the value you want to check. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set as it would be if you had specified the T_NEGOTIATE flag. The overall result of the option checks is returned in the ret->flags field, which contains the single worst result of the option checks. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);

/*OTFreeMem

Frees memory allocated with the OTAllocMem function. (Deprecated in Mac OS X v10.4.)

void OTFreeMem (
   void * mem
);
Parameters
mem
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTFreeMem (
   void * mem
);

/*OTNextOption

Locates the next TOption structure in a buffer. (Deprecated in Mac OS X v10.4.)

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);
Parameters
buffer

A pointer to the buffer containing the option to be found.
buflen

A long specifying the size of the buffer containing the option to be found.
prevOptPtr
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTNextOption function allows you to parse through a buffer containing TOption structures describing an endpoint’s option values. Within the buffer, TOption structures are aligned to long-word boundaries. This function takes into account this padding when it calculates the beginning address of the next TOption structure and it returns that address in the prevOptPtr parameter.

The first time you call the option, set the prevOptPtr parameter to the beginning address of the buffer. When the function returns, the prevOptPtr parameter points to the next (second) option in the buffer. You can continue this process, specifying the value returned for the prevOptPtr parameter by the previous invocation of the function, each time you call the function to obtain the beginning address of each option in the buffer.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);

/*OTStrLength

Returns the length of a C string. (Deprecated in Mac OS X v10.4.)

OTByteCount OTStrLength (
   const char * str
);
Parameters
str
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTByteCount OTStrLength (
   const char * str
);

/*OTInstallNotifier

Installs a notifier function. (Deprecated in Mac OS X v10.4.)

OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);
Parameters
ref
proc

For C++ applications, the proc parameter must point to either a C function or a static member function. See OTNotifyUPP data type.
contextPtr

A context pointer for your use. The provider passes this value unchanged to your notifier function when it calls the function.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTInstallNotifier function installs a notifier function for the provider that you specify. Changing a provider’s mode of execution does not affect the notifier function. The notifier function remains installed until you remove it using the OTRemoveNotifier function or until you close the provider.

Before calling the OTInstallNotifier function, you must open the provider for which you want to install the notifier. If you open a provider asynchronously (for example, with the OTAsyncOpenEndpoint function), you must pass a pointer to a notifier function as a parameter to the function used to open the provider. In this case, you don’t need to call the OTInstallNotifier function unless you want to install a different notifier function. If you do, you must call the OTRemoveNotifier function before calling the OTInstallNotifier function.

Opening a provider synchronously (for example, with the OTOpenEndpoint function) opens the provider but does not install a notifier function for it. If you need a notifier function for a provider opened synchronously, you must call the OTInstallNotifier function. This notifier would not return completion events, but would return asynchronous events advising you of the arrival of data, of changes in flow-control restrictions, and so on.

Call the OTInstallNotifier function only when no provider functions are executing for the provider that you specify. Otherwise, the OTInstallNotifier function returns the result code kOTStateChangeErr.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);

/*OTSetSynchronous

Sets a provider’s mode of execution to synchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetSynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetSynchronous function causes all provider functions to run synchronously when using the provider that you specify.

Changing a provider’s mode of execution does not affect its notifier function, if any is installed for this provider; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetSynchronous (
   ProviderRef ref
);

/*OTSetNonBlocking

Disallows a provider from waiting if it cannot currently complete a function that sends or receives data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetNonBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetNonBlocking function causes provider functions to return a result code immediately, instead of waiting for a function that sends or receives data to complete. When you open a provider, its mode of operation is set to nonblocking by default.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetNonBlocking (
   ProviderRef ref
);

/*OTUseSyncIdleEvents

Allows synchronous idle events to be sent to your notifier. (Deprecated in Mac OS X v10.4.)

OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);
Parameters
ref
useEvents
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);

/*OTBind

Assigns an address to an endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);
Parameters
ref
reqAddr

If you specify NIL for the reqAddr parameter, Open Transport chooses a protocol address for you and requests 0 as the endpoint’s maximum number of concurrent outstanding connect indications.

If you want Open Transport to assign an address for you, setthe addr.len field of the TBind structure to 0.
retAddr

You can set this parameter to nil if you do not care to know what address the endpoint is bound to or what the negotiated value of qlen is.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTBind function to request an address that an endpoint be bound to. You can either use the reqAddr parameter to request that the endpoint be bound to a specific address or allow the endpoint provider to assign an address dynamically by passing nil for this parameter. Consult the documentation for the top-level protocol you are using to determine whether it is preferable to have the address assigned dynamically. The function returns the address to which the endpoint is actually bound in the retAddr parameter. This might be different from the address you requested, if you requested a specific address.

If you are binding a connection-oriented endpoint, you must use the reqAddr->qlen field to specify the number of connection requests that may be outstanding for this endpoint. The retAddr->qlen field specifies, on return, the actual number of connection requests allowed for the endpoint. This number might be smaller than the number you requested. Note that when the endpoint is actually connected, the number might be further decreased by negotiations taking place at that time.

If you call the OTBind function asynchronously and you have not installed a notifier function, the only way to determine when the function completes is to poll the endpoint using the OTGetEndpointState function. This function returns a kOTStateChangeErr until the bind completes. When the endpoint is bound, the state is either T_UNBND if the bind failed, or T_IDLE if it succeeded.

You can cancel an asynchronous bind that is still in progress by calling the OTUnbind function.

You must not bind more than one connectionless endpoint to a single address. Some connection-oriented protocols let you bind two or more endpoints to the same address. In such instances, you must use only one of the endpoints to listen for connection requests for that address. When binding the endpoint listening for a connection, you must set the reqAddr->qlen field of the OTBind function to a value greater than or equal to 1. When binding the other endpoints, you must set the reqAddr->qlen field to 0.

If you accept a connection for an endpoint that is also listening for connection requests, the address of that endpoint is deemed “busy” for the duration of the connection, and you must not bind another endpoint for listening to that same address. This requirement prevents more than one endpoint bound to the same address from accepting connection requests. If you have to bind another listening endpoint to the same address, you must first use the OTUnbind function to unbind the first endpoint or use the OTCloseProvider function to close it.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);

/*OTRcv

Reads data sent using a connection-oriented transactionless protocol. (Deprecated in Mac OS X v10.4.)

OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);
Parameters
ref
buf

A pointer to a memory location where the incoming data is to be copied. You must allocate this buffer before you call the function.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You call the OTRcv function to read data sent by the peer to which you are connected. If the OTRcv function succeeds, it returns an integer (OTStatus) specifying the number of bytes received. The function places the data read into the buffer referenced by the buf parameter. If the function fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure. You can call this function to receive either normal or expedited data. If the data is expedited, the T_EXPEDITED flag is set in the flags parameter.

If T_MORE is set in the flags parameter when the function returns, this means that the buffer you allocated is too small to contain the data to be read and that you must call the OTRcv function again. If you have read x bytes with the first call, the next call to the OTRcv function begins to read at the (x + 1) byte. Of course, if you need it, you must copy the data in the buffer to another location before calling the function again. Each call to this function that returns with the T_MORE flag set means that you must call the function again to get more data. When you have read all the data, the OTRcv function returns with the T_MORE flag not set. If the endpoint does not support the concept of a TSDU (Transport Service Data Unit), the T_MORE flag is not meaningful and should be ignored. To determine whether the endpoint supports TSDUs, examine the tsdu field of the TEndpointInfo structure. A value of T_INVALID means that the endpoint does not support it.

Some protocols allow you to send zero-length data to signal the end of a logical unit. In this case, if you request more than 0 bytes when calling the OTRcv function, the function returns 0 bytes only to signal the end of a TSDU.

If the OTRcv function returns and the T_EXPEDITED bit is set in the flags parameter, this means that you are about to read expedited data. If the number of bytes of expedited data exceeds the number of bytes you specified in the reqCount parameter, both the T_EXPEDITED and the T_MORE bits are set. You must call the OTRcv function until the T_MORE flag is not set to retrieve the rest of the expedited data.

If you are calling the OTRcv function repeatedly to read normal data and a call to the function returns T_EXPEDITED in the flags parameter, the next call to the OTRcv function that returns without the T_EXPEDITED flag set returns normal data at the place it was interrupted. It is your responsibility to remember where that was and to continue processing normal data. You can determine how much normal data you read by maintaining a running total of the number of bytes returned in the OTStatus result.

If the endpoint is in asynchronous mode or is not blocking, the function returns with the kOTNoDataErr result if no data is available. If you have installed a notifier, the endpoint provider calls your notifier and passes T_DATA or T_EXDATA for the code parameter when there is data available. If you have not installed a notifier, you may poll for these events using the OTLook function. Once you receive a T_DATA or T_EXDATA event, you should continue in a loop, calling the OTRcv function until it returns with the kOTNoDataErr result.

If the endpoint is in synchronous mode and is blocking, the endpoint waits for data if none is currently available. You should avoid calling the OTRcv function this way because it might cause processing to hang if no data is available. If you are doing other operations in synchronous mode, you should put the endpoint in nonblocking mode before calling the OTRcv function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);

/*OTSnd

Sends data to a remote peer. (Deprecated in Mac OS X v10.4.)

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);
Parameters
ref
buf

A pointer to the data being sent. If you are sending data that is not stored contiguously, this is a pointer to an OTData structure that describes the first data fragment.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You use the OTSnd function to send data to a remote peer. Before you use this function, you must establish a connection with the peer.

If the OTSnd function succeeds, it returns an integer (OSStatus) specifying the number of bytes that were actually sent. If it fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure.

You specify the data to be sent by passing a pointer to the data (buf) and byspecifying the size of the data (nbytes). The maximum size of the data you can send is specified by the tsdu field of the TEndpointInfo structure for the endpoint.

Some protocols use expedited data for control or attention messages. To determine whether the endpoint supports this service, examine the etsdu field of the TEndpointInfo structure. A positive integer for the etsdu field indicates the maximum size in bytes of expedited data that you can send. To send expedited data, you must set the T_EXPEDITED bit of the flags parameter.

If you want to break up the data sent into smaller logical units, you can set the T_MORE bit of the flags parameter to indicate that you are using additional calls to the OTSnd function to send more data that belongs to the same logical unit. To indicate that the last data unit is being sent, you must specify 0 for nbytes and turn off the T_MORE flag. This is the only circumstance under which it is permitted to send a zero-length data unit. If the endpoint does not support the sending of zero-length data, the OTSnd function fails with the kOTBadDataErr result.

If the endpoint is in blocking mode, the OTSnd function returns after it actually sends the data. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSnd function returns with the kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it returns a T_GODATA event to let you know that it is possible to send data.

The following table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSnd function.
Table A-1  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);

/*OTConnect

Requests a connection to a remote peer. (Deprecated in Mac OS X v10.4.)

OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);
Parameters
ref
sndCall
rcvCall

This parameter is only meaningful for synchronous calls to the OTConnect function. See TCall data type.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous mode, the OTConnect function returns after the connection is established and fills in the fields of the TCall structure (referenced by the rcvCall parameter) with the actual values associated with this connection. These might be different from the values you specified using the sndCall parameter.

If the OTConnect function returns with the kOTLookErr result, this might be either because of a pending T_LISTEN or T_DISCONNECT event. That is, either a connection request from another endpoint has interrupted execution of the function, or the remote endpoint has rejected the connection. If you don’t have a notifier installed, you can call the OTLook function to identify the event that caused the kOTLookErr result. If the event is T_LISTEN, you must accept or reject the incoming request and then continue processing the OTConnect function by calling OTRcvConnect. If the event is T_DISCONNECT, you must call the OTRcvDisconnect function to clear the error condition—that is, to deallocate memory and place the endpoint in the correct state.

If the endpoint is in asynchronous mode, the OTConnect function returns before the connection is established with a kOTNoDataErr result to indicate that the connection is in progress. When the connection is established, the endpoint provider calls your notifier, passing T_CONNECT for the code parameter. In response, you must call the OTRcvConnect function to read the connection parameters that would have been returned using the rcvCall parameter if the endpoint were in synchronous mode.

It is possible that the remote address returned in the addr field of the rcvCall parameter is not the same as the address you requested using the sndCall->addr field. This happens when the connection is accepted for a different endpoint than the one receiving the connection request.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);

/*OTSetBlocking

Allows a provider to wait or block until it is able to send or receive data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetBlocking function causes provider functions that send or receive data to wait if current conditions prevent them from completing an operation. By default, a provider is in nonblocking mode, in which case, if a provider function were unable to complete sending or receiving data, it would return immediately with a result that would tell you why the operation was unable to complete.

If a provider is in blocking mode and you call the OTCloseProvider function to close the provider, Open Transport gives each Streams module up to 15 seconds to process outgoing commands. It is recommended that you call the OTSetNonBlocking function before you call the OTCloseProvider function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetBlocking (
   ProviderRef ref
);

/*NewOTNotifyUPP

Creates a new universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the OTNotifyUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);

/*OTMemzero

Initializes the specified memory range to 0. (Deprecated in Mac OS X v10.4.)

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);
Parameters
dest
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);


/*OTAtomicAdd32

Atomically adds a 32-bit value to a memory location. (Deprecated in Mac OS X v10.4.)

SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);
Parameters
toAdd
dest
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);

/*OTGetTimeStamp

Obtains the current timestamp. (Deprecated in Mac OS X v10.4.)

void OTGetTimeStamp (
   OTTimeStamp * currentTime
);
Parameters
currentTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTGetTimeStamp (
   OTTimeStamp * currentTime
);

/*OTLIFOEnqueue

Places a link at the front of a LIFO list. (Deprecated in Mac OS X v10.4.)

void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);
Parameters
list
link
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);

/*OTLIFODequeue

Removes the first link in a LIFO list and returns a pointer to it. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFODequeue (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFODequeue (
   OTLIFO * list
);

/*OTLIFOStealList

Removes all links in a LIFO list and returns a pointer to the first link in the list. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFOStealList (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFOStealList (
   OTLIFO * list
);

/*OTReverseList

Reverses the order in which entries are linked in a list. (Deprecated in Mac OS X v10.4.)

OTLink * OTReverseList (
   OTLink * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTLink * OTReverseList (
   OTLink * list
);

/*OTGetEndpointState

Obtains the current state of an endpoint. (Deprecated in Mac OS X v10.4.)

OTResult OTGetEndpointState (
   EndpointRef ref
);
Parameters
ref
Return Value

See the description of the OTResult data type.
Discussion

The OTGetEndpointState function returns an integer greater than or equal to 0 indicating the state of the specified endpoint. The endpoint state enumeration describes possible endpoint states and lists their decimal value.

If the function fails, it returns a negative integer specifying the error code. You must open an endpoint before you can determine its state.

You might need to know an endpoint’s state in order to determine whether a function has completed or whether the endpoint is in an appropriate state for the function that you want to call next.

This function returns endpoint state information immediately, whether the endpoint is in synchronous or asynchronous mode.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTGetEndpointState (
   EndpointRef ref
);

/*OTAtomicTestBit

Tests a bit in a byte and returns its current state. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicTestBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicTestBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);

/*OTAtomicSetBit

Sets a specified bit in a byte. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicSetBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicSetBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);

/*OTAsyncOpenEndpoint
Opens an endpoint and installs a notifier callback function for the endpoint.

C INTERFACE
OSStatus OTAsyncOpenEndpoint( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OTNotifyProcPtr proc, 
                     void* contextPtr);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
config 
A pointer to an endpoint configuration structure that specifies the endpoint's characteristics. You obtain a value for the config parameter by calling the OTCreateConfiguration function. The OTAsyncOpenEndpoint function disposes of the configuration structure before returning. 
oflag 
Reserved; must be set to 0. 
info 
A pointer to a TEndpointInfo structure to be filled in by the OTAsyncOpenEndpoint function. Specify NULL for this parameter if you do not want the OTAsyncOpenEndpoint function to return endpoint information. 
proc 
A pointer to a notifier callback function for this endpoint. If you do not provide a notifier function, your application cannot receive completion events, including the event advising you that the endpoint has been created. Never pass a universal procedure pointer as the proc parameter. 
contextPtr 
A pointer for your use. The endpoint passes this pointer value when calling the notifier function you specify in the proc parameter. You might use the contextPtr parameter to pass your notifier function information about the endpoint, for example. 
function result 
An error code. See Discussion. 
DISCUSSION
The OTAsyncOpenEndpoint function opens an endpoint having the characteristics specified by the config parameter. How processing proceeds depends on this result code.

If the result code is any except kOTNoError, an error occurred and Open Transport does not queue the function for execution. The OTAsyncOpenEndpoint function creates no endpoint and does not call the notifier function that you specified in the proc parameter.

If the result code is kOTNoError, the OTAsyncOpenEndpoint function has queued the operation for execution. When it completes it calls the notifier function that you specified in the proc parameter, passing the event T_OPENCOMPLETE for the code parameter, a result code in the result parameter, and the endpoint reference for the newly created endpoint in the cookie parameter. For information about notifier functions, see "Application-Defined Notifier Functions" and "Event Codes". 

An endpoint created by the OTAsyncOpenEndpoint function operates in asynchronous mode, does not block, and does not acknowledge sends. To change these default settings, you can call the OTSetSynchronous function, OTSetBlocking function and the OTAckSends function. 

The initial state of an endpoint is T_UNBND, meaning that the endpoint is not bound to a protocol address. Before using the endpoint to transfer data, you must bind it to a protocol address by calling the OTBind function.

SPECIAL CONSIDERATIONS
The first time you open a provider of any kind, Open Transport allocates needed resources at system task time, calling the ScheduleSystemTask function to do this. To allow this processing to take place, you need to call SystemTask or WaitNextEvent from a foreground task while waiting for the endpoint to be created.

The OTAsyncOpenEndpoint function disposes of the configuration structure returned by the OTCreateConfiguration function. If you want to use the same configuration to open additional endpoints, you must obtain a valid copy of the configuration structure by calling the OTCloneConfiguration function before you call the OTAsyncOpenEndpoint function. For more information, see "Configuring and Opening a Provider".

SEE ALSO
The OTOpenEndpoint function.*/
OSStatus OTAsyncOpenEndpoint( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OTNotifyProcPtr proc, 
                     void* contextPtr);

/*OTAtomicClearBit

Clears a bit in a byte. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicClearBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicClearBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);

/*OTDestroyConfiguration

Deletes an OTConfiguration structure. (Deprecated in Mac OS X v10.4.)

void OTDestroyConfiguration (
   OTConfigurationRef cfig
);
Parameters
cfig
Discussion

The OTDestroyConfiguration function deletes the OTConfiguration structure that you specify in the cfig parameter and releases all associated memory.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTDestroyConfiguration (
   OTConfigurationRef cfig
);

/*OTUnbind

Dissociates an endpoint from its address or cancels an asynchronous call to the OTBind function. (Deprecated in Mac OS X v10.4.)

OSStatus OTUnbind (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If you call the OTUnbind function asynchronously and you have not installed a notifier function, the only way to determine that the endpoint has been unbound is to use the OTGetEndpointState function to poll the state of the endpoint. The function returns the kOTStateChangeErr result when the OTUnbind function returns. If the function succeeds, the state of the endpoint is T_UNBND. If it fails, its state is T_IDLE.

After you unbind an endpoint, you can no longer use it to send or receive information. You can use the OTCloseProvider function to deallocate memory reserved for the endpoint, or you can use the OTBind function to associate it with another address and then resume transferring data or establishing a connection.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUnbind (
   EndpointRef ref
);

/*InitOpenTransport
Initializes the parts of Open Transport for use by the application or code resource.

C INTERFACE 
OSStatus InitOpenTransport(void);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
function result 
An error code. See Appendix B. 
DISCUSSION
Call this function before using other Open Transport functions. 

If you need to know whether Open Transport is present at start-up time, but you don't need to use it (e.g. an installer),you can use the Gestalt function and its Open Transport selectors as described in "The Gestalt Selector and Response Bits". However, for normal applications, your calling the InitOpenTransport function is sufficient to test for the presence of Open Transport.

To initialize only the parts of Open Transport that handle ports and implement the Open Transport utility functions call the InitOpenTransportUtilities function.

SPECIAL CONSIDERATIONS 
You must make sure that your A5 world is correctly initialized for 68000 code resources.

If your program uses the Apple Shared Library Manager (ASLM), you must call the InitLibraryManager function to initialize ASLM before calling the InitOpenTransport function. To initialize ASLM, use the InitLibraryManager function, described in the Apple Shared Library Manager Developer's Guide.

For applications, Open Transport patches the ExitToShell trap when you call the function InitOpenTransport. The patch calls the function CloseOpenTransport if Open Transport is still active when your application quits.

SEE ALSO
"The Gestalt Selector and Response Bits".

"Initializing and Closing Open Transport". 

The CloseOpenTransport function.*/
OSStatus InitOpenTransport(void);

/*CloseOpenTransport
Unregisters your application or code resource connection to Open Transport.

C INTERFACE 
void CloseOpenTransport(void);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

DISCUSSION
The CloseOpenTransport function tells Open Transport that your application or code resource has finished using it. You can call this function only at system task time. You must not call this function if you have any outstanding network I/O in progress, such as an outstanding asynchronous operation.

When your application finishes using Open Transport, you have the option of using this function to unload Open Transport without stopping execution if your application has other tasks to perform that do not require Open Transport. If you are writing an application, you are not required to use this function, but it is strongly recommended that you do so.

If you are writing a code resource, a CFM code fragment, or a shared library, you must call the CloseOpenTransport function before unloading from memory.

System software cannot unload the Open Transport kernel until the last software module on your computer that called the InitOpenTransport function has also called the CloseOpenTransport function.

SPECIAL CONSIDERATIONS 
If your client uses the Apple Shared Library Manager, be sure you call the CleanupLibraryManager function after calling the CloseOpenTransport function. 

SEE ALSO
The InitOpenTransport function. 

The InitOpenTransportUtilities function. 

"Getting Started With Open Transport" in Networking With Open Transport.*/
void CloseOpenTransport(void);

/*OTRcvConnect

Reads the status of an outstanding or completed asynchronous call to theOTConnect function. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvConnect (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTRcvConnect function to determine the status of a previously issued OTConnect call. If you want to retrieve information about the connection, you must allocate buffers for the addr field and, if required, the opt and udata fields before you make the call.

If the endpoint is synchronous and blocking, the OTRcvConnect function waits for the connection to be accepted or rejected. If the connection is accepted, the function returns with a kOTNoError result. If the connection is rejected, the function returns with a kOTLookErr result. In this case, you should call the OTLook function to verify that a T_DISCONNECT event is the reason for the kOTLookErr, and then you should call the OTRcvDisconnect function to clear the event.

If the endpoint is asynchronous or nonblocking, the OTRcvConnect function returns with the kOTNoDataErr result if the connection has not yet been established.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvConnect (
   EndpointRef ref,
   TCall * call
);

/*OTCloneConfiguration

Copies an OTConfiguration structure. (Deprecated in Mac OS X v10.4.)

OTConfigurationRef OTCloneConfiguration (
   OTConfigurationRef cfig
);
Parameters
cfig
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCloneConfiguration function copies the OTConfiguration structure that you specify in the cfig parameter and returns a pointer to the copy. Because the internal format of an OTConfiguration structure is private, you must use the OTCloneConfiguration function to obtain two identical structures. For example, you can use this function when another application passes you a configuration structure that you want to reuse but for which you do not have the original configuration string. By cloning the structure, you have access to an additional copy of the configuration even without knowing its configuration string.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTConfigurationRef OTCloneConfiguration (
   OTConfigurationRef cfig
);

/*OTLook

Determines the current asynchronous event pending for an endpoint. (Deprecated in Mac OS X v10.4.)

OTResult OTLook (
   EndpointRef ref
);
Parameters
ref
Return Value

See the description of the OTResult data type.
Discussion

You use the OTLook function in one of two cases. First, if the endpoint is in synchronous mode, you can call the OTLook function to poll for incoming data or connection requests. Second, certain asynchronous events might cause a synchronous function to fail with the result kOTLookErr. For example, if you call OTAccept and the endpoint gets a T_DISCONNECT event, the OTAccept function returns with kOTLookErr. In this case, you need to call the OTLook function to determine what event caused the original function to fail. Table 3-7 on page 3-26 lists the functions that might return the kOTLookErr result and the events that can cause these functions to fail.

The OTLook function returns an integer value that specifies the asynchronous event pending for the endpoint specified by the ref parameter. On error, OTLook returns a negative integer corresponding to a result code.

If there are multiple events pending, the OTLook function first looks for one ofthe following events: T_LISTEN, T_CONNECT, T_DISCONNECT, T_UDERR, or T_ORDREL. If it finds more than one of these, it returns them to you in first-in, first-out order. After processing these events, the OTLook function looks for the T_DATA, T_REQUEST, and T_REPLY events. If it finds more than one of these, it returns them to you in first-in, first-out order. You cannot use the OTLook function to poll for completion events.

Unless you are operating exclusively in synchronous mode, it is recommended that you use notifier functions to get information about pending events for an endpoint.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTLook (
   EndpointRef ref
);

/*OTSndOrderlyDisconnect

Initiates or completes an orderly disconnection. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndOrderlyDisconnect (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTSndOrderlyDisconnect function to initiate an orderly release of a connection and to indicate to the peer endpoint that you have no more data to send. After calling this function, you must not send any more data over the connection. However, you can still continue to receive data if the peer endpoint has not yet called the OTSndOrderlyDisconnect function.

This function is a service that is not supported by all protocols. If it is supported, the servtype field of the TEndpointInfo structure has the value T_COTS_ORD or T_TRANS_ORD.

The OTSndOrderlyDisconnect function behaves exactly the same in all modes of operation.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSndOrderlyDisconnect (
   EndpointRef ref
);

/*OTRcvDisconnect

Identifies the cause of a connection break or of a connection rejection, acknowledges and clears the corresponding disconnection event. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvDisconnect (
   EndpointRef ref,
   TDiscon * discon
);
Parameters
ref
discon
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Calling the OTRcvDisconnect function clears the corresponding disconnection event and retrieves any user data sent with the disconnection.

If you do not care about data returned with the disconnection and do not needto know the reason for the disconnection nor the sequence ID, you may specify a nil pointer for the discon parameter. In this case, the provider discards any user data associated with the disconnection.

The OTRcvDisconnect function behaves in the same way for all modes of operation. If there is no disconnection request pending, the function returns with the kOTNoDisconnectErr result. If there is a disconnection request pending, the function returns either the kOTNoError or kOTBufferOverflowErr result. In the latter instance, you need to check the discon field of the TEndpointInfo structure for your endpoint and make sure that the buffer referenced by the udata.buf field is at least as big as the value specified for the discon field.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvDisconnect (
   EndpointRef ref,
   TDiscon * discon
);


/*OTRcvOrderlyDisconnect

Acknowledges a request for an orderly disconnect. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvOrderlyDisconnect (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTRcvOrderlyDisconnect function is a service that is not supported by all protocols. If it is, the servtype field of the TEndpointInfo structure has the value T_COTS_ORD or T_TRANS_ORD for the endpoint.

After using the OTRcvOrderlyDisconnect function to acknowledge receipt of a disconnection request, there will not be any more data to receive. Calls to the OTRcv function (for a transactionless connection) or to the OTRcvRequest function (for a transaction-based connection) after acknowledging a disconnection request fail with the kOTOutStateErr result. If the endpoint supports a remote orderly disconnect, you can still send data over the connection if you have not yet called the OTSndOrderlyDisconnect function.

The OTRcvOrderlyDisconnect function behaves in the same way in all modes of operation. If there is no disconnection request pending, the function returns with the kOTNoReleaseErr result. It there is a disconnection request pending, the function returns either the kOTNoError or kOTBufferOverflowErr result. In the latter instance, you need to check the discon field of theTEndpointInfo structure for your endpoint and make sure that the buffer referenced by the udata.buf field is at least as big as the value specified for the discon field.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvOrderlyDisconnect (
   EndpointRef ref
);

/*OTEnterNotifier

Limits the notifications that can be sent to your notifier. (Deprecated in Mac OS X v10.4.)

Boolean OTEnterNotifier (
   ProviderRef ref
);
Parameters
ref
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTEnterNotifier (
   ProviderRef ref
);

/*OTSndDisconnect

Tears down an open connection (abortive disconnect) or rejects an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndDisconnect (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

There are two functions that you can use to tear down a connection: OTSndDisconnect for an abortive disconnect, or OTSndOrderlyDisconnect for an orderly disconnect. It is recommended that you use the OTSndOrderlyDisconnect function for tearing down a connection whenever possible and that you use the OTSndDisconnect function only for rejecting incoming connection requests.

If the endpoint is in asynchronous mode, the OTSndDisconnect function returns immediately with a result of kOTNoError to indicate that the disconnection process has begun and that your notifier function will be called when the process completes.

When the connection has been broken, the provider issues a T_DISCONNECTCOMPLETE event. If you have installed a notifier function, Open Transport calls your notifier and passes this event in the code parameter. The cookie parameter contains the call parameter. If you have not installed a notifier function, you cannot determine when this function completes.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTSndDisconnect (
   EndpointRef ref,
   TCall * call
);

/*OTListen

Listens for an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTListen (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You use the OTListen function to listen for incoming connection requests. On return, the function fills in the TCall structure referenced by the call parameter with information about the connection request. After retrieving the connection request using the OTListen function, you can reject the request using the OTSndDisconnect function, or you can accept the request using the OTAccept function.

If the endpoint is in synchronous mode and is blocking, the OTListen function returns when a connection request has arrived. If the endpoint is in asynchronous mode or is not blocking, the OTListen function returns any pending connection requests or returns the kOTNoDataErr result if there are no pending connection requests. You can also call the OTListen function from within a notifier function in response to the T_LISTEN event. In this case, the function returns a result immediately.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTListen (
   EndpointRef ref,
   TCall * call
);

/*OTLeaveNotifier

Allows Open Transport to resume sending primary and completion events. (Deprecated in Mac OS X v10.4.)

void OTLeaveNotifier (
   ProviderRef ref
);
Parameters
ref
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLeaveNotifier (
   ProviderRef ref
);

/*OTAckSends

Specifies that a provider make an internal copy of data being sent and that it notify you when it has finished sending data. (Deprecated in Mac OS X v10.4.)

OSStatus OTAckSends (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

By default, providers make an internal copy of data before sending it and they do not acknowledge sends. If you use the OTAckSends function to specify that the provider acknowledge sends and you call a function that sends data, the provider does not copy the data before sending it. Instead, it reads data directly from your buffer while sending. For this reason, you must not change the contents of your buffer until the provider is no longer using it. The provider lets you know that it has finished using the buffer by calling your notifier function and passing T_MEMORYRELEASED event code for the code parameter, a pointer to the buffer that was sent in the cookie parameter, and the size of the buffer in the result parameter.

If you have not installed a notifier function for the provider, this function returns the kOTAccessErr result.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTAckSends (
   ProviderRef ref
);

/*OTIoctl

Sends a module-specific command to an Open Transport protocol module. (Deprecated in Mac OS X v10.4.)

SInt32 OTIoctl (
   ProviderRef ref,
   UInt32 cmd,
   void * data
);
Parameters
ref
cmd

A routine selector for the module-specific command.
data

Data to be used by the module-specific command, or a pointer to such data. The interpretation of the data parameter is command specific.
Discussion

The OTIoctl function sends a module-specific command to an Open Transport protocol module. The OTIoctl function runs synchronously or asynchronously, matching the provider’s mode of execution.

If the OTIoctl function completes synchronously without error, it returns 0 or a positive integer. The positive integer’s meaning is command specific. If the OTIoctl function fails while executing synchronously, its return value is a negative integer corresponding to an Open Transport result code.

If the OTIoctl function runs asynchronously, it returns immediately with a return value kOTNoError or another Open Transport result code. When the function completes execution, Open Transport calls the notifier function you specify, passing the event code kStreamIoctlEvent and a result parameter indicating the result of the completed OTIoctl function. If the value of the result parameter is greater than 0, the corresponding result code is defined by the command; otherwise, the value of the result parameter corresponds to an Open Transport result code.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

SInt32 OTIoctl (
   ProviderRef ref,
   UInt32 cmd,
   void * data
);

/*OTAccept

Accepts an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTAccept (
   EndpointRef listener,
   EndpointRef worker,
   TCall * call
);
Parameters
listener
worker
call
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTAccept (
   EndpointRef listener,
   EndpointRef worker,
   TCall * call
);

/*OTOpenEndpoint
Opens an endpoint. This function is synchronous, and creates an endpoint that operates synchronously.

C INTERFACE 
EndpointRef OTOpenEndpoint ( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OSStatus* err);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
config 
A pointer to an endpoint configuration structure that specifies the endpoint's characteristics. You obtain a value for the config parameter by calling the OTCreateConfiguration function. The OTOpenEndpoint function disposes of the configuration structure before returning. 
oflag 
Reserved; must be set to 0. 
info 
A pointer to a TEndpointInfo structure to be filled in by the OTOpenEndpoint function. Specify NULL for this parameter if you do not want the OTOpenEndpoint function to provide endpoint information. 
err 
A pointer to the result code for this function. 
function result 
An endpoint reference for the endpoint that has been created or NULL if the endpoint has not been created. 
DISCUSSION
The OTOpenEndpoint function opens an endpoint having the configuration specified by the config parameter. The function returns an endpoint reference, by which you refer to the created endpoint when calling provider functions. If the OTOpenEndpoint function fails, its return value is kOTInvalidEndpointRef. 

The function creates an endpoint that is synchronous, does not block, and does not acknowledge sends. To change these settings, you can call the OTSetAsynchronous function, the OTSetBlocking function and the OTAckSends function. 

The initial state of an endpoint is T_UNBND, meaning that the endpoint is not bound to an address. Before using the endpoint to transfer data, you must bind it to an address by calling the OTBind function.

To close and delete an endpoint, call the OTCloseProvider function.

SPECIAL CONSIDERATIONS 
The OTOpenEndpoint function can only be called at system task time because it is a synchronous function. 

The OTOpenEndpoint function disposes of the configuration structure passed in as a parameter. If you want to use the same configuration to open additional endpoints, you must obtain a copy of the configuration structure before calling the OTOpenEndpoint function, by calling the OTCloneConfiguration function. 

SEE ALSO
"Creating a Configuration Structure". 

"Reusing Provider Configurations". 

The OTAsyncOpenEndpoint function.

"Endpoint States".*/
EndpointRef OTOpenEndpoint ( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OSStatus* err);

/*OTMemcpy

Copies data from one memory location to another; the source and destination locations must not overlap. (Deprecated in Mac OS X v10.4.)

void OTMemcpy (
   void * dest,
   const void * src,
   OTByteCount nBytes
);
Parameters
dest
src
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTMemcpy (
   void * dest,
   const void * src,
   OTByteCount nBytes
);

/*OTOpenMapperInContext

Creates a synchronous mapper provider and returns a mapper reference. (Deprecated in Mac OS X v10.4.)

MapperRef OTOpenMapperInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
err
clientContext
Return Value

See the description of the MapperRef data type.
Discussion

Applications may pass a NULL pointer but non-applications must always pass a valid client context pointer.

You receive a client context pointer when you call the function InitOpenTransportInContext. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

MapperRef OTOpenMapperInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   OSStatus * err,
   OTClientContextPtr clientContext
);

/*OTLookupName

Finds and returns all addresses that correspond to a particular name or name pattern, or confirms that a name is registered. (Deprecated in Mac OS X v10.4.)

OSStatus OTLookupName (
   MapperRef ref,
   TLookupRequest * req,
   TLookupReply * reply
);
Parameters
ref
req
reply
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You can use the OTLookupName function to find out whether a name is registered and what address is associated with that name. You use the req parameter to supply the information needed for the search: what name should be looked up and, optionally, what node contains that information, how many matches you expect to find, and how long the search should continue before the function returns. On return, the reply parameter contains the names field that points to the buffer where the matching entries are stored and the rspcount field that specifies the number of matching entries.

For each registered name found, the OTLookupName function stores the following information in the buffer referenced by the names field of the reply parameter:unsigned short addrLen; / length of address that follows/
unsigned short nameLen; / length of name that follows /
unsigned char addr[]; / address /
unsigned char name[]; / name, padded to quad-word boundary/


If you are searching for names using a name pattern and you expect that more than one name will be returned to you, you need to parse the reply buffer to extract the matching names.

If you call the OTLookupName function asynchronously, the mapper provider calls your notifier function passing one of two completion codes for the code parameter (T_LKUPNAMERESULT or T_LKUPNAMECOMPLETE) and passing the reply parameter in the cookie parameter. The mapper provider passes the T_LKUPNAMERESULT code each time it stores a name in the reply buffer, and it passes the T_LKUPNAMECOMPLETE code when it is done. When you receive this event, examine the rspcount field to determine whether there is a last name to retrieve from the reply buffer. The use of both codes is a feature that gives you a choice about how to process multiple names when searching for names matching a pattern.
If you decide to allocate a buffer that is large enough to contain all the names returned, you can ignore the T_LKUPNAMERESULT code and call a function that parses the buffer once the OTLookupName function has completed—that is, once the provider calls your notifier function using the T_LKUPNAMECOMPLETE event.
If you want to save memory or if you don’t know how large a buffer to allocate, you can use the following method to process the names returned. Each time that the T_LKUPNAMERESULT event is passed, you must do something with the reply from the reply buffer. You can copy it somewhere, or you can delete it if it isn’t a name you’re interested in. Then, from inside your notifier you must set the reply->names.len field or the reply->rspcount field back to 0 (thus allowing the mapper provider to overwrite the original name). This tells the mapper provider that you are ready to receive another name. Accordingly, when the mapper provider has inserted another name into your reply buffer, it calls your notifier passing the T_LKUPNAMERESULT code, and you can process the new entry as you have processed the first entry. This method also saves you the trouble of having to parse through the buffer to extract name and address information.

The cookie parameter to the notifier contains the reply parameter.

The format of the names and protocol addresses are specific to the underlying protocol. Consult the documentation supplied for your protocol for more information.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTLookupName (
   MapperRef ref,
   TLookupRequest * req,
   TLookupReply * reply
);

/*OTSndUData

Sends data using a connectionless transactionless endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndUData (
   EndpointRef ref,
   TUnitData * udata
);
Parameters
ref
udata

A pointer to a TUnitData structure that specifies thedata to be sent and its destination. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous, blocking mode, the OTSndUData function returns immediately. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSndUData function returns a kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it calls your notifier function, passing T_GODATA for the code parameter. You can then call the OTSndUData function from your notifier to send the data. You can also retrieve this event by polling the endpoint using the OTLook function.

Some endpoint providers are not able to detect immediately whether you specified incorrect address or option information. In such cases, the provider calls your notifier function when it detects the error, passing the T_UDERR for the code parameter to advise you that an error has occurred. You can determine the cause of this event by calling the OTRcvUDErr function and examining the value of the uderr->error parameter. It is important that you call the OTRcvUDErr function even if you are not interested in examining the cause of the error. Failing to do this leaves the endpoint in an invalid state for doing other sends and makes the endpoint provider unable to deallocate memory reserved for internal buffers associated with the send.

The next table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSndUData function.
Table A-2  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. the kOTFlowErr result might be returned

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
the function returns immediately. the kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSndUData (
   EndpointRef ref,
   TUnitData * udata
);

/*OTRcvUData

Reads data sent by a client using a connectionless transactionless protocol. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvUData (
   EndpointRef ref,
   TUnitData * udata,
   OTFlags * flags
);
Parameters
ref
udata
flags
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

When the OTRcvUData function returns, it passes a pointer to a TUnitData structure containing information about the data read and a pointer to a flags variable that is set to indicate whether there is more data to be retrieved. If the buffer pointed to by the udata->udata.buf field is not large enough to hold the current data unit, the endpoint provider fills the buffer and sets the flags parameter to T_MORE to indicate that you must call the OTRcvUData function again to receive additional data. Subsequent calls to the OTRcvUData function return 0 for the length of the address and option buffers until you receive the full data unit. The last unit to be received does not have the T_MORE flag set.

If the endpoint is in asynchronous mode or is not blocking and data is not available, the OTRcvUData function fails with the kOTNoDataErr result. The endpoint provider uses the T_DATA event to notify the endpoint when data becomes available. You can use a notifier function or the OTLook function to retrieve the event. Once you get the T_DATA event, you should continue calling the OTRcvUData function until it returns the kOTNoDataErr result.

It is possible that the provider generates an erroneous T_DATA event. This is the case when the provider calls your notifier, passing T_DATA for the code parameter; but when you execute the OTRcvUData function, it returns with a kOTNoDataErr result. If this happens, you should continue normal processing and assume that the next T_DATA event is genuine.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvUData (
   EndpointRef ref,
   TUnitData * udata,
   OTFlags * flags
);

/*OTElapsedMicroseconds

Calculates the time elapsed in microseconds since a specified time. (Deprecated in Mac OS X v10.4.)

UInt32 OTElapsedMicroseconds (
   OTTimeStamp * startTime
);
Parameters
startTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
UInt32 OTElapsedMicroseconds (
   OTTimeStamp * startTime
);

/*DisposeOTNotifyUPP

Disposes of a universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

void DisposeOTNotifyUPP (
   OTNotifyUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void DisposeOTNotifyUPP (
   OTNotifyUPP userUPP
);

/*OTSetAsynchronous

Sets a provider’s mode of execution to asynchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetAsynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetAsynchronous function causes all functions for the provider specified in the ref parameter to run asynchronously. You must install a notifier function for the provider if it needs to receive completion events. You can install a notifier function either before or after calling the OTSetAsynchronous function.

Changing a provider’s mode of execution does not affect its notifier function, if any; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetAsynchronous (
   ProviderRef ref
);

/*OTTimeStampInMilliseconds

Calculates the time elapsed in milliseconds since since a specified time. (Deprecated in Mac OS X v10.4.)

UInt32 OTTimeStampInMilliseconds (
   OTTimeStamp * delta
);
Parameters
delta
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
UInt32 OTTimeStampInMilliseconds (
   OTTimeStamp * delta
);

/*OTSubtractTimeStamps

Subtracts one timestamp value from another. (Deprecated in Mac OS X v10.4.)

OTTimeStamp * OTSubtractTimeStamps (
   OTTimeStamp * result,
   OTTimeStamp * startTime,
   OTTimeStamp * endEnd
);
Parameters
result
startTime
endEnd
Return Value

See the description of the OTTimeStamp data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTTimeStamp * OTSubtractTimeStamps (
   OTTimeStamp * result,
   OTTimeStamp * startTime,
   OTTimeStamp * endEnd
);

/*OTMemset

Sets the specified memory range to a specific value. (Deprecated in Mac OS X v10.4.)

void OTMemset (
   void * dest,
   OTUInt8Param toSet,
   OTByteCount nBytes
);
Parameters
dest
toSet
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTMemset (
   void * dest,
   OTUInt8Param toSet,
   OTByteCount nBytes
);

#ifdef __cplusplus
}
#endif

#endif