#ifndef QUICKTIMESTREAMING_H
#define QUICKTIMESTREAMING_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMECOMPONENTS_H
#include <QuickTime/QuickTimeComponents.h>
#endif

//#include <HYS/QuickTime/QuickTimeStreaming.h>
#include <APPLE/QuickTime/QuickTimeStreaming.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*MediaPacketizerRequirements Values

Constants passed to MediaPacketizerRequirements.

enum {
   identityMatrixType            = 0x00,
   // result if matrix is identity //
   translateMatrixType           = 0x01,
   // result if matrix translates //
   scaleMatrixType               = 0x02,
   // result if matrix scales //
   scaleTranslateMatrixType      = 0x03,
   // result if matrix scales and translates //
   linearMatrixType              = 0x04,
   // result if matrix is general 2 x 2 //
   linearTranslateMatrixType     = 0x05,
   // result if matrix is general 2 x 2 and translates //
   perspectiveMatrixType         = 0x06  // result if matrix is general 3 x 3 //
};
enum {
   kMediaPacketizerCanPackEditRate = 1 << 0,
   kMediaPacketizerCanPackLayer  = 1 << 1,
   kMediaPacketizerCanPackVolume = 1 << 2,
   kMediaPacketizerCanPackBalance = 1 << 3,
   kMediaPacketizerCanPackGraphicsMode = 1 << 4,
   kMediaPacketizerCanPackEmptyEdit = 1 << 5
};
Constants
identityMatrixType

Matrix is identity; value is 0x00. 

Available in Mac OS X v10.0 and later.
translateMatrixType

Matrix translates; value is 0x01. 

Available in Mac OS X v10.0 and later.
scaleMatrixType

Matrix scales; value is 0x02. 

Available in Mac OS X v10.0 and later.
scaleTranslateMatrixType

Matrix translates and scales; value is 0x03. 

Available in Mac OS X v10.0 and later.
linearMatrixType

Matrix is general 2 x 2 type; value is 0x04. 

Available in Mac OS X v10.0 and later.
linearTranslateMatrixType

Matrix is general 2 x 2 type and translates; value is 0x05 

Available in Mac OS X v10.0 and later.
perspectiveMatrixType

Matrix is general 3 x 3 type; value is 0x06. 

Available in Mac OS X v10.0 and later.
kMediaPacketizerCanPackEditRate

The packetizer can pack the edit rate value. 

Available in Mac OS X v10.0 and later.
kMediaPacketizerCanPackLayer

The packetizer can pack the layer number. 

Available in Mac OS X v10.0 and later.
kMediaPacketizerCanPackVolume

The packetizer can pack the sound volume value. 

Available in Mac OS X v10.0 and later.
kMediaPacketizerCanPackBalance

The packetizer can pack the sound balance value. 

Available in Mac OS X v10.0 and later.
kMediaPacketizerCanPackGraphicsMode

The packetizer can pack the graphics transfer mode value. 

Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

enum {
   identityMatrixType            = 0x00,
   /* result if matrix is identity */
   translateMatrixType           = 0x01,
   /* result if matrix translates */
   scaleMatrixType               = 0x02,
   /* result if matrix scales */
   scaleTranslateMatrixType      = 0x03,
   /* result if matrix scales and translates */
   linearMatrixType              = 0x04,
   /* result if matrix is general 2 x 2 */
   linearTranslateMatrixType     = 0x05,
   /* result if matrix is general 2 x 2 and translates */
   perspectiveMatrixType         = 0x06  /* result if matrix is general 3 x 3 */
};
enum {
   kMediaPacketizerCanPackEditRate = 1 << 0,
   kMediaPacketizerCanPackLayer  = 1 << 1,
   kMediaPacketizerCanPackVolume = 1 << 2,
   kMediaPacketizerCanPackBalance = 1 << 3,
   kMediaPacketizerCanPackGraphicsMode = 1 << 4,
   kMediaPacketizerCanPackEmptyEdit = 1 << 5
};

/*QTSStreamBuffer

Defines a stream buffer for QuickTime streaming.

struct QTSStreamBuffer {
   struct QTSStreamBuffer *   reserved1;
      struct QTSStreamBuffer *   reserved2;
         struct QTSStreamBuffer *   next;
            unsigned char *            rptr;
            unsigned char *            wptr;
            long                       reserved3;
            UInt32                     metadata[4];
            SInt32                     flags;
         };
Fields
reserved1
Discussion

Reserved; do not use.
reserved2
Discussion

Reserved; do not use.
next
Discussion

A pointer to the next message block in a message. 
rptr
Discussion

A pointer to the first byte in the data buffer that contains real data. 
wptr
Discussion

A pointer to the byte after the last byte in the data buffer that contains real data. 
reserved3
Discussion

Reserved; do not use.
metadata
Discussion

Usage defined by message sender. 
flags
Discussion

Reserved; do not use.
Related Functions
QTSCopyMessage
QTSDupMessage
QTSFlattenMessage
QTSFreeMessage
QTSMessageLength
RTPRssmGetTimeScaleFromPacket
RTPRssmHandleNewPacket 
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
struct QTSStreamBuffer {
   struct QTSStreamBuffer *   reserved1;
      struct QTSStreamBuffer *   reserved2;
         struct QTSStreamBuffer *   next;
            unsigned char *            rptr;
            unsigned char *            wptr;
            long                       reserved3;
            UInt32                     metadata[4];
            SInt32                     flags;
         };
typedef struct QTSStreamBuffer          QTSStreamBuffer;

#ifdef __cplusplus
}
#endif
#endif