#ifndef SCNETWORKCONNECTION_H
#define SCNETWORKCONNECTION_H

#include <AvailabilityMacros.h>
#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <CoreFoundation/CoreFoundation.h>
#include <SystemConfiguration/SystemConfiguration.h>

#include <APPLE/SystemConfiguration/SCNetworkConnection.h>

/*SCNetworkConnectionPPPStatus

enum { 
    kSCNetworkConnectionPPPDisconnected = 0, 
    kSCNetworkConnectionPPPInitializing = 1, 
    kSCNetworkConnectionPPPConnectingLink = 2, 
    kSCNetworkConnectionPPPDialOnTraffic = 3, 
    kSCNetworkConnectionPPPNegotiatingLink = 4, 
    kSCNetworkConnectionPPPAuthenticating = 5, 
    kSCNetworkConnectionPPPWaitingForCallBack = 6, 
    kSCNetworkConnectionPPPNegotiatingNetwork = 7, 
    kSCNetworkConnectionPPPConnected = 8, 
    kSCNetworkConnectionPPPTerminating = 9, 
    kSCNetworkConnectionPPPDisconnectingLink = 10, 
    kSCNetworkConnectionPPPHoldingLinkOff = 11, 
    kSCNetworkConnectionPPPSuspended = 12, 
    kSCNetworkConnectionPPPWaitingForRedial = 13 
};  
Constants
kSCNetworkConnectionPPPDisconnected
PPP is disconnected.
kSCNetworkConnectionPPPInitializing
PPP is initializing.
kSCNetworkConnectionPPPConnectingLink
PPP is connecting the lower connection layer (for example, the modem is dialing out).
kSCNetworkConnectionPPPDialOnTraffic
PPP is waiting for networking traffic to automatically establish the connection.
kSCNetworkConnectionPPPNegotiatingLink
The PPP lower layer is connected and PPP is negotiating the link layer (LCP protocol).
kSCNetworkConnectionPPPAuthenticating
PPP is authenticating to the server (PAP, CHAP, MS-CHAP or EAP protocols).
kSCNetworkConnectionPPPWaitingForCallBack
PPP is waiting for the server to call back.
kSCNetworkConnectionPPPNegotiatingNetwork
PPP is now authenticated and negotiating the networking layer (IPCP or IPv6CP protocols)
kSCNetworkConnectionPPPConnected
PPP is now fully connected for at least one networking layer. Additional networking protocol might still be negotiating.
kSCNetworkConnectionPPPTerminating
PPP networking and link protocols are terminating.
kSCNetworkConnectionPPPDisconnectingLink
PPP is disconnecting the lower level (for example, the modem is hanging up).
kSCNetworkConnectionPPPHoldingLinkOff
PPP is disconnected and maintaining the link temporarily off.
kSCNetworkConnectionPPPSuspended
PPP is suspended as a result of the suspend command (for example, when a V.92 Modem is On Hold).
kSCNetworkConnectionPPPWaitingForRedial
PPP has found a busy server and is waiting for redial.
Discussion 

PPP-specific status of the network connection. This status is returned as part of the extended information for a PPP service. Note: additional status might be returned in the future. Your application should be prepared to receive an unknown value. 
Availability
Introduced in Mac OS X v10.3.*/
enum { 
    kSCNetworkConnectionPPPDisconnected = 0, 
    kSCNetworkConnectionPPPInitializing = 1, 
    kSCNetworkConnectionPPPConnectingLink = 2, 
    kSCNetworkConnectionPPPDialOnTraffic = 3, 
    kSCNetworkConnectionPPPNegotiatingLink = 4, 
    kSCNetworkConnectionPPPAuthenticating = 5, 
    kSCNetworkConnectionPPPWaitingForCallBack = 6, 
    kSCNetworkConnectionPPPNegotiatingNetwork = 7, 
    kSCNetworkConnectionPPPConnected = 8, 
    kSCNetworkConnectionPPPTerminating = 9, 
    kSCNetworkConnectionPPPDisconnectingLink = 10, 
    kSCNetworkConnectionPPPHoldingLinkOff = 11, 
    kSCNetworkConnectionPPPSuspended = 12, 
    kSCNetworkConnectionPPPWaitingForRedial = 13 
};  


/*SCNetworkConnectionRef

typedef const struct __SCNetworkConnection * SCNetworkConnectionRef;  
Discussion 

This is the handle to manage a connection-oriented service. 
Availability
Introduced in Mac OS X v10.3.*/
typedef const struct __SCNetworkConnection * SCNetworkConnectionRef;  

/*SCNetworkConnectionStatus

enum { 
    kSCNetworkConnectionInvalid = -1, 
    kSCNetworkConnectionDisconnected = 0, 
    kSCNetworkConnectionConnecting = 1, 
    kSCNetworkConnectionConnected = 2, 
    kSCNetworkConnectionDisconnecting = 3 
};  
Constants
kSCNetworkConnectionInvalid
The network connection refers to an invalid service.
kSCNetworkConnectionDisconnected
The network connection is disconnected.
kSCNetworkConnectionConnecting
The network connection is connecting.
kSCNetworkConnectionConnected
The network connection is connected.
kSCNetworkConnectionDisconnecting
The network connection is disconnecting.
Discussion 

Status of the network connection. This status is intended to be generic and high level. An extended status, specific to the type of network connection is also available for applications that need additonal information. 
Availability
Introduced in Mac OS X v10.3.*/
enum { 
    kSCNetworkConnectionInvalid = -1, 
    kSCNetworkConnectionDisconnected = 0, 
    kSCNetworkConnectionConnecting = 1, 
    kSCNetworkConnectionConnected = 2, 
    kSCNetworkConnectionDisconnecting = 3 
};  

/*SCNetworkConnectionContext

typedef struct { 
    CFIndex version; 
    void *info; 
    const void *(*retain)(
        const void *info); 
    void (*release)(
        const void *info); 
    CFStringRef (*copyDescription)(
        const void *info); 
} SCNetworkConnectionContext;  
Fields
version
The version number of the structure type being passed in as a parameter to the SCNetworkConnectionCreateWithServiceID function. This structure is version 0.
info
A C pointer to a user-specified block of data.
retain
The callback used to add a retain for the info field. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. The value may be NULL.
release
The calllback used to remove a retain previously added for the info field. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. The value may be NULL.
copyDescription
The callback used to provide a description of the info field.
Discussion 

Structure containing user-specified data and callbacks for a SCNetworkConnection. 
Availability
Introduced in Mac OS X v10.3.*/
typedef struct { 
    CFIndex version; 
    void *info; 
    const void *(*retain)(
        const void *info); 
    void (*release)(
        const void *info); 
    CFStringRef (*copyDescription)(
        const void *info); 
} SCNetworkConnectionContext;  

/*SCNetworkConnectionCallBack

typedef void (*SCNetworkConnectionCallBack) ( 
    SCNetworkConnectionRef connection, 
    SCNetworkConnectionStatus status, 
    void *info );  
Parameters
status
The connection status.
connection
The connection reference.
info
Application-specific information.
Discussion 

Type of the callback function used when a status event is delivered. 
Availability
Introduced in Mac OS X v10.3.*/
typedef void (*SCNetworkConnectionCallBack) ( 
    SCNetworkConnectionRef connection, 
    SCNetworkConnectionStatus status, 
    void *info );  



//function

/*SCNetworkConnectionCopyUserPreferences

Boolean SCNetworkConnectionCopyUserPreferences ( 
    CFDictionaryRef selectionOptions, 
    CFStringRef *serviceID, 
    CFDictionaryRef *userOptions );  
Parameters
selectionOptions
Currently unimplemented. Pass NULL for this version.
serviceID
Reference to the default serviceID for starting connections, this value will be returned by the function.
userOptions
Reference to default userOptions for starting connections, this will be returned by the function.
Return Value

Returns TRUE if there is a valid service to dial; FALSE if the function was unable to retrieve a service to dial. 
Discussion 

Provides the default service ID and a dictionary of user options for the connection. Applications can use the returned serviceID and userOptions values to open a connection on the fly. 
Availability
Introduced in Mac OS X v10.3.*/

Boolean SCNetworkConnectionCopyUserPreferences ( 
    CFDictionaryRef selectionOptions, 
    CFStringRef *serviceID, 
    CFDictionaryRef *userOptions );  

/*SCNetworkConnectionGetStatus

SCNetworkConnectionStatus SCNetworkConnectionGetStatus ( 
    SCNetworkConnectionRef connection );  
Parameters
connection
The SCNetworkConnection to obtain status from.
Return Value

Returns the status value. 
Discussion 

Returns the status of the SCNetworkConnection. A status is one of the following values: 
 
	kSCNetworkConnectionInvalid
	kSCNetworkConnectionDisconnected
	kSCNetworkConnectionConnecting
	kSCNetworkConnectionDisconnecting
	kSCNetworkConnectionConnected

Availability
Introduced in Mac OS X v10.3.*/
SCNetworkConnectionStatus SCNetworkConnectionGetStatus ( 
    SCNetworkConnectionRef connection );  

/*SCNetworkConnectionStart

Boolean SCNetworkConnectionStart ( 
    SCNetworkConnectionRef connection, 
    CFDictionaryRef userOptions, 
    Boolean linger );  
Parameters
connection
The SCNetworkConnection to start.
userOptions
The options dictionary to start the connection with. If userOptions is NULL, the default settings will be used. If userOptions are specified, they must be in the same format as network services stored in the system configuration preferences schema. The options will override the default settings defined for the service. 

For security reasons, not all options can be overridden; the appropriate merging of all settings will be done before the connection is established, and inappropriate options will be ignored.
linger
This parameter indicates whether or not the connection can stay around when the application no longer has interest in it. A typical application should pass FALSE, and the connection will be automatically stopped when the reference is released or if the application quits. If the application passes TRUE, the application can release the reference or exit and the connection will be maintained until a timeout event, until a specific stop request occurs, or until an error is encountered.
Return Value

Returns TRUE if the connection was correctly started (the actual connection is not established yet, and the connection status needs to be periodically checked); FALSE if the connection request was not started. The error must be retrieved from the SCError function. 
Discussion 

Starts the connection for the SCNetworkConnection. The connection process is asynchronous and the function will return immediately. The connection status can be obtained by polling or by callback. The connection is made with the default settings from the administrator. Some of the settings can be overridden for the duration of the connection. These are specified in an options dictionary. The options dictionary uses the same format as a network service defined in the system configuration preferences schema. 

Note: Starting and stopping of connections is implicitly arbitrated. Calling SCNetworkConnectionStart on a connection already started will indicate that the application has interest in the connection and it shouldn't be stopped by anyone else. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionStart ( 
    SCNetworkConnectionRef connection, 
    CFDictionaryRef userOptions, 
    Boolean linger );  

/*SCNetworkConnectionStop

Boolean SCNetworkConnectionStop ( 
    SCNetworkConnectionRef connection, 
    Boolean forceDisconnect );  
Parameters
connection
The SCNetworkConnection to stop.
Return Value

Returns TRUE if the disconnection request succeeded; FALSE if the disconnection request failed. The error must be retrieved from the SCError function. 
Discussion 

Stops the connection for the SCNetworkConnection. The disconnection process is asynchronous and the function will return immediately. The connection status can be obtained by polling or by callback. This function performs an arbitrated stop of the connection. If several applications have marked their interest in the connection, by calling SCNetworkConnectionStart, the call will succeed but the actual connection will be maintained until the last interested application calls SCNetworkConnectionStop. 

In certain cases, you might want to stop the connection anyway. In these cases, you set the forceDisconnect argument to TRUE. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionStop ( 
    SCNetworkConnectionRef connection, 
    Boolean forceDisconnect );  

/*SCNetworkConnectionCopyExtendedStatus

CFDictionaryRef SCNetworkConnectionCopyExtendedStatus ( 
    SCNetworkConnectionRef connection );  
Parameters
connection
The SCNetworkConnection to obtain status from.
Return Value

Returns the status dictionary. If NULL is returned, the error can be retrieved using the SCError function. 
Discussion 

Returns the extended status of the connection. An extended status dictionary contains specific dictionaries describing the status for each subcomponent of the service. 

For example, a status dictionary will contain the following sub-dictionaries, keys, and values: 
 
	IPv4  : Addresses      : the assigned IP address.
 
	PPP   : Status         : the PPP-specific status of type
				 SCNetworkConnectionPPPStatus.
 
		LastCause      : Available when the status is "Disconnected"
				 and contains the last error associated with
				 connecting or disconnecting.
 
		ConnectTime    : the time when the connection was
				 established.
 
	Modem : ConnectSpeed   : the speed of the modem connection
				 in bits/second.

Other dictionaries could be present for PPPoE, PPTP, and L2TP. 

The status dictionary may be extended in the future to contain additional information. 
Availability
Introduced in Mac OS X v10.3.*/
CFDictionaryRef SCNetworkConnectionCopyExtendedStatus ( 
    SCNetworkConnectionRef connection );  

/*SCNetworkConnectionCreateWithServiceID

SCNetworkConnectionRef SCNetworkConnectionCreateWithServiceID ( 
    CFAllocatorRef allocator, 
    CFStringRef serviceID, 
    SCNetworkConnectionCallBack callout, 
    SCNetworkConnectionContext *context );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for the connection structure. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
serviceID
A string that defines the service identifier of the connection. Service identifiers uniquely identify services in the system configuration database.
callout
The function to be called when the status of the connection changes. If this parameter is NULL, the application will not receive notifications of status change and will need to poll for updates.
context
The SCNetworkConnectionContext associated with the callout.
Return Value

Returns a reference to the new SCNetworkConnection. 
Discussion 

Creates a new connection reference to use for getting the status or for connecting or disconnecting the associated service. 
Availability
Introduced in Mac OS X v10.3.*/

SCNetworkConnectionRef SCNetworkConnectionCreateWithServiceID ( 
    CFAllocatorRef allocator, 
    CFStringRef serviceID, 
    SCNetworkConnectionCallBack callout, 
    SCNetworkConnectionContext *context );  

/*SCNetworkConnectionScheduleWithRunLoop

Boolean SCNetworkConnectionScheduleWithRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
connection
The SCNetworkConnection to schedule.
runLoop
The run loop to schedule with.
runLoopMode
The run loop mode.
Return Value

Returns TRUE if the connection is scheduled successfully; FALSE if the scheduling failed. The error can be retrieved using the SCError function. 
Discussion 

Schedules a connection with the run loop. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionScheduleWithRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  

/*SCNetworkConnectionUnscheduleFromRunLoop

Boolean SCNetworkConnectionUnscheduleFromRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
connection
The SCNetworkConnection to unschedule.
runLoop
The run loop to unschedule from.
runLoopMode
The run loop mode.
Return Value

Returns TRUE if the connection is unscheduled successfully; FALSE if the unscheduling failed. The error can be retrieved using the SCError function. 
Discussion 

Unschedules a connection from the run loop. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionUnscheduleFromRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  

#endif