#ifndef __WINE_WINDOWS_H
#define __WINE_WINDOWS_H

#ifdef __WINESRC__
#error Wine should not include windows.h internally
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 800) && !defined(__cplusplus)
/* TYPE_ALIGNMENT generates this - move it outside the warning push/pop scope. */
# pragma warning(disable:4116)
#endif

#ifndef _INC_WINDOWS
#define _INC_WINDOWS

#if defined(RC_INVOKED) && !defined(NOWINRES)
#include <Wine/winresrc.h>
#else /* RC_INVOKED && !NOWINRES */

/* All the basic includes */
#include <Wine/excpt.h>
#include <stdarg.h>
#include <Wine/windef.h>
#include <Wine/winbase.h>
#include <Wine/wingdi.h>
#include <Wine/winuser.h>
#include <Wine/winnls.h>
#include <Wine/wincon.h>
#include <Wine/winver.h>
#include <Wine/winreg.h>
#include <Wine/winnetwk.h>

/* Not so essential ones */
#ifndef WIN32_LEAN_AND_MEAN

#include <Wine/cderr.h>
#include <Wine/dde.h>
#include <Wine/ddeml.h>
#include <Wine/dlgs.h>
#include <Wine/lzexpand.h>
#include <Wine/mmsystem.h>
#include <Wine/nb30.h>
#include <Wine/rpc.h>
#include <Wine/shellapi.h>
/* #include <winperf.h> */

#ifndef WINE_NOWINSOCK
#include <Wine/winsock2.h>
#endif /* WINE_NOWINSOCK */

#ifndef NOCRYPT
#include <Wine/wincrypt.h>
/* #include <winefs.h> */
/* #include <winscard.h> */
#endif /* !NOCRYPT */

#ifndef NOGDI
#include <Wine/winspool.h>
#ifdef INC_OLE1
/* #include <ole.h> */
#else
#include <Wine/ole2.h>
#endif
#include <Wine/commdlg.h>
#endif /* !NOGDI */

#endif /* !WIN32_LEAN_AND_MEAN */

/* #include <stralign.h> */

#ifdef INC_OLE2
#include <Wine/ole2.h>
#endif /* INC_OLE2 */

#ifndef NOSERVICE
#include <Wine/winsvc.h>
#endif /* !NOSERVICE */

#ifndef NOMCX
#include <Wine/mcx.h>
#endif /* !NOMCX */

#ifndef NOIMM
#include <Wine/imm.h>
#endif /* !NOIMM */

#endif  /* RC_INVOKED && !NOWINRES */
#endif /* _INC_WINDOWS */
#endif  /* __WINE_WINDOWS_H */
