#include <CarbonCore/CarbonCore.h>

//work

/*NewAliasMinimalFromFullPath

Creates an alias record that contains only the full pathname of the target. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.)

Not recommended

OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
);
Parameters
fullPathLength

The number of characters in the full pathname of the target.
fullPath

A pointer to a buffer that contains the full pathname of the target. The full pathname starts with the name of the volume, includes all of the directory names in the path to the target, and ends with the target name. (For a description of pathnames, see the documentation for the File Manager.)
zoneName

The AppleTalk zone name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
serverName

The AppleTalk server name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimalFromFullPath function creates an alias record that identifies the target by full pathname. You can call NewAliasMinimalFromFullPath to create an alias record for a file that doesn’t exist or that resides on an unmounted volume.

The NewAliasMinimalFromFullPath function uses the standard alias record data structure, but it fills in only the information provided in the input parameters. You can therefore use NewAliasMinimalFromFullPath to create alias records for targets on unmounted volumes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.
Declared In
Aliases.h*/
OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
){};

/*ResolveAlias

Identifies the single most likely target of an alias record. (Deprecated in Mac OS X v10.4. Use FSResolveAlias instead.)

Not recommended

OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you pass a fromFile parameter of NULL, ResolveAlias performs only an absolute search. If you pass a pointer to a valid FSSpec structure in the fromFile parameter, ResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the MatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to the target of the alias record. This parameter must be a valid FSSpec structure.
wasChanged

A pointer to a Boolean value indicating whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, ResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (ResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The ResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, ResolveAlias returns (in the target parameter) the FSSpec structure for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, ResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, ResolveAlias asks the user to insert the volume. The ResolveAlias function exits after it finds one acceptable target.

After it identifies a target, ResolveAlias compares some key information about the target with the information in the alias record. (The description of the MatchAlias function lists the key information.) If the information differs, ResolveAlias updates the record to match the target.

When it finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAlias returns a result code of fnfErr and fills in the target parameter with a complete FSSpec structure describing the target (that is, the volume reference number, parent directory ID, and filename or folder name). The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, pass the FSSpec structure to the File Manager function FSpCreate to create a replacement for a missing file.

The ResolveAlias function displays the standard dialog boxes when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialog boxes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAlias instead.
Declared In
Aliases.h*/
OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
){};

/*FSResolveAlias

Returns an FSRef to the single most likely target of an alias record.

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to an FSRef specifying the starting point for a relative search. If you pass NULL in this parameter, FSResolveAlias performs only an absolute search. If you pass a pointer to a valid FSRef in the fromFile parameter, FSResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the FSMatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to an FSRef. On successful return, this FSRef describes the target of the alias record. This parameter must point to a valid FSRef structure.
wasChanged

A pointer to a Boolean value indicating, on return, whether the alias record in the alias parameter was updated because it contained some outdated information about the target. If it updates the alias record, FSResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (FSResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. When it finds the specified volume and parent directory but fails to find the target file or directory in that location, FSResolveAlias returns fnfErr. Note that the FSRef in the alias parameter is not valid in this case.
Discussion

The FSResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, FSResolveAlias returns (in the target parameter) the FSRef for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, FSResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, FSResolveAlias asks the user to insert the volume. The FSResolveAlias function exits after it finds one acceptable target.

After it identifies a target, FSResolveAlias compares some key information about the target with the information in the alias record. If the information differs, FSResolveAlias updates the record to match the target.

The FSResolveAlias function displays the standard dialogs when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialogs. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSResolveAlias (
   const FSRef * fromFile,
   AliasHandle alias,
   FSRef * target,
   Boolean * wasChanged
){};

/*FSNewAlias

Creates a new alias record, given a file system reference (FSRef) to the target file or directory.

OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
);
Parameters
fromFile

A pointer to a file system reference specifying the starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the structure, pass a fromFile value of NULL. If you want FSNewAlias to record relative path information, pass a pointer to a valid FSRef in this parameter. The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
target

A pointer to an FSRef for the target of the alias record.
inAlias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets inAlias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The FSNewAlias function creates an alias record that describes the specified target. It allocates the storage, fills in the record, and puts a record handle to that storage in the inAlias parameter. FSNewAlias records the full pathname of the target and a collection of other information relevant to locating the target, verifying the target, and mounting the target’s volume, if necessary. You can have FSNewAlias store relative path information as well by supplying a starting point for a relative path. 
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSNewAlias (
   const FSRef * fromFile,
   const FSRef * target,
   AliasHandle * inAlias
){};
/*FSIsAliasFile

Determines whether a file system object is an alias file, a data file, or a folder.

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
);
Parameters
fileRef

A pointer to a file system object. 
aliasFileFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is an alias file. A value of FALSE indicates that the object is not an alias file. 
folderFlag

A pointer to a Boolean variable. On return, a value of TRUE indicates that the object specified in the fileRef parameter is a folder. A value of FALSE indicates that the object is a file. 
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

Table 1 summarizes the information that this function provides about the object specified in the fileRef parameter: 
Table 1  Information about a file system object
Alias flag	
Folder flag	
Object kind 

T	
F	
Alias file

F	
F	
Data file

F	
T	
Folder


Note that if fileRef is an alias file, this function does not provide any information about the object to which the alias refers. To find out whether this object is a file or a folder, you can use FSResolveAliasFile.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/

OSErr FSIsAliasFile (
   const FSRef * fileRef,
   Boolean * aliasFileFlag,
   Boolean * folderFlag
){};

/*FSResolveAliasFileWithMountFlags

Resolves an alias contained in an alias file.

OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
);
Parameters
theRef

A pointer to a file system reference (FSRef) for the alias file you plan to open. If the function completes successfully, this FSRef describes the file or the directory referred to by the alias file.
resolveAliasChains

A Boolean value. Set this parameter to TRUE if you want FSResolveAliasFileWithMountFlags to resolve all aliases in a chain (for example, an alias file that refers to an alias file and so on), stopping only when it reaches the target file. Set this parameter to FALSE if you want to resolve only one alias file, even if the target is another alias file. 
targetIsFolder

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to a directory or a volume; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
wasAliased

A pointer to a Boolean value. The FSResolveAliasFileWithMountFlags function returns TRUE in this parameter if the FSRef in the parameter theRef points to an alias; otherwise, FSResolveAliasFileWithMountFlags returns FALSE in this parameter. 
mountFlags

Options controlling how the alias file is resolved. See “Volume Mount Options” for a description of the values you can use here. Set this parameter to kResolveAliasFileNoUI to prevent any user interaction, including disk switch alerts, while the alias is being resolved.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The function FSResolveAliasFileWithMountFlags is identical to FSResolveAliasFile with the exception that it provides the mountFlags parameter, allowing callers additional control over how the alias file is resolved.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/
OSErr FSResolveAliasFileWithMountFlags (
   FSRef * theRef,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased,
   unsigned long mountFlags
){};


/*NewAliasMinimal

Creates a short alias record quickly. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal instead.)

Not recommended

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
);
Parameters
target

A pointer to an FSSpec structure for the target of the alias record.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimal function creates an alias record that contains only the minimum information necessary to describe the target: the target name, the parent directory ID, the volume name and creation date, and the volume mounting information. The NewAliasMinimal function uses the standard alias record data structure, but it fills in only parts of the record.

The ResolveAlias function never updates a minimal alias record. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal instead.
Declared In
Aliases.h*/

OSErr NewAliasMinimal (
   const FSSpec * target,
   AliasHandle * alias
){};

/*FSCopyAliasInfo

Returns information from an alias handle.

OSStatus FSCopyAliasInfo (
   AliasHandle inAlias,
   HFSUniStr255 * targetName,
   HFSUniStr255 * volumeName,
   CFStringRef * pathString,
   FSAliasInfoBitmap * whichInfo,
   FSAliasInfo * info
);
Parameters
inAlias

A handle to the alias record to get information from.
targetName

A pointer to a string that, on return, contains the name of the target item. Pass NULL if you do not want this information returned.
volumeName

A pointer to a string that, on return, contains the name of the volume the target resides on. Pass NULL if you do not want this information returned.
pathString

A pointer a CFString that, on return, contains the POSIX path to the target. Pass NULL if you do not want this information returned.
whichInfo

A pointer to a variable of type FSAliasInfoBitmap. On return, this field indicates which fields in the alias information block, specified in the info parameter, contain valid data. See “Alias Information Masks” for a description of the values that may be returned here. This parameter may be NULL.
info

A pointer to a structure of type FSAliasInfo. On return, this structure contains information about the alias. Pass NULL if you do not want this information returned.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

This function returns the requested information from the alias handle passed in the inAlias parameter. The information is gathered only from the alias record, so it may not match what is on disk. No disk i/o is performed.

The FSCopyAliasInfo function adds support for unicode filenames and filenames longer than 32 bytes. It replaces the GetAliasInfo function. 
Availability
Not available in CarbonLib.
Available in Mac OS X version 10.2 and later.
Declared In
Aliases.h*/

OSStatus FSCopyAliasInfo (
   AliasHandle inAlias,
   HFSUniStr255 * targetName,
   HFSUniStr255 * volumeName,
   CFStringRef * pathString,
   FSAliasInfoBitmap * whichInfo,
   FSAliasInfo * info
){};

/*GetAliasInfo

Gets information from an alias record without actually resolving the record. (Deprecated in Mac OS X v10.3. Use FSCopyAliasInfo instead.)

Not Recommended

OSErr GetAliasInfo (
   AliasHandle alias,
   AliasInfoType index,
   Str63 theString
);
Parameters
alias

A handle to the alias record to be read.
index

The kind of information to be retrieved. If the value of index is a positive integer, GetAliasInfo retrieves the parent directory that has the same hierarchical level above the target as the index parameter (for example, an index value of 2 returns the name of the parent directory of the target’s parent directory). You can therefore assemble the names of the target and all of its parent directories by making repeated calls to GetAliasInfo with incrementing index values, starting with a value of 0. When the value of index is greater than the number of levels between the target and the root, GetAliasInfo returns an empty string. You can also set the index parameter to one of the values described in “Information Type Constants”.
theString

A string that, on return, holds the requested information.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The GetAliasInfo function returns the information stored in the alias record, which might not be current. To ensure that the information is current, you can resolve and update the alias record before calling GetAliasInfo.

The GetAliasInfo function cannot provide all kinds of information about a minimal alias. 
Special Considerations

Use the FSCopyAliasInfo function instead of GetAliasInfo. GetAliasInfo does not reliably return information for aliases to items on POSIX file systems. In addition, GetAliasInfo does not support unicode names or names longer than 32 bytes. If the name of the alias target is longer than 32 bytes, the name is truncated and the file ID and extension (if any) are appended before the name is returned by GetAliasInfo.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
Aliases.h*/

OSErr GetAliasInfo (
   AliasHandle alias,
   AliasInfoType index,
   Str63 theString
){};

/*MatchAlias

Identifies a list of possible matches for an alias and passes the list through an optional selection filter. The filter can return more than one possible match. (Deprecated in Mac OS X v10.4. Use FSMatchAlias instead.)

Not recommended

OSErr MatchAlias (
   const FSSpec * fromFile,
   unsigned long rulesMask,
   AliasHandle alias,
   short * aliasCount,
   FSSpecArrayPtr aliasList,
   Boolean * needsUpdate,
   AliasFilterUPP aliasFilter,
   void * yourDataPtr
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you do not want MatchAlias to perform a relative search, set fromFile to NULL. If you want MatchAlias to perform a relative search, pass a pointer to a file system specification structure that describes the starting point for the search.
rulesMask

A set of rules to guide the resolution. Pass the sum of all of the rules you want to invoke. For a description of the values you can use in this parameter, see “Matching Constants”.
alias

A handle to the alias record to be resolved.
aliasCount

On input, a pointer to the maximum number of possible matches to return. On output, the actual number of matches returned.
aliasList

A pointer to the array that holds the results of the search, a list of possible candidates.
needsUpdate

A pointer to a Boolean flag that indicates whether the alias record to be resolved needs to be updated.
aliasFilter

An application-defined filter function. The Alias Manager executes this function each time it identifies a possible match and after the search has continued for three seconds without a match. Your filter function returns a Boolean value that determines whether the possible match is discarded (true) or added to the list of possible targets (false). It can also terminate the search by setting the variable parameter quitFlag. See AliasFilterProcPtr for a description of the filter function.
yourDataPtr

A pointer to data to be passed to the filter function. The yourDataPtr parameter can point to any data your application might need in the filter function.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

If MatchAlias finds the parent directory on the correct volume but does not find the target, it sets the aliasCount parameter to 1, puts the file system specification structure for the target in the results list, and returns fnfErr. The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, use the FSSpec structure and the File Manager function FSpCreate to create a replacement for a missing file.

After it identifies a target, MatchAlias compares some key information about the target with the same information in the record. If the information does not match, MatchAlias sets the needsUpdate flag to true. The key information is
the name of the target 
the directory ID of the target’s parent 
the file ID or directory ID of the target 
the name and creation date of the volume on which the target resides 

The MatchAlias function also sets the needsUpdate flag to true if it identifies a list of possible matches rather than a single match or if kARMsearchRelFirst is set in the rulesMask parameter but the target is identified through either an absolute search or an exhaustive search. Otherwise, the MatchAlias function sets the needsUpdate flag to false. MatchAlias always sets the needsUpdate flag to false when resolving an alias created by NewAliasMinimal. If you want to update the alias record to reflect the final results of the resolution, call UpdateAlias. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSMatchAlias instead.
Declared In
Aliases.h*/

OSErr MatchAlias (
   const FSSpec * fromFile,
   unsigned long rulesMask,
   AliasHandle alias,
   short * aliasCount,
   FSSpecArrayPtr aliasList,
   Boolean * needsUpdate,
   AliasFilterUPP aliasFilter,
   void * yourDataPtr
){};

/*UpdateAlias

Updates an alias record. (Deprecated in Mac OS X v10.4. Use FSUpdateAlias instead.)

Not recommended

OSErr UpdateAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle alias,
   Boolean * wasChanged
);
Parameters
fromFile

The starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the record, pass a fromFile value of NULL. If you want UpdateAlias to record relative path information, pass a pointer to a valid FSSpec structure in this parameter.
target

The target of the alias record. This parameter must be a pointer to a valid FSSpec structure.
alias

A handle to the alias record to be updated.
wasChanged

A pointer to a Boolean value indicating whether the newly constructed alias record is exactly the same as the old one. If the new record is the same as the old one, UpdateAlias sets the wasChanged parameter to false. Otherwise, it sets it to true. Check this parameter to determine whether you need to save an updated record.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The UpdateAlias function rebuilds the entire alias record and fills it in as the NewAlias function would.

The UpdateAlias function always creates a complete alias record. When you use UpdateAlias to update a minimal alias record, you convert the minimal record to a complete record.
Special Considerations

The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSUpdateAlias instead.
Declared In
Aliases.h*/
OSErr UpdateAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle alias,
   Boolean * wasChanged
){};

/*NewAlias

Creates a complete alias record. (Deprecated in Mac OS X v10.4. Use FSNewAlias instead.)

Not recommended

OSErr NewAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle * alias
);
Parameters
fromFile

The starting point for a relative path, to be used later in a relative search. If you do not need relative path information in the structure, pass a fromFile value of NULL. If you want NewAlias to record relative path information, pass a pointer to a valid FSSpec structure in this parameter. The two files or directories, specified in the fromFile and target parameters, must reside on the same volume.
target

A pointer to an FSSpec structure for the target of the alias record.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAlias function creates an alias record that describes the specified target. It allocates the storage, fills in the record, and puts a record handle to that storage in the alias parameter. NewAlias always records the name and file or directory ID of the target, its creation date, the parent directory name and ID, and the volume name and creation date. It also records the full pathname of the target and a collection of other information relevant to locating the target, verifying the target, and mounting the target’s volume, if necessary. You can have NewAlias store relative path information as well by supplying a starting point for a relative path. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAlias instead.
Declared In
Aliases.h*/

OSErr NewAlias (
   const FSSpec * fromFile,
   const FSSpec * target,
   AliasHandle * alias
){};

/*ResolveAliasFile

Resolves an alias contained in an alias file. (Deprecated in Mac OS X v10.4. Use FSResolveAliasFile instead.)

Not recommended

OSErr ResolveAliasFile (
   FSSpec * theSpec,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased
);
Parameters
theSpec

A pointer to a file system specification (FSSpec) structure for the alias file you plan to open. If the function completes successfully, this FSSpec refers to the file or the directory that was referred to by the alias file.
resolveAliasChains

A Boolean value. Set this parameter to TRUE if you want ResolveAliasFile to resolve all aliases in a chain (for example, an alias file that refers to an alias file and so on), stopping only when it reaches the target file. Set this parameter to FALSE if you want to resolve only one alias file, even if the target is another alias file. 
targetIsFolder

A return parameter only. The ResolveAliasFile function returns TRUE in this parameter if the file specification structure in the parameter theSpec points to a directory or a volume; otherwise, ResolveAliasFile returns FALSE in this parameter. 
wasAliased

A return parameter only. The ResolveAliasFile function returns TRUE in this parameter if the file specification structure in the parameter theSpec points to an alias; otherwise, ResolveAliasFile returns FALSE in this parameter. 
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

If your application bypasses the Finder when manipulating documents, it should check for and resolve aliases itself by using the ResolveAliasFile function.

The ResolveAliasFile function first checks the catalog file for the file or directory specified in the parameter theSpec to determine whether it is an alias and whether it is a file or a directory. If the object is not an alias, ResolveAliasFile leaves theSpec unchanged, sets the targetIsFolder parameter to TRUE for a directory or volume and FALSE for a file, sets wasAliased to FALSE, and returns noErr. If the object is an alias, ResolveAliasFile resolves it, places the target in the parameter theSpec, and sets the wasAliased flag to TRUE.

When ResolveAliasFile finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAliasFile returns a result code of fnfErr and fills in the parameter theSpec with a complete file system specification structure describing the target (that is, its volume reference number, parent directory ID, and filename or folder name). The file system specification structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, use the file system specification structure to create a replacement for a missing file with the File Manager function FSpCreate.

If ResolveAliasFile receives an error code while resolving an alias, it leaves the input parameters as they are and exits, returning an error code. ResolveAliasFile can return any Resource Manager or File Manager errors.
Special Considerations

Before calling the ResolveAliasFile function, you should make sure that it is available by using the Gestalt function with the gestaltAliasMgrAttr selector. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAliasFile instead.
Declared In
Aliases.h*/

OSErr ResolveAliasFile (
   FSSpec * theSpec,
   Boolean resolveAliasChains,
   Boolean * targetIsFolder,
   Boolean * wasAliased
){};

/*FSResolveAliasWithMountFlags

Returns an FSRef to the target of an alias.

OSErr FSResolveAliasWithMountFlags (
   const FSRef * fromFile,
   AliasHandle inAlias,
   FSRef * target,
   Boolean * wasChanged,
   unsigned long mountFlags
);
Parameters
fromFile

A pointer to an FSRef specifying the starting point for a relative search. If you pass NULL in this parameter, FSResolveAliasWithMountFlags performs only an absolute search. If you pass a pointer to a valid FSRef in the fromFile parameter, FSResolveAliasWithMountFlags performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the FSMatchAlias function.
inAlias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to an FSRef structure. On successful return, this FSRef refers to the target of the alias record. This parameter must point to a valid FSRef structure.
wasChanged

A pointer to a Boolean value indicating, on return, whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, FSResolveAliasWithMountFlags sets the wasChanged parameter to true. Otherwise, it sets it to false. (FSResolveAliasWithMountFlags never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
mountFlags

Options controlling how the alias is resolved. See “Volume Mount Options” for a description of the values you can use here. Set this parameter to kResolveAliasFileNoUI to prevent any user interaction while the alias is being resolved.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The function FSResolveAliasWithMountFlags is identical to FSResolveAlias with the exception that it provides the mountFlags parameter, allowing callers additional control over how the alias is resolved.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Aliases.h*/
OSErr FSResolveAliasWithMountFlags (
   const FSRef * fromFile,
   AliasHandle inAlias,
   FSRef * target,
   Boolean * wasChanged,
   unsigned long mountFlags
){};

