#import <CoreData/NSPersistentStoreCoordinator.h>
//work

@implementation  NSPersistentStoreCoordinator 
/*initWithManagedObjectModel:

Initializes the receiver with a managed object model.

- (id)initWithManagedObjectModel:(NSManagedObjectModel *)model
Parameters
model

A managed object model.
Return Value

The receiver, initialized with model.
Availability
Available in Mac OS X v10.4 and later.*/
- (id)initWithManagedObjectModel:(NSManagedObjectModel *)model{}

/*addPersistentStoreWithType:configuration:URL:options:error:

Adds a new persistent store of a specified type at a specified location, and returns a reference to the new store.

- (id)addPersistentStoreWithType:(NSString *)storeType configuration:(NSString *)configuration URL:(NSURL *)storeURL options:(NSDictionary *)options error:(NSError **)error
Parameters
storeType

A string constant (such as NSSQLiteStoreType) that specifies the store type—see "Store Types" for possible values. 
configuration

The name of a configuration in the receiver's managed object model that will be used by the new store. The configuration can be nil, in which case no other configurations are allowed.
storeURL

The file location of the persistent store.
options

A dictionary containing key-value pairs that specify whether the store should be read-only, and whether (for an XML store) the XML file should be validated against the DTD before it is read. For key definitions, see "Store Options". This value may be nil.
error

If a new store cannot be created, upon return contains an instance of NSError that describes the problem
Return Value

An identifier for the newly-created store or, if an error occurs, nil.
Availability
Available in Mac OS X v10.4 and later.
See Also
– migratePersistentStore:toURL:options:withType:error:
– removePersistentStore:error:*/
- (id)addPersistentStoreWithType:(NSString *)storeType configuration:(NSString *)configuration URL:(NSURL *)storeURL options:(NSDictionary *)options error:(NSError **)error{}

/*managedObjectIDForURIRepresentation:

Returns an object ID for the specified URI representation of an object ID if a matching store is available, or nil if a matching store cannot be found.

- (NSManagedObjectID *)managedObjectIDForURIRepresentation:(NSURL *)URL
Parameters
URL

An URL object containing a URI that specify a managed object.
Return Value

An object ID for the object specified by URL.
Discussion

The URI representation contains a UUID of the store the ID is coming from, and the coordinator can match it against the stores added to it.
Availability
Available in Mac OS X v10.4 and later.
See Also
URIRepresentation (NSManagedObjectID)
objectWithID: (NSManagedObjectContext)*/
- (NSManagedObjectID *)managedObjectIDForURIRepresentation:(NSURL *)URL{}




/*setMetadata:forPersistentStore:

Sets the metadata stored in the persistent store during the next save operation executed on it to metadata.

- (void)setMetadata:(NSDictionary *)metadata forPersistentStore:(id)store
Parameters
metadata

A dictionary containing metadata for the store.
store

A persistent store identifier.
Discussion

The store type and UUID (NSStoreTypeKey and NSStoreUUIDKey) are always added automatically, however NSStoreUUIDKey is only added if it is not set manually as part of the dictionary argument.

Important:  Setting the metadata for a store does not change the information on disk until the store is actually saved.

Availability
Available in Mac OS X v10.4 and later.
See Also
+ metadataForPersistentStoreWithURL:error:
– metadataForPersistentStore:*/
- (void)setMetadata:(NSDictionary *)metadata forPersistentStore:(id)store{}


/*metadataForPersistentStore:

Returns a dictionary that contains the metadata currently stored or to-be-stored in the specified persistent store.

- (NSDictionary *)metadataForPersistentStore:(id)store
Parameters
store

A persistent store identifier.
Return Value

A dictionary that contains the metadata currently stored or to-be-stored in store.
Availability
Available in Mac OS X v10.4 and later.
See Also
+ metadataForPersistentStoreWithURL:error:
– setMetadata:forPersistentStore:*/
- (NSDictionary *)metadataForPersistentStore:(id)store{}


/*managedObjectModel

Returns the receiver’s managed object model.

- (NSManagedObjectModel *)managedObjectModel
Return Value

The receiver’s managed object model.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSManagedObjectModel *)managedObjectModel{}


/*persistentStoreForURL:

Returns the persistent store identifier for the specified URL. 

- (id)persistentStoreForURL:(NSURL *)URL
Parameters
URL

An URL object that specifies the location of a persistent store.
Return Value

An identifier for the persistent store at the location specified by URL.
Availability
Available in Mac OS X v10.4 and later.
See Also
– persistentStores
– URLForPersistentStore:*/
- (id)persistentStoreForURL:(NSURL *)URL{}



/*persistentStores

Returns an array of identifiers for the persistent stores associated with the receiver.

- (NSArray *)persistentStores
Return Value

An array of identifiers for the persistent stores associated with the receiver.
Availability
Available in Mac OS X v10.4 and later.
See Also
– persistentStoreForURL:
– URLForPersistentStore:*/
- (NSArray *)persistentStores{}



/*URLForPersistentStore:

Returns the URL for a persistent store identifier.

- (NSURL *)URLForPersistentStore:(id)store
Parameters
store

A persistent store identifier.
Return Value

The URL for the persistent store specified by store.
Availability
Available in Mac OS X v10.4 and later.
See Also
– persistentStoreForURL:
– persistentStores*/
- (NSURL *)URLForPersistentStore:(id)store;{}




/*Removes the specified persistent store.

- (BOOL)removePersistentStore:(id)store error:(NSError **)error
Parameters
store

A persistent store identifier.
error

If an error occurs, upon return contains an instance of NSError that describes the problem.
Return Value

YES if the store is removed; otherwise returns NO.
Availability
Available in Mac OS X v10.4 and later.
See Also
– addPersistentStoreWithType:configuration:URL:options:error:
– migratePersistentStore:toURL:options:withType:error:*/
- (BOOL)removePersistentStore:(id)store error:(NSError **)error{}


/*metadataForPersistentStoreWithURL:error:

Returns a dictionary that contains the metadata stored in the persistent store at the specified location.

+ (NSDictionary *)metadataForPersistentStoreWithURL:(NSURL *)url error:(NSError **)error
Parameters
url

An URL object that specifies the location of a persistent store.
error

If no store is found at url or if there is a problem accessing its contents, upon return contains an instance of NSError that describes the problem.
Return Value

A dictionary containing the metadata for the persistent store at url. If no store is found, or there is a problem accessing its contents, returns nil.

The keys guaranteed to be in this dictionary are NSStoreTypeKey and NSStoreUUIDKey.
Discussion

This method allows you to access the metadata stored in a persistent store without initializing a Core Data stack.
Availability
Available in Mac OS X v10.4 and later.
See Also
– metadataForPersistentStore:
– setMetadata:forPersistentStore:*/
+ (NSDictionary *)metadataForPersistentStoreWithURL:(NSURL *)url error:(NSError **)error{}


@end

/*Store Metadata

These constants are of type NSString and relate to metadata.

NSString * const NSStoreTypeKey;
NSString * const NSStoreUUIDKey;
Constants
NSStoreTypeKey

The key in the metadata dictionary to identify the store type.

Available in Mac OS X v10.4 and later.
NSStoreUUIDKey

The key in the metadata dictionary to identify the store UUID.

The store UUID is useful to identify stores through URI representations, but it is not guaranteed to be unique. The UUID generated for new stores is unique—users can freely copy files and thus the UUID stored inside—so if you track or reference stores explicitly you need to be aware of duplicate UUIDs and potentially override the UUID when a new store is added to the list of known stores in your application.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CoreData/NSPersistentStoreCoordinator.h*/
NSString * const NSStoreTypeKey;
NSString * const NSStoreUUIDKey;


/*Store Options

These constants are of type NSString and are keys for the options dictionary used in addPersistentStoreWithType:configuration:URL:options:error: and migratePersistentStore:toURL:options:withType:error:.

NSString * const NSReadOnlyPersistentStoreOption;
NSString * const NSValidateXMLStoreOption;
Constants
NSReadOnlyPersistentStoreOption

A flag that indicates whether a store is treated as read-only or not.

The default value is NO. 

Available in Mac OS X v10.4 and later.
NSValidateXMLStoreOption

A flag that indicates whether an XML file should be validated with the DTD while opening.

The default value is NO. 

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CoreData/NSPersistentStoreCoordinator.h*/
NSString * const NSReadOnlyPersistentStoreOption;
NSString * const NSValidateXMLStoreOption;

/*Store Types

These constants are of type NSString and describe the possible types of persistent store.

NSString * const NSSQLiteStoreType;
NSString * const NSXMLStoreType;
NSString * const NSBinaryStoreType;
NSString * const NSInMemoryStoreType;
Constants
NSSQLiteStoreType

Specifies the SQLite database store type.

Available in Mac OS X v10.4 and later.
NSXMLStoreType

Specifies the XML store type.

Available in Mac OS X v10.4 and later.
NSBinaryStoreType

Specifies the binary store type.

Available in Mac OS X v10.4 and later.
NSInMemoryStoreType

Specifies the in-memory store type.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CoreData/NSPersistentStoreCoordinator.h*/

NSString * const NSSQLiteStoreType;
NSString * const NSXMLStoreType;
NSString * const NSBinaryStoreType;
NSString * const NSInMemoryStoreType;

