#include <CoreFoundation/CoreFoundation.h>

//work


/*CFPropertyListCreateFromXMLData

Creates a property list using the specified XML or binary property list data.

CFPropertyListRef CFPropertyListCreateFromXMLData (
   CFAllocatorRef allocator,
   CFDataRef data,
   CFOptionFlags mutabilityOption,
   CFStringRef *errorString
);
Parameters
allocator

The allocator to use to allocate memory for the new property list. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
data

The raw bytes to convert into a property list. The bytes may be the content of an XML file or of a binary property list (see Property List Formats).
mutabilityOption

A constant that specifies the degree of mutability for the returned property list. See Property List Mutability Options for descriptions of possible values. 
errorString

On return, NULL if the conversion is successful, otherwise a string that describes the nature of the error. Error messages are not localized, but may be in the future, so they are not currently suitable for comparison.

Pass NULL if you do not wish to receive an error string. Ownership follows the Create Rule.
Return Value

A new property list if the conversion is successful, otherwise NULL. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFPropertyListRef CFPropertyListCreateFromXMLData (
   CFAllocatorRef allocator,
   CFDataRef data,
   CFOptionFlags mutabilityOption,
   CFStringRef *errorString
){};

/*CFPropertyListCreateXMLData

Creates an XML representation of the specified property list.

CFDataRef CFPropertyListCreateXMLData (
   CFAllocatorRef allocator,
   CFPropertyListRef propertyList
);
Parameters
allocator

The allocator to use to allocate memory for the new data object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
propertyList

The property list to convert. This may be any of the standard property list objects, for example a CFArray or a CFDictionary object. 
Return Value

A CFData object containing the XML data. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDataRef CFPropertyListCreateXMLData (
   CFAllocatorRef allocator,
   CFPropertyListRef propertyList
){};

/*CFPropertyListCreateDeepCopy

Recursively creates a copy of a given property list.

CFPropertyListRef CFPropertyListCreateDeepCopy (
   CFAllocatorRef allocator,
   CFPropertyListRef propertyList,
   CFOptionFlags mutabilityOption
);

Parameters
allocator

The allocator to use to allocate memory for the new property list. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
propertyList

The property list to copy. This may be any of the standard property list objects, for example a CFArray or a CFDictionary object. 
mutabilityOption

A constant that specifies the degree of mutability of the returned property list. See Property List Mutability Options for descriptions of possible values. 
Return Value

A new property list that is a copy of propertyList. Ownership follows the Create Rule.
Discussion

Recursively creates a copy of the given property list so nested arrays and dictionaries are copied as well as the top-most container.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.*/

CFPropertyListRef CFPropertyListCreateDeepCopy (
   CFAllocatorRef allocator,
   CFPropertyListRef propertyList,
   CFOptionFlags mutabilityOption
){};


