#include <CoreFoundation/CoreFoundation.h>
//work


/*CFSetCreateMutable

Creates an empty CFMutableSet object.

CFMutableSetRef CFSetCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFSetCallBacks *callBacks
);
Parameters
allocator

The allocator to use to allocate memory for the new set and its storage for values. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
capacity

The maximum number of values that can be contained by new set. The set starts empty and can grow to this number of values (and it can have less). If this parameter is 0, the set’s maximum capacity is not limited. The value must not be negative.
callBacks

A pointer to a CFSetCallBacks structure initialized with the callbacks to use to retain, release, describe, and compare values in the set. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in or can be reused for multiple collection creations. This parameter may be NULL, which is treated as if a valid structure of version 0 with all fields NULL had been passed in.

If any of the fields are not valid pointers to functions of the correct type, or this parameter is not a valid pointer to a CFSetCallBacks structure, the behavior is undefined. If any value put into the collection is not one understood by one of the callback functions, the behavior when that callback function is used is undefined.

If the collection contains CFType objects only, then pass kCFTypeSetCallBacks as this parameter to use the default callback functions. 
Return Value

A new mutable set, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFMutableSetRef CFSetCreateMutable (
   CFAllocatorRef allocator,
   CFIndex capacity,
   const CFSetCallBacks *callBacks
){};

/*CFSetGetCount

Returns the number of values currently in a set.

CFIndex CFSetGetCount (
   CFSetRef theSet
);
Parameters
theSet

The set to examine. 
Return Value

The number of values in theSet. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFIndex CFSetGetCount (
   CFSetRef theSet
){};


/*CFSetGetValues

Obtains all values in a set.

void CFSetGetValues (
   CFSetRef theSet,
   const void **values
);
Parameters
theSet

The set to examine. 
values

A C array of pointer-sized values to be filled with values from theSet. The value must be a valid C array of the appropriate type and of a size at least equal to the count of theSet). If the values are Core Foundation objects, ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetGetValues (
   CFSetRef theSet,
   const void **values
){};

/*CFSetContainsValue

Returns a Boolean that indicates whether a set contains a given value.

Boolean CFSetContainsValue (
   CFSetRef theSet,
   const void *value
);
Parameters
theSet

The set to search. 
value

The value to match in theSet. Comparisons are made using the equal callback provided when theSet was created. If the equal callback was NULL, pointer equality (in C, ==) is used. 
Return Value

true if value is contained in theSet, otherwise false. 
Discussion

This function uses the equal callback. value and all elements in the set must be understood by the equal callback.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFSetContainsValue (
   CFSetRef theSet,
   const void *value
){};

/*CFSetAddValue

Adds a value to a CFMutableSet object.

void CFSetAddValue (
   CFMutableSetRef theSet,
   const void *value
);
Parameters
theSet

The set to modify.
value

A CFType object or a pointer value to add to theSet (or the value itself, if it fits into the size of a pointer). 

value is retained by theSet using the retain callback provided when theSet was created. If value is not of the type expected by the retain callback, the behavior is undefined. If value already exists in the collection, this function returns without doing anything. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetAddValue (
   CFMutableSetRef theSet,
   const void *value
){};

/*CFSetRemoveValue

Removes a value from a CFMutableSet object.

void CFSetRemoveValue (
   CFMutableSetRef theSet,
   const void *value
);
Parameters
theSet

The set to modify.
value

The value to remove from theSet.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetRemoveValue (
   CFMutableSetRef theSet,
   const void *value
){};

/*CFSetApplyFunction

Calls a function once for each value in a set.

void CFSetApplyFunction (
   CFSetRef theSet,
   CFSetApplierFunction applier,
   void *context
);
Parameters
theSet

The set to operate upon. 
applier

The callback function to call once for each value in the theSet. If this parameter is not a pointer to a function of the correct prototype, the behavior is undefined. The applier function must be able to work with all values in theSet.
context

A pointer-sized program-defined value, which is passed as the second parameter to the applier function, but is otherwise unused by this function.
Discussion

If theSet is mutable, it is unsafe for the applier function to change the contents of the collection.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
void CFSetApplyFunction (
   CFSetRef theSet,
   CFSetApplierFunction applier,
   void *context
){};

