#include <DiscRecordingUI/DRBurnProgressPanel.h>

//work
@implementation   DRBurnProgressPanel 

/*progressPanel


Creates and returns an instance of the burn progress panel. 
+ (DRBurnProgressPanel*) progressPanel; 
Return Value

A pointer to the newly created DRBurnProgressPanel.*/
+ (DRBurnProgressPanel*) progressPanel{}


/*beginProgressPanelForBurn:layout:


Presents the progress panel on screen and begins the burn process. 
- (void) beginProgressPanelForBurn:(DRBurn*)burn layout:(id)layout; 
Parameters
burn
The object performing the burn.
layout
The data to be burned to disc. See the DRBurn documentation for information on valid layouts.
Discussion 

This method returns control to the caller after it has displayed the progress sheet and begun the burn. Once the method has returned the caller can perform other operations while the burn continues.*/
- (void) beginProgressPanelForBurn:(DRBurn*)burn layout:(id)layout{}


/*setDescription:


Sets the panel text displayed to the user. 
- (void) setDescription:(NSString*)description; 
Parameters
description
The text to display.
Discussion 

The panel's description is typically a short text string that gives an indication to the user what operation is being performed. If no description is explicitly set, the progress panel uses a standard text string suitable to the burn.*/
- (void) setDescription:(NSString*)description{}

/*beginProgressSheetForBurn:layout:modalForWindow:


Presents the progress panel as a sheet and begins the burn process. 
- (void) beginProgressSheetForBurn:(DRBurn*)burn layout:(id)layout 
        modalForWindow:(NSWindow *)docWindow; 
Parameters
burn
The object performing the burn.
layout
The data to be burned to disc. See the DRBurn documentation for information on valid layouts.
docWindow
The window the sheet will be attached to. If docWindow is not nil, the panel slides down as a sheet running as a document modal window. If owner is nil, this is an error.
Discussion 

This method returns control to the caller after it has displayed the progress sheet and begun the burn. Once the method has returned the caller can perform other operations while the burn continues.*/
- (void) beginProgressSheetForBurn:(DRBurn*)burn layout:(id)layout 
        modalForWindow:(NSWindow *)docWindow{}



@end