#include <HIToolbox/HIToolbox.h>


/*HIPointConvert

Converts a point from one coordinate space to another.

void HIPointConvert (
   HIPoint * ioPoint,
   HICoordinateSpace inSourceSpace,
   void * inSourceObject,
   HICoordinateSpace inDestinationSpace,
   void * inDestinationObject
);
Parameters
ioPoint

A pointer to the point to convert. On output, the point contains the destination coordinates. 
inSourceSpace

A constant specifying the source coordinate space from which the point is to be converted. Some coordinate spaces require the caller to pass extra information in the inSourceObject parameter.
inSourceObject

A pointer to an object defining the source coordinate space from which the point is to be converted. You may pass an object of type WindowRef or HIViewRef. If no object is necessary, you must pass NULL. See Coordinate Space Constants for details on which coordinate spaces require objects.
inDestinationSpace

A constant specifying the destination coordinate space to which the point is to be converted. Some coordinate spaces require the caller to pass extra information in the inDestinationObject parameter.
inDestinationObject

A pointer to an object defining the destination coordinate space to which the point is to be converted. You may pass an object of type WindowRef or HIViewRef. If no object is necessary, you must pass NULL. See Coordinate Space Constants for details on which coordinate spaces require objects.
Discussion

When converting a point from one coordinate space to another, this function takes into account the scale factor of your application’s user interface. If the source or destination object is a view, the view should already be embedded in a window. If both the source and destination objects are views, the views are not required to be embedded in the same window.
Availability
Available in Mac OS X v10.4 and later.
Declared In
HIGeometry.h*/
void HIPointConvert (
   HIPoint * ioPoint,
   HICoordinateSpace inSourceSpace,
   void * inSourceObject,
   HICoordinateSpace inDestinationSpace,
   void * inDestinationObject
){
printf ("HIPointConvert",*ioPoint,inSourceSpace,inSourceObject,inDestinationSpace,inDestinationObject);
};


