#include <stdio.h>
#include <IOKit/IOBufferMemoryDescriptor.h>



/*inTaskWithOptions


Creates a memory buffer with memory descriptor for that buffer. 
public

static IOBufferMemoryDescriptor * inTaskWithOptions( 
    task_t inTask, 
    IOOptionBits options, 
    vm_size_t capacity, 
    vm_offset_t alignment = 1); 
Parameters
inTask
The task the buffer will be allocated in.
options
Options for the allocation:
kIODirectionOut, kIODirectionIn - set the direction of the I/O transfer. 
kIOMemoryPhysicallyContiguous - pass to request memory be physically contiguous. This option is heavily discouraged. The request may fail if memory is fragmented, may cause large amounts of paging activity, and may take a very long time to execute. 
kIOMemoryPageable - pass to request memory be non-wired (the default for kernel allocated memory is wired). 
kIOMemoryPurgeable - pass to request memory that may later have its purgeable state set with IOMemoryDescriptor::setPurgeable. Only supported for kIOMemoryPageable allocations. 
kIOMemoryKernelUserShared - pass to request memory that will be mapped into both the kernel and client applications.
capacity
The number of bytes to allocate.
alignment
The minimum required alignment of the buffer in bytes (1 is the default for no required alignment). For example, pass 256 to get memory allocated at an address with bits 0-7 zero.
Return Value

An instance of class IOBufferMemoryDescriptor to be released by the caller, which will free the memory descriptor and associated buffer. 
Discussion 

This function allocates a memory buffer with a given size and alignment in the task's specified address space, and returns a memory descriptor instance representing the memory. It is recommended that memory allocated for I/O or sharing via mapping be created using IOBufferMemoryDescriptor. Options passed with the request specify the kind of memory to be allocated. For example, pageability and sharing are specified with option bits. This function may block and so should not be called from interrupt level or while a simple lock is held. 
Availability
Mac OS X v10.2 and above*/

static IOBufferMemoryDescriptor::IOBufferMemoryDescriptor * inTaskWithOptions(
    task_t inTask,
    IOOptionBits options,
    vm_size_t capacity,
    vm_offset_t alignment ){
printf ("inTaskWithOptions",inTask,options,capacity,alignment);
}

/*getBytesNoCopy


Gets the virtual address of the beginning of the buffer. 
public

virtual void *getBytesNoCopy(); 
Return Value

The virtual address of the beginning of the buffer*/
void *IOBufferMemoryDescriptor::getBytesNoCopy(){
printf ("getBytesNoCopy");
}; 

