#import <QTKit/QTMedia.h>


/*Constants

The following constants specify the media attributes that you can get and set using the mediaAttributes and setMediaAttributes methods. To get or set a single attribute, use attributeForKey: or setAttribute:.

Note: The QTMediaTypeAttribute attribute indicates the type of media data contained in a QTMedia object. These constants are used to indicate media types, as shown in the portion of the table beginning with the QTMediaTypeVideo constant. 

Constant	
Description
QTMediaCreationTimeAttribute	
The creation time of a QTMedia object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMediaDurationAttribute	
The duration of a QTMedia object; the value for this key is of type NSValue, interpreted as a QTTime.

Available in Mac OS X v10.3 and later.
QTMediaModificationTimeAttribute	
The modification time of a QTMedia object; the value for this key is of type NSDate.

Available in Mac OS X v10.3 and later.
QTMediaSampleCountAttribute	
The media sample count; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMediaQualityAttribute	
The media quality; the value for this key is of type NSNumber, interpreted as a short.

Available in Mac OS X v10.3 and later.
QTMediaTimeScaleAttribute	
The media time scale; the value for this key is of type NSNumber, interpreted as a long.

Available in Mac OS X v10.3 and later.
QTMediaTypeAttribute	
The media type; the value for this key is of type NSString; see below for the values this attribute can return.

Available in Mac OS X v10.3 and later.
QTMediaTypeVideo	
Video media.

Available in Mac OS X v10.3 and later.
QTMediaTypeSound	
Sound media.

Available in Mac OS X v10.3 and later.
QTMediaTypeText	
Text media.

Available in Mac OS X v10.3 and later.
QTMediaTypeBase	
Base media.

Available in Mac OS X v10.3 and later.
QTMediaTypeMPEG	
MPEG media

Available in Mac OS X v10.3 and later.
QTMediaTypeMusic	
Music media

Available in Mac OS X v10.3 and later.
QTMediaTypeTimeCode	
Timecode media.

Available in Mac OS X v10.3 and later.
QTMediaTypeSprite	
Sprite media.

Available in Mac OS X v10.3 and later.
QTMediaTypeFlash	
Flash media.

Available in Mac OS X v10.3 and later.
QTMediaTypeMovie	
Movie media.

Available in Mac OS X v10.3 and later.
QTMediaTypeTween	
Tween media.

Available in Mac OS X v10.3 and later.
QTMediaType3D	
3D media.

Available in Mac OS X v10.3 and later.
QTMediaTypeSkin	
Skin media

Available in Mac OS X v10.3 and later.
QTMediaTypeQTVR	
QuickTime VR media.

Available in Mac OS X v10.3 and later.
QTMediaTypeHint	
Hint media.

Available in Mac OS X v10.3 and later.
QTMediaTypeStream	
Stream media.

Available in Mac OS X v10.3 and later.*/
 NSString  *QTMediaCreationTimeAttribute;
 NSString  *QTMediaDurationAttribute;	
 NSString  *QTMediaModificationTimeAttribute	;
 NSString  *QTMediaSampleCountAttribute	;
 NSString  *QTMediaQualityAttribute	;
 NSString  *QTMediaTimeScaleAttribute	;
 NSString  *QTMediaTypeAttribute	;
 NSString  *QTMediaTypeVideo	;
 NSString  *QTMediaTypeSound	;
 NSString  *QTMediaTypeText	;
 NSString  *QTMediaTypeBase	;
 NSString  *QTMediaTypeMPEG	;
 NSString  *QTMediaTypeMusic	;
 NSString  *QTMediaTypeTimeCode;	
 NSString  *QTMediaTypeSprite	;
 NSString  *QTMediaTypeFlash	;
 NSString  *QTMediaTypeMovie	;
 NSString  *QTMediaTypeTween	;
 NSString  *QTMediaType3D	;
 NSString  *QTMediaTypeSkin;	
 NSString  *QTMediaTypeQTVR	;
 NSString  *QTMediaTypeHint	;
 NSString  *QTMediaTypeStream	;



@implementation QTMedia

/*quickTimeMedia

- (Media)quickTimeMedia
Discussion

Returns the QuickTime media associated with a QTMedia object.
Availability
Available in Mac OS X v10.3 and later.*/
- (Media)quickTimeMedia{
printf ("quickTimeMedia");
}

@end

