#include <QuartzCore/CVOpenGLTexture.h>



/*CVOpenGLTextureGetTarget

Returns the texture target (for example, GL_TEXTURE_2D) of an OpenGL texture.

GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose target you want to obtain. 
Return Value

The OpenGL texture target.
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image
){
printf ("CVOpenGLTextureGetTarget",image);
};

/*CVOpenGLTextureGetCleanTexCoords

Returns the texture coordinates for the part of the image that should be displayed.

void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]
);
Parameters
image

The Core Video OpenGL texture whose clean tex coordinates you want to obtain.
lowerLeft

On return, the GLFloat array hold the s and t texture coordinates of the lower-left corner of the image.
lowerRight

On return, the GLFloat array hold the s and t texture coordinates of the lower-right corner of the image.
upperRight

On return, the GLFloat array hold the s and t texture coordinates of the upper-right corner of the image.
upperLeft

On return, the GLFloat array hold the s and t texture coordinates of the upper-left corner of the image.
Discussion

This function automatically takes into account whether or not the texture is flipped. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]
){
printf ("CVOpenGLTextureGetCleanTexCoords",image,lowerLeft,lowerRight,upperRight,upperLeft);
};

/*CVOpenGLTextureGetName

Returns the texture target name of a CoreVideo OpenGL texture. 

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose texture target name you want to obtain.
Return Value

The target name of the texture. 
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image
){
printf ("CVOpenGLTextureGetName",image);
};

/*CVOpenGLTextureRelease

Releases a Core Video OpenGL texture.

void CVOpenGLTextureRelease (
   CVOpenGLTextureRef texture
);
Parameters
texture

The Core Video OpenGL texture that you want to release.
Discussion

This function is equivalent to CFRelease, but NULL safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

void CVOpenGLTextureRelease (
   CVOpenGLTextureRef texture
){
printf ("CVOpenGLTextureRelease",texture);
};
