#include <QuickTime/QuickTime.h>

//work

/*MediaGetName

Returns the name of the media type.

ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
name

The name of the media type; for example, the video media handler returns the string 'video'.
requestedLanguage

The language in which you want the name returned; see Localization Codes.
actualLanguage

A pointer to the actual language in which the name is returned; see Localization Codes
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage ){};

/*MediaSetSoundOutputComponent

Sets the sound output component for a media handler.

ComponentResult MediaSetSoundOutputComponent (
   MediaHandler    mh,
   Component       outputComponent );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
outputComponent

An instance of a sound output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundOutputComponent (
   MediaHandler    mh,
   Component       outputComponent ){
printf ("MediaSetSoundOutputComponent",mh,outputComponent);
};




/*MediaSetGraphicsMode

Sets the graphics mode and blend color of any media handler.

ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
mode

The graphics mode of the media handler; see Graphics Transfer Modes.
opColor

A pointer to the color for use in blending and transparent operations. The media handler passes this color to QuickDraw as appropriate when you draw in addPin, subPin, blend, transparent, or graphicsModeStraightAlphaBlend mode.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor ){};



/*MediaSetPublicInfo

Undocumented

ComponentResult MediaSetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            dataSize );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
infoSelector

Undocumented
infoDataPtr

Undocumented
dataSize

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            dataSize ){};


/*MediaGetPublicInfo

Undocumented

ComponentResult MediaGetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            *ioDataSize );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
infoSelector

Undocumented
infoDataPtr

Undocumented
ioDataSize

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/

ComponentResult MediaGetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            *ioDataSize ){};

/*MediaSetHandlerCapabilities

Lets a derived media handler report its capabilities to the base media handler.

ComponentResult MediaSetHandlerCapabilities (
   MediaHandler    mh,
   long            flags,
   long            flagsMask );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
flags

Flags (see below) that specify the capabilities of your derived media handler. This parameter contains a number of flags, each of which corresponds to a particular feature. You may work with more than one flag at a time. Be sure to set unused flags to 0. See these constants: 
handlerHasSpatial
handlerCanClip
handlerCanMatte
handlerCanTransferMode
handlerNeedsBuffer
handlerNoIdle
handlerNoScheduler
handlerWantsTime
handlerCGrafPortOnly
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the base media handler to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single flag without altering the settings of other flags.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your media handler may call this function at any time. In general, you should call it from your MediaInitialize function , so that you report your capabilities to the base media handler before the Movie Toolbox starts working with your media. You may call this function again later, in response to changing conditions. For example, if your media handler receives a matrix that it cannot accommodate from the MediaSetMatrix function, you can allow the base media handler to handle your drawing by calling this function and setting the handlerNeedsBuffer flag in both the flags parameter and the flagsMask parameter to 1.
Special Considerations

Note that this function is provided by the base media handler; your media handler does not support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetHandlerCapabilities (
   MediaHandler    mh,
   long            flags,
   long            flagsMask ){};



/*MediaSetActive

Enables and disables media.

ComponentResult MediaSetActive (
   MediaHandler    mh,
   Boolean         enableMedia );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
enableMedia

A Boolean value that indicates whether your media is enabled or disabled. If this parameter is set to TRUE, your media is enabled; if the parameter is FALSE, your media is disabled.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your derived media handler should support this function if you perform your own scheduling or if your media handler uses significant amounts of temporary storage. If you are doing your own scheduling (that is, you have set the handlerNoScheduler flag to 1 in the flags parameter of the MediaSetHandlerCapabilities function), your media handler needs to keep account of the media's active state so that you can properly respond to Movie Toolbox requests. When your media is disabled, you may choose to dispose of temporary storage you have allocated, so that the storage is available to other programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetActive (
   MediaHandler    mh,
   Boolean         enableMedia ){};



/*MediaInitialize

Prepares a derived media handler component to provide access to its media.

ComponentResult MediaInitialize (
   MediaHandler              mh,
   GetMovieCompleteParams    *gmc );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
gmc

A pointer to a GetMovieCompleteParams structure. You can obtain information about the current media from this structure. You should copy any values you need to save into your derived media handler's local data area. Because this data structure is owned by the Movie Toolbox, you do not need to worry about disposing of any of the data in it.
Return Value

See Error Codes. Returns noErr if there is no error. If you return an error, the Movie Toolbox disables the track that uses your media. In cases where your media has just been created, the Movie Toolbox immediately disposes of your media.
Discussion

This function gives your media handler an opportunity to get ready to support the Movie Toolbox. As part of these preparations, your derived media handler should report its capabilities to the base media handler by calling MediaSetHandlerCapabilities. You may choose to examine the data in the GetMovieCompleteParams structure; you may also save values from this structure. If you save references to structures (such as the matte pixel map), do not dispose of the memory associated with these structures. The Movie Toolbox owns these structures.

Note that the Movie Toolbox may call other functions supported by your media handler before it calls your MediaInitialize function. In particular, it may call your MediaGetMediaInfo and MediaPutMediaInfo functions. However, before the Movie Toolbox tries to do anything with the data in your media, it will call your MediaInitialize function. The Movie Toolbox loads the movie's data using functions that are supported by the base media handler; your media handler does not have to support those functions.
Special Considerations

All derived media handlers should support this function. In addition, if your media handler saves values from the GetMovieCompleteParams structure that may change, be sure to support the corresponding functions that allow the Movie Toolbox to report changes to your media handler. For example, if your handler saves the movie time scale from the movieScale field, you should also support the MediaSetMovieTimeScale function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaInitialize (
   MediaHandler              mh,
   GetMovieCompleteParams    *gmc ){};


/*MediaDoIdleActions

Forces a media handler to perform its idle-time actions.

ComponentResult MediaDoIdleActions (
   MediaHandler    mh );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaDoIdleActions (
   MediaHandler    mh ){};

/*MediaSetSoundEqualizerBands

Sets sound equalizer bands for a media handler.

ComponentResult MediaSetSoundEqualizerBands (
   MediaHandler                     mh,
   MediaEQSpectrumBandsRecordPtr    spectrumInfo );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
spectrumInfo

A pointer to a MediaEQSpectrumBandsRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundEqualizerBands (
   MediaHandler                     mh,
   MediaEQSpectrumBandsRecordPtr    spectrumInfo ){};


/*MediaSetSoundLevelMeteringEnabled

Enables or disables sound level metering for a media handler.

ComponentResult MediaSetSoundLevelMeteringEnabled (
   MediaHandler    mh,
   Boolean         enable );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
enable

Pass TRUE to enable sound level metering, FALSE to disable it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundLevelMeteringEnabled (
   MediaHandler    mh,
   Boolean         enable ){};






/*MediaGetSoundEqualizerBandLevels

Gets the sound equalizer band levels for a media handler.

ComponentResult MediaGetSoundEqualizerBandLevels (
   MediaHandler    mh,
   UInt8           *bandLevels );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
bandLevels

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetSoundEqualizerBandLevels (
   MediaHandler    mh,
   UInt8           *bandLevels ){};


/*MediaSetSoundBalance

Sets the right/left sound balance of a track.

ComponentResult MediaSetSoundBalance (
   MediaHandler    mh,
   short           balance );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
balance

The new balance setting for the media handler's track. The balance setting is a signed 16-bit integer that controls the relative volume of the left and right sound channels. A value of 0 sets the balance to neutral. Positive values shift the balance to the right channel, negative values to the left channel. The valid range is 127 (right channel only) to -128 (left channel only).
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to alter the audio balance on a per-track basis. It works with both mono and stereo sources. The actual volume of the audio is not changed by this setting, only its relative distribution. This function operates on sound tracks, music tracks, and Flash tracks containing audio. It may operate on other audio track types as well; if the the chosen media handler does not support this function, it returns badComponentSelector. To obtain the media handler for a track, call GetTrackMedia and then GetMediaHandler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundBalance (
   MediaHandler    mh,
   short           balance ){};

/*MediaHasCharacteristic

Called by Movie Toolbox with a specified characteristic to allow tracks to be identified by various attributes.

ComponentResult MediaHasCharacteristic (
   MediaHandler    mh,
   OSType          characteristic,
   Boolean         *hasIt );

Parameters
mh

The Movie Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
characteristic

A constant that specifies the attribute of a track. Examples of characteristics that are currently defined are the constants VisualMediaCharacteristic and AudioMediaCharacteristic.
hasIt

A pointer to a Boolean value that specifies whether the track has the attribute specified in the characteristic parameter. Set this value to TRUE if the attribute applies to your media handler; otherwise, set this value to FALSE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You should implement this function for any media handler that has characteristics in addition to spatial ones. If you have set the handlerHasSpatial capabilities flag, the base media handler automatically handles the VisualMediaCharacteristic constant for you.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaHasCharacteristic (
   MediaHandler    mh,
   OSType          characteristic,
   Boolean         *hasIt ){};



