#include <SystemConfiguration/SystemConfiguration.h>

//work

/*SCNetworkConnectionCopyUserPreferences

Boolean SCNetworkConnectionCopyUserPreferences ( 
    CFDictionaryRef selectionOptions, 
    CFStringRef *serviceID, 
    CFDictionaryRef *userOptions );  
Parameters
selectionOptions
Currently unimplemented. Pass NULL for this version.
serviceID
Reference to the default serviceID for starting connections, this value will be returned by the function.
userOptions
Reference to default userOptions for starting connections, this will be returned by the function.
Return Value

Returns TRUE if there is a valid service to dial; FALSE if the function was unable to retrieve a service to dial. 
Discussion 

Provides the default service ID and a dictionary of user options for the connection. Applications can use the returned serviceID and userOptions values to open a connection on the fly. 
Availability
Introduced in Mac OS X v10.3.*/

Boolean SCNetworkConnectionCopyUserPreferences ( 
    CFDictionaryRef selectionOptions, 
    CFStringRef *serviceID, 
    CFDictionaryRef *userOptions ){};  

/*SCNetworkConnectionGetStatus

SCNetworkConnectionStatus SCNetworkConnectionGetStatus ( 
    SCNetworkConnectionRef connection );  
Parameters
connection
The SCNetworkConnection to obtain status from.
Return Value

Returns the status value. 
Discussion 

Returns the status of the SCNetworkConnection. A status is one of the following values: 
 
	kSCNetworkConnectionInvalid
	kSCNetworkConnectionDisconnected
	kSCNetworkConnectionConnecting
	kSCNetworkConnectionDisconnecting
	kSCNetworkConnectionConnected

Availability
Introduced in Mac OS X v10.3.*/
SCNetworkConnectionStatus SCNetworkConnectionGetStatus ( 
    SCNetworkConnectionRef connection ){};  

/*SCNetworkConnectionStart

Boolean SCNetworkConnectionStart ( 
    SCNetworkConnectionRef connection, 
    CFDictionaryRef userOptions, 
    Boolean linger );  
Parameters
connection
The SCNetworkConnection to start.
userOptions
The options dictionary to start the connection with. If userOptions is NULL, the default settings will be used. If userOptions are specified, they must be in the same format as network services stored in the system configuration preferences schema. The options will override the default settings defined for the service. 

For security reasons, not all options can be overridden; the appropriate merging of all settings will be done before the connection is established, and inappropriate options will be ignored.
linger
This parameter indicates whether or not the connection can stay around when the application no longer has interest in it. A typical application should pass FALSE, and the connection will be automatically stopped when the reference is released or if the application quits. If the application passes TRUE, the application can release the reference or exit and the connection will be maintained until a timeout event, until a specific stop request occurs, or until an error is encountered.
Return Value

Returns TRUE if the connection was correctly started (the actual connection is not established yet, and the connection status needs to be periodically checked); FALSE if the connection request was not started. The error must be retrieved from the SCError function. 
Discussion 

Starts the connection for the SCNetworkConnection. The connection process is asynchronous and the function will return immediately. The connection status can be obtained by polling or by callback. The connection is made with the default settings from the administrator. Some of the settings can be overridden for the duration of the connection. These are specified in an options dictionary. The options dictionary uses the same format as a network service defined in the system configuration preferences schema. 

Note: Starting and stopping of connections is implicitly arbitrated. Calling SCNetworkConnectionStart on a connection already started will indicate that the application has interest in the connection and it shouldn't be stopped by anyone else. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionStart ( 
    SCNetworkConnectionRef connection, 
    CFDictionaryRef userOptions, 
    Boolean linger ){};  

/*SCNetworkConnectionStop

Boolean SCNetworkConnectionStop ( 
    SCNetworkConnectionRef connection, 
    Boolean forceDisconnect );  
Parameters
connection
The SCNetworkConnection to stop.
Return Value

Returns TRUE if the disconnection request succeeded; FALSE if the disconnection request failed. The error must be retrieved from the SCError function. 
Discussion 

Stops the connection for the SCNetworkConnection. The disconnection process is asynchronous and the function will return immediately. The connection status can be obtained by polling or by callback. This function performs an arbitrated stop of the connection. If several applications have marked their interest in the connection, by calling SCNetworkConnectionStart, the call will succeed but the actual connection will be maintained until the last interested application calls SCNetworkConnectionStop. 

In certain cases, you might want to stop the connection anyway. In these cases, you set the forceDisconnect argument to TRUE. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionStop ( 
    SCNetworkConnectionRef connection, 
    Boolean forceDisconnect ){};  

/*SCNetworkConnectionCopyExtendedStatus

CFDictionaryRef SCNetworkConnectionCopyExtendedStatus ( 
    SCNetworkConnectionRef connection );  
Parameters
connection
The SCNetworkConnection to obtain status from.
Return Value

Returns the status dictionary. If NULL is returned, the error can be retrieved using the SCError function. 
Discussion 

Returns the extended status of the connection. An extended status dictionary contains specific dictionaries describing the status for each subcomponent of the service. 

For example, a status dictionary will contain the following sub-dictionaries, keys, and values: 
 
	IPv4  : Addresses      : the assigned IP address.
 
	PPP   : Status         : the PPP-specific status of type
				 SCNetworkConnectionPPPStatus.
 
		LastCause      : Available when the status is "Disconnected"
				 and contains the last error associated with
				 connecting or disconnecting.
 
		ConnectTime    : the time when the connection was
				 established.
 
	Modem : ConnectSpeed   : the speed of the modem connection
				 in bits/second.

Other dictionaries could be present for PPPoE, PPTP, and L2TP. 

The status dictionary may be extended in the future to contain additional information. 
Availability
Introduced in Mac OS X v10.3.*/
CFDictionaryRef SCNetworkConnectionCopyExtendedStatus ( 
    SCNetworkConnectionRef connection ){};  

/*SCNetworkConnectionCreateWithServiceID

SCNetworkConnectionRef SCNetworkConnectionCreateWithServiceID ( 
    CFAllocatorRef allocator, 
    CFStringRef serviceID, 
    SCNetworkConnectionCallBack callout, 
    SCNetworkConnectionContext *context );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for the connection structure. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
serviceID
A string that defines the service identifier of the connection. Service identifiers uniquely identify services in the system configuration database.
callout
The function to be called when the status of the connection changes. If this parameter is NULL, the application will not receive notifications of status change and will need to poll for updates.
context
The SCNetworkConnectionContext associated with the callout.
Return Value

Returns a reference to the new SCNetworkConnection. 
Discussion 

Creates a new connection reference to use for getting the status or for connecting or disconnecting the associated service. 
Availability
Introduced in Mac OS X v10.3.*/

SCNetworkConnectionRef SCNetworkConnectionCreateWithServiceID ( 
    CFAllocatorRef allocator, 
    CFStringRef serviceID, 
    SCNetworkConnectionCallBack callout, 
    SCNetworkConnectionContext *context ){};  

/*SCNetworkConnectionScheduleWithRunLoop

Boolean SCNetworkConnectionScheduleWithRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
connection
The SCNetworkConnection to schedule.
runLoop
The run loop to schedule with.
runLoopMode
The run loop mode.
Return Value

Returns TRUE if the connection is scheduled successfully; FALSE if the scheduling failed. The error can be retrieved using the SCError function. 
Discussion 

Schedules a connection with the run loop. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionScheduleWithRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode ){};  

/*SCNetworkConnectionUnscheduleFromRunLoop

Boolean SCNetworkConnectionUnscheduleFromRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
connection
The SCNetworkConnection to unschedule.
runLoop
The run loop to unschedule from.
runLoopMode
The run loop mode.
Return Value

Returns TRUE if the connection is unscheduled successfully; FALSE if the unscheduling failed. The error can be retrieved using the SCError function. 
Discussion 

Unschedules a connection from the run loop. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionUnscheduleFromRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode ){};  
