#ifndef MATH64_H
#define MATH64_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif


//#include <HYS/CarbonCore/Math64.h>
#include <APPLE/CarbonCore/Math64.h>

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*S64Compare


SInt32 S64Compare (
   SInt64 left,
   SInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt32 S64Compare (
   SInt64 left,
   SInt64 right
);

/*U64SetU


UInt64 U64SetU (
   UInt32 value
);
Parameters
value
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

UInt64 U64SetU (
   UInt32 value
);

/*U64Multiply


UInt64 U64Multiply (
   UInt64 left,
   UInt64 right
);
Parameters
xparam
yparam
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

UInt64 U64Multiply (
   UInt64 left,
   UInt64 right
);

/*U32SetU


UInt32 U32SetU (
   UInt64 value
);
Parameters
value
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
UInt32 U32SetU (
   UInt64 value
);

/*U64Div


Under evaluation

UInt64 U64Div (
   UInt64 dividend,
   UInt64 divisor
);
Parameters
dividend
divisor
Return Value
Availability
Declared In
Math64.h*/
UInt64 U64Div (
   UInt64 dividend,
   UInt64 divisor
);

/*U64ShiftRight


UInt64 U64ShiftRight (
   UInt64 value,
   UInt32 shift
);
Parameters
value
shift
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

UInt64 U64ShiftRight (
   UInt64 value,
   UInt32 shift
);

/*S64Div


SInt64 S64Div (
   SInt64 dividend,
   SInt64 divisor
);
Parameters
dividend
divisor
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt64 S64Div (
   SInt64 dividend,
   SInt64 divisor
);

/*S64SetU


SInt64 S64SetU (
   UInt32 value
);
Parameters
value
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt64 S64SetU (
   UInt32 value
);

/*S64Add


SInt64 S64Add (
   SInt64 left,
   SInt64 right
);
Parameters
x
y
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
SInt64 S64Add (
   SInt64 left,
   SInt64 right
);

/*U64Subtract


UInt64 U64Subtract (
   UInt64 left,
   UInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/
UInt64 U64Subtract (
   UInt64 left,
   UInt64 right
);

/*U64Compare


SInt32 U64Compare (
   UInt64 left,
   UInt64 right
);
Parameters
left
right
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
Math64.h*/

SInt32 U64Compare (
   UInt64 left,
   UInt64 right
);


#ifdef __cplusplus
}
#endif

#endif