#ifndef  OSUTILS_H
#define OSUTILS_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef MACMEMORY_H
#include <CarbonCore/MacMemory.h>
#endif

#ifndef PATCHES_H
#include <CarbonCore/Patches.h>
#endif


#ifndef DATETIMEUTILS_H
#include <CarbonCore/DateTimeUtils.h>
#endif

#ifndef CFSTRING_H
#include <CoreFoundation/CFString.h>
#endif

//#include <HYS/CarbonCore/OSUtils.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*SysParmType

Contains settings used by the system at startup.

struct SysParmType {
   UInt8 valid;
   UInt8 aTalkA;
   UInt8 aTalkB;
   UInt8 config;
   short portA;
   short portB;
   long alarm;
   short font;
   short kbdPrint;
   short volClik;
   short misc;
};
typedef struct SysParmType SysParmType;
typedef SysParmType * SysPPtr;
Availability
Available in Mac OS X v10.0 and later.*/
struct SysParmType {
   UInt8 valid;
   UInt8 aTalkA;
   UInt8 aTalkB;
   UInt8 config;
   short portA;
   short portB;
   long alarm;
   short font;
   short kbdPrint;
   short volClik;
   short misc;
};
typedef struct SysParmType SysParmType;
typedef SysParmType * SysPPtr;


/*Addressing Errors

Specify a type of addressing error.

enum {
   false32b = 0,
   true32b = 1
};
Constants
false32b

Indicates a 24-bit addressing error.

Available in Mac OS X v10.0 and later.
true32b

Indicates a 32-bit addressing error.

Available in Mac OS X v10.0 and later.*/
enum {
   false32b = 0,
   true32b = 1
};


/*Queue Types

Specifies queue types.

enum {
   dummyType = 0,
   vType = 1,
   ioQType = 2,
   drvQType = 3,
   evType = 4,
   fsQType = 5,
   sIQType = 6,
   dtQType = 7,
   nmType = 8
};
typedef SignedByte QTypes;
Constants
dummyType

Reserved.

Available in Mac OS X v10.0 and later.
vType

Specifies a vertical retrace queue type. See the Vertical Retrace Manager for more information.

Available in Mac OS X v10.0 and later.
ioQType

Specifies a file I/O or driver I/O queue type.

Available in Mac OS X v10.0 and later.
drvQType

Specifies a drive queue type.

Available in Mac OS X v10.0 and later.
evType

Specifies an event queue type. See the Event Manager for more information.

Available in Mac OS X v10.0 and later.
fsQType

Specifies a volume-control-block queue type.

Available in Mac OS X v10.0 and later.
sIQType

Specifies a slot interrupt queue type. See the Slot Manager for more information.

Available in Mac OS X v10.0 and later.
dtQType

Specifies a deferred task queue type. See Memory Management Utilities for more information.

Available in Mac OS X v10.0 and later.
nmType

Specifies a notification queue type. See the Notification Manager for more information.

Available in Mac OS X v10.0 and later.
Discussion

The different queue types that are accessible to your application are defined by the QTypes data type. Each of these enumerated queue types determines a different type of queue element. These constants are used in the qtype field of the QElem structure.*/
enum {
   dummyType = 0,
   vType = 1,
   ioQType = 2,
   drvQType = 3,
   evType = 4,
   fsQType = 5,
   sIQType = 6,
   dtQType = 7,
   nmType = 8
};
typedef SignedByte QTypes;


/*SysEnvRec

Contains information about the system environment.

struct SysEnvRec {
   short environsVersion;
   short machineType;
   short systemVersion;
   short processor;
   Boolean hasFPU;
   Boolean hasColorQD;
   short keyBoardType;
   short atDrvrVersNum;
   short sysVRefNum;
};
typedef struct SysEnvRec SysEnvRec;
Fields
environsVersion

The version number of the SysEnvirons function that was used to fill in the record.

When you call the SysEnvirons function, you specify a version number to ensure that you receive a system environment record that matches your expectations. If you request a more recent version of SysEnvirons than is available, SysEnvirons places its own version number in the environsVersion field and returns a function result envVersTooBig.
machineType

A code for the Macintosh model. See “Macintosh Model Codes”. Use the Gestalt function to obtain information about machine types not listed among these constants.
systemVersion

The version number of the current System file, represented as two byte-long numbers with one or more implied decimal points. The value $0410, for example, represents system software version 4.1.

If you call SysEnvirons when a system earlier than 4.1 is running, the MPW glue places $0 in this field and returns a result code of envNotPresent.
processor

A code for the microprocessor. See “Microprocessor Codes”.
hasFPU

A Boolean value that indicates whether hardware floating-point processing is available.
hasColorQD

A Boolean value that indicates whether Color QuickDraw is present. This field says nothing about the presence of a color monitor.
keyBoardType

A code for the keyboard type. See “Keyboard Constants”. Use the Gestalt function to obtain information about keyboard types not listed among these constants.

If the Apple Desktop Bus is in use, this field returns the keyboard type of the keyboard on which the last keystroke was made.
atDrvrVersNum

The version number of the AppleTalk driver (specifically, the .MPP driver) currently installed. If AppleTalk is not loaded, this field is 0.
sysVRefNum

The working-directory reference number of the folder or volume that holds the open System file.
Discussion

The SysEnvirons function fills in a system environment record, which describes some aspects of the software and hardware environment. 
Availability
Available in Mac OS X v10.0 and later.*/

struct SysEnvRec {
   short environsVersion;
   short machineType;
   short systemVersion;
   short processor;
   Boolean hasFPU;
   Boolean hasColorQD;
   short keyBoardType;
   short atDrvrVersNum;
   short sysVRefNum;
};
typedef struct SysEnvRec SysEnvRec;



/*QElem

Contains information about a queue element.

struct QElem {
   QElem * qLink;
   short qType;
   short qData[1];
};
typedef struct QElem QElem;
typedef QElem * QElemPtr;
Fields
qLink

The type of the queue element. For a description of the values which you can use in this field, see “Queue Types”. 
qType

A variable array of data. The type of data and the length depend upon the queue type, specified in the qType field.
qData
Discussion

A queue element is a single entry in a queue. Each operating-system queue created and maintained by the Macintosh Operating System consists of a queue header and a linked list of queue elements. The exact structure of an element in an operating-system queue depends on the type of the queue. The QElem data type defines the available queue elements.
Availability
Available in Mac OS X v10.0 and later.
Contains information about a queue element.*/

struct QElem {
   struct QElem * qLink;
   short qType;
   short qData[1];
};
typedef struct QElem QElem;
typedef QElem * QElemPtr;

/*QHdr

A Windows queue header structure.

struct QHdr {
   short       qFlags;
   short       pad;
   long        MutexID;
   QElemPtr    qHead;
   QElemPtr    qTail;
};
Fields
qFlags
Discussion

Undocumented
pad
Discussion

Unused.
MutexID
Discussion

Undocumented
qHead
Discussion

Undocumented
qTail
Discussion

Undocumented
Related Functions
CDSequenceSetSourceDataQueue
Dequeue
Enqueue
InitializeQHdr
TerminateQHdr 
Declared In
ImageCompression.h*/
struct QHdr {
   short       qFlags;
   short       pad;
   long        MutexID;
   QElemPtr    qHead;
   QElemPtr    qTail;
};
typedef  struct QHdr QHdr;

/*QHdrPtr

Represents a type used by the Compression and Decompression API.

typedef QHdr * QHdrPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef QHdr * QHdrPtr;

/*MachineLocation

Contains information about the geographical location of a computer.

struct MachineLocation {
   Fract latitude
   Fract longitude
   union {
      #if TARGET_RT_BIG_ENDIAN
      SInt8 dlsDelta;
      #endif
      long gmDelta;
      struct {
         #if TARGET_RT_LITTLE_ENDIAN
         SInt8 pad[3];
         #endif
         SInt8 Delta;
      } dls;
   } u;
};
typedef struct MachineLocation MachineLocation;
Fields
latitude

The location’s latitude, in fractions of a great circle. For example, Copenhagen, Denmark is at 55.43 degrees north latitude. When writing the latitude to extended parameter RAM with the WriteLocation procedure, you must convert this value to a Fract data type. (For example, a Fract value of 1.0 equals 90 degrees –1.0 equals –90 degrees and –2.0 equals –180 degrees.) For more information on the Fract data type, see Mathematical and Logical Utilities.
longitude

The location’s longitude, in fractions of a great circle. For example, Copenhagen, Denmark is at 12.34 degrees east longitude. When writing the longitude to extended parameter RAM with the WriteLocation procedure, you must convert this value to a Fract data type. (For example, a Fract value of 1.0 equals 90 degrees –1.0 equals –90 degrees and –2.0 equals –180 degrees.
dlsDelta

A value that represents the current state of daylight savings time. 
gmDelta
pad
delta

A signed byte value representing the hour offset for daylight saving time. This field is a 1-byte value contained in a long word. It should be preserved when writing gmtDelta. 
Discussion

The geographic location and time-zone information of a Macintosh computer are stored in extended parameter RAM. The MachineLocation data type defines the format for the geographic location record.

The ReadLocation and WriteLocation procedures use the geographic location record to read and store the geographic location and time zone information in extended parameter RAM. If the geographic location record has never been set, all fields contain 0.

In order for MachineLocation to be endian-safe, a new member has been added to the 'u' union in the structure. You are encouraged to use the new member instead of the old one.

If your code looked like this:MachineLocation.u.dlsDelta = 1;


you should change it to this:MachineLocation.u.dls.Delta = 1;


to be endian safe. The gmtDelta remains the same; the low 24-bits are used. Remember that order of assignment DOES matter.

This will overwrite results:MachineLocation.u.dls.Delta = 0xAA;         // u = 0xAAGGGGGG; G=Garbage
MachineLocation.u.gmtDelta = 0xBBBBBB;      // u = 0x00BBBBBB;


when in fact reversing the assignment would have preserved the values:MachineLocation.u.gmtDelta = 0xBBBBBB;      // u = 0x00BBBBB;
MachineLocation.u.dls.Delta = 0xAA;         // u = 0xAABBBBBB;

Availability
Available in Mac OS X v10.0 and later.*/
struct MachineLocation {
   Fract latitude;
   Fract longitude;
   union {
      #if TARGET_RT_BIG_ENDIAN
      SInt8 dlsDelta;
      #endif
      long gmtDelta;
      struct {
         #if TARGET_RT_LITTLE_ENDIAN
         SInt8 pad[3];
         #endif
         SInt8 Delta;
      } dls;
   } u;
};
typedef struct MachineLocation MachineLocation;


//function

/*Dequeue

Removes a queue element directly from an operating-system queue or from a queue that you have created.

OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to a queue element to remove from a queue. 
qHeader

A pointer to a queue header. 
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Discussion

The Dequeue function attempts to find the queue element specified by the qElement parameter in the queue specified by the qHeader parameter. If Dequeue finds the element, it removes the element from the queue, adjusts the other elements in the queue accordingly, and returns noErr. Otherwise, it returns qErr, indicating that it could not find the element in the queue. The Dequeue function does not deallocate the memory occupied by the queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

The Dequeue function disables interrupts as it searches through the queue for the element to be removed. The time during which interrupts are disabled depends on the length of the queue and the position of the entry in the queue. The Dequeue function can be called at interrupt time. However, the Dequeue function is ordinarily used only by system software and, whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose removal functions. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Dequeue:
SlotVRemove

Removes a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VRemove

Removes a system-based VBL task. This function is available with the Vertical Retrace Manager.
WaitNextEvent

Removes an Event. This function is available with the Event manager.
SIntRemove

Removes a slot interrupt task. This function is available with the Slot Manager.
NMRemove

Removes a Notification request. This function is available with the Notification Manager.
SleepQRemove

Removes a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);

/*Enqueue

Adds elements directly to an operating-system queue or a queue that you create.

void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to the queue element to add to a queue. 
qHeader

A pointer to a queue header. 
Discussion

The Enqueue function adds the queue element specified by the qElement parameter to the end of the queue specified by the qHeader parameter. The specified queue header is updated to reflect the new queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

Because interrupt functions are likely to manipulate operating-system queues, interrupts are disabled for a short time while the specified queue is updated. You can call the Enqueue function at interrupt time. However, the Enqueue function is ordinarily used only by system software. Whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose functions whenever possible, instead of the Enqueue function. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Enqueue:
SlotVInstall

Installs a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VInstall

Installs a system-based VBL task. This function is available with the Vertical Retrace Manager.
AddDrive

Adds a disk drive. This function is available with the Device Manager.
PPostEvent and PostEvent

Installs an Event. This function is available with the Event manager.
DTInstall

Installs a deferred task. This function is available with the Memory Management Utilities.
SIntInstall

Installs a slot interrupt task. This function is available with the Slot Manager.
NMInstall

Installs a Notification request. This function is available with the Notification Manager.
SleepQInstall

Installs a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);

/*TickCount

Obtains the current number of ticks (a tick is approximately 1/60 of a second) since the system last started up.

UInt32 TickCount ();
Discussion

The TickCount function returns an unsigned 32-bit integer that indicates the current number of ticks since the system last started up. You can use this value to compare the number of ticks that have elapsed since a given event or other action occurred. For example, you could compare the current value returned by TickCount with the value of the when field of an event structure.

The tick count is incremented during the vertical retrace interrupt, but this interrupt can be disabled. Your application should not rely on the tick count to increment with absolute precision. Your application also should not assume that the tick count always increments by 1 an interrupt task might keep control for more than one tick. If your application keeps track of the previous tick count and then compares this value with the current tick count, your application should compare the two values by checking for a “greater than or equal” condition rather than “equal to previous tick count plus 1.”

Do not rely on the tick count being exact; it is usually accurate to within one tick, but this level of accuracy is not guaranteed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
UInt32 TickCount ();

/*MakeDataExecutable

Notifies the system that the specified data is subject to execution.

void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);
Parameters
baseAddress

The starting address of the data to be flushed.
length

The length of the data pointed to by the baseAddress parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void MakeDataExecutable (
   void * baseAddress,
   unsigned long length
);

/*Delay

Delays execture for the specified amount of time.

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);
Parameters
numTicks
finalTicks
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/

void Delay (
   unsigned long numTicks,
   unsigned long * finalTicks
);

/*SetCurrentA5

Sets the value in register A5 to the value of the low-memory global variable CurrentA5. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetCurrentA5 ();
Return Value

The value in the A5 register before SetCurrentA5 changes it to the value of the low-memory global variable CurrentA5. 
Discussion

The CurrentA5 variable points to the boundary between the parameters and global variables of the current application.

You cannot reliably call SetCurrentA5 in code that executes at interrupt time unless you first guarantee that your application is the current process (for example, by calling the Process Manager function GetCurrentProcess). In general, you should call SetCurrentA5 at noninterrupt time and then pass the returned value to the interrupt code. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
long SetCurrentA5 ();

/*SetA5

Sets the A5 register to the address specified. (Deprecated in Mac OS X v10.4. There is no replacement because Mac OS X doesn’t use the A5 variable.)

long SetA5 (
   long newA5
);
Parameters
newA5

The value to which the A5 register is to be changed. 
Return Value

The value in the A5 register before SetA5 changes it to newA5. 
Discussion

In interrupt code that accesses application global variables, use the SetA5 function first to restore a value previously saved using SetCurrentA5, and then, at the end of the code, to restore the A5 register to the value it had before the first call to SetA5. 
Carbon Porting Notes

68K-specific. Does nothing in PowerPC native code. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/

long SetA5 (
   long newA5
);

/*Changing the Addressing Mode
pascal char GetMMUMode		(void);
pascal void SwapMMUMode		(char *mode);*/
pascal char GetMMUMode		(void);
pascal void SwapMMUMode		(char *mode);


/*Getting Information About the Operating Environment
pascal OSErr Gestalt	(OSType selector, long *response);
pascal OSErr SysEnvirons(short versionRequested, SysEnvRec *theWorld);*/
pascal OSErr SysEnvirons(short versionRequested, SysEnvRec *theWorld);

/*InitUtil

Copies the contents of parameter RAM into low memory. (Deprecated in Mac OS X v10.3. There is no replacement because Mac OS X doesn’t require this initialization.)

OSErr InitUtil ();
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
OSUtils.h*/
OSErr InitUtil ();

/*GetSysPPtr

Returns a pointer to the low-memory copy of parameter RAM. (Deprecated in Mac OS X v10.4. There is no replacement; this function always returns NULL in Mac OS X.)

SysPPtr GetSysPPtr ();
Return Value

See the description of the SysPPtr data type.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
SysPPtr GetSysPPtr ();

/*WriteParam

Write the modified values in the system parameters data structure to parameter RAM. (Deprecated in Mac OS X v10.4. There is no replacement, because this function does nothing in Mac OS X.)

OSErr WriteParam ();
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OSUtils.h*/
OSErr WriteParam ();

/*ReadLocation

Obtains information about a geographic location or time zone.

void ReadLocation (
   MachineLocation * loc
);
Parameters
loc

On return, the fields of the geographic location structure containing the geographic location and the time-zone information.The ReadLocation procedure reads the stored geographic location and time zone of the Macintosh computer from extended parameter RAM. 

You can get values for the latitude, longitude, daylight savings time (DST), or Greenwich mean time (GMT). If the geographic location record has never been set, all fields contain 0.

Discussion

The latitude and longitude are stored as Fract values, giving accuracy to within one foot. For example, a Fract value of 1.0 equals 90 degrees –1.0 equals –90 degrees and –2.0 equals –180 degrees. 

To convert these values to a degrees format, you need to convert the Fract values first to the Fixed data type, then to the LongInt data type. Use the Mathematical and Logical Utilities functions Fract2Fix and Fix2Long to accomplish this task.

The DST value is a signed byte value that specifies the offset for the hour field—whether to add one hour, subtract one hour, or make no change at all. 

The GMT value is in seconds east of GMT. For example, San Francisco is at –28,800 seconds (8 hours * 3,600 seconds per hour) east of GMT. The gmtDelta field is a 3-byte value contained in a long word, so you must take care to get it properly.

The ReadLocation function was previously available with the Script Manager.

For more information on the geographic location record, see MachineLocation. 

For more information on the Fract data type and the conversion routines Long2Fix, Fix2Fract, Fract2Fix, and Fix2Long, see Mathematical and Logical Utilities. 
Special Considerations

Do not call the ReadLocation function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void ReadLocation (
   MachineLocation * loc
);

/*CSCopyUserName

Returns a reference to the CFString that represents the user name.

CFStringRef CSCopyUserName (
   Boolean useShortName
);
Parameters
useShortName

A Boolean value that specifies whether to return the short name or full name of the user.
Return Value

A CFStringRef. See the Base Services documentation for a description of the CFStringRef data type.
Discussion

The function CSCopyUserName returns a CFStringRef based on the read UID (RUID, as returned by getuid) of the calling process. This can result in unexpected behavior (that is, CSCopyUserName returning different results than SCDynamicStoreCopyConsoleUser) for processes that manipulate their UID.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
CFStringRef CSCopyUserName (
   Boolean useShortName
);

/*CSCopyMachineName

Returns a reference to the CFString that represents the computer name.

CFStringRef CSCopyMachineName ();
Return Value

A CFStringRef. See the Base Services documentation for a description of the CFStringRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
CFStringRef CSCopyMachineName ();

/*Manipulating the Processor Caches
pascal Boolean SwapInstructionCache
				(Boolean cacheEnable);
pascal void FlushInstructionCache
				(void);
pascal Boolean SwapDataCache(Boolean cacheEnable);
pascal void FlushDataCache	(void);
void FlushCodeCache		(void);
OSErr FlushCodeCacheRange	(void *address, unsigned long count);*/
OSErr FlushCodeCacheRange	(void *address, unsigned long count);

#ifdef __cplusplus
}
#endif
#endif