//inc;;
#ifndef COREAUDIOTYPES_H
#define COREAUDIOTYPES_H



#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Audio Time Stamp Flags

Indicate which fields in an AudioTimeStamp structure are valid.

enum
{
   kAudioTimeStampSampleTimeValid      = (1L << 0),
   kAudioTimeStampHostTimeValid        = (1L << 1),
   kAudioTimeStampRateScalarValid      = (1L << 2),
   kAudioTimeStampWordClockTimeValid   = (1L << 3),
   kAudioTimeStampSMPTETimeValid       = (1L << 4)
};
Constants
kAudioTimeStampSampleTimeValid

The sample frame time is valid.

Available in Mac OS X v10.0 and later.
kAudioTimeStampHostTimeValid

The host time is valid.

Available in Mac OS X v10.0 and later.
kAudioTimeStampRateScalarValid

The rate scalar is valid.

Available in Mac OS X v10.0 and later.
kAudioTimeStampWordClockTimeValid

The word clock time is valid.

Available in Mac OS X v10.0 and later.
kAudioTimeStampSMPTETimeValid

The SMPTE time is valid.

Available in Mac OS X v10.0 and later.
Declared In
CoreAudioTypes.h*/
enum
{
   kAudioTimeStampSampleTimeValid      = (1L << 0),
   kAudioTimeStampHostTimeValid        = (1L << 1),
   kAudioTimeStampRateScalarValid      = (1L << 2),
   kAudioTimeStampWordClockTimeValid   = (1L << 3),
   kAudioTimeStampSMPTETimeValid       = (1L << 4)
};


/*Audio Data Format IDs

The four character code IDs used to identify individual formats of audio data in the AudioStreamBasicDescription structure.

enum
{
   kAudioFormatLinearPCM               = 'lpcm',
   kAudioFormatAC3                     = 'ac-3',
   kAudioFormat60958AC3                = 'cac3',
   kAudioFormatAppleIMA4               = 'ima4',
   kAudioFormatMPEG4AAC                = 'aac ',
   kAudioFormatMPEG4CELP               = 'celp',
   kAudioFormatMPEG4HVXC               = 'hvxc',
   kAudioFormatMPEG4TwinVQ             = 'twvq',
   kAudioFormatMACE3                   = 'MAC3',
   kAudioFormatMACE6                   = 'MAC6',
   kAudioFormatULaw                    = 'ulaw',
   kAudioFormatALaw                    = 'alaw',
   kAudioFormatQDesign                 = 'QDMC',
   kAudioFormatQDesign2                = 'QDM2',
   kAudioFormatQUALCOMM                = 'Qclp',
   kAudioFormatMPEGLayer1              = '.mp1',
   kAudioFormatMPEGLayer2              = '.mp2',
   kAudioFormatMPEGLayer3              = '.mp3',
   kAudioFormatDVAudio                 = 'dvca',
   kAudioFormatVariableDurationDVAudio = 'vdva',
   kAudioFormatTimeCode                = 'time',
   kAudioFormatMIDIStream              = 'midi',
   kAudioFormatParameterValueStream    = 'apvs',
   kAudioFormatAppleLossless           = 'alac'
};
Constants
kAudioFormatLinearPCM

Linear PCM, a noncompressed audio data format with one frame per packet. Uses the linear PCM format flags in AudioStreamBasicDescription Flags.

Available in Mac OS X v10.0 and later.
kAudioFormatAC3

AC-3. Uses no flags.

Available in Mac OS X v10.2 and later.
kAudioFormat60958AC3

AC-3 packaged for transport over an IEC 60958 compliant digital audio interface. Uses the standard format flags in AudioStreamBasicDescription Flags.

Available in Mac OS X v10.2 and later.
kAudioFormatAppleIMA4

Apple’s implementation of IMA 4:1 ADPCM. Uses no flags.

Available in Mac OS X v10.2 and later.
kAudioFormatMPEG4AAC

MPEG-4 AAC. The flags field contains the MPEG-4 audio object type constant listed in MPEG-4 Audio Object Type Constants indicating the specific kind of data.

Available in Mac OS X v10.2 and later.
kAudioFormatMPEG4CELP

MPEG-4 CELP. The flags field contains the MPEG-4 audio object type constant listed in MPEG-4 Audio Object Type Constants indicating the specific kind of data.

Available in Mac OS X v10.2 and later.
kAudioFormatMPEG4HVXC

MPEG-4 HVXC. The flags field contains the MPEG-4 audio object type constant listed in MPEG-4 Audio Object Type Constants indicating the specific kind of data.

Available in Mac OS X v10.2 and later.
kAudioFormatMPEG4TwinVQ

MPEG-4 TwinVQ. The flags field contains the MPEG-4 audio object type constant listed in MPEG-4 Audio Object Type Constants indicating the specific kind of data.

Available in Mac OS X v10.2 and later.
kAudioFormatMACE3

MACE 3:1. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatMACE6

MACE 6:1. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatULaw

μLaw 2:1. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatALaw

aLaw 2:1. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatQDesign

QDesign music. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatQDesign2

QDesign2 music. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatQUALCOMM

QUALCOMM PureVoice. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatMPEGLayer1

MPEG-1/2, Layer 1 audio. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatMPEGLayer2

MPEG-1/2, Layer 2 audio. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatMPEGLayer3

MPEG-1/2, Layer 3 audio. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatDVAudio

DV Audio. Uses no flags

Available in Mac OS X v10.3 and later.
kAudioFormatVariableDurationDVAudio

Variable duration DV Audio. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatTimeCode

A stream of IOAudioTimeStamp structures. Uses the IOAudioTimeStamp flags (see Audio Time Stamp Flags and Audio Time Stamp Flag Combination Constant).

Available in Mac OS X v10.3 and later.
kAudioFormatMIDIStream

A stream of MIDIPacketList structures where the time stamps in the MIDIPacket structures are sample offsets in the stream. The mSampleRate field in the AudioStreamBasicDescription structure is used to describe how time is passed in this kind of stream and an audio unit that receives or generates this stream can use this sample rate together with the number of frames it is rendering and the sample offsets within the MIDIPacketList to define the time for any MIDI event within this list. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatParameterValueStream

A "side-chain" of Float32 data that can be fed or generated by an audio unit and that is used to send a high density of parameter value control information. An audio unit typically runs a parameter value stream at either the sample rate of the audio unit’s audio data, or some integer quotient of this (say a half or a third of the sample rate of the audio). The mSampleRate field in the AudioStreamBasicDescription structure describes this relationship. Uses no flags.

Available in Mac OS X v10.3 and later.
kAudioFormatAppleLossless

Apple Lossless. Uses no flags.

Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/
enum
{
   kAudioFormatLinearPCM               = 'lpcm',
   kAudioFormatAC3                     = 'ac-3',
   kAudioFormat60958AC3                = 'cac3',
   kAudioFormatAppleIMA4               = 'ima4',
   kAudioFormatMPEG4AAC                = 'aac ',
   kAudioFormatMPEG4CELP               = 'celp',
   kAudioFormatMPEG4HVXC               = 'hvxc',
   kAudioFormatMPEG4TwinVQ             = 'twvq',
   kAudioFormatMACE3                   = 'MAC3',
   kAudioFormatMACE6                   = 'MAC6',
   kAudioFormatULaw                    = 'ulaw',
   kAudioFormatALaw                    = 'alaw',
   kAudioFormatQDesign                 = 'QDMC',
   kAudioFormatQDesign2                = 'QDM2',
   kAudioFormatQUALCOMM                = 'Qclp',
   kAudioFormatMPEGLayer1              = '.mp1',
   kAudioFormatMPEGLayer2              = '.mp2',
   kAudioFormatMPEGLayer3              = '.mp3',
   kAudioFormatDVAudio                 = 'dvca',
   kAudioFormatVariableDurationDVAudio = 'vdva',
   kAudioFormatTimeCode                = 'time',
   kAudioFormatMIDIStream              = 'midi',
   kAudioFormatParameterValueStream    = 'apvs',
   kAudioFormatAppleLossless           = 'alac'
};

/*AudioChannelLabel Constants


These constants are for use in the mChannelLabel field of an AudioChannelDescription structure. 
enum { 
    kAudioChannelLabel_Unknown = 0xFFFFFFFF, // unknown or unspecified other use 
    kAudioChannelLabel_Unused = 0, // channel is present, but has no intended use or destination 
    kAudioChannelLabel_UseCoordinates = 100, // channel is described by the mCoordinates fields.  
    kAudioChannelLabel_Left = 1, 
    kAudioChannelLabel_Right = 2, 
    kAudioChannelLabel_Center = 3, 
    kAudioChannelLabel_LFEScreen = 4, 
    kAudioChannelLabel_LeftSurround = 5, // WAVE: "Back Left" 
    kAudioChannelLabel_RightSurround = 6, // WAVE: "Back Right" 
    kAudioChannelLabel_LeftCenter = 7, 
    kAudioChannelLabel_RightCenter = 8, 
    kAudioChannelLabel_CenterSurround = 9, // WAVE: "Back Center" or plain "Rear Surround" 
    kAudioChannelLabel_LeftSurroundDirect = 10, // WAVE: "Side Left" 
    kAudioChannelLabel_RightSurroundDirect = 11, // WAVE: "Side Right" 
    kAudioChannelLabel_TopCenterSurround = 12, 
    kAudioChannelLabel_VerticalHeightLeft = 13, // WAVE: "Top Front Left" 
    kAudioChannelLabel_VerticalHeightCenter = 14, // WAVE: "Top Front Center" 
    kAudioChannelLabel_VerticalHeightRight = 15, // WAVE: "Top Front Right"  
    kAudioChannelLabel_TopBackLeft = 16, 
    kAudioChannelLabel_TopBackCenter = 17, 
    kAudioChannelLabel_TopBackRight = 18,  
    kAudioChannelLabel_RearSurroundLeft = 33, 
    kAudioChannelLabel_RearSurroundRight = 34, 
    kAudioChannelLabel_LeftWide = 35, 
    kAudioChannelLabel_RightWide = 36, 
    kAudioChannelLabel_LFE2 = 37, 
    kAudioChannelLabel_LeftTotal = 38, // matrix encoded 4 channels 
    kAudioChannelLabel_RightTotal = 39, // matrix encoded 4 channels 
    kAudioChannelLabel_HearingImpaired = 40, 
    kAudioChannelLabel_Narration = 41, 
    kAudioChannelLabel_Mono = 42, 
    kAudioChannelLabel_DialogCentricMix = 43,  
    kAudioChannelLabel_CenterSurroundDirect = 44, // back center, non diffuse  
    // first order ambisonic channels 
    kAudioChannelLabel_Ambisonic_W = 200, 
    kAudioChannelLabel_Ambisonic_X = 201, 
    kAudioChannelLabel_Ambisonic_Y = 202, 
    kAudioChannelLabel_Ambisonic_Z = 203,  
    // Mid/Side Recording 
    kAudioChannelLabel_MS_Mid = 204, 
    kAudioChannelLabel_MS_Side = 205,  
    // X-Y Recording 
    kAudioChannelLabel_XY_X = 206, 
    kAudioChannelLabel_XY_Y = 207,  
    // other 
    kAudioChannelLabel_HeadphonesLeft = 301, 
    kAudioChannelLabel_HeadphonesRight = 302, 
    kAudioChannelLabel_ClickTrack = 304, 
    kAudioChannelLabel_ForeignLanguage = 305,  
    // generic discrete channel 
    kAudioChannelLabel_Discrete = 400,  
    // numbered discrete channel 
    kAudioChannelLabel_Discrete_0 = (
        1L<<16) | 0, 
    kAudioChannelLabel_Discrete_1 = (
        1L<<16) | 1, 
    kAudioChannelLabel_Discrete_2 = (
        1L<<16) | 2, 
    kAudioChannelLabel_Discrete_3 = (
        1L<<16) | 3, 
    kAudioChannelLabel_Discrete_4 = (
        1L<<16) | 4, 
    kAudioChannelLabel_Discrete_5 = (
        1L<<16) | 5, 
    kAudioChannelLabel_Discrete_6 = (
        1L<<16) | 6, 
    kAudioChannelLabel_Discrete_7 = (
        1L<<16) | 7, 
    kAudioChannelLabel_Discrete_8 = (
        1L<<16) | 8, 
    kAudioChannelLabel_Discrete_9 = (
        1L<<16) | 9, 
    kAudioChannelLabel_Discrete_10 = (
        1L<<16) | 10, 
    kAudioChannelLabel_Discrete_11 = (
        1L<<16) | 11, 
    kAudioChannelLabel_Discrete_12 = (
        1L<<16) | 12, 
    kAudioChannelLabel_Discrete_13 = (
        1L<<16) | 13, 
    kAudioChannelLabel_Discrete_14 = (
        1L<<16) | 14, 
    kAudioChannelLabel_Discrete_15 = (
        1L<<16) | 15, 
    kAudioChannelLabel_Discrete_65535 = (
        1L<<16) | 65535 
};  
Discussion 

These channel labels attempt to list all labels in common use. Due to the ambiguities in channel labeling by various groups, there may be some overlap or duplication in the labels below. Use the label which most clearly describes what you mean. 

WAVE files seem to follow the USB spec for the channel flags. A channel map lets you put these channels in any order, however a WAVE file only supports labels 1-18 and if present, they must be in the order given below. The integer values for the labels below match the bit position of the label in the USB bitmap and thus also the WAVE file bitmap*/
enum { 
    kAudioChannelLabel_Unknown = 0xFFFFFFFF, // unknown or unspecified other use 
    kAudioChannelLabel_Unused = 0, // channel is present, but has no intended use or destination 
    kAudioChannelLabel_UseCoordinates = 100, // channel is described by the mCoordinates fields.  
    kAudioChannelLabel_Left = 1, 
    kAudioChannelLabel_Right = 2, 
    kAudioChannelLabel_Center = 3, 
    kAudioChannelLabel_LFEScreen = 4, 
    kAudioChannelLabel_LeftSurround = 5, // WAVE: "Back Left" 
    kAudioChannelLabel_RightSurround = 6, // WAVE: "Back Right" 
    kAudioChannelLabel_LeftCenter = 7, 
    kAudioChannelLabel_RightCenter = 8, 
    kAudioChannelLabel_CenterSurround = 9, // WAVE: "Back Center" or plain "Rear Surround" 
    kAudioChannelLabel_LeftSurroundDirect = 10, // WAVE: "Side Left" 
    kAudioChannelLabel_RightSurroundDirect = 11, // WAVE: "Side Right" 
    kAudioChannelLabel_TopCenterSurround = 12, 
    kAudioChannelLabel_VerticalHeightLeft = 13, // WAVE: "Top Front Left" 
    kAudioChannelLabel_VerticalHeightCenter = 14, // WAVE: "Top Front Center" 
    kAudioChannelLabel_VerticalHeightRight = 15, // WAVE: "Top Front Right"  
    kAudioChannelLabel_TopBackLeft = 16, 
    kAudioChannelLabel_TopBackCenter = 17, 
    kAudioChannelLabel_TopBackRight = 18,  
    kAudioChannelLabel_RearSurroundLeft = 33, 
    kAudioChannelLabel_RearSurroundRight = 34, 
    kAudioChannelLabel_LeftWide = 35, 
    kAudioChannelLabel_RightWide = 36, 
    kAudioChannelLabel_LFE2 = 37, 
    kAudioChannelLabel_LeftTotal = 38, // matrix encoded 4 channels 
    kAudioChannelLabel_RightTotal = 39, // matrix encoded 4 channels 
    kAudioChannelLabel_HearingImpaired = 40, 
    kAudioChannelLabel_Narration = 41, 
    kAudioChannelLabel_Mono = 42, 
    kAudioChannelLabel_DialogCentricMix = 43,  
    kAudioChannelLabel_CenterSurroundDirect = 44, // back center, non diffuse  
    // first order ambisonic channels 
    kAudioChannelLabel_Ambisonic_W = 200, 
    kAudioChannelLabel_Ambisonic_X = 201, 
    kAudioChannelLabel_Ambisonic_Y = 202, 
    kAudioChannelLabel_Ambisonic_Z = 203,  
    // Mid/Side Recording 
    kAudioChannelLabel_MS_Mid = 204, 
    kAudioChannelLabel_MS_Side = 205,  
    // X-Y Recording 
    kAudioChannelLabel_XY_X = 206, 
    kAudioChannelLabel_XY_Y = 207,  
    // other 
    kAudioChannelLabel_HeadphonesLeft = 301, 
    kAudioChannelLabel_HeadphonesRight = 302, 
    kAudioChannelLabel_ClickTrack = 304, 
    kAudioChannelLabel_ForeignLanguage = 305,  
    // generic discrete channel 
    kAudioChannelLabel_Discrete = 400,  
    // numbered discrete channel 
    kAudioChannelLabel_Discrete_0 = (
        1L<<16) | 0, 
    kAudioChannelLabel_Discrete_1 = (
        1L<<16) | 1, 
    kAudioChannelLabel_Discrete_2 = (
        1L<<16) | 2, 
    kAudioChannelLabel_Discrete_3 = (
        1L<<16) | 3, 
    kAudioChannelLabel_Discrete_4 = (
        1L<<16) | 4, 
    kAudioChannelLabel_Discrete_5 = (
        1L<<16) | 5, 
    kAudioChannelLabel_Discrete_6 = (
        1L<<16) | 6, 
    kAudioChannelLabel_Discrete_7 = (
        1L<<16) | 7, 
    kAudioChannelLabel_Discrete_8 = (
        1L<<16) | 8, 
    kAudioChannelLabel_Discrete_9 = (
        1L<<16) | 9, 
    kAudioChannelLabel_Discrete_10 = (
        1L<<16) | 10, 
    kAudioChannelLabel_Discrete_11 = (
        1L<<16) | 11, 
    kAudioChannelLabel_Discrete_12 = (
        1L<<16) | 12, 
    kAudioChannelLabel_Discrete_13 = (
        1L<<16) | 13, 
    kAudioChannelLabel_Discrete_14 = (
        1L<<16) | 14, 
    kAudioChannelLabel_Discrete_15 = (
        1L<<16) | 15, 
    kAudioChannelLabel_Discrete_65535 = (
        1L<<16) | 65535 
};

/*SMPTETime

SMPTE time is a format used to sync audio and video streams, based on video framing.

typedef struct SMPTETime {
UInt64 mCounter;
UInt32 mType;
UInt32 mFlags;
SInt16 mHours;
SInt16 mMinutes;
SInt16 mSeconds;
SInt16 mFrames;
} SMPTETime;
Availability
Available in Mac OS X v10.0 and later.
In this section:

SMPTE Types 
SMPTE Time Stamps*/
typedef struct SMPTETime {
UInt64 mCounter;
UInt32 mType;
UInt32 mFlags;
SInt16 mHours;
SInt16 mMinutes;
SInt16 mSeconds;
SInt16 mFrames;
} SMPTETime;


/*AudioTimeStamp

Encapsulates time stamp information in various formats.

typedef struct AudioTimeStamp {
Float64 mSampleTime;
UInt64 mHostTime;
Float64 mRateScalar;
UInt64 mWordClockTime;
SMPTETime mSMPTETime;
UInt32 mFlags;
UInt32 mReserved;
} AudioTimeStamp;
Availability
Available in Mac OS X v10.0 and later.*/
 struct AudioTimeStamp {
Float64 mSampleTime;
UInt64 mHostTime;
Float64 mRateScalar;
UInt64 mWordClockTime;
SMPTETime mSMPTETime;
UInt32 mFlags;
UInt32 mReserved;
};
typedef struct AudioTimeStamp   AudioTimeStamp;


/*AudioStreamPacketDescription

typedef struct AudioStreamPacketDescription {
SInt64 mStartOffset;
UInt64 mLength;
} AudioStreamPacketDescription;
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct AudioStreamPacketDescription {
SInt64 mStartOffset;
UInt64 mLength;
int mDataByteSize; //hys
int mVariableFramesInPacket; //hys
} AudioStreamPacketDescription;

/*AudioChannelLayoutTag


These constants are used in the mChannelLayoutTag field of an AudioChannelLayout structure. 
enum { 
    // Some channel abbreviations used below: 
    // L - left 
    // R - right 
    // C - center 
    // Ls - left surround 
    // Rs - right surround 
    // Cs - center surround 
    // Rls - rear left surround 
    // Rrs - rear right surround 
    // Lw - left wide 
    // Rw - right wide 
    // Lsd - left surround direct 
    // Rsd - right surround direct 
    // Lc - left center 
    // Rc - right center 
    // Ts - top surround 
    // Vhl - vertical height left 
    // Vhc - vertical height center 
    // Vhr - vertical height right 
    // Lt - left matrix total. for matrix encoded stereo. 
    // Rt - right matrix total. for matrix encoded stereo.  
    // General layouts 
    kAudioChannelLayoutTag_UseChannelDescriptions = (
        0L<<16) | 0, // use the array of AudioChannelDescriptions to define the mapping. 
    kAudioChannelLayoutTag_UseChannelBitmap = (
        1L<<16) | 0, // use the bitmap to define the mapping.  
    kAudioChannelLayoutTag_Mono = (
        100L<<16) | 1, // a standard mono stream 
    kAudioChannelLayoutTag_Stereo = (
        101L<<16) | 2, // a standard stereo stream (L R) - implied playback 
    kAudioChannelLayoutTag_StereoHeadphones = (
        102L<<16) | 2, // a standard stereo stream (L R) - implied headphone playbac 
    kAudioChannelLayoutTag_MatrixStereo = (
        103L<<16) | 2, // a matrix encoded stereo stream (Lt, Rt) 
    kAudioChannelLayoutTag_MidSide = (
        104L<<16) | 2, // mid/side recording 
    kAudioChannelLayoutTag_XY = (
        105L<<16) | 2, // coincident mic pair (often 2 figure 8's) 
    kAudioChannelLayoutTag_Binaural = (
        106L<<16) | 2, // binaural stereo (left, right) 
    kAudioChannelLayoutTag_Ambisonic_B_Format = (
        107L<<16) | 4, // W, X, Y, Z  
    kAudioChannelLayoutTag_Quadraphonic = (
        108L<<16) | 4, // front left, front right, back left, back right  
    kAudioChannelLayoutTag_Pentagonal = (
        109L<<16) | 5, // left, right, rear left, rear right, center  
    kAudioChannelLayoutTag_Hexagonal = (
        110L<<16) | 6, // left, right, rear left, rear right, center, rear  
    kAudioChannelLayoutTag_Octagonal = (
        111L<<16) | 8, // front left, front right, rear left, rear right, 
    // front center, rear center, side left, side right  
    kAudioChannelLayoutTag_Cube = (
        112L<<16) | 8, // left, right, rear left, rear right 
    // top left, top right, top rear left, top rear right  
    // MPEG defined layouts 
    kAudioChannelLayoutTag_MPEG_1_0 = kAudioChannelLayoutTag_Mono, // C 
    kAudioChannelLayoutTag_MPEG_2_0 = kAudioChannelLayoutTag_Stereo, // L R 
    kAudioChannelLayoutTag_MPEG_3_0_A = (
        113L<<16) | 3, // L R C 
    kAudioChannelLayoutTag_MPEG_3_0_B = (
        114L<<16) | 3, // C L R 
    kAudioChannelLayoutTag_MPEG_4_0_A = (
        115L<<16) | 4, // L R C Cs 
    kAudioChannelLayoutTag_MPEG_4_0_B = (
        116L<<16) | 4, // C L R Cs 
    kAudioChannelLayoutTag_MPEG_5_0_A = (
        117L<<16) | 5, // L R C Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_0_B = (
        118L<<16) | 5, // L R Ls Rs C 
    kAudioChannelLayoutTag_MPEG_5_0_C = (
        119L<<16) | 5, // L C R Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_0_D = (
        120L<<16) | 5, // C L R Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_1_A = (
        121L<<16) | 6, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_1_B = (
        122L<<16) | 6, // L R Ls Rs C LFE 
    kAudioChannelLayoutTag_MPEG_5_1_C = (
        123L<<16) | 6, // L C R Ls Rs LFE 
    kAudioChannelLayoutTag_MPEG_5_1_D = (
        124L<<16) | 6, // C L R Ls Rs LFE 
    kAudioChannelLayoutTag_MPEG_6_1_A = (
        125L<<16) | 7, // L R C LFE Ls Rs Cs 
    kAudioChannelLayoutTag_MPEG_7_1_A = (
        126L<<16) | 8, // L R C LFE Ls Rs Lc Rc 
    kAudioChannelLayoutTag_MPEG_7_1_B = (
        127L<<16) | 8, // C Lc Rc L R Ls Rs LFE (doc: IS-13818-7 MPEG2-AAC Table 3.1) 
    kAudioChannelLayoutTag_MPEG_7_1_C = (
        128L<<16) | 8, // L R C LFE Ls R Rls Rrs 
    kAudioChannelLayoutTag_Emagic_Default_7_1 = (
        129L<<16) | 8, // L R Ls Rs C LFE Lc Rc 
    kAudioChannelLayoutTag_SMPTE_DTV = (
        130L<<16) | 8, // L R C LFE Ls Rs Lt Rt 
    // (kAudioChannelLayoutTag_ITU_5_1 plus a matrix encoded stereo mix)  
    // ITU defined layouts 
    kAudioChannelLayoutTag_ITU_1_0 = kAudioChannelLayoutTag_Mono, // C 
    kAudioChannelLayoutTag_ITU_2_0 = kAudioChannelLayoutTag_Stereo, // L R  
    kAudioChannelLayoutTag_ITU_2_1 = (
        131L<<16) | 3, // L R Cs 
    kAudioChannelLayoutTag_ITU_2_2 = (
        132L<<16) | 4, // L R Ls Rs 
    kAudioChannelLayoutTag_ITU_3_0 = kAudioChannelLayoutTag_MPEG_3_0_A, // L R C 
    kAudioChannelLayoutTag_ITU_3_1 = kAudioChannelLayoutTag_MPEG_4_0_A, // L R C Cs  
    kAudioChannelLayoutTag_ITU_3_2 = kAudioChannelLayoutTag_MPEG_5_0_A, // L R C Ls Rs 
    kAudioChannelLayoutTag_ITU_3_2_1 = kAudioChannelLayoutTag_MPEG_5_1_A, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_ITU_3_4_1 = kAudioChannelLayoutTag_MPEG_7_1_C, // L R C LFE Ls Rs Rls Rrs  
    // DVD defined layouts 
    kAudioChannelLayoutTag_DVD_0 = kAudioChannelLayoutTag_Mono, // C (mono) 
    kAudioChannelLayoutTag_DVD_1 = kAudioChannelLayoutTag_Stereo, // L R 
    kAudioChannelLayoutTag_DVD_2 = kAudioChannelLayoutTag_ITU_2_1, // L R Cs 
    kAudioChannelLayoutTag_DVD_3 = kAudioChannelLayoutTag_ITU_2_2, // L R Ls Rs 
    kAudioChannelLayoutTag_DVD_4 = (
        133L<<16) | 3, // L R LFE 
    kAudioChannelLayoutTag_DVD_5 = (
        134L<<16) | 4, // L R LFE Cs 
    kAudioChannelLayoutTag_DVD_6 = (
        135L<<16) | 5, // L R LFE Ls Rs 
    kAudioChannelLayoutTag_DVD_7 = kAudioChannelLayoutTag_MPEG_3_0_A, // L R C 
    kAudioChannelLayoutTag_DVD_8 = kAudioChannelLayoutTag_MPEG_4_0_A, // L R C Cs 
    kAudioChannelLayoutTag_DVD_9 = kAudioChannelLayoutTag_MPEG_5_0_A, // L R C Ls Rs 
    kAudioChannelLayoutTag_DVD_10 = (
        136L<<16) | 4, // L R C LFE 
    kAudioChannelLayoutTag_DVD_11 = (
        137L<<16) | 5, // L R C LFE Cs 
    kAudioChannelLayoutTag_DVD_12 = kAudioChannelLayoutTag_MPEG_5_1_A, // L R C LFE Ls Rs 
    // 13 through 17 are duplicates of 8 through 12. 
    kAudioChannelLayoutTag_DVD_13 = kAudioChannelLayoutTag_DVD_8, // L R C Cs 
    kAudioChannelLayoutTag_DVD_14 = kAudioChannelLayoutTag_DVD_9, // L R C Ls Rs 
    kAudioChannelLayoutTag_DVD_15 = kAudioChannelLayoutTag_DVD_10, // L R C LFE 
    kAudioChannelLayoutTag_DVD_16 = kAudioChannelLayoutTag_DVD_11, // L R C LFE Cs 
    kAudioChannelLayoutTag_DVD_17 = kAudioChannelLayoutTag_DVD_12, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_DVD_18 = (
        138L<<16) | 5, // L R Ls Rs LFE 
    kAudioChannelLayoutTag_DVD_19 = kAudioChannelLayoutTag_MPEG_5_0_B, // L R Ls Rs C 
    kAudioChannelLayoutTag_DVD_20 = kAudioChannelLayoutTag_MPEG_5_1_B, // L R Ls Rs C LFE  
    // These layouts are recommended for AudioUnit usage 
    // These are the symmetrical layouts 
    kAudioChannelLayoutTag_AudioUnit_4 = kAudioChannelLayoutTag_Quadraphonic, 
    kAudioChannelLayoutTag_AudioUnit_5 = kAudioChannelLayoutTag_Pentagonal, 
    kAudioChannelLayoutTag_AudioUnit_6 = kAudioChannelLayoutTag_Hexagonal, 
    kAudioChannelLayoutTag_AudioUnit_8 = kAudioChannelLayoutTag_Octagonal, 
    // These are the surround-based layouts 
    kAudioChannelLayoutTag_AudioUnit_5_0 = kAudioChannelLayoutTag_MPEG_5_0_B, // L R Ls Rs C 
    kAudioChannelLayoutTag_AudioUnit_6_0 = (
        139L<<16) | 6, // L R Ls Rs C Cs 
    kAudioChannelLayoutTag_AudioUnit_7_0 = (
        140L<<16) | 7, // L R Ls Rs C Rls Rrs 
    kAudioChannelLayoutTag_AudioUnit_5_1 = kAudioChannelLayoutTag_MPEG_5_1_A, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_AudioUnit_6_1 = kAudioChannelLayoutTag_MPEG_6_1_A, // L R C LFE Ls Rs Cs 
    kAudioChannelLayoutTag_AudioUnit_7_1 = kAudioChannelLayoutTag_MPEG_7_1_C, // L R C LFE Ls Rs Rls Rrs  
    kAudioChannelLayoutTag_AAC_Quadraphonic = kAudioChannelLayoutTag_Quadraphonic, // L R Ls Rs 
    kAudioChannelLayoutTag_AAC_4_0 = kAudioChannelLayoutTag_MPEG_4_0_B, // C L R Cs 
    kAudioChannelLayoutTag_AAC_5_0 = kAudioChannelLayoutTag_MPEG_5_0_D, // C L R Ls Rs 
    kAudioChannelLayoutTag_AAC_5_1 = kAudioChannelLayoutTag_MPEG_5_1_D, // C L R Ls Rs Lfe 
    kAudioChannelLayoutTag_AAC_6_0 = (
        141L<<16) | 6, // C L R Ls Rs Cs 
    kAudioChannelLayoutTag_AAC_6_1 = (
        142L<<16) | 7, // C L R Ls Rs Cs Lfe 
    kAudioChannelLayoutTag_AAC_7_0 = (
        143L<<16) | 7, // C L R Ls Rs Rls Rrs 
    kAudioChannelLayoutTag_AAC_7_1 = kAudioChannelLayoutTag_MPEG_7_1_B, // C Lc Rc L R Ls Rs Lfe 
    kAudioChannelLayoutTag_AAC_Octagonal = (
        144L<<16) | 8, // C L R Ls Rs Rls Rrs Cs  
    kAudioChannelLayoutTag_TMH_10_2_std = (
        145L<<16) | 16, // L R C Vhc Lsd Rsd Ls Rs Vhl Vhr Lw Rw Csd Cs LFE1 LFE2 
    kAudioChannelLayoutTag_TMH_10_2_full = (
        146L<<16) | 21, // TMH_10_2_std plus: Lc Rc HI VI Haptic  
    kAudioChannelLayoutTag_DiscreteInOrder = (
        147L<<16) | 0 // needs to be ORed with the actual number of channels 
};  
Discussion 

Constants*/
enum { 
    // Some channel abbreviations used below: 
    // L - left 
    // R - right 
    // C - center 
    // Ls - left surround 
    // Rs - right surround 
    // Cs - center surround 
    // Rls - rear left surround 
    // Rrs - rear right surround 
    // Lw - left wide 
    // Rw - right wide 
    // Lsd - left surround direct 
    // Rsd - right surround direct 
    // Lc - left center 
    // Rc - right center 
    // Ts - top surround 
    // Vhl - vertical height left 
    // Vhc - vertical height center 
    // Vhr - vertical height right 
    // Lt - left matrix total. for matrix encoded stereo. 
    // Rt - right matrix total. for matrix encoded stereo.  
    // General layouts 
    kAudioChannelLayoutTag_UseChannelDescriptions = (
        0L<<16) | 0, // use the array of AudioChannelDescriptions to define the mapping. 
    kAudioChannelLayoutTag_UseChannelBitmap = (
        1L<<16) | 0, // use the bitmap to define the mapping.  
    kAudioChannelLayoutTag_Mono = (
        100L<<16) | 1, // a standard mono stream 
    kAudioChannelLayoutTag_Stereo = (
        101L<<16) | 2, // a standard stereo stream (L R) - implied playback 
    kAudioChannelLayoutTag_StereoHeadphones = (
        102L<<16) | 2, // a standard stereo stream (L R) - implied headphone playbac 
    kAudioChannelLayoutTag_MatrixStereo = (
        103L<<16) | 2, // a matrix encoded stereo stream (Lt, Rt) 
    kAudioChannelLayoutTag_MidSide = (
        104L<<16) | 2, // mid/side recording 
    kAudioChannelLayoutTag_XY = (
        105L<<16) | 2, // coincident mic pair (often 2 figure 8's) 
    kAudioChannelLayoutTag_Binaural = (
        106L<<16) | 2, // binaural stereo (left, right) 
    kAudioChannelLayoutTag_Ambisonic_B_Format = (
        107L<<16) | 4, // W, X, Y, Z  
    kAudioChannelLayoutTag_Quadraphonic = (
        108L<<16) | 4, // front left, front right, back left, back right  
    kAudioChannelLayoutTag_Pentagonal = (
        109L<<16) | 5, // left, right, rear left, rear right, center  
    kAudioChannelLayoutTag_Hexagonal = (
        110L<<16) | 6, // left, right, rear left, rear right, center, rear  
    kAudioChannelLayoutTag_Octagonal = (
        111L<<16) | 8, // front left, front right, rear left, rear right, 
    // front center, rear center, side left, side right  
    kAudioChannelLayoutTag_Cube = (
        112L<<16) | 8, // left, right, rear left, rear right 
    // top left, top right, top rear left, top rear right  
    // MPEG defined layouts 
    kAudioChannelLayoutTag_MPEG_1_0 = kAudioChannelLayoutTag_Mono, // C 
    kAudioChannelLayoutTag_MPEG_2_0 = kAudioChannelLayoutTag_Stereo, // L R 
    kAudioChannelLayoutTag_MPEG_3_0_A = (
        113L<<16) | 3, // L R C 
    kAudioChannelLayoutTag_MPEG_3_0_B = (
        114L<<16) | 3, // C L R 
    kAudioChannelLayoutTag_MPEG_4_0_A = (
        115L<<16) | 4, // L R C Cs 
    kAudioChannelLayoutTag_MPEG_4_0_B = (
        116L<<16) | 4, // C L R Cs 
    kAudioChannelLayoutTag_MPEG_5_0_A = (
        117L<<16) | 5, // L R C Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_0_B = (
        118L<<16) | 5, // L R Ls Rs C 
    kAudioChannelLayoutTag_MPEG_5_0_C = (
        119L<<16) | 5, // L C R Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_0_D = (
        120L<<16) | 5, // C L R Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_1_A = (
        121L<<16) | 6, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_MPEG_5_1_B = (
        122L<<16) | 6, // L R Ls Rs C LFE 
    kAudioChannelLayoutTag_MPEG_5_1_C = (
        123L<<16) | 6, // L C R Ls Rs LFE 
    kAudioChannelLayoutTag_MPEG_5_1_D = (
        124L<<16) | 6, // C L R Ls Rs LFE 
    kAudioChannelLayoutTag_MPEG_6_1_A = (
        125L<<16) | 7, // L R C LFE Ls Rs Cs 
    kAudioChannelLayoutTag_MPEG_7_1_A = (
        126L<<16) | 8, // L R C LFE Ls Rs Lc Rc 
    kAudioChannelLayoutTag_MPEG_7_1_B = (
        127L<<16) | 8, // C Lc Rc L R Ls Rs LFE (doc: IS-13818-7 MPEG2-AAC Table 3.1) 
    kAudioChannelLayoutTag_MPEG_7_1_C = (
        128L<<16) | 8, // L R C LFE Ls R Rls Rrs 
    kAudioChannelLayoutTag_Emagic_Default_7_1 = (
        129L<<16) | 8, // L R Ls Rs C LFE Lc Rc 
    kAudioChannelLayoutTag_SMPTE_DTV = (
        130L<<16) | 8, // L R C LFE Ls Rs Lt Rt 
    // (kAudioChannelLayoutTag_ITU_5_1 plus a matrix encoded stereo mix)  
    // ITU defined layouts 
    kAudioChannelLayoutTag_ITU_1_0 = kAudioChannelLayoutTag_Mono, // C 
    kAudioChannelLayoutTag_ITU_2_0 = kAudioChannelLayoutTag_Stereo, // L R  
    kAudioChannelLayoutTag_ITU_2_1 = (
        131L<<16) | 3, // L R Cs 
    kAudioChannelLayoutTag_ITU_2_2 = (
        132L<<16) | 4, // L R Ls Rs 
    kAudioChannelLayoutTag_ITU_3_0 = kAudioChannelLayoutTag_MPEG_3_0_A, // L R C 
    kAudioChannelLayoutTag_ITU_3_1 = kAudioChannelLayoutTag_MPEG_4_0_A, // L R C Cs  
    kAudioChannelLayoutTag_ITU_3_2 = kAudioChannelLayoutTag_MPEG_5_0_A, // L R C Ls Rs 
    kAudioChannelLayoutTag_ITU_3_2_1 = kAudioChannelLayoutTag_MPEG_5_1_A, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_ITU_3_4_1 = kAudioChannelLayoutTag_MPEG_7_1_C, // L R C LFE Ls Rs Rls Rrs  
    // DVD defined layouts 
    kAudioChannelLayoutTag_DVD_0 = kAudioChannelLayoutTag_Mono, // C (mono) 
    kAudioChannelLayoutTag_DVD_1 = kAudioChannelLayoutTag_Stereo, // L R 
    kAudioChannelLayoutTag_DVD_2 = kAudioChannelLayoutTag_ITU_2_1, // L R Cs 
    kAudioChannelLayoutTag_DVD_3 = kAudioChannelLayoutTag_ITU_2_2, // L R Ls Rs 
    kAudioChannelLayoutTag_DVD_4 = (
        133L<<16) | 3, // L R LFE 
    kAudioChannelLayoutTag_DVD_5 = (
        134L<<16) | 4, // L R LFE Cs 
    kAudioChannelLayoutTag_DVD_6 = (
        135L<<16) | 5, // L R LFE Ls Rs 
    kAudioChannelLayoutTag_DVD_7 = kAudioChannelLayoutTag_MPEG_3_0_A, // L R C 
    kAudioChannelLayoutTag_DVD_8 = kAudioChannelLayoutTag_MPEG_4_0_A, // L R C Cs 
    kAudioChannelLayoutTag_DVD_9 = kAudioChannelLayoutTag_MPEG_5_0_A, // L R C Ls Rs 
    kAudioChannelLayoutTag_DVD_10 = (
        136L<<16) | 4, // L R C LFE 
    kAudioChannelLayoutTag_DVD_11 = (
        137L<<16) | 5, // L R C LFE Cs 
    kAudioChannelLayoutTag_DVD_12 = kAudioChannelLayoutTag_MPEG_5_1_A, // L R C LFE Ls Rs 
    // 13 through 17 are duplicates of 8 through 12. 
    kAudioChannelLayoutTag_DVD_13 = kAudioChannelLayoutTag_DVD_8, // L R C Cs 
    kAudioChannelLayoutTag_DVD_14 = kAudioChannelLayoutTag_DVD_9, // L R C Ls Rs 
    kAudioChannelLayoutTag_DVD_15 = kAudioChannelLayoutTag_DVD_10, // L R C LFE 
    kAudioChannelLayoutTag_DVD_16 = kAudioChannelLayoutTag_DVD_11, // L R C LFE Cs 
    kAudioChannelLayoutTag_DVD_17 = kAudioChannelLayoutTag_DVD_12, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_DVD_18 = (
        138L<<16) | 5, // L R Ls Rs LFE 
    kAudioChannelLayoutTag_DVD_19 = kAudioChannelLayoutTag_MPEG_5_0_B, // L R Ls Rs C 
    kAudioChannelLayoutTag_DVD_20 = kAudioChannelLayoutTag_MPEG_5_1_B, // L R Ls Rs C LFE  
    // These layouts are recommended for AudioUnit usage 
    // These are the symmetrical layouts 
    kAudioChannelLayoutTag_AudioUnit_4 = kAudioChannelLayoutTag_Quadraphonic, 
    kAudioChannelLayoutTag_AudioUnit_5 = kAudioChannelLayoutTag_Pentagonal, 
    kAudioChannelLayoutTag_AudioUnit_6 = kAudioChannelLayoutTag_Hexagonal, 
    kAudioChannelLayoutTag_AudioUnit_8 = kAudioChannelLayoutTag_Octagonal, 
    // These are the surround-based layouts 
    kAudioChannelLayoutTag_AudioUnit_5_0 = kAudioChannelLayoutTag_MPEG_5_0_B, // L R Ls Rs C 
    kAudioChannelLayoutTag_AudioUnit_6_0 = (
        139L<<16) | 6, // L R Ls Rs C Cs 
    kAudioChannelLayoutTag_AudioUnit_7_0 = (
        140L<<16) | 7, // L R Ls Rs C Rls Rrs 
    kAudioChannelLayoutTag_AudioUnit_5_1 = kAudioChannelLayoutTag_MPEG_5_1_A, // L R C LFE Ls Rs 
    kAudioChannelLayoutTag_AudioUnit_6_1 = kAudioChannelLayoutTag_MPEG_6_1_A, // L R C LFE Ls Rs Cs 
    kAudioChannelLayoutTag_AudioUnit_7_1 = kAudioChannelLayoutTag_MPEG_7_1_C, // L R C LFE Ls Rs Rls Rrs  
    kAudioChannelLayoutTag_AAC_Quadraphonic = kAudioChannelLayoutTag_Quadraphonic, // L R Ls Rs 
    kAudioChannelLayoutTag_AAC_4_0 = kAudioChannelLayoutTag_MPEG_4_0_B, // C L R Cs 
    kAudioChannelLayoutTag_AAC_5_0 = kAudioChannelLayoutTag_MPEG_5_0_D, // C L R Ls Rs 
    kAudioChannelLayoutTag_AAC_5_1 = kAudioChannelLayoutTag_MPEG_5_1_D, // C L R Ls Rs Lfe 
    kAudioChannelLayoutTag_AAC_6_0 = (
        141L<<16) | 6, // C L R Ls Rs Cs 
    kAudioChannelLayoutTag_AAC_6_1 = (
        142L<<16) | 7, // C L R Ls Rs Cs Lfe 
    kAudioChannelLayoutTag_AAC_7_0 = (
        143L<<16) | 7, // C L R Ls Rs Rls Rrs 
    kAudioChannelLayoutTag_AAC_7_1 = kAudioChannelLayoutTag_MPEG_7_1_B, // C Lc Rc L R Ls Rs Lfe 
    kAudioChannelLayoutTag_AAC_Octagonal = (
        144L<<16) | 8, // C L R Ls Rs Rls Rrs Cs  
    kAudioChannelLayoutTag_TMH_10_2_std = (
        145L<<16) | 16, // L R C Vhc Lsd Rsd Ls Rs Vhl Vhr Lw Rw Csd Cs LFE1 LFE2 
    kAudioChannelLayoutTag_TMH_10_2_full = (
        146L<<16) | 21, // TMH_10_2_std plus: Lc Rc HI VI Haptic  
    kAudioChannelLayoutTag_DiscreteInOrder = (
        147L<<16) | 0 // needs to be ORed with the actual number of channels 
};  

/*AudioChannelLabel

A tag identifying how the channel is to be used.

typedef UInt32 AudioChannelLabel;
Discussion

This data type is used for the mChannelLabel field of the AudioChannelDescription structure. See Audio Channel Label Constants for possible values.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/
typedef UInt32 AudioChannelLabel;

/*AudioChannelDescription

Describes a single channel.

struct AudioChannelDescription
   {
   AudioChannelLabel   mChannelLabel;
   UInt32              mChannelFlags;
   Float32             mCoordinates[3];
};
typedef struct AudioChannelDescription AudioChannelDescription;
Fields
mChannelLabel

The AudioChannelLabel structure that describes the channel.
mChannelFlags

Flags that control the interpretation of mCoordinates. See Channel Coordinate Flags for possible values.
mCoordinates

An ordered triple that specifies a precise speaker location. See Channel Coordinate Index Constants for the interpretation of the items in the array.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/
struct AudioChannelDescription
   {
   AudioChannelLabel   mChannelLabel;
   UInt32              mChannelFlags;
   Float32             mCoordinates[3];
};
typedef struct AudioChannelDescription AudioChannelDescription;

/*AudioChannelLayoutTag

A tag identifying a particular pre-defined channel layout.

typedef UInt32 AudioChannelLayoutTag;
Discussion

This data type is used for the mChannelLayoutTag field of the AudioChannelLayout structure. See Audio Channel Layout Tags for possible values.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/
typedef UInt32 AudioChannelLayoutTag;

/*AudioChannelLayout

Used to specify channel layouts in files and hardware.

struct AudioChannelLayout
   {
   AudioChannelLayoutTag       mChannelLayoutTag;
   UInt32                      mChannelBitmap;
   UInt32                      mNumberChannelDescriptions;
   AudioChannelDescription     mChannelDescriptions[kVariableLengthArray];
};
typedef struct AudioChannelLayout AudioChannelLayout;
Fields
mChannelLayoutTag

The AudioChannelLayoutTag value that indicates the layout. See Audio Channel Layout Tags for possible values.
mChannelBitmap

If mChannelLayoutTag is set to kAudioChannelLayoutTag_UseChannelBitmap, this field is the channel use bitmap.
mNumberChannelDescriptions

The number of items in the mChannelDescriptions array.
mChannelDescriptions

If mChannelLayoutTag is set to kAudioChannelLayoutTag_UseChannelDescriptions, use the mChannelDescriptions field to describe the layout.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/
struct AudioChannelLayout
   {
   AudioChannelLayoutTag       mChannelLayoutTag;
   UInt32                      mChannelBitmap;
   UInt32                      mNumberChannelDescriptions;
   AudioChannelDescription     mChannelDescriptions[kVariableLengthArray];
};
typedef struct AudioChannelLayout AudioChannelLayout;


/*AudioBuffer

Holds a buffer of audio data.

struct AudioBuffer
   {
   UInt32  mNumberChannels;
   UInt32  mDataByteSize;
   void*   mData;
};
typedef struct AudioBuffer  AudioBuffer;
Fields
mNumberChannels

The number of interleaved channels in the buffer.
mDataByteSize

The number of bytes in the buffer pointed at by mData.
mData

A pointer to the buffer of audio data.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CoreAudioTypes.h*/
struct AudioBuffer
   {
   UInt32  mNumberChannels;
   UInt32  mDataByteSize;
   void*   mData;
};
typedef struct AudioBuffer  AudioBuffer;

/*AudioBufferList

Holds a variable length array of AudioBuffer structures.

struct AudioBufferList
   {
   UInt32      mNumberBuffers;
   AudioBuffer mBuffers[kVariableLengthArray];
};
typedef struct AudioBufferList  AudioBufferList;
Fields
mNumberBuffers

The number of AudioBuffer structures in the mBuffers array.
mBuffers

A variable length array of AudioBuffer structures.
Availability
Available in Mac OS X v10.0 and later.*/
struct AudioBufferList
   {
   UInt32      mNumberBuffers;
   AudioBuffer mBuffers[kVariableLengthArray];
};
typedef struct AudioBufferList  AudioBufferList;


/*AudioStreamBasicDescription

Encapsulates all the information for describing the basic format properties of a stream of audio data.

struct AudioStreamBasicDescription
   {
   Float64 mSampleRate;
   UInt32  mFormatID;
   UInt32  mFormatFlags;
   UInt32  mBytesPerPacket;
   UInt32  mFramesPerPacket;
   UInt32  mBytesPerFrame;
   UInt32  mChannelsPerFrame;
   UInt32  mBitsPerChannel;
   UInt32  mReserved;
};
typedef struct AudioStreamBasicDescription  AudioStreamBasicDescription;
Fields
mSampleRate

The number of sample frames per second of the data in the stream. For compressed formats, this field indicates the number of sample frames per second of decompressed data. You can combine this value with the frames per packet to determine the amount of time represented by a packet. This value must be nonzero, except when this structure is used in a listing of supported formats (see AudioStreamBasicDescription Constant).
mFormatID

A four character code indicating the general kind of data in the stream. See Audio Data Format IDs. This value must be nonzero.
mFormatFlags

Flags specific to each format, if any. My be set to 0 to indicate no format flags. See Audio Data Format IDs for the types of flags used with each data type.
mBytesPerPacket

The number of bytes in a packet of data. For formats with a variable packet size, this field is set to 0. In that case, the size of each packet is specified by an AudioStreamPacketDescription structure. 
mFramesPerPacket

The number of sample frames in each packet of data. For compressed formats, this field indicates the number of frames encoded in each packet. For formats with a variable number of frames per packet, this field is set to 0 and the packet is described by an AudioStreamPacketDescription structure. 
mBytesPerFrame

The number of bytes in a single sample frame of data. This field is set to 0 if the data format (for instance any compressed format) does not contain separate samples for each channel. 
mChannelsPerFrame

The number of channels in each frame of data. This value must be nonzero.
mBitsPerChannel

The number of bits of sample data for each channel in a frame of data. This field is set to 0 if the data format (for instance any compressed format) does not contain separate samples for each channel.
mReserved

Pads the structure out to force an even 8-byte alignment.
Discussion

This structure is sufficient to describe any constant bit rate format that has channels that are the same size. For variable bit rate data and for constant bit rate data where the channels have unequal sizes, each packet must additionally be described by an AudioStreamPacketDescription structure. In all fields, a value of 0 indicates that the field is either unknown, not applicable, or otherwise is inappropriate for the format and should be ignored. 

For the purposes of this data structure, the following definitions apply: 
A sample is one data value (that is, one number) for one channel of digitized audio data. 
A frame is a set of samples that includes one sample for each channel. The samples in a frame are intended to be played together (that is, simultaneously). (Note that this definition might be different from the use of the term frame by codecs, video files, and audio or video processing applications.) In non-interleaved audio, the per-frame fields in the structure apply to one channel. In interleaved audio, the per-frame fields apply to the set of n channels. 
A packet is the smallest, indivisible block of data. In uncompressed audio, each packet contains exactly one frame. In compressed audio, the number of frames in a packet depends on the encoding. For example, an AAC packet contains 1024 sample frames. In some formats, the number of frames per packet varies. 
The sample rate is the number of complete frames of samples per second of noncompressed or decompressed data.

Typically, the fields of an AudioStreamBasicDescription structure describe the complete layout of the sample data in data buffers represented by AudioBuffer structures that are contained in an AudioBufferList structure.

When an AudioStreamBasicDescription structure has the kAudioFormatFlagIsNonInterleaved flag set, however, the AudioBufferList structure is used in a different way. In this case, each AudioBuffer structure in the list contains a single (mono) channel of audio data and the AudioStreamBasicDescription structure fields describe the format of one AudioBuffer structure. The exception to this rule is the AudioStreamBasicDescription structure’s mChannelsPerFrame field, which indicates the total number of AudioBuffer structures that are contained in the AudioBufferList. This data format is used primarily by audio units and audio converters. It is not used by audio hardware.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CoreAudioTypes.h*/
struct AudioStreamBasicDescription
   {
   Float64 mSampleRate;
   UInt32  mFormatID;
   UInt32  mFormatFlags;
   UInt32  mBytesPerPacket;
   UInt32  mFramesPerPacket;
   UInt32  mBytesPerFrame;
   UInt32  mChannelsPerFrame;
   UInt32  mBitsPerChannel;
   UInt32  mReserved;
};
typedef struct AudioStreamBasicDescription  AudioStreamBasicDescription;

/*AudioStreamBasicDescription Flags

Standard flags for use in the mFormatFlags field of the AudioStreamBasicDescription structure.

enum
{
   kAudioFormatFlagIsFloat                     = (1L << 0),
   kAudioFormatFlagIsBigEndian                 = (1L << 1),
   kAudioFormatFlagIsSignedInteger             = (1L << 2),
   kAudioFormatFlagIsPacked                    = (1L << 3),
   kAudioFormatFlagIsAlignedHigh               = (1L << 4),
   kAudioFormatFlagIsNonInterleaved            = (1L << 5),
   kAudioFormatFlagIsNonMixable                = (1L << 6),
   kAudioFormatFlagsAreAllClear                = (1L << 31),
   
   kLinearPCMFormatFlagIsFloat                 = kAudioFormatFlagIsFloat,
   kLinearPCMFormatFlagIsBigEndian             = kAudioFormatFlagIsBigEndian,
   kLinearPCMFormatFlagIsSignedInteger         = kAudioFormatFlagIsSignedInteger,
   kLinearPCMFormatFlagIsPacked                = kAudioFormatFlagIsPacked,
   kLinearPCMFormatFlagIsAlignedHigh           = kAudioFormatFlagIsAlignedHigh,
   kLinearPCMFormatFlagIsNonInterleaved        = kAudioFormatFlagIsNonInterleaved,
   kLinearPCMFormatFlagIsNonMixable            = kAudioFormatFlagIsNonMixable,
   kLinearPCMFormatFlagsAreAllClear            = kAudioFormatFlagsAreAllClear,
   
   kAppleLosslessFormatFlag_16BitSourceData    = 1,
   kAppleLosslessFormatFlag_20BitSourceData    = 2,
   kAppleLosslessFormatFlag_24BitSourceData    = 3,
   kAppleLosslessFormatFlag_32BitSourceData    = 4
};
Constants
kAudioFormatFlagIsFloat

Set for floating point, clear for integer.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagIsBigEndian

Set for big endian, clear for little endian.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagIsSignedInteger

Set for signed integer, clear for unsigned integer. This is only valid if kAudioFormatFlagIsFloat is clear.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagIsPacked

Set if the sample bits occupy the entire available bits for the channel, clear if they are high- or low-aligned within the channel.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagIsAlignedHigh

Set if the sample bits are placed into the high bits of the channel, clear for low bit placement. This is only valid if kAudioFormatFlagIsPacked is clear.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagIsNonInterleaved

Set if the samples for each channel are located contiguously and the channels are laid out end to end, clear if the samples for each frame are laid out contiguously and the frames laid out end to end. This flag affects the use of the AudioStreamBasicDescription and AudioBufferList structures; see the discussion of the AudioStreamBasicDescription structure for details.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagIsNonMixable

Set to indicate when a format is nonmixable. Note that this flag is only used when interacting with the HAL's stream format information. It is not a valid flag for any other use.

Available in Mac OS X v10.3 and later.
kAudioFormatFlagsAreAllClear

Set to indicate all the flags are clear. You must use this constant instead of 0, because a 0 in the mFormatFlags field of the AudioStreamBasicDescription structure indicates that there are no format flags.

Available in Mac OS X v10.3 and later.
kLinearPCMFormatFlagIsFloat

Synonym for kAudioFormatFlagIsFloat.

Available in Mac OS X v10.0 and later.
kLinearPCMFormatFlagIsBigEndian

Synonym for kAudioFormatFlagIsBigEndian.

Available in Mac OS X v10.0 and later.
kLinearPCMFormatFlagIsSignedInteger

Synonym for kAudioFormatFlagIsSignedInteger.

Available in Mac OS X v10.0 and later.
kLinearPCMFormatFlagIsPacked

Synonym for kAudioFormatFlagIsPacked.

Available in Mac OS X v10.0 and later.
kLinearPCMFormatFlagIsAlignedHigh

Synonym for kAudioFormatFlagIsAlignedHigh.

Available in Mac OS X v10.0 and later.
kLinearPCMFormatFlagIsNonInterleaved

Synonym for kAudioFormatFlagIsNonInterleaved.

Available in Mac OS X v10.2 and later.
kLinearPCMFormatFlagIsNonMixable

Synonym for kAudioFormatFlagIsNonMixable.

Available in Mac OS X v10.3 and later.
kLinearPCMFormatFlagsAreAllClear

Synonym for kAudioFormatFlagsAreAllClear.

Available in Mac OS X v10.3 and later.
kAppleLosslessFormatFlag_16BitSourceData

This flag is set for Apple Lossless data that was sourced from 16 bit native endian signed integer data.

Available in Mac OS X v10.3 and later.
kAppleLosslessFormatFlag_20BitSourceData

Set for Apple Lossless data that was sourced from 20 bit native endian signed integer data aligned high in 24 bits.

Available in Mac OS X v10.3 and later.
kAppleLosslessFormatFlag_24BitSourceData

Set for Apple Lossless data that was sourced from 24 bit native endian signed integer data.

Available in Mac OS X v10.3 and later.
kAppleLosslessFormatFlag_32BitSourceData

Set for Apple Lossless data that was sourced from 32 bit native endian signed integer data.

Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/

enum
{
   kAudioFormatFlagIsFloat                     = (1L << 0),
   kAudioFormatFlagIsBigEndian                 = (1L << 1),
   kAudioFormatFlagIsSignedInteger             = (1L << 2),
   kAudioFormatFlagIsPacked                    = (1L << 3),
   kAudioFormatFlagIsAlignedHigh               = (1L << 4),
   kAudioFormatFlagIsNonInterleaved            = (1L << 5),
   kAudioFormatFlagIsNonMixable                = (1L << 6),
   kAudioFormatFlagsAreAllClear                = (1L << 31),
   kLinearPCMFormatFlagIsFloat                 = kAudioFormatFlagIsFloat,
   kLinearPCMFormatFlagIsBigEndian             = kAudioFormatFlagIsBigEndian,
   //kLinearPCMFormatFlagIsSignedInteger         = kAudioFormatFlagIsSignedInteger,
   //kLinearPCMFormatFlagIsPacked                = kAudioFormatFlagIsPacked,
   kLinearPCMFormatFlagIsAlignedHigh           = kAudioFormatFlagIsAlignedHigh,
   kLinearPCMFormatFlagIsNonInterleaved        = kAudioFormatFlagIsNonInterleaved,
   kLinearPCMFormatFlagIsNonMixable            = kAudioFormatFlagIsNonMixable,
   kLinearPCMFormatFlagsAreAllClear            = kAudioFormatFlagsAreAllClear,
   kAppleLosslessFormatFlag_16BitSourceData    = 1,
   kAppleLosslessFormatFlag_20BitSourceData    = 2,
   kAppleLosslessFormatFlag_24BitSourceData    = 3,
   kAppleLosslessFormatFlag_32BitSourceData    = 4
};
 #define kLinearPCMFormatFlagIsSignedInteger         kAudioFormatFlagIsSignedInteger
   #define kLinearPCMFormatFlagIsPacked                kAudioFormatFlagIsPacked


/*AudioChannelLayoutTag_GetNumberOfChannels

A macro to get the number of channels from an audio channel layout tag (AudioChannelLayoutTag data type).

#define AudioChannelLayoutTag_GetNumberOfChannels(layoutTag) ((UInt32)((layoutTag) & 0x0000FFFF))
Parameters
layoutTag

The audio channel layout tag to examine.
Return Value

The number of channels the tag indicates.
Discussion

The low 16 bits of an audio channel layout tag gives the number of channels, unless the layout tag is kAudioChannelLayoutTag_UseChannelDescriptions or kAudioChannelLayoutTag_UseChannelBitmap, which specify other ways of defining the layout.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CoreAudioTypes.h*/
#define AudioChannelLayoutTag_GetNumberOfChannels(layoutTag) ((UInt32)((layoutTag) & 0x0000FFFF))

/*AudioStreamBasicDescription Flag Combinations Constants

Some commonly used combinations of flags for AudioStreamBasicDescription structures.

enum
{
#if TARGET_RT_BIG_ENDIAN
   kAudioFormatFlagsNativeEndian       = kAudioFormatFlagIsBigEndian,
#else
   kAudioFormatFlagsNativeEndian       = 0,
#endif
   kAudioFormatFlagsNativeFloatPacked  = kAudioFormatFlagIsFloat |
   kAudioFormatFlagsNativeEndian | kAudioFormatFlagIsPacked
};
Constants
kAudioFormatFlagsNativeEndian

Defined to set or clear kAudioFormatFlagIsBigEndian depending on the endianness of the processor at build time.

Available in Mac OS X v10.2 and later.
kAudioFormatFlagsNativeFloatPacked

The flags for the canonical format of fully packed, native endian floating point data.

Available in Mac OS X v10.2 and later.
Declared In
CoreAudioTypes.h*/
enum
{
#if TARGET_RT_BIG_ENDIAN
   kAudioFormatFlagsNativeEndian       = kAudioFormatFlagIsBigEndian,
#else
   kAudioFormatFlagsNativeEndian       = 0,
#endif
   kAudioFormatFlagsNativeFloatPacked  = kAudioFormatFlagIsFloat |
   kAudioFormatFlagsNativeEndian | kAudioFormatFlagIsPacked
};


#ifdef __cplusplus
}
#endif
#endif