
#ifndef DRCOREOBJECT_H
#define DRCOREOBJECT_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef __AVAILABILITYMACROS__
#include <AvailabilityMacros.h>
#endif

#if defined(__cplusplus)
extern "C" {
#endif

/*DRRefConReleaseCallback


A callback used by a Disc Recording object to relinquish ownership of its refCon (reference context) data. 
typedef void (*DRRefConReleaseCallback)(
    const void *refCon);  
Discussion 

If you name your function MyDRRefConReleaseCallback, you would declare it like this: 

					void MyDRRefConReleaseCallback (void *refCon);*/
typedef void (*DRRefConReleaseCallback)(
    const void *refCon);  


/*DRRefConRetainCallback


A callback used by a Disc Recording object to obtain ownership of its refCon (reference context) data. 
typedef const void* (*DRRefConRetainCallback)(
    const void *refCon);  
Discussion 

If you name your function MyDRRefConRetainCallback, you would declare it like this: 

					void MyDRRefConRetainCallback (void *refCon);


This callback returns the value to store as the reference context for a Disc Recording object, typically the refCon parameter passed to the callback -- but your callback may return any value as the reference context.*/
typedef const void* (*DRRefConRetainCallback)(
    const void *refCon);  


/*DRTypeRef


An untyped, generic reference to any Disc Recording object. 
typedef CFTypeRef DRTypeRef;  
Discussion 

DRTypeRef is one of the base types defined in Disc Recording, used as a placeholder for parameter and return type in several polymorphic functions. It is a generic object reference that can take a reference to any other Disc Recording object.*/
typedef CFTypeRef DRTypeRef;  

/*DRRefConCallbacks


Contains a set of callbacks for use by a Disc Recording object in managing its reference context. 
struct DRRefConCallbacks { 
    unsigned long version; 
    DRRefConRetainCallback retain; 
    DRRefConReleaseCallback release; 
};  
Fields
version
The version of this structure. The value must be a known version, or zero.
retain
An optional callback used by a Disc Recording object to retain its reference context. When NULL, the Disc Recording object will not retain the reference context when set.
release
An optional callback used by a Disc Recording object to remove a retain previously added for its reference context. When NULL, the Disc Recording objecting will not release its reference context when the object is destroyed or when a new reference context value is set.*/
struct DRRefConCallbacks { 
    unsigned long version; 
    DRRefConRetainCallback retain; 
    DRRefConReleaseCallback release; 
};  
typedef  struct DRRefConCallbacks DRRefConCallbacks;

//functions

/*DRSetRefCon


Sets the Disc Recording object's reference context value. 
extern void DRSetRefCon(
    DRTypeRef ref,
    void*refCon,
    const DRRefConCallbacks*callbacks) ;  
Parameters
ref
A generic reference to any Disc Recording object whose reference context you want to set.
refCon
The reference context value to set for the Disc Recording object. If the the Disc Recording object's reference context is not NULL when a new value is set, the previous refCon value will be released using the release callback previously set, if any. The new refCon value will be retained by the Disc Recording object using the retain callback previously set, if any. 

You may pass a value of NULL, which results in the Disc Recording object having no value in its reference context.
callbacks
A pointer to a DRRefConCallbacks structure initialized with the callbacks for the Disc Recording object to use on its reference context. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in, or can be reused for multiple object references. 

If the structure's version field does not contain a known value, this function's behavior is undefined. The retain field may be NULL, in which case the Disc Recording object will not retain the reference context when set. The release field may also be NULL, in which case the Disc Recording object will not release its reference context when the object is destroyed or when a new reference context value is set. 

If this parameter itself is NULL, this function behaves as if a valid structure of version 0 and with all fields NULL had been passed in. 

If any of the callback structure's fields are not valid pointers to functions of the correct type, or if this parameter is not a valid pointer to a DRRefConCallbacks callbacks structure, this function's behavior is undefined.
Availability
Introduced in Mac OS X v10.2*/
extern void DRSetRefCon(
    DRTypeRef ref,
    void*refCon,
    const DRRefConCallbacks*callbacks) ;  

/*DRGetRefCon


Gets the Disc Recording object's reference context value. 
extern void* DRGetRefCon(
    DRTypeRef ref) ;  
Parameters
ref
A generic reference to any Disc Recording object whose refCon value you want to get.
Return Value

The value currently stored in the Disc Recording object's reference context. 
Availability
Introduced in Mac OS X v10.2*/
extern void* DRGetRefCon(
    DRTypeRef ref) ;  


#if defined(__cplusplus)
}
#endif

#endif	