
#ifndef DISKARBITRATION_DASESSION_H
#define DISKARBITRATION_DASESSION_H

#include <CoreFoundation/CoreFoundation.h>

#ifdef __cplusplus
extern "C" {
#endif

/*DASessionRef

typedef struct __DASession * DASessionRef;  
Discussion 

Type of a reference to DASession instances.*/

typedef struct __DASession * DASessionRef;  

//func


/*DASessionUnscheduleFromRunLoop


Unschedules the session from a run loop. 
extern void DASessionUnscheduleFromRunLoop(
    DASessionRef session,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode );  
Parameters
session
The session which is being unscheduled.
runLoop
The run loop on which the session is scheduled.
runLoopMode
The run loop mode in which the session is scheduled.*/
extern void DASessionUnscheduleFromRunLoop(
    DASessionRef session,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode );  

/*DASessionScheduleWithRunLoop


Schedules the session on a run loop. 
extern void DASessionScheduleWithRunLoop(
    DASessionRef session,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode );  
Parameters
session
The session which is being scheduled.
runLoop
The run loop on which the session should be scheduled.
runLoopMode
The run loop mode in which the session should be scheduled.*/
extern void DASessionScheduleWithRunLoop(
    DASessionRef session,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode );  

/*DASessionCreate


Creates a new session. 
extern DASessionRef DASessionCreate(
    CFAllocatorRef allocator );  
Return Value

A reference to a new DASession. 
Discussion 

The caller of this function receives a reference to the returned object. The caller also implicitly retains the object and is responsible for releasing it.*/
extern DASessionRef DASessionCreate(
    CFAllocatorRef allocator ); 

#ifdef __cplusplus
}
#endif 

#endif 
