
#import <Foundation/NSObject.h>
#import <ApplicationServices/ApplicationServices.h>

@class NSAppleEventDescriptor;

@interface NSAppleEventManager : NSObject

/*sharedAppleEventManager

Returns the single instance of NSAppleEventManager, creating it first if it doesn’t exist.

+ (NSAppleEventManager *)sharedAppleEventManager
Availability
Available in Mac OS X v10.0 and later.*/
+ (NSAppleEventManager *)sharedAppleEventManager;

/*currentReplyAppleEvent

Returns the corresponding reply event descriptor if an Apple event is being handled on the current thread.

- (NSAppleEventDescriptor *)currentReplyAppleEvent
Discussion

An Apple event is being handled on the current thread if currentAppleEvent does not return nil. Returns nil otherwise. This descriptor, including any mutations, will be returned to the sender of the current event when all handling of the event has been completed, if the sender has requested a reply. The effects of retaining the descriptor are undefined; it may be copied, but mutations of the copy are not returned to the sender of the current event.
Availability
Available in Mac OS X v10.3 and later.
See Also
– setCurrentAppleEventAndReplyEventWithSuspensionID:*/
- (NSAppleEventDescriptor *)currentReplyAppleEvent;

/*setEventHandler:andSelector:forEventClass:andEventID:

Registers the Apple event handler specified by handler for the event specified by eventClass and eventID.

- (void)setEventHandler:(id)handler andSelector:(SEL)handleEventSelector forEventClass:(AEEventClass)eventClass andEventID:(AEEventID)eventID
Discussion

If an event handler is already registered for the specified event class and event ID, removes it. The signature for handler should match the following:- (void)handleAppleEvent:(NSAppleEventDescriptor *)event withReplyEvent: (NSAppleEventDescriptor *)replyEvent;

Availability
Available in Mac OS X v10.0 and later.
See Also
– removeEventHandlerForEventClass:andEventID:*/

- (void)setEventHandler:(id)handler andSelector:(SEL)handleEventSelector forEventClass:(AEEventClass)eventClass andEventID:(AEEventID)eventID;


@end
