#ifndef _IOSTORAGE_H
#define _IOSTORAGE_H

#include <IOKit/IOTypes.h>
#include <APPLE/IOKit/storage/IOStorage.h>


#ifdef __cplusplus

#include <IOKit/assert.h>
#include <IOKit/IOMemoryDescriptor.h>
#include <IOKit/IOService.h>


/*IOStorageCompletionAction

typedef void (*IOStorageCompletionAction)(
    void *target, 
    void *parameter, 
    IOReturn status, 
    UInt64 actualByteCount);  
Parameters
target
Opaque client-supplied pointer (or an instance pointer for a C++ callback).
parameter
Opaque client-supplied pointer.
status
Status of the data transfer.
actualByteCount
Actual number of bytes transferred in the data transfer.
Discussion 

The IOStorageCompletionAction declaration describes the C (or C++) completion routine that is called once an asynchronous storage operation completes.*/
typedef void (*IOStorageCompletionAction)(
    void *target, 
    void *parameter, 
    IOReturn status, 
    UInt64 actualByteCount);  


/*StorageCompletion

struct IOStorageCompletion { 
    void *target; 
    IOStorageCompletionAction action; 
    void *parameter; 
};  
Fields
target
Opaque client-supplied pointer (or an instance pointer for a C++ callback).
action
Completion routine to call on completion of the data transfer.
parameter
Opaque client-supplied pointer.
Discussion 

The IOStorageCompletion structure describes the C (or C++) completion routine that is called once an asynchronous storage operation completes. The values passed for the target and parameter fields will be passed to the routine when it is called*/
struct IOStorageCompletion { 
    void *target; 
    IOStorageCompletionAction action; 
    void *parameter; 
};  

class IOStorage : public IOService
{
OSDeclareAbstractStructors(IOStorage);

public:
/*open

public

virtual bool open(
    IOService *client, 
    IOOptionBits options, 
    IOStorageAccess access); 
Parameters
client
Client requesting the open.
options
Options for the open. Set to zero.
access
Access level for the open. Set to kIOStorageAccessReader or kIOStorageAccessReaderWriter.
Return Value

Returns true if the open was successful, false otherwise. 
Discussion 

Ask the storage object for permission to access its contents; the method is equivalent to IOService::open(), but with the correct parameter types.
This method may also be invoked to upgrade or downgrade the access of an existing open (if it fails, the existing open prevails).*/
virtual bool open(
    IOService *client, 
    IOOptionBits options, 
    IOStorageAccess access);

};



#endif 
#endif
