#ifndef USB_H
#define USB_H

#if KERNEL
#include <libkern/OSByteOrder.h>
#include <IOKit/IOMemoryDescriptor.h>
#else
#include <architecture/byte_order.h>
#endif

#include <IOKit/IOTypes.h>

#if !defined(__USB_)
#    include <IOKit/usb/USBSpec.h>
#endif

#include <APPLE/IOKit/usb/USB.h>

#ifdef __cplusplus
extern "C" {
#endif

/*IOOptionBits

enum { 
    kIOUSBInterfaceOpenAlt = 0x00010000 
};  
Constants
kIOUSBInterfaceOpenAlt
Open the alternate interface specified when creating the interface.
Discussion 

Parameter passed to an IOService::open() call.*/
enum { 
    kIOUSBInterfaceOpenAlt = 0x00010000 
};  

/*USBDevRequest

typedef struct { 
    UInt8 bmRequestType; 
    UInt8 bRequest; 
    UInt16 wValue; 
    UInt16 wIndex; 
    UInt16 wLength; 
    void *pData; 
    UInt32 wLenDone; 
} IOUSBDevRequest;  
Fields
bmRequestType
An encoded value that contains the direction, type, and recipient of the request. Use the USBmakebmRequestType macro to encode this field.
bRequest
Request code
wValue
16 bit parameter for request, host endianess
wIndex
16 bit parameter for request, host endianess
wLength
Length of data part of request, 16 bits, host endianess
pData
Pointer to data for request - data returned in bus endianess
wLenDone
Set by standard completion routine to number of data bytes actually transferred
Discussion 

Parameter block for control requests, using a simple pointer for the data to be transferred.*/
typedef struct { 
    UInt8 bmRequestType; 
    UInt8 bRequest; 
    UInt16 wValue; 
    UInt16 wIndex; 
    UInt16 wLength; 
    void *pData; 
    UInt32 wLenDone; 
} IOUSBDevRequest;  

/*IOUSBCompletionAction

typedef void (*IOUSBCompletionAction)( 
    void *target, 
    void *parameter, 
    IOReturn status, 
    UInt32 bufferSizeRemaining);  
Parameters
target
The target specified in the IOUSBCompletion struct.
parameter
The parameter specified in the IOUSBCompletion struct.
status
Completion status.
bufferSizeRemaining
Bytes left to be transferred.
Discussion 

Function called when USB I/O completes.*/
typedef void (*IOUSBCompletionAction)( 
    void *target, 
    void *parameter, 
    IOReturn status, 
    UInt32 bufferSizeRemaining); 

/*IOUSBCompletion

typedef struct IOUSBCompletion { 
    void *target; 
    IOUSBCompletionAction action; 
    void *parameter; 
} IOUSBCompletion;  
Fields
target
The target to pass to the action function.
action
The function to call.
parameter
The parameter to pass to the action function.
Discussion 

Struct specifying action to perform when a USB I/O completes.*/
typedef struct IOUSBCompletion { 
    void *target; 
    IOUSBCompletionAction action; 
    void *parameter; 
} IOUSBCompletion; 

#ifdef __cplusplus
}
#endif

#endif