#ifndef CGIMAGESOURCE_H
#define CGIMAGESOURCE_H
#include <CoreGraphics/CoreGraphics.h>

/*Image Source Option Dictionary Keys

Define keys for the options dictionary used to create an image source.

CFStringRef kCGImageSourceTypeIdentifierHint;
CFStringRef kCGImageSourceShouldAllowFloat;
CFStringRef kCGImageSourceShouldCache;
CFStringRef kCGImageSourceShouldToneCompressFloat;
CFStringRef kCGImageSourceCreateThumbnailFromImageIfAbsent;
CFStringRef kCGImageSourceCreateThumbnailFromImageAlways;
CFStringRef kCGImageSourceThumbnailMaxPixelSize;
CFStringRef kCGImageSourceCreateThumbnailWithTransform
Constants
kCGImageSourceTypeIdentifierHint

Specifies the best guess of the uniform type identifier (UTI) for the format of the image source file. If specified, the value of this key must be a CFString object. This key can be provided in the options dictionary when you create a CGImageSource object.

Available in Mac OS X v10.4 and later.
kCGImageSourceShouldAllowFloat

Specifies whether the image should be returned as a CGImage object that uses floating-point values, if supported by the file format. CGImage objects that use extended-range floating-point values may require additional processing to render in a pleasing manner. The value of this key must be a CFBoolean value. The default value is kCFBooleanFalse.

Available in Mac OS X v10.4 and later.
kCGImageSourceShouldCache

Specifies whether the image should be cached in a decoded form. The value of this key must be a CFBoolean value. The default value is kCFBooleanTrue. This key can be provided in the options dictionary that you can pass to the functions CGImageSourceCopyPropertiesAtIndex and CGImageSourceCreateImageAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceShouldToneCompressFloat

Specifies whether the image should have tone compression applied if needed. With this option, an image that contains extended-range floating-point pixel samples is compressed into the standard range of 0 to 1. The value of this key must be a CFBoolean value. The default value is kCFBooleanFalse.
kCGImageSourceCreateThumbnailFromImageIfAbsent

Specifies whether a thumbnail should be automatically created for an image if a thumbnail isn't present in the image source file. The thumbnail is created from the full image, subject to the limit specified by kCGImageSourceThumbnailMaxPixelSize. If a maximum pixel size isn't specified, then the thumbnail is the size of the full image, which in most cases is not desirable. This key must be a CFBoolean value. The default value is kCFBooleanFalse. This key can be provided in the options dictionary that you pass to the function CGImageSourceCreateThumbnailAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceCreateThumbnailFromImageAlways

Specifies whether a thumbnail should be created from the full image even if a thumbnail is present in the image source file. The thumbnail is created from the full image, subject to the limit specified by kCGImageSourceThumbnailMaxPixelSize. If a maximum pixel size isn't specified, then the thumbnail is the size of the full image, which probably isn't what you want. This key must be a CFBoolean value. The default value is kCFBooleanFalse. This key can be provided in the options dictionary that you can pass to the function CGImageSourceCreateThumbnailAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceThumbnailMaxPixelSize

Specifies the maximum width and height in pixels of a thumbnail. If this key is not specified, the width and height of a thumbnail is not limited and thumbnails may be as big as the image itself. If present, this key must be a CFNumber value. This key can be provided in the options dictionary that you pass to the function CGImageSourceCreateThumbnailAtIndex.

Available in Mac OS X v10.4 and later.
kCGImageSourceCreateThumbnailWithTransform

Specifies whether the thumbnail should be rotated and scaled according to the orientation and pixel aspect ratio of the full image. The value of this key must be a CFBoolean value. The default value is kCFBooleanFalse.

Available in Mac OS X v10.4 and later.*/
extern const CFStringRef kCGImageSourceTypeIdentifierHint;
extern const CFStringRef kCGImageSourceShouldAllowFloat;
extern const CFStringRef kCGImageSourceShouldCache;
extern const CFStringRef kCGImageSourceShouldToneCompressFloat;
extern const CFStringRef kCGImageSourceCreateThumbnailFromImageIfAbsent;
extern const CFStringRef kCGImageSourceCreateThumbnailFromImageAlways;
extern const CFStringRef kCGImageSourceThumbnailMaxPixelSize;
extern const CFStringRef kCGImageSourceCreateThumbnailWithTransform;

/*Individual Image Properties

Defines properties that apply to an individual image in an image source.

CFStringRef kCGImagePropertyDPIHeight;
CFStringRef kCGImagePropertyDPIWidth;
CFStringRef kCGImagePropertyPixelWidth;
CFStringRef kCGImagePropertyPixelHeight;
CFStringRef kCGImagePropertyDepth;
CFStringRef kCGImagePropertyOrientation;
CFStringRef kCGImagePropertyIsFloat;
CFStringRef kCGImagePropertyIsIndexed;
CFStringRef kCGImagePropertyHasAlpha;
CFStringRef kCGImagePropertyColorModel;
CFStringRef kCGImagePropertyProfileName;
CFStringRef kCGImagePropertyCompressQuality;
Constants
kCGImagePropertyDPIHeight

The resolution, in dots per inch, in the x dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyDPIWidth

The resolution, in dots per inch, in the y dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPixelWidth

The number of pixels in the x dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyPixelHeight

The number of pixels in the y dimension. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyDepth

The number of bits in each color sample of each pixel. If present, this key is a CFNumber value.

Available in Mac OS X v10.4 and later.
kCGImagePropertyOrientation

The intended display orientation of the image. If present, this key is a CFNumber value with the same value as defined by the TIFF and Exif specifications. The value specifies where the origin (0,0) of the image is locates, as shown in Table 1. If not present, a value of 1 is assumed.
Table 1  
Value	
Location of the origin of the image

1	
Top, left 

2	
Top, right 

3	
Bottom, right 

4	
Bottom, left 

5	
Left, top 

6	
Right, top 

7	
Right, bottom 

8	
Left, bottom 


Available in Mac OS X v10.4 and later.
kCGImagePropertyIsFloat

Specifies whether or not the image contains floating-point pixel samples. The value of this key is kCFBooleanTrue if the image contains them.

Available in Mac OS X v10.4 and later.
kCGImagePropertyIsIndexed

Specifies whether or not the image contains indexed pixel samples (sometimes called paletted samples). The value of this key is kCFBooleanTrue if the image contains them.

Available in Mac OS X v10.4 and later.
kCGImagePropertyHasAlpha

Specifies whether or not the image has an alpha channel. The value of this key is kCFBooleanTrue if the image contains an alpha channel.

Available in Mac OS X v10.4 and later.
kCGImagePropertyColorModel

The color model of the image such as, "RGB", "CMYK", "Gray", or "Lab". The value of this key is CFStringRef.

Available in Mac OS X v10.4 and later.
kCGImagePropertyProfileName

The name of the optional ICC profile embedded in the image, if known. If present, the value of this key is a CFStringRef.

Available in Mac OS X v10.4 and later.
kCGImagePropertyCompressionQuality

The desired compression quality to use when writing to an image destination. If present, this key is a CFNumber value in the range 0.0 to 1.0.
Discussion

These properties can be returned by the function CGImageSourceCopyPropertiesAtIndex.*/
extern const CFStringRef kCGImagePropertyDPIHeight;
extern const CFStringRef kCGImagePropertyDPIWidth;
extern const CFStringRef kCGImagePropertyPixelWidth;
extern const CFStringRef kCGImagePropertyPixelHeight;
extern const CFStringRef kCGImagePropertyDepth;
extern const CFStringRef kCGImagePropertyOrientation;
extern const CFStringRef kCGImagePropertyIsFloat;
extern const CFStringRef kCGImagePropertyIsIndexed;
extern const CFStringRef kCGImagePropertyHasAlpha;
extern const CFStringRef kCGImagePropertyColorModel;
extern const CFStringRef kCGImagePropertyProfileName;
extern const CFStringRef kCGImagePropertyCompressQuality;


/*CGImageSourceRef

Defines an opaque type that represents a Quartz image source.

typedef struct CGImageSource *CGImageSourceRef;
Discussion

In Mac OS X v10.4 and later, CGImageSourceRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct CGImageSource *CGImageSourceRef;


//function

/*CGImageSourceCreateImageAtIndex

Creates a CGImage object for the image data associated with the specified index in an image source.

CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based. 
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

Returns a CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateImageAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);

/*CGImageSourceCopyPropertiesAtIndex

Returns the properties of the image at a specified location in an image source.

CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index of the image whose properties you want to obtain. The index is zero-based. 
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply.
Return Value

A dictionary that contains the properties associated with the image.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyPropertiesAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);

/*CGImageSourceCreateWithURL

Creates an image source that reads from a location specified by a URL.

CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
);
Parameters
url

The URL to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageSourceRef CGImageSourceCreateWithURL(
   CFURLRef url,
   CFDictionaryRef options
);

/*CGImageSourceCopyTypeIdentifiers

Returns an array of uniform type identifiers (UTIs) that are supported for Quartz image sources.

CFArrayRef CGImageSourceCopyTypeIdentifiers ();
Return Value

Returns an array of the UTIs that are supported for image sources.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFArrayRef CGImageSourceCopyTypeIdentifiers ();


/*CGImageSourceCreateWithData

Creates an image source that reads from a Core Foundation data object.

CGImageSourceRef CGImageSourceCreateWithData(
   CFDataRef data,
   CFDictionaryRef options
);
Parameters
data

The data object to read from.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A Quartz image source. You are responsible for releasing this object using CFRelease.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/

CGImageSourceRef CGImageSourceCreateWithData(
   CFDataRef data,
   CFDictionaryRef options
);

/*CGImageSourceCreateThumbnailAtIndex

Creates a thumbnail image of the image located at a specified location in an image source.

CGImageRef CGImageSourceCreateThumbnailAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);
Parameters
isrc

An image source.
index

The index that specifies the location of the image. The index is zero-based.
options

A dictionary that specifies additional creation options. See Image Source Option Dictionary Keys for the keys you can supply.
Return Value

A CGImage object.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CGImageRef CGImageSourceCreateThumbnailAtIndex(
   CGImageSourceRef isrc,
   size_t index,
   CFDictionaryRef options
);

/*CGImageSourceGetType

Returns the uniform type identifier of the source container.

CFStringRef CGImageSourceGetType(
   CGImageSourceRef isrc
);
Parameters
isrc

An image source.
Return Value

The uniform type identifier of the image.
Discussion

The uniform type identifier (UTI) of the source container can be different from the type of the images in the container. For example, the .icns format supports embedded JPEG2000. The type of the source container is "com.apple.icns" but type of the images is JPEG2000.

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs. 
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/

CFStringRef CGImageSourceGetType(
   CGImageSourceRef isrc
);

/*CGImageSourceCopyProperties

Returns the properties of the image source.

CFDictionaryRef CGImageSourceCopyProperties (
   CGImageSourceRef isrc
   CFDictionaryRef options
);
Parameters
isrc

An image source.
options

A dictionary you can use to request additional options. See “Image Source Option Dictionary Keys” for the keys you can supply. 
Return Value

A dictionary that contains the properties associated with the image source container.
Discussion

These properties apply to the container in general but not necessarily to any individual image contained in the image source.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageSource.h*/
CFDictionaryRef CGImageSourceCopyProperties (
   CGImageSourceRef isrc,
   CFDictionaryRef options
);


#endif