#ifndef GLU_H
#define GLU_H

#include <OpenGL/gl.h>

#ifndef __glu_h__
#include <GL/glu.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*GLUORTHO2D(3G)                                                  GLUORTHO2D(3G)



NAME
       gluOrtho2D - define a 2D orthographic projection matrix


C SPECIFICATION
       void gluOrtho2D( GLdouble left,
                        GLdouble right,
                        GLdouble bottom,
                        GLdouble top )


PARAMETERS
       left, right Specify  the  coordinates  for  the left and right vertical
                   clipping planes.

       bottom, top Specify the coordinates for the bottom and  top  horizontal
                   clipping planes.

DESCRIPTION
       gluOrtho2D sets up a two-dimensional orthographic viewing region.  This
       is equivalent to calling glOrtho with near = -1 and far = 1.

SEE ALSO
       glOrtho, gluPerspective*/
  void gluOrtho2D( GLdouble left,
                        GLdouble right,
                        GLdouble bottom,
                        GLdouble top );

/*GLUERRORSTRING(3G)                                          GLUERRORSTRING(3G)



NAME
       gluErrorString - produce an error string from a GL or GLU error code


C SPECIFICATION
       const GLubyte * gluErrorString( GLenum error )


PARAMETERS
       error  Specifies a GL or GLU error code.

DESCRIPTION
       gluErrorString  produces  an  error string from a GL or GLU error code.
       The string is in ISO Latin  1  format.  For  example,  gluErrorString(-gluErrorString(GL_OUT_OF_MEMORY)
       GL_OUT_OF_MEMORY) returns the string out of memory.

       The  standard  GLU error codes are GLU_INVALID_ENUM, GLU_INVALID_VALUE,
       and GLU_OUT_OF_MEMORY.  Certain other GLU functions can return special-specialized
       ized  error codes through callbacks.  See the glGetError reference page
       for the list of GL error codes.

ERRORS
       NULL is returned if error is not a valid GL or GLU error code.

SEE ALSO
       glGetError, gluNurbsCallback, gluQuadricCallback, gluTessCallback



                                                            GLUERRORSTRING(3G)*/
       const GLubyte * gluErrorString( GLenum error );


/*GLUPERSPECTIVE(3G)                                          GLUPERSPECTIVE(3G)



NAME
       gluPerspective - set up a perspective projection matrix


C SPECIFICATION
       void gluPerspective( GLdouble fovy,
                            GLdouble aspect,
                            GLdouble zNear,
                            GLdouble zFar )


PARAMETERS
       fovy    Specifies  the field of view angle, in degrees, in the y direc-direction.
               tion.

       aspect  Specifies the aspect ratio that determines the field of view in
               the x direction.  The aspect ratio is the ratio of x (width) to
               y (height).

       zNear   Specifies the distance from the viewer  to  the  near  clipping
               plane (always positive).

       zFar    Specifies  the  distance  from  the  viewer to the far clipping
               plane (always positive).

DESCRIPTION
       gluPerspective specifies a viewing frustum into  the  world  coordinate
       system.   In  general,  the aspect ratio in gluPerspective should match
       the aspect ratio of the associated viewport. For example, aspect =  2.0
       means  the  viewer's angle of view is twice as wide in x as it is in y.
       If the viewport is twice as wide as it is tall, it displays  the  image
       without distortion.

       The  matrix  generated  by  gluPerspective  is multipled by the current
       matrix, just as if glMultMatrix were called with the generated  matrix.
       To  load  the perspective matrix onto the current matrix stack instead,
       precede the call to gluPerspective with a call to glLoadIdentity.

       Given f defined as follows:

                               f  = cotangent(fovy/2)

       The generated matrix is
             f
        ------------       0              0              0
           aspect


            0              f              0              0

                                      zFar+zNear    2*zFar*zNear
            0              0          ----------    -----------------------zNear-zFar
                                      zNear-zFar     zNear-zFar

            0              0              -1             0



NOTES
       Depth buffer precision is affected by the values  specified  for  zNear
       and  zFar.   The greater the ratio of zFar to zNear is, the less effec-effective
       tive the depth buffer will be at distinguishing between  surfaces  that
       are near each other.  If

                                   r = zFar/zNear


       roughly  log2(r)  bits  of  depth buffer precision are lost.  Because r
       approaches infinity as zNear approaches 0, zNear must never be  set  to
       0.

SEE ALSO
       glFrustum, glLoadIdentity, glMultMatrix, gluOrtho2D



                                                            GLUPERSPECTIVE(3G)*/
void gluPerspective( GLdouble fovy,
                              GLdouble aspect,
                            GLdouble zNear,
                            GLdouble zFar );

/*GLUCHECKEXTENSION(3G)                                    GLUCHECKEXTENSION(3G)



NAME
       gluCheckExtension - determines if an extension name is supported


C SPECIFICATION
       GLboolean gluCheckExtension( const GLubyte *extName,
                                    const GLubyte *extString )


PARAMETERS
       extName    Specifies an extension name.

       extString  Specifies  a  space-separated  list  of extension names sup-ported. supported.
                  ported.

DESCRIPTION
       gluCheckExtension returns GL_TRUE if  extName  is  supported  otherwise
       GL_FALSE is returned.

       This is used to check for the presence for OpenGL, GLU or GLX extension
       names  by  passing  the  extension  strings  returned  by  glGetString,
       gluGetString,  glXGetClientString,  glXQueryExtensionsString,  or  glX-QueryServerString, glXQueryServerString,
       QueryServerString, respectively, as extString.

NOTES
       Cases where one extension name is a substring of another are  correctly
       handled.

       There may or may not be leading or trailing blanks in extString.

       Extension names should not contain embedded spaces.

       All strings are null-terminated.

SEE ALSO
       glGetString,   gluGetString,   glXGetClientString,   glXQueryExtension-sString, glXQueryExtensionsString,
       sString, glXQueryServerString*/
    GLboolean gluCheckExtension( const GLubyte *extName,
                                    const GLubyte *extString );


/*GLULOOKAT(3G)                                                    GLULOOKAT(3G)



NAME
       gluLookAt - define a viewing transformation


C SPECIFICATION
       void gluLookAt( GLdouble eyeX,
                       GLdouble eyeY,
                       GLdouble eyeZ,
                       GLdouble centerX,
                       GLdouble centerY,
                       GLdouble centerZ,
                       GLdouble upX,
                       GLdouble upY,
                       GLdouble upZ )


PARAMETERS
       eyeX, eyeY, eyeZ
                       Specifies the position of the eye point.

       centerX, centerY, centerZ
                       Specifies the position of the reference point.

       upX, upY, upZ   Specifies the direction of the up vector.

DESCRIPTION
       gluLookAt  creates a viewing matrix derived from an eye point, a refer-ence reference
       ence point indicating the center of the scene, and an UP vector.

       The matrix maps the reference point to the negative z axis and the  eye
       point  to  the  origin.   When a typical projection matrix is used, the
       center of the scene therefore maps to the center of the viewport.  Sim-ilarly, Similarly,
       ilarly,  the  direction  described  by the UP vector projected onto the
       viewing plane is mapped to the positive y axis so that it points upward
       in  the  viewport.   The  UP vector must not be parallel to the line of
       sight from the eye point to the reference point.

       Let

            centerX - eyeX
        F = centerY - eyeY
            centerZ - eyeZ

       Let UP be the vector (upX, upY, upZ).

       Then normalize as follows: f = F/ || F ||

       UP' = UP/|| UP ||

       Finally, let s = f X UP', and u = s X f.

       M is then constructed as follows:

             s[0]    s[1]    s[2]    0
             u[0]    u[1]    u[2]   0
        M = -f[0]   -f[1]   -f[2]    0
              0       0       0      1

       and gluLookAt is equivalent to

       glMultMatrixf(M);

       glTranslated (-eyex, -eyey, -eyez);

SEE ALSO
       glFrustum, gluPerspective



                                                                 GLULOOKAT(3G)*/
       void gluLookAt( GLdouble eyeX,
                       GLdouble eyeY,
                       GLdouble eyeZ,
                       GLdouble centerX,
                       GLdouble centerY,
                       GLdouble centerZ,
                       GLdouble upX,
                       GLdouble upY,
                       GLdouble upZ );



#ifdef __cplusplus
}
#endif


#endif