#ifndef __SHUTDOWN__
#define __SHUTDOWN__

#ifndef  MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef  MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#include <APPLE/ShutDown.h>
#ifdef __cplusplus
extern "C" {
#endif

/*Data Types
typedef pascal void (*ShutDwnProcPtr)(void)*/
typedef pascal void (*ShutDwnProcPtr)(void);

/*Constants
/masks for ShutDwnInstall flags/
enum {
   sdOnPowerOff      = 1,  /call procedure before power off/
   sdOnRestart       = 2,  /call procedure before restart/
   sdRestartOrPower  = 3,  /call procedure before power off or restart/
   sdOnUnmount       = 4,  /call procedure before unmounting volumes/
   sdOnDrivers       = 8   /call procedure before checking for open /
};                         / drivers/

*/
enum {
   sdOnPowerOff      = 1,  /*call procedure before power off*/
   sdOnRestart       = 2,  /*call procedure before restart*/
   sdRestartOrPower  = 3,  /*call procedure before power off or restart*/
   sdOnUnmount       = 4,  /*call procedure before unmounting volumes*/
   sdOnDrivers       = 8   /*call procedure before checking for open */
};                         /* drivers*/

#include <APPLE/ShutDown_E.h>
//func

/*Installing or Removing a Shutdown Procedure
pascal void ShutDwnInstall(ShutDwnProcPtr shutDownProc, short flags);
pascal void ShutDwnRemove(ShutDwnProcPtr shutDownProc);*/
pascal void ShutDwnInstall(ShutDwnProcPtr shutDownProc, short flags);

#ifdef __cplusplus
}
#endif

#endif 
