#ifndef LIBKERN_LIBKERN_H
#define LIBKERN_LIBKERN_H

#include <sys/appleapiopts.h>
#include <stdint.h>
#include <string.h>
#include <sys/cdefs.h>
#include <sys/types.h>
#include <mach/vm_param.h>

#include <kern/locks.h>//hys

/*COPY(9)                  BSD Kernel Developer's Manual                 COPY(9)

NAME
     copy, copyin, copyout, copystr, copyinstr -- kernel copy functions

SYNOPSIS
     #include <sys/types.h>
     #include <sys/systm.h>

     int
     copyin(const void *uaddr, void *kaddr, size_t len);

     int
     copyout(const void *kaddr, void *uaddr, size_t len);

     int
     copystr(const void *kfaddr, void *kdaddr, size_t len, size_t *done);

     int
     copyinstr(const void *uaddr, void *kaddr, size_t len, size_t *done);

DESCRIPTION
     The copy functions are designed to copy contiguous data from one address
     to another.  All but copystr() copy data from user-space to kernel-space
     or vice-versa.

     The copy routines provide the following functionality:

     copyin()      Copies len bytes of data from the user-space address uaddr
                   to the kernel-space address kaddr.

     copyout()     Copies len bytes of data from the kernel-space address
                   kaddr to the user-space address uaddr.

     copystr()     Copies a NUL-terminated string, at most len bytes long,
                   from kernel-space address kfaddr to kernel-space address
                   kdaddr.  The number of bytes actually copied, including the
                   terminating NUL, is returned in *done.

     copyinstr()   Copies a NUL-terminated string, at most len bytes long,
                   from user-space address uaddr to kernel-space address
                   kaddr.  The number of bytes actually copied, including the
                   terminating NUL, is returned in *done.

RETURN VALUES
     The copy functions return 0 on success or EFAULT if a bad address is
     encountered.  In addition, the copystr(), and copyinstr() functions
     return ENAMETOOLONG if the string is longer than len bytes.

SEE ALSO
     fetch(9), store(9)

BSD                             January 7, 1996                            BSD*/
     int
     copyin(const void *uaddr, void *kaddr, size_t len);


#endif