#ifndef __KPI_INTERFACEFILTER__
#define __KPI_INTERFACEFILTER__
#include <sys/kernel_types.h>
#include <net/kpi_interface.h>

/*iff_output_func

typedef errno_t (*iff_output_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    mbuf_t *data);  
Parameters
cookie
The cookie specified when this filter was attached.
interface
The interface the packet is being transmitted on.
data
The outbound packet, may be changed.
Return Value

Return: 0 - The caller will continue with normal processing of the packet. EJUSTRETURN - The caller will stop processing the packet, the packet will not be freed. Anything Else - The caller will free the packet and stop processing. 
Discussion 

iff_output_func is used to filter fully formed outbound packets. The interface is only valid for the duration of the filter call. If you need to keep a reference to the interface, be sure to call ifnet_reference and ifnet_release.*/
typedef errno_t (*iff_output_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    mbuf_t *data);  


/*iff_input_func

typedef errno_t (*iff_input_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    mbuf_t *data,
    char **frame_ptr);  
Parameters
cookie
The cookie specified when this filter was attached.
interface
The interface the packet was received on.
protocol
The protocol of this packet. If you specified a protocol when attaching your filter, the protocol will only ever be the protocol you specified. By passing the protocol to your filter, you can supply the same function pointer to filters registered for different protocols and differetiate the protocol using this parameter.
data
The inbound packet, may be changed.
frame_ptr
A pointer to the pointer to the frame header. The frame header length can be found by inspecting the interface's frame header length (ifnet_hdrlen).
Return Value

Return: 0 - The caller will continue with normal processing of the packet. EJUSTRETURN - The caller will stop processing the packet, the packet will not be freed. Anything Else - The caller will free the packet and stop processing. 
Discussion 

iff_input_func is used to filter incoming packets. The interface is only valid for the duration of the filter call. If you need to keep a reference to the interface, be sure to call ifnet_reference and ifnet_release.*/
typedef errno_t (*iff_input_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    mbuf_t *data,
    char **frame_ptr);  

/*iff_event_func

typedef void (*iff_event_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    const struct kev_msg *event_msg);  
Parameters
cookie
The cookie specified when this filter was attached.
interface
The interface the packet is being transmitted on.
event_msg
The kernel event, may not be changed.
Discussion 

iff_event_func is used to filter interface specific events. The interface is only valid for the duration of the filter call. If you need to keep a reference to the interface, be sure to call ifnet_reference and ifnet_release.*/
typedef void (*iff_event_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    const struct kev_msg *event_msg);  

/*iff_ioctl_func

typedef errno_t (*iff_ioctl_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    u_long ioctl_cmd,
    void*ioctl_arg);  
Parameters
cookie
The cookie specified when this filter was attached.
interface
The interface the packet is being transmitted on.
ioctl_cmd
The ioctl command.
ioctl_arg
A pointer to the ioctl argument.
Return Value

Return: 0 - The caller will continue with normal processing of the packet. EOPNOTSUPP - This filter did not do anything special with the ioctl. You should return this unless your filter handled the ioctl itself. EJUSTRETURN - The caller will stop processing the packet, the packet will not be freed. Anything Else - The caller will free the packet and stop processing. 
Discussion 

iff_ioctl_func is used to filter ioctls sent to an interface. The interface is only valid for the duration of the filter call. If you need to keep a reference to the interface, be sure to call ifnet_reference and ifnet_release.*/
typedef errno_t (*iff_ioctl_func)(
    void*cookie,
    ifnet_t interface,
    protocol_family_t protocol, 
    u_long ioctl_cmd,
    void*ioctl_arg);  

/*iff_detached_func

typedef void (*iff_detached_func)(
    void*cookie,
    ifnet_t interface);  
Parameters
cookie
The cookie specified when this filter was attached.
interface
The interface this filter was detached from.
Discussion 

iff_detached_func is called to notify the filter that it has been detached from an interface. This is the last call to the filter that will be made. A filter may be detached if the interface is detached or the detach filter function is called. In the case that the interface is being detached, your filter's event function will be called with the interface detaching event before the your detached function will be called.*/
typedef void (*iff_detached_func)(
    void*cookie,
    ifnet_t interface);  

/*iff_filter

struct iff_filter { 
    void*iff_cookie; 
    const char*iff_name; 
    protocol_family_t iff_protocol; 
    iff_input_func iff_input; 
    iff_output_func iff_output; 
    iff_event_func iff_event; 
    iff_ioctl_func iff_ioctl; 
    iff_detached_func iff_detached; 
};  
Fields
iff_cookie
A kext defined cookie that will be passed to all filter functions.
iff_name
A filter name used for debugging purposes.
iff_protocol
The protocol of the packets this filter is interested in. If you specify zero, packets from all protocols will be passed to the filter.
iff_input
The filter function to handle inbound packets, may be NULL.
iff_output
The filter function to handle outbound packets, may be NULL.
iff_event
The filter function to handle interface events, may be null.
iff_ioctl
The filter function to handle interface ioctls, may be null.
iff_detached
The filter function used to notify the filter that it has been detached.
Discussion 

This structure is used to define an interface filter for use with the iflt_attach function.*/
struct iff_filter { 
    void*iff_cookie; 
    const char*iff_name; 
    protocol_family_t iff_protocol; 
    iff_input_func iff_input; 
    iff_output_func iff_output; 
    iff_event_func iff_event; 
    iff_ioctl_func iff_ioctl; 
    iff_detached_func iff_detached; 
};  
typedef  struct iff_filter iff_filter;

//function

/*iflt_detach

void iflt_detach(
    interface_filter_t filter_ref);  
Parameters
filter_ref
A reference to the filter as returned by iflt_attach.
Discussion 

Detaches an interface filter from an interface.*/
void iflt_detach(
    interface_filter_t filter_ref);  

/*iflt_attach

errno_t iflt_attach(
    ifnet_t interface,
    const struct iff_filter*filter, 
    interface_filter_t *filter_ref);  
Parameters
interface
The interface the filter should be attached to.
filter
A structure defining the filter.
filter_ref
A parameter through which a reference to the attached filter instance is returned.
Return Value

0 on success otherwise the errno error. 
Discussion 

Attaches an interface filter to an interface.*/
errno_t iflt_attach(
    ifnet_t interface,
    const struct iff_filter*filter, 
    interface_filter_t *filter_ref);  

#endif
