#include <CarbonCore/CarbonCore.h>
//work

/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (
   OSType selector,
   long * response
){};

/*NewGestaltValue

Installs a new Gestalt selector code and a value that Gestalt returns for that selector.

OSErr NewGestaltValue (
   OSType selector,
   long newValue
);
Parameters
selector

The selector code you want to add. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
newValue

The value to return for the new selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You call the function NewGestaltValue when the specified selector is not already installed and you don't want to override an existing value.

In Mac OS X, the new selector and value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr NewGestaltValue (
   OSType selector,
   long newValue
){};

/*ReplaceGestaltValue

Replaces the value that the function Gestalt returns for a specified selector code with the value provided to the function.

OSErr ReplaceGestaltValue (
   OSType selector,
   long replacementValue
);
Parameters
selector

The selector code you want to add. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
replacementValue

The replacement Gestalt value for the selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You use the function ReplaceGestaltValue to replace an existing value. You should not call this function to introduce a value that doesn't already exist; instead call the function NewGestaltValue.

In Mac OS X, the selector and replacement value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr ReplaceGestaltValue (
   OSType selector,
   long replacementValue
){};

/*SetGestaltValue

Sets the value the function Gestalt will return for a specified selector code, installing the selector if it was not already installed.

OSErr SetGestaltValue (
   OSType selector,
   long newValue
);
Parameters
selector

The selector code you want to set. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
newValue

The new Gestalt value for the selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You use SetGestaltValue to establish a value for a selector, without regard to whether the selector was already installed.

In Mac OS X, the selector and new value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr SetGestaltValue (
   OSType selector,
   long newValue
){};

/*DeleteGestaltValue

Deletes a Gestalt selector code so that it is no longer recognized by Gestalt.

OSErr DeleteGestaltValue (
   OSType selector
);
Parameters
selector

The selector code you want to delete. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

After calling this function, subsequent query or replacement calls for the selector code will fail as if the selector had never been installed. 

In Mac OS X, the selector is on a per-context basis. You cannot use this function to affect another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr DeleteGestaltValue (
   OSType selector
){};
